library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
	start : in std_logic;
	finished : out std_logic;
	tone : in std_logic;
    audio_request : out std_logic;  --    Audio controller request new data
    data : in unsigned(15 downto 0);
    counter_out: out unsigned (4 downto 0);
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;
    
    signal lrck_divider : unsigned(11 downto 0); 
    signal bclk_divider : unsigned(3 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
    
    signal shift_out : unsigned(15 downto 0);

    signal sin_out     : unsigned(15 downto 0);
    signal sin_counter : unsigned(11 downto 0); 
	signal backcounter : unsigned (4 downto 0);
	signal testCounter : unsigned (25 downto 0);
	
	signal endOfTone : unsigned (11 downto 0);
    signal sin_out1, sin_out0 : unsigned(15 downto 0);
	signal merged: unsigned (15 downto 0);
	signal switch : std_logic ; 
	signal thresh: unsigned (11 downto 0);
component musicRom is port (Clk: in std_logic;
addr : in unsigned(10 downto 0);
data : out unsigned(15 downto 0));
end component;

component musicRom1 is port (Clk: in std_logic;
addr : in unsigned(10 downto 0);
data : out unsigned(15 downto 0));
end component;


begin
  counter_out<=backcounter;
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz = 192 (X"C0")
    -- Left justify mode set by I2C controller
    
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then 
        lrck_divider <= (others => '0');
      elsif lrck_divider = thresh then--"100001000000"  then        -- "C0" minus 1
        lrck_divider <= "000000000000";
      else 
        lrck_divider <= lrck_divider + 1;
      end if;
    end if;   
  end process;

thresh <= "100001000000"  ;
	
  process (clk)
	begin
		if rising_edge (clk) then
			if sin_counter = "000000000000" then
				finished <= '0';
			elsif sin_counter = endOfTone then
				finished <= '1';
			end if;
		end if;
	end process;

  process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = X"B" or set_lrck = '1'  then  
        bclk_divider <= X"0";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;


   set_lrck <= '1' when lrck_divider = "100001000000" else '0'; 
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(3 downto 0) = "0101" else '0';
  clr_bclk <= '1' when bclk_divider(3 downto 0) = "1011" else '0';
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        bclk <= '0';
      elsif set_lrck = '1' or clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;



  -- Audio data shift output
  process (clk)
  begin
    if rising_edge(clk) then
		if switch = '0' and test_mode = '1' then
			merged <= sin_out;
		else
			merged <= data;
		end if;

      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif set_lrck = '1' then
        if test_mode = '1' then 
			shift_out <= merged;
        else 
          shift_out <= data;
        end if;
      elsif clr_bclk = '1' then 
        shift_out <= shift_out (14 downto 0) & '0';
      end if;
    end if;   
  end process;

    -- Audio outputs
    
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;          
    AUD_DACDAT   <= shift_out(15); 
    AUD_BCLK     <= bclk;          

    -- Self test with Sin wave
    
    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' or start = '0'then 
            sin_counter <= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then  
            sin_counter <= sin_counter + 1;
			switch <= not switch ;
          end if;
        end if;
    end process;

    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' then 
            backcounter<= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then  
            backcounter <= backcounter + 1;

        end if;
      end if;
    end process;

    process(clk)
    begin
      if rising_edge(clk) then
        lrck_lat <= lrck;
      end if;
    end process;

    process (clk) 
    begin
      if rising_edge(clk) then 
        if lrck_lat = '1' and lrck = '0' then
          audio_request <= '1';
        else 
          audio_request <= '0';
        end if;
      end if;
    end process;

v1: musicRom  port map (
		clk ,
		sin_counter (11 downto 1),
		sin_out0);		
v2: musicRom1  port map (
		clk ,
		sin_counter (11 downto 1),
		sin_out1);
		     
endOfTone <= "110110000000" when tone = '0' else
		     "101011100100" when tone = '1' else
		     "110110000000" ;

sin_out <= sin_out0 when tone = '0' else
		   sin_out1 when tone = '1' else
		   sin_out0;

end architecture;


