library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity datafeed is port (
	clk, reset_n , write , read, chipselect  : in std_logic;
	address: in unsigned (5 downto 0);
	writedata : in unsigned (15 downto 0);
	readdata: out unsigned (15 downto 0);
	request : out std_logic;
	AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
); 

end datafeed ;




architecture rtl of datafeed is 
component de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
	start : in std_logic;
	finished : out std_logic;
	tone : in std_logic;
    audio_request : out std_logic;  --    Audio controller request new data
    data : in unsigned(15 downto 0);
    counter_out: out unsigned (4 downto 0);
    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  component;
signal counter : unsigned (4 downto 0);
signal test_mode : std_logic:= '0';
signal tone : std_logic;
type buffer_type is array (0 to 31) of unsigned (15 downto 0);
signal buffer1 : buffer_type;
signal audio_request: std_logic;
signal data: unsigned (15 downto 0);
signal audio_clk : std_logic;
signal start : std_logic;
signal finished : std_Logic;
--signal AUD_ADCDAT, AUD_ADCLRCK, AUD_DACLRCK, AUD_DACDAT, AUD_BCLK : std_logic;
begin
v: de2_wm8731_audio port map (
	audio_clk,
	reset_n,
	test_mode,
	start ,
	finished ,
	tone ,
	audio_request,
	data,
	counter,
    AUD_ADCLRCK,
    AUD_ADCDAT  ,   --    Audio CODEC ADC Data
    AUD_DACLRCK  ,  --    Audio CODEC DAC LR Clock
    AUD_DACDAT ,   --    Audio CODEC DAC Data
    AUD_BCLK   --    Audio CODEC Bit-Stream Clock
);

  process (clk)
begin 
	if rising_edge (clk) then
		audio_clk <= not audio_clk;
	end if;
end process;

  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        request <= '0';
      else
        if counter = "11111" then
          request <= '1';
        elsif write = '1' and chipselect = '1' then
          request <= '0';  -- important to reset the irq
        end if;
      end if;
    end if;
  end process;

process (clk) begin
	if rising_edge (clk) then
		data <= buffer1(to_integer (counter));
	
		if chipselect = '1' and write = '1'  then
			if  address(5) = '1' then
				buffer1 (to_integer (address(4 downto 0))) <= writedata;
			elsif address = "000000" then
				tone <= writedata (0);
			elsif address = "000001" then
				start <= writedata (0);
			end if;
		end if;
	end if;
end process;

process (clk) begin
	if rising_edge (clk) then
		if chipselect = '1' and write = '1'  then
			if address = "000010" then
				test_mode <= '1';
			end if;
		elsif 	finished = '1' then
				test_mode <= '0';
		end if;
	end if;
end process;


end rtl;