// system.h has peripheral base addresses, IRQ definitions, and cpu details
#include "system.h"
// Next include has definition of alt_irq_register
#include "sys/alt_irq.h"
//The next two includes are in syslib/DeviceDrivers[sopc_builder]
//They have the macros for setting values in peripherals

#include "altera_avalon_pio_regs.h"
// Next include contains usleep(microseconds)
#include <unistd.h> //e.g. //usleep(5000000); is 5 seconds
#include <stdio.h>
#include "functions.h"
#include "altera_avalon_pio_regs.h"
#include <io.h>
#include "DM9000A.h"
#include "basic_io.h"
#include "functions.h"
#include "altera_avalon_uart_regs.h"
//#include "altera_avalon_irda_regs.h"

#define gridconst 0x12345678 

//DM9000
#define MAX_MSG_LENGTH 128
#define UDP_PACKET_PAYLOAD_OFFSET 42
#define UDP_PACKET_LENGTH_OFFSET 38
#define UDP_PACKET_PAYLOAD (transmit_buffer + UDP_PACKET_PAYLOAD_OFFSET)

#define STATE_INIT      0
#define STATE_CONNECTED 1
#define STATE_ME_START  2
#define STATE_HIM_START 3
#define STATE_START     4

// Ethernet MAC address.  Choose the last three bytes yourself
unsigned char mac_address[6] = { 0x01, 0x60, 0x6E, 0x11, 0x22, 0x33  };

unsigned int interrupt_number;

unsigned int receive_buffer_length;
unsigned char receive_buffer[1600];
unsigned int state = STATE_INIT;


char spcount1  , spcount2   , spcount3  , spcount4 ;   //space vars to calculate new positions. every block contains 4 units.
char spcount1_r, spcount2_r , spcount3_r, spcount4_r ; //right battle area vars
int score_lines = 0 ; //score
volatile int count = 0;
volatile int othermadeline ; 
    
    //keyboard
int edgeregister =  0 ; 
int previouscount = 0 ; 
int currentcount = 0 ; 
int w  , cgover;
    
char boardgrid[20][10]  , tempgrid[20][10]   , tempgrid1[20][10]   , tempgrid2[20][10] ;
char boardgrid_r[20][10], tempgrid_r[20][10] , tempgrid1_r[20][10] , tempgrid2_r[20][10];
int i , j ;
    
int gameover = 0 ;
int gameover_r = 0; 


//on the left
struct tetris_piece current_blk  , uu  , current_blk1  ;
//on the right
struct tetris_piece current_blk_r, uu_r, current_blk1_r;

//KB_CODE_TYPE decode_mode;

#define UDP_PACKET_PAYLOAD_OFFSET 42
#define UDP_PACKET_LENGTH_OFFSET 38

#define UDP_PACKET_PAYLOAD (transmit_buffer + UDP_PACKET_PAYLOAD_OFFSET)



unsigned char transmit_buffer[] = {
  // Ethernet MAC header
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Destination MAC address
  0x01, 0x60, 0x6E, 0x11, 0xE2, 0x0F, // Source MAC address
  0x08, 0x00,                         // Packet Type: 0x800 = IP
                          
  // IP Header
  0x45,                // version (IPv4), header length = 20 bytes
  0x00,                // differentiated services field
  0x00,0x9C,           // total length: 20 bytes for IP header +
                       // 8 bytes for UDP header + 128 bytes for payload
  0x00, 0x00,          // packet ID
  0x00,                // flags
  0x00,                // fragment offset
  0x01,                // time-to-live
  0x11,                // protocol: 11 = UDP
  0xb6,0x00,           // header checksum: incorrect
  0xc0,0xa8,0x01,0x01, // source IP address
  0xFF,0xFF,0xFF,0xFF, // destination IP address
                          
  // UDP Header
  0x67,0xd9, // source port port (26585: garbage)
  0x27,0x2b, // destination port (10027: garbage)
  0x00,0x88, // length (136: 8 for UDP header + 128 for data)
  0x00,0x00, // checksum: 0 = none
                          
  // UDP payload
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67
};   

static void ethernet_interrupt_handler() {
  unsigned int receive_status;
  int i;
  int sprite_num;
  int curMsgChar = 0;
  unsigned int packet_length;
  
  receive_status = ReceivePacket(receive_buffer, &receive_buffer_length);

  if (receive_status == DMFE_SUCCESS) {

/*#if 1
    printf("\n\nReceive Packet Length = %d", receive_buffer_length);
    for(i=0;i<receive_buffer_length;i++) {
      if (i%8==0) printf("\n");
      printf("0x%.2X,", receive_buffer[i]);
    }
    printf("\n");
#endif
*/


    if (receive_buffer_length >= 14) {
      //  A real Ethernet packet
      if (receive_buffer[12] == 8 && receive_buffer[13] == 0 &&
      receive_buffer_length >= 34) {
    // An IP packet
    if (receive_buffer[23] == 0x11) {
      // A UDP packet
      if (receive_buffer_length >= UDP_PACKET_PAYLOAD_OFFSET) {
        
        //*********************** Player 2 Logic ***********************
        //  printf("%s\n",receive_buffer+UDP_PACKET_PAYLOAD_OFFSET);
         
          if((state == STATE_INIT ) &&(receive_buffer[42]=='z')&&(receive_buffer[43]=='z')) {
            
              printf("  Connection Verified! Game Ready!\n"); state=STATE_CONNECTED; 
              
              for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
              UDP_PACKET_PAYLOAD[curMsgChar] = 0;
               }
         //"zz" is the signal for connection verification
         
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
          packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
                }  
         
         //game start signal
         else  if((state == STATE_CONNECTED)&&(receive_buffer[42]=='z')&&(receive_buffer[43]=='s'))
           {
              
              state = STATE_HIM_START;
              printf("  Player 2 is Ready!Pleas press 'enter' to start game!\n");
                       
           }
        else  if((state == STATE_ME_START)&&(receive_buffer[42]=='z')&&(receive_buffer[43]=='s'))
           {
              
              state = STATE_START;
              printf("  Game Starts!\n");
                       
           }
          else if (receive_buffer[42]=='a') 
          { 
            sprite_num = receive_buffer[43]; 
       //     printf("                                                                       received :%d\n",sprite_num);
            
            current_blk_r.c1.x = piecessprites_r[sprite_num][0] ;
            current_blk_r.c1.y = piecessprites_r[sprite_num][1] ;
            current_blk_r.c2.x = piecessprites_r[sprite_num][2] ;
            current_blk_r.c2.y = piecessprites_r[sprite_num][3] ;
            current_blk_r.c3.x = piecessprites_r[sprite_num][4] ;
            current_blk_r.c3.y = piecessprites_r[sprite_num][5] ;
            current_blk_r.c4.x = piecessprites_r[sprite_num][6] ;
            current_blk_r.c4.y = piecessprites_r[sprite_num][7] ;
            current_blk_r.type = piecessprites_r[sprite_num][8] ;
            current_blk_r.state =piecessprites_r[sprite_num][9] ;
            current_blk_r.color =piecessprites_r[sprite_num][10] ;
            
            
             }
          else if ((receive_buffer[42]=='e')&&(receive_buffer[43]=='q')) 
          {
            current_blk1_r = current_blk_r;
          
             }
          else if ((receive_buffer[42]=='e')&&(receive_buffer[43]=='r')) 
          {
            current_blk_r = current_blk1_r;
          
             }
          else if (receive_buffer[42]=='b') 
          { 
            sprite_num = receive_buffer[43]; 
       //     printf("                                                                       received :%d\n",sprite_num);
            
            current_blk1_r.c1.x = piecessprites_r[sprite_num][0] ;
            current_blk1_r.c1.y = piecessprites_r[sprite_num][1] ;
            current_blk1_r.c2.x = piecessprites_r[sprite_num][2] ;
            current_blk1_r.c2.y = piecessprites_r[sprite_num][3] ;
            current_blk1_r.c3.x = piecessprites_r[sprite_num][4] ;
            current_blk1_r.c3.y = piecessprites_r[sprite_num][5] ;
            current_blk1_r.c4.x = piecessprites_r[sprite_num][6] ;
            current_blk1_r.c4.y = piecessprites_r[sprite_num][7] ;
            current_blk1_r.type = piecessprites_r[sprite_num][8] ;
            current_blk1_r.state =piecessprites_r[sprite_num][9] ;
            current_blk1_r.color =piecessprites_r[sprite_num][10] ;
            
            
             }
          else if ((receive_buffer[42]=='z')&&(receive_buffer[43]=='a')) 
          {
            draw(current_blk_r);         
             }
          else if ((receive_buffer[42]=='z')&&(receive_buffer[43]=='p')) 
          {

            uu_r.c1.x = receive_buffer[44]+360;   //+320 because we should display the origin block into the right battle field
            uu_r.c1.y = receive_buffer[45];
            uu_r.c2.x = receive_buffer[46]+360;
            uu_r.c2.y = receive_buffer[47];
            uu_r.c3.x = receive_buffer[48]+360;
            uu_r.c3.y = receive_buffer[49];
            uu_r.c4.x = receive_buffer[50]+360;
            uu_r.c4.y = receive_buffer[51];
            uu_r.type  = receive_buffer[52];
            uu_r.state = receive_buffer[53];
            uu_r.color = receive_buffer[54];

            
            drawpiece_tnext(current_blk_r , uu_r) ;
            delay2();
            uu_r = current_blk_  r;
          
             }  
          
          
          
        
      }
    } else {
      printf("Received non-UDP packet\n");
    }
      } else {
    printf("Received non-IP packet\n");
      }
    } else {
      printf("Malformed Ethernet packet\n");
    }

  } else {
    printf("Error receiving packet\n");
  }

  /* Display the number of interrupts on the LEDs */
  interrupt_number++;
 // outport(SEG7_DISPLAY_BASE, interrupt_number);

  /* Clear the DM9000A ISR: PRS, PTS, ROS, ROOS 4 bits, by RW/C1 */
  dm9000a_iow(ISR, 0x3F);
              
  /* Re-enable DM9000A interrupts */
  dm9000a_iow(IMR, INTR_set);
}



int main(void)
{   
   

    //set flag to hide beginning screen
 //   IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0xff);
    
    
    //UDP packet
    int curMsgChar = 0;
    unsigned int packet_length;
    state = STATE_INIT;

    
    
    
    printf("\n================================================================================\n");
    printf("*                  Welcome to Tetris v 1.0 ....                                *\n");
    printf("*                  Copy rights Open to All Human Beings                        *\n");
    printf("*                                                                Yunfan Dong   *\n");
    printf("================================================================================\n");
    
    //******************************Preparations **************************************
    
    (DM9000_init(mac_address))?printf("  DM9000A failed!\n"):printf("  DM9000A successfully initialized!\n");  
    printf("================================================================================\n");
    DM9000_init(mac_address); 
    interrupt_number = 0;
    alt_irq_register(DM9000A_IRQ, NULL, (void*)ethernet_interrupt_handler);
    IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x00);
    printf("  Waiting for connection....\n");   
    //*****shake hands before game start
    while (state == STATE_INIT){
          for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
          UDP_PACKET_PAYLOAD[curMsgChar] = 0;
          }
         //"zz" is the signal for connection verification
         
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
          packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS)
          usleep(1000000);
   //       printf("sengding %s",transmit_buffer+UDP_PACKET_PAYLOAD_OFFSET);
         // printf("               message sent! Sprite num:%d \n",random); 
     //   printf("  Waiting for connection....\n");   
    }
    
    
    printf("================================================================================\n");
  
  
     //initialize the grid 
    for (i = 0 ; i < 20 ; i++)         
    {
        for(j = 0 ; j < 10 ; j++)
        {
            boardgrid[i][j] = 0 ;
            tempgrid [i][j] = 0 ;
        }
    }
    
    for (i = 0 ; i < 20 ; i++)         
    {
        for(j = 0 ; j < 10 ; j++)
        {
            boardgrid_r[i][j] = 0 ;
            tempgrid_r [i][j] = 0 ;
        }
    }
   

    
    
    //printf("hello world \n") ;
    
    int random = rand() % 14  ; 
    

    //initialize a block on the left
    current_blk.c1.x = piecessprites[random][0] ;
    current_blk.c1.y = piecessprites[random][1] ;
    current_blk.c2.x = piecessprites[random][2] ;
    current_blk.c2.y = piecessprites[random][3] ;
    current_blk.c3.x = piecessprites[random][4] ;
    current_blk.c3.y = piecessprites[random][5] ;
    current_blk.c4.x = piecessprites[random][6] ;
    current_blk.c4.y = piecessprites[random][7] ;
    current_blk.type = piecessprites[random][8] ;
    current_blk.state =piecessprites[random][9] ;
    current_blk.color =piecessprites[random][10] ;
       
    //send [random] to the other terminal
    
     for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
        UDP_PACKET_PAYLOAD[curMsgChar] = 0;
      }
      
     UDP_PACKET_PAYLOAD[curMsgChar++] = 'a';
     UDP_PACKET_PAYLOAD[curMsgChar++] = random;
     UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
     packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
     transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
     transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
     if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
   //  printf("   Message Sent! Sprite num:%d \n",random); 
        
    
    
    current_blk1   = current_blk ;
    
    for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
          UDP_PACKET_PAYLOAD[curMsgChar] = 0;
          }
         
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'e';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'q';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
          packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
  //  current_blk1_r = current_blk_r;
   
   
   
     //*******************Preperations************************  only in sigle game
     //listen for key 'space or enter' to begin the game!




   
    printf("  Press ENTER to begin!\n");
 
    IOWR_ALTERA_AVALON_PIO_DATA(KEYCOUNTER_BASE,0x00);

   
   
    while(state!=STATE_START){
        
        IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x02);     
        usleep(1000000);
        IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x00);
        usleep(1000000);
        int cnt;
        
       
            
          edgeregister = IORD_ALTERA_AVALON_PIO_DATA(KEYBOARDSCANCODE_BASE);
          previouscount = currentcount ;         
          currentcount = IORD_ALTERA_AVALON_PIO_DATA(KEYCOUNTER_BASE);  
     //     printf("\ncurrent count:%d  0x%x ",currentcount,edgeregister);
          if(currentcount>previouscount){
               
                if((edgeregister == 0x29f029)||(edgeregister == 0x5af05a))  /// 'space' or 'enter'
                  {
                   for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
                                UDP_PACKET_PAYLOAD[curMsgChar] = 0;
                              }
         //"zz" is the signal for connection verification
         
                   UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
                   UDP_PACKET_PAYLOAD[curMsgChar++] = 's';
                   UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
                   packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
                   transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
                   transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
                   if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS) ;                                 
                   IOWR_ALTERA_AVALON_PIO_DATA(KEYCOUNTER_BASE,0);                   
                   if(state == STATE_HIM_START) {
                    state = STATE_START;printf("  Game Starts!\n");
                    }
                   else  {
                            state = STATE_ME_START;
                            printf("  Player 2 hasn't started,please wait before Player 2 press start!\n");                             
                       }  
                                   
                } 
          }   
                

                  
            
        
        }
    
 
    printf("================================================================================\n");
    
    
    
    
    printf("****************************************\n Initializing Screen ......\n****************************************\nlog:\n\n");
//   IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x01);
   IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x05); 
   IOWR_ALTERA_AVALON_PIO_DATA(SCOREOFPLAYER_BASE,0);
   initializescreen();
   
   
   //******************************************************************************************
   //*********************************main loop ***********************************************
   
   while( ( gameover == 0 ) && ( gameover_r == 0 ) )  //no player has ended
   
     {
     for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
          UDP_PACKET_PAYLOAD[curMsgChar] = 0;
          }
         
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'e';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'r';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
          packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
          
         
    

    //assigning the initial piece
    current_blk   = current_blk1 ;
   // current_blk_r = current_blk1_r; 
    
    // generate new blk
    random = rand() % 14; 
    
    for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
        UDP_PACKET_PAYLOAD[curMsgChar] = 0;
      }
      
     UDP_PACKET_PAYLOAD[curMsgChar++] = 'b';
     UDP_PACKET_PAYLOAD[curMsgChar++] = random;
     UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
     packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
     transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
     transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
     if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
     
     
    current_blk1.c1.x = piecessprites[random][0] ;
    current_blk1.c1.y = piecessprites[random][1] ;
    current_blk1.c2.x = piecessprites[random][2] ;
    current_blk1.c2.y = piecessprites[random][3] ;
    current_blk1.c3.x = piecessprites[random][4] ;
    current_blk1.c3.y = piecessprites[random][5] ;
    current_blk1.c4.x = piecessprites[random][6] ;
    current_blk1.c4.y = piecessprites[random][7] ;
    current_blk1.type = piecessprites[random][8] ;
    current_blk1.state =piecessprites[random][9] ;
    current_blk1.color =piecessprites[random][10] ;
    
    /*
    current_blk1_r.c1.x = piecessprites_r[random][0] ;
    current_blk1_r.c1.y = piecessprites_r[random][1] ;
    current_blk1_r.c2.x = piecessprites_r[random][2] ;
    current_blk1_r.c2.y = piecessprites_r[random][3] ;
    current_blk1_r.c3.x = piecessprites_r[random][4] ;
    current_blk1_r.c3.y = piecessprites_r[random][5] ;
    current_blk1_r.c4.x = piecessprites_r[random][6] ;
    current_blk1_r.c4.y = piecessprites_r[random][7] ;
    current_blk1_r.type = piecessprites_r[random][8] ;
    current_blk1_r.state =piecessprites_r[random][9] ;
    current_blk1_r.color =piecessprites_r[random][10] ;
    */
    
    for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
          UDP_PACKET_PAYLOAD[curMsgChar] = 0;
          }
         
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 'a';
          UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
          packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
          transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
          if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
    
        
    draw(current_blk); 
  //draw(current_blk_r);
    
    //have to draw the next piece to come 
    //*****************************************
    
    clearnextpiecearea();
    drawnextpiece (current_blk1) ;
    
    char collision = 0;
    char collision_r = 0;
    
    //****************************************************************************
    //*****************************collision loop1*********************************
    //**** parallel thread for battle area 1
    while (collision != 1)
    {
        int response ;
        for(response = 0 ; response < 30 ; response++)
        {
            
            
      //********************************read key inputs*************************
            
        
        edgeregister = IORD_ALTERA_AVALON_PIO_DATA(KEYBOARDSCANCODE_BASE);
        previouscount = currentcount ;
        currentcount = IORD_ALTERA_AVALON_PIO_DATA(KEYCOUNTER_BASE);
        
        //resetting in case some keystroke got carried over
            if(response == 0)
            {
                currentcount = previouscount ; 
            }
       
       
      
        
        if(currentcount > previouscount)        //read the keyboard
            {
                //if 'enter' output current grids in console (for debugging)
                if(edgeregister == 0x5af05a)
                  {
                                                                                                  
                    printf("left grid\n");
                    for (i = 0 ; i < 20 ; i++)         
                     {
                       for(j = 0 ; j < 10 ; j++)
                         {
                            
                           printf("%d,", tempgrid [i][j] ) ;
                           if(j==9)printf("\n");
                          }
                     }
                    printf("\n\n");
                    printf("right grid\n");
                    for (i = 0 ; i < 20 ; i++)         
                     {
                       for(j = 0 ; j < 10 ; j++)
                         {
                           
                           printf("%d,", tempgrid_r [i][j] ) ;
                           if(j==9)printf("\n");
                          }
                     }

                  }
                  
                  //*********'left' key pressed 
                //uu is a temp block to store the result of temp movement,if no collision, then assign uu to current blk
                else if( edgeregister == 0xe0f06b )
                { 
                    uu  = moveleft(current_blk) ;                                       
                    printf("keycode: %x  -- 'left'\n" , edgeregister) ; 
                } 

                
                //*********'right' key pressed
               else if( edgeregister == 0xe0f074 )
                {
                    uu  = moveright(current_blk);                      
                    printf("keycode: %x  -- 'right'\n" , edgeregister) ; 
                }           
                //**********'up' key pressed
                else if( edgeregister == 0xe0f075 )
                {
                    uu  = rotate(current_blk);
                    printf("keycode: %x  -- 'up'(rotate)\n" , edgeregister) ; 
                }
                //***********'down' key pressed 
                else if( edgeregister == 0xe0f072 )
               {
                    uu = movedown(current_blk);
                    uu = movedown(uu) ;
                    printf("keycode: %x  -- 'down'\n" , edgeregister) ; 
               } 
               
               //************'spacebar' pressed
                 else if(edgeregister == 0x29f029)   
                {
                    printf("keycode: %x  -- 'space'(to bottom)\n" , edgeregister) ; 
                    
                   //move the piece down to the lowest possible grids
                   
                   //g1,g2,g2,g4 are relative positions in the grid, the grid is 10*20 , every grid capable of one blk
                   
                    struct coordinate g1  , g2  , g3  , g4 ; 
                    
                    g1 = coord_change(current_blk.c1);
                    g2 = coord_change(current_blk.c2);
                    g3 = coord_change(current_blk.c3);
                    g4 = coord_change(current_blk.c4);
                   
                    // keep track of how many grids we move down in order to calculate exact coordinates
                    
                    spcount1 = 0 ;   
                    spcount2 = 0 ;   
                    spcount3 = 0 ;  
                    spcount4 = 0 ;   
                    
                    // total height is 20
                    // x --- vertical   y --- horizontal
                    
                    while( (tempgrid[g1.x + 1][g1.y] != 1) && (g1.x < 19))
                    {
                        g1.x = g1.x + 1 ;
                        spcount1 = spcount1 + 1 ; 
                    }
                    
                    while( (tempgrid[g2.x + 1][g2.y] != 1) && (g2.x < 19))
                    {
                        g2.x = g2.x + 1 ;
                        spcount2 = spcount2 + 1 ; 
                    }
                    
                    while( (tempgrid[g3.x + 1][g3.y] != 1) && (g3.x < 19))
                    {
                        g3.x = g3.x + 1 ;
                        spcount3= spcount3 + 1 ; 
                    }
                    
                    while( (tempgrid[g4.x + 1][g4.y] != 1) && (g4.x < 19))
                    {
                        g4.x = g4.x + 1 ;
                        spcount4 = spcount4 + 1 ; 
                    }
                                                           
                    
                    //calculate how much the entity goes down
                    
                    char min_x_down_allowed ;
                     
                    min_x_down_allowed = spcount1 ;
                    
                    if (spcount2 < min_x_down_allowed) min_x_down_allowed = spcount2 ;
                    if (spcount3 < min_x_down_allowed) min_x_down_allowed = spcount3 ;
                    if (spcount4 < min_x_down_allowed) min_x_down_allowed = spcount4 ;
                                                                                               
                    uu = current_blk ; 
                    uu.c1.y = uu.c1.y  + 20 * min_x_down_allowed ; 
                    uu.c2.y = uu.c2.y  + 20 * min_x_down_allowed ; 
                    uu.c3.y = uu.c3.y  + 20 * min_x_down_allowed ; 
                    uu.c4.y = uu.c4.y  + 20 * min_x_down_allowed ; 
                   
                } 
                
                
                       
              
  
           // check whether the corrdinates needed to be filled are  occupied,if so, the move is illegal
           
                struct coordinate g1   , g2   , g3   , g4   ;   //coordinate is relative ordinate to the grid
                               
                g1 = coord_change(uu.c1);
                g2 = coord_change(uu.c2);
                g3 = coord_change(uu.c3);
                g4 = coord_change(uu.c4);
 
                              
                //*********check if grid already occupied
                
                //left
                if( (tempgrid[g1.x][g1.y] == 1) || (tempgrid[g2.x][g2.y] == 1) ||(tempgrid[g3.x][g3.y] == 1) 
                    || (tempgrid[g4.x][g4.y] == 1) )
                {
 
                    uu = current_blk ;
                }
                
                //now check if any of the coordinates are outside of boundaries
                else if( ((uu.c1.x < 50) || (uu.c2.x < 50) || (uu.c3.x < 50) || (uu.c4.x < 50))
                        || ((uu.c1.x > 230) || (uu.c2.x >230) || (uu.c3.x > 230) || (uu.c4.x > 230))  )
                {
                    
                    uu = current_blk ;
                }
                else if (((uu.c1.y < 50) || (uu.c2.y < 50) || (uu.c3.y < 50) || (uu.c4.y < 50))
                        || ((uu.c1.y > 430) || (uu.c2.y > 430) || (uu.c3.y > 430) || (uu.c4.y > 430)))
                {
                     //the piece might go outside the top and bottom edges
                    // printf("333333333333333333333\n") ;
                    uu = current_blk ;
                }
                else
                {
                     //  legal move here . draw blk on new place,clear old place first
                     
                      // send new position
                    for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
                     UDP_PACKET_PAYLOAD[curMsgChar] = 0;
                    }
         
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 'p';
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c1.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c1.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c2.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c2.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c3.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c3.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c4.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c4.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.type;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.state;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.color;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
                     packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
                     transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
                     transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
                     if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
                     
                     
                   
                    drawpiece_tnext(current_blk , uu) ;
                    current_blk = uu ; 
                }
                                                               
                      delay2();
                    

            } 
            
            
        }
                          
            //if there is a collision, set collision to 1,update the tempgrid bits
            //there is a collision if the grid bits are set at y below,or the lowest 
            //y is already the bottom
           
            //first check if the lowest y on the grid is already at the bottom 
            
            unsigned short int max_y ; 
            
            max_y   = current_blk.c1.y ; 
            
            if (current_blk.c2.y > max_y) max_y = current_blk.c2.y ; 
            if (current_blk.c3.y > max_y) max_y = current_blk.c3.y ; 
            if (current_blk.c4.y > max_y) max_y = current_blk.c4.y ;

           
           //**********************************************
           //****** see if there is a collision with anything on the grid
           int ymax1  , tempxcoord   , c1set   , c2set  , c3set   , c4set  ; 

           
           c1set =  0 ; 
           c2set =  0 ;
           c3set =  0 ;
           c4set =  0 ;
           
           struct coordinate yy1  , yyy1  ; 
           
           // c1 check
           
           //left area
           tempxcoord = current_blk.c1.x ; 
         
           ymax1  = current_blk.c1.y ; 
           if ( (current_blk.c2.y > ymax1) && (current_blk.c2.x == tempxcoord)) ymax1 = current_blk.c2.y ; 
           if ( (current_blk.c3.y > ymax1) && (current_blk.c3.x == tempxcoord)) ymax1 = current_blk.c3.y ; 
           if ( (current_blk.c4.y > ymax1) && (current_blk.c4.x == tempxcoord)) ymax1 = current_blk.c4.y ; 
           yy1.x = tempxcoord ; 
           yy1.y = ymax1 + 20 ; 
           yyy1  = coord_change(yy1) ;
           if( tempgrid[yyy1.x][yyy1.y] == 1) c1set = 1 ; 
                      
           //c2 check
           
           //left area
           tempxcoord = current_blk.c2.x ; 
           
           ymax1  = current_blk.c2.y ; 
           if ( (current_blk.c1.y > ymax1) && (current_blk.c1.x == tempxcoord)) ymax1 = current_blk.c1.y ; 
           if ( (current_blk.c3.y > ymax1) && (current_blk.c3.x == tempxcoord)) ymax1 = current_blk.c3.y ; 
           if ( (current_blk.c4.y > ymax1) && (current_blk.c4.x == tempxcoord)) ymax1 = current_blk.c4.y ; 
           yy1.x = tempxcoord ; 
           yy1.y = ymax1 + 20 ; 
           yyy1  = coord_change(yy1) ;
           if( tempgrid[yyy1.x][yyy1.y] == 1) c2set = 1 ; 

                     
           //c3 check
           
           //left
           tempxcoord = current_blk.c3.x ; 
           
           ymax1  = current_blk.c3.y ; 
           if ( (current_blk.c1.y > ymax1) && (current_blk.c1.x == tempxcoord)) ymax1 = current_blk.c1.y ; 
           if ( (current_blk.c2.y > ymax1) && (current_blk.c2.x == tempxcoord)) ymax1 = current_blk.c2.y ; 
           if ( (current_blk.c4.y > ymax1) && (current_blk.c4.x == tempxcoord)) ymax1 = current_blk.c4.y ; 
           yy1.x = tempxcoord ; 
           yy1.y = ymax1 + 20 ; 
           yyy1  = coord_change(yy1) ;
           if( tempgrid[yyy1.x][yyy1.y] == 1) c3set = 1 ; 
           
           
           //c4 check
           
           //left
           tempxcoord = current_blk.c4.x ; 
           
           ymax1  = current_blk.c4.y ; 
           if ( (current_blk.c1.y > ymax1) && (current_blk.c1.x == tempxcoord)) ymax1 = current_blk.c1.y ; 
           if ( (current_blk.c2.y > ymax1) && (current_blk.c2.x == tempxcoord)) ymax1 = current_blk.c2.y ; 
           if ( (current_blk.c3.y > ymax1) && (current_blk.c3.x == tempxcoord)) ymax1 = current_blk.c3.y ; 
           yy1.x = tempxcoord ; 
           yy1.y = ymax1 + 20 ; 
           yyy1  = coord_change(yy1) ;
           if( tempgrid[yyy1.x][yyy1.y] == 1) c4set = 1 ; 

           //*********check collision and update position        
           //left check
           if(max_y == 430)         //piece is at the bottom of the grid
           {
            //printf("at the bottom of the screen\n") ;
            //set the grid and update collision 
            collision = 1 ; 
            struct coordinate f1 , f2 , f3 , f4 ; 
                f1 = coord_change(current_blk.c1);
                f2 = coord_change(current_blk.c2);
                f3 = coord_change(current_blk.c3);
                f4 = coord_change(current_blk.c4);
                
                 ///update grid
                tempgrid[f1.x][f1.y] = 1 ; 
                tempgrid[f2.x][f2.y] = 1 ; 
                tempgrid[f3.x][f3.y] = 1 ; 
                tempgrid[f4.x][f4.y] = 1 ;     
           }
           else if((c4set + c3set + c2set + c1set) > 0 )        // touches blks already in the grid 
           {
            collision = 1 ; 
            struct coordinate f1 , f2 , f3 , f4 ; 
                f1 = coord_change(current_blk.c1);
                f2 = coord_change(current_blk.c2);
                f3 = coord_change(current_blk.c3);
                f4 = coord_change(current_blk.c4);
                tempgrid[f1.x][f1.y] = 1 ; 
                tempgrid[f2.x][f2.y] = 1 ; 
                tempgrid[f3.x][f3.y] = 1 ; 
                tempgrid[f4.x][f4.y] = 1 ;   
           }
           
           else  //if no collision move down and restart the collsion check loop
           {
            uu = movedown(current_blk);
            
            for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
                     UDP_PACKET_PAYLOAD[curMsgChar] = 0;
                    }
         
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 'z';
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 'p';
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c1.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c1.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c2.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c2.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c3.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c3.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c4.x;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.c4.y;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.type;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.state;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = uu.color;
                     UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
                     packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
                     transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
                     transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
                     if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1)==DMFE_SUCCESS);
                     
            drawpiece_tnext(current_blk , uu) ;
     //       printf("position updated!!");
     
           //speed control
            if(score_lines <3)
            delay1(); 
            else if (score_lines<6)
            delay11();
            
            else delay111();  

           }
        
            current_blk = uu ;       //update for  next iteration of the loop  

    }
     ///**************end of collision loop1******************** 
     
     





    //************************************************************
    //********** detect line fulfilment & update grid
    
   
    
    int r , c , t , sum; //vars
    
    r = 19 ; // x- paramter of new grid
    t = 0 ;  //record score  
 
    sum = 0 ;
    
    ///**********leftside*****************
    //traverse grid
    for (i = 19 ; i >= 0  ; i--)
    {
        for (j = 0 ; j < 10 ; j++)
        {
            sum = sum + tempgrid[i][j] ;
        }
        
        if(sum == 10) ///  fulfil
        {
        t = t + 1 ;  
        }
        
        else         //if not 
        {
        for (c = 0 ; c < 10 ; c++)
            {
            tempgrid1[r][c] = tempgrid[i][c] ;
            }
            r = r - 1 ;
        }
        sum = 0 ;
    }
   
   
    for (i = 0 ; i < t ; i++)
    {
        for(j = 0 ; j < 10 ; j++)
        {
        tempgrid1[i][j] = 0 ;
        }
    }
    
    

    
    
    /*
    
    ///**********right side*****************
    //traverse grid
    for (i = 19 ; i >= 0  ; i--)
    {
        for (j = 0 ; j < 10 ; j++)
        {
            sum = sum + tempgrid_r[i][j] ;
        }
        
        if(sum == 10) ///  fulfil
        {
        t = t + 1 ;  
        }
        
        else         //if not 
        {
        for (c = 0 ; c < 10 ; c++)
            {
            tempgrid1_r[r][c] = tempgrid_r[i][c] ;
            }
            r = r - 1 ;
        }
        sum = 0 ;
    }
   
   
    for (i = 0 ; i < t ; i++)
    {
        for(j = 0 ; j < 10 ; j++)
        {
          tempgrid1_r[i][j] = 0 ;
        }
    }
    
    
    */
    
    
    //******************************************************
    //*****************update the score*********************
    score_lines = score_lines + t ; 
    
    if(t!=0)printf("the score is updated to %d\n" , score_lines) ; 
    IOWR_ALTERA_AVALON_PIO_DATA(SCOREOFPLAYER_BASE,score_lines);
    if(score_lines >=3) IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x09);
    if(score_lines >=6) IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x0d);
 
 
 
    
   
  
  //****************************************************************************************
  //*******check  differences  between
  //*******the the boardgrid and the tempgrid1 and draw accordingly. Then update the 
  //*******board grid and the tempgrid arrays
   int d , s ; 
   for (d = 0 ; d < 20 ; d++)
   {
    for (s = 0 ; s < 10 ; s++)
    {
        if(tempgrid[d][s] == tempgrid1[d][s])
        {
            //do nothing
        }
        else
        {
            if(tempgrid[d][s] == 1)
            {
                createunit(20*s + 50 , 20*d + 50 , 0 );
                tempgrid[d][s] = 0 ;
            }
            else
            {
            //    createunit(20*s + 70 , 20*d + 50 , white );
                tempgrid[d][s] = 1 ;
            }
        }
    }
   }
   
    /* 
   for (d = 0 ; d < 20 ; d++)
   {
    for (s = 0 ; s < 10 ; s++)
    {
        if(tempgrid_r[d][s] == tempgrid1_r[d][s])
        {
            //do nothing
        }
        else
        {
            if(tempgrid_r[d][s] == 1)
            {
                createunit(20*s + 70 , 20*d + 50 , 0 );
                tempgrid_r[d][s] = 0 ;
            }
            else
            {
            //    createunit(20*s + 70 , 20*d + 50 , white );
                tempgrid_r[d][s] = 1 ;
            }
        }
    }
   }
   
   */
 
   
   
   //********************************************************************************
   //check if the top row of the gris is full and stop the loop. Basically game over
       cgover = 0 ;
       for (w = 0 ; w < 10 ; w++)
       {
        cgover = cgover + tempgrid[1][w] ;
       }
       if(cgover > 1 ) {
        gameover = 1 ; 
        printf("Hoops.... I'm full....");
        }
       
       
       
       
 
     } //this is the end of the second while loop
    
   // IOWR_ALTERA_AVALON_PIO_DATA(PIO_FLAG_BASE,0x00);
    finalmessage();
   
    
}



