//Slightly modified from the DE2 default design example
//
module	VGA_Controller(	//	Host Side
						iCursor_RGB_EN,
						iCursor_X,
						iCursor_Y,
						iCursor_R,
						iCursor_G,
						iCursor_B,
						iRed,
						iGreen,
						iBlue,
						iGameStage,
						oAddress,
						oCoord_X,
						oCoord_Y,
						//	VGA Side
						oVGA_R,
						oVGA_G,
						oVGA_B,
						oVGA_H_SYNC,
						oVGA_V_SYNC,
						oVGA_SYNC,
						oVGA_BLANK,
						oVGA_CLOCK,
						//	Control Signal
						iCLK,
						iRST_N,
						irow191817,
						irow161514,
						irow131211,
						irow1098,
						irow765,
						irow432,
						iscoreofplayer	);

`include "VGA_Param.h"

//	Host Side
output	reg	[19:0]	oAddress;
output	reg	[9:0]	oCoord_X;
output	reg	[9:0]	oCoord_Y;
input		[3:0]	iCursor_RGB_EN;
input		[9:0]	iCursor_X;
input		[9:0]	iCursor_Y;
input		[9:0]	iCursor_R;
input		[9:0]	iCursor_G;
input		[9:0]	iCursor_B;
input		[9:0]	iRed;
input		[9:0]	iGreen;
input		[9:0]	iBlue;
input    iGameStage;

//rowinputs
input       [29:0]  irow191817 ; 
input       [29:0]  irow161514 ; 
input       [29:0]  irow131211 ; 
input       [29:0]  irow1098 ; 
input       [29:0]  irow765 ; 
input       [29:0]  irow432 ; 
input       [15:0]  iscoreofplayer ;




//	VGA Side
output		[9:0]	oVGA_R;
output		[9:0]	oVGA_G;
output		[9:0]	oVGA_B;
output	reg			oVGA_H_SYNC;
output	reg			oVGA_V_SYNC;
output				oVGA_SYNC;
output				oVGA_BLANK;
output				oVGA_CLOCK;
//	Control Signal
input				iCLK;
input				iRST_N;

//	Internal Registers and Wires
reg		[9:0]		H_Cont;
reg		[9:0]		V_Cont;
reg		[9:0]		Cur_Color_R;
reg		[9:0]		Cur_Color_G;
reg		[9:0]		Cur_Color_B;
reg            gagestage;
wire				mCursor_EN;
wire				mRed_EN;
wire				mGreen_EN;
wire				mBlue_EN;

assign	oVGA_BLANK	=	oVGA_H_SYNC & oVGA_V_SYNC;
assign	oVGA_SYNC	=	1'b0;
assign	oVGA_CLOCK	=	iCLK;
assign	mCursor_EN	=	iCursor_RGB_EN[3];
assign	mRed_EN		=	iCursor_RGB_EN[2];
assign	mGreen_EN	=	iCursor_RGB_EN[1];
assign	mBlue_EN	=	iCursor_RGB_EN[0];
assign   gamestage = iGameStage;

assign	oVGA_R	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mRed_EN	?	Cur_Color_R	:	0)	:	0;
assign	oVGA_G	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mGreen_EN	?	Cur_Color_G	:	0)	:	0;
assign	oVGA_B	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mBlue_EN	?	Cur_Color_B	:	0)	:	0;


//my code
//digit logic calculation 
reg [6:0] digit1 , digit2, digit3 ;
wire [6:0] tdigit0 ,  tdigit1 , tdigit2 , tdigit3 , tdigit4 , tdigit5 , tdigit6 , tdigit7 , tdigit8 , tdigit9 ;
reg  [319:0]logo0[238:0];
reg  [319:0]logo1[238:0];
reg  [319:0]logo2[238:0];
reg  [319:0] logo_Row,logo_Row1,logo_Row2;

reg  [159:0] name [43:0];
reg  [159:0] name_Row;

reg  [199:0] title [29:0];
reg  [199:0] title_Row;

reg  [9:0]logo_V,logo_H,name_V,name_H,title_H,title_V;
reg  [9:0] logo_x, logo_y;
reg  [9:0] logo_tempx,logo_tempy;
reg  gameflag;


hexout u1(iscoreofplayer       , tdigit0) ; 
hexout u2(iscoreofplayer - 10  , tdigit1) ;
hexout u3(iscoreofplayer - 20  , tdigit2) ;
hexout u4(iscoreofplayer - 30  , tdigit3) ;
hexout u5(iscoreofplayer - 40  , tdigit4) ;
hexout u6(iscoreofplayer - 50  , tdigit5) ;
hexout u7(iscoreofplayer - 60  , tdigit6) ;
hexout u8(iscoreofplayer - 70  , tdigit7) ;
hexout u9(iscoreofplayer - 80  , tdigit8) ;
hexout u10(iscoreofplayer - 90  , tdigit9) ;



always @ (*)
begin

//***************************************** First Layer of Logo***********************************************

logo0[  0]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  1]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  2]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  3]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  4]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  5]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  6]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  7]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  8]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[  9]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 10]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 11]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 12]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 13]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 14]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 15]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 16]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 17]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 18]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 19]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 20]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 21]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 22]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 23]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 24]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 25]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 26]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 27]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 28]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 29]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 30]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 31]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 32]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 33]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 34]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 35]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 36]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 37]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 38]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 39]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 40]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 41]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 42]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100100100100100100100100000000000000001001001000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 43]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000010010000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 44]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 45]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 46]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 47]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 48]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000100000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 49]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 50]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 51]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 52]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 53]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 54]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 55]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 56]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 57]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 58]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 59]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 60]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 61]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 62]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 63]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 64]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 65]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 66]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 67]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 68]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 69]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 70]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 71]=320'b00000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 72]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 73]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[ 74]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111101000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000;
logo0[ 75]=320'b00000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001000000000000000000000000000000000000000000000000000000000000000100010000000000000000000000000000000;
logo0[ 76]=320'b00000000000000000000000000100000000000100000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000;
logo0[ 77]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000;
logo0[ 78]=320'b00000000000000000000000000000000000011000000000000000000000000000000000000000000000000011011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000001000001000000000000000000000000000000;
logo0[ 79]=320'b00000000000000000000000000000000000000001000000000000000000000000000000000000000000000011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000100000000000000;
logo0[ 80]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000000001100010000100000000000000000;
logo0[ 81]=320'b00000000000000000000000000000000000000000000000000000001000111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000001100100011101110011110000000000000000000000001000000001100000000100000000000000000;
logo0[ 82]=320'b00000000000000000000000000000001000000000000000000000000000010001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111110000000000000000000000000000000000000011101000000010000000000000000;
logo0[ 83]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000;
logo0[ 84]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000011100000000000000000000000000000;
logo0[ 85]=320'b00000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000110100000000000000000000000000000;
logo0[ 86]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000011100000000000000000100000000000000000000000000000;
logo0[ 87]=320'b00000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000010001000000000000000000000000010000100000000000000000;
logo0[ 88]=320'b00000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000111110000001111101111111111110111111101101011010110100101001111011010010100101111011011111110111111111011010010111101101111000000001000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000;
logo0[ 89]=320'b00000000000000000010000000000000001100001001000001100000010000000000000000000000000000000000111100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100010000000000000000000000010000000000000000000000;
logo0[ 90]=320'b00000000000000000100000000000000000100010010000001100000000000000000000000000000000000000000111100000010001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001010010011000101100000000000000000000000000000000000000000000100000000000000000000000000000000000000000100010000000000000000;
logo0[ 91]=320'b00000000000000001100000000000000000000010000000000000000000100000000000000000000000000000000111100011111111111111100111111000000000000000101111111000000000000000010011000010000011111111000001000000111111011000111111000000001000000000000000000000000000000010000000000010110000000000000000000000000000000000000000000000000;
logo0[ 92]=320'b00000000000000100000100000000000000011110000000000000000011000000000000000000000000000000000111110000111111011011100011010000000000000000000011111000000000000000001011000010000011111100000000000000010111111011101100000000001000000000000000000000000000000010000000000001100010000110000000000000010000000000000000000000000;
logo0[ 93]=320'b00000000000010110011100000000000000001000000000000000000000000000000000000000000000010000000111110000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000001000000000000001100110000000000011010000000000000000000100000;
logo0[ 94]=320'b00000000000110100001000000000110000000100000000000000000000001000000000000000000000010110000111110000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111010000011100111010000000000000000000000000;
logo0[ 95]=320'b00000000000111110111000000001110000000100000000000000101100000010000000001000000000011111001111110000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000010111011110101100010000000000000000000000000;
logo0[ 96]=320'b00000000000001111111100000010000001000000000000000000000000000110000000010000000000011111111111110000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110011000000110111011000001100000000000000000000000000000;
logo0[ 97]=320'b00000000000000001011110000011001100001000000010000000000000001100000000000000000000111111111111110000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111011111111110001100110000011000011010100000000000000000000000000000000000;
logo0[ 98]=320'b00000000000010000111100000011000110000000000000000000000000000000000100000000000000111111111111110000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110111111100000000001000011100000001010000000000000000110000011;
logo0[ 99]=320'b00000000111111001101100000111001110001010000100000000000000000000010000000000000000011111001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010010000000010100000000000000000000000000000000000000000000000000000111000000000000111100000000000000000000000000000010010000000;
logo0[100]=320'b00000001111111111011100010111111100001100000000000000000000000000001110000000100000010100000011110000011000000001110000000011100000000111100000001111000000001111100000001111000000001111000000011110000000011100000000100000000000000000000000000000000000000001000001000000001111110000000000000000000000000000000000000000000;
logo0[101]=320'b00000011111111111011110000111111100000100000001000000000000000000000000010000000000111111111111110000011000000001110000000011110000000111100000001111000000001111100000001111100000001111000000011110000000011100000000000000000000000000000000000000000000000001000000000000000000100000000000000000000000000011100001000000000;
logo0[102]=320'b00000111111111111101111000011111010001000000000000000001100000000000000010000000001111111111111010000010000000011111100000111111000001111110000011111100000011111110000011111100000011111100000111111000001111110000000000000000000000000000000000000000000000100001000000000000000000000000000001100000000001111111001111000000;
logo0[103]=320'b00000111111111111111111000000111001001000000000000000000000000000000000000000000001011111000001110000000010000011111100000111111000001111111000010001110000011111111000011110110000011111100000111111000001111110000000000000000000000000000000000000000000000000011111100000011010000000000000100000000000011011011111100001000;
logo0[104]=320'b00000111111111111100110100001101001001100000000000000000100000000000001000000000000011111111111110000000010000011111100000111111000001111110000010000110000001111111000011000110000011111100000111111000001111110000000000000000000000000000000000000000000000010011111100000101000000000010000000000001000010110001111101000000;
logo0[105]=320'b00000001111111111000100000011000000011011100000000000001100000000000000000000000000111111100111110000000010000011111100000111111000001111111000010000110000011111111000011000110000011011100000111111000001111110000000000000000000000000000000000000000001111101111111000000000000000000011010000000010000000110101110010000000;
logo0[106]=320'b00000001100010111100000010010010000011111100010000000000101000000000000000000000000111111011111110000000010000011001100000110001000001000010000010000110000011111111000011000110000011111100000111111000001110110000000000000000000000000000000000000000011010011111111100000000000000000011011101000000000000111111100000000000;
logo0[107]=320'b00000000100100111111011010000110000011111110000000000000110000000000000000000000000001111001110110000000000000010000000000100000000001000000000010000110000011111110000011000110000011111100000100001000001000000000000000000000000000000000000000000000000010011111011100000100001010101011111110000000000001111111000000000000;
logo0[108]=320'b00000000111001111100000000000111001111111000000001000000011000000000000000000001000001111111100110000000000000010000100000100000000001000000000010000110000011111111000011000110000011111100000100011000000000000000000000000000000000000000000000010111110011110011011100100000000000011001111110110000000001011111000000000000;
logo0[109]=320'b01000000111000110000000000001111100001001100000011111011110000000000000000000000000000111111100110000000000000010000000000100000000001000000000010000000000010000000000011000010000011111100000100011000000100100000000000000000000000000000000000010001100001010011111111110100010001101000011101110110000000000011000000000000;
logo0[110]=320'b00000000100000100000000000001110000000110110000000000001110000000000000010000100000001111111101110000000000000010000000000100000000001000000000010000000000000000000000000000010000011111100000100011000000000000000000000000000000000000000000000000000000001100001111001111111111101111100100000111111010000000000000000000000;
logo0[111]=320'b01001000000000000010000000011111000000000110000000000000111100000000000011000100001001111111111110000000000000010000000000100001000001000010000010000000000000000000000000000010000011111100000111111000000111100000000000000000000000000000000000000011000000100011110011110000111110111111111000111111110000000000000000000000;
logo0[112]=320'b00000100000000001000000011111111111000000110000001000010111100100000000011110100001111111111111110000000000000010000000000100011000001000010000000000000000010000000000010000000000011111100000100001000000111100000000000000000000000000000000000000000000001111111111111100000011110011111110100111000000000000000000000000000;
logo0[113]=320'b00110110100111011000110011111110011000000110000100000010110111000000000111111100000011111111111110000000000000011111100000111111000001111110000000000000000000000000000000000000000011111100000110111000001111100000000000000000000000000000000000000000000100001001111001100000111100111111000001111000000000000000000000000000;
logo0[114]=320'b01111001100111111111100100111110000000001110101100000000111111000000000011111100000001111111111110000000000000011111100000100111000001111110000010000000000000000000000000000010000011111100000110111000001111100000000000000000000000000000000000000000000000000000111001000001111100111110000001101100000000100000000000000000;
logo0[115]=320'b00101111101111111111000111111100000000001111110000001100111110000000000001011111001111111111111110000000000000000000000000100000000001000000000010000000000000000000000000000010000000000000000000000000000000000000000000000000100000000000000000011110000000000001111110000111111111100000000011111100000000100000000000000000;
logo0[116]=320'b10001111111111111110001101100000000010001111110000001001111110000000000000001111001111111111111110000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000011110010000000000111110000001111111100000000111110000000001010000000000000000;
logo0[117]=320'b00011111111111111111100001100000001010001111111100001111111100000000000000001111111111111111111110000000000000000000000000100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100110000011111110100110000111011100000010010000000000000000;
logo0[118]=320'b00011111111111111111100101100010100000010111000100001111111000000000000000000111111111111111111110000000000000000000000000100000000001000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000110111111111000000001100111110000000000000000000000000;
logo0[119]=320'b00010111111111111111110111100000111100110100000000011111111010000000000000000011111111111111111110000000000000000000000000000000000001000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111001100001111111111100000000000000000000000;
logo0[120]=320'b00111111111111011110110111100100111100000100000000010011100000000000000000000111111111111111111110000000000000000000000000000000000001000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001111111111011111100000111111011111000000000000000000000;
logo0[121]=320'b01111111111100100111000111100000110100000110000000110110010000000000000000000000011111111111111110000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100111100101111111101011100000001101111111100000000000000000000;
logo0[122]=320'b11111111100000110011000000000000001100000000000001111110010000000000001000010000011111111111111110000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000001101101111110110011110000001101111111111110010000000000000;
logo0[123]=320'b11111100000000000000000000110000111110011000000001111111110000000001001000000000111111111111111110000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000100000000000000000000000001001000000000010111111110000111110000011111111111111100000000000000000;
logo0[124]=320'b11111100000000000000000001111100011110011011000001111111110000000000011000000000011111111111111110000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000111100000000000101111111110000111000000110010001100000111100001111111111111110000000110000000000;
logo0[125]=320'b11110000000010010000001111001111111110110000000000111111110000000111011010000000011111111111111110000000000000000010000000000110000000000100000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000001111111110001000000010001000001000000001100011111111111111111000000000000000000;
logo0[126]=320'b11111000000000000000001110100111110111000100000010011111110000000111111110000000111111111111111110000000000000001011100000010111000000100110000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000010000000010001000001111001100000000000000000011011111111111111000100000000000000;
logo0[127]=320'b11111000000000000000001111110111111001001111000010111111110000000001111110010001111111111111111110000001000000001011100000010111000000100110000000000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100100000000000010000011111111111111111100000000000000000;
logo0[128]=320'b11111110110000000000011111111111111000011010011011111111000000000000011110000011111111111111111100000000000000000000000000000010000000000000000000000000000011111110000000000000000000000000000011100000000111000000000000000001110000000000000000000000000000000000111101100000010000000000011011111111111111111000000000000000;
logo0[129]=320'b11111111110000000010111111111111110100010111111111111110000000000000000011100111111111111111111110000000000000001111100000011110000000111100000000000000000011111110000000000000000000000000000011100000000011000000000000000001110000000000000010011111000000000000111111100000100000000000001111111111111111011000000000000000;
logo0[130]=320'b11110101111000000110111111011111111111000111111111111110000000000000000011100011111111111111111110000000000000001111100000011111000000111100000000000000000001111110000000000000000000000000000011000000000111000000000000000001001000000000000000011111000000000000111011000000011000000000000111100001111111111000011100000000;
logo0[131]=320'b11100111111000000000011111111111111110000110111111111111000000000000001000000001111111111111111110000001000000001111100000011110000000011100000000000000000001111110000000000000000000000000000011000000000111000000001000000000001000000000000000011111000000000001111110000110001000000000001111110111111111111110011100000000;
logo0[132]=320'b11111111111000000000001111111111111100001100011111111111100001000000000001101101111111111111111110000000000000000111100000001110000000011100000000000000000001111110000000000000000000000000000011100000000111000000000000000000001000000000000000000111000000000111111110001111000000000000001111011111110011110010000111100000;
logo0[133]=320'b11111111001100000000001111111111111100010011111111111111100000111100000001101111111111111111111110000000000000000101000000001010000000010100000000000000000011111110000000000000000000000000000011100000000111000000000000000000001000000000000000000011000000000010011111111111100000000000001111100100000011011110001111100000;
logo0[134]=320'b11111110100000000000001111111111100000000010111111001111100100000000001111111111111111111111111110000000000000001111100000011111000000011100000000000000000011111110000000000000000000000000000011100000000111000000000000000000001000000000000000000011110000000100111100011111100000000000001111100010000000000100000100100000;
logo0[135]=320'b11111111111000000000000111110101110000000000000001001110001000000011111111111111111111111111111110000000000000000111000000011111000000011100000000000000000011111110000000000000000000000000000011100000000111000000000000000000001000000000000000000111011010000000011000000111100000000000001111011011000000000100100011100000;
logo0[136]=320'b11111111111000000110000010111101001000000000000000000011111000100111111111111111111111111111111110000001000000001111100000011111000000111100000000000000000011111110000000000000000000000000000011100000000110000000000000000000001000000000000000000011000000000000000001101111000000111110001111111101000000000000000000100000;
logo0[137]=320'b11111100111100011110010000010000011100000000000000000111001100000011111111101111000100011111111110000000000000001111100000011111000000101100000000000000000011111110000000000000000000000000000011100000000111000000000000000001100000000000000000001111000000000000000111110010000100110111001111111111000000000000010001100000;
logo0[138]=320'b11111111111110011111101111111101110000000000000000000001111010000011111101100110000000011111111110000000000000001111000000011111000000011110000000001000000011111110000000000000000000000000000011100000000011000000000000000001100000010000000000000100110001100000000011110000000111100001010111111101101011000000000111100000;
logo0[139]=320'b11111111111111001111001110111111111100000000000000000000111101000011111000100000000000000111111110000000000000000001000000011110000000011100000000001000000011111110000000000000000000000000000011100000000111000000000000000001101000011000000000000100100000000000011001101010000111100000001111111101111111100000000011100000;
logo0[140]=320'b11111111111111001111000110111111111100000000000000000000110111000000001101100000000000010001111110000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000001101001111000000000000000100000000000001101110010100111000110000011111001111111000011100001100000;
logo0[141]=320'b11111111111111111110000110111101111110000000000000000000010011110000011010001100000000000000111110000001000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000001101000111010000000000001000011101000000111111110110111000100000011000111111110010011110000100000;
logo0[142]=320'b11111111111111111100100000011111111110011101100001100000001001110000011000000100000000000000111110000000000000000000000000000000000000000000000000000000000010111110000000000000000000000000000000000000000000000000000000000000001001111011101000001101001000000110000111101100110011110000000011101111110010010110001111100000;
logo0[143]=320'b11111111111111111000000011011111101111111010111011000000000001100000000001010111000000000000011110000000000000000000000000000000000000000000000000000000000001111110000000000000000000000000000000000000000000010000000000000000000001111111111001001101000000000011111111101001111101110000000000111111100000011111111111110000;
logo0[144]=320'b11111111111111111110001111110111001110111111111111110110001111000000000011000000000000000000000010000000000000000000000000000000000000000000000000000000000001111100000000000000000000000000000000000000000000000000000000000000000011111111111001111000000000000000011111011011111111100110001100111111110001111111111111100000;
logo0[145]=320'b11111111110111111110000010111111001110111001011111011100001100000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011111101010011000000000000000011111111111111111101100100001111111110111111111111111100000;
logo0[146]=320'b11111111111100001110000000010100001110111111111011101100000001100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000111110011010100011000000000000011110111111011111111100000001111111100111111111111111110000;
logo0[147]=320'b11111111111100000111110000111100001111111011111111111111110111011000010000000000001000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000010100101011011000011011000000000011100011111111111111100111111111111111111111111111111110000;
logo0[148]=320'b11111111111000001111110000111000111111111011111111111111111111011001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000100000001100010000000011100000000001110001111111111111110011001001111111111111111111111110000;
logo0[149]=320'b11111111111000111111110100011000011111111110111111111111110000110000100000010000100000000000000000000000000000000000000000000000000000000000000000000000000001000100000000000000000000000000000000000000000001111100000000000000000000001001100001110000001100000000001110001111111111111110011000001111111111111111111111110000;
logo0[150]=320'b11111111111100111111111100010000000111111111111110111111000000000000010000010001111000000000000000000000000000000000000000000000000000000000000000000000000001100100000000000000000000000000000000000000000001111100000000000000011011001111111000110000000000000100000111111111111111111110110100111111111111111111111111110000;
logo0[151]=320'b11111111111111110011011111010000001111111110010100101111100100000000010001000000000110000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000011111100000000000011000001111111111101100010000000000101001111111111011110111110111100111111110111111111111111110000;
logo0[152]=320'b00000000000000000000000000000000000000000000000000000000000000000000001111000001011100000100000000010000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000111101100000000000111111000111101111110110000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[153]=320'b00000000000000000000000000000000000000000000000000000000000000000000001111000000001110001100100000010000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000111111110000000000111111110110000111110011111000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[154]=320'b00010101010000001100000000000000000000000000000000000000000000000000011111111101101111111100000000110000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000001111111110000000000111111111101111111111001111000000000000000000000000000000000000000000000000000000001100111111110000;
logo0[155]=320'b00000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111001010000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000001111100110000000011111111111101111111111111111111000000000000000000000000000000000000000000000000000000000000000000000;
logo0[156]=320'b00000000000000000000000000000000000000000000000000000000000000000000001111111111011110110111110001010000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000101110000000011111111111001111111111111111111000000000000000000000000000000000000000000000000000000000000000000000;
logo0[157]=320'b00000000000000000000000000000000000000000000000000000000000000000000001111111110011100000011110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111000111111011111111110000000000000000000000000000000000000000000000000000000000000000000000;
logo0[158]=320'b00000000000000000000000000000000000000000000000000000000000000000000000111111110111000000111110000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000100000000000000000001011111111000111111101111111110000000000000000000000000000000000000000000000000000000000000000000000;
logo0[159]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000001100000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100001000110111000111000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[160]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[161]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[162]=320'b00000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[163]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[164]=320'b00000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo0[165]=320'b00000000000000000000000000000000000000000000000001000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000;
logo0[166]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000100000010000000000000000000000000000000000000000000000000000000000000000000000;
logo0[167]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000001100000010000000000000000000000000000000000000000000000000000000100000000000000;
logo0[168]=320'b00000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000100000000000000;
logo0[169]=320'b00000000000000000010000000000010000000000000000000001110000000000000000000000000000001000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000111100000000000000000000000000000000000000;
logo0[170]=320'b00000000000000000000000000001111000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000111100000000000000000100000000000000000000;
logo0[171]=320'b00000000000000000000000000001111000000111000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001111000000000100000111100000000000000000000000000000000000000;
logo0[172]=320'b00000000000000000000000000001111100000111000000000000000000000100000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010000000001111000000000100011111110000000000000000000000000111110011111;
logo0[173]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000001000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000110001011100000000000000000000000000000000001111;
logo0[174]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000110000000000000000000000000000000000000000000000;
logo0[175]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000110000000000000000000000000000000000000000000000;
logo0[176]=320'b00000000000000000000000000000000000000000000000000000000000000001000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000010000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000100000000000000000000010000000000000000000000000;
logo0[177]=320'b00001000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000001100000000000000000000000000000000000110000000000010000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000000000000000000000000000000000000000000000000000;
logo0[178]=320'b00000100000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000001100000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000010000000000000000000000000000000000000000000011000000000000000000000000;
logo0[179]=320'b00000000000000000000000000000000000000000000000000000000000000000000000001100100000000000010000000000000000000000001100001100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000010001100000000000000000000001000000000000000011000000000000000000000000;
logo0[180]=320'b00000001000000000000000000001000000000000000000000000000000010000000000000100100000000000010000000000000000000000001100001100000000000000000000000000000001111110000000000000000000000000000000000000000000000000010000000000000000000000000000100000000010001100000000000000000000000001000000000000001100000000000000000000000;
logo0[181]=320'b00000110000000000000000000010100000000000000001000000000000000000000000000000100000000000000000000000000000000000000000000100000000000000000000000000000001100100000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010001100000000000100000000000011100000000000011000000000000000000000000;
logo0[182]=320'b00000100000000000000000000000010000000000000011000000000000000000000000000000100000000000000000000000000000000000000000000100000000000000000000000000000001110110000000000000000000000000000000000000000000000000010000000000000000000000000000001111000011001000000000000000000000000011000000000000011000000000000000000000000;
logo0[183]=320'b00000110000000000000000000000011000000000000010000000000000000000000000000000100000000000000000000000000000000000000001000100000000000000000000000000101111100110000000000000000000000000000000000000000000000000011000000000000000000000000000000110000010000000000000001100000000000000000000000000011010000000000000000000000;
logo0[184]=320'b00000000000000000000000000100011000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000100000000000000000000000000000000000000000000000001110100000000000000000000000000000100000000110000000000001100000000000100000000000000000000000000000000000000000;
logo0[185]=320'b11111100011111111111111111100000111111100000110001010001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001110000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000110000000000111111000000101111111111111111110001110111111000110000000;
logo0[186]=320'b11111111111111111111111111110000011111111111010000111000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001111000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000001111110000000000111110000000000000011111111111111111111111111111111111111;
logo0[187]=320'b11111111111111111111111111110000001111111111000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000010001111000000000000000000000000000000000000000000000000000001010000000000000000000000000000001000000111110001001110111100000000000000000000000111111111111111111111111111111;
logo0[188]=320'b11111111111111111111111111100000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000110000110001000000000000000000000000000000000000000000000000000110000000000000000000000000000001000000111110001100111111000110000000000000000000000000000000000000000011111111;
logo0[189]=320'b00111001000000000100000011110000000000000001100000000000000000000000000000000000000001110000000000000000000000000001100000000000000000000000000000110000010001000000000000000000000000000000000000000000000000000100000000000000000000000000000011000000111111011100011111000111111111110011111111000000000000000000000000000001;
logo0[190]=320'b00000000000000000000000011110000000000000001110001100000000000000000000000000000000011110000000000000000000000000000000000000000000000000000000000000000110001000000000000000000000000000000000000000000000000000100000000000000000000000000000011000011111111111101111111100101111111111111111111111110110100000000000000000000;
logo0[191]=320'b00000000000000000000000011110000000000000001110000100000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000011100001111111100100101111110111111111111111011111100111111110000011110011000000;
logo0[192]=320'b00000000000000000000000011110010000001000000110000000000000000000000000000000000100101111110000000000000011000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011110111100100011111110101111111111111111111111111111111111111111111111111;
logo0[193]=320'b10010000000011011000000111010011000001000001100000000000000000000000000000000000110110011100000000000000001010000001100000000000000000000000000000000000000000100000000000000110000000000000000000000000000000000000000000000000000000000000000001110001111111000100011101110101111111111111111111111111111010111111111111111111;
logo0[194]=320'b00010100001111010000000011110000000011100001100000000000000000000000000000000000000011111100000000000000000110000001100000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000001110011111110001111111111111101111111111111111111111111111100001111111111111111;
logo0[195]=320'b00010010001101000000000011110000000011000001000000000000000000000000000000000000010100001100000000000000000010000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111011110110011110110111100111111111111111111111111111110100001011111111111111;
logo0[196]=320'b00010000000001010000001111110010000001000001000000000001001110000000000000000001100000001100000000000000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111001011111110011100010110111111111111111111111111111111111100001111111111111100;
logo0[197]=320'b00010100000001000100000011100011000001000001000000000000000000000000000000010000000000001000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000011100100000000010111111111111111111111111111111111111111010111111111111110;
logo0[198]=320'b00110000000001000000010011000011000001100001100000010000100000000000000010010000000000001000000000000000000110000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000010000110011110101011111111111111111111111111111010000111111111111111;
logo0[199]=320'b00000000000000000010010011000001000111111000111110000000000000000001000110000000000000001000000000000000000010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001011101111111111111111111111111111110010001111111111111111;
logo0[200]=320'b00000000000000000000000110000110000000110000110110000000100010000011100000000000000000001000000000000000001010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111111110111111111111111111111111111011100111111111111111;
logo0[201]=320'b00000100001001000000000110001100000011100001010010000000010010000000000000000000000000001000000010000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000101001110111000111111111111111111111111111001100111111111111111;
logo0[202]=320'b00000000000001001000000010001100000001100000010011000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000001111101111100010111111111111111111111100001101111111111111;
logo0[203]=320'b00100000001001000000000010001100000000110010010011001001100101000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000011000010111111111111000111111111111011111100001101111111111111;
logo0[204]=320'b00000000100011110010010000000000000011110000010011000010000101000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000011100001111111111111111101111111111111111110011111111111111111;
logo0[205]=320'b00100000100110010100000000000000000101011101011011001000001000000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000110000000000111111111111111111111111111111000011111111111111111;
logo0[206]=320'b01101000000110000100000000001000000011000100111011000000001000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000100000000000001111111111111111111111111111100001111111111111111;
logo0[207]=320'b00100000000011100000000000001100000000010100111011000000001000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000110000001000000000111111111111111111111111110010111111011111101;
logo0[208]=320'b00110010000011100001000000010000000000001100001011000000001000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000100000001000000000000011111111111111111111000111011111111110111;
logo0[209]=320'b10110010001001111000011000011000000000000000001010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000100000001000000001111111111111111100100011011111111011;
logo0[210]=320'b01100111001100110010001000001000000000000000000111000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000100010000000000001000000000001111111111111110011110111000011000;
logo0[211]=320'b01100010000100100001111011000000000000000000001011000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000010000000000001000000000000000011111111111000000000000000011;
logo0[212]=320'b00000001001111100110111110001100000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000000000000001000000000000000000000000001000000000000000000;
logo0[213]=320'b00000000000111110011111100001100000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000000000000001000000000001000000000000011011111111111111111;
logo0[214]=320'b00010100000010011111000000001100001000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000100000001000000000001100000000000011101111111111111111;
logo0[215]=320'b00011000011011111000000000011110000110000000000000000000010000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000001000000000001100000000000000001111111111111111;
logo0[216]=320'b01111111011111000000000000001110000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000100000000000001000001111111111111;
logo0[217]=320'b01111111100000000000000000001100000011000000001000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000100000000000001000000000111111111;
logo0[218]=320'b11111100000000000000000000001100011001000000001000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000100000000000001100000000000011111;
logo0[219]=320'b10000000000000000000000000001100010010000000011000000000010001010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000100000000000100000000000001100000000000000111;
logo0[220]=320'b00000000000000000000000000001100000001100000011000000000010001111001101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000100000000000100000000000001100000000000000000;
logo0[221]=320'b00000000000000001100000000000010000000000000011000001000010011000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000100000000000100000000000001100000000000000000;
logo0[222]=320'b00000000000000000010000010000010000000000000010000000000010011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[223]=320'b00000000000000000000000001000001000000000000010000000000010001001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[224]=320'b00000000000000000000000000000010000000000000010000000000010001010001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[225]=320'b00000000000000000000000000000010000000000000010000000000010001010001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[226]=320'b00000000000000000000000000000010000000000000010000000000010000000001000000001001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[227]=320'b00000000000000000000000000000010000000000000010000000000010000000001000000011001011100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000100000000000000100000000000000000;
logo0[228]=320'b00000000000000000000000000000010000000000000011000000000010000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000100000000000000100000000000000000;
logo0[229]=320'b00000000000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000100000000000000000;
logo0[230]=320'b00000110000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000100000000000000000;
logo0[231]=320'b00000110000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[232]=320'b00000110000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[233]=320'b00000100000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[234]=320'b00000100000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[235]=320'b00000000000000000000000000000010000000000000010000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[236]=320'b00000000000000000000000000000010000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[237]=320'b00000000000000000000000000000010000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000;
logo0[238]=320'b00000000000000000000000000000010000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

logo1[  0]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  1]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  2]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  3]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  4]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  5]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  6]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  7]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  8]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[  9]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 10]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 11]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 12]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 13]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 14]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 15]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 16]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 17]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 18]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 19]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 20]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 21]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 22]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 23]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 24]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000111111111111111111111111111110000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 25]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111100000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 26]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 27]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 28]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 29]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 30]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 31]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 32]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011111111000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 33]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001100000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 34]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000010011111111111110000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 35]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000011111111000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 36]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111100011011010000000000000000000000000000000111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 37]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000110000110001110101110101100110001111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 38]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 39]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101011111111110111110111111110110111100100101100101000101011101111101000000001110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 40]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011100000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 41]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 42]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011011011011011011011011011011111111110110110110110111111111111101111000000001000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 43]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111101111111111111101101111111111111111111111011111111100000100001111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 44]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111101010011110111111111111111111111111111111111111111111111111111111111111111111111100000000100100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 45]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101011110000000001100010000000000000000000000100100000000000000000011001101111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 46]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110111111110100000011011111111110110111110000011111110111110111110000111101000000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 47]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011101111111111110000000000000000000000000000001111000000000000000000000000000000000000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 48]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111011111111111111110000000000000000000000000001111001111100000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 49]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000001111111111111111100000000000000000000000000000000000000001101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 50]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111110000000000000000000001111100011000000111111000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 51]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000000000011000000011111110001111110000000000000000000000000000000000000000011111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 52]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000000001110000111110000011111001111000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 53]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000000011000011101111111111011110101100000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 54]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000000100001111111111111111110011001111000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 55]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000001000011111111011111110111110110111100000000000000000000000000000000000001111111111111111111111111111111111110111111111001111111111111111111111111111111111111111111111111111111111;
logo1[ 56]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111110000000000000000001111111111011111110111111111111110000000000000000000000000000000000001111111111111111111111111111111111111110000011101111111111111111111111111111111111111111111111111111111111;
logo1[ 57]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111110000000000000000011101111111011111110111111110101110000000000000000000000000000000000001111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111;
logo1[ 58]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111110000000000000000111101111111011111110111111111010111000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 59]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111110000000000000000111101111111011111110111111101111011100000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 60]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111110000000000000001111101111111011111110111111101111111110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 61]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111110000000000000011111101111111011111110111111101111111110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 62]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111110000000000000011111101111111011111110111111101111111111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 63]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111110000000000000011111101111111011111110111111101111111111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 64]=320'b11111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111011111111111111111111110000000010000111111101111111011111110111111101111101111100000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 65]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111110000000010001111111101111111011111110111111101111110101100000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 66]=320'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111110000000010001111111101111111011111110111111101111111111111111110000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 67]=320'b11111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111110111111011111111111111111111110000111000000100111101111111111111111111111111111111111111111110000000000000000000110001111111111111111111111111111111111110101111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 68]=320'b11111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111010110111111111111111111111110110011111110101111111111111111111111111111111111111111111111111100000000000000000111001011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 69]=320'b11111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111110011011111111011111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 70]=320'b11111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111110011101111001001101010111100000001011111111111111100011111111111111111110111111100000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 71]=320'b11111111111111111110110111111101111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 72]=320'b11111111111111111110110011111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 73]=320'b11111111111111111001111011111111111111111111111111011111111111111011111111111111111111111111111011111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[ 74]=320'b00010111111111111110011110111111111111111111111111111111111011111111111110111111111011111100000010110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010110000011111111111111111111111101111111111111111111111111111111111101111111111111111111111111111111;
logo1[ 75]=320'b11111111111111111111011111011111111111111111111111111111011110110000000011100000001101001100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000111000110101100001111111111111111111111111111111111111111111111111111111011101111111111111111111111111111111;
logo1[ 76]=320'b00000000000000101100111111011111111111011111111111111110111111111111111111111111111111111110000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000111111111111111110111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111;
logo1[ 77]=320'b00000000000000001101111111111111111111111111111111111111111111111111111111111111111111100100000001000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000111101111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111;
logo1[ 78]=320'b00000000000010010011111111111111111100111111111111111111111111111111111111111111111111100100000001001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000011111111111111111111111111111111110111111111111111111110111110111111111111111111111111111111;
logo1[ 79]=320'b00000000000000000011111111111111111111110111111111111111111111111111111111111111111111100000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000111100000001111111111111111111111111111111111111111111111111111111111100111111111111011111111111111;
logo1[ 80]=320'b00000000000000000001111111111111111111111111111111111111111111111111111111111111111111100000000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000011111001011111111111111111111101111101111111111111111111111111111110011101111011111111111111111;
logo1[ 81]=320'b00000000000000000001011111111111111111111111111111111110111000000000000000000000000000000000000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000111110000011111110011011100010001100001111111111111111111111110111111110001111111011111111111111111;
logo1[ 82]=320'b00000000000000000011111111111110111111111111111111111111111101110000000000000000000000000011111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001111000000000000000000000001111111011111111111111111111111111111100010111111101111111111111111;
logo1[ 83]=320'b00000000000000000111111111111111111111111111111111111111111111111111111111111111111111101111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000111111111111111111111111111111001111111111111111111111111110011111111110111111111111111111;
logo1[ 84]=320'b00011100000000111111111111111111111111111111111111111111111111110000001111000000000011111111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000011111111111111111110111111111111111100011111111111111111111111111111;
logo1[ 85]=320'b11111100010100111111111111101111111111111111111111111111111111111000011111111000000011111111100001111111110110011111111111111111111111110010000111111111111111111111111111111111111000001111111111111111111111110011100000000001100000000000000001111111100011111111111111111110111111111111111001011111111110111111111111111111;
logo1[ 86]=320'b11111101111111011111111111111111111111111111111111111111111111111100011111111000000111111111000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000010010000000000000011111111100011111111111111111100011111111111111111011111111111111111111111111111;
logo1[ 87]=320'b11111111111111111111111111111111111111111111111101111111111111111100011111111000000011111111000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010110000000000000011111111100011111111111111101110111111111111111111111111101111011111111111111111;
logo1[ 88]=320'b11111111111111111111111111111111111111111111111101111111111111111100011111111000000011111111000001111110000010000000000000000000010010100100001011010010000100100101001010000100100000001000000000100101101000010010000100000010110000000000000011011111100011111111111111111111111111111111111111111111101111111111111111111111;
logo1[ 89]=320'b11111111111111111101111111111111110011110110111110011111101111111101111111111000000011111111000011111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001110000000000000011011111100111111011111111111011101101111111111111111111101111111111111011111111;
logo1[ 90]=320'b11111111111111111011111111111111111011101101111110011111111111111111111111111100000111111111000011111101110111111111111111111111111111111111111111111111111111111111111111111111111101111111011110100100101100011010011111111101110000000000000011011111100111111011111111111111011111111111111111111111111011101111110111111110;
logo1[ 91]=320'b11111111111111110011111111111111111111101111111111111111110011111111111111111100000111111111000011100000000000000001000000111111111111111010000000111111111110011001100111101111100000000111110111111000000100110000000111111110110000000000000001001111100111101111111111101001111111111111111111111111111111111111111111111100;
logo1[ 92]=320'b11111111111111011101011111111111111100001111111111111111100111111111111111111111000111111111000001111000000100100011000101111111111111111110100000111111111111111110000111101111100000010111111111111101000000000010011111111000110000000000000001011111100011101111111111110011101111001111111111111101111111111111111111111111;
logo1[ 93]=320'b11111111111101001100011111111111111110111111111111111111111110111111111111111111000101111111000001111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001110000000000000001010111101111111110111111111111110011001111111111100001111111111111111111011111;
logo1[ 94]=320'b11111111111001011110111111111001111111011111111111111111111110111111111111111111111101001110000001111111010100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000011000000000000110000000000000000011111001111111111111111111110110000101111100011000101111111111111111111111111;
logo1[ 95]=320'b11111111111000001000111111110001111111011111111111111000011111101111111110111111111100000010000001111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000010000000000000011000010111111111111111111001111111111100000100001010011101111111111111111111111111;
logo1[ 96]=320'b11111111111110000000011111101111110111111111111111111111111111001111111101111111111100000000000001111000010100011101101111111111111111111111111111111111011111111111111111111111111111111111111111111110110111111001111111111111111111001111111111111111111111111111110001100111111001000100111110011111111111111111111111111111;
logo1[ 97]=320'b11111111111111110100001111100110011110111111101111111111111110011111111111111111111000000000000001111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011010000011111111111100000000000000000000000001110011001110100111100101011111111111111111111111111111111111;
logo1[ 98]=320'b11111111111101111000011111100110001111111111111111111111111111111111011111111111111000000000000001111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000111111111111111111111111111001000000011111111110111100011111110101111111111111111001111100;
logo1[ 99]=320'b11111111000000110010011111000110001110101111011111111111111111111101111111111111111100000110111111111110110000101111100001111111100011111111000111111111000111111111000111111111000110110110001101101110011101011000001100000000000000000000001110000000000011011111000111111111111000011111111111111111111111111101101001111111;
logo1[100]=320'b11111110000000000100011101000000011110011111111111111111111111111110001111111011101101001111100001111100101110010001001100100010011001000000100010000100100010000010111000000000111010000101100000001011100100010111001011111100000000000000000000000000000010010111110111111110000001111111111111111111111111110111111111111000;
logo1[101]=320'b11111100000000000100001111000000011111011111110111111111011111111111111101111111111000000000000001111100101111010001011110100001111101000011111110000101111010000011111110000011111110000111111100001111111000011111100110000001111111001111111111111111111111110111111111111111111011111111111111111111111111100011110110111110;
logo1[102]=320'b11111000000000000010000111100000001100111111111111111110011111111111111101111111110000000000000001111101011001100000010011000000110110000001101100000011101100000001101100000011101100000011011000000110010000001100100110000000000000111111111111111111111111011110111111111111111111111111111110011111111110000000000000111110;
logo1[103]=320'b11111000000000000000000111111000110110111111111111111111111111111111111111111111110100000111010001111111101000100000010001000000110010000000100101110001100100000000100100001001100100000011001000000010010000000100000010000000000000000000000000000000000000111100000011111100101111111111111011111111111100100100000011110111;
logo1[104]=320'b11111000000000000011001011110010110110011111111111111111011111111111110111111111111100000000000001111111101000100000011001000000110010000001100101111001100100000000100100011001100100000011001000000110000000001110000010000000000000010000000000000001111111101000000011111010111111111101111111111110111101001110000010111111;
logo1[105]=320'b11111110000000000111011111100111111000000011111111111110011111111111111111111111111000000000000001111111101000100000010001000000110010000000100101111001100100000000100100011001100100100011001000000110000000001110000010000000000000010000000000000011110000010000000111111111111111111100101101111101111111001010001101111111;
logo1[106]=320'b11111110011101000001111101101001111100000011101111111111010111111111111111111111111000000000000001111111101000100000011001001110110010111101100101111001100100000000100100111001100100000011001000000110000001001110000010000000000000000000000001111111100101100000000011111111111111111100000010111111111110000000011111111111;
logo1[107]=320'b11111111011001000000100101111001111100000001111111111111001111111111111111111111111110000000000001111111101000101111111001011111110010111111100101111001100100000001100100111001100100000011001011100110000111111110000010000000000000000000000010111111111101100000100011111011110101010100000001111111101110000000110111111111;
logo1[108]=320'b11111111000110000011111111111000110000000111111110111111100111111111111111111110111110000000010001111111111000101111011001011111110010111111100101111001100100000000100100111001100100000011001011100111001111011110000010000000000000000000000010101000001100001100100011011111111111100110000000001111111110100000111111111111;
logo1[109]=320'b10111111000111001111111111110000011110110011111100000100001111111111111111111111111111000000001001111111111000101111111001011111110010111111100001111111100101111111100000111101100100000011001011100111001011011110000010000000000000000000000010101100011110101100000000001011101110010111100010001001111111111100111111111111;
logo1[110]=320'b10111111011111011111111111110001111111001001111111111110001111111111111101111011111110000000010001111111111000101111111001011111110010111111100001111111100111111111100011111101100100000011001011100111001111011110000010000000000000000000000010011111111110011110000100000000000010000011011111000000101111111111111111111100;
logo1[111]=320'b10110111111111111101111111100000111111111001111111111111000011111111111100111011110110000000000001111111111000101111011001011110110010111101100001111111100111111111100011111101100100000011001000000110001000011110000010000010000000000000000011000100111111011100000100001101000001000000000011000000001111111111111111111100;
logo1[112]=320'b11111011111101110111111100000000000111111001111110111101000011011111111100001011110000000000000001111111111000101111111001011000110010111101100011111111100101111111100001111111100100000011000011110111001000011110000010000010011000000000000011000111111110000000000000011111100001100000001011000111111111111111111111111000;
logo1[113]=320'b11001001011000100111001100000001100111111001111001111101001000111111111000000011111100000000000001111111111000100000011001000000110010000001100001111111100111111111100011111111100100000011000001000111000000011110000010000000000000000000000010011111111011110110000110011111000011000000111100000111111111111111111111111000;
logo1[114]=320'b10000110011000000000011001000001110111110001010011111111000000111111111100000011111110000000000001111111111000100000011001011000110010000001100001111111100111111111100011111101100100000011000001000111000000011110000010000000000000000000000011011111111111111111000110111110000011000001111100010011111111011111111111111000;
logo1[115]=320'b11010000000000000000111000000011111111110000001111110011000001111111111110100000110000000000000001011111111000111111111001011111110010111111100001111111100111111111100011111101100111111111000111111111001111111110000010000001010000000000000011000001111111111110000001111000000000011111111100000011111111011111111111111000;
logo1[116]=320'b00110000000000000001110010011111111101100000001111110110000001111111111111110000110000000000000001011111111000111111111001011111110011111111100011111111100111111111100011111111100111111111000111111111001111111110000010000001011000000000000010000001101111111111000001111110000000011111111000000111111110101111111111111000;
logo1[117]=320'b11100000000000000000011110011111110101110000000011110000000011111111111111110000000000000000000001011111111000111111111001011111110010111111100001111111100111111111100011111111100111111111000111111111001111111110000010000001111000000000000011011111111111111111011001111100000001011001111000100011111101100111111111111111;
logo1[118]=320'b11100000000000000000011010011101011111001000111011110000000111111111111111111000000000000000000001011111111000111111111001011111110010111111100011111111100100000001100011111111100111111111000111111111001111111110000010000001111000000000000011000000111111001011111111001000000000011011110011000000111111111111111111111111;
logo1[119]=320'b11101000000000000000001000011111000011001011111111000000000101111111111111111100000000000000000001011111111000111111111001011111110010111111100011111111100100000001100011111111100111111111000111111111001111111110000010000001110000000000000011001100111111011111111110000000000000010011110000000000011111111111111111111111;
logo1[120]=320'b01000000000000100001000000011010000011111011111111101100011111111111111111111000000000000000000001011111111000111111111001111111110010111111100011111111100100000001100011111111100111111111000111111111001111111110000010000101110000000000000001111111100110011111001110000000000100000011111000000100000111111111111111111111;
logo1[121]=320'b00000000000011011000111000011111001011111001111011001001101111111111111111111111100000000000000001011111111000111111111001111111110011111111100011111111100100000001100011111111100111111111000111111111001111111110000010000000010000000000000000000000001001101011000001010000000010100011111110010000000011111111111111111100;
logo1[122]=320'b00000000001111001100111111111111010011111111111110000001101111111111110111101111100000000000000001111111111000111111110000111111110001111111100011111111100100000001100011111111100011111111100111111111001111111110000010000111111000000000000000000000001111110111110010010000001001000001111110010000000000001101111111111110;
logo1[123]=320'b00000011111111111111111111001111000001100111111110000000001111111110110111111111000000000000000001111111111100111111111000111111110000111111100011111111100100000001100011111111100011111111100111111111001111111110000010000110011110000000000111111111110110111111111101000000001111000001111100000000000000011111111111111110;
logo1[124]=320'b00000011111111111111111110000011100001100100111110000000000111111111100111111111100000000000000001111111111000111111111000111111110001111111100001111111100100000001100011111111100011111111100111111111001111111110000010000111000010000000001010000000001111000111111001101110001111000011110000000000000001111111001111111111;
logo1[125]=320'b00001111111101100111110000010000000001000111111111000000001111111000100101111111100000000000000001111111111000111101110000111001110001111011100001111111100100000001100011111111100111111111100111111111001111111110000010000111111110000000011110000000001110111111101110111110111111110011100000000000000000111111111111111000;
logo1[126]=320'b00000111111111111111110001010000001000111011111101100000001111111000000001111111000000000000000001111111111000110100011000101000110001011001100001111111100100000001100011111111100011111111000111111111001111111110000010000011111110000000011101111111101110011110000110011111111111111111100100000000000000111011111111111100;
logo1[127]=320'b00000111111111111111110000001000000110110000111101000000001111111110000001101110000000000000000001111110111000110100011000101000110001011001100000001111100100000001100000111111100011111111100111111111001111111110000010000011111100000000001111111111111111111110000011011111111111101111100000000000000000011111111111111111;
logo1[128]=320'b00000001001111111111100000000000000101100101100100000000111111111111100001111100000000000000000001111111011000111111111000111100110001011111100000011111100100000001100000111111100011111111100100011111001000111110000010000110001110000000000111101111111111111111000010011111101111111111100100000000000000000111111111111111;
logo1[129]=320'b00000000001111111101000000000000001011101000000000000001111111111111101100011000000000000000000001111111101100110000011000100000110001000011100000011111100100000001100000111111100011111111100100011111001000111110001010000010001100000000000101100000111111111111000000011111011111111111110000000000000000100111111111111110;
logo1[130]=320'b00001000000111111001000000100000000000111000000000000001111111111111111100011100000000000000000001111111111100100000010000100000110001000011100000011111100110000001100000111111100011111111100100111111001000111110011110001010010100000000000111100000111011111111000100111111100111111111111000011110000000000111100011111111;
logo1[131]=320'b00011000000111111111100000000000000001111001000000000000111111111111110111111110000000000000000001111110111000100000011000000000110000000011100000011111100110000001100000111111100011111111100100111111001000111110010110011111110100000000000011100000110001111110000001111001110111111111110000001000000000000001100011111111;
logo1[132]=320'b00000000000111111111110000000000000011110011100000000000011110111111111110010010000000000000000001111111111000101000011000010001110000100011100000011111100110000001100000111111100011111111100100011111001000111110001111111111110100000000000011101000110001111000000001110000111111111111110000000000001100001101111000011000;
logo1[133]=320'b00000000110011111111110000000000000011101100000000000000011111000011111110010000000000000000000001111111111000101010110000010101110000101011100000011111100100000001100000111111100011111111100100011111001000111110001111111111110100000000000011111100111001111101100000000000011111111011110000011011111100100001110000011000;
logo1[134]=320'b00000001011111111111110000000000011111101101000000110000011011111111110000000000000000000000000001111111111000100000010000000000110000100011100000011111100100000001100000111111100011111111100100011111001000111110011110111111110100000000000011111100001111111011000011100000011111111111110000001101111111111011111011011000;
logo1[135]=320'b00000000000111111111111000000010001111111111111110110001110101111100000000000000000000000000000001111111111000101000010000000000110000100011100000011111100100000001100000111111100011111111000100011111001000111110011111111111110100000000000011111000000101111111100111111000011110011111110000000100111111111011011100011000;
logo1[136]=320'b00000000000111111001111101000010110111111111111111111100000111011000000000000000000000000000000001111110111000100000010000000000110000000011100000011111100100000001100000111111100011111111000100011111001000111110001111111111110000000000000011111100111111111101111110010000011111000001100000000010111111111111111111011000;
logo1[137]=320'b00000001000011100001101111101111100011111111111111111000110011111100000000000000111011100000000001111111011000100000010000000000110000000011100000011111100100000001100000111111100011111111000100011111001000111110001011111110011000111111111111110000111111111111111000001101110011001000110000000000111111111111101110011000;
logo1[138]=320'b00000000000001100000010000000010001111111111111111111110000101111100000010011001111111100000000001111111101000100000110000000000110000100001100000010111100100000001100000111111100011111111000100011111001000111110011011111010010000101111111111111011001110011111111100001111111000011110100000000010010100111111111000011000;
logo1[139]=320'b00000000000000100000110001000000000011111111111111111111000010111100000111011111111111111000000001111111101000101110110000000001100000100011100000010111100100000001100000111111100011111111000100011111001000111110011011100010010001100111111111111011011111111111000110000101111000011111110000000010000000011011111100011000;
logo1[140]=320'b00000000000000110000111001000000000011111111111111111111001000111111110010011111111111101110000001111111101000101111110000011111100000111111100000011111100100000001100000111111100011111111000111111111001111111110011011000010010010000111111111111111011111111111110010001101011000111001111100000110000000111100011110011000;
logo1[141]=320'b00000000000000000001111001000000000001111111111111111111101100001111100101110011111111111111000001111110101000100111110000001111110000001111100000011111100100000001100000111111100001111111000011111111001111111111011010001010010110000101111111111110111000010111111000000001001000101011111100110000000001101100000111011000;
logo1[142]=320'b00000000000000000011001111100000000001100010011110011111110110001110100111111011111111111111000001111111100000100111110000001111100000001111000000011111000100000001100000111111100001111111000011111110001111111111111010011101110110000100010111110010110111101001111000000011001100001111111100010000001101101001110000001000;
logo1[143]=320'b00000000000000000111111100100000010000000001000100111111111110011000111110001000111111111111100000111111111100010111100000001111000000001111000000011110000010000001000000111111000001111110000011111100001111101111111111111100011110000000000110110010111111001100000000010110000010001111110111000000011111100000000000001000;
logo1[144]=320'b00000000000000000001110000000000110001000000000000001001110000111000011100111111111111111111111000011111111111011111100000001111000000001110000001011110000010000010000000110110000000111110000001111100000111111111111111111100100100000000000110000111111111000111100000100100000000011000110011000000001110000000000000011000;
logo1[145]=320'b00000000001000000001111101000000010001000000000000000011110001111100011101111111111111111111111110011000000001111111000000001111000000001110000001011110000011111111000000110111000000111111000001111110000111111111111110111110111101100000010101100111111111111111100000000000000000010011011110000000001000000000000000001000;
logo1[146]=320'b00000000000011110001111111100011110001000000000000000011111110011111111101111111111111111111111111111000000000111100000000000000000000000000000100110000010110011011000000000001001111000000000110000000001000101111000000011101111111000001100101011100111111111111100000000000100000000011111110000000011000000000000000001000;
logo1[147]=320'b00000000000011111000001111000011110000000100000000000000001000100111101111111111110111111111111011111000000000011000000000000000000000000000000000000000010011111111000000000000000000000000000000000000000001000111000000011111111101011010100000111100100111100110100011100000000000000011000000000000000000000000000000001000;
logo1[148]=320'b00000000000111110000001111000111000000000000000000000000000000100000001111111111111011111111111100011000000000000000000000000000000000000000000000000000011011111111000000000000000000000000000000000000000001000111000000011111111011111110011001111110100011011111110001110000000000000001100010110000000000000000000000001000;
logo1[149]=320'b00000000000111000000001011100111100000000000000000000000001111001001011111101111011111111111111110011000000000000000000000000000000000000000000000000000000010111010000000000000000000000000000000000000000010000011000000011111111111110110011110001111110010011111110001110000000000000001100111110000000000000000000000001000;
logo1[150]=320'b00000000000011000000000011101111011000000000000001000000111111110000101111101110000111111111111110011000000000000000000000000000000000000000000000000000000010011010000000000000000000000000000000000000000010000011000000011111100100110000000111001111111100001010010000000000000000000001001011000000000000000000000000001000;
logo1[151]=320'b00000000000000001100100000101111110000000001100011000000011011100000001110111011101001111111111100011000000000000000000000000000000000000000000000000000000011011111000000000000000000000000000000000000000100000011000000011100111110000000000010011101111100000000110000000000000001000001000011000000001000000000000000001000;
logo1[152]=320'b11111111111111111111111111111111111111111111111111111111111111100000010000111110100011111011111100001000000000110000000000000000000000000000000000000000010011101111000100000000000000000000000000001111101000010011000000011000000111000010000001001111111100000111111111111111111111111111111111111111111111111111111111111000;
logo1[153]=320'b11111111111111111111111111111111111111111111111111111111111111111111110000111110110001100011011100101000000000111000000000000000000000000000000000000000000011101111001110000000000000000000000000001111111000000001000000011000000001001011000001100000111111111111111111111111111111111111111111111111111111111111111111111111;
logo1[154]=320'b11101010101111010010000010011000110101011111111000111111111111101111000000000010010000000011111101001110001001111000000000000000000000000000000000000000010010000111011100000000000000000000000000000000010000000001000000011000000000010000000000010000111101111111111111111111111111111111111111111111111111110011000000001110;
logo1[155]=320'b11111111111111111110000000000000000000000000000000000000000001100000000000000000000000000000000110101000001011110000000000000000000000000000000000000000001110000111111100000000000000000000000000001000010000011001000000100000000000010000000000000000000100000000000000000010000000000001000000000000110001111111111111111010;
logo1[156]=320'b11111111111111111110000000000000000000000000000000000000000101101000010000000000100001001000001110101000011011000001000000000000000000000000000000000000001110011111011100000000000000000000000000110000111111010001000000100000000000100000000000000000000101000000000000000110000000000001000000000000110001111111111111111110;
logo1[157]=320'b01111111111111111110000000000000000000000000000000000000000100000010010000000001100011111100001010111110011110000011100000000000000000000000000000000000010111111111000000000000000000000000000110000001110000111110000001100000000000101000000100000000001000100000000000000010000000000001000000000000110001111111111111111111;
logo1[158]=320'b00000000000000000100000000000000000000000000000001000000000110000000001000000001000011111000001011110000001100000111100000000000000000000000000000000000001011111111000000000000000000000000000111000001010000110110000000010000000000101000000010000000001000000000000000000110000000000011000000000000110001100000100000001100;
logo1[159]=320'b00000000000000000100000000000000010000000000011011110011001110000000000010010011111011111011111111111100001101110111100000000000000000000000000000000111110100000000001100000000000000000000001111100111110000110110000000011111011110101000000111000111011000000001100000000111011000000001011000000000111011100000110001001100;
logo1[160]=320'b00000000000000000000000000000000000000000000000001100000001110000000000000001110000111111100011110111000000001010011100000000000000000000000000000000111011100000000001000000000000000000000001111000011110000000000000000000000000001111111111101111100011000000000000000000110000000000000000000000000000000000000000000000000;
logo1[161]=320'b11111111111111111111111111111111111111111111111111011111111111111111110000001000000000000000000000000000001101110010000000000000000000000000000000000111111100000000011000000000000000000000011111100000100000000000000000000000000111001111111001101110011111111111111111111111111111111111111111111111111111111111111111111111;
logo1[162]=320'b11111111111111111111111111111111111111111111111111111111111011111111100000011000000000000000000000000000011100100000000000000000000000000000000000000101111100000000111000000000000000000000000000000000000000000000000000000000000111111111111100111111011111111111111111111111111111111111111111111111111111111111111111111111;
logo1[163]=320'b00000000000000000000000000000000000000000000111111111111001010000001100000011100000000000000000000000000000000000000000000000000000000000000000000000011101000000000001100000110000000000000000000000000000000000000000000000000000011111111111101011111011000000000000011111111111110000000000000000000000000000000000000000000;
logo1[164]=320'b00000000000000000000000000000000000000000000000111111000001010000001100000011010011011000000000000000000000000000000000000000000001000000000000100001100110000000000001100000110100000000000000000000100000000000000000000000111000111111111111111001111111000000000000000001011100000000000000000000000000000000000000011000000;
logo1[165]=320'b00000000000000000000000000000000000000000000000010110000000110000000001000010010000011100000000000000000000000000000000000000000011000000000001100001100000000000000000000000111100000000000000000000000000000000000000000000110000111111111111111111111101000000000000000000111100000000000000000000000000000000100000011000000;
logo1[166]=320'b00000000000000001000000000000000000000000000000011110000000110000000011101111010000011100000000000000000000000000000000000000000011000000000001010000000000000000000000000001101111000000000000000000100000000000000000000000000000001110000000001011111101000000000010000000111000000000000000000000000000110001100000111001001;
logo1[167]=320'b00000000000000001100000000000000000000000000000011110000000110000000011111101000000011110000000000000000000000000000000000000000011000000000000000000000000000000000000000000110010010000000000000101100000000000000000000000000000000110000000010000111101000000000000000000111110000000000000000000000000000001010001111000000;
logo1[168]=320'b00000000000000001110000000000000000000000000000011111111000110000000001011101000000011100000000000000000000000000000000000000000011000000000001010001100000000001100000000000111011011000000000000111110000000000000000000000000000000001100000011111011101100000010010001100111010000111110000000000000001000001010001111000000;
logo1[169]=320'b00000000000100011101000010011101110000100000000011000001000110000000001110001100000010100000000000000000000000000000000000000000011000000000001010001100000000001100000000111110111111000000000000000000000000000000000000000000000000001000000011111011101111111111111111101110100011000010000001000000001110101110100111000000;
logo1[170]=320'b00111111111111111111111111110000110111111110000000001110000000000000000110001100000010100000000000000000000000000000000001110000011000000000001110011100000000111100000000011011110000000000000000000000000000000000000000000000000000000000000011111011100111111111111111111100111011000010111101101111111011110111110111111110;
logo1[171]=320'b11111111111111111111111111110000111111000111111111111111111111110110001110001000000011100000000000000000000000000000000001110000011000000000000110011100000000111100000000111011110000000000000000000000000000000000000000000000000000000000000111111101101111111100000111111111011111000011111111111111111111111111111111111111;
logo1[172]=320'b11111111111111111111111111110000011111000011111110000000110001010110001000001010000011100000000000000000000000000000000001110000011000000000000111011101000000101100000000011011111000001111110000100100000000000000000011100000000000111100010101101111101111011110000110111111011100000001111111111111111111111111000001100000;
logo1[173]=320'b11111111111111111111111011111111111111111111110100000000110000111001000000001010000011100100000000000000000000000000000001110000000011000000001111010100000000001110000000111011111100000001111100000110000000000000000000001110000000000011110101101111001111111111111111111101001010100011111111111111111111111111111111110000;
logo1[174]=320'b11111111111111111111111011111111111111111111111111111111111111011001110000101010111111100000000000000011011111110111111011110000110000000000011100111100000001111110000000001100000100000000111110000100100111101110111100000111100100000011110101000000001011111100000000100101001011111111111111111111111111111111111111111111;
logo1[175]=320'b11111111111111111111111111111111111111111111111111111111111111111101111111111011111111111111111111111111111111111111111111111111111111111111111100111111111101000111111111001111111111010011101111111111111111111111111111111111111111111111111101111111101011111111111111111101001011100011111111111111111111111111111111111111;
logo1[176]=320'b11111111111111111111111111111111111111111111111111111111111111110001111111111011111111011111111111111111111111111111111110111011001111111111111110111110101101001111011000101111111111101111111111111111111111111100000001111111111111111111111101111111101011111111111111111111011011101111111111111101111111111111111111111111;
logo1[177]=320'b11110111111111111111111111111111111111111111111111111111111111111000111111111011111111111111111111111111111111111110111110011110111111111111111111111111111101001111111111101111111111111111111111111111111111111111110111111111111111111111111101111111101111111111111111111111111111111111111111111111111111111111111111111111;
logo1[178]=320'b11111011111111111111111111111111111111111111111111111111111111111100011111111011111111111111111111111111111111111111111110011111111111111111111110111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111100111111101111111111111111111111111111111111111111111100111111111111111111111111;
logo1[179]=320'b11111111111111111111111111111111111111111111111111111111111111111111011110011010111111111101111111111111111111111110011110011111111111111111111111111111111011111011111111111111111111111111111111111111111111111111111111111111111111111111111100111111101110011111111100111111111010111101111111111100111111111111111111111111;
logo1[180]=320'b11111110111111111111111111110111111111111111111111111111111101111111111111011010111111111101111111111111111111111110011110010111111111111111111111111111110000001011111111111111111111111111111111111111111111111101110111111111111111111111011011101011001110010111011101111011111011100111111111111110011111111111111111111111;
logo1[181]=320'b11111001111111111111111111101011111111111111110111111111111111111111111111101010111111111110111101110111111111111111111111011111101111011111111111111110010011001011111111011111111111111111111111111111111111111111111111111111111111111111010111111111101110011111111111011111111111100011111111111100111111111111111111111111;
logo1[182]=320'b11111011111111111111111111110101111111111111100111111111111111111111111110001010111111111111011101110111111111111110011111011111111111111111111111111111110001001111111111111111111111111111111111111111111111111101111111111111111111111111111110000111100110111111111111111111111111100011111111111100111111111111111111111111;
logo1[183]=320'b11111001111111111111111111111100111111111111100101111111111101111111111110001011111111111111111111111111111111111111010111011111111111111111111111111010000011001111111111111111111111111111111111111111111111101100111111111111111111111111111111001111101111111111111110011111111111111111111111111100101111111111111111111111;
logo1[184]=320'b11111111111111111111111111011100111111111111101011111111111110111111111111101111111111111111111111111111111111111111011111011111111111111111111111111110011111011101111111111111111001100000000000111011111111010000011101111100110000000000000001011011011001111111111110011111111111010011110111111111111111111110010100000000;
logo1[185]=320'b00000011100000000000000000001111000000011111000010101110111110001111111111111111111111111111111111110100111000000010000000000010001111000000110000101110000101111101111111111111110000000110000000000011000000010001100000100000000000000000000001111011111001111111111000000111111000000000000000000001100001000000111001111111;
logo1[186]=320'b00000000000000000000000000001111100000000000101111000111110100001111111111111111111111111111100000000000000000000011000000000000000001111000000000101110000101111101111111111111110000110010000000000000111001110011000000000100000000000000000011111010000001111111111000001111111111111100000000000000000000000000000000000000;
logo1[187]=320'b00000000000000000000000000001111110000000000111111111111111000001111111111111111111111100111100000000011000110101111001100011110000000000000000110101110000111111111111111111111110000110000000000000000111111000001010000000100000000000000000010111010000001110110001000011111111111111111111111000000000000000000000000000000;
logo1[188]=320'b00000000000000000000000000011111111111111111111110111111111000000111111111111111111110000111100000000001001111001001101001111100000000000000000111001111001010111111111111111100110000110000000000000000111111111001000000000000000000000000000010111010000001110010000000111001111111111111111111111111111111111111111100000000;
logo1[189]=320'b01000110111111111011111100001111111111111110011111111111111111010111111111111111111110001111100000000000101111000010010111111100011100000011100111001111001010111111111111111101111000110000000000000010011111101001100000000000000000000000000000111110000000100010000000111000000000001100000000111111111111111111111111111110;
logo1[190]=320'b11111111111111111111111100001111110111111110001110011111111111010101111111111111111100001111100000000001001111000111011111111110000110000000000111111111001010011111111111111101111000110000000000000000111111101011111000000000000000000000000000111100000000000010000000011000000000000000000000000001001011111111111111111111;
logo1[191]=320'b11111111111111111111111100001110110111111110001111011111111000010111111111111111111110001111100000000001111111000101011111111100000000000000000110001111111011111111111111111111111000110000000000000000111110111001111101000001000000000000000100011100000000011011000000001000000000000000000000000000000000111100001100111111;
logo1[192]=320'b11111111111111111111111100001101101010111110001111111111111100000111111111111111011010000001100001111110100111010101011111111100000000000000000110000000000001100001000000000001000000110100001000001100111110101111111101101111111111111110110100000100001000011011100000001000000000000000000000000000000000000000000000000000;
logo1[193]=320'b01101111111100100111111000101100111110111110011111111111111000001111111111111111001001100011111111111111110101111110011111111111111111111111111111111111111111011111111111111001111111111111111111111111111111111111111111111111111111111111111100001100000000111011100000001000000000000000000000000000000001000000000000000000;
logo1[194]=320'b11101001110000101111111100001111011100011110011111111111110010001111111111111111111100000011111111111111111001111110011111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111100001100000001110000000000000000000000000000000000000000000011110000000000000000;
logo1[195]=320'b11101100110000111111111100001111001100111110111111111111111111111111111111111111100011110011111111111111111101111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000100000001100001000000000000000000000000000000000000000011110000000000000000;
logo1[196]=320'b11101011111110101111110000001101000010011110111111111110110001111111111111111110011100010011111111111111110111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000110100000000100011100000000000000000000000000000000000000011110000000000000000;
logo1[197]=320'b11101011111110111011111100010100101010101110111111111111111111111111111111101111110011110011111111111011111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111100010001111111100000000000000000000000000000000000000000100000000000000000;
logo1[198]=320'b11001111111110111111001100111100111110011110011111101111011111111111111101101111111111110111111111111011111001110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111101110101111001100000010000000000000000000000000000000101110000000000000000;
logo1[199]=320'b11111111111111111101101100111110111000000011000001111111011111001110111001111111111111010111100111011011101101110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101011111101111111111101111111110011011111000110000010000000000000000000000000000001101110000000000000000;
logo1[200]=320'b11111111111111111111111001111001101111001111001001111111011101101100011111100111111111110111111111011111110101111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111101111111111111111111111101101111000110000000000000000000000000000000000000100011000000000000000;
logo1[201]=320'b11111011110110111111111001110010001100011110101101111111101101101111111111111111111111110111111101111111110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111101100111111111111111100111100111010110000000000000000000000000000000000000010011000000000000000;
logo1[202]=320'b11111111111110110111110001110010011110011101101100111111111101101100111111111111111011101111110111111011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100111011111110111110111111111111100000000000000000000000000000000000000011110000000000000000;
logo1[203]=320'b11011111110110111111111101010011111111001101101100110110011000111111111111111111111111101111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101111111111111110111011111110100101100000000000000000000000000000000000011110000000000000000;
logo1[204]=320'b11011111011100001101101111011111111100001111101100111101111000100011111111111111111111101111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111100011110000000000000000000000000000000000000100000000000000000;
logo1[205]=320'b11011111011001101011111111111011111010100000100100110111110111000011111111111111110111101111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111101010111111001111111111000000000000000000000000000000111100000000000000000;
logo1[206]=320'b10010111111000111011111111110100111100101011000100111111110110000001111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110011011111101101000111111011111111111110000000000000000000000000000011110000000000000000;
logo1[207]=320'b11011101111100011111111111110000111111101011000100101111110110100000111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111001111110111111111000000000000000000000000001100000000000000000;
logo1[208]=320'b11001101111100010110111111101100111011110011110100111111110111000000111111110111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111000111111011111110111111111111100000000000000000000111000000000000000000;
logo1[209]=320'b01001101110110000111100111100011111011111110010101111111111111000101111111110111011110111111111111011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111011111110111111110000000000000000011000000000000000000;
logo1[210]=320'b10011000110011001101110111110111111011010011111000111111111011100110011111110111111010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111011101111111111110111111111110000000000000001100000000000000000;
logo1[211]=320'b10011101111010011110000100111111111111011111110100111111111011100011011111110111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011011111111101111111111110111111111111111100000000000111111111111111100;
logo1[212]=320'b11111110110000011001000001110011110110111111111101111111111111100111011111110101111110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011011111111111111011111110111111111111111111111111110111111111111111110;
logo1[213]=320'b11111111011000001100000011110011111110111111111111111101011110000011011111110111011010110111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011011111111111111111111110111111111110111111111111100100000000000000000;
logo1[214]=320'b11101001111101100000111111110011110111111111111111111111111110000011001111111111011010110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111011111110111111111110011111111111100000000000000000000;
logo1[215]=320'b11100111100100000111110111100001111001011111011111111111101110011111101011111101111001111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110111111111110011111111111111110000000000000000;
logo1[216]=320'b10000000000000111001111111110001111101111111111111111101111111111011101111111101111011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111011111111111110111110000000000000;
logo1[217]=320'b10000000011111001111111111110011111100111111110111111111101110000001111111111010111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111011111111111110111111110000000000;
logo1[218]=320'b00000011110111111111111111110011000110111111110111111111101111011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111011111111111110011111111111100000;
logo1[219]=320'b01111110111111111111111111110010001100111111100111111111101110101111011111111111100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111011111111111011111111111110011111111111111000;
logo1[220]=320'b11111111111111111111111111110010011110001111100111111111101110000110010111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111011111111111011111111111110011111111111111111;
logo1[221]=320'b01111111111111110011111111111100110101101111100111110111101100110111000100011111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111011111111111011111111111110011111111111111111;
logo1[222]=320'b11000011111111111101111101111101011101101111001011111111101100110101111000000111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[223]=320'b11111100000000000011111110111110110001101111001011100000001010110101111011000111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[224]=320'b11111111111111111111111111111101111111111101001011111111101010101000101011000110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[225]=320'b11111111111111111111111111111101011111111111001011111111101010001010101000001110100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[226]=320'b11111111011110110111001100001101011111111110001010011110001011111000101100010110011100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[227]=320'b11111111111111111111111111111101010011111111101111100000001011111110101111100110100011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[228]=320'b11111110111111111111111111111101011111111111100111111111101111111110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111100011111011111111111111011111111111111111;
logo1[229]=320'b11101111111000001111111111111101011111111111001011111111101111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100011111011111111111111011111111111111111;
logo1[230]=320'b11101001111111111111111111111101111111111111101010000111001011000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011111111111111011111111111111111;
logo1[231]=320'b11111001111111111111111111111101011111111111101111111111101110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111011111111111111111;
logo1[232]=320'b11111001101111110111111111111101111111111111101011001110101110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111;
logo1[233]=320'b11011011111111111111011111111101111111100110101011111110101000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111011111111111111111;
logo1[234]=320'b11111010111111110101111111111101011111111111101011111110001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011111111111111111;
logo1[235]=320'b01111011111111111111111111111101111111111111101011111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101011111111111111111;
logo1[236]=320'b11111010110111111111111111111101111111111111101111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111111111111;
logo1[237]=320'b11111011111111111111111111111101111111111111101111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111;
logo1[238]=320'b11111011111111111111111111111101111111111111101111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;


logo2[  0]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  1]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  2]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  3]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  4]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  5]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  6]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  7]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  8]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[  9]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 10]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 11]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 12]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 13]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 14]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 15]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 16]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 17]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 18]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 19]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 20]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 21]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 22]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 23]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 24]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000001111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 25]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000010111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 26]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 27]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 28]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 29]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 30]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 31]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 32]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 33]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 34]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111101100000000000001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 35]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110111111111111111111111111111100000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 36]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000011000100101111111111111111111111011111111000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 37]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111001011001110001010001010011001110000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 38]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 39]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000000001000001000000001001000011011010010010111010100010000010111111110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 40]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 41]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101111101110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 42]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 43]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011110000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 44]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000011111111011011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 45]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110000100011001111111111111111011011111111111111111100110010000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 46]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001010100100000000000000000000001111100000001000001000000110000000111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 47]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111110000111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 48]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111110000000000011111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 49]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000000000000000011111111111111111111111111111111111111110010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 50]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000001111111111111111111110000011100111111000000111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 51]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001111111111111111111100111111100000000110000001111111111111111111111111111111111111111100000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 52]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001111111111111111110001111000000000000000110000111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 53]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001111111111111111100111100000000000000000000010011111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 54]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001111111111111111011110000000000000000000000110000111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 55]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001111111111111110111100000000100000001000000001000011111111111111111111111111111111111110000000000000000000000000000000000001000000000110000000000000000000000000000000000000000000000000000000000;
logo2[ 56]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001111111111111101110000000000100000001000000000000001111111111111111111111111111111111110000000000000000000000000000000000000001111100010000000000000000000000000000000000000000000000000000000000;
logo2[ 57]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001111111111111111100010000000100000001000000000010001111111111111111111111111111111111110000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000;
logo2[ 58]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001111111111111111000010000000100000001000000000001000111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 59]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001111111111111111000010000000100000001000000010000000011111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 60]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001111111111111110000010000000100000001000000010000000001111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 61]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000001111111111111100000010000000100000001000000010000000001111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 62]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000001111111111111100000010000000100000001000000010000000000111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 63]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000001111111110111100000010000000100000001000000010000000000111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 64]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001111111101111000000010000000100000001000000010000000000011111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 65]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001111111101110000000010000000100000001000000010000000010011111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 66]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001111111101110000000010000000100000001000000010000000000000000001111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 67]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001111000111011010000000000000000000000000000000000000000000000001111111111111111111001110000000000000000000000000000000000001010000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 68]=320'b00000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000001001000000000000000000000001001100000000000000000000000000000000000000000000000000000000000011111111111111111000110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 69]=320'b00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000001100100000000100000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 70]=320'b00000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000110110000100000011111110100000000000000011100000000000000000001000000011110011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 71]=320'b00000000000000000001001000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 72]=320'b00000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 73]=320'b00000000000000000100000100000000000000000000000000100000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 74]=320'b00000000000000000000100000000000000000000000000000000000000100000000000000000000000100000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 75]=320'b00000000000000000000000000000000000000000000000000000000000001001111111100011100110010010011000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111000000000010011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 76]=320'b00000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 77]=320'b00000010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 78]=320'b11110111010000001100000000000000000000000000000000000000000000000000000000000000000000000000000000110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 79]=320'b11111111111111101100000000000000000000000000000000000000000000000000000000000000000000000000000000100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 80]=320'b11111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111000000000110000000000000000000000010000010000000000000000000000000000000000000000000000000000000000;
logo2[ 81]=320'b11111111111111111010100000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 82]=320'b11111111111101111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111110000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000;
logo2[ 83]=320'b11111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000;
logo2[ 84]=320'b11100011111111000000000000000000000000000000000000000000000000001111110000111111111100000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 85]=320'b00000011001001000000000000000000000000000000000000000000000000000111100000000111111100000000000000000000001001100000000000000000000000001001111000000000000000000000000000000000000111110000000000000000000000001100011111111110011111111111111100000000011100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 86]=320'b00000000000000100000000000000000000000000000000000000000000000000011100000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111100001111111111111100000000011100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 87]=320'b00000000000000000000000000000000000000000000000000000000000000000011100000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111100001111111111111100000000011100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 88]=320'b00000000000000000000000000000000000000000000000000000000000000000011100000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111100001111111111111100100000011100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 89]=320'b00000000000000000000000000000000000000000000000000000000000000000010000000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110001111111111111100100000011000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 90]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100100000011000000000000000000000000000000000000000000000000000000000000000000001;
logo2[ 91]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100110000011000000000000000000000000000000000000000000000000000000000000000000011;
logo2[ 92]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001111111111111110100000011100000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 93]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110001111111111111110100000010000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 94]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111111110011111111111111111111111111111111111111111111111111111111111111111111111111111100111111111100111111111111001111111111111111100000110000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 95]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111101111111111110000111100000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 96]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011100000010000000000000000000000000000000000100000000000000000000000000000000000000000000001001000000010000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 97]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 98]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[ 99]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000011110000000011100000000111000000000111000000000111000000000111000000001110000000001100000000111110011111111111111111011110001111111111100100000000000000000000000000000000000000000000000000000000000000000;
logo2[100]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000010001100000110011000001100110000011011100000011011100000001000110000011000100000010011100000100011000001000110000000011111111111111111111111111111101100000000000000000000000000000000000000000000000000000000000000111;
logo2[101]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000100001000000000010000000000000000010000100000000000000000000000000000000000000000000000000000000011001111110000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000001;
logo2[102]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000001100000000001000000000010000000000010000000000010000000000010000000000100000000001100000000011011001111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001;
logo2[103]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000001110000000001100000000011000000000011000000000011000000000011000000000110000000001100000000011111101111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000;
logo2[104]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011000000000011000000000110000000001110000000001111101111111111111101111111111111110000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[105]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011000000000011000000000110000000001110000000001111101111111111111100111111011111100000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[106]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011000000000011000000000110000000001110000000001111101111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[107]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011000000000011000000000110000000000110000000001111101111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[108]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011000000000011000000000110000000000110000000001111101111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[109]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011100000000011000000000110000000000110000000001111101111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[110]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011000000000011000000000011100000000011000000000110000000000110000000001111101111111111111111111111101100000000000000000000000000000000000000000000000000000000000000000000000000011;
logo2[111]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011100000000011000000000011100000000011000000000110000000000110000000001111101111101111111111111111100111000000000000000000000000000000000000000000000000000000000000000000000000011;
logo2[112]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111101100111111111111100111000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[113]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111111111111111111111101100000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[114]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111111111111111111111100100000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[115]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111110001111111111111100100000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[116]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111110000111111111111101100000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[117]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111110000111111111111100100000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[118]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000011000000000110000000001111101111110000111111111111100111111000000110000000000000000000000000000000000000000000000000000000000000000;
logo2[119]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000011000000000110000000001111101111110001111111111111100110011000000100000000000000000000000000000000000000000000000000000000000000000;
logo2[120]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000111000000000110000000001111101111010001111111111111110000000011001100000000000000000000000000000000000000000000000000000000000000000;
logo2[121]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000111000000000110000000001100000000011100000000011000000000011100000000011000000000011000000000110000000001111101111111101111111111111111111111110110000000000000000000000000000000000000000000000000000000000000000011;
logo2[122]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000001111000000001110000000011100000000011000000000011100000000011100000000011000000000110000000001111101111000000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000001;
logo2[123]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000111000000001111000000011100000000011000000000011100000000011100000000011000000000110000000001111101111000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000001;
logo2[124]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000111000000001110000000011110000000011000000000011100000000011100000000011000000000110000000001111101111000000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[125]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000111000000001110000000011110000000011000000000011100000000011000000000011000000000110000000001111101111000000001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[126]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000111000000001110000000011110000000011000000000011100000000011100000000011000000000110000000001111101111100000001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000011;
logo2[127]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000111000000001110000000011111110000011000000000011111000000011100000000011000000000110000000001111101111100000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[128]=320'b00000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000100011000000000111000000001110000000011111100000011000000000011111000000011100000000011000000000110000000001111101111000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[129]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011000000000111000000001110000000011111100000011000000000011111000000011100000000011000000000110000000001110101111100000011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000001;
logo2[130]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011010000000111000000001110000000011111100000011000000000011111000000011100000000011000000000110000000001100001110000000011111111111000000000000100000000000000000000000000000000000000000000000000000000000000000000;
logo2[131]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000000111100000001111000000011111100000011000000000011111000000011100000000011000000000110000000001100001100000000011111111111100000000001110000000000000000000000000000000000000000000000000000000000000000000;
logo2[132]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000000111100000001111000000011111100000011000000000011111000000011100000000011000000000110000000001110000000000000011111111111100000000001110000000000000000000000000000000000000000000000000000000000000000011;
logo2[133]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000001111100000001111000000011111100000011000000000011111000000011100000000011000000000110000000001110000000000000011111111111100000000000110000000000000000000000000000000000000000000000000000000000000000111;
logo2[134]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000001111100000001111000000011111100000011000000000011111000000011100000000011000000000110000000001100001000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[135]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000001111100000001111000000011111100000011000000000011111000000011100000000111000000000110000000001100000000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[136]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111010000001111100000001111000000011111100000011000000000011111000000011100000000111000000000110000000001110000000000000111111101111100000000000000000010000000000000000000000000000000000000000000000000000000000111;
logo2[137]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100111010000000111100000001111000000011111100000011000000000011111000000011100000000111000000000110000000001110100000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[138]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111010000001111100000001111000000011111100000011000000000011111000000011100000000111000000000110000000001100100000100000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[139]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111010000001111100000011111000000011111100000011000000000011111000000011100000000111000000000110000000001100100011100000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[140]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111010000001111100000011111000000011111100000011000000000011111000000011100000000111000000000110000000001100100110100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[141]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111011000001111110000001111110000011111100000011000000000011111000000011110000000111100000000110000000000100101110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[142]=320'b00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000011111011000001111110000011111110000111111100000111000000000011111000000011110000000111100000001110000000000000101100010000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000111;
logo2[143]=320'b00000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000000001000000000011101000011111110000111111110000111111100001111100000000111111000000111110000001111100000011110000000000000000000011100000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000111;
logo2[144]=320'b00000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000001100000000000100000011111110000111111110001111100100001111100000001111111001001111111000001111110000011111000000000000000000011011000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000111;
logo2[145]=320'b00000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000001100111111110000000111111110000111111110001111100100001111100000000111111001000111111000000111110000001111000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[146]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000011111111111111111111111111111011001111101001100100111101111110100000111101111001111111110111000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111;
logo2[147]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100111111111111111111111111111111111111111101000000000111111111110011111111111111111011111111110000000111111100000000000000000000000000000000000010001000000000000000000000000000000000000000000000000000000000111;
logo2[148]=320'b00000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000011100111111111111111111111111111111111111111111111111111100100000000111111111111111111111111111110111111111110000000111111100000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000111;
logo2[149]=320'b00000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000001100111111111111111111111111111111111111111111111111111111100000001111111111111111111111111111111101111111100000000111111100000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000111;
logo2[150]=320'b00000000000000000000000000000000100000000000000000000000000000001111000000000000000000000000000001100111111111111111111111111111111111111111111111111111111100000001111111111111111111111111111111111111111100000000111111100000000000000000000000000000000011110001100000000000000000000000000000000000000000000000000000000111;
logo2[151]=320'b00000000000000000000000000000000000000000000000000000000000000011111100000000000000000000000000011100111111111111111111111111111111111111111111111111111111100000000111111111111111111111111111111111111111000000000111111100000000000000000000000000000000011011000000000000000000000000000000000000000000000000000000000000111;
logo2[152]=320'b00000000000000000000000000000000000000000000000000000000000000011111100000000000000000000000000011100111111111001111111111111111111111111111111111111111101100000000111011111111111111111111111111110000010000000000111111100000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000111;
logo2[153]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000111111111000111111111111111111111111111111111111111101100000000110001111111111111111111111111110000000000000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[154]=320'b00000000000000000001101000000111001010000000000111000000000000000000100000000000000000000000000010000001110110000111111111111111111111111111111111111111101100000000100011111111111111111111111111111111100000000000111111100000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000001;
logo2[155]=320'b00000000000000000001111111111111111111111111111111111111111110011111100000000000000000000000000000000111110100001111111111111111111111111111111111111111110000000000000011111111111111111111111111110111100000000000111111000000000000000000000000000000000011111111111111111101111111111110111111111111001110000000000000000101;
logo2[156]=320'b00000000000000000001111111111111111111111111111111111111111010010111100000000000000000000000000000000111100100111110111111111111111111111111111111111111110000000000100011111111111111111111111111001111000000000000111111000000000000010000000000000000000010111111111111111001111111111110111111111111000110000000000000000001;
logo2[157]=320'b10000000000000000001111111111111111111111111111111111111111011111101100000000000000000000000000100000001100001111100011111111111111111111111111111111111101000000000111111111111111111111111111001110110001110000001111110000000000000010000000000000000000111011111111111111101111111111110111111111111001110000000000000000000;
logo2[158]=320'b11111111111111111011111111111111111111111111101110111111111001111111110000000000000000000000000100001111110011111000011111111111111111111111111111111111110000000000111111111111111111111111111000101110001111001001111111100000000000010000000000000000000111111111111111111001111111111100111111111111001110011111011111110011;
logo2[159]=320'b11101111111111111011101111111111100111111111100100001100110001111111111101000000000000000000000000000011110010001000011111111111111111111111111111111000000011111101110011111111111111111111110000011000001111001001111111100000000000010000000000000000100111111110001111111000100111111110100011111111000000011111001100010011;
logo2[160]=320'b11111111111111111111111111111111111111111111111110011111110001111111111111110001111000000011100001000011111110001100011111111111111111111111111111110000000011111111110011111111111111111111110000111100001111111111111111111111111110000000000010000011100111111111111111111001111111111111111111111111111111111111111111111111;
logo2[161]=320'b00000000000000000000000000000000000000000000000000100000000000000000001111110011111111111111111111111111110010001101111111111111111111111111111111111000000011111111100111111111111111111111100000011111011111111111111111111111111000110000000010010001100000000000000000000000000000000000000000000000000000000000000000000000;
logo2[162]=320'b00000000000000000000000000000000000000000000000000000000000000000000011111100011111111111111111111111111100011011111111111111111111111111111111111111000000011111111000111111111111111111111111111111111111111111111111111111111111000000000000010000000100000000000000000000000000000000000000000000000000000000000000000000000;
logo2[163]=320'b11111111111111111111111111111111111111111111000000000000110001111110011111100011111111111111111111111111111111111111111111111111111111111111111111111100000111111111110011111001111111111111111111111111111111111111111111111111111100000000000010100000100111111111111100000000000001111111111111111111111111111111111111111111;
logo2[164]=320'b11111111111111111111111111111111111111111111111000000111110001111110011111100001100100111111111111111111111111111111111111111111110111111111111011110011001111111111110011111001011111111111111111111011111111111111111111111000110000000000000000110000000111111111111111110000011111111111111111111111111111111111111100111111;
logo2[165]=320'b11111111111111111111111111111111111111111111111100001111111001111111110111100001111100011111111111111111111111111111111111111111100111111111110011110011111111111111111111111000011111111111111111111111111111111111111111110001111000000000000000000000000111111111111111111000011111111111111111111111111111111011111100111111;
logo2[166]=320'b11111111111111110111111111111111111111111111111100001111111001011111100010000001111100011111111111111111111111111111111111111111100111111111110001111111111111111111111111110000000111111111111111111011111111111111111111111111111110000111111110000000000111111111100111111000111011111111111111111111111001010011111000110100;
logo2[167]=320'b11111111111111110011111111111111111111111111111100001111111001111111100000010011111100001111111111111111111111111111111111111111100111111111110001111111111111111111111111111000001101111111111111010011111111111111111111111111111111001111111100000000000111111111111111111000001111111111111111111111111111110001110000111111;
logo2[168]=320'b11111111111111110001111111111111111111111111111100000000111001111111110000010011111100011111111111111111111111111111111111111111100111111111110001110011111111110011111111101000000000111111111111000001111111111111111111111111111111110011111100000000000011111101101110011000101111000001111111111111110111110001110000111111;
logo2[169]=320'b11111111111001100000111101100000001111011111111100110000111001111111110001110011111100011111111111111111111111111111111111111111100111111111110001110011111111110011111111000001000000111111111111111111111111111111111111111111111111110011111100000000000000000000000000010001011100000001111110111011110001010001011000111111;
logo2[170]=320'b11000000000000000000000000000000001000000001111111110001111111111111111001110011111100011111111111111111111111111111111110001111100111111111110001100011111111000011111111100000001111111111111111111111111111111111111111111111111111111111111100000100000000000000000000000011000100000001000010010000000000001000000000000001;
logo2[171]=320'b00000000000000000000000000000000000000000000000000000000000000001001110001110011111100011111111111111111111111111111111110001111100111111111111001100011111111000011111111000100001111111111111111111111111111111111111111111111111111111111111000000010000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[172]=320'b00000000000000000000000000000000000000000000000000111111001110001001100011110001111100011111111111111110111111111111111110001111000111101111111000100010111111000011111111100100000111110000000111011011111111111111111100011111111110000001101000000000000000100000000000000000000000000000000000000000000000000000000000000000;
logo2[173]=320'b00000000000000000000000100000000000000000000000011111111001111000110111111010001111100011011111111111111111111111111111110001111111100111111110000100011111111000001111111000100000011111110000001111001111111111111111110110001111111110100001000010000100000000000000000000010000100000000000000000000000000000000000000000000;
logo2[174]=320'b00000000000000000000000100000000000000000000000000000000000000100110001111010000000000011111111111111100000000001000000100001111001111111111100011000011111110000001111111000011111011111111000001110010010000010001000011111000010011111100001000111101100100000011111111011010000100000000000000000000000000000000000000000000;
logo2[175]=320'b00000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000011000000000010000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100011100000000000000000000000000000000000000;
logo2[176]=320'b00000000000000000000000000000000000000000000000000000000000000000110000000000000000000100000000000000000000000000000000000000000110000000000000001000001010010000000100111000000000000010000000000000000000000000010111100000000000000000000000000000000000100000000000000000000000100010000000000000000000000000000000000000000;
logo2[177]=320'b00000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000001000000000001000000000000000000000000000010000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[178]=320'b00000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[179]=320'b00000000000000000000000000000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000100000010000000000000000000000000000000000000;
logo2[180]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000001000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000100000010100100000001000100010000100000100000000000000000000000000000000000000000000;
logo2[181]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000010001000000000001000010001000000000000000000000000000010000000000000000000000100000000100000000100000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[182]=320'b00000000000000000000000000001000000000000000000000000000000000000000000001110001000000000000000000001000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[183]=320'b00000000000000000000000000000000000000000000000010000000000010000000000001010000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[184]=320'b00000000000000000000000000000000000000000000000100000000000001000000000000010000000000000000000000000000000000000000100000100000000000000000000000000000000000000010000000000000000110001011111111000100000000100000000000000001001111111111111110000100100000000000000000000000000000001100000000000000000000000001001011111111;
logo2[185]=320'b00000000000000000000000000000000000000000000001100000000000001110000000000000000000000000000000000001011000111111101111111111101110000111111001111000000000010000010000000000000001111111001111111111100111111100000011110011111111111111111111110000100000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[186]=320'b00000000000000000000000000000000000000000000000000000000000011110000000000000000000000000000011111111111111111111100111111111111111110000111111111000000000010000010000000000000001111001000111111111111000110000000111111111011111111111111111100000100000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[187]=320'b00000000000000000000000000000000000000000000000000000000000111110000000000000000000000000000011111111100111001010000110001100001111111111111111001000000000000000000000000000000001111001111111111111111000000000000100111111011111111111111111100000100000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[188]=320'b00000000000000000000000000000000000000000000000001000000000111111000000000000000000000000000011011111110010000110000010010000011111111111111111000000000000100000000000000000011001111001111111111111111000000000000111111111111111111111111111100000100000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[189]=320'b00000000000000000000000000000000000000000000000000000000000000101000000000000000000000000000011111111111010000111100001000000011000011111100011000000000000100000000000000000010000111001111111111111101100000010000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[190]=320'b00000000000000000000000000000000001000000000000000000000000000101000000000000000000000000000011111111110110000111000000000000001010001111111111000000000000100100000000000000010000111001111111111111111000000010000000111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[191]=320'b00000000000000000000000000000001001000000000000000000000000111101000000000000000000000000000011111111110000000111010000000000011111111111111111001110000000100000000000000000000000111001111111111111111000001000000000010111010111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[192]=320'b00000000000000000000000000000000010100000000000000000000000011111000000000000000000000000000011110000001000000101010000000000011111111111111111001111111111110011110111111111000111101001011110111110011000001010000000010010000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[193]=320'b00000000000000000000000000000000000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[194]=320'b00000000000000000000000000000000100000000000000000000000001101110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[195]=320'b00000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[196]=320'b00000000000000000000000000000000111100000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[197]=320'b00000000000000000000000000000000010100000000000000000000000000000000000000000000001100000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000;
logo2[198]=320'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000;
logo2[199]=320'b00000000000000000000000000000000000000000000000000000000000000110000000000000000000000100000010000100100010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000000000000000001100100000000000000000000000000000000000000000000000000000000000000000000;
logo2[200]=320'b00000000000000000000000000000000010000000000000000000000000000010000000000011000000000000000000000100000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000;
logo2[201]=320'b00000000000000000000000000000001110000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000011000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000;
logo2[202]=320'b00000000000000000000000000000001100000000000000000000000000000010011000000000000000100000000001000000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011000100000001000000000000000000010000000000000000000000000000000000000000000000000000000000;
logo2[203]=320'b00000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000000100000000000010000000000000000000000000000000000000000000000000000000000;
logo2[204]=320'b00000000000000000000000000100000000000000000000000000000000000011100000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[205]=320'b00000000000000000000000000000100000000000000000000000000000000111100000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[206]=320'b00000000000000000000000000000011000000000000000000000000000001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001100100000010010000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[207]=320'b00000000000000000000000000000011000000000000000000010000000001011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[208]=320'b00000000000000000000000000000011000000000000000000000000000000111111000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[209]=320'b00000000000000000000000000000000000000000001100000000000000000111010000000000000100001000000000000100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[210]=320'b00000000000000000000000000000000000100101100000000000000000100011001000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[211]=320'b00000000000000000000000000000000000000100000000000000000000100011100000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[212]=320'b00000000000000000000000000000000001001000000000000000000000000011000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[213]=320'b00000000000000000000000000000000000001000000000000000010100001111100000000000000100101001000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[214]=320'b00000000000000000000000000000000000000000000000000000000000001101100010000000000100101001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[215]=320'b00000000000000000000001000000000000000000000000000000000000001100000010000000010000110000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[216]=320'b00000000000000000110000000000000000000000000000000000010000000000100010000000000000100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[217]=320'b00000000000000110000000000000000000000000000000000000000000001111110000000000101000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[218]=320'b00000000001000000000000000000000100000000000000000000000000000100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[219]=320'b00000001000000000000000000000001100000000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[220]=320'b00000000000000000000000000000001100000000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[221]=320'b10000000000000000000000000000001001010010000000000000000000000000000000011100000000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[222]=320'b00111100000000000000000000000000100010010000100000000000000000000010000111111000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[223]=320'b00000011111111111100000000000000001110010000100100011111100100000010000100111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[224]=320'b00000000000000000000000000000000000000000010100100000000000100000110010100111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[225]=320'b00000000000000000000000000000000100000000000100100000000000100100000010111110000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[226]=320'b00000000100001000000110011110000100000000001100101100001100100000110010011100000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[227]=320'b00000000000000000000000000000000101000000000000000011110100100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[228]=320'b00000001000000000000000000000000100000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000;
logo2[229]=320'b00010000000111110000000000000000100000000000000100000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110011100000000000000000000000000000000000000;
logo2[230]=320'b00010000000000000000000000000000000000000000000101111000000100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000;
logo2[231]=320'b00000000000000000000000000000000100000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[232]=320'b00000000010000001000000000000000000000000000000100010001000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[233]=320'b00100000000000000000100000000000000000000001000100000001000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000;
logo2[234]=320'b00000001000000000010000000000000000000000000000100000001100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000;
logo2[235]=320'b10000000000000000000000000000000000000000000000100000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000;
logo2[236]=320'b00000001000000000000000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000;
logo2[237]=320'b00000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
logo2[238]=320'b00000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;



name[  0]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[  1]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[  2]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[  3]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[  4]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[  5]=160'b0000001111100000000000000000000000000000000000000000000000000000000000001110011100000000000000001100000000000000000000111111100000000000000000000000000000000000;
name[  6]=160'b0000001111110000000000000000000000000000000000000000000000000000000000000111111000000000000000011100000000000000000000111111110000000000000000000000000000000000;
name[  7]=160'b0000001110110011011000000000000000000000000000000110000000000000000000000011110011001100011100011100011100000111000000111111111000111000011100001111000000000000;
name[  8]=160'b0000001111110111011000000000000000000000000000001110000000000000000000000011110011101100111110011000111110001111100000111000111011111100111110011111100000000000;
name[  9]=160'b0000001111110111011000000000000000000000000000001110000000000000000000000001100011101100111110011101111111001111100000111000111011111100111110011111100000000000;
name[ 10]=160'b0000001111110111011000000000000000000000000000000000000000000000000000000001100011101101110110011101110111011101110000111000111011001110110111011001100000000000;
name[ 11]=160'b0000001110111111111000000000000000000000000000000110000000000000000000000001100011111101110110011101110011011101100000111011111011111100110110011111100000000000;
name[ 12]=160'b0000001111110111111000000000000000000000000000001110000000000000000000000001100011111101110110011000111111011101110000111111110011111101110111011111100000000000;
name[ 13]=160'b0000001111100011111000000000000000000000000000001110000000000000000000000001100001111001110110011000011111011101100000111111100001111001110111001101100000000000;
name[ 14]=160'b0000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000;
name[ 15]=160'b0000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000000000;
name[ 16]=160'b0000000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000;
name[ 17]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 18]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 19]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 20]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 21]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 22]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 23]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 24]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 25]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 26]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 27]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 28]=160'b0000011111110000000011000000000000000000000000000000000000000000000000000000011110000000000000000110000000000011110000011100000000000000000000000000001110000000;
name[ 29]=160'b0000011111110000000011000000000000000000000000000000000000000000000000000000111111000000000000001110000000000111110000011100000000000000000000000000001110000000;
name[ 30]=160'b0000011111110110010011000001100000100000000000000001000000000000000000000001111111000110001100001110000000001111100001011101100100110000110000001000101110000100;
name[ 31]=160'b0000000111000110111011100111110001110000000000000011100000000000000000000001110111001110111111011100000000001111000011111101111110110011111100111001111110011100;
name[ 32]=160'b0000000111000110111011101111111011110000000000000011100000000000000000000001111111001110111111011110000000001111110111111101111110110011111100111011111110011100;
name[ 33]=160'b0000000111000110111011001110111011100000000000000000000000000000000000000001111110011100110011011110000000001111100110011101111110110111001100110011101110011100;
name[ 34]=160'b0000000111000110111011101110111011100000000000000001100000000000000000000001110000011100110011011110011000001111000111011101111110110111001100110011101110111000;
name[ 35]=160'b0000000111000111110011100111111011100000000000000011100000000000000000000001110000011100111111011100111100000111110111111001111111110011111100110011111100111000;
name[ 36]=160'b0000000111000011110001100111110011100000000000000011100000000000000000000001110000011100011110011100011000000111110011110000111111100001111100110001111100110000;
name[ 37]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 38]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 39]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 40]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 41]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 42]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
name[ 43]=160'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

title[  0]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[  1]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[  2]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[  3]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[  4]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[  5]=200'b00011111111111111111101111111111111110001111111111111111110000011111110000000011111110000000111111100000000000000000001111110000000000000000011111100000000001111111000001111111000011111111111111100000;
title[  6]=200'b00011111111111111111100111111111111110001111111111111111110011111111111100000001111101000011111111111000000000000000111111111111100000000000011111100000000000111110000000111111000001111111111111100000;
title[  7]=200'b00011001111111100111000011101111011100000110011111111001100011110111011110000000111110000111100001111000000000000001110011101111000000000000001111000000000000111110000000011111000000111011110111000000;
title[  8]=200'b00001010001111000011000011111000001100000100000111100001100001111100001111000000111110000111100000110000000000000011100100000111000000000000011111100000000000111110000000111111000000111110000011000000;
title[  9]=200'b00000000001110000000000011111000000000000000000111100000100011111100000111110000111110001111000000010000000000000111101000000010000000000000011111100000000000111110000000111111000000111110000000000000;
title[ 10]=200'b00000000001111000000000011111000000000000000000111100000000011111100000111110000111110001111000000000000000000000111010000000000000000000000010111100000000000111111000001111111000000111110000000000000;
title[ 11]=200'b00000000001111000000000011111000110000000000000111100000000011111100000111010000111110001111100000000000000000000111010100000000000000000000110011110000000000111111000001111111000000111110001100000000;
title[ 12]=200'b00000000001111000000000011111000111000000000000111100000000011111100001110100000111110000111110000000000000000001111011110000000000000000010110001110110000000111111000001011111000000111110011100000000;
title[ 13]=200'b00000000001111000000000111111111111000000000000111100000000011111000111100000000111110000111111111000000000000001111011111111111110000000111100001111110000000111111100011011111000011111111111100000000;
title[ 14]=200'b00000000001111000000011111111111111000000000000111100000000001111111111000000000111110000011111111110000000000001111110111111111111000000111100001111110000000111111100011011111000111111111111100000000;
title[ 15]=200'b00000000001111000000010111111111111000000000000111100000000111111111110100000000111110000001111111111000000000001111010011111111110000000011110001111011100000111011100010011111000101111011111100000000;
title[ 16]=200'b00000000001111000000000011111000111000000000000111100000001111110000110000000000111110000000000111111100000000001111010000000111110000000011111001111100000000111001110110011111000001111110001100000000;
title[ 17]=200'b00000000001111000000000011111000000000000000000111100000000001111100111000000000111110000000000001111111000000001111000000000111110000000011011111111100000000111101110110011111000000111110000100000000;
title[ 18]=200'b00000000001111000000000011111000000000000000000111100000000001111100011000000000111110000000000000011111000000000111000000000111110000000011001110011110000000111101110100011111000000111110000000000000;
title[ 19]=200'b00000000001111000000000011111000000000000000000111100000000001111100011100000000111110000100000000011111000000000111100000000111110000000110000100011110000000111101111100011111000000111110000000000000;
title[ 20]=200'b00000000001111000000000011111000000100000000000111100000000001111100011110000000111110001100000000011111000000000011100000000111110000000111000000001110000000111100111100011111000000111110000011000000;
title[ 21]=200'b00000000001111000000000011111000001110000000000111100000000001111100001110000000111110001110000000011110000000000001110000000111110000001111000000001111000000111000111000011111000000111110000011000000;
title[ 22]=200'b00000000011111000000000011111000111110000000000111100000000001111000001111000000111110011111000000111110000000000000111110000111110000011111000000001111000000111000111000011111000001111110001111100000;
title[ 23]=200'b00000000111111000000001111111111111111000000001111110000000011111100001111100001111110011111111111111100000000000000011111111111110000111111000000011111100001111100011000111111100011111111111111110000;
title[ 24]=200'b00000000111111100000000111111111111111110000001111111000000011111110000111100101111111101111111111110000000000000000000111111111111100111111110000011111111111111110001000111111110001111111111111111100;
title[ 25]=200'b00000000111111100000000111111111111111100000001111111000000011111110000110000001111111100000001111000000000000000000000111111111111100111111110000001111111111111110001000011111110001111111111111111000;
title[ 26]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[ 27]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[ 28]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
title[ 29]=200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;


    
	if (iscoreofplayer < 10) 
	begin 
	digit1 = tdigit0  ; 
	digit2 = 7'b0111111 ;
	digit3 = 7'b0111111 ;  
	end

	else if (iscoreofplayer < 20) 
	begin
	digit1 = tdigit1  ; 
	digit2 = 7'b0000110 ;
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 30) 
	begin 
	digit1 = tdigit2  ; 
	digit2 = 7'b1011011 ; 
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 40) 
	begin 
	digit1 = tdigit3  ; 
	digit2 = 7'b1001111 ; 
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 50) 
	begin 
	digit1 = tdigit4  ; 
	digit2 = 7'b1100110 ;  
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 60) 
	begin 
	digit1 = tdigit5  ; 
	digit2 = 7'b1101101 ; 
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 70) 
	begin 
	digit1 = tdigit6  ; 
	digit2 = 7'b1111101 ;
	digit3 = 7'b0111111 ; 
	end

	else if (iscoreofplayer < 80) 
	begin 
	digit1 = tdigit7  ; 
	digit2 = 7'b0000111 ; 
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 90) 
	begin 
	digit1 = tdigit8  ; 
	digit2 = 7'b1111111 ;
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 100) 
	begin 
	digit1 = tdigit9  ; 
	digit2 = 7'b1100111 ; 
	digit3 = 7'b0111111 ;
	end
	
	logo_x = 360;
	logo_y = 320;
	


end




//	Pixel LUT Address Generator
always@(posedge iCLK or negedge iRST_N)
begin

	logo_tempx = H_Cont - X_START - logo_x;
	logo_tempy = V_Cont - Y_START - logo_y;

	if(!iRST_N)
	begin
		oCoord_X	<=	0;
		oCoord_Y	<=	0;
		oAddress	<=	0;
	end
	else
	begin
		if( H_Cont>=X_START && H_Cont<X_START+H_SYNC_ACT &&
			V_Cont>=Y_START && V_Cont<Y_START+V_SYNC_ACT )
		begin
			oCoord_X	<=	H_Cont-X_START;
			oCoord_Y	<=	V_Cont-Y_START;
			oAddress	<=	oCoord_Y*H_SYNC_ACT+oCoord_X-3;
		end
	end
	
end

//	Cursor Generator	
always@(posedge iCLK or negedge iRST_N)
begin
	logo_V = (V_Cont - Y_START - 120 ) % 239;
   logo_H = (H_Cont - X_START - 160 ) % 319;
	
	name_V = (V_Cont - Y_START - 402 + 22  ) % 43;
	name_H = (H_Cont - X_START - 480 + 80  ) % 159;
	
	title_V= (V_Cont - Y_START -5 )% 29;
	title_H= (H_Cont - X_START - 220)% 199;
	
	logo_tempx = H_Cont - X_START - logo_x;
	logo_tempy = V_Cont - Y_START - logo_y;
	
	logo_Row = logo0[logo_V];
	logo_Row1= logo1[logo_V];
	logo_Row2= logo2[logo_V];
	
	name_Row = name[name_V];
	
	title_Row = title[title_V];

	//*********************reset************************
	if(!iRST_N)
	begin
		Cur_Color_R	<=	0;
		Cur_Color_G	<=	0;
		Cur_Color_B	<=	0;

	end
	
	//******************** !reset ***********************
	else
	
	begin
		if(	H_Cont>=X_START+8 && H_Cont<X_START+H_SYNC_ACT+8 &&
			V_Cont>=Y_START && V_Cont<Y_START+V_SYNC_ACT )
		  begin
			 if( (	(H_Cont==X_START + 8 + iCursor_X) 	||
					(H_Cont==X_START + 8 + iCursor_X+1) ||
					(H_Cont==X_START + 8 + iCursor_X-1) ||
			 		(V_Cont==Y_START + iCursor_Y)	||
					(V_Cont==Y_START + iCursor_Y+1)	||
					(V_Cont==Y_START + iCursor_Y-1)	)
					&& mCursor_EN )
			begin
				Cur_Color_R	<=	iCursor_R;
				Cur_Color_G	<=	iCursor_G;
				Cur_Color_B	<=	iCursor_B;
			end
			
  //********************logo and welcome**********************************************************************************************
     //layer one
	  /*
	  
		else if((gamestage == 0) && (H_Cont-X_START<480) && (H_Cont-X_START>160) && (V_Cont-Y_START<360) &&(V_Cont-Y_START > 120) && (logo_Row[logo_H] == 1) )	
			begin
			 Cur_Color_R = 880;
			 Cur_Color_G = 880;
			 Cur_Color_B = 880;
			end
			*/
		
	//layer two
	   else if((gamestage != 1)&& (H_Cont-X_START<480) && (H_Cont-X_START>160) && (V_Cont-Y_START<360) &&(V_Cont-Y_START > 120) && (logo_Row1[logo_H] == 1) )
	 	
			begin
			
			 Cur_Color_R = 656;
			 Cur_Color_G = 844;
			 Cur_Color_B = 952;
			end
			
	//  layer three	
		else if((gamestage !=1) && (H_Cont-X_START<480) && (H_Cont-X_START>160) && (V_Cont-Y_START<360) &&(V_Cont-Y_START > 120) && (logo_Row2[logo_H] == 1) )
		
			begin
			 Cur_Color_R = 421;
			 Cur_Color_G = 421;
			 Cur_Color_B = 421;
			end
	//name
		else if((gamestage != 1) && (H_Cont-X_START<560) && (H_Cont-X_START>400) && (V_Cont-Y_START<425) &&(V_Cont-Y_START > 380) && (name_Row[160 - name_H] == 1) )
		
			begin
			 Cur_Color_R = 0;
			 Cur_Color_G = 0;
			 Cur_Color_B = 512;
			end
			
		else if((gamestage != 1) && (H_Cont-X_START<420) && (H_Cont-X_START> 220) && (V_Cont-Y_START<70) &&(V_Cont-Y_START > 40) && (title_Row[200 - name_H] == 1) )
		
			begin
			 Cur_Color_R = 0;
			 Cur_Color_G = 0;
			 Cur_Color_B = 0;
			end
  //********************input interface (main frame)*******************************************************************************
				else if( (((V_Cont - Y_START) >460 ) && ((V_Cont - Y_START) < 470)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 580)) )
			begin
			  Cur_Color_R <= 10'b1111111111;
			
			end
			
			//******************drawing blocks***************************
			//*************************************************
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[9]}} ;
				Cur_Color_G	<=	0;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 420 ) && ((V_Cont - Y_START) < 440)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//*************************************************************************************
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 400 ) && ((V_Cont - Y_START) < 420)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//**********************************************************************************************************
			
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 380 ) && ((V_Cont - Y_START) < 400)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow191817[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			
			//*************************************************
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[9]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 360 ) && ((V_Cont - Y_START) < 380)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//*************************************************************************************
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 340 ) && ((V_Cont - Y_START) < 360)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//**********************************************************************************************************
			
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 320 ) && ((V_Cont - Y_START) < 340)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow161514[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			
			//*************************************************
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[9]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 300 ) && ((V_Cont - Y_START) < 320)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//*************************************************************************************
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 280 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//**********************************************************************************************************
			
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 260 ) && ((V_Cont - Y_START) < 280)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow131211[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			
			
			//*************************************************
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[9]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 240 ) && ((V_Cont - Y_START) < 260)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//*************************************************************************************
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 220 ) && ((V_Cont - Y_START) < 240)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//**********************************************************************************************************
			
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 200 ) && ((V_Cont - Y_START) < 220)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow1098[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			
			
			//*************************************************
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[9]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 180 ) && ((V_Cont - Y_START) < 200)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//*************************************************************************************
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 180)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			
			//**********************************************************************************************************
			
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 160)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow765[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[9]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[8]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[7]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[6]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[5]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[4]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[3]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[2]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[1]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 120 ) && ((V_Cont - Y_START) < 140)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[0]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[19]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[18]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[17]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[16]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[15]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[14]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[13]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[12]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[11]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 100 ) && ((V_Cont - Y_START) < 120)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[10]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			//**********************************************************************
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 380 ) && ((H_Cont - X_START) < 400)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[29]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 400 ) && ((H_Cont - X_START) < 420)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[28]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 420 ) && ((H_Cont - X_START) < 440)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[27]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 440 ) && ((H_Cont - X_START) < 460)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[26]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 460 ) && ((H_Cont - X_START) <480)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[25]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 480 ) && ((H_Cont - X_START) < 500)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[24]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 500 ) && ((H_Cont - X_START) < 520)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[23]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 520 ) && ((H_Cont - X_START) < 540)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[22]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 540 ) && ((H_Cont - X_START) < 560)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[21]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
			else if( (((V_Cont - Y_START) > 80 ) && ((V_Cont - Y_START) < 100)) && (((H_Cont - X_START) > 560 ) && ((H_Cont - X_START) < 580)) )
			begin
				
				Cur_Color_R	<=	{10{irow432[20]}} ;
				Cur_Color_G	<=	0 ;
				Cur_Color_B	<=	0;
			end
			
	
			
			
	//********************score digits**********************************************************************************************
			else if( (((V_Cont - Y_START) > 140 ) && ((V_Cont - Y_START) < 300)) && (((H_Cont - X_START) > 270 ) && ((H_Cont - X_START) < 370)) )
			begin
				if((((H_Cont - X_START) > 280 ) && ((H_Cont - X_START) < 300)))
				begin
					 if(((V_Cont - Y_START) == 150 ))
					 begin
					 Cur_Color_R	<=	{10{digit3[0]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 160 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[6]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 170 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[3]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 281 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[5]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 299 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[1]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 281 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[4]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 299 ))
					 begin
				     Cur_Color_R	<=	{10{digit3[2]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else
					 begin
					 Cur_Color_R	<=	0 ;
				     Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0;
				     end

				end
				
				else if((((H_Cont - X_START) > 310 ) && ((H_Cont - X_START) < 330)))
				begin
				if(((V_Cont - Y_START) == 150 ))
					 begin
					 Cur_Color_R	<=	{10{digit2[0]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 160 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[6]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 170 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[3]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 311 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[5]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 329 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[1]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 311 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[4]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 329 ))
					 begin
				     Cur_Color_R	<=	{10{digit2[2]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else
					 begin
					 Cur_Color_R	<=	0 ;
				     Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0;
				     end
				end
				
				else if((((H_Cont - X_START) > 340 ) && ((H_Cont - X_START) < 360)))
				begin
				if(((V_Cont - Y_START) == 150 ))
					 begin
					 Cur_Color_R	<=	{10{digit1[0]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 160 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[6]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if(((V_Cont - Y_START) == 170 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[3]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 341 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[5]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 150 ) && ((V_Cont - Y_START) < 160)) && ((H_Cont - X_START) == 359 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[1]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 341 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[4]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if ((((V_Cont - Y_START) > 160 ) && ((V_Cont - Y_START) < 170)) && ((H_Cont - X_START) == 359 ))
					 begin
				     Cur_Color_R	<=	{10{digit1[2]}} ;
					 Cur_Color_G	<=	0 ;
					 Cur_Color_B	<=	0 ; 
					 end
					 
					 else if (gamestage ==0)
					 begin
			        Cur_Color_R = 656;
			        Cur_Color_G = 844;
			        Cur_Color_B = 952;
				     end

			
				end
				
				else if(gamestage == 0)
				begin
				Cur_Color_R	<=	656 ;
				Cur_Color_G	<=	844 ;
				Cur_Color_B	<=	952;
				end
			end 
			 
			//***************************************************************************
			else if ((gamestage == 0))
			begin
				Cur_Color_R	<=	656;
				Cur_Color_G	<=	844;
				Cur_Color_B	<=	952;
			end			
		end
	end
end

//	H_Sync Generator, Ref. 25.175 MHz Clock
always@(posedge iCLK or negedge iRST_N)
begin
	if(!iRST_N)
	begin
		H_Cont		<=	0;
		oVGA_H_SYNC	<=	0;
	end
	else
	begin
		//	H_Sync Counter
		if( H_Cont < H_SYNC_TOTAL )
		H_Cont	<=	H_Cont+1;
		else
		H_Cont	<=	0;
		//	H_Sync Generator
		if( H_Cont < H_SYNC_CYC )
		oVGA_H_SYNC	<=	0;
		else
		oVGA_H_SYNC	<=	1;
	end
end

//	V_Sync Generator, Ref. H_Sync
always@(posedge iCLK or negedge iRST_N)
begin
	if(!iRST_N)
	begin
		V_Cont		<=	0;
		oVGA_V_SYNC	<=	0;
	end
	else
	begin
		//	When H_Sync Re-start
		if(H_Cont==0)
		begin
			//	V_Sync Counter
			if( V_Cont < V_SYNC_TOTAL )
			V_Cont	<=	V_Cont+1;
			else
			V_Cont	<=	0;
			//	V_Sync Generator
			if(	V_Cont < V_SYNC_CYC )
			oVGA_V_SYNC	<=	0;
			else
			oVGA_V_SYNC	<=	1;
		end
	end
end

endmodule




//***************************for the scoring display**************************************************
module hexout(
input wire [15:0] value , 
output reg  [6:0] outvalue
);

wire [3:0] tempvalue ; 
assign tempvalue = value[3:0] ; 


always @ (value)
 case(tempvalue)
	4'd0 : outvalue = 7'b0111111 ; 
	4'd1 : outvalue = 7'b0000110 ; 
	4'd2 : outvalue = 7'b1011011 ; 
	4'd3 : outvalue = 7'b1001111 ; 
	4'd4 : outvalue = 7'b1100110 ; 
	4'd5 : outvalue = 7'b1101101 ; 
	4'd6 : outvalue = 7'b1111101 ; 
	4'd7 : outvalue = 7'b0000111 ; 
	4'd8 : outvalue = 7'b1111111 ; 
	4'd9 : outvalue = 7'b1100111 ; 
    default : outvalue = 7'b0111111 ;
 endcase 

endmodule 

//mycode ends