/*-------------------------------------------------------------------------------
--
-- Developed VGA raster display  
-- Verilog Edition.
-- Tutor: Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------*/

module	VGA_Controller(	//	Host Side
						iCursor_RGB_EN,
						iCursor_X,
						iCursor_Y,
						iCursor_R,
						iCursor_G,
						iCursor_B,
						iRed,
						iGreen,
						iBlue,
						iFlag,
						//iFlag1,
						oAddress,
						oCoord_X,
						oCoord_Y,
						
						//	VGA Side
						oVGA_R,
						oVGA_G,
						oVGA_B,
						oVGA_H_SYNC,
						oVGA_V_SYNC,
						oVGA_SYNC,
						oVGA_BLANK,
						oVGA_CLOCK,
						//	Control Signal
						iCLK,
						iRST_N,
						
						iscoreofplayer	);

`include "VGA_Param.h"

//	Host Side
output	reg	[19:0]	oAddress;
output	reg	[9:0]	oCoord_X;
output	reg	[9:0]	oCoord_Y;
input		[3:0]	iCursor_RGB_EN;
input		[9:0]	iCursor_X;
input		[9:0]	iCursor_Y;
input		[9:0]	iCursor_R;
input		[9:0]	iCursor_G;
input		[9:0]	iCursor_B;
input		[9:0]	iRed;
input		[9:0]	iGreen;
input		[9:0]	iBlue;
input    [7:0] iFlag;

//rowinputs

input       [15:0]  iscoreofplayer ;




//	VGA Side
output		[9:0]	oVGA_R;
output		[9:0]	oVGA_G;
output		[9:0]	oVGA_B;
output	reg			oVGA_H_SYNC;
output	reg			oVGA_V_SYNC;
output				oVGA_SYNC;
output				oVGA_BLANK;
output				oVGA_CLOCK;
//	Control Signal
input				iCLK;
input				iRST_N;

//	Internal Registers and Wires
reg		[9:0]		H_Cont;
reg		[9:0]		V_Cont;
reg		[9:0]		Cur_Color_R;
reg		[9:0]		Cur_Color_G;
reg		[9:0]		Cur_Color_B;
wire				mCursor_EN;
wire				mRed_EN;
wire				mGreen_EN;
wire				mBlue_EN;
//reg            mFlag;

//assign   mFlag = iFlag;
assign	oVGA_BLANK	=	oVGA_H_SYNC & oVGA_V_SYNC;
assign	oVGA_SYNC	=	1'b0;
assign	oVGA_CLOCK	=	iCLK;
assign	mCursor_EN	=	iCursor_RGB_EN[3];
assign	mRed_EN		=	iCursor_RGB_EN[2];
assign	mGreen_EN	=	iCursor_RGB_EN[1];
assign	mBlue_EN	=	iCursor_RGB_EN[0];

assign	oVGA_R	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mRed_EN	?	Cur_Color_R	:	0)	:	0;
assign	oVGA_G	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mGreen_EN	?	Cur_Color_G	:	0)	:	0;
assign	oVGA_B	=	(	H_Cont>=X_START+9 	&& H_Cont<X_START+H_SYNC_ACT+9 &&
						V_Cont>=Y_START 	&& V_Cont<Y_START+V_SYNC_ACT )
						?	(mBlue_EN	?	Cur_Color_B	:	0)	:	0;


//my code
//digit logic calculation 
reg [6:0] digit1 , digit2, digit3 ;
wire [6:0] tdigit0 ,  tdigit1 , tdigit2 , tdigit3 , tdigit4 , tdigit5 , tdigit6 , tdigit7 , tdigit8 , tdigit9 ;



//*****************sprites************//

reg  [639:0] back_2 [479:0];
reg  [199:0] ready [27:0];



reg  [79:0] level1 [29:0];
reg  [79:0] level2 [29:0];
reg  [79:0] level3 [25:0];

reg  [159:0] name [43:0];
reg  [159:0] name_Row;

reg  [199:0] title[29:0];
reg  [199:0] title_Row;

reg  [319:0] columbia [229:0];
reg  [319:0] columbia_Row;

reg  [131:0] lion [121:0];
reg  [131:0] lion_Row;

reg  [79:0] score [23:0];


reg  [9:0]name_V,name_H;
reg  [9:0]title_V,title_H;
reg  [9:0]columbia_V,columbia_H;
reg  [9:0]score_V,score_H;

reg  [9:0]ready_V,ready_H;

reg  [9:0]back_V,back_H;
reg  [9:0]level1_V,level2_V,level3_V,level1_H,level2_H,level3_H;

reg  [9:0]lion_V [19:0];
reg  [9:0]lion_H [19:0];



hexout u1(iscoreofplayer       , tdigit0) ; 
hexout u2(iscoreofplayer - 10  , tdigit1) ;
hexout u3(iscoreofplayer - 20  , tdigit2) ;
hexout u4(iscoreofplayer - 30  , tdigit3) ;
hexout u5(iscoreofplayer - 40  , tdigit4) ;
hexout u6(iscoreofplayer - 50  , tdigit5) ;
hexout u7(iscoreofplayer - 60  , tdigit6) ;
hexout u8(iscoreofplayer - 70  , tdigit7) ;
hexout u9(iscoreofplayer - 80  , tdigit8) ;
hexout u10(iscoreofplayer - 90  , tdigit9) ;



always @ (*)
begin
	if (iscoreofplayer < 10) 
	begin 
	digit1 = tdigit0  ; 
	digit2 = 7'b0111111 ;
	digit3 = 7'b0111111 ;  
	end

	else if (iscoreofplayer < 20) 
	begin
	digit1 = tdigit1  ; 
	digit2 = 7'b0000110 ;
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 30) 
	begin 
	digit1 = tdigit2  ; 
	digit2 = 7'b1011011 ; 
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 40) 
	begin 
	digit1 = tdigit3  ; 
	digit2 = 7'b1001111 ; 
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 50) 
	begin 
	digit1 = tdigit4  ; 
	digit2 = 7'b1100110 ;  
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 60) 
	begin 
	digit1 = tdigit5  ; 
	digit2 = 7'b1101101 ; 
	digit3 = 7'b0111111 ;
	end


	else if (iscoreofplayer < 70) 
	begin 
	digit1 = tdigit6  ; 
	digit2 = 7'b1111101 ;
	digit3 = 7'b0111111 ; 
	end

	else if (iscoreofplayer < 80) 
	begin 
	digit1 = tdigit7  ; 
	digit2 = 7'b0000111 ; 
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 90) 
	begin 
	digit1 = tdigit8  ; 
	digit2 = 7'b1111111 ;
	digit3 = 7'b0111111 ;
	end

	else if (iscoreofplayer < 100) 
	begin 
	digit1 = tdigit9  ; 
	digit2 = 7'b1100111 ; 
	digit3 = 7'b0111111 ;
	end
level1[  0] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  1] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  2] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  3] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  4] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  5] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  6] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[  7] = 80'b00000000000000111000000000000000000000000000000000000000001110000000000000000000;
level1[  8] = 80'b00000000000001111000000000000000000000000000000000000000010111000000000000011100;
level1[  9] = 80'b00000000000001111000000000000000000000000000000000000000110111000000000011111000;
level1[ 10] = 80'b00000000000011111000000000000000000000000000000000000001100111000000000011111000;
level1[ 11] = 80'b00000000000011110000000000000000000000000000000000000001100110000000000000111000;
level1[ 12] = 80'b00000000000011110000000011110001000000100000001110000011000110000000000001110000;
level1[ 13] = 80'b00000000000111100000000111110011100001100000111111000111000110000000000001110000;
level1[ 14] = 80'b00000000000111100000011100110011100001100001100111000111001100000000000001110000;
level1[ 15] = 80'b00000000000111100000111000110011100011000011100110001110001000000000000011100000;
level1[ 16] = 80'b00000000000111000000111000100011100111000011000110001110010000000000000011100000;
level1[ 17] = 80'b00000000001111000001110001100011100110000111000100001110000000000000000111000000;
level1[ 18] = 80'b00000000001110000001110010000001100100000111001000001110000100000000000111000000;
level1[ 19] = 80'b00000000001110000001110000010001111100001111000010011110001100000000000111000000;
level1[ 20] = 80'b00000000001110000001110000100001111000001111000100001111111000000000001110000000;
level1[ 21] = 80'b00000000011111110000111110000001110000000111111000001111110000000000001110000000;
level1[ 22] = 80'b00000000001111000000011000000000000000000001000000000011000000000000001100000000;
level1[ 23] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 24] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 25] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 26] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 27] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 28] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level1[ 29] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;

	
level2[  0] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[  1] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[  2] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[  3] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[  4] = 80'b00000000111100000000000000000000000000000000000000000000011100000000000000010000;
level2[  5] = 80'b00000001111100000000000000000000000000000000000000000000111110000000000001111100;
level2[  6] = 80'b00000001111100000000000000000000000000000000000000000001001110000000000010011110;
level2[  7] = 80'b00000001111000000000000000000000000000000000000000000011001110000000000110001111;
level2[  8] = 80'b00000011111000000000000000000000000000000000000000000110001110000000000110001110;
level2[  9] = 80'b00000011110000000000010000010000000000000000010000000110001100000000000110001110;
level2[ 10] = 80'b00000011110000000011111100111000001100000011111000001100011100000000000110001100;
level2[ 11] = 80'b00000111110000000111011100111000011100000110011100011100011100000000000010001100;
level2[ 12] = 80'b00000111100000001110011100111100011000001110011100011100011000000000000000011000;
level2[ 13] = 80'b00000111100000011100011100111100011000011100011000111000110000000000000000110000;
level2[ 14] = 80'b00000111000000011100011000111100110000111000011000111001000000000000000000100000;
level2[ 15] = 80'b00001111000000111000010000111101100000111000110000111000000000000000000001100000;
level2[ 16] = 80'b00001111000000111000100000011101100000111001000000111000001000000000000011000000;
level2[ 17] = 80'b00001111000000111000001100011111000001111000001000111000011000000000000111111110;
level2[ 18] = 80'b00011110000100111100010000011110000001111000010000111111110000000000001111111100;
level2[ 19] = 80'b00011111111000111111100000011100000000111111000000011111000000000000001111111000;
level2[ 20] = 80'b00001111100000001100000000000000000000001000000000000100000000000000000001100000;
level2[ 21] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 22] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 23] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 24] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 25] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 26] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 27] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 28] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level2[ 29] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;


level3[  0] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[  1] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[  2] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[  3] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[  4] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[  5] = 80'b00000000000011000000000000000000000000000000000000000000010000000000000000000000;
level3[  6] = 80'b00000000001111000000000000000000000000000000000000000001111000000000000000111000;
level3[  7] = 80'b00000000001111000000000000000000000000000000000000000011011000000000000011111100;
level3[  8] = 80'b00000000001111000000000000000000000000000000000000000110011000000000000110011110;
level3[  9] = 80'b00000000011111000000000000000000000000000000000000000100011000000000000110011100;
level3[ 10] = 80'b00000000011110000000000000000000000000000000000000001100011000000000000100011100;
level3[ 11] = 80'b00000000111110000000001110001100000100000001110000011100111000000000000000010000;
level3[ 12] = 80'b00000000111100000000111110001100001100000111111000011000110000000000000000110000;
level3[ 13] = 80'b00000000111100000001100110011100001100001110011000111000110000000000000000111100;
level3[ 14] = 80'b00000000111100000011000110011100011100011100011000110001100000000000000000011110;
level3[ 15] = 80'b00000000111000000111000110011100011000011100010001110011000000000000000000011110;
level3[ 16] = 80'b00000001111000000110000100011100111000111000110001110000000000000000010000011100;
level3[ 17] = 80'b00000001110000001110001000001100110000111000100001110000010000000000110000011100;
level3[ 18] = 80'b00000001110000001110010010001110100000111000001001110000100000000000110000111000;
level3[ 19] = 80'b00000001110000001110000110001111000001111000010001111001100000000001110001110000;
level3[ 20] = 80'b00000011110011001111011000001110000000111101100001111111000000000000111011100000;
level3[ 21] = 80'b00000011111110000111110000000100000000011111000000111110000000000000011110000000;
level3[ 22] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[ 23] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[ 24] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;
level3[ 25] = 80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000;

ready[  0] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[  1] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[  2] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[  3] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[  4] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[  5] = 200'b11111111000000000000000000000000000000000000000000000000111111110001111000000110011111111111001111111100011111111000000000011111111111000000000000000000001111100000000000000000000000000000000000000000;
ready[  6] = 200'b11111111100000000000000000000000000000000000000000000000111111110000111100000110011111111111001111111100011111111100000000011111111110000000000000000000111111100000010000000000000000000000000000010000;
ready[  7] = 200'b11100011110000000000000000000000000000000000000000000000111000000000111100000110000001110000001110000000011100011100000000000001110000000000000000000000111000000000111000000000000000000000000001110000;
ready[  8] = 200'b11100001110000000000000000000000000000000000000000000000111000000000111110000110000001110000001110000000011100001110000000000001110000000000000000000001110000000001111000000000000000000000000001110000;
ready[  9] = 200'b11100001110001110000000001110000000011000000011100000000111000000000111110000110000001110000001110000000011100001110000000000001110000000001100000000001110000000011111110000011110000001110000011111110;
ready[ 10] = 200'b11100001110001110110000111111100001111100001111110000000111000000000110111000110000001110000001110000000011100001110000000000001110000000111111000000000111000000011111110001111111000000110110011111110;
ready[ 11] = 200'b11100001110001111110001110001100011100000001100000000000111100000000110011000110000001110000001110000000011100011100000000000001110000001110011100000000111110000001111000000000011100000111110001110000;
ready[ 12] = 200'b11110111100001111000001100001110011100000011100000000000111111110000110011100110000001110000001111111000011110111100000000000001110000011100011100000000011111000000111000000000011100000111100001110000;
ready[ 13] = 200'b11111111100001111000001100000110011100000001110000000000111111110000110001100110000001110000001111111000011111110000000000000001110000011100001100000000000111100000111000000000111100000111000001110000;
ready[ 14] = 200'b11111110000001110000011111111110001111000001111100000000111000000000110001110110000001110000001110000000011111111000000000000001110000011100001110000000000011110000111000000111111100000110000001110000;
ready[ 15] = 200'b11100000000001110000011111111110000111100000011110000000111000000000110000111110000001110000001110000000011100011100000000000001110000011100001110000000000001110000111000001110011100000110000001110000;
ready[ 16] = 200'b11100000000001110000011100000000000001110000001110000000111000000000110000111110000001110000001110000000011100011100000000000001110000011100001100000000000001110000111000001100001100000110000001110000;
ready[ 17] = 200'b11100000000001110000001100000000000001110000000110000000111000000000110000011110000001110000001110000000011100001100000000000001110000011100011100000000000001110000111000011100011100000110000001110000;
ready[ 18] = 200'b11100000000001110000001111000000000011100000001110000000111100000000110000011110000001110000001111000000011100001110000000000001110000001110111000000000110011110000111100001110011100000110000000111100;
ready[ 19] = 200'b11100000000001110000000111111100011111100011111100000000111111111000110000001110000001110000001111111100011100001110000000000001110000000111110000000001111111000000111110001111111100001111000000111100;
ready[ 20] = 200'b11100000000001110000000000111000001110000000110000000000111111110000110000001110000001110000001111111100011100001110000000000001110000000001000000000000001100000000001100000010001100000110000000001100;
ready[ 21] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 22] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 23] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 24] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 25] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 26] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
ready[ 27] = 200'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;



/*

back_1[  0] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  1] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  2] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  3] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  4] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  5] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  6] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  7] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  8] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[  9] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 10] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 11] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 12] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 13] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 14] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 15] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 16] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 17] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 18] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 19] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 20] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 21] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 22] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 23] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 24] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 25] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 26] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 27] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 28] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 29] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 30] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 31] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 32] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 33] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 34] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 35] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 36] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 37] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 38] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 39] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 40] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 41] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 42] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 43] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 44] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 45] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 46] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 47] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 48] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 49] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 50] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 51] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000010011011000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 52] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010000000000010000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 53] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000011000000000010000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 54] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000000000010000000000010000000000011011111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 55] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001000000000010000000000010000000000011011111111111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 56] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001000000000010000000000000000000000000000000010000000011111111111111111111111111111111100111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 57] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000010000000000000000000000000000000011000111111111111111111111100111111111111000111100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 58] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110000000000000000000000000000000000000000000000000000000000000011111111111111111000111111111110000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 59] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000100000000000000000000000000000000000000000000000000001000100000000000111111111110000110000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 60] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000100000000000000000000000000000000000000000101110000000000000000000000110100100000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 61] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000100000000000000000000000000000000000000010001111111000110110110000000110000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 62] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000100000000000000000000000000000000000111111111111111000010000110000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 63] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100000000000000000000000000000000000000000001100111111110110000010000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 64] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001000000000000000000000000000000000000000000011000011100110000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 65] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001000000000000000000000000000000000000000010011000011000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 66] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000001000011000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 67] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 68] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000001100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 69] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000100000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 70] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000110000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 71] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 72] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000011000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 73] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111011100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 74] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 75] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101110110111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 76] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111100011110110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111100111011001111111111111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 77] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110111111111110011111111111111111111111111111111111101110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 78] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110011101101111111111111111111111111110100111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 79] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111001111111111111111111111111110110111000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
back_1[ 80] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111011111101111111111111111111110000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 81] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111101111111111111111111110000010000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 82] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111101111111111110111011111111111000011000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 83] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111110111110111000011011100000001000000100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
back_1[ 84] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111011100111000000000011000000110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
back_1[ 85] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111110011000010000001000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 86] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 87] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111000000001100000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 88] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111100000000100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 89] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111000000000011111111111111111111111111111100000000001000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 90] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000001111111111111111111111111111111100000001101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 91] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111110000000001001100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 92] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000001011111111111111111011110000000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 93] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000011111111111111000011000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 94] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000001011000000000000011100000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 95] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000011000000000000011100000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 96] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000011000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 97] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000001000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 98] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[ 99] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[100] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
back_1[101] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000110000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
back_1[102] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100010000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[103] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111;
back_1[104] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111101111111111111111;
back_1[105] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111110011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[106] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[107] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[108] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000000000000010000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111101111111111111111;
back_1[109] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000000000110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110110111111111101111;
back_1[110] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000001110110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111;
back_1[111] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000001111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[112] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111010000000000111111111000000000000111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111110011111111111111;
back_1[113] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111100000000000111111111000000011111111111111111111111000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[114] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000111111111111111110000000000111111111001111111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[115] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000011111111111111111111110000000001111111111111111111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_1[116] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111000001001111111111111111110000000011111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111;
back_1[117] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110111111111001011111111111111111100000111111111111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111;
back_1[118] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111001011111111111111011000000111111111111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111;
back_1[119] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000111001111000001111111000000000000000111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111;
back_1[120] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001000000000000111000100000000000000000000000000000000000000000000000001000001111110000000000000000000111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111;
back_1[121] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001000000000000010110110000000000000000000000000000000000000000000000000011111000011110000000000001101000000111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111011111111111;
back_1[122] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000001000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000001110100011010011110000000111111111111111111111111111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111000111001110111110111111111111;
back_1[123] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000001100000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000010000000000010011010000111111111111111111111111111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111010111000011100110111111111111;
back_1[124] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001110000000000111110110111111111101;
back_1[125] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010000000000001010000011111110000;
back_1[126] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000111111110111111111111;
back_1[127] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011100000000000000000000000000000111111110111111111111;
back_1[128] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000001100000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111101111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111101000000000000000000000000000000010000011111111111111111111;
back_1[129] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000011000001111101100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111000111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011000000000000000000000000000000000000001000111101111111111111111;
back_1[130] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101111011101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111110001100111111111111111111111111111111111100001111111110011111111111111111111111111111111111111111111111111111111111100111000000000000000001000000000000000000000000000000000000000100111110000111111111111;
back_1[131] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000100011000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000001100011111111111111111111111111111111100001111111111011111111111111111111111111111111111111111111011111111111100000000000000000000100000100000000000000000000000000000000000000010111111100111111111111;
back_1[132] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000001000000000111000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111110001111111111111111111111111111111111111111111111111111110111000000000000000000000000000000100000000000000000000000000000000000000000000000000111110111111111111;
back_1[133] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111110000111111111111111111111111111111111111111111111000000000111000000000000000000000000000000100000000000000000000000000000000000000000000000111011111111111111111;
back_1[134] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000110111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111110000000111111111111111111111111111111111111111100000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000111101111111111111111;
back_1[135] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000001100000000000000000000000111111111111100000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111000000000011111111111111111111111111111111111110000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000111111111011111111111;
back_1[136] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000100000000000000000000000000000000000000000000000000000000000001110011111001000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111000000000000000111111111111111111111100111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111011111111111;
back_1[137] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000001101000000000011000000000000000000000000000000000000000000000000101000001001000000000000000000000000000000000000001000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111111111111111111111111111111100000000000000000001111111111111111111111111100000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000111111110001111111111;
back_1[138] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000111000000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000111111111111111111111111111111101110000000000000000000011111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111001111111111;
back_1[139] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000001111100000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000011111111111111111111111111111111111100000000000000000000000011111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111100111111111;
back_1[140] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000001111000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000011111111111111111111111111111111111111111000000000000000000000001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110011111111;
back_1[141] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000011000000001011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000001000111111111111111111111111111111111110000000000000000000000000000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111001111111;
back_1[142] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000111000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001000011111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111101111111;
back_1[143] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000001111000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001000000111111111111111111111111111111111111111111110000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000001111111111111110111111;
back_1[144] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000011000000000100000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000001111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111001111;
back_1[145] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000001010000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000001111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001011111111111111111100111;
back_1[146] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000100000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000001111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111110111;
back_1[147] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000001111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111110001;
back_1[148] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111111111111111111001;
back_1[149] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111011011111111111100;
back_1[150] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000100000000101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111100;
back_1[151] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000110011111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111011110;
back_1[152] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000001111110011111111111111111111111100011111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110111111111;
back_1[153] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000001011111110001111111111111111111111111100000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111110111;
back_1[154] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000000000000011111111111001111111111111111111111111111000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111101;
back_1[155] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000001111111111111001111111111111111111111110000000001111111111111110000000000000101000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110;
back_1[156] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100011100000000000000001111111111111111100111111111111111111111110000000101111111111111110000000000001111000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111;
back_1[157] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000011111111111111111100111111111111111111111111100000101111111111111110000000000011111000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111;
back_1[158] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000000000000111111111111111111100011111111111111111111111111000101111111111111111000000000111111100000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111;
back_1[159] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000111111111111111111110011111111111111111111111111100101111111111111111010000000111111100000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110;
back_1[160] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111011000000000000101111111111111111110001111111111111111111111111100111111111111111111111000001111111110000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110;
back_1[161] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111101000000000000000000000000100011111001111111111111111111111111100111111111111111111111000001111111110000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111110;
back_1[162] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110111100000000000001111111100000000000000000000000000100011111001111111111111111111111111100111111111111111111111000000111111110000000101011100000000000000000000000000000000000000000000000000000000000111111111111111110010111;
back_1[163] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110011000000000000000000000001111111111100000000000000000000000100110111111000111111111111111111111111100111111111111111111011000000111111111111111111001000000000000000000000000000000000000000000000000000000000000111111111111111011111111;
back_1[164] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000000001000000000000001111111110000000000000000001111111111111111100111111111111111111111111100111111111111111110011000001111111111111111100000000000000000000000000000000000000000000000000000000000000001111111111111111111111111;
back_1[165] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111000000000000000000000000000000000000000000000000011111111110000000000011111111111111111111111100011111111111111111111100000111111111111111110000000011111111111111111110000000000000000000000000000000000000000000000000000000000000000111111111111011111111111;
back_1[166] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100111111010000000000000000000000010000100000000000000000000000000000001111111111110000000010011011101111111111111111110011111111111111111111111000111111111111111111000000111111111111111111111111010000000000000000000000000000000000000000000000000000000000111111111111111111111111;
back_1[167] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111100000000000000000000011111111110000000000000000000000000000000000000000000000011110000000000000001111111111111111111110011111111111111111111111001111111111111111110000000111111111111111111111111110000000000000000000000000000000000000000000000000000000001111111111111111111111111;
back_1[168] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111100000000000000000000111111100000000000000000000000000000000000000000000000000000000000111110000000010111111111111111111111111111001111111111111111111111001111111111111111110000000001111111111111111111110000000000000000000000000000000000000000000000000000000000000011111111111111111111111;
back_1[169] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111100000000000000000111111111110000000000000000000000000000000000000000000000000000000000000001110010000110000000000000011111111111111111111111001111111111111111111111001111111111111111110000000011111111111111111111111000000000000000000000000000000000000000000000000000000000001001111111111111111111111;
back_1[170] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111100000000000000000000111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000001111111111111111111111100111111111111111111111001111111111111111110000000011111111111111111010010000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[171] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111111110000000000000000000111011000000000000000001000110100000000000000000000000000000000000000000000000000000000000000000000000011011000000000000000011111111111111111111100111111111111111111111001111111111111111110000000001111111101111100000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[172] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111000000000000000001101111111100000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000001011111111111111111110011111111111111111111001111111111111111110000000000111100000010000000000000000000000000000000000000000000000000000000000000000000000000100111111111111111111;
back_1[173] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110000000000000000000001111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000011111111111111110011111111111111111111101111111111111111110000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[174] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111110000000000000000011111111100000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000001111111111111110000111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[175] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111111111111000000000000011111111111100000000000000000000000000000000000000000000000000000000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000011111111111111111111111000000000111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[176] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000011111111111000000000000000000000000000000000000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000000011000110000000000001111111111111111111111111000000000000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_1[177] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011111110100010100011111111111111100000000000000101000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000000001111111111111111111111111111110000000000000000011111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[178] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000000000000111111111111111000000000000000000000000000000000000000000000000000000000010010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111110000000000000000011111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[179] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000011111111111111101110001000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111100000000000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[180] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111100000000000000110011111000000000000000111101110000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_1[181] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000011111111111111000000000000111111111111000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[182] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111110000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_1[183] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000111111111111111001000000011111111111000000000000000000000000000000000000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[184] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000111111111111010000000000000111111111111000000000000000000000000000000000000000000000000000000000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000001111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000111111111111111111111;
back_1[185] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000001111111111111111000000000000101111111100000000000000000010000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000000000000001111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[186] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000001111111111111000000000000001111111101000000000000001100000000000000000000000000000000010011100000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000000001111011111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111;
back_1[187] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000011101111111010010000001000100010000001100000000000000000000000000000000000000000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100000000001111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[188] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001101111111000000000000001110111000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100001111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[189] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001101111101000000000000000000000000000000000000000000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100011111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_1[190] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000100000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100011111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[191] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000110000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111100011111111111111111111111111111111111111111111111111111111111111111111011111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[192] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000011111111111111111111;
back_1[193] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000011101111000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111;
back_1[194] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000011111100000000000000000000000000000000000000000000000000000010000000000000000000000000000100000000000000000000000000000011000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_1[195] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000001100000000000000000000000000000011100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000001000001000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111;
back_1[196] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000001110000000000000000000000000000001100000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111011111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[197] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000000000000000011111000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000001000001101000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[198] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000111100000000000000000000000001111000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111011111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[199] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000100000000000000000000000001000000000000000000000000000111000000000000000000000000001101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[200] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000011100000000000000000000000000010000000000000000000000000111000000000000000000000000000100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111;
back_1[201] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000101000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000001111111100000000000000000000000000000000000000000000000000000000000000000000011111111111111111;
back_1[202] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000101000000000000000000000000000100000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000000011001111111111111111;
back_1[203] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000001000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111111111111111111100000000000000000000000000000000000000000000000000000000000000011101111111111111111;
back_1[204] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111111111111111111011000000000000000000000000000000000000000000000000000000000000011111001111111111111;
back_1[205] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000111111111111111111111110000000000000000000000000000000000000000000000000000000000000001111101111111111111;
back_1[206] = 640'b1111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000001111110111111111111;
back_1[207] = 640'b1111111111111111111111111111111111111111111111111111111111111111111100000001000111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000101111111111111111111111111100000000000000000000000000000000000000000000000000000000000001111111011111111111;
back_1[208] = 640'b1111111111111111111111111111111111111111111111111111111111111111111100000000000111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000001111111011111111111;
back_1[209] = 640'b1111111111111111111111111111111111111111111111111111111111111111111100000000000111111111111111111111111110000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111100100000000000000000000000000000000000000000000000000000000000001111111111111111111;
back_1[210] = 640'b1111111111111111111111111111111111111111111111111111111111111111111000000000000111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111011111111111111111111111111111111111111111111111111111111111111111111111111111101000011000111111111111111111111110000000000000000000000000000000000000000000000000000000000000001111111101111111111;
back_1[211] = 640'b1111111111111111111111111111111111111111111111111111111111111111110000000000001111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111000011101111111111111111111111100000000000000000101101100000000000000000000000000000000000000001101111101111111111;
back_1[212] = 640'b1111111111111111111111111111111111111111111111111111111111111111110000000000001111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001001111111111111111111111100000000000000001011111100000000000000000000000000000000000000000111111100111111111;
back_1[213] = 640'b1111111111111111111111111111111111111111111111111111111111111111110000000001000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111011111111111111111111111111111111111111111111111111111111111111111111111111111110000001001111111111111111111111100000000000000011111011100000000000000000000000000000000000000001101111111111111111;
back_1[214] = 640'b1111111111111111111111111111111111111111111111111111111111111111110000000001000011111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001011111111111111111111111100000000000000011110011110000000000000000000000000000000000000000111111110111111111;
back_1[215] = 640'b1111111111111111111111111111111111111111111111111111111111111111111000000000000111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111111111100000000000000001110111110100000000000000000000000000000000000001111111110011111111;
back_1[216] = 640'b1111111111111111111111111111111111111111110111111111111111111111110010000000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111111111111111111110000000000000000011110100000000000000000000000000000000000000001111111111011111110;
back_1[217] = 640'b1111111111111111111111111111111111111111111101111111111111111111110011000000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111101111111111111111111111110000001111111111111111111111101010000000000000010111110000000000000000000000000000000000000000000011111111001011110;
back_1[218] = 640'b1111111111111111111111111111111111111111111111111111111111111110001000001000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111000011111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000111111111110001100;
back_1[219] = 640'b1111111111111111111111111111111111111111111111111111111111111111000000000000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000111111111101111001;
back_1[220] = 640'b1111111111111111111111111111111111111111110011111111111111111111100000100000001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111011111111111111111111110110000000000000000000001010000000000000000000000000000000000000000000010011100111111111;
back_1[221] = 640'b1111111111111111111111111111111111111111101111111111111111111111111000110010011111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111100011111111111111111100100000000000000000000000011001110000000000000000000000000000000000000000001111000111000111;
back_1[222] = 640'b1111111111111111111111111111111111111111111111111111111111111111111110100010011111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111000000000000000000000000110010000000000000000000000000000000000000000000001110111111111111;
back_1[223] = 640'b1111111111111111111111111111111111111111111111111111111111111111110111111011011111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111110100111111111111111110011000000000000000000000010010000000000000000000000000000000000000000000001111111111001111;
back_1[224] = 640'b1111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111100000111111111111111111100000011111111111111100100000000000000000000000000001000000000000000000000000000000000000000000110111111111011111;
back_1[225] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111010111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111101000000000111111111111111000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000111111111110111111;
back_1[226] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111101110111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111110000000000111111111111111000011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000111111111110111111;
back_1[227] = 640'b1111111111111111111111111111111111111111111111111111111111110011111111111110111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111111100000000111111111111100000000011110111010000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111;
back_1[228] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111111100000000011111111111100000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000010011111011111111;
back_1[229] = 640'b1111111111111111111111111111110111111111111111111111111111111101111111111110111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111111100000000011111111111100000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000111111011111111111;
back_1[230] = 640'b1111111111111111111111111111110111111111111111111111111111111001111111011110011111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000001111111111101111111111111111111111111111111111111111111111111111111111111010010011111111111100000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000111111010111011111;
back_1[231] = 640'b1111111111111111111111111111111111100111111111111111111111111001111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000000000000001111111111101111111111111111111111111111111101101111111111111111111111111111010011111111111100000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000011111;
back_1[232] = 640'b1111111111111111111111111111111111111111111111111111111111111011011111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000000000000001111111111101111111111111111111111111111111100001111111111111111111111111111110011111111111100000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000000111111011101101111;
back_1[233] = 640'b1111111111111111111111111111111111111111111111111111111101111111101111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110010000000000000000000001111111111101111111111111111111111111111111100000111111111111111111111111111110011111111111110000000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000011110010001111111;
back_1[234] = 640'b1111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000111100000000000000000001111111111101111111111111111111111111111111100001111111111111111111111111111110011111111111100000000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000011100100101111110;
back_1[235] = 640'b1111111111111111111111111101111111111111111111111111011001100000000011111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110111100000000000000000001111111111101111111111111111111111111111111100001011111111111111111111111111110111111111111100000000000111111111111111100000000000000000000000000000000000000000000000000000000000000000000011001001000000000;
back_1[236] = 640'b1111111111111111111111110111111111111111111111111111111000100010000001111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111111111000000000000000000000111111111101111111111111111111111111111111100011011111111111111111111111111110111111111111100000000011111111111111011000000000000000000000000000000000000000000000000000000000000000000000010000000000000000;
back_1[237] = 640'b1111111111111111111111111111111111111111111111111101111000000001100100001111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000111111111101111111111111111111111111111111100010001111111111111111111111101110111111111111000000000000011111111000001000000000000000000000000000000000000000000000000000000000000000000000001100000000000000;
back_1[238] = 640'b1111111111111111111111111111111111111111111111111110000000000000100111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111100110001111111111111111111111101111111111111111000000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000;
back_1[239] = 640'b1111111111111111111111111111111111111111111111111111100000000000001111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111101100001111111111111111111111101111111111111111000000000000001111110000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000;
back_1[240] = 640'b1111111111111111111111111111111111111111111110011111111000000000000011111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111111100001111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[241] = 640'b1111111111111111111111111111111111111111111110111011110000000000000011111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000111111111101111111111111111111111111111111111110001111111111111111111111111111111111111110000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[242] = 640'b1111111111111111111111111111111111111111111110010000000000000000000000011111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111111110001111111111110000000001111111111111110000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000001100000000000001;
back_1[243] = 640'b1111111111111111111111111111111111111111111110001111000000000000000000001111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111111110001111111111100110000001000111000111110111000000000000011111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[244] = 640'b1111111111111111111111111111111111111111111100111111011100000000000000111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111111110011111111111000000000011000011000000000000000000000000001111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[245] = 640'b1111111111111111111111111111111111111111111000100110111110000000000000001111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000111111111101111111111111111111111111111111111111011111111110000000000001000011011000000000000000000000000111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[246] = 640'b1101111111111111111111111111111111111111110011100100111111000000000000001111111111111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000000000111111111101111111111111111111111111111111111111111111111111000111000000000010000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[247] = 640'b1111111111111111101111111111111111111111110111100001111001000000000000101111111111111111111111110010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111110111111111111111000011000001000000000000000000000000000011111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[248] = 640'b1111111111111111111111111111111111111111101100010010111100000000000000111111111111111111111111110010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101111111111111111111111111111111110111111111111111000111010001000001000000000100001111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000100000;
back_1[249] = 640'b1111111111111111111111111111111111111111001110100100000000000000000001111111111111111111111111001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000111111111100111111111111111111111111111111110111011111111111000110110000000001011000000111111111000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[250] = 640'b1111111111111111111111111111111100001000010111100000100000000000000001111111111111111111111111001100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000111111111100111111111111111111111111111111110011111111111111101111111011000001010000001110000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000011;
back_1[251] = 640'b1111111111111111111111001110010111110011111111010011111000000000000111111111111111111111111111110101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011000000000000000000000000111111111100111111111111111111111111111111110011111111111111111111111111000011100111110000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[252] = 640'b1111111111111111111100111101011011111100000000000001111000000000000111111111111111111111111111111011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001101100000000000000000000111111111101111111111111111111111111111111110011111111111111111111111111111111110000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[253] = 640'b1111111111111111111000000000011111111111011010000000000000000000000111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000000000000000000111111111100111111111111111111111111111111110011111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[254] = 640'b1111111111111111110111100000011111111111111110100000000000000000000111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100111111111111111111111111111111110011111111111111111111111011001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[255] = 640'b1111111111111111111111100110110110111111111111101100001100000000000000000111111111111111111111111000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100111111111111111111111111111111111011111111111111111111111111101110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[256] = 640'b1111111111111101111111101110011100011111111111001111001100000000000000000011111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100111111111111111111111111111111111011111111111111111111111111111111111000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[257] = 640'b1111111111111111101011100110011110011111111111011111001100000000000000111111111111111111111111110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000111111111100111111111111111111111111111111111011111111111111111111101111011111101000001000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[258] = 640'b1111111100010110110000001111001110000000000000111110000000000000000000000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000111111111100111111111111111111111111111111111011111111111111110011101110001000000000000000000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[259] = 640'b1111111111111111011000111101001100000000000000111111000000000000000000000010111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000111111111100111111111111111111111111111111111011111111111111111011101011011011000000000000000000000000000111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[260] = 640'b1111111111111111101000000100001000000000000000111111100000000000000000011111111110101111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000111111111110111111111111111111111111111111111011111111111111111111110010010000000000000000001000000000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[261] = 640'b0111111111110100111000000000011000100000001111001111011100000000000011111111111011000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000000000000000000000111111111100111111111111111111111111111111111011111111111111111101110010010001000000000000000000000000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[262] = 640'b1001111111111111110000000000000001100000000111111100001100000000001000101111001011000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000111111111100111111111111111111111111111111111011111111111111111101111010000000000000000000000000000000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[263] = 640'b0001000000111111010001110000000010000000100111111110000000000000000000000101110011000000010011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000111111111100111111111111111111111111111111111011111111111111111111011011100000100000010000000000000000011111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[264] = 640'b1111111111001111111111100000000000000000000111111110110000000000000100011111111100000000000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111011111111111111111100011111100000000000010000000000000000011111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[265] = 640'b1111111111111001111111000000000000000000000011111111010000000000000111111111111110000000000100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000111111111100111111111111111111111111111111111011111111111111111100001111100000000000000000000100000010111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[266] = 640'b1111111111101110010011110000000000000000000100111111000000000000001111111111111110000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111011111111111111100101001111100000000000000000000010000000101111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[267] = 640'b1111111111101111000000000000000000000000000000111111111000000000001111111111111110000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111011111111111100000001000111100001000000000000000000000000001111111111111100000000000000000000000000000000000000000000000000000000000000010000000000000000000000;
back_1[268] = 640'b1111111111111111110000000000000000000000000000011000011100000000000011011111100000000000000011011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111111101110110000000000000111100001000000000000000000000000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[269] = 640'b1111111111111111000000000000000000000000000000010011000100000000001110011011101000000100000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111001100000000000000000000111000000000000000000000000100000001011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[270] = 640'b1111111111111111100111000001000000000000000000000001000100000000001001111111111000000100000000101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000001011111111001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[271] = 640'b1111111111111111111001100000100000000000000000000010000000000000000111111111111000010000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000001010111111001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[272] = 640'b1111111111111111111101100000000000000000000000000000000000000000000111111111111000000000110011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000010111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[273] = 640'b1111111111111111111111100010000000000000000000000000000000000000111111111111111000001000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[274] = 640'b1111111111111111111111101111010000000000000000000000000000000000111111111111100000000000110000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000111111111110111111111111111111111111010111110000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000;
back_1[275] = 640'b1111111111111111111111101100000000000000000000000000000000000000011111111111110000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000111111111110111111111111111111111111000011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[276] = 640'b1111111111111111111111111111100000000000000000000000000000000000000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000111111111110111111111111111111111110000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010;
back_1[277] = 640'b1111111111111111111111101111111000000000000000000000000000000000000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111110111111111111111111111100000000000000000000000000000000000000011000000000000000000000000000000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[278] = 640'b1111111111111111111111101111111000000000000000000000000000000000000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000010111111111110111111111111111111111100000000000000000000000000000000000011111110000000000000000000011000001111100000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000;
back_1[279] = 640'b1111111111111111111111111111111011100000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000011111111111110111111111111111111110000000000000000000000000000000000000000101111100000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000;
back_1[280] = 640'b1111111111111111111111111111111111111100000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111001011111111111110111111111111111111110000000000000000000000000000000000000000011111110000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000001000;
back_1[281] = 640'b1111111111111111111111100111111111101100000000000000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110111111111111110111111111111111111110000000000000000000000000000000000000000001111111000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000001100;
back_1[282] = 640'b1111111111111111111111100001111111001010000000000000000000000000001111111111000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111110111111111111111111110000000000000000000000000000000000000000001111111100000000000000000001001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[283] = 640'b1111110111111111111111110001111111111110000000000000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000111111111111111111111111111111111111111100000000000000000000000000000000000000000000111111100000000000000000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[284] = 640'b1111000011111111111111110000111110011100000000000000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100001111111111111111111111111111111111110100000000000000000000000000000000000000000000011111100000000000000000001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000;
back_1[285] = 640'b1111001001111111111111110000111110011000000000000000000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000111111111111111111111111111111111110000000000000000000000000000000000000000000000001111100000000000000000011111111110000000000000000000000000000000000000000000000000000001000000000000000000000000000100000000000;
back_1[286] = 640'b1110001110111111111111110000111111111000000000000000000000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110001111111111111111111111111111111110000000000000000000000000000000000000000000000000001000000000000000001111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[287] = 640'b1110001111001111111111110001111111000100000000000000000000000000011111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111100111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[288] = 640'b1110001111100111111111110001110111000000000000000000000000000000001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110001111111111111111111111111011000000000000000000000000000000000000000000000000000000000000000000011101101111111111111110000000000000000000000000000000000000000000000000000000000000000000000000001000001000000;
back_1[289] = 640'b1110000111111011111111110000111111000000000000000000000000000000011111111111111111111111000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000010000;
back_1[290] = 640'b0000000001111101111111110000111110000000000000000000000000000000011111111111111111111111111000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111001111111110111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[291] = 640'b1111100000111100111111100001110000000000000000001000000000000000000111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000111111000000000000000000000000000000000000000000000000000111111111111111111100011111111111100000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000010000000000000000000000000000011000;
back_1[292] = 640'b1111110000000001111111100011100000000000000000000000000000000000011111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000001111111111000000000000000000000000001111111100000000000000000000000000000000000000000000000000111111111111111111111001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[293] = 640'b1111111000000011111111100111100000000000000000000000000000000011111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000000000000111111111000000000000000000000000011111111111000000000000000000000000000000000000000000000001111111111111111111111110011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[294] = 640'b1111111000000111111111101110000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000000000001100100000000000000000000000000000011111111110000000000000000000000001111111111100000000000000000000000111111111111000000000000000000000000000000000000000000000001111111111111111111111111001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001;
back_1[295] = 640'b1111110011000111111111111100000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000110000000000000000000000000011100000000000000000000000001111111100000000000000000000000011100110000000000000000000000000000011111111111000000000000000000000001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111110011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001;
back_1[296] = 640'b0000000011100011111111111100000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000011111111000000000000000000000010110000000000000000000000001111111110000000000000000000000011110111010000000000000000000000000011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[297] = 640'b1111000001110000100100000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000001111111111100000000000000000011111111111000000000000000000111111111111000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[298] = 640'b0011100001110000101100000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001111111111110000000000000000011011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[299] = 640'b0000100011100000001100000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000011111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[300] = 640'b0000011111100000010000000000000000000000000000000000000000010111111111111111111111111111111111111111111111111111111111111111110011000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000001101101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[301] = 640'b1100001001000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111110000000000100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000001100101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[302] = 640'b0010000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000011010000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[303] = 640'b0001000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000011000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[304] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111100000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000011010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000011010010111000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[305] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011010000000100000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111100000000000000000000000000000000000000000000000000000111000111101101011111011111011110011111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[306] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101011000000101100011001000000000001000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111100000000000000000000000000000000001100111001100011000001000001000001000100000111001111011111011111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[307] = 640'b0000000000000000000000000000000000000000000000000000000101111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000101111111111111110111001100000100011101100000000010000000000000000100111110011011000000101111100000000000000001000000010110011100000110000011111110000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111100000000000000000000000001000000000000000000000000000000000000000000000000000000000000000111001111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[308] = 640'b0000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000101111111111111111111111111111111111111100111011111111110011001110111111111111111111110111110000001000000000001011111111111111111110111101111111000000000011100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[309] = 640'b0000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000111111111111111111111111111111111111110100111111100111111011111111111111111111011111110111100000001010000001101111111111111111111111111101110011000000000010011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011111111100000000000000000000000000000000000000000000000000000000000000000000000;
back_1[310] = 640'b0000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111011111111000000000000000000000000000000111111111111111111111111111111111111111111111111111111111101110111111111111111111111111100100000001010000001101111111111111111111111111111111101000001111110011001000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000000000000000000000000000000000000000000000000000;
back_1[311] = 640'b0000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111110001111111000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111101111111111111111110101100000001010000011111111111111001111111111111111111001000111111111111111100011000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000;
back_1[312] = 640'b0000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111110000111111100000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111011111100100100000001011011111111111111111111111111111111111010000000011111111111010100010001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[313] = 640'b0000000000000000000000000000000000000000000000000000000000001011111111111111111111111111111111111111111111111111110000011111100000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111100000100100000001011111111111111111111111111111111111110011100111011111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[314] = 640'b0000000000000000000000000000000000000000000000000000000011011111111111111111111111111111111111111111111111111111100000011111100000000000000001000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111000000100100000001011111111111111111111111111101111111111011110010001111111111000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[315] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000011111000000000100000001000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111000000100100000011011111111111111111111111111111111111111111111111111111111001111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[316] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000001111000000000000000000010000000000111111111111111111111111111111111111111111111111111111111111111111111111111111010000000100100000011111111111111111111111111111111111100000111101111101111100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[317] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000001110000000000000000000110000000000111111111111111111111111111111111111111111111101111111111111111111111111110011010000000100100001111111111111111111111111111111111111111111111101110100111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[318] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000111111111111111111111111111111111111111111110000111111111111111111111111000011010000000101100111011111111111111111111111111111111111111111111111100010100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[319] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111101000000000000000000000000001111110000000001111111111111111111111111111100000111111100011111111111111111111111111000011010000000101111111111111111111111111111111111111111111111111111111000011111100000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[320] = 640'b0000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111000000000000000000000000000001111111111111111111111111111111111111111111000000011111100111111111111111111111101100000010010000000100111111111111111111111111111101111111111111111111001010000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[321] = 640'b0000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111000000000000000000000000000011111111111111111111111111111111111111111101000010001001111111111111111101111111101000000010010000001111111111111111111111111111111111111001111111111111110011101001111110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[322] = 640'b0000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111100000000000000000000000000000011111111111111111111111111111111111111101000000000000000011111111111111111110001001000000011010000011111111111111111111111111111111111111101111111100111110001000011110011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[323] = 640'b0000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111000000000000000000000000000000011111111111111111111111111111111111111110000000000001000001111111111111111100000001000000111010001011111111011111111111111111111111111111111111011000100000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[324] = 640'b0000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111100000000000000000000000000000011111111111111111111111111111111111111110000000000111000011111111111111111110000001000000011010111110000011101101011011111111111111110110111111001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[325] = 640'b0000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111100000000000000000000000000011111111111111111111111111111111111111111111100000000100000010111111111111100000000001000000011011111111011111101110011111111111111111111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[326] = 640'b0000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111110000000000000000000000000111111111111111111111111111111111111111111111000000000000000010111111111101100000000001000000010001111111111111111111111111110111111111111111111110010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[327] = 640'b0000000000000000000000000000000000000000000000000000000000001011111111111111111111111111111111111111111111111100000000000000000000000001111111111111111111111111111111111111111111100000000000000000110011111111111000000000001000001111111111111111111111111111111110111111111111111100111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[328] = 640'b0000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111110000010000000000000000000000000001111111111111111111111111111111111111111111000000000000000000011111111111111000000000001111111111110111111111101100000111111111000000000000001100000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[329] = 640'b0000000000000000000000000000000000000000010111111111111111111111111111111111111111111111111111111111100000000010000000000000000000000001111111111111111111111111111111111111111111100000000000000000011111111111111011000000010110100000011100000001000000000011111110000000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[330] = 640'b0000000000000000000000000000000000000000000010111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000111111111111111111111111111111111111111110000000000000000011111111111111111011000000000110100001111111111111100000000011100000000000011011101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[331] = 640'b0000000000000000000000000000000000001000111111111111111111111111111111111111111111111111111111101000000000100000000000000000000000000000111111111111111111111111111111111111111110001000000000000011111111111111111111111111111111110111110011111111100110000010000000000110000111001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[332] = 640'b0000000000000000011110110001101100110111111111111111111111111111111111111111111111101110111111111000000010000000000000000000000000000000111111111111111111111111111111111111111111101000000000111111111111111111111000101111100100001011000011111100000000000000000000011111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[333] = 640'b0000000000011111101111111111111111111111111111111111111111111111111111111111111111101110111111111110000000000000000000000000000000011011111111111111111111111111111111111111111111100000000000111111111111111111110000111011001111111001111101111110000011111111111110111001111111110100000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[334] = 640'b0000001111111111001111111111111111111111111111111111111111111111111111111100111111111110111111111100000000000000000000000000000000010111111111111111111111111111111111111111111111100000000000111111111111111111001101110011111111110011111011111000000111101111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[335] = 640'b1111111111111111011111111111111111111111111111111111111111111111111111100000011100001110010011100000000000000000000000000000000000000011111111111111111111111111111111111111111111110110000001111111111111111111111111111111111111001111111111111001111111111111111111111111101111111111101110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[336] = 640'b1111111111111111111111111111111111111111111111101111111111111011110000000000000000001110000011000000000000000000000000000000000000001111111111111111111111111111111111111111111000001000000111111111111111111111111100000111111111011110000000000000000000011111111110000001101111100000000000110000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[337] = 640'b1111111111111111111111111111111111111111111111111111111111111011111000000000000111111110000011000000000000000000000000000000000000001111111111111111111111111111111111111111110011111111000111111111111111111111111110111111111111110000000001110011011111111111110011111111111111100000000001111111111111000100010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[338] = 640'b1111111111111111111111111111111111111111111111111111111111110011111111000000001111111111000111000000000000000000000000000000000000000111111111111111111111111111111111111111100011111111000111111111111111111111111110001111111100000000000000000011111110111111110011111111111100000000000000000000100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[339] = 640'b1111111111111111111111111111111111111111111111111111100000000011011110000000000111101110000111000000000000000011111000000000000000000111111111111111111111111111111111111111100011111110000111111111111111111111111111000101111110000111011100011011111111111111110010011111111000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[340] = 640'b1111111111111111111111111111111111111111111111111111000000000110000000000000001111101110000111000000000000111111110000000000000000000111111111111111111111111111111111110000001111111110000110111111111111111111111011100111111111000110010000010010100011111110110000011101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[341] = 640'b1111111100111111111111111111111111111111111111111111101111111100000000000000011111111111110111000000000000111111110111100000000000001111111111111111111111111111111111110001111111011111110111111111111111111111101011001111101111100110010000000001001101100010000000111100000000000000000011000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[342] = 640'b1111111111111111111111111111111111111111111111101111111111111111001000000100011111111111110111000000000000111111101111100011000000011111111111111111100011111111111110000000000000011111110111111111111111111111111111111111101011111111111111110000001111101100000000010111111111000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[343] = 640'b1111111111111111111111111111111111111111111111000111111111111100000000000000000000011111110111000000000000111111101100000011000000000111111111111111111000111111110000000000000001110111101111111111111111111111100111111111110011111111111101100000000011101001000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[344] = 640'b1111111111111111111111111111111111111111111111111111111111111100000110110111000000111111111111111000000000111111100000000000000000000110011111010000111000110000000000000000000010000111010111111111111111111111101111111111111111111111111111100001000011000001001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[345] = 640'b1111111111111111111110110000100000001111111111111111111111111110011100111111001111111111111111111000000000000000000000000000000000000000001000011000000000000000000000000000000100001111001111111111111111111111111111111111100000001101000000000001001000000001001000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110111111111110000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[346] = 640'b1111111111111111111111000000100100101111111111111111111111101111100011111111111111111111111111111101110000000000000000000000000000000000000100011000000001000000000000000000000000001110001111101111111111111111111101111111110011111110000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000111110111111111110000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[347] = 640'b1111111111111111111101000001111101111111111111111111111111111110111111000101111111111111111111111111010000000000000000000000000000000000000000011010110000000000000000000000000000001110000111000011111111110000000000011111111111111111111100000000000110000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110111111111110000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[348] = 640'b1111111111111010011010000000000111111111111111111111111111111111111100011111111111111111111111111111000000000000000000000000000000000000000000010011001001000000000000000011000001100000000011110111111110100000000000000100000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000111001111111111110000000000000000000000000000000000001011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[349] = 640'b1111111111111111111110001100000111111111111111111111111111111111100000011111111100001100111111100000000000000000000000000000000000000000110000000000100000000000000000000000000000000101111111100111111111111000000000000100010000000000000000000000110100000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001110000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[350] = 640'b1111111111111100010000001000000011111111111111111111111111111110001111111111111110111100111111100001000000000000000000000000000000000000111000000000110000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[351] = 640'b1111111111111111111000001110011111111111111111111111111111110000111111111111111111110101110111000000000000000000000000000000000000000000110000000000100000000000000000000000000000000001000100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[352] = 640'b1111111111111111111111111111111111111111111111111111111110001111111111111101111111111111111001100000000000000000000000000000000000000000000000100000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[353] = 640'b1111111111111100001100000000000001111111111111111111111000111000111111111001111111101000000000000000000000000000000000000000000000000100000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000001110000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[354] = 640'b1111111111111111111110011110001010011111111111111111111111111111111111100111111111010000000000000000000000000000000000000000000000001100000000100000000000000000000000000000000000000010100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[355] = 640'b1111111111111111000000000100000011011111111111111100111111111111111111111111111101110000000000000000000000000000010000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[356] = 640'b1111111111111110000000111111111010111111111111111101111111100000000000000000001011110000000000000000000000000000110000000001000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000001101001101001110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000010000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[357] = 640'b1111111111111000000001111111111111111111111110011111111111100000000000000000000001000000000000000000000000000000001000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000001000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000000000000000000000000000000010000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[358] = 640'b1111111111100000011111111111011111110111111111111111111111100011011100000000001100100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010000000000000000000000000000000000100000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[359] = 640'b1111111111100001111111111111111101111111111111111111111111111100000000000111000000001100000110000000000000000000000000000000000000000000000000000000000000000000100000000100111000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000010000000000000000000000000000100000000000000000000000000000000000000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[360] = 640'b1111111111111111111111011111111111111000111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110011011111110010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000001100000000000000000000000000000000000000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[361] = 640'b1111111111111111111100111111001111111111111111111111111111111111100001111111110011100000000000000000000000000000000000000000000000000000000000000000000000000000111110000001000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010010000000000000000000000000001100000000000000000000000000000000000000000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[362] = 640'b1111111111111111111111110001111100011111111111111111111111111110011111111110000111100011000001100011111010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000111101111111111100111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011011000000000000000000000000001100000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[363] = 640'b1111111111111111111111101111110001111111111111111111111111111000000001100000000000000000000000000000000000000000000000000000000000000000000000000001110011111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000100000000000000110011111110100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000011000000000000000000000000000000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000;
back_1[364] = 640'b1111111111100011111000111110001111111111111111111111111111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000010100011111111111101111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000011000000000000000000000000000000000000000001111110000000000100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[365] = 640'b1111111111111111111111111000011011111111111111111111111111100000000000000111011000111111101111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001011100000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000111000000000000000000000000000000000000001111111111000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[366] = 640'b1111111111111110011111110011111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000001000111100110010011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000110000000000000000000000000000000000000001011111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[367] = 640'b1111111111111001111100001111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000110000111110111111111111111111100100000001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000110000000000000000000000000000000000000001000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[368] = 640'b1111111111111111110000000111111111111111111111111111111111000000000000001111001011001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111110010100111000110010011111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000001110110000000000000000000000000000000010001111111111100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[369] = 640'b1111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000011000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111110000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100111000000000000000000001111100000000000000000000000000000000011001111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[370] = 640'b1111111111110000111001111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111011111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001111000000000000000000011100000000000000000000000000000000000001001111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[371] = 640'b1111111111101111111111111011100000000111111011111111111111100000011111111111111111111111111111100000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000001100110110111101111111000000000000000011111100000000000000000000000000000000001001111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[372] = 640'b1111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001111111111111111111111111111111111111000000000011111100011000000000000000000000000000000000000000000000000000000000000000000000000001111111111111101101000001111111111111111111111111011000001000000011000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000001001111111111110000000000000000000001111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000;
back_1[373] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000011110111111111101111111010011011111100110011111111111111111111111111111111011111100000000000000000000000000000000000000000000111001111000000000000000000000000000001011111111111111111111111111111111111111111001111111011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110001111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000001111111111111000000001100000111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000;
back_1[374] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110000000000000000000000000111111101111110011111111111111111111111011111111111111111111111000111000111101111011000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111000100000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111100000000000000000000000000000000000001111111111111000000001100000011111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[375] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000111100011111111111111111111111111111111111111111111111000000000000000000000000011011111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111000000000000000000000000000000000000000000000000000000000001011111111100111111100000000000000000000000000000000000000110011111111000000000100001100011111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[376] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000011000001111100011111110111111111111111111111111111111111111111111110001111000111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000001111010011111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[377] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111000011100011111111111111111111100001110000000011111110000000000000001111111111111111111111111111111111111111001111111001101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000111111100111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[378] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000001111100000000000000000000001110000000000000000000000000001100101111111111111111111000011011100111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100001111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[379] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000010111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[380] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000011000001001111111111111111111111111111111111111100000000000000000000000000000000000000;
back_1[381] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111011111100000000000000000000000000000000000000;
back_1[382] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[383] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[384] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[385] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[386] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[387] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[388] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[389] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001101000000000000000000000000000000000000000;
back_1[390] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000001111111100000000000000000000000000000000000000;
back_1[391] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000011100000000000000111111110000000000000000000000000000000000000;
back_1[392] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000001111111111110000000000000111111110000000000000000000000000000000000000;
back_1[393] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000011111111111111111110000000000000111111110000000000000000000000000000000000000;
back_1[394] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000111111111111111111111110000000000000111111110000000000000000000000000000000000000;
back_1[395] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000001111111111111111111111111110000000000000111111110000000000000000000000000000000000000;
back_1[396] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000011111111111111111111111111111110000000000001111111110000000000000000000000000000000000000;
back_1[397] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111000000000011111111110000000000000000000000000000000000000;
back_1[398] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111100000000010111111110000000000000000000000000000000000000;
back_1[399] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000011111111111111111111111111111111111111111100000001111111111110000000000000000000000000000000000000;
back_1[400] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000011111111111111111111111111111111111111111111100001111111111110000000000000000000000000000000000000;
back_1[401] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000001100000011111111111111111111111111111111111111111111110011111111111110000000000000000000000000000000000000;
back_1[402] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000001100000000111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000;
back_1[403] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000100001100000111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000;
back_1[404] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000100001100000111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000;
back_1[405] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000010000000000000000100001100000111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000;
back_1[406] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111001111111111100000000000000000000000000000000000000000000000000000000100001110000111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000;
back_1[407] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000100001100000111111111111111111111100000111111111111111111111011111111111111000000000000000000000000000000000000;
back_1[408] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000010000000000000000100001100000001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[409] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000010000000000000000100001000000000111101011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[410] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000010000000000000000100001100000000111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[411] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111001000000000000000000000000000000000000000000000000000000000000000010000000000000000100001100000100011101111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[412] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001110000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000100001100000111111101100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[413] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000010000000000100000100001110000111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[414] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000100000100001100011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[415] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000100001110000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[416] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000001100001110000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[417] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010100000000000000100001100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[418] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010100000000100000100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[419] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110100000000000000100001100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[420] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000001010000000000000000000000000000000100000000000000000100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[421] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000110000000000100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[422] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000001111000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000011111000000001100001100000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[423] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000001111111100000000000000000000000000000000000000000000000000010000000000000000000000000000111101111111111100001110000000101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[424] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011111111111111111111111111111111111111110000000000111101111010011110000000000000000000000010111111111111111100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[425] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[426] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[427] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[428] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[429] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[430] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[431] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[432] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[433] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[434] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[435] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[436] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[437] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[438] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[439] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111110000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[440] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[441] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[442] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[443] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[444] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[445] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[446] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000;
back_1[447] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000;
back_1[448] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000;
back_1[449] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110000001111100111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000;
back_1[450] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000011111111000000011111110011111100000000000;
back_1[451] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001111111111111000111111111111111111000000000;
back_1[452] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000001111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000111100000011111100110000011000000011100000000;
back_1[453] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001110100111111111111111111111111111111111111111111111111111111111111111111111111111111100001100000000001110000000000001110110000010000000001100000000;
back_1[454] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001110000111111111111111111111111111111111111111111111111111111111111111111111111111111111011100000000001100000000000000111110000000000000000110000000;
back_1[455] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010001111000111111111111111111111111111111111111111111111111111111111111111111111111111111100011100000000011000000000000000111110000000000000000110000000;
back_1[456] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111100111111111111111111111111111111111111111111111111111111111111111111111111111110000001100000000011000000111100000011110000000000000000110000000;
back_1[457] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001100000000111000000111100000011110000001111000000010000000;
back_1[458] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111101111111111111111111111111111111111111111111111111111111111111111111111111110000001100000000110000001101111111111110000001111000000010000000;
back_1[459] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111110000001100000000110000001100111111111110000001101000000011000000;
back_1[460] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111110000001100111111111110000001101000000011000000;
back_1[461] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111110000001100111111111110000001101000000011000000;
back_1[462] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100011110000001111000000111100000011110000001101100000011000000;
back_1[463] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011110000001111000000111100000011110000001111100000011000000;
back_1[464] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011110000001111000000000000000011110000001111100000011000000;
back_1[465] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011110000001111100000000000000111110000001111100000011000000;
back_1[466] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011110000001101110000000000001111110000001101000000011000000;
back_1[467] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001110000001100111100000000111100110000001101100000011000000;
back_1[468] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111111111111000111111111101111111110000000;
back_1[469] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111000000011111111000000011111110000111111100000000;
back_1[470] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000;
back_1[471] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000;
back_1[472] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000;
back_1[473] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000;
back_1[474] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000;
back_1[475] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000;
back_1[476] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000;
back_1[477] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000;
back_1[478] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000;
back_1[479] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000;
*/
/*
back_2[  0] = 640'b0000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  1] = 640'b0000000000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  2] = 640'b0000000110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  3] = 640'b0000000101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  4] = 640'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  5] = 640'b0000001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  6] = 640'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  7] = 640'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  8] = 640'b0010110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[  9] = 640'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 10] = 640'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 11] = 640'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 12] = 640'b0101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 13] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 14] = 640'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 15] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 16] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 17] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 18] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 19] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 20] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 21] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 22] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 23] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 24] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 25] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 26] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 27] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 28] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 29] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 30] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 31] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 32] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 33] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 34] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 35] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 36] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 37] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 38] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 39] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 40] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 41] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 42] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 43] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 44] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 45] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 46] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 47] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 48] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 49] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 50] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000001000000000000100000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 51] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111111111101100100111100000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 52] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111101111111111101111111111100100000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 53] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111100111111111101111111111100100000000000000000000000111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 54] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000110111111111101111111111101111111111100100000000000000000001111111111111111111111111111111111111110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 55] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111110111111111101111111111101111111111100100000000000000000000000000000011111111111111111100011111101110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 56] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111110111111111101111111111111111111111111111111101111111100000000000000000000000000000011011011110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 57] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111111111111111111101111111111111111111111111111111100111000000000000000000111011011111010000111000011111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 58] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011001111111111111111111111111111111111111111111111111111111111111100000000000000000111000000010001111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 59] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111011111111111111111111111111111111111111111111111111110111011111111111000000000001111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 60] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111011111111111111111111111111111111111111111010001111111111111111111111001011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 61] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111011111111111111111111111111111111111111101110000000111001001001111111001111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 62] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010011111111011111111111111111111111111111111111000000000000000111101111001111111111111111111111111111111111111111111111111011100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 63] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110011111111111111111111111111111111111111111110011000000001001111101111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 64] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011110111111111111111111111111111111111111111111100111100011001111111111111111111111111111111111111111111111111111111111101111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111;
back_2[ 65] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111110111111111111111111111111111111111111111101100111100111111111111111111111111111111111111111111101111111111100000000001000111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_2[ 66] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111110111100111111111111111111111111111111111111111111111111111111111000000000000000011100011111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011;
back_2[ 67] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111110111111110111111111111111111111111111111111111111111111111111111100000000000000011100001111111101111111111111111110111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_2[ 68] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111110011110111111111111111111111111111111111111111111100111111111110000000000000000110000010000011100110010111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100011;
back_2[ 69] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111111111111011111011111110111111111111111111111111111111111111100011111111111111100000000000000011000000000000000000111100100101111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010;
back_2[ 70] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111001111011111111111111111111111111111111111111110000001111111110000000000000001110000000000000000000000000101111101101011111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011110000;
back_2[ 71] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111101111001111111111111111111111111111111111111111111111111000111111111000000000000000011000000000011100000000000000000001111111011010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110000;
back_2[ 72] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111100101111100111101111111111111111111111111111111111111111111111111111110000000001000001110000000001100000000000000000000111111011111110110001000011111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100101;
back_2[ 73] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110110100011111101111111111111111111111111111111111111111111111111111100000000000000011100000000010000000000000000000011111111111111111111110110110111011000111111111111111111111111111111111111111111111111000011111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010000;
back_2[ 74] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111110110101110111111111111111111111111111111111111111111111111111110000000001000000110000100001110000000000000000101111111111111111111111111111110111110100110110000011111111111111111111111111111111111111111111000011110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000;
back_2[ 75] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111110110001111111111111111111111111111111111111111111111111111111100000000000000011100111000011100000000000000000011111111111111111111111111111111111111011100000010111001000001111111111111111111111111111111111111110000000001000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001101;
back_2[ 76] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110111111011101001001111111111111111111111111111111111111111111111111110000000000100000111000110001111000000000000100101111111111111111111111111111111111111111111111111100000000000011111100110011111111111111111111111111111000000000011111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111101010;
back_2[ 77] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000011111111111111111111111111111111111111111111111111111111000000011000001100000000011000000000000001011111111111111111111111111111111111111111111111111111110111111110001000000010001101000001111111111111111111111111100010001111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011;
back_2[ 78] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011111111111111111111111011111111111111111111111111111000000000110000111001110000110000000000000000111111111111111111111111111111111111111111111111111111111111000111111111100000000000001111010010001111111111111111111111001011000000010000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111100111;
back_2[ 79] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011111111111111111111111111111111111111111111000000000001100001110011100000100000000000000000011111111111111111111111111111111111111111111111111111111111111111000111111111111110000000000000000111100000011111111111111111001001000111111000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110011111111111000111;
back_2[ 80] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111110011111111111110000000000011000111100111000111000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111000111111111111110011100000000000101100010100001111111111111001111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111000000;
back_2[ 81] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111000001000001110000111001110011110000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111000000000000000010110000000111111111001111101111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111101111110011001;
back_2[ 82] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111001111111111110000010000011100011100111100011000000000000011111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111000010000000000001010100001111100111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111101111111101111110010000;
back_2[ 83] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111000000110000111001111001110001110000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111100100000001000001010111100100011111110111111011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111101111101011001;
back_2[ 84] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000001110001111011100011100000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111100000000000100011011111111111100101111001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111110111111111110001;
back_2[ 85] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110000001000001100000100111100111000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111011100000000001100111101111110111111110010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101101111110111101110111000;
back_2[ 86] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001100000011000000001111001110000100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111110000000000111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001110010111111111000;
back_2[ 87] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110011110001100001100001010011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111111110011111111100010001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000101000011111100000;
back_2[ 88] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011111111111111111111111110000011111111011111110000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111000001111110010;
back_2[ 89] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111000010111111111111111111111111111111111111111111111111111111111111110000000011111111111111111111111111111111111111111111111111111111111111111111111111111111011111100000111111111101111111111111111111111111111011111111110111111000011000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000001111011111;
back_2[ 90] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011101111111111111111111111111111111111111111111111111111111111111111111111110000000011111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111110001111111111111111000111111111011101110010010000000011100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100111111111010;
back_2[ 91] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111110000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111000111000001101001110110011000000011100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110001111111111011;
back_2[ 92] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111000001100011111111111111111111111111110011000111111111111111111111111111111111111111111111111111111111111111110101111111111111110100001111100011101100100000000000011100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111010011111111;
back_2[ 93] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111000000000000111101011111111111111111111111111111111111111111111111111111111111111111101111111000000111100111110000011111100000000000000011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111000111111;
back_2[ 94] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001000000000001111111101111111111111111111111111111111111111111111111111111111111111111111110100111111111111100011111001111111101000000000000011110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111101111;
back_2[ 95] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001000000111111111111110111000000011111111111111111111111111111111111111111111111111111111111100111111111111100011111001111111101100000000000011111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111011111111110111100;
back_2[ 96] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111011111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000001111111100111111111111111111111111111111111111111111111111111111111111111111000000000011111110011111111111101111110001111111101000000000000011111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111011111111110111110;
back_2[ 97] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110011111111111111111111111111111111111111111111111111111111111111111110000000010000000000000000000111000000000111111111111111111111111111111111111111111111111111110000000000000000111111111011011111111111110111111001111111101000000000000011111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111101111111111111111;
back_2[ 98] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101011111111111111111111111111111111111111111111111111111111111111000000000000011000000000000000000000100011000111111111111111111111111111111111111111111111000000000000000011100000000000000011011111111111100111111001111111101000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001010111111111111111111111111111110;
back_2[ 99] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111001011111111111111111111111111111111111111111111111111111111111111111111000001111100000000000000000000000111000101111111111111111111111111111111111111100011000000001111100000000000000000000001101111111111111111111000111111111100000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100101101111111111111111111111111110;
back_2[100] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111110000011111111111111111111111111111111111111111111111111111111111111111111111101101110000000000000000000101111110111111111111111111111111111100000000111111111001111111100000000000000011111111101101111111111111110010000111111101100000000000011111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010111111111110011111111111111;
back_2[101] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111101000111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111111111111111111111111110000000000110000111111111110000000000000000000001111111111111100001111111111111110011001111111101001000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000011011111111011111111111101;
back_2[102] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111000000011111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011111111111111111100000000000000011111110000000000000000000000011111001111111111111101010100111111001111111011001111100111000000000000011111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000010000100000111110011111101111100;
back_2[103] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111110000000011111111111111111111111111111111111110111111111111111101111111111110000000000000000000000000000000010000000000000000000000000111110000000000000000000000011111111111111111111111111110101101111111111101111100000000000000111101000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000100010000000000010001101110111101111101;
back_2[104] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111101100011111100100000111111111111111111111111111111111000000000011111111111111111111111111111111000000000000000000000000000000000000000001111100000000000000000000000111111111111111111111111111111111111111101111001111110000000000000000000000010111000000000011111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110001000000000010001011000010111111011111101;
back_2[105] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101100011111111000000001111111111111111111111110000000001110000000001001111111111111111111111111111100000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111110101111000000000000000000000100000000010111000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110000000000000000001000001100111111111001;
back_2[106] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111110110111111111111111111111111110000000111011000000000011111111111111111111111111111111000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111110101111000000000000000000000100000000010011100000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101001111000000000000000010000001000000111111011;
back_2[107] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000010000000000011011111111111111111111111100000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111100001111100000000000000000000110011001100011110000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110100000000000000000100000000001001110011;
back_2[108] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000011000001110000001111111111111111110000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111000001111000000000000000111111111111101001011001000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000011111111110100000000000010100010001000000000111;
back_2[109] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111001000000000001111001111101000011111111111000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000000011111111111111111111001011001101000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010111111000111111110000000000100000001001011000110010111;
back_2[110] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111111111111111111111111111111111111111111111111011100000000111111111111001100000000000000000000001110000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110111111111111111111111110001011111101111000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111000110111110011110000001111010110000000110011000;
back_2[111] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011111111111111111111111111111111111111111111111111111111111110000001111111111100000000000000000111001000000000000000000000001100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110111111111111111111111110000010110101111000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111101011111111110011100000000010010000010010000110000;
back_2[112] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111111111111111111100001000000000000000000000000110000000000000001000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000101111111111000001110111111111111000000000000000011110100100100000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011101111111111110101000000000110100001101100100100100;
back_2[113] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000011111111111000001110111111100000000000000000000011111110100100000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111001001111001001110110001001001111110;
back_2[114] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010011111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000000000000000001111111111000001110110000000000000000000000000011011110100000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111110001011000101100110000101001111110;
back_2[115] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111100111111111111111111111111111110000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111100000000000000000000001111111110000001110000000000000000000000000000011111110011100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111011000001111110011010010011111111;
back_2[116] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111100111111111111111111100000000111111111100000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000111110110000000000000000001111111100000001110000000000000000000000000000011101110011110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000011100111111111111110000000000111011110100011011111;
back_2[117] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111111111111111111111111111111001111111111100000000000111111111110000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000000000110100000000000000000011111000000000001110000000000000000000000000000011111111011110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111011101111111111111110001111000101110011100000011111;
back_2[118] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011111111111111111111111111111111111111111111111111000000000110111111110000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000110100000000000000100111111000000000001110000000000000000000000000000011111111001111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111000011111111111011110011000000100111001100100011111;
back_2[119] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111111111111111111111111111111111111111111000000000001111111100000000000000000111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111000110000111110000000111111111111111000000000001110000000000000000000000000000011110111101111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111100011100000101000010111101111111001110;
back_2[120] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111111111111111111111111111111111111111111111111111100000000000011111000000000000000001111111111111111111111111111111111111111111111111111111111111111101110111111111111000111011111111111111111111111111111111111111111111111110111110000001111111111111111111000000000001110000000000000000000000000000011111111100110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000000000000001000000000111100101111101110;
back_2[121] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000111111111111111111111111111111111111111111111111111101111111111111000000000000000000011111111111111111111111111111111111111111111111111111111111111111101110111111111111101001001111111111111111111111111111111111111111111111111100000111100001111111111110010111111000000000001110000000000000000000000000000011111011100110100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000000000000011111110111111111011;
back_2[122] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111111111111111100000000000000000001111111111111111111111111111111111111111111111111111110111111111110111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111110001011100101100001111111000000000001110000000000000000000000000000011111011010111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111100011101000000000111010110001001111011111111001;
back_2[123] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111111111111111111000000000000000111111111111111111111111111111111111111111101111111111111111110011111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111101111111111101100101111000000000001110000000000000000000000000000011111111110110011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101001110000001110000000101000111101011001011111111100;
back_2[124] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111111111111111111111111111111111111111111111111111111111101100000000000100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111000000000001110000000000000000000000000000011111101110010011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110111101100000111110001111111111011101001011111010010;
back_2[125] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111100000000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001110000000000000000000000000000011111101101011000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000111111101111111111110101110100000001111;
back_2[126] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001110000000000000000000000000000011111111111011110000010111111110111111111111111111111111111111111111111111111111111111111111111111111111111110000010000000000000011111111111111111111000111101011111111111;
back_2[127] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111000000001000001111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111000000000000000000000000000011111110111001110100000111010111111111111111111111111111111111111111111111111111111111111111111111100110011110010001100011111111111111111110111111111011111101111111111111;
back_2[128] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111110111111111110011111111111111111111111110010000000001111111111111111111111111111111111111111111111111111111111111111111111111111100111110011111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000011010000000000000000000000000011111111111101111001000011100000000111111111111111111111111111111111111111111111111111111111110001111010011000010111111111011111111111111101111101111111111100111111111110;
back_2[129] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111100100111111111111111111111111111101010001111111111111111111111111111111111111111111111111111111111111111111111111111111111110111100111110000010011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000010111000000000000000000000000011111111111100111100100001100111100001111111111111111111111111111111111111111111111100111111100000111111100111111111111011111111111111110111011110111000010100111111111110;
back_2[130] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000111111111111110111111111111000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000100010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001110011000000000000000000000000011111111011110111111101101110011101111000000111111111111111111111111001111111111110011000111111111111111110111111111110011111111001101101111111111011000001111111111111100;
back_2[131] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111101111110001111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111011100111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111110011100000000000000000000000011111111111110100111110101110110101111111000000111111111111111111111100110000000011111111111111111111011110011111111111111000000011001111111111111101000110011111111111000;
back_2[132] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111000111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111110111111111000111101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111000000000000000000000011111111101110010000000111111111110111111101111001111111111111000001000111111111111111111111111111111011111111111111110110000000000111111011111111111111011101011111110111;
back_2[133] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000101000000000000000000001111111000000000000000011000000000000000000000011111111111111011111100111111111110111101111101000111000000111111111000111111111111111111111111111111011111111111111110011000000001111100000111111111000101110011111111111;
back_2[134] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111001000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000011100000000000000000000011111111111111111001111111000000111111100111101000011011011111111111000111111111111111111111111111111011111101111111100011000000001111100000101011111000010110010001111111;
back_2[135] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111110011111111111111111111111000000000000011111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000111000000000000000000000011111111110111100011100111111110000011111111111000011001101111111111100111111111111111111111111111111111111100111111110000000000001111110000101011111010110011100011111111;
back_2[136] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111011111111111111111111111111111111111111111111111111111111111110001100000110111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000011111111111111111110000111000111111100000111111111011100001111111111111111111111111111111111111111011111011111011011111100101100001111000000000000011000011001101111111111;
back_2[137] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111110010111111111100111111111111111111111111111111111111111111111111010111110110111111111111111111111111111111111111110111111111111111111011111110111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000001110100000000000000000000011111111111011111110110000001110011111110000001101111110011111111111100111111111111111111010001000111110011111110101110000000000000000000000000000011000011101111111111111;
back_2[138] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111000111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111010111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000000000000000011111111111010001111000000000000011100011111000001111111111111111111111111111111110011111111111111111111011000000001100000000000000000000100000000011110111110110111111111;
back_2[139] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111110000011111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000101110100000000000000000011111111111100000011111110000000000001111100111111000000101111111111111111111111111111111111111110000000000000000000011000000000100000000100000000010100111111011011111111;
back_2[140] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111100000011110000111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101111100000000000000000001111111111111110000000111111000001011000000110001111111011111111111111111111111100000000000000000000000000000000000001111110000000000100111111111010110111111101101111111;
back_2[141] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111110000011111100111111110100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000011000000000000110100111110111000000000000001111111111111111110001111111111111011100000000011100011011111111111111110000000000000000000000000000000000000000000000011111111111111111111111110010110111111110111101111;
back_2[142] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111000011111000111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000111111110111100000000000000001111111111111111111111000111111111111100000000000000001111111100000000000000000000000000000000000000000000000000000011111111111111111111111111110111111011111111010011111;
back_2[143] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110000111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000011111110101111000000000000000111111111111111111111111110001111000111100000000010000000000000000000000000000000000000000000000000000011111111111111111111111110101111110111111111111011111111101011111;
back_2[144] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111100111111111011111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101001111111111111111111111110111111111111111111111111111000000111111111100010000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111110111111111111110110011;
back_2[145] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111110101111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111001111111111110000000000000000000000000010000000011111111111111111111111111111111111111111111110101111111110100010111111111111011111;
back_2[146] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111011111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000110111111111111111111111111111111111111111111111111111111111111111100011111111110000000000000001100000111000000011111111111111111111111111111111111111111111111111111111111111100011111111110001011;
back_2[147] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111111111111111111111100111111111111111111111111111111111111111111000011111000100111111111111111111111111111111111111111111111111111111111111111111111111110111001111100111111111111111101111;
back_2[148] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000100111100000000000000010001111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001011001111111111000110;
back_2[149] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110011111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011000100101111111101011;
back_2[150] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111011111111010011111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010110000000000000000000000011111111111011111111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111100111111000011;
back_2[151] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111010111111111111111111111111111111111111111111111111111111111111111111111111111000000000000010000000000000000000000000000000000000000000000000000000000000000000100000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000111111111111001111111111111111111111111111111111111111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111001111101101;
back_2[152] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000110000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100000000000000000000000000000000001100000000011110000000100000000000011111111111110000101101111111111111111111111111100011111111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111011000010;
back_2[153] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111110000010000000001111100000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000110111111111111111111000000000000000000000000000000111111100001110001000100000001000111111111110100000111111111111111111111111111100011111101111111110000011111111111111111111111111111111111111111111111111100001111111111111111111111111111111111000111111111111111000001000;
back_2[154] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111000000000000000001111000000000000000000000000000000000000000000000000000000000000000111000001100000000000000000000000000000000000000000000000000000000000000000111000101111111111111111111111000000000000000000000011011111111111110000010111111000000001001111111111100000000110111111111111111111111111100000111110111111111000011111111111111111111111111111111111111111000000011111111111111111111111111111111111111111000111111111111111001000010;
back_2[155] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111100001110000111011111111111111111111111000011000001000000011011111111110000000000111110111111111111111111111101111111110111111111000001111111111111010111111111111111111111111001111111111111111111111111111111111111111111111000111111111111000111111101;
back_2[156] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000100000010000000000000110000001000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111110001100001111111111111111111111111111111111011101100000111111111110000000000000111011111111111111111111111101111111010111111111000001111111111110000111111111111111111111111001111111111111111111111111111111111111111111111000111111111111111111111111;
back_2[157] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000001010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111110000000001111111111111111111111111111111000000110110001111111111100000000000000111011011111111111111111111100011111010111111111000001111111111100000111111111111111111111111111111111111111111111111111111111111111111111110000111111111111111111110011;
back_2[158] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000010000111000001000000100000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000011110011111111111111111111111111111111111111111000000111111111111111111110000000000000000000101111111111111111000000000000000111111111111111111111111111110000111010111111111000000111111111000000011111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111110110;
back_2[159] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000110000010000001000000000000000000000000000000000000000000000000000000000000001110000000010010000100000000000000000010011110111111111111111111111111111111111111111111111111111111110000000000000000000000001111111110011111111111111000000000000000111101111111111111111111111110000011010111111110000000101111111000000011111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111110101;
back_2[160] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111110001100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111000010010010000001000000000010010111011111111111111111111111111111111111111111111111001000000000000000000000000011111111111110000010110111111111111010000000000000001101111111111111111111111110000011000111111110000000000111110000000001111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111110000;
back_2[161] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111000001110011000000000000000000000000000000000000000000000000000001000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000111111001010000010010001001110100100110111111111111111111111111111111111111111111100000000000000000000001111111111111111100000000000000011010111111111111111111111111011101110111111111111111111111110000011000111111110000000000111110000000001111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111100001;
back_2[162] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111110000000000000000000000000000000000000000000000000000000000000111000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000100011111011010110010111011100010111111111111111111111111111111111111111000000000000000000000001111111111111111000001000011111111111110000011110111111110111011011101101010100110110111111111111111111110000011000111111111000000000111111000000001111111010100011111111111111111111111111111111111111111111111111111111111011111111111111101101011;
back_2[163] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110000000000000000000000000000000000000000000000000000001100000100000111000000000000000000000000000000000000000000000000110000000000000000000011001000000000000000100011111000110110110111111111111111111111111111111111111111100000000000000000000000011111111111111000001100111111111111111111111110000000011110000000000000001011111011001010111111111111111111111111111110011000111111110000000100111111000000000000000000110111111111111111111111111111111111111111111111111111111111111011111111111110100111111;
back_2[164] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111110000000000000000000000000000000000000000000011000000000001100000000000000000000000000000000000000000000000010000000000000010000111000110001000011001000000000000000111011111100111111111111111111111111111111111111100000000000000000000000100111111111111000000011111111111111111111111110111111111111110000011100000000000011111110000000000110011011011111111111111111110001111000111111110000001100111110000000000000000011111111111111111111111111111111111111111111111111111111111111110011111111111100111111111;
back_2[165] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111100000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000100110011001011111001110011100011011000000001000111111111111111111111111111111111111111110000000000000000000000011111111111111110110000111111111111111111111111111111111111111111111111100000111100000111111100000000000000000111011011111111111111111111110011111000111111110000001111111100000000000000000001111111111111111111111111111111111111111111111111111111111111111011011111110111111111111;
back_2[166] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110011101001111001110011011011100010111111101111111111111111111111111111111100000000000000000000001111111111011000000101111111111111111111111101111011111111111111111111111111111110000000011101101111101100100010000000000111011101111111111111111111110000111000111111110000000111111000000000000000000000000101111111100011111111111111111111111111111111111111111111111010011111101111111111111;
back_2[167] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111100000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000010000000110011111011111111111100111000111111111111111111111111111111111111111100100000000000000000001111111111110000000000011111111111111111111100000000001111111111111111111111111111111111111111111111101101101111111111110000000000000111101101101111111111111111110000110000111111110000001111111000000000000000000000000001111111111111111111111111111111111111111111111111111111110000011111111111111111111;
back_2[168] = 640'b1110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011100001100000000000000000000000000000000000000000000000000000000000000111000011000000000000000010000000110011111111011111111111111111111111111111111111111111111111000000000000000000000111111111111000000000000011111111111111111111000000011111111111111111111111111111111000000000011011111111111111000001111111101000000000000000000111101110111111111111111111110000110000111111110000001111111110000000000000000000001111111111111111111111111111111111111111111111111111111111111101101101111111111111111;
back_2[169] = 640'b1100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111100011100001000000000000000000000000000000000000000000000000000111011000000110101110000000000000000000000010111111111111111111111111111111111111111111111000000000000000000000000111111111111110000000000011111111111111111000000000001111111111111111111111111111111111110000000000000011111111111110001101111001111111111111100000000000011111111111110111111111111111110000110000111111110000001111111100000000000000000000000111111111111111111111111111111111111111111111111111111111110110111111111111111111101;
back_2[170] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111100000000000000000000000000000000000000000000000001111100111101111111100110111100110100010010000000000101111111111111111111111111111111111111111100000000000000000000011111111111110000000000011111111111111111111000000000000011111111111111111111111111111010101111011111000000000000000001011111111111111111100101010111111110000000000000001111111011111111111111111110000110000111111110000001111111100000000000000000101101111111111111111111111111111111111111111111111111111111111111110011001111111111111111;
back_2[171] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111010000111111110111000000000000000000000000000000000000000000010111111111111111111111111110110111101111100010010001011111111111111111111111111111111111100000000000000000000000111111111110100000000001111111111111111111000100111111111111111110111001011111111111111111111111001111111111111100000000000000001110111111101101100100101111111111111100000000000001111111011011111111111111110000110000111111100000001111111110000000010000011111111111111111111111111111111111111111111111111111111111111111111110110001111111111111111;
back_2[172] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110100000111111111111110111000000000000000000000000000000000000000000000111111111111111111111111111111111111000111110011111111111111111111111111111111111000000000000000000011111111111111100000000000111111111111111110010000000011111111111111111111011111111111110000000000111111111110111111111111111110000000000000001111110000000001111101100000000001111110100000000011111111101111111111111111110000110000111111100000001111111111000011111101111111111111111111111111111111111111111111111111111111111111111111111111011101111111111111111;
back_2[173] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000111011111111111111111111111100000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111110000000000000000001111111111111110000000001111111111111111111110000000101111111111111111111111111111111111111111111111100000000000000001111111111111111111110000000000000001110010011111111111101100000000000111111111100000011111111101101111111111111100110010000111111110000001111111111111001111111111111111111111111111111111111010111111111111111111111111111111111111111110101111111111111111;
back_2[174] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111110101111111111111111111111111000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111000000000000000001011111111110000000000000001111111111111111100000000011111111111111111111111111111111110011111111111111111000011110000000000000000111111011101001111110000000000000000100011111111111111110110000000000011111111110000011111111111111000011111111111000000001111111110000001111111111111111111111111111111111111111111000110001111111111111111111111111111111111111111111110101111111111111111;
back_2[175] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101111110101111111111111111111111100000000000000000000000001000000000110001111111111111111111111111111111111111111111111111111010000000000000000001111111110001000000000000111111111111100000000000011111111111111111111111111111111111100000000001111111111111000000001111111000000000000000111111000000001000010000000000000000000010111111111011111111000011110011100000000011111111111110111111111000111111111111000011111110000011111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111;
back_2[176] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111100000000000000000000000101010010001110011111111111111111111111111111111111111111110000000000000000000111111111111000000000000001111111111111100000000000111111111111111111111111111111111101111111111100000000000000000011111111101010111111000000000000000100011011111111100100000000000000000000000111111111100111000111111111110000000000011111111111110111111111111111000011111111111000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111110111000011111111111111111;
back_2[177] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111110000011111111110000000110001000000110111111111001110011111111111111111111111111111111110010010000000000011111111111100000100000001011101011100000000000000011111111111111010111111111111111100111111111101111111101111110000000000000011111101110100111111000000000000000000011111111110010000000000000000000000000111111110110111111111111111010000000000011111111111111000001111111111111111100011111111110001111111111111111111111111111111111111111111111111111111111111111101100110000000011100111111111111110111111111111111111;
back_2[178] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111110000000010000011110000000000001110011111111111111111111001000111111111111111111111110000000000000011111111111111111100000000011111111111111000000000000000111111111111111111111111111111110000000011111111111110111101101011101110000000000000011111100011110110011000000000000000000100111111110000000000000000000000000000111100001110111111111111111110000000000011111111111111111111000001111111111000111100011111111111111111111111111111111111111111111111111111111111111000001000000000111100111111101111111111111101111111111111111111;
back_2[179] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111110111110010000000000000000000001110011111111111111111111111111111111111111100000000000000011111111111110000000000111111111111111111100000000000000010001110111111111111111111111010111111111000000000000000000111111110111101111110000000000000010001111111111111110000000000000000000000111111111000000000000000000000000001111100001110111111111111111110000000001011111111111111111111111111100011111111111001111100011111111111111111111111111111111111000000000110010000010000000101111111111010011111111111111111110000011111111110111111;
back_2[180] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111110000000000000000000000000011001100111111111111111111111111111111000000000000000111111111100000000000000011111111111111001100000111111111111111000010001111111111111111111111110011111111001111000000000000000011111101000001111110000000000000001001111111111001000000000000000000000000111111111100000000000000000000000001111100011111111111111111111110000000011111111111111111111111111111111110001111111111110000000011111111111111111111000000000000000100000000000000000000011111111111111111111111111111111111111001010111111111111111;
back_2[181] = 640'b1111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111110111110000000000000000000000001111111111100001111111101111111111111000000000000011111111111100000000000000111111111111000000000000111111111111111111111111111111111110001111111111111111101111111101111111100000000000000011111101111111100110000000000000000000011111111100000000000000000000000000111111111100000000000000000000000001111100111111111111111111111110000000011111111111111111111111111111111111111100000111111000000000000000000000000000000000000000000011100011000000000000011111111111111111111111111111111111111101110011111111111111;
back_2[182] = 640'b1111111111111111110110011111111111111111111111111111111111111111111111111111111111111111111111111111111010110000000000000000000000011111111111111111111111111110000000000001111111111100000000000000001111111111110000000000111111111111111111111111111111111111111111111111100000000000000001111110111111011111100000000000000010001111111111111100000000000000000000011111111110000000000000000000000001111111111110000000000000000000000001111100111111111111111111111110000000001111111111111111111111111111111111111111111100001110000000000000000000000000000000000000000001110111100000000111111111111111111111111111111111111111111000000011111111111111;
back_2[183] = 640'b1111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000001111111111111111111111001000000010111111111111000000000000000110111111100000000000111111111111111111111111111111111111111111111111100000000111100000000000000000111110010000011111100000000000000000010111111111000000000000000000000000111111111111000000000000000000000001111111111110000000000000000000000001111100111111111111111111111110000000000111111111111111111111111111111111111111111110111011110000000000000000000000000000000000000001111111111001111111111111111111111111111111111111111111111100000011111111111111;
back_2[184] = 640'b1111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001101111111111111000000000000101111111111111000000000000111111111111111111111111111111111101000000111111111111111100000011111110000000000000000110010011111110001000000000000000000000011111111100000000000000000000000011111111111000000000000000000000001111111111110000000000000000000000001111100111111111111111111111110000000001011111111111111111111111111111111111111111111111111111110000000010000000000000000000000001111111111111111111111111111111111111111111111111111111101111000000111111111111111;
back_2[185] = 640'b1111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111110000000000000000111111111111010000000011111111111111111101111111111111111111011111111111110000000000000011111110001111111110000000000000000110011111111111110000000000000000000000111111111100000000000000000000000011111111111000000000000000000000001111111111110000000000000000000000001111100111111011111111111111110000000001011111111111111111111111111111111111111111111111101111111111000111111000111111111111111111111111111111111111111111111111111111111111111111111111111110010000111111111111011;
back_2[186] = 640'b1111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111110000000000000111111111111110000000010111111111111110011111111111100011111111111111111101100011110000000000000010111100011111111110000000000000000000000111111110000000000000000000000000111111111110000000000000000000000011111111111000000000000000000000001111111111110000000000000000000000001111100011111011111111110000100000000000011111111111111110111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001001111111111011111;
back_2[187] = 640'b1111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111100010000000101101111110111011101111110011111111111111111111111111100000111111111111111100001111111000000000000011101101111111111110000000000000000000001111111111000000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111110000000000000000000000001111100011111011111111110000000000000000011111111111111100100101111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111011110;
back_2[188] = 640'b1111111111111101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111110010000000111111111111110001000111111111111111111111111111110001111000000000000111111111111111111000000000000001001111111111111000000000000000000000001111111111100000000000000000000000111110111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111011110000000000000000000000011111111111111111111101101001111111111111111111100000111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111100111111111111111111;
back_2[189] = 640'b1111111111111010011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111110010000010111111111111111111111111111000011111111111111000000111111000000000000111110001001111111000000000000000000011111111110000000000000000000000000111111111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111011100000000000000000000000011111111111111111111111111111010010111111111111100000111111111111111111111111111111111111111111111111111111111111111111111111111100111111011111111111000111111111111111111;
back_2[190] = 640'b1111111111110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111110110111111101111111111111111111111111111111100000000000011111111111111111100000000000110010111111111110000000000000000000011110111111000000000000000000000001111011111110000000000000000000000111110111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111011100000000000000000000000011111111111111111111111111111111110000000111111110000111111111111111111111111111111111111111111111111111110110111111111111111111101111111111111111110000111111111101111111;
back_2[191] = 640'b1111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111011111111111111111110001111111111111110000000111110000000000011111000100111111100000000000010101111111111100000000000000000000011110111111000000000000000000000001111001111110000000000000000000000111110111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111011100000000000000000000000011111111111111111111111111111111111111100000100000101111111111111111111111111111111111111111111101100100110010010111111111111111111111111111111111111101111111111111101011;
back_2[192] = 640'b1111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111000000000000111111100011111110000000000011011011111111111000000000000000000111111111000000000000000000000011100111111000000000000000000000001111000111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111001000000000000000000000000011111111111111111111111111111111111111111111000011111111111111111111111111111111001001001001100101100111111111111111111111111111111111111111110111111111111111111111111111;
back_2[193] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111100010000111100000000000111111111001111110000000000010011111111111110000000000000000000111011111100000000000000000000011100111111000000000000000000000001111111111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111001000000000000000000000000011111111101111111111111111111111111111111111111100011101011111111011011011001001001001101101111111111111111111111111111111111111111111110111111111111111111111111111111111;
back_2[194] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111100000011111100000000000111110111111111111000000000000100011101111100000000000000000000111011111100000000000000000000011100111111000000000000000000000001111001111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111001000000000000000000000000011111111101111111111111111111111111111111111111100000111011000010011011011011111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111;
back_2[195] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111110000000000110110111111111100000000000000000011001111110000000000000000000110011111100000000000000000000011100011111000000000000000000000001111011111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111000100000000000000000000000011111111101111111111111111111111111111111111111100000000111111111111111110111110111111111111111111111111111111111111111111111111111000000001111111110000111111111111111111;
back_2[196] = 640'b1111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111110111111111110000000000001100111111111100000000000000000011001111110000000000000000000110001111100000000000000000000011110011111000000000000000000000001111110111110000000000000000000000111111111111000000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111000100000000000000000000000011111111101111111111111111111111111111111111111000000111111111111111111111111111111111111111111111111111111111111111111111111111000010110010001111111110111111111111111111;
back_2[197] = 640'b1111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111110111111111100000000000000000111111111100000000000000000011000111110000000000000000001100000111100000000000000000000011110111111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111100000000000000000000001111111111111000000000000000000000001111100011111000000000000000000000000000011111111101111111111111111111111111111111111111000000011111111111111111110111110010111111111111111111111111111111111111110001111111111111111110011111110001111111111111111;
back_2[198] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111000000000000000000110111111100000000000000000011000011110000000000000000001110000111110000000000000000000011110111111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111100000000000000000000001111111111111000000000000000000000001111100011111100100000000000000000000000011111111101111111111111111111111111111111111111000000011111111111111111111111111111111111111111111111111111111111111111111011111111111111111111011111111101111111111111111;
back_2[199] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111100111011111100000000000000000110111111100000000000000000111000111110000000000000000001110010111110000000000000000000011111111111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111100000000000000000000001111111111111100000000000000000000001111110011111100000000000000000000000000011111111101111111111111111111111111111111111110000000000111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111101110111011111111111101;
back_2[200] = 640'b1111111111110111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111101100011111100000000000000000111101111100000000000000000111000111110000000000000000001111011111110000000000000000000011111011111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111100000000000000000000001111111111111100000000000000000000001111110011111100000000000000000000000000001111111111111111111111111111111111111111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111011111111111111111;
back_2[201] = 640'b1111111011111111100111111111111111111111111111111111111111111101111111111111111111111111111111111111111111001111111111111111111111111111111101100011111100000000000000000111111111100000000000000000111010111110000000000000000001111011111110000000000000000000011111111111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111110000000000000000000001111111111111000000000000000000000001111110011111100000000000000000000000000001111111111111111111111111111111111111111111111000000011111111111111111111110000000011111111111111111111111111111111111111111111111111111111111111111111100011011111111111;
back_2[202] = 640'b1111111011110011101111111111111111111111111111111111111111111111111011111111111111111111111111111111111111001111111111111111111111111111111101111001111100000000000000001111111111100000000000000000111010111110000000000000000001111011111110000000000000000000111111011111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111110000000000000000000001111111111111100000000000000000000001111110011111100000000000000000000000000001111111111111111111111111111111111111111111111000000000111111111111100000000000000000111111111111111111111111111111111111111111111111111111111111111100110010110111111111;
back_2[203] = 640'b1111110111100111111111111111111111111111111111111110111111111111111001111111111111111111111111111111111110001111111111111111111111111111111101110001111100000000000000001111111111100000000000000000111110111110000000000000000001111011111110000000000000000000111111111111000000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111111000000000111111111111000000000000000000011111111111111111111111111111111111111111111111111111111111111101010001111101111111;
back_2[204] = 640'b1111100001000111111111111111111111111111111111111111111111110111100000111110111111111111111111111111111110111111111111111111111111111111111101110001111100000000000000001111111111100000000000000000111111111110000000000000000001111011111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000011111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111111000000000111111111111000000000000000000100111111111111111111111111111111111111111111111111111111111111100000110111111111101;
back_2[205] = 640'b1111001111001111111111111111111111111111111111111110111111111110110000100111111111111111111111111111111110111111111111111111111111111111111101110011111100000000000000001111111111100000000000000000111111111110000000000000000001111011111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111111100000001111111111000000000000000000000001111111111111110000001010111111111111111111111111111111111111110011010011101111100;
back_2[206] = 640'b1111111110111111111111111111111111111111111111111111111111111111100010000000000110111111111111111111111110111111111111111111111111111111111101111011111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111111000000001111111111000000000000000000000000111111100000011111111111111111111111111111111111110111111111110000101011111111110;
back_2[207] = 640'b1111101110111111111111111111111111111111111111111111111111111111110011111110111001111111111111111111111110111111111111111111111111111111111101111111111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111110000000000001111010000000000000000000000000011111110011111111111111111111111111111111111111111111111111110110110101111111110;
back_2[208] = 640'b1110111101111111111111111111111111111111111111111011111111111111111011111111111100001111111111111111111101111111111111111111110001111111111101111111111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110001111100000000000000000000000000001111111111111111111111111111111111111111111110000000000011110000000000000000000000000011111111111111111111111111111111111111111111111111111111111111110110110101111111111;
back_2[209] = 640'b1101101101011111111111111111111111111111111111111111111110110000010011111111111000001111111111111111111101111111110000000000000001111111111111111101111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000000001111111111110000000000000000000000111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110000111100000000000000000000000000001111111111111111111111111111111111111111111100000000000011100000000000000000000000000011011111110111111111111111111111111111111111111111111111111111110100001000111111011;
back_2[210] = 640'b1001101101111111111111111111111111111111111111100111000111111110000111111111111000001111111111111111111011111000000000000000000011111111111111111111111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000000011111111111111111110011000000000001111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110000111100100000000000000000000000001111111111111111111111111111111111111111111100000000010111100111000000000000000000000001111111111111111111111111111111111111111111110111111111111111110100000010101111100;
back_2[211] = 640'b0011111011111111111111111111111111111111111011000110111111111111111111111111110111001111111111111111101111111111000000000000000001111111111111111111111100000000000000001111111111100000000000000000111111111110000000000000000001111111111110000000000000000000111111111111100000000000000000001111111111111111111110000000000000001111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110000111100100000000000000000000000001111111111111111111111111111111111111111111100000000000111100010000000000000000000000011111111111111111010010011111111111111111111101111111111111111110010000010111111111;
back_2[212] = 640'b1111111011111111111111111111111111111111111100001111111110111110101111111111110111111111111111111111101111111000000000000000000001111111111111111111111100000000000000001111111111100000000000000001111111111110000000000000000001111111111110000000000000000000111111111111100000000000000011011111111111111111111111011100000000001111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110000111100000000000000000000000000000111111111111111111111111111111111111111111100000000001111110110000000000000000000000011111111111111110100000011111111111111111111111111111111111111111000010011010110111;
back_2[213] = 640'b1111111110111111111111111111111111111111111100001101111111111110001111111110111011001111111111111111110110000000000000000000000001111111111011111111111100000000000000001111111111100000000000000001111111111110000000000000000011111111111110000000000000000000111111111111111111110000000011011111111111111111111111000000000000001111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110010111100100000000000000000000000000111111111111111111111111111111111111111111100000000001111110110000000000000000000000011111111111111100000100011111111111111111111111111111111111111110010100100111111111;
back_2[214] = 640'b1111111111111111111111111111111111111111111001110111101111001000001111111110111111001111111111111111111101111000000000000000000011111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000000111111111111111111110100111111111111111111111111100000000000000000001111111111111100000000000000000000111111111111110000000000000000000001111111111111100000000000000000000001111110010111100000000000000000000000000000111111111111111111111111111111111111111111110000000000111110100000000000000000000000011111111111111100001100001111111111111111111111111111111111111111000001001011111111;
back_2[215] = 640'b1111111011111111111111111111111111111111100010011001111001011110000111111111111011011111111111111111111111111111100100000000011111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011110111111110000000000000000000111111111111111111110000000000000011111111111111000000000110000000001111111111111100000000000000000000111111111111110000000000000000000111111111111111100000000000000000000001111110010111100000000000000000000000000000111111111111111111111111111111111111111111110000000000001110000000000000000000000000011111111111111110001000001011111111111111111111111111111111000110000010001101001000;
back_2[216] = 640'b1111110111111111111111111111111111111111101000101000000000010000001101111111110111011111111111111111111111111111111111111111111111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011110111111110000000000000000000111111011111111000000000000000000011111111111111000000000000000000001111111111111100000000000000000000111111111111110000000000000000001011111111111111100000000000000000000011111110010111100000000000000000000000000000111111111111111111111111111000111111111111111000000000111110000000000000000000000000001111111111111111100001011111111111111111111111111111111100001110000000110101001001;
back_2[217] = 640'b1111110111111111111111111111111111111111100010000000011000000000001100111111110011011111111111111111111011111111111111111111111111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000000111111011111110000000000000000000011111111111111000000000000000000001111111111111100000000000000000001111111111111110000000000000000000001111111111111100000000000000000000011111110010111100010000000000000000000000000111111111111111111111111111010111110111111111000000001111110000000000000000000000010101111111111111101000001111111111111111111111111111010100111011111100001011110100001;
back_2[218] = 640'b1111110111111111111111111111111111111111001000000011111111110001110111110111110111001111111111111111111011111111111111111111111111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000001111100011111110000000000000000000011111111111111000000000010000000001111111111111100000000000000000001111111111111110000000000000000000011111111111111100000000000000000000011111110000111100000000000000000000000000000111111111111111111111111111111111111110000001000000000111100000000000000000000000000011111111111111111111111111111111111111111111011011111111001111111000000111001110011;
back_2[219] = 640'b1111111111111111111111111111111111111111110000011111111111110100111111111111110111011111111111111111111011111111111111111111111111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000001111100011111100000000000000000000011111111111111110000001110000000001111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100000000000000000000000000000111111111111111111111111111111111111111111111000000000000000000000000000000000000000001111111111001111111111111111111111111111111111111111111100111101010000111010000110;
back_2[220] = 640'b1111111111111111111111111111111111111111101100110001111111111100011111011111110001001111111111111111111011111111111111111111111111111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000001111111011111100000000000000001111111111111111111111111001110000000001111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100000000000000000000000000000111111111111111111111111111111111111111111111000000000000100000000000000000000001001111111111111111111110101111111111111111111111111111111100011011111101111111001000000;
back_2[221] = 640'b1111111111111111111111111111111111111111010010000011111111111100000111001101100000001111111111111111111011111111111000000000000011111111111011111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111110000000000000000001111111111111110000000000011111111111111111111111111111101110000000001111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100000000000000000000000000000111111111111111111111111111111111111111111101001100000011100000000000000000011011111111111111111111111100110001111111111111111111111111111101001001110110110111000111010;
back_2[222] = 640'b1111111111111111111111111111111111111110000000000000101111110100000001011101100000000111111111111111111111100000000000000000000011111111111111111111111100000000000000011111111111100000000000000001111111111110000000000000000011111111111100000000000000000001111111111111110000000001111111111111111111111111111111111110000000011111111111111110000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100000000000000000000000000000111111111111111111111111111111111111111111100111100000000110000000000000000000111111111111111111111111001101111111111111111111111111111111111111110111110101010001100001;
back_2[223] = 640'b1111111111111111111111111111111111101100110111000000010000111000001000000100100000000011111111111111110111111110111111111111111111111111111111111111111110000000000000011111111111100000000000000001111111111110000000000000000011111111111100000000000000000001111111111111110000011111111111111111111111111111111111111110000000001111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100010000000000000000000000000111111111111111111111111111111111111111111111111100000001011000000000000000001100111111111111111111111101101111111111111111111111111110011101100011111110101111111110011;
back_2[224] = 640'b1111111111111111111111111111111111001111000110000000000011001000000110000000000000000100111111111111110111111111111111111111111111111111111111111111111110000000000000011111111111100000000000000001111111111110000000000000000011111111111100000000000000000001111111111111111000111111111111111111111111111111000000000110000000001111111111111100000000000000000001111111111111110000000000000000000011111111111111100000000000000000000011111110000111100010000000000000000000000000111111111111111111111111111111111111000111111111100000011111100000000000000011011111111111111111111111111110111111111111111111110111111110010000001111001011001110100111;
back_2[225] = 640'b1111111111111111111111111111111100011100010001011111100000000000000000101000000000000100111111111111110111111111111111111111111111111111111111111111111110000000000000011111111111100000000000000001111111111110000000000000000011111111111100000000000000000001111111111111111001111111111111111111111111111111011111111111000000001111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100010000000000000000000000000111111111111111111111111111111110111111111011111100000000111100000000000000011111111111111111111111111111111111111111111111111001010000101001110111111000000011111011111;
back_2[226] = 640'b1101111111111111111111111111111001101100010011101001100000000000000000010001000000000000100001111110110111111111111111111111111111111111111111111111111110000000000000011111111111100000000000000011111111111110000000000000000011111111111100000000000000000001111111111111111000000000000000011111111111111111111111111101000000011111111111111100000000000000000000111111111111110000000000000000000011111111111111100000000000000000000011111110000111100010000000000000000000000000111111111111111111111111111111101111111110011111100000000111100000000000000011111111111111111111111111111111011111111111111000001100000001111111111111001100011101111111;
back_2[227] = 640'b1101111111111111111111111111110011001000000111111101100000001100000000000001000000000000000010111100110111111111111111111111100111111111111111111111111100000000000000111111111111100000000000000011111111111110000000000000000011111111111110000000000000000001111111111111111000000010111111111111111111111111111111111000000000111111111111111100000000000000000000111111111111110000000000000000000011111111111111110100000000000000000011111110000111100010000000000000000000000000111111111111111111111111111111100011111111011111100000011111111100001000101111111111111111111111111110000011011111111011110011110010010001111111111110110001001010111000;
back_2[228] = 640'b0111111111111111111111111111110011000100001101111101110000000000000000000000000000000000000000011001100111111111111111111111111111111111110111111111111110000000000000111111111111100000000000000011111111111110000000000000000011111111111110000000000000000001111111111111111011111111111111111111111111111111111111010000000000111111111111111110000000000000000000111111111111110000000000000000000001111111111111111111000000000000000011111110000111100010000000000000000000000000001111111111111111111111111111100011111111111111100000011111111111111100011111111111111111111111100000000001111111111101111111100100111111011111111111101100000101110011;
back_2[229] = 640'b0011111111111111111111111111111011000000000010011100000010010010000000000001000000000000000100000100011111111111111111111111111111111111110111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111110000000000000000001111111111111111011111111111111111111111111111111111111110000000000011111111111111100000000000000000000111111111111110000000000000000000001111111111111111111100000000000000011111110000111110010000000000000000000000000001111000000111111111111111111100011111111111111100000011111111111111111001111111111111111111111100000011110011111111011101111110000001111111101111111000000100001000111;
back_2[230] = 640'b0011111111111111111111111111101111000000001110000011000000000110000000100001100000000000000000000000001111111111111111111110000011111111110111111111111111000000000000111111111111100000000000000011111111111110000000000000000111111111111110000000000000000001111111111111100011111111111001111111111111111111111111110000000000111111111111111100000000000000000000111111111111110000000000000000000001111111111111111001100000000000000011111110000111110010000000000000000000000000001111000000011111111111111111111000101101111111100000011111111111111111100111111111111111111111000000111110011000111101111110001111011011110111111111000010101000100111;
back_2[231] = 640'b0011111111111111111111111111100110011000000000000000000000000110000000000000000000000000000000000000001111111111111111111110001111111111110111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111110000000000000000001111111111111000011111111111111111111111111111111111111110000000001111111111111111100000000000000000000111111111111110000000000000000000011111111111111110110110000000000000011111110000111110010000000000000000000000000001111010010001111111111111111111000110101111111100000011111111111111101111111111111111111111111001111111001111111111111110111011111111111111011111111010000111111100001;
back_2[232] = 640'b0010111111111111111111111111100000000000000000000000000000000100100000000000001000000000000001101100001111111111111111111100000011111111110111111111111100000000000000111111111111100000000000000011111111111110000000000000000111111111111110000000000000000001111111111111100011111111001111111111111111111110000011111000000001111111111111111100000000000000000000111111111111110000000000000000000001111111111111111111010000000000000011111110000111110010000000000000000000000000001111011110001111111111111111110000111001111111100000011111111111111000011111111111111111111111111111111111111111111000001100111111111111111101111111010010100010010001;
back_2[233] = 640'b0111111111111111111111111111000000000010000000000000000010000000010000000000000000000000000000100000000111111111111111111100100011111111110111111111111100000000000000111111111111100000000000000011111111111110000000000000000111111111111110000000000000000001111111111111100011111100000000000011111111111110000011111010000011111111111111111100000000000000000000111111111111110000000000000000000001111111111110000011101001000000000011111110000111110010000000000000000000000000001111011111000111111111111111100000100001111111100000001111111100000000000000000011111111111111111111111111111111111000100011111111111111111111111111111101101110000010;
back_2[234] = 640'b0111111000111110010011010000000000000101011001100000000000011000000000000000000000000000000010000010000111111111111111111100000011111111110111111111111110000000000000111111111111100000000000000011111111111111000000000000000111111111111100000000000000000001111111111111100010111100000000000011111111111110000011110000000011111111111111111110000000000000000000111111111111110000000000000000000001111111111101111111111001000000000011111110000111110010000000000000000000000000001111011110000111111111111111100000101001111111100000011111111100000000000000000011111111111111111111111111111111111111101111111111111111111111111111111011011010010101;
back_2[235] = 640'b0001110000111100011000110010000000010110100100000000100110011111111100000000000000000000000011000000001111111111111111111100000011111111110111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111110011111000000000000011111111111110000011110000000011111111111111111110000000000000000001111111111111110000000000000000000001111111111000010001001110000000000011111110000111110010000000000000000000000000001111011110100011111111111111100000101001011111100000011111111111000000000000000011111111111111111111111111111111111110111111111111111111111111011111100110110111111111;
back_2[236] = 640'b0100110001110000110101101000011110000110110010000000000111011101111110000000000000000000000001000001001111111111111111111100000011111111110111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111110011111000000000000011111111111110000011110000000011111111111111111110000000000000000001111111111111110000000000000000000011111111111101011011000100000000000001111111000111110010000000000000000000000000001111111100100011111111111111100001001101011111000000011111111100000000000000100111111111111001111111111111111111111111111111110111111111111111100111101111111111111111;
back_2[237] = 640'b0110000011000110001000000011110111001111010000000010000111111110011011110000000000000000000000000111001111111111111111111100000011111111110111111111111100000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111100111111000000000000011111111111110000011011000000011111111111111111100000000000000000001111111111111110000000000000000000011111111111111111111110010000000000001111111000111110010000000000000000000000000001111111101110111111111111111110001011101011111000000111111111111100000000111110111111111110001111111111111111111111111111111111110011111111111110111110011111111111111;
back_2[238] = 640'b0110000000000000000000000111111100100000000000000001111111111111011000000000000000000000000000010010001111111111111111111000000011111111111111111111111100000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111110111111000000000000011111111111110000010011001001111111111111111111110000000000000000001111111111111110000000000000000000011111111111000000000000011000000000001111111000111110010000000000000000000000000001111111001110111111111111111110000010100011111000000111111111111111000011111111111111111111001111111111111111111111111110111111111111111111111110011110111111111111111;
back_2[239] = 640'b0110000000000000000100000111111111000111100000000000011111111111110000000000000000000000000000000000001111111111111111110000000011111111111111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111111111110000000000000011111111111110000011111001001111111111111111111111100000000000000001111111111111110000000000000000000011111111111000000000000000000000000001111111000111110010000000000000000000000000001111110011111111111111111111111111010110011111000000111111111111110000001111111111111111111111111111111111111111111111111110110111001111111111111011110111111111111111;
back_2[240] = 640'b0000000000011110000000000111111110001011000001100000000111111111111100000000000000000000000000000000001111111111111111100000000011111111111111111111111110000000000000111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111111110000000000000000011111111111110000011111001001111111111111111111111110000000000000001111111111111110000000000000000000001111111111100000000111000000000000001111111000111110010000000000000000000000000001111100011110111111111111111111111100110011111000001111111111111111111111111111111111111111111111111111111111111111101111111010011110111110001111001011111110111111111;
back_2[241] = 640'b0000010001111000000000001111111110000100100001000100001111111111111100000000000000000000000000000000001111111111111111100000000011111111111111111111111110000000000001111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111111111110000000000000011111111111110000011111011001111111111111111111111110000000000000001111111111111110000000000000000000001111111111100000000000100000000000001111111000111110010000000000000000000000000001111100100110111111111000000111111111100011111000001111111111111111111101101111111111111111111111111111111111111111111110111110111111111111100100001101111111011111111;
back_2[242] = 640'b0001100000000000000001100111011101001111000001101111111111111111111111100000000000000000000000000000001111111111111111000000000011111111111111111111111100000000000001111111111111100000000000000011111111111110000000000000000111111111111100000000000000000001111111111111111110110000000000000011111111111110000011111011001011111111111111111111110000000000000001111111111111110000000000000000000001111111111110000000000000000000000001111111000111110010000000000000000000000000001111100111110111111110001111111110000000111111001111111111111111110000000000111111111111111111111111111111111111000111100001010111111111111111111001000011111111111110;
back_2[243] = 640'b0011000111000000000011100111111001101111000001110000111111111111111111110000000000000000000001000000001111111111111100000000000111111111101111111111111100000000000001111111111111000000000000000011111111111110000000000000000111111111111100000000000000000001111111111111111111110000000000000011111111111110000011111001000111111111111111111111100000000000000001111111111111110000000000000000000001111111111111000000000000000000000001111111000111110010000000000000000000000000001111100111111111111100011001111110101000111000001000111111111111100000000000000111111111111000000000000000000000000000000000111111111111111111111110011111111111111111;
back_2[244] = 640'b1100000000000000001011111110000100000000000011000000100011111111111111000000000000000000000000000000001111111111111110000000000111111111101111111111111100000000000001111111111111000000000000000011111111111110000000000000000111111111111100000000000000000011111111111111111110110000000000000011111111111110000011111001000010011111111111111100000000000000000000111111111111110000000000000000000001111111111111000000000000000000000001111111000111110010000000000000000000000000001111100001101111111000111111111100111110111000011111111111111111110000000000000111111000000000000000000000000000000000000000001111111111111111100111111111111111111111;
back_2[245] = 640'b1100000000001111110010111111000100000000000111011001000001111111111111110000000000000000001000000000011111111111111100000000000111111111101111111111111100000000000001111111111111000000000000000111111111111110000000000000000111111111111100011000000000000011111111111111111110110000000000000011111111111110000011111011000110011111111111111100000000000000000000111111111111110000000000000000000001111111111111111110010000000000000001111111000111110010000000000000000000000000001111100000111111110001111111111110111100100111111100111111111111111000000000010111110000000000000000000000000000000000000000001111111111111111011111110110111111111111;
back_2[246] = 640'b0010000000000010000111011111001100000000001100011011000000111111111111110000000000000000001000000001011111111111111000000000000111111111101111111111111100000000000001111111111111000000000000000111111111111100000000000000000111111111111100111000000000000011111111111111111111110000000000000011111111111110000011111011000011011111111111111100000000000000000000111111111111111000000000000000000001111111111110110001001000000000000001111111000011110010000000000000000000000000001111100000111111110000111010111111000001111111111111111111111111111111111111101111111000000000000000000000000000000000000000111111111111111111011111110111111111111110;
back_2[247] = 640'b0001001100001110010011011000011000000000001000011110000110111100111111010000000000000000011000001101111111111111110000000000000111111111101111111111111100000000000001111111111111000000000000000111111111111100000000000000000111111111111100111000000000000011111111111111111111110000000000000011111111111110000010011011000000011111111111111100000000000000000000111111111111111000000000000000000001111111111110000000001000000000000001111111000011110010000000000000000000000000001111101010111111100000111110111110110011000000000011111111111100000000000000111111111000000000000000000000000000000000110000111111111111111111110100111111111111111001;
back_2[248] = 640'b0111111100001111000000001000000000000000010011101101000011111111111111000000000000000000010000001101111111111110000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000000111111111111100000000000000000011111111111111111110000000000000000011111111111110000011111011000000011111111111111100000000000000000000111111111111111000000000000000000001111111111111000000000000000000111111111111000011110010000000000000000000000000000111101010011111100000111000111110111010111000001011110001111111011111111111110011111000000000000000000000000000000000110001111111111111111111111100011111101111011111;
back_2[249] = 640'b1111111111101111010100000000000000000000110001011011111111111111111110011100000000000000000010110001111111111100000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111110000000000000000011111111111110000011111011000000011111111111111100000000000000000000111111111111111000000000000000000001111111111111100101000000001111111111111111000011110011000000000000000000000000000111101010111111110000111001011111111110110100111010000000111111111111111100111110111101100000000000000000000000000000000000111111111111111111111101110011111110111110;
back_2[250] = 640'b1111111111111110000000000000100011110111101000011111011111111111111110011100000000000000000010110011011111101110000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111110100000000000000011111111111110000011111011000000011111111111111100000000000000000000111111111111111000000000000000000011111111111111100000110000001111111111111111000011110011000000000000000000000000000111101100011111111100010000000100111110101111010001110000000000000000000000001101111100000000000000000000000000000000000000111111111111111110110011011111101111111100;
back_2[251] = 640'b1111111111111111111000110001101000001100000000101100000111111111111010001111100000000000000100001010011111000000000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111111100000000000000011111111111110000011111001000000111111111111111100000000000000000000111111111111111000000000000000000111111111111111110100100000001111111111111111000011110011000000000000000000000000000111111100111111111100100001000000111100011000001010000001101000001111110001100001011100000000000000000000000000000000000001111111111111111111100000111110000111111111;
back_2[252] = 640'b1111111111111111111111000010100100000011111111111110000111111111111110011111100000000001000000000100011110000000000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111111100000000000000011111111111110000011110001000000011111111111111100000000000000000000111111111111111000000000000000011111111111111111010110010000001111111111111111000011110010000000000000000000000000000111111100111111111100001011111111100000001111010011000111111000000111100001110011111100000000000000000000000000000000000001111111111111111111111100111100010111111111;
back_2[253] = 640'b1111111111111111110111111111100000000000100101111111111111111111111010111111100100000001100000011111110110010000000000000000000111111111101111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111111100000000000000011111111111110000011110011000000011111111111111100000000000000000001111111111111111000000000000000011111111111111110011111100010001111111111111111000011110011000000000000000000000000000111111101111111111100001110001011111111110100111011000011110000000011000011100111111100000000000000000000000000000000000011111111111111111111111111110100111111111111;
back_2[254] = 640'b1111111111111111001001011111100000100000000001011111111111111111111000111111100000000001110000001111111000000000000000000000000111111111111111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111100000000000000000011111111111111111111100000000000000011111111111110000011110011000000011111111111111100000000000000000001111111111111111000000000000000011111111111111100001110000100001111111111111111000011110011000000000000000000000000000111111101111111111110001110000100110000100011110011100000000000000000000001111111111100000000000000000000000000000000000011111111111111111111111110100111110111111111;
back_2[255] = 640'b1111111111110000001111111001001001000000000000010011110011111111111111111001110000000000010000000111010011000000000000000000001111111111111111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111101100000000000000011111111111110000011111011000000011111111111111100000000000000000001111111111111111000000000000000011111111111111110010011100100001111111111111111000011110011000000000000000000000000000111110101111111111111001111000000010001011111101111100000000000000000110101011111111100000000000000000000000000000000000011111111111111111111111110111111001111111111;
back_2[256] = 640'b1111111111000010001011010001100011100000000000110000110011111111111011111100000000000000000000000011111100000000000000000000001111111111111111111111111000000000000001111111111111000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111111100000000000000011111111111110000010011011000000011111111111111100000000000000000001111111111111111100000000000000011111111111111111100001111000001111111111111111000011110011000000000000000000000000000111110101111111111111000011000000000000000110011111110110001110011001110111011111111100000000000000000000000000000000010011111111111111111111111111011111111111111111;
back_2[257] = 640'b1111111110000000010101011001100001100000000000100000110011111111111111000111000000000000000000001110001000000000000000000000001111111111111111111111111000000000000001111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111100000000000000000011111111111110000010010011000000011111111111111100000000000000000001111111111111111100000000000000011111111111111111111101010000001111111111111111000011110011000000000000000000000000000111110101111111111111010011010000100000010110010110111011111110011111111111011111111101100000000000000000000000000000000011111111111111111111111111111111111111111111;
back_2[258] = 640'b1111001011101001001111110000110001111111111111000001111111111111111110110000100000000000000000001111110000000000000000000000001111111111011111111111110000000000000001111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111100000000000000000011111111111110000011110011000000011111111111111100000000000000000001111111111111111100000000000000011111111111111111111010010000001111111111111111000011110011000000000000000000000000000111111101111111111111001101010001110111111100001111011011111111111110101111000111111110000000000000000000000000000000000011111111111111111111100000011111111111111111;
back_2[259] = 640'b0000000000011110100111000010110011110000011111000000111111111111111111111101000000000000000000101111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111100000000000000000011111111111110000011111011000000011111111111111100000000000000000001111111111111111100000000000000011111111111111111111010110000001111111111111111000011110011000000000000000000000000000111111101111111111111100101010100100100111100001111111111111111111001111111000111111110000000000000000000000000000000000011111111111111111110001100011111111111111111;
back_2[260] = 640'b0000000001110001010111111011110110001110111111000000011111111111111111100000000001010000000000011111110000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111101100000000000000011111111111110000011110011000000011111111111111100000000000000000001111111111111111100000000000000011111111111111111111000010100000000000001111111000011110001000000000000000000000000000111111101111111111111101000001101101111100100001111110111111111110011111111001011111110000000000000000000000000000000000111111111111111111000001000111111111111101111;
back_2[261] = 640'b1000000000001011000111101111100111011111110000110000100011111111111100011100000100111000000000011111010000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111111110000000000000011111111111110000011110011000000011111111111111100000000000000000001111111111111111100000000000000000011111111111111111001101100000001111111111111000011110011000000000000000000000000000111111101111111111111111010101101101000101110000111111111111111110011111111001011111110000000000000000000000000000000000011111111111001011010010001111111111111111111;
back_2[262] = 640'b0110000010100000001111111111110110011111111000000011110011111111110111010111110100111110000000001111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111100000000000000001111111111111000000000000000000011111111111111111111110000000000000011111111111110000011110011000000011111111111111100000000000000000000111111111111111000000000000000000001111111111111111000110110001111111111111111000011110011000000000000000000000000000111111101111111111111101010000101111001100110110111111111111111110011111111000011111110000000000000000000000000000000011111111111111011101101110001111111111111111111;
back_2[263] = 640'b1110111111000000101110001111100101111111011000000001111111111111111111111010001100111111101101101111110000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111000000000000000001111111111111000000000000000000011111111111111111111100000000000000011111111111110000011110010000000011111111111111100000000000000000000111111111111111000000000000000000011111111111111111000111001001111111111111111000011110011000000000000000000000000000111111101111111111111111000100100011000010110001111111111111111100111111110000101111110000000000000000000000000000000001111100111111110100110001111111111111111111111;
back_2[264] = 640'b0000000000110000000000011111110111111111111000000001001111111111111011101000000011111111111100001111110000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111000000000000000001111111111111000000000000000000011111111111111111111100000000000000111111111111110000011110010000000011111111111111100000000000000000000111111111111111000000000000000011111111111111111111000000010001111111111111111000011110001000000000000000000000000000111111101111111111111100011100000011001111111001111111111111111100111111110010111111110000000000000000000000000010000011000111110000111100110011111101111111111111111;
back_2[265] = 640'b1100000000000110000000111111111111111111111100000000101111111111111000011100000001111111111011001111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000000111111111111000000000000000001111111111111000000000000000000011111111111111111111100000000000000011111111111100000010010000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111011100100001111111111111111001011110011000000000000000000000000000111111101111111111111100011110000010000110110011111111011111101001111111110010111111110000000000000000000000000001011011011111011111110100110011100111111111111111100;
back_2[266] = 640'b1110100000010001101100001111111111111111011011000000111111111111110111111100000001111101111101111111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111101100000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111111111000001111111111111111001011110001000000000000000000000000000111111100111100111100111010110011010001100000011111111101111111010011111111100111111110000000000000000000000000000111111111101100111110000100001100001101111111110000;
back_2[267] = 640'b0000000000010000111111111111111111111100111111000000000111111111110001111111000001111111111100111111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111100000000000000000111111111111100000011010010000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111111111010001111111111111111001011110001000000000000000000000000000111111100011100011011111110101111010001101001011111111111111111110001111111001011111110000000000000000000000000001111111101100000100010000000001001001111111110000001;
back_2[268] = 640'b0000000000000000001111111111111111111110001111100111100011111111111100101001011111111111111100100111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111100000000000000000111111111111100000011110000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111110011010001111111111111111001011110001000000000000000000000000000111111000010001001111111111101111011010001000001111111111111111110001011111001011111111000000000000000100000000000011100001110001100010010000011000001111111100000111;
back_2[269] = 640'b0000000000000000111111110111111111110110001111101100111011111111110001100101010111111011111100111111100000000000000000000000001111111111011111111111110000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111101100000000000000111111111111100000001000000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111110011010001111111111111111001011110001000000000000000000000000000111111110011111111011101000100011101001110000000011111111011111110100011111001011111110000000000000000000000000000011111110110111010010010001000001000011111000011111;
back_2[270] = 640'b0000000000000000011000111110111101000000000111111110111011111111110110011000000111111011111111010011100000000000000000000000001111111111111111111111110000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111101000000000000000111111111111100000001000000000000011111111111111100000000000000000011111111111111111000000000000000111111111111111111111111011110001111111111111111001011110001000000000000000000000000000111100111111011000001101100010001100000000000000111111111111111110100001111111011111110001000000000000000000000000001101111101101000110000000001110001011000001111111;
back_2[271] = 640'b0000000000000000000110011111011100000000000010111101111110111101111000111100000111101111110111111101100000000000000000000000001111111111111111111111100000000000000011111111111110000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111101000000000000000111111111111100000001100000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111111011011110001111111111111111001011110001000000000000000000000000000011111110011000000000000000000000000000000000000011011111111111110101000110110011111100010000000000000100000000000011001110111000000000100000011110001000000111111111;
back_2[272] = 640'b0000000000000000000010011111111110000000000111111111111110111111111000111100000111111111001100111111000000000000000000000000001111111111111111111111110000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111001011011110001111111111111111001011110001000000000000000000000000000011101010000000000000000010000000000000000000000011111111111111111101000001111111111110000000000000000000000000000011011111011110001010000000000000000000111111111111;
back_2[273] = 640'b0000000000000000000000011101111111100000111000111111111111111011000001111000000111110111000111111110100000000000000000000000001111111111111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111111000000000000000111111111111111111001000001110001111111111111111000011110001000000000000000000000000000011111000000000000000000000000000000000000000000000000111111111111110000111111111111111110000000000000000000000000000001111011000000000000010000001111011111111111111;
back_2[274] = 640'b1100000000100000000000010000101111110000000000111111111110011011000011111100011111111111001111111101000000000000000000000000001111111111111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111100000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111111000000000000000011111111111111111101000100110001111111111111111000011110001000000000000000000000000101010111000000000000000000000000000000000000000000000000111111111111110001111111111111111110000000000000000000000000001000011111001000000000011001000101111111111111111;
back_2[275] = 640'b1100000000000010000000010011111111111000000000111101111110001011101111111110001111111101110011111111000000000000000000000000001111111110111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000001111111111110111000110000001100111101111111000011110001000000000000000000000000111110001100100000000000000000000001000000000000000000000111111111111111111111111111111110000000000000000000000000000110000000000000000000101100100001000111111111111111;
back_2[276] = 640'b1110000000000000000000000000011111111000000000011111111100000011111111111111101111111101111111111111000000000000000000000000000011111110111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111100000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000001111111111110001000100001100000000001111111000011110001000000000000000000000001110100111000000000000000000000000001111000100000000000000011100111111111111111111111111111000000000000000000000000000001001000000000000000111000000011110011111111111101;
back_2[277] = 640'b1111111000000100000000010000000111100100000000011001110100011101111111111111011111111011111111111110000000000000000000000000000011111110111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000001111111111111111111111111111111110001111111000011110001000000000000000000000011110001100000000000000000000000001111100100100000000000000001111111111000011111111111111111000000000000000000000000000101010000000000010000001000001111110011111111111111;
back_2[278] = 640'b1111111111100111000000010000010111110010000000000000001100000111111111111110011111000011111111100001000000000000000000000000000011111110111111111111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000001111111111111111111111111111111110111001111101000011110001000000000000000000000011111000000000000000000000000000111100000001000100000000000000000111110000011111111111111111110000000000000000000000000000000000000000000000100001110111110000111111111111;
back_2[279] = 640'b1111111111111111001000000001100100011111000000000000001100001011111111111110111111100011111011111000000000000000000000000000000111111110111111011111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111111000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000111111111111111111111111111111110011011111100000011110001000000000000000000001111111000000000000000000000000000011111010000010100000000000000001111110000111111111111111111110000000000000000000000000000110000000000000010000110101111000000000010111111;
back_2[280] = 640'b1111111111111111101110000000100001100011110000001100011001111001111111111110111111110011111011111111000000000000000000000000001111111110111111011111100000000000000011111111111100000000000000001111111111111000000000000000001111111111111000000000000000000011111111111111101000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000111111111111111111111111111111111100000110100000011110001000000000000000000001111111000000000000000000000000000001111100000001000000000000000000111110000111111111111111111110000000000000000000000000010000100011001100100000111011110000000000000010111;
back_2[281] = 640'b1111111111111111110111011000000001010011110000001110011000100011110111111110111111111011111011111111000000000000000000000000000011111110111111010101100000000000000011111111111100000000000000001111111111110000000000000000001111111111110000000000000000000011111111111111100000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000000001110011111011111111111111101111000001000000011111001000000000000000000001110100000000000000000000000000000000111110001100100000000000000000111110110111111111111111111100000000000000000000000010011000001000000100100010000111110000100000111000011;
back_2[282] = 640'b1111111111111111111001111111111000110101110000000110110000000111110111111110111111111001110011110111000000000000000000000000000011111110111111001101000000000000000111111111111100000000000000001111111111110000000000000000001111111111110000000000000000000011111111111110100000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000000001100011111111111111111111110101100000000000011111001000000000000000000001110000000000000000000000000000000000011110011110000000000000001000110110110110111111111111111100000000000000000000000000001100000100111100001111011111111111110111111110110;
back_2[283] = 640'b1111101011111111111110101010110000000001000011110110111110000111110111111110111111111100010111111110000000000000000000000000000011111110111111000011000000000000000111111111111100000000000000001111111111110000000000000000001111111111110000000000000000000011111111111110000000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000000111111111111111111111111111000101011001100000011111000000000000000000000011110000000000000000000000000000000000001011011110010000000000000000111001111111111111111111110000000000000000000000000001101110000111100000011111111111111111110111111110001;
back_2[284] = 640'b1111111101111111111111001011001001100011111001111111111100000001110111111110111111111110010111111111000000000000000000000000010011111110111111110111000000000000000111111111111100000000000000001111111111110000000000000000001111111111110000000000000000000011111111111110100000000000000000000111111111111100000000000000000000011111111111111000000000000000000001111111111111110000000000000000000000011111111111111111111111111010010011110100000011111000000000000000000001011110000000000000000000000000000000000000111100110010000000000000000110111111011101111111111100000000000000000000000000011001101101111110001111111111111111111100011111101100;
back_2[285] = 640'b1111100110111111110001100001001101100111111101111111000000011111111111111111111111111110010111111111000000000000000000000000001011111100111111000111000000000000000111111111111100000000000000001111111111110000000000000000011111111111110000000000000000000011111111111110000000000000000000000111111111111100000000000000000000011111111111111000000000000000000000111111111111110000000000000000000000011111111111111111111111111011100101011000001011111000000000000000000001111111000000000000000000000000000000000000011110000010000000000000001101111111101000011111111111000000000000000000000000000000101100010100011111111111111111111111011111111110;
back_2[286] = 640'b1101111101011111111000001001110110010111111111111000111101111111101111111111011111111110011111111110000000000000000000000000000001111100111111100111000000000000000111111111111100000000000000001111111111110000000000000000011111111111110000000000000000000011111111111110000000000000000000000111111111111100000000000000000000011111111111111000000000000000000000111111111111110000000000000000000000111111111111111111111111111111111101111110011011111000000000000000000001111111000000000000000000000000000000000000000011110110000000000000010111111111110111001111111111000000000000000000000000000011110110000001111111111111111111111111111111111110;
back_2[287] = 640'b0001110110110111111111001010000000111011111111111111111111111111101111111111101111111111100111111111100000000000000000000000000100111100111101001111000000000000000111111111111100000000000000001111111111110000000000000000011111111111110000000000000000000011111111111110000000000000000000000111111111111100000000000000000000011111111111111000000000000000000000111111111111110000000000000000000001111111111111111111111111110111111110011011000011111000000000000000000001111011000000000000000000000000000000000000000011111110000000000011100000011111111111100011111111000000000000000000000000000111101111100011111111111111111111111111111111111111;
back_2[288] = 640'b0001110011111011110110000010001000111111111111111111111111111111110000011111111000001111111111111111110000000000000000000000000010110100100000000100001000000000000111111111111100000000000000001111111111110000000000000000011111111111110000000000000000000011111111111100000000000000000000000111111111111100000000000000000000011111111111111000000000000000000001111111111111110000000000000000000001111111111111111111111111110111111111101110110011111000000000000000100111111000000000000000000000000000000000000000000000000110000000000100010010000000111111101000011111000000000000000000000000000011101101101111111111111111111111111110111110111111;
back_2[289] = 640'b0001111001110101110001000111000000111111110111111111111111111111100000011111111111110000111111011111110000000000000000000000000010011000000010000000000000000000000111111111111000000000000000001111111111110000000000000000011111111111110000000000000000000011111111111100000000000000000000000111111111111100000000000000000000011111111111111000000000000000000001111111111111110000000000000000000011111111111111111111111111110111111111111011011011111100000000000111111111111100000000000000000000000000100000000000000000000000000000001111111111111110000000011000111100000000000000000000000000000011100111111111111111111111111111111111111111101110;
back_2[290] = 640'b1111111110111010111101000111000001111111110111111111111111111111100000011111111111111111100111001111110000000111100000000000010001001000000000000000000000000000000111111111111000000000000000001111111111110000000000000000011111111111110000000000000000000011111111011100000000000000000000000111111111111100000000000000000000011111111111111100000000000000000001111111111111110000000000000000000111111111111111111111111111000111111111111100110111111101000000001111111111111100000000000000000000000000100000000000000000000000000000011111111111111111111111101000100000000000000000000000000000000111111111111111111111111111111111111111111111111111;
back_2[291] = 640'b0000011011011001011001010110001111111111001111110111111111111111111000011111111111111111111111100111111100001101110000000000011111000000100000001000000000000000000111111111111000000000000000001111111111110000000000000000011111111111110000000000000000000111111111111100000000000000000000000111111111111100000000000000000000011111100111111000000000000000000011111000000111111000000000000000000111111111111111111111111111000111111111111111010111111110000011111100111110111100000000000000000000000000000000000000000000000000000000011111111111111111111111100001000000000000000000000000000000000111111111111111101111111111111111111111111111100111;
back_2[292] = 640'b1000001111111010010001010100011111111111110111111111111111111111100000111111111111111111111111111111001111101101111000000000011111000000000000000000000000000000000111111111111000000000000000001111111111110000000000000000011111111111110000000000000000000111111111111100000000000000000000000111110001111100000000000000000000110000000000111100000000000000000011110000000011111100000000000000000111111111111111111111111111000111111111111111000110110010111111111100111111110000000000000000000000000000000000000000000000000000000000011111111111111111111111100010000000000000000000000000000000000001111111111111011111111011111111111111111111110111;
back_2[293] = 640'b1111111101000110011001011000011111111111011111111111111111111100000000111111111111111111111111111111111110011110011000000000111111000000000000000000000000000000000111111111111100000000000000011111111111110000000000000000011111111111110000000000000000000111111111111110000000000000000000001100000000001110000000000000000000111000000000111110000000000000000011100000000000111100000000000000001111111111111111111111111110000111111111111111111101111000111111110000001111110000000000000000000000000000000000000000000111110000000000001111111111111111111111110000000000000000000000000000000000000000111111111111110011111000011111111100000000010011;
back_2[294] = 640'b1111110111011110111110010101111111101110001011111111111000000000000000111111111111111111111111111111111111111100011100000000111111100000000000000000000000000000000111111111111100000000000000011111111111110000000000000000111100000111111000000000000000001110011011111111000011000000000000011100000000001110000000000000000000110000000000011110000000000000000111000000000000111100000000000000001111111111111111111111111110000111111111111111111110110110111111111000001001100000000000000000000000000000000000000000000111110000000000000011111111111111111111110000000000000000000000000000000000000001101111111111111100000001100001100000001100001110;
back_2[295] = 640'b0000001100001010110000001011111111100111100111111111111110000000000000111111111111111111111111111111111111111111111100111100111111100000000000000000000000000000001111001111111100000000000000111100011111111000000000000000110000000011111000000000000000011100011001111110011100000000000000011100000000000110000000000000000001110000000000011110000000000000001111111111111111111110000000000000001111111111111111111111111110000111111111111111111111001100111111110000000000000000000000000000000000000000000000000000001111110000000000010111111111111111111111110000000000000000000000000000000000000000100110111111111111100011111111110011111111111110;
back_2[296] = 640'b1111111100001100000000000011111010000011110010111111111100000000000001111111111111111111111111111111111111111111111111111100011111100000000000000000000000000000011100000000111110000000000000111101001111111000000000000000110000000001111000000000000001011100001000101111110001000000000000111100000000000111000000000000000011111111111111111111000000000000000011111111111111100000000000000001111111111111111111111111111111000111111111111111111111101111111011100000000000000000000000000000000000000000000000000000001111110000000000011111111111111111111111110100000000000000000000000001111111111111111111111111111111111000000000000000000000000000;
back_2[297] = 640'b0000111110100111011011111111111011000000100000111111111111100000000000111111111111111111111111111111111111111111111111111111111001100000000111110000000000000000010000000000011110000000000000100000000000111000000000000001000000000000111100000000001100101111011111111111100001000000000000111111111111111111100000000000000000001111111110000000000000000000000011111111111111111111111111111111111111111111111111111111111111000111111111111111111111001111111000000000000000000000000000000000000000000000000000000000001111110000000000001111111111111111111111110100000011111111111111111111111100000000000000000000000000000000000000000000000000000000;
back_2[298] = 640'b1100110111101111010011111100101100000000110110010011111111111111100000111111111111111111111111111111111111111111111111111111111110000000000111111000000000000000010000000000001110000000000011100100000000111100000000000011111111111111111110000000110000111111111111011111100001000000000000000111111111100000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111011101100000000000000000000000000000000000000000000000000000000000001111111000000000011111111111111111111111111111011000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[299] = 640'b1111010101011111110011111100000000011100001100000011111111111000000001111111111111111111111111111111111111111111111111111111111010110100100000000101000000000000111100000000011111000000000011111111111111111110000000000011111111111111111110000011100000111111111101111000000101000000000000000011111111111111011000000001010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111000111100010000000000000000000000000000000000000000000000000000000000001110011101000001011111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[300] = 640'b1111100000011111101111111000000000001110000000011111111111101000000001111111111111111111111111111111111111111111111111111111101111101001110011110000000000000001111111111111111111000000000001111111111110000000000000000001111111110110000000011111100000110110111111101000000101000100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111011100100000000000000000000000000000000000000000000000000000000000000001110010010000000011111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[301] = 640'b0011110110111111111101111000100000000111000000001111111111000000000001111111111111111111111111111111111111111111111111111111101110001001001000011000100000000001111111111111111110111100011111111111111000110000000000001111000011111010010001110101100100110110111111101000001101010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111010100000000000000000000000000000000000000000000000000000000000000000001110011010110000111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[302] = 640'b1101111111111111000011111100010000000000000000101111111110000000000001111111111111111111111111111111111111111111111111111111111100000001110000100000010111111111111111111111111111111111111111111111111111111011000000000001000000001111001111110111101110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111110110000000000000000000000000000000000000000000000000000000000000000000011100100011110000111111111111111111111110001000000110100000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[303] = 640'b1110111111100100000011111100110000000000000000011111111110000000000001111111111111111111111111111111111111111111111111111111111000000011001000100000111111111111111111111111111111111111111111111111111111111111011000000000011111111110111111111111101111111001111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000100110011000000011111111111111111111111111100111111111110000000000000000000000000011110100000000000000000000000000000000000000000;
back_2[304] = 640'b1111111111111000011011011000110000000001001100000111111000000000000001111111111111111111111111111111111111111111111111111111110000000011100000100000001111111111111111111111111111111111111111111111111111111111111111000011111111111111101111111111111111100101111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111110100000000000000000000000000000000000000000000000000000000000100001000011100101101001110111110011111111111111111111101111111111110001000100000000000001000011110110100000000000000000000000000000000000000;
back_2[305] = 640'b1111111111111101001111000000011000000000001110000111111000000000000001111111111111111111111111111111111111111111111111111111110000000011100000000001100011111111111111111111111111111111111111111111111111111111111111111111111111111100101111111011111111010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111100111111111111111111010000000000000000000000000000000000000000001111111111000111000010010100000100000100001100000000000000000000000001111111111111111001111110000000011111010011111111100000100000000000000000000000000000000;
back_2[306] = 640'b1111111111111111000100000000011000000000000111000111111000000000000001111111111111111111111111111111111111111111111111111111110000000011100000100001101111111111111111111111111111111111111111111111111111111111111111111111111111100010100111111010011100110111111111110111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111100111111111111111111110000000000000000000000000000111010011000110010100100110101110111110111011111000110000100000100000010001000000000000000001111111011111111000000001000000111111111000001100000000000000000000000000000000;
back_2[307] = 640'b1111111111110011111110000000000001000000000001000111111010000000000001111111111111111111111111111111111111111111111110111111000000000010000000100000011111010000000000000001000110011111011100010011111111101111111111111111011000001100100111111010000011111111111111110111111101001100011111001111100000001111111110001111111111111111111111111111111111111111111111111111111111111111111111110000000001111111111111111111111111110111111111111111111110000000000000000000001110101110011000010000100000000001000001000011100111101111111111111000110000000100111111111001101111000111011111101000000000001000011111111000001110000000000000000000000000000000;
back_2[308] = 640'b1111111111111110011111110000000000000000000000001111111110000000000001111111111111111111111111111111111111111111111111111111000000000010000000100000001111010000000000000000000000000000000000000011000100000000001100110001000000000000000000001000001111110111111111110100000000000000000001000010000000111111111100011111110111111111111111111111111111111111111111111111111111111111111111000000000001111111111111111111111111111111111111111111111100000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000100001111110001011000010100111101100111111110000000000001000011111111100011110100000000000000000000000000000;
back_2[309] = 640'b1111001101111110111111110000000000000001010010000011111110000000000001111111111111111111111111111111111111111111111101111111100000000010010000100000001111000000000000000000000000000000000000001011000000011000000100000000000000000000100000001000011111110101111110010000000000000000000000000010001100111111111101100111111111111111111111111111111111111111111111111111111111111111111000000000000001111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000111101100001011011111110000000000001000011111111100111000100000000000000000000000000000;
back_2[310] = 640'b0001100000010110110111111000000000000000000000000011111110000000000001111111111111111111111111111111111111111111110101111000100000000110000000100000001111000000000000000000000000000000000000000000000000000000000010001000000000000000000000000011011111110101111110010000000000000000000000000000000010111110000001100110111101111111111111111111111111111111111111111111111111111111111000000000000001111111111111111111111111111111111111111111111001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100101111111100000000001000110111111001111100000000000000000000000000000000;
back_2[311] = 640'b0000000011011001001100100000000000000000000000000011111100000000000001111111111111111111111111111111111111111111111110110000100000000100000001100000011111000000000000000000000000000000000000000000000000000000000000000000010000000000000000001010011111110101111100000000000000110000000000000000000110111000000000000000011100111000111111111111111111111111111111111111111111111100000000000000000001111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111100000000001000111111110001111000000000000000000000000000000000;
back_2[312] = 640'b0000000000000000001110100000000000000000000000000011111100000000000001111111111111111111111111111111111111111111111111000000000000000100000000100000011111000000000000000000000000000000000000000000000000000000000000000000000000000000100000011011011111110100100000000000000000000000000000000000101111111100000000000101011101110001111111111111111111111111111111111111111000000000000000000000000001111111111111111111111111111111111111110111101010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111110000000000001000111111110001110000000000000000000000000000000000;
back_2[313] = 640'b0000000000000000000000000000000000000000000000000001111111110100000001111111111111111111111111111111111111111111111111100000000000001000000000000000011111000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011011111110100000000000000000000000000000000000001100011000100000000010111111111111111111111111111111111111111111111111111111000000000000000000000000001111111111111111111111111111110111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110000000000000000111111000000011000000000000000000000000000000000;
back_2[314] = 640'b0000000000000000000000000000000000000000000000000001111100100000000001111111111111111111111111111111111111111110011111100000000000011100000000001000111111000000000000000000000000000000000000000000000000000000000000000000000000000000000111111011011111110100000000000000000000000000010000000000100001101110000000000111101111111111111111111111111111111111111111111111101100000000000000000000000001111111111111111111111111111000101011110011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111100100000000001100111100000000010000000000000000000000000000000000;
back_2[315] = 640'b0000000000000000000000000000000000000000000000000001111000000000000011111111111111111111111111111111111111111100011101000000100000001011000000001001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000111111011011111100100000000000000000000000000000000000000000000000000000000110000101111111111111111111111111111111111111111111111100000000000000000000000000001111111111111111111111111111110110000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110111000000000000000000111100000000010000000000000000000000000000000000;
back_2[316] = 640'b0000000000000000000000000000000000000000000000000001111000000000000011111111111111111111111111111111111111110000011101010000100000000000000000101111111111000000000000000000000000000000000000000000000000000000000000000000000000000000101111111011011111100000000000000000000000000000000000011111000010000010000011110001111111111111111111111111111111111111111001111111000000000000000000000000000001111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100111110001000000000000000000000000000000000000000000000000000000000000000000;
back_2[317] = 640'b0000000000000000000000000000000000000000000000000001111000000000000011111111111111111111111111111111111111111000011111010001000000000011100001001011111111000000000000000000000000000000000000000000000010000000000000000000000000001100101111111011011110000000000000000000000000000000000000000000000010001011000011111111111111111111111111111111111111111111111001110000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000000000000000000000000000000000000;
back_2[318] = 640'b0000000000000000000000000000000000000000000000000011111000000000000011111111111111111111111111111111111111110000011100001100000000000000000011111111111111000000000000000000000000000000000000000000001111000000000000000000000000111100101111111010011000100000000000000000000000000000000000000000000000011101011011111111111111111111111111111111111111111111111100000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101110000000000000000000111111110000000100000011000001010000000000000000000;
back_2[319] = 640'b0000000000000000000000000000000000000000000000000011111000000000000011111111111111111111111111111101111111100000010111110001111000000001111010000001111111110000000000000000000000000000011111000000010100000000000000000000000000111100101111111010000000000000000000000000000000000000000000000000000000111100000011111111011111111111111111111111111111111111111000000000000000000000000000000000000001111111111111111111111100000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111111110110111111111111111111111000000000000000000000001000000000000000000000;
back_2[320] = 640'b0000000000000000000000000000000000000000000000000011110000000000000011111111111111111111111111111111111100000000101111110011011101101111111110011111000000000000000000000000000000000000111111100000011011000000000000000000010011111101101111111011000000000000000000000000000010000000000000000000110101111110000011111111111111111111111111111111111111111110000000000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000010000000000000000000000000000111111111111110010111111000000000000000000000000000000000000000000000000000000000000;
back_2[321] = 640'b0000000000000000000000000000000000000000000000000011110000000000000011111111111111111111111111111111100000000000111111000000001000000111111101111111111111100010000000000000000000000010100101110110001111000000000010000000010111111101101111110000000000000000000000000000000000000110000000000000001100010110000001110111111111111111111111111111111111111000000000000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110110101110000000000000000000000000000000000000000000000000000000000000000000000;
back_2[322] = 640'b0000000000000000000000000000000000000000000000000011110000000000000011111111111111111111111111111111000000000011111111101000111000001111111101111111111111111110000000000000000000010111100111111111100111000000000000001110110111111100101111100000000000000000000000000000000000000010000000011000001110111100001100011111111111111111111111111111111111100000000000000000000000000000000000000000000011111111111111111111000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111100000100000000000000000000000000000000000000000000000000000000000000000000000;
back_2[323] = 640'b0000000000000000000000000000000000000000000000000011111111111000000011111111111111111111111111111000000000000111111101111111111000110001111101111111111111111110000000000000000000001111101111110111110111000000000000011111110111111000101110100000000100000000000000000000000000000000000100111011111111001111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000011111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111001011000000000010000000000000000000000100000000000000000000000000000;
back_2[324] = 640'b0000000000000000000000000000000000000000001100000111111000000000000111111111111111111111111111110000000000000011111111111111111111111111111101111111111111111111000000000000000000001110011111000111100111000000000000001111110111111100101000001111100010010100100000000000000001001000000110000111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111100101000000000000000000000000000000011110000000000000000000000000000;
back_2[325] = 640'b0000000000000000000000000000000000000001011100001110000000000000000011111111111111111111111001100000000000000011111111111111111111111111100001111111111111111111111000000000000000000010001111011111101011000000000011111111110111111100100000000100000010001100000000000000000000000000000000101111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000111111111111111110000000000000000000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111101111111111111111111111111111111111111111110000000000000000000000000;
back_2[326] = 640'b0000000000000000000000000000000000000001111100001110000000000000000011111111111111111111100001100000000000000000111111111111111111111111000001111111111111111111111111100000000000000100000111111111101011000000010011111111110111111101110000000000000000000000000001000000000000000000001101111111011111111111111111111111111111111111111111111111000000000000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000000000000000000000000010010000000000000000010000000000000000000000000000000000000000000011111111111111111111111111111111111111111101111111111111111111111111111111111111111110000000000000000000000001;
back_2[327] = 640'b0000000000000000000000000000000000000011111111111111111111110100111111111111100011111110000001100000000000000010111111111111111111111110000011111111111111111111111111111110000000011100000111111001001111000000000111111111110111110000000000000000000000000000000001000000000000000011000111111111111111111111111111111111111111111111111111011111111111111100111111100000000110000000000000001111111111111111111111111111111111100000000000000000000000000000000000000000000110011000000000000000001110000000000000000000000000000000000000000111111111111111111111111111111111111111111101111111111111111111111111111111111111111100000000000000000000000001;
back_2[328] = 640'b0000000000000000000000000000000000000111111111111111110000000000111111111000000000000110000001100000001111101111111111111111111111111110000011111111111111111111111111111111111100111100000001111011100011000000000111111111110000000000001000000000010011111000000000111111111111110011111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000110011000000000010000001111100000000000000000000000000000000000001111111111111111111111111111111111111111111101111111111111111111111111111111111111110100000000000000000000000000;
back_2[329] = 640'b1111111111111111111111111111111111111111101000000000000000000000000000000000000000000110000001100000011111111101111111111111111111111110000011111111111111111111111111111111111100011100000001111111101111000000000100111111101001011111100011111110111111111100000001111111011111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000001111111111111111111011011111110000000000000000000000000000000000011111111111111111111111111111111111111111111100111111111111111100011111111000001111110000000000000000000000000000;
back_2[330] = 640'b1111111111111111111111111111111111111111111101000000000000000000000000000000000000000110000001100111111111111111111111111111111111111111000011111111111111111111111111111111110001111100000001111100011110000000000100111111111001011110000000000000011111111100011111111111100100010011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000011011111111111111111111101101011000000000000000000000000000000000111111111111111111111111111111111111110111111000011110100000000000000000000000000000000000000000000000000000000000;
back_2[331] = 640'b1111111111111111111111111111111111110111000000000000000000000000000000000000000000000110000001010111111111011111111111111111111111111111000011111111111111111111111111111111000001110100000001111111111110000000000000000000000000001000001100000000011001111101111111111001111000110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000100000001001011111111111111111111011110111110000000000000000000000000000001111111111111111111111111111110000000000011111000000000000000000000000000000000000000000000000000000000000000000000;
back_2[332] = 640'b1111111111111111100001001110010011001000000000000000000000000000000000000000000000010101000001000111111101111111111111111111111111111111000011111111111111111111111111111110000000010100000001000011111110000000000111010000011011110100111100000011111111111111111111100000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000001100000011001111111111111111111111011111111010000000000000000000000000000000111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[333] = 640'b1111111111100000010000000000000000000000000000000000000000000000000000000000000000010101000011000001111111111111111111111111111111100100000011111111111111111111111111110000000000011110000000000011111111000000001111000100110000000110000010000001111100000000000001000110000000001011111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111011000000001100110111111111111111111111111111001111111101000000000000000000000000000011111111111111111111111111111100000000000000010000000000000000000000000000000000000000000000000000000000000000000000;
back_2[334] = 640'b1111110000000000110000000000000000000000000000000000000000000000000000000011000000000101000011000011111111111111111111111111111111101000000011111111111111111111111111100000000000011111110000000011111111000000110010001100000000001100000100000111111000010000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111000000000000000011100000111111111111111111111001111000011111111000000000000000000000000000011111111111111111111111111111111101000000000110000000000000000000000000000000000000000000000000000000000000000000000;
back_2[335] = 640'b0000000000000000100000000000000000000000000000000000000000000000000000011111100011110101101111011111111111111111111111111111111111111100000011111111111111111111111100000000000000001001110110000011111111000000000000000000000000110000000000000110000000000000000000000000010000000000010001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111110000111111011111111111111111111111101111111011111110010000000000000000000000000001111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[336] = 640'b0000000000000000000000000000000000000000000000010000000000000100001111111111111111110101111111111111111111111111111111111111011111110000000111111111111111111111111000000000000111110111111000000011111111000000000011111000000000100001111111111111111111100000000001111110010000011111111111001111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111000011000000100000000111100001111111111111111111110011111111001111110000000000000000000000000000000000011111111010011111111110000000010000000000000000000000000000000000000111000000000000000000000000000000000000000;
back_2[337] = 640'b0000000000000000000000000000000000000000000000000000000000000100000111111111111000000101111111111111111111111111111111111110001111110000000011111111111111111111000000000000001100000000111110000111111111000000000001000000000000001111111110001100100000000000001100000000000000011111111110000000000000111011101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111101011111100001111111111111111111111111111111110000111001111110010000000000000000000000000001111111111111111111111111111100010110000000000011100001111001110000001111111111101111100010000000000000000000000111;
back_2[338] = 640'b0000000000000000000000000000000000000000000000000000000000001100000000111111110000000100111011111111111111111111111111111100000111111000000011111111111111111100000000000000011100000000111010000111001111000000000001110000000011111111111111111100000001000000001100000000000011111111111111111111011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111011101101111111111110111111111111111000000001101111110000000000000000000000000000111111111111111111111111111111110111111000000010010100111111111111001001111111111111111100010110000000000000000001111;
back_2[339] = 640'b0000000000000000000000000000000000000000000000000000011111111100100001111111111000010101111011111111111111111100000111111110000111111000000001111111111111100000000000000000011100000001111010000111001111000000000000111010000001111000100011100100000000000000001101100000000111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011010000000000100111110000101001111111101111111111111111111111110000000001001111110000000000000000000000000001111111111111111111111111111111111111111000000010010010111111111111001001111111111111111111011100000000000000000001111;
back_2[340] = 640'b0000001000000000000000000000000000000000000000000000111111111001111111111111110000010101111011111111111111000000001111111111111001111000000000111111111100000000000000001111110000000001111011000111001111000000000100011000000000111001101111101101011100000001001111100010011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010000000000100011111111011111101111111111111111111111110000000000001111110000000000000000000000000001111111111111111111111111111111111111111000000010000111001111111111111101111111111111111111011111100000000000000111111;
back_2[341] = 640'b0000011111000000000000000000000000000000000000000000010000000011111111111111100000000100001010111111111111000000001000011111110000110000000000111111111000000000000000001110000000100000101000001110001111000000010100110000010000011001101111111110110010011101111111000011111111111111111100111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111000000111111100000000000000000000000110001101111111111111111111111111000000000000111110000000000000000000000000001111111111111111111111111111111111111111000100001000011111111111111111111111111111111111111111111110000000000000111111;
back_2[342] = 640'b0000011100000000000000000000000000000000000000010000000000000000110111111011100000000100001010111111111111000000010000011110000000100000000000111110011100000000000001111111111111100001101000001110001111000000000000000000010100000000000000001111110000010011111111101000000000111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111101111110000000000000011111100100111111111111111110111111111101000000000011011111000000000000000000000000001111111111111111111111111111111111111111000000111100011111111111111111111111111111111111111111111111111000111111111111;
back_2[343] = 640'b1100011100000000000000000000000000000000000000111000110000000011111111111111111111100100001110111111111111000000010011111100000000111000000000100000000111000000001111111111111110001001010100011110001111000000011000000000001100000000000010011111111100010110111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000011111000000000111001011110111101111111111111111111111011011110000001101011000000000000000000000000001111111111111111111111111111111111111111000010111111011111111111111111111111111111111111111111111111101000101111111111;
back_2[344] = 640'b1110011100000000000000000000000000000000001100000000110000000011111001001000111111000100000110000111111111000000011111111011000000111001100000101101010011001111111111111111111101111011101010011100001110000000010000000000000000000000000000011110111100111110110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011100000111001111100000000111100011110111111111111111111111111110011011101011111000001000000000000000000000000001111111111111111111111111111111111111111000000111111011111111111111111111111111111111111111111111111111100111111111111;
back_2[345] = 640'b1110011000000000000001001111011111110000001100000000110000000001100011000000110000000111000111110111111111111111111111100000000000011111110111100101110001111111111111111111111011110110110111001100001110000000000000000000011111110010111111111110110111111110110111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111101110000000000111111111110111111111111111111111111111110111101011111111111000000000000000000000000001111111011111111111111111111111111111111000000001100011111111111111111111111111111111111111111111111111000111010111111;
back_2[346] = 640'b1110011000000000000000111111011011010000001100000000110000010100011101100000000000000111000011110010001111111111111111100000000000011111111011100111110010111111111111111111111111111101110111010000000010000000000010000000001100000001111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111011111111000000000000011101110001111111111111011111111000111000101111111111111000000000000000000000000001111110001111111111111111111111111111111000000010010001111111111111111111111111111111111111111111111101100110011111111;
back_2[347] = 640'b1110111000000000000010111110000010000000001100000000110000001001000110111010000000000000000000000000101111111111111110000000011000011111101111100101001011111111111111111111111111110111111000111100000000001111111111100000000000000000000011111111111001111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111110000000111111111111111111111111111111111111111111010001111111111111000000000000000000000000001111111011111111111111111111111111111111000000011000011111111111111111111111111111000001111111111111100000000000011111;
back_2[348] = 640'b1111111000000101100101111111111000000000001100000000110010000000110011100000000000000000000000000000111111111111111110001000011100011101110111101100110110111111111111111100111110011111111100001000000001011111111111111011111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011110000001111111111111111111111111111111101111111111111111111111111000111001110111111111111000000000000000000000000001111111110100111111111111111111111111110000000000000111111111111111111111111111111100001111111111111111111111111111111;
back_2[349] = 640'b1111111000000000000001110011111000000000001100000000111100000011011111100000000011110011000000011111111111111111111110000000011010001011011001111111011111111111111111111111111111111010000000011000000000000111111111111011101111111111111111111111001011111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111000000110110001111111110000000000001100000000000001111111011101111111111111111111111111111000000000000000011111111111111111111111000000000111111111111111111111111111111;
back_2[350] = 640'b1111111000000011101111110111111100000000001100000000110000011001110000000000000001000011000000011110111111111111111110000000011000001010010001110111001111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011011111111111100000000000000111000000000001111111101111111111111111111111111111110000000000000000001111111111111111111110000000000110000110000000000000000011111;
back_2[351] = 640'b1110111000000000000111110001100000000000001100001100110011001111000000000000000000001010001000111111111111111111110011000000010000001010011000110010011111111111111111111111111111111110111011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111011111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111101111111110101111111111111111111110001100111111111111000000000001111011100000000001111111111111111100111111111111111111110000000000000000001111111111111101111110000000000111111111111111011111000001111;
back_2[352] = 640'b1110111000000000000000000000000000000000001100111000111101110000000000000010000000000000000110011111111111111111100111000000110000010110111001010111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111110001100001111110100000000000000001110100000000001111111111111111111111111111111111111110000000000000000000011111011110000110000000000000111111111110000000011100100110;
back_2[353] = 640'b1100110000000011110011111111111110000000001110000001110111000111000000000110000000010111111111111111111111111111100111000000110011101010000001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111101111110001001111111100000001000000001000000000000000000000000000000010000000000010111111111111111111111111111111111001000000000000000000000000000000000000000000000000000111111111100000000000000000110;
back_2[354] = 640'b1100110000000000000001100001110101100000001100000111110000000000000000011000000000101111111111111111111111111110000011000000000001110000000011011111111111111111111111111111111111111101011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111111111111010010011111111111111111111111111111111111111111111111111111111101110110000001111111000000011000000000000000000000000000000000000000001111000001000111111111111011111111111111111111111110000000000000000000011011111100000000000000000000111111111000000000000000000011;
back_2[355] = 640'b1100110000000000111111111011111100100000111101110011110000000000000000000000000010001111111111111111111111111111100011111010001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111101110011111000000000000000000000000000000000000000111000010000111111111111111111111111111111111111111000000000000000000001111111100010000000000000000110111111000000000000000000011;
back_2[356] = 640'b1101110000000001111111000000000101001100011111000010110000011111111111111111110100001111111111111111111111111111001111111110101111111111111111111111111111111101011111111111111111111111111111111111111111111111111111111111111111111111111111111111110010110010110001110111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101110111011111111111000000000000000000000000000000000000000000000000101000100000111111111111111111111111111111111111111000000000000000000000000111000000000000000000000110111111000000000000000000001;
back_2[357] = 640'b1101110000000111111110000000000000010000011101100000110000011111111111111111111110111111111111111111111111111111110111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111110111110111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101111110111001111111100000000000000000010000000000000000000000000000000001011000000111111111111111111111111111111111111111000000000000000000000000111000000000000000000000011111100000000000000000000000;
back_2[358] = 640'b1101110000011111100000000000100100001011101000000000110000011100100011111111110011011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101111111111101111111100000000000000000010000000000000000000000000000000011010000000111111111111111111111111111111111111111000000000000000000000000111000000000000000000000011111110000000000000000000000;
back_2[359] = 640'b1101110000011110000000000000010010001100011000000000110000000011111111111000111111110011111001111111111111111111111111111111111111111111111111111111111111111111011111111011000111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111011111111111111111111111111111111111111111100100011111111111111111111111111111111111111111111111111101101111101111111110000000000000000000100010000000000000000111110000000000011111000000111111111111111111111111111111111111111000000000000000000000000001100000000000000000000011111110000000000000000000000;
back_2[360] = 640'b1101110000000000000000100000000000110111011000000000110000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001100100000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111100111111111111111111111111111111110011011111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111100111111111110000000000000000000000100010000000000000010011111100000000011111000000111111111111111111111111111111111111111000000000000000000000000000000000000000000000000011011111000000000000000000000;
back_2[361] = 640'b1101100000000000000011010000110110000000011000000000110000000000011110000000001100011111111111111111111111111111111111111111111111111111111111111111111111111111000001111110111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101101111111101100000000000000001100010000000000000000000111110000000011111000000111111001010101111111111111111111111111000000010000000000000100000000000000000000000000011000000000000000000000000000;
back_2[362] = 640'b1101100000000000000001101110011011100000011000000000110000000001100000000001111000011100111110011100000101111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111000010000000000011000000000000001111111111111111111111111111111111111111111111111111111111111111111111111110000111111111111111111111111111111111100000101111111111111111111111111111111111111111111111111111111111101100100111111111111111111101000011000010000000000000000000000011000000011011100000111011001011000000000000111111111111111000000000000000000000000000000000000000000000000011100000000000000000000000000;
back_2[363] = 640'b1101100000000000010000010111101110000000011000000000110000000111111110011111111111111111111111111111111111111111111111111111111111111111111111111110001100000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111011111111111111001100000001011011111111111111111111111111111111111111111110000111111111111111111111111111111111110000001011011111111111111111111111111111111111111111111111111111101111111111111000000000000000000001100010000000000000000000000000000000011011100000111011000000000000000001111110111111111000000000000000000000000000000000000000000000000000011111111000000000000000000;
back_2[364] = 640'b1101100000011100100111001101110000000000011000000000110000000000000000001011111111111111111111111111111111111111111111111111111111111111111111111111101011100000000000010000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111110000000000000000111100000000000000000000000000000000001111110000001111100001000000101111111110011011111111000000000000000000000000000000000000000000000000010000001000000000000000000000;
back_2[365] = 640'b1111100000000010000000110111100100000000011000000000110000011111111111111000100111000000010000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110100011111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111101111111111111111111000100110000010111000000000000000000000000000000001110011111110111100000100000001010000110010011111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[366] = 640'b1111100001100001101100001100000000000000011000000000110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000011001101100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000011011111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111000000100111111111111111111111111111111111111111111111111111111111101111111111111111110110001110001111111000000000000000000000000000000001110100011001011000000000000000001000110111001111011000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[367] = 640'b1011100011000110011011110000000000000000111000000000110000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111001111000001000000000000000000011011111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111101101111000000000000000000000000000001101110111111100111001001000000000000001010110011011111000000000000000000000000100000000000000000000000000000000000000000000000000000;
back_2[368] = 640'b1111101100000001101111111000000000000000111000000000110000111111111111110000110100110000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000001101011000111001101100000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111010101001000000000000000000000000000000101110001110011011001000000000000000000000011011111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[369] = 640'b1111100000111000000000000000000000000000111000000000110000011111111111111111111111111111111111111111111111111100111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000001111111111111111111111111111111101111111111111111111111111111111110111111111111111111111111111111110100000011111111111111111111111111111111111111111111111111111111111111101111011000111111111111111111011100111000000000000000000000000000000000110111111111100000010000000110000000110000001111111000000000000000000000000000000010000000000000000000000000000000000000000000000;
back_2[370] = 640'b1111100001101111000110000000000000000000111000000000110000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000100000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111110000111111111111111111001011111000000000000000000000000000000010110111111111111000000000000010000000110101011111111100011001110000010000000000000000000000000000000000000000000000000000000000000;
back_2[371] = 640'b1111111111110000000000000100011111111000111100000000110000011111100000000000000000000000000000011111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111110011001001000010000000111111111111111111000010000000000000000000000000000000010110111111111111000000010100000000001111101111111111111111111111111111111000111100000111000000000000000000000000000000000000000000;
back_2[372] = 640'b1111111111111111111111111111000000000001111000000000110000111111111111111111111111111111110000000000000000000000000000000000000111111111100000011100111111111111111111111111111111111111111111111111111111111111111111111111110000000000000010010111110000000000000000000000000100111110111111100111111111111111111110111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111100000000000001110000010111111111111111111100000000000000111111100000000000000000000000000000000000110111111111111000000010001001111110000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000;
back_2[373] = 640'b1111111111111111111111111111111111111111111111111111111110000000000000000001111111111111111111111100001000000000010000000101100100000011001100000000000000000000000000000000100000011111111111111111111111111111111111111111111000110000111111111111111111111111111110100000000000000000000000000000000000000000110000000100111111111111111111111111101111111111111111111111111111100111111111111111111111111111111111111110000001110000000000000000000000000000010111111111111111111111111100000000000000000000000000000000001110111111111110000010000010001011111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_2[374] = 640'b1111111111111111111111111111111111100111111111111111111111111111111111111111111110111111110000000000000000000000000000000111001111111111111111111111111000000010000001100000000000000000000000100000000000000000000000111000111000010000100111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000111011111100000000111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011111110000000000000000000000000000000001110000011111110000010000011001101111111111111111111111111111111111111111111111111111111111011000000000000000000000000000000000000;
back_2[375] = 640'b1111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111001100000000000000000000000000010111111111111111111111111111111111111111111111111000011100000000000000000000000000000000000000000000000111111111111111111111111100100000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000111111111111111111111111111111111111111111111111111111111110100000000011000000010000000000000000000000000000000001111001100011110000010101011000011100111111111111111111111111111111111111111111111111111111011000000000000000000000000000000000000;
back_2[376] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000001111111111111111111111111100111110000011100000001000000000000000000000000000000000000000000001110000111000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000111000000110001000011110110000111101101111111111111111111111111111111111111111111111111111010000000000000000000000000000000000000;
back_2[377] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000111111000111100011100000000000000000000011110001111111100000001111111111111110000000000000000000000000000000000000000110000000110010111111111111111111111111111111111100111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000111000000011111000000000110001000100011000111111111111111111111111111111111111111111111111010000000000000000000000000000000000000;
back_2[378] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000011111111111111111111110000011111111111111111111110001111111111111111111111111110011010000000000000000000111100100011000000111111111111111111111111111111111111111111111111111111100000011111111111111111111111111111111111111111111111111111111100100000000000000000000000000000000111000000000000000000111100001000000000011110001111111111111111111111111111111111111111111010000000000000000000000000000000000000;
back_2[379] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000111110000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000001111111000000000000000000111111111111111111111111111111111111111111111111111111100100000000000000000000000000000000111000000000000000000111100001111111100000111101000000000001011111111111111111101111011111010000000000000000000000000000000000000;
back_2[380] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000100011111101111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000010000000001001110011111111111111111111111000000101111100000000000000000000000000111000000000000000000010000000011111111111100111010110000000000000000000000000000000000001000000000000000000000000000000000000000;
back_2[381] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000111100111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000110000000000000000000000101111110000000000000000000000000111111111111010000100110000000000000000111111110100100111111111111111111111111110000100000000000000000000000000000000000000000000;
back_2[382] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000000111111111111111111111111111111111111111111111111111111110000000000000000000001111111100000000000000000000000000000000000000000000000000000000000000000000000000000101111111000000000000000000000001011000000000000000000010000000000000000000000000000000000000100000000001011101111111111111100000000000000000000000000000000000000;
back_2[383] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101010000000000000000000000000000000000000000000000000000000000000000000000000000100111111100000000000000000000000001000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[384] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000000000000000000000000000000000000000000000000000000000000000000000000000000111111100000000000000000000001011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[385] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000000001000100010000000000000000011111110010000000000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[386] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000100000011111111111100000000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000111111000000000000000000000000000000000000000000000;
back_2[387] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111000000000000000001000000000000000000000000000000000000000000000000000000000000000000010000000000111011100000000000000000000000000000000000000000;
back_2[388] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000000000000000000000000000000000000000000011000000000000000001011111111111111000000000000010010000000000000000000010000000000000000000000000000000000000000000000011111100000000001111000000000000000000000000000000000000000;
back_2[389] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111110111000000000000000000000000000000000000000000000000000000001100000000000000000111111111111111100000000000010000000000000000000000001000000000000000000000000000000000000000000000011111101111111110010100000000000000000000000000000000000000;
back_2[390] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111110011011111111111111111111111010001111111111111111111111111111111010100000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100000000000000010000000000000000000010100000000000000000000000000000000000000000000111111100111110111110010000000000000000000000000000000000000;
back_2[391] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111000000000000000000011111110000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000000000000100000100000000000000000000000000000000001111111100011111111111111111111100000000000000000000000000000000000000;
back_2[392] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001101000111111111111111111111001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000011111110000000000001111111111111111111100000000000000000000000000000000000000;
back_2[393] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000011111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000001111100111100000000000000000001111011111111111111100000000000000000000000000000000000000;
back_2[394] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000001111111111111000000000000000001111001111111111111111111101000000000000000000000000000000000000;
back_2[395] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111011111111111111111111111111111111111111111110000000011111111111111111111111111111111111101111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000111111111110000000000000001001111110001111111111111011111101000000000000000000000000000000000000;
back_2[396] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000011111110011111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000011111111100000000000000111001011111111101111111111110011111111000000000000000000000000000000000000;
back_2[397] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000110000000000000000000000000000000000010111100000000000011111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001000000011111000000000000000001111111111111111100111111111100011111111000000000000000000000000000000000000;
back_2[398] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011100010000001111100101111111111111111111111111111111111111111001001011111000000000000000000000000000000000000001001111111111111111111110000000111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000001100000100000000000000011111111111111111111111100011110111101011111111000000000000000000000000000000000000;
back_2[399] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100101000100100100000000000000100111111111111111111111111111111111100101111001000111100000000000000000000000000000000000000011111111111111111111111111100000011111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000100000000000000000000111111111111111111100011100010000111111111000000000000000000000000000000000000;
back_2[400] = 640'b1111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110110000000000000000000000000011111111111111111111111111111111111100000011111111000000000110000000000000000000000000000000000011111111111111111111111111111111100000000011111111111111111111111101111000000000000000000000000000000000000000010000000000000000000000000000010110100000000000000000001010000100000000000000000000001111111111111111100000000011111111111111000000000000000000000000000000000000;
back_2[401] = 640'b1111101110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000000000000000111111111111111111111111111111111111111111111000001111111110000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111100000000000000000000000000000011111111111111111100000010000000000000000000000000000010110100000000000000000000010000100000000000000000010000001111111111111111001100111011111111111000000000000000000000000000000000000;
back_2[402] = 640'b1101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111001100000000000000000000011111111111111111111111111111111111111111111111110000011111111111100000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000010000000000000000000000000000010110000000000000000100010010000111000000000000000000000000000000000000000001110011111111110001000000000000000000000000000000000000;
back_2[403] = 640'b0111011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110000000000000000000000000111111111111111111111111111111111111111111111111111111111111100010010011010000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111101000000010000000000000000000000000000010110100000000000000010010010000000000000000000000000000000000111011111011000110011111111110001000000000000000000000000000000000000;
back_2[404] = 640'b0100001111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101100000000000000000001100001111111111111111111111111111111111111111111111111111111101010001110000001000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111101111000010000000000000000000000000000010110111100000100000000010010000011111111111111111111111111111111111111111111110011111111110001000000000000000000000000000000000000;
back_2[405] = 640'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111000000110000000000001000000000000001111111111111111111111111111111111111111111111111111001100110000000000111000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000010000000000000000000000000000010100100000000000000010000110000011111111111111111111111111111111111111111111111011111111111110000000000000000000000000000000000000;
back_2[406] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111100110011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000110111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000110000000000000000010000000000000000000000000000010110100000000000000010000100000011111111111111111111111111111111111111111111111011111111111110000000000000000000000000000000000000;
back_2[407] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111100000000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000110111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000010000010000000010000000000000000000000000000010110100000000000000010000110000010000000000000000000011111000000000000000000000101111111111010000000000000000000000000000000000000;
back_2[408] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000111101111010011000001111111001100000001000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000011111110000000000011111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000011111111111011111100110000000000000000000000000000010100100000000000001010010010000110000000000011111111111100001111100000000111111011111111111111000000000000000000000000000000000000;
back_2[409] = 640'b0000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011000011101111100001110000000001001111100111111111111111101111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000010000000110111001111111111111110111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000001111111111000001000000110000000000000000000000000000010100101111111110001010010100010111000010100111111111111111111111111100000000000000000000000000000000000000000000000000000000000000;
back_2[410] = 640'b0000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011101111110001111110001101101111111111111111101111111110011101111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111110000001110000000000000000000000000000010101100000000000001010010110111111000011111111111001100111111111110000000000000000000000000000000000000000000000000000000000000000;
back_2[411] = 640'b0000000000000000000000000100000000000000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001110111111111111111111100111001101000111011111111111111111111111111111111111111111111111111111111111111000001100010000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000010000000110111100000000000000000000000001110000000000000000000000000000010101100000000000001110010110110011100010000111111111111111111111000000000000000000000000000000000000000000000000000000000000000000;
back_2[412] = 640'b0000000000000100000000000001000000010011100110001000000111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111110111111111111011111111101110111111111111111111111111111111111101101111111111111111111111101111110011111100000000100000000111001111111111111111111111111111111111111111111111111111111111111111111111111111001000000000000000000000000000000000000000000000000000000001110001111110000100000000000000000000000000001010000000000000000000000000000010101100000000000001110010110111000000010011001111111111111111110100000000000000000000000000000000000000000000000000000000000000000;
back_2[413] = 640'b0000000000000000000000000000000000010001000000000000000000010000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111110111111100111111111111111111111111111111111111111111111111111111111111111111000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000001110000000000000000000000000000000000000001010000000000000000000000000001010101111111111010001010011100111000000010111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000;
back_2[414] = 640'b0000000000010000110011001000010000010001110000000000110001100011000010000000000001000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000111111101101111111111111111111111111111111111111111111111111101111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000001010000000000000000000000000000000101111111111010001010000110000000011111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[415] = 640'b1111111111110111100111001110011111111111111110010000111001110000100000000001100001000100000000000000000000001100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110110111011111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000001110000000000000000000000000000000101100000000000001110010100011000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[416] = 640'b1111111111100111101111111111111111101111001110000000111101111111011000010000000000000000000000000000000000000000000000000111111101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000001000000000000000000000000000000000101100000000000010110011100011001111111111111111111111110010000000000000000000000000000000000000000000000000000000000000000000000;
back_2[417] = 640'b1111111111111111111111111111110011110111111111111111111111100111001100011000111011001000000000000000000000000000000000000000000000000000000000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000001000100000000000000000000000000000101000000000100001110010110010111111111111111111111111110011000000000000000000000000000000000000000000000000000000000000000000000;
back_2[418] = 640'b1111111111111111111111111111111111111111111111111001111110111111111111111101111111100000000000000000000000000100000000000110000000100000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000000000001010100000000000000000000000000001111010100111000001010011110111111111111111111111111100000001000000000000000000000000000000000000000000000000000000000000000000000;
back_2[419] = 640'b1111111111111111111111111111111111111111111111111111111101111110011110011100111111110011111111111000000000000000000000000000000000000000000000000000000000000000001000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000000000000000000000000000000000000000000000000000000111100000000000000000000000000000000000000000000000000000000001110100000000000000000000000000110001010000000100001010011010111011111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[420] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111001111111111111111001110001100000000100000000100010000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000000000000000000000000000000000000000000000000000000111000010100000000000000000000000000000000000000000000000000000000101011100000000000000000000000111110000000000100001110010010011111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[421] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111101111111100011100011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000000000000000000000000000000000000000001110111111100000000000000000000111001000000001000001110011111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[422] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000001110001110011110011110011000000000000000000000000000000000000000000000000010000000000000000000101000000100001000000000001000000000010111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000000000000000000000000000000000000000000000011111111110000111111111111111111111111111111111111111111100000000000000000000000010111011111111111111111000000000100001111111110000000110011011110011111111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[423] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111100111011111001110001110000110000000000000000010000000000000100000000000000000000001000000000001000000000010000000001001000000100001100000000000000000000000001011111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000011111111111111111111110000000011111111111111111111111111111111111111111111111111111111111111111111111111111001011010111111111010010100011111010011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[424] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011010111111000111010000000010011000000001110000000000000000000000011001110010000000000100000000100100110011000000000000000000000000000000000000000000000000001111111111111111110101111111111111111111111111111111000110000000000000000000000000000000000000000000000000000000000000000000000000011111100001111111111111111000000000000000000001111111111000010000101100001111111111111111111111101010111111111101000000100011111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[425] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110111001000100000000011100010011000011000000000111011111111111100110000000000000001000001000100000000000000000000000110000000000000000000000000000100000000000110011000000000000000000011111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000100110011111111111111111111111111111111111111111111111000000000001110001111000000000000000000000000111111111111111000010100011111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[426] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000111111110101110001111011111111111110011110011011000011100111110111000000000000000000000000000000000000000000000000000000000000000000000000000000000111100000000000001100111110111000010000000000000000000000000000000000000000000000000000000000000000000000000000001100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010100001001111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[427] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100000000000100111101111111001111000111101111111111111000110000000000000110100000101110001000000000000000000000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000101111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111111111111110000000010100001111011111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[428] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011000011111111111111011100001110001110001111111111101110000000000000000000000000000000000000000000000000001000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010010001111111111111110111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[429] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100111000111110111111111111000100000000000000111110000000100000001100000000001010001000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111000000010001111111111101111011100000010000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[430] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111110011110001101001111111110110000000111111111111011111111111000001000000000000010011111111010000000000000000000000000000000000000000000000000000000000000000000000000000100111110111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111000010010000001111111110001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[431] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111000000000001111110000110000000111111111111111110000011110011111000011111111111101000000000000100000010000000001000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[432] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111110111111111111110000000000011111111111111111111100001000000000000100110111111100100000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[433] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110000001000001111111111000111100000000000000001110000100011111100000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011110110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[434] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100111111111111111000001111111110001000001101111000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[435] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011100000111111111111111111110000000000001100000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[436] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111111111111111111111111111111111111000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[437] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111000011010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[438] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111101111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[439] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101111111111111111111111111111111111001111100111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[440] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001101111111111111111111111111111111111000000100111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[441] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001101111111111111111111111111111111111111000000010111000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[442] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[443] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111000000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_2[444] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110101111111111111111111111111111111111111111111111111111111010000000000000000000111111100000000000000000000000000000000000000000000000000000000000000000000000;
back_2[445] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111111111111100000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101011111111111111111111111111111111111111111111111111111100000000011010011111111101111111111100000000000000000000000000000000000000000000000000000000000000000;
back_2[446] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110011111111111111111111111111111111111111111111111111111111111111111111111111110000111111111111000000000000000000000000000000000000000000000000000000000000;
back_2[447] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110110001111111111111111111111111111111111111111111111111111111111111111111111110000000000011111111110000000000000000000000000000000000000000000000000000000;
back_2[448] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111001001100111111111111111111111111111111111111111111111111111111111111111111111001100000000001111111111000001111111111110000000000000000000000000000000000;
back_2[449] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111011111111100011000001111111111111111111111111111111111111111111111111111111111111101100000000011111111111011111111111111111011111000000000000000000000000000;
back_2[450] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000110101111111001111111111111111111111111111111111111111111111111111111111111111111100011111000111111011111111100011100111111100000001100100010000000000;
back_2[451] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000100111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111011111111111110111000011100111011111110100000110000000110;
back_2[452] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000100110010111111111111111111111111111111111111111111111111111111111111111111111111110110000001011111111111011011111100011011101111101110001101000000010;
back_2[453] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111001111111111111111111111111111111111111111111111111111111111111111111000000110110011111011111111110101111111111110101100110001000000010110000110;
back_2[454] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111101111110111110011111111111111111111111111111111111111111111111111111111111111111000000110110000101011111111111011111111111111110101111111111110001100000110;
back_2[455] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101111110111011111111111111111111111111111111111111111111111111111111110000111000000110110011101011111111101111111111111111011101111001001111100011000010;
back_2[456] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011001111011111111111111111111111111111111111111111111111111111111111000000111000000110101111111011111100110111111011011111101101111111111111110011000000;
back_2[457] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111110001111111111111111111111111111111111111111111111111111111110101111000000110101111111011111111010111111111111111101101111110110111110111011110;
back_2[458] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111100011111111011101111000000110111111111011111111011111110110110000011101111111001101111111011110;
back_2[459] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111010011111111000001111000000110101111111011111111011111110111011111110101111111011101010110000010;
back_2[460] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111000000011110111100001111111011111111111111111111111111111111111111111111111111111111111111111111111111111000000110101111111001111110011000000110001111110101111111011111110110000010;
back_2[461] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111111110110011111111111111111111111111111111111111111111111111111111111111111111111111111000000111100011101110000001111111100111110000011100111111011100000110000000;
back_2[462] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111100111111111111111111111111111111111111111111111111111111111111111111111111111000000111101011101111111110110111111100111111101101111111011000000110000000;
back_2[463] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111000000011000001101111111110110111111011011111101101111111001011110110000010;
back_2[464] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000110101111111110111111111111111111111101111111001011110110010110;
back_2[465] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111100000000000011101111111110101011111111111111010101111111001001110110010010;
back_2[466] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111100000000010111101111111110110101100001111110100101111111011101110110000000;
back_2[467] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111110000000110111111111111110111011011111111011011101111111011001110110000000;
back_2[468] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111011110111000011100101011111111011111111111000000;
back_2[469] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110001111000100000000111111100000000110010100000001001000000010000000;
back_2[470] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000011111111111111111111111111111111110001100000000000000000000000000000;
back_2[471] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000001111111111111111111111111111111111111110001000000000000000000000000000;
back_2[472] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000001111111111111111111111111111111111111000000000000000000000000000000000;
back_2[473] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000111111111111111111111111111110000000000000000000000000000000000000;
back_2[474] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000111111111111111111111111111000000000000000000000000000000000000000;
back_2[475] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000001111111111111111111111111111111110000000000000000000000000000000;
back_2[476] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000111111111111111111111111111111111111111110000000000000000000000;
back_2[477] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000011111111111111111111111111111111111111111111110111100000000000000;
back_2[478] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000011111111111111111111111111111111111111111111111111111111110110010;
back_2[479] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000011111111111111101111100100111111110011000000000000000000000000000;

/*
back_3[  0] = 640'b1111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000100010010010100010001100011011101101101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000;
back_3[  1] = 640'b1111111111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111100011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110000000000000000000000000000000000000000;
back_3[  2] = 640'b1111111001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100010110111110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000;
back_3[  3] = 640'b1111111010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101110111111111001111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000;
back_3[  4] = 640'b1111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110001110101111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000100000000000000000000000000000000000;
back_3[  5] = 640'b1111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111001011111101111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000;
back_3[  6] = 640'b1111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000110100011101110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000000000000000000000000;
back_3[  7] = 640'b1111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101100101111110100100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000100000000000000000000000000000000;
back_3[  8] = 640'b1101001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110101011101010110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000;
back_3[  9] = 640'b1110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010110010001001000011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000100000000000000000000000000000000;
back_3[ 10] = 640'b1111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111000000111111110011011110001110111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000000000000000000000000;
back_3[ 11] = 640'b1110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111101011101111101111111000000110111111011111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000100000000000000000000000000000;
back_3[ 12] = 640'b1010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111011111111111110111110000001110111111111101111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000;
back_3[ 13] = 640'b1100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000111110001010100001001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000000000000000000;
back_3[ 14] = 640'b1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111011101000100100111111110000101111111110111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010100000000000000000000000000000;
back_3[ 15] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111101111111111101111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
back_3[ 16] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111101111111111111111101000100101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
back_3[ 17] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000100000100001111111111111111101111111111111101111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000000000000000;
back_3[ 18] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000001010011111111111111111111011111101001100111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100101000000000000000000000;
back_3[ 19] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010001010011111111101111111101111110001000010010111111111111110101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001000000000000000000000;
back_3[ 20] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001100011111001001011111111000111001001110100000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000;
back_3[ 21] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111101000000000000111111111010100100011111100010100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000;
back_3[ 22] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011100000010011101011111101100000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100101000000000000000000;
back_3[ 23] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101000110000011101111111111110001111111111111111111111010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
back_3[ 24] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000011111100101010000101111111010000010111111111111111100110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111100010000000000000000;
back_3[ 25] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000100000011111100001111111110000110111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110000000000000000000;
back_3[ 26] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100010011100100000011111111001111111110001111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
back_3[ 27] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010010101011111101111111110000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010000000000000;
back_3[ 28] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011010100001011111111001111111111010111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
back_3[ 29] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010111110000111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000000;
back_3[ 30] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000000;
back_3[ 31] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010111111001100111111011111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
back_3[ 32] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
back_3[ 33] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
back_3[ 34] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010011101000000000000000011111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000;
back_3[ 35] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101000000010100000000000000000001111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000001;
back_3[ 36] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000010000000011100011111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000001;
back_3[ 37] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000001001100000001010010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001;
back_3[ 38] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010110000000011111111010010101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001;
back_3[ 39] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111100001100100111111111110000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100001;
back_3[ 40] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000011111101101010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001;
back_3[ 41] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100100010000010010001011110000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001;
back_3[ 42] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000110010111100000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001;
back_3[ 43] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101100000000000001111000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001;
back_3[ 44] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111000011000000000100110001101100000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 45] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010110111010000000011111101110100000000000000000111111111111111111111111111111111111111111111100110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 46] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010111011101111000000000000000001111111111011111111111111000010011001100000000000000000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 47] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000001001000100100000010001110000000000000000001111111011001001100000001111000111111111111111111000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[ 48] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000001010110000111110010001110000000000000000000011101001011001000111000000000011011111111111111110000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[ 49] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001001000000000010000001110100110111001100000100000000000000000000000001010000110000000000000000011000000111110110000000000000000001111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[ 50] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000001001111110100110111111011000111000011111111000000000000000000000000000000011000000001000000000000100000000000101111111111111000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[ 51] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111111111100111101111111001110001001011111000000000000000000000000000110000111111111101100100111100000000011111111111111000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[ 52] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011011010000000001001111111110011100000000000100100000111111100000000000000000000000001100111101111111111101111111111100100000000101111111111000000000000001110111111000001011111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 53] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000010000010000000000111001011111011111111110100000001111110000000000000000000000110011111111100111111111101111111111100100000000001111111111111000000000000000000000001111111110000100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 54] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000001111100010010010000000000011011111101111111011111000011100011000000000000000000011100110111111111101111111111101111111111100100000011111111111110000000000000000000000000000000001111000110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101;
back_3[ 55] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011100011011010000010000011101011010111111111111101101100010000000000000000001101111110111111111101111111111101111111111100100000010000010001111111111111100000000000000000000100000010110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111;
back_3[ 56] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001000110000000000001101000111110011110000001100111111111111111111100000000000000000110111111110111111111101111111111111111111111111111111101111111100000000000011111100001111111100011000001000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111;
back_3[ 57] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000001100000010010000001000011101000000011000000101100110000001111100111110111111111111111010000000000000000010101111111111111111110001011111111011111111111111111111100111000000001111111111000011100000101111111010011101110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110011111110;
back_3[ 58] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000100000010000001011000000000010000111000101011100001111011111111111111111111111101110000000000000000001011001111111111111110000011111111111111111111111111111111111111111100000000000000000111011111101111111110011101110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110000100011;
back_3[ 59] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101100000000000000100110011000000000011001001000000010100011111100000001111111111111111111111111111111111100000000000000101111011111111111111111110011111111111111111111111111111110111011111011111000000100001111001111111100000100000001111010000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100000000001;
back_3[ 60] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000001000000001111001011111101111100000000110011111010111111110001111111111100111111111111101111110000000000000000011111111011111111011111001111111111111111111111111010001111111111111111111110011011111111101101111111100000000000000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000001000000;
back_3[ 61] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000001000000000000010000001110001111111110101101100010011011111101100001111111111111111001011111111111110111100100000000000011011111111011111111001011111111000000000111111111101110000000111001001001111111001100100000000000100000000000000000000111110001111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000;
back_3[ 62] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000100000000010010000011011111111111111111110111010011111111111110111111111111111111111111111111111111100000000000000110011111111011111110111111100000000000011111111000000000000000100111111001111110100000000000001000000000000000000000000011111011000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
back_3[ 63] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001100010010110110111010000010111111111111111111110111111111111111111111111111111111011111111111111111111110100000000000010110011111111101111110110000000010000000111111110011000000011001101101100110000000000000000000010000000000000000000000000111010101101000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
back_3[ 64] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001000010001110010010011111001111111111110111111100011101111101111111111111101100011011111111111111111111110000000000000111110111111111111111000011111111011000001111111100111110011011110000100000000000000100100000000000000000000000000000000010000010111001110000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000010000;
back_3[ 65] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110000000000000000000000000110000010011010111010000011111111111111100101111111101011111111111111111111111111111111111111111111000010000000000010111110111111111110000011111111111110100111111101100111110100110000000000000000000000010000000000000010000000000011111111110111001111101110011000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
back_3[ 66] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000000110100000111111111111111110111011111101111111111111111111111111111111111111111111111000000000000000111111111111111100001101111111111111101100011111110111111110000000000000000000000000000000000000000000000000111111111111111111111101011001111000000111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000100;
back_3[ 67] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000011100000010000000000001111111111001111111111111111111111111111111111111111111111111111111111100000000000000000001011111111111000001111111111001111110000000010111011000010000000000000000000000000000000000000000000011111111110111100011110000100010111110011100001001011011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110010111101000000000011;
back_3[ 68] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000001001000001000001100000000000000000000000001101000001111000000111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000011111111100001111111111110000011111000010000000010000000000000000000000000000011000000000001111111111111111001111101111100011010111111110110000010000111010110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011110010110110110100000010011100;
back_3[ 69] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000000000000010100010100000000001001000000000001000011100000011111110111111111111111111111111111111111111111111111111111111111111111101111101111001100010000000000000000000010111111100001000011111111110000100001000000000000000000000000000000011100000000000000011111111110111100111111111111110111000011001100100010110011011100011100000010011011111111111111111111111111111111001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111110000000001101;
back_3[ 70] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000001100001000000000000000000001001100100000000000110000001100011100110111111111100111111111111111111111111111111111111111111111110010000000000000000000000000000000011111111110000000000011101001000000000000000000000000000000000000001111110000000001111111111111110001111111111111001111111111010000110110110000000011011100110111110000101101111111111111111111110000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111110110000001011111101001100001111;
back_3[ 71] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000011110000001000000011100000000000000010100010000000011110010111001100100010000001111111111111111100111111111111111111111111111111111111111111111100000000000000000000000000000000000111111111011000111000110001100000000000000000000000000000000000111000000000111111111111111100111111111100010111111111111111110000001100101101111000000011110001111011111001110111111111111111110000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111100110000010011111100000110001111;
back_3[ 72] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000001110001001000000000110000110111010000000000000000100100111110000000000000000010001100000100000000000000000111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000110000010101111001100100000000000000000000000000000000000000000000000000000001111111110111110001111111110011111111111111111111000000100001010011111111100011000000000101100110111001110001111111101111110000000000000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000001000000010111100000000110011010;
back_3[ 73] = 640'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001111100011010000100001100001110000100000011110011100000000111110000001111000000011100011111111111111101111111111111111111111111111111111111111111111111000000000000000000000000000001111001101011111101000000000000000000000000000000000000000000000000000011111111111111100011111111101110111111111111111100000000000000000001111011000001011111001110000000101110111011001111011111111110000000100100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111100000000000000100010100000011101111;
back_3[ 74] = 640'b0000000000000000000000000000000000000000000000000101111110001100000001000000000000000000000000111110000000100000011111111111000000000011111011111101011111110100111111111111011100001111111111111111111111111111111111111111111111111111111111111111000000000000000001100000000000110001110111000000000000000000000000000000000000000000000000001111111110111111001111011110001111111111111111010000000000000000000000001111110011100010111100000100111000000010111110011111111111111110000000000000001011101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000001100000001011111;
back_3[ 75] = 640'b0000000000000000000000000000000000000000000000000000100000001110000000001000000000000111010011000000100000100000011111111111111111111111111111011111111111111111111011111111100001111111111111111111111111111111111111111111111111111111111111111110000000000000000001100001001111111111111100000100000000000000000000000000000000000000011111111111111100011000111100010111111111111111100000000000000010000000000000000111111111110111011101001010110001100000001110010011111100111111000001000000001001101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000001001000000000110010;
back_3[ 76] = 640'b0000000000000000000000000000000011100000000000000001000010000000000000010111110001110010100001000000110000010001111111111111111111110111111111111111111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111110000001111000000111110101001001111101010000000000000000000000000000000000000001111111111011111000111001110000101111111111011010000000000000000000110011010000000000011111111011000111100110011010100111100111000000110011011110110110111010000011111001101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011000000010000000000000000010101;
back_3[ 77] = 640'b0000000000000000100011001000000000000000000000000000000010110001111000000000000000110000100000000000000010110111111111111111011111101111111111111111111111000011111111111100111111111111111111111111111111111111111111111111111111111111111111111110000000111110111011110000100001000000000000000000000000000000000000000000111111100111110011111111100111111111111110100000000000000000000001000101100010000000001111111111110011100001101011000101001010101110011100000011011111001100000010001111110001101001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000000000000000000000011101;
back_3[ 78] = 640'b0000000000000000000000000000000000000111000000010000000111011111111111100011000001110010000010000111010111111111111111111111111111100111111111111111110111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111001010010000000100000000100000000000000000000000000000111111111001111000110001111001101111111111111000000000000001000000000000000000000111111111111111111111111000011111000011111100011101101110010110011110000001111001100101011000000010000101001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000010000000000000000011000;
back_3[ 79] = 640'b0000000000000111000000000010111011110000000000000000111011111110011111101101111000000111101110111011111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001111011100001000100001000000000000000000000000000111111111110011110001100011111011011111111111111100000000000000011001000000000000000111111111111111111111111111111000111111100001001110011110011000110110000100111000000011110101001000111111000010001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000010001100000000000101001;
back_3[ 80] = 640'b0000000000000100001110000111000000100000111111111011111111111111111111111100111110000000011111111111111011111111100011111111101111101111111111011111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111100110000000000000000001100000000000001111111111100111000011000111000111111111111111110000000000000001100010011111000000111101111111111111111111111111111111111000111111111111101100011111000110100010010011110011100000000101111111111111100000101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000000001000000100000000000000000111110;
back_3[ 81] = 640'b0000000000000000010100000100010111111111111111110011111111111111111111110001111111100011111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001111100110000000000000000000000000111110111110001111000110001100001111111111111111100000000000000000000000111100011111111111111110000111111111111111111111111111111000011111111111111110110111111111000110011110000011000110000101111101111111100011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000010000000010000001100010;
back_3[ 82] = 640'b0000000000000000111100001001111111111111111111010111111111111011011111111111111111111111111111101111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111100000000110000000000001111101111101011100011000011100111111111111100000100000000000100000000000000000111111111111111111111111111111111111111111111111111111111000011111111111111111111000000111110111000110001101100010001000111100111110111011000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001000010000000010000001101011;
back_3[ 83] = 640'b0000000000000011111110011111111111111111110111111111110111111111111111111111111111111100111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000111000000000000000111111001111010110000110001110001111111111110000000000000000000001000100000000000001111111111111111111111111111111111111111111111111111111111111100011111111111111111111111011011011111101011001111111100101011111110101111010110010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000110000000010000010100110;
back_3[ 84] = 640'b0000000010000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111000000001111111110110001110000100011100011111111111100000000000000000000000000000000000000000101111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111100011011111111100100011010100000111100010111001110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000111000001000000000001011;
back_3[ 85] = 640'b0000000000001111111011000111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000110001111110111110011111011000011000111111111110000000000000000001000100100000000000000000001000111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111011111111111100100011110011101101100100011110001111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001010010000001000010001000110;
back_3[ 86] = 640'b0000000000001111111011111101001101111111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001110011111100111111110000110001111011111000000000000100010011011111000110000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111101101111111000011110111111100011111010000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001000000001101110001101000000000110;
back_3[ 87] = 640'b0000001000000101111111111101111111111111111011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000010101100001110011110011110101100000000000000000100110111111001110000001100000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111110001111111111111101110000001000111110001011110011100011100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001010000000111111010111100000011111;
back_3[ 88] = 640'b0000011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000011101111111100000000000001011001001001111100011111111111111110000000000000000000000011111111111111111111111111111111111111111111111111111111111100001111111011111111111000111100001111111111111101111110111101011100101011111110000010000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000000000011000101100000001101;
back_3[ 89] = 640'b0000100111111111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000011110000111101000000000000000000011011001111000100101111111111111110000000001111111100000000000000000001101111111111111111111111111111111111111111111100000000111111111100011100111111111111111111111111100001110110000111000101110111111000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000000010111110000100000;
back_3[ 90] = 640'b1001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001100010000000000000000100100110110011110000000111111111111111111111111000000001111111100000000000000000000000000001111111111111111111111111111111111111000000000111111100111111111111111110011111111111111111101000010110000010000010010000000100011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000010011000000000101;
back_3[ 91] = 640'b0111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000010000000000000001001101100111100011111111111111111111111111111111100000000001111111100000000000000000000000000000000011111111111111111111111111111111000000000000000000111111111111111110011111111111111110000010111001010110010110011000000100111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110100010000001000001110000000000100;
back_3[ 92] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000100100011110011001001110000111111111111111111111111111111111111110110000000111110011100000000000000000000000000001100101111111101111100111100000000000000000000000000000101111111111111110111111111111110001100001100011100010001100000000001101011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000100000010000000000101100100000;
back_3[ 93] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000001010000111110011111111111111111111111111111111111111111111111111110000000000000010000000000000000000000111111111111000011001111111000000000000000000000000000000000000000011111111111111111111110000111000100100100001111100000111000000000011101001001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000010000000000111000001;
back_3[ 94] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000010010011111111111111111111111111111111111111111111111111111111000000000000000000000000000000011110111111111110000000011010000000000000000000000000000000000000000000000000111111111111111110111111111100001101000000110000000100110000000001101001010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000001000000000000010001;
back_3[ 95] = 640'b1111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000100111000011111111111111111111111111111111111111111111111111000001000000000000000000000000000111111111110111111000000000000010100111111100000000000000000000000000000000000000000110000000000000000011111101100001101100000110000001100010000000011101100110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000001000000000100100000000001010011;
back_3[ 96] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011011000111111111111111111111111111111111111111111111111000000000000001110000000000001111111111111111110000000011000000000000000000000000000000000000010011000000000000000000000000111111111100000101011100010111100100001110000000100110000000111101100100111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111110111111111110010001001100000000001101000000001000000;
back_3[ 97] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000011010001101111111111111111111111111111111111111111111000000000000001000000001111111101111111111111111111000111111111000000000000000000000000000000000010001100000000000001111111111111111000000000100011100001101110000000110000001100010000010111101110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111110110110100100000000001000000000100010000000000000000;
back_3[ 98] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000100000010101111111111111111111111111111111111111111110000000000000000000111111111111100111111111111111111111011100111000000000000000000000000000000000110000000000111111111111111100011111111111111011111111011100011000000110000011100111000011111101110000111111111111111111111111111111111111111111111111111111111111111111111111111111110111101011110010000100000000110101000000000000000000010000000001;
back_3[ 99] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000001000110101111111111111111111111111111111111111111110000000000000000000000000111110000011111111111111111111111000111010000000000000000000000000000000000000011100111111110000011111101001111111111110001011000000000100000111000001110011101111111101111000011111111111111111111111111111111111111111111111111111111111111111111111111111100111011101001100000000000000011010010000000000000011000000000001;
back_3[100] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000010011100001111101111111111111111111111111111111111110000000000000000000000000000000000010010001111111111111111111010000001000000000000000000000000000011111111000000000110000000011111111001111100001101011011000000000111001101111000001100011111111111101111011011111111111111111111111111111111111111111111111111111111111111111111111111111000000011100000000000000000000011111101000000000001101000000000001;
back_3[101] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011000000000000000001101000010111001111111111111111111111111111100000000000000000000000000000000000000000000111111111111111111111111000000000000000000000000001111111111001111000000000001111111111111111111110001111111110111110000000000000001100110000011110100111111111101111000011111111111111111111111111111111111111111111111111111111111111111111111111111101010011000000000000000001111110111111100100000000100000000000010;
back_3[102] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000001111000101101101111111111111111111111000000000000000000000000000000000000000000001111111111111111111111111111111100000000000000000011111111111111100000001111111111110111111111100000110000001111111101101111000000110000000100110000011010101111111111101111100101111111111111111111111111111111111111111111111111111111111111111111111111111100100011000000000000000001011110001111011111000000100000010000011;
back_3[103] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001010000010100001111111101111111111111110000000000000000000001000000000000000010000000000001111111111111111111111111111111101111111111111111111111111000001111111111111111111111100000111111111000000111111110101000010000000010000011111111000000010010111111111101111000001111111111111111111111111111111111111111111111111111111111111111111111111111010000000000000000011011111011101011001111101110011001000010000010;
back_3[104] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001000001100011011100011011111001111111100000000000000000000000111111111100000000000000000000000000000000111111111111111111111111111111111111111110000011111111111111111111111000000100111111111111111110001111111111101100110000001111111110001111011111111000111111111101111110011111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000011001110111110100111110100111111000000100000000;
back_3[105] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000111100011100010010000111111110000000000000000000000001111111110001111111110110000000000000000000000000000011111111111111111111111111111111111111111111111111111111111110000011111111100011111111111111111111111111110101111111111110000000000111011111111110000111111111101111100001111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000011110001011000111100011010111000011000000000101;
back_3[106] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111011111110000000001001000000000000000000000000001111111000100111111111100000000000000000000000000000000111111111111111111111111111111111111111111111111111000000110001111111111111100011111111111111111111111111110111111111100111111111111111011111111100100011111111101111110010111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000000010110000100100111100000001111010111111000000000;
back_3[107] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000111100011100000100000000000000000000000000000000001111111111101111111111100100000000000000000000000011111111111111111111111111111111111111111111111110000111111111111000011111111111111111111111111111111111111111100011111011111111111111111111001100110010100001111111101111110000111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000001001011110110000010011011101111110100000000;
back_3[108] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111101111111000000000000000000000000000000000000011111111111100111110001111110000000000000000001111111111111111111111111111111111111111111000000000000011111111111111111111111111111111111111111111111111111111111000001111111111111111111000001110010100111000110111111101111110001111111111111111111111111111111111111111111111111111111111111111111111111000001010000001001111100000000001010010000000011010010110111111110000;
back_3[109] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111111100110000000000000000000000000000000000110111111111110000110000010111100000000000111111111111111111111111111111111010111111111000011111111110000011111111111111111111111111111111111111111111111111111111111111101111111111100000000111111111111110100010010111111101111111000111111111111111111111111111111111111111111111111111111111111111111111111111100100001101000000111000000001111110110100100001110100111001111000;
back_3[110] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000111100111111111000110000000000000000000000000000000000100011111111000000000000110011111111111111111111110001111111111111011111111111000000110011111111111110000111111111111111111111111111111111111111111111111111111111111111111110000000000111111111111110001101000110000111111101111111000111111111111111111111111111111111111111111111111111111111111111111111111111001100101100000000111001000001100001111000000110000111111001000011;
back_3[111] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000001110011111111111111111000010000000000000000000000000000000000000001111110000000000011111111111111111000110111111111111111111111110011000011111111111111111111111110000111111111111111111111111111111111111111111111111111111111111111011110011110111111111111111110000110001100000111111101111111101011111111111111111111111111111111111111111111111111111111111111111111111001001000000010000010100000000001100011101111100100010001101110001100;
back_3[112] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000011100111111111111111111111000000000000000000000000000000000000000000000000011110111111111111111111111111001111111111111010111110000000011000011110011111111111111111111111111111111111111111111111111111111111111111110000000101111111111000001110111111111111000000000000000110101001011011111101111111100011111111111111111111111111111111111111111111111111111111111111111110111000000000000001100010000000000001010100111111011010101110011001011011;
back_3[113] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000111111111111111111111100000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111110100000111111110110000101111111111111111111111111111111111111111111111111111111111111111000000000000000011111111111000001110111111100000000000000000000111100011010011111101111111110011111111111111111111111111111111111111111111111111111111111111111111101000010000100000110000000000000000110010000110100000001000110110000000;
back_3[114] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000110011111111100111000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111000000011000001111111011111110101111111111111111111111111111111111111111111111111111111111101111000000000000000001111111111000001110110000000000000000000000000111100000010111111001111111110001111111111111111111111111111111111111111111111111111111111111111111001000000000000000001000000000000000001110100101010011001101010010000001;
back_3[115] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000111111111000000000000000000010000011000000000000000000000000000001111111111111111111111111111111111111100001111111111111011111111111011111111111111111111111111111111111111111111111111111111111111001111100000000000000000000001111111110000001110000000000000000000000000000111010000100011111001111111110001111111111111111111111111111111111111111111111111111111111111111100100000000010000000010000000000000000000100111110000001100100100000000000;
back_3[116] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000111011111111001000000000000000000000011000000000000000000011111111000000000011111111111111111111100000001111111111111111111111111111111011111111111111111111111111111111111111111111111111111111110110000111110110000000000000000001111111100000001110000000000000000000000000000111100000100001111001111111111001111111111111111111111111111111111111111111111111111111111111111110000000000010000101111100011000000000000001111111111000100001110100100001;
back_3[117] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000001110001111111111111110000000000000000000000110000000000011111111111000000000001111111111111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000000000110100000000000000000011111000000000000111000000000000000000000000000111100001000001111001111111110001111111111111111111111111111111111111111111111111111111111111111111100000000000001000000100010000000000000001110000011010001100111110100001;
back_3[118] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000111100011111111111111111111000000000000000000000000000000111111111001000000001111111111111111000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000110100000000000000100111111000000000000111000000000000000000000000011111111000010000111001111111111000111111111111111111111111111111111111111111111111111111111111111001110000000000100000000100100000000000100001100111101011000110101011100000;
back_3[119] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000001111001111111111111111111111110111000000000000000000000111111111110000000011111111111111111000000011111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111000110000111110000000111111111111111000000000000111000000000000000000000000011111111000100000110001111111111000111111111111111111111111111111111111111111111111111111111111100111100100110000111100000001100000000011100011111010100101000010110000100001;
back_3[120] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000111100111111111111111111111111111101100100000000000000000011111111111100000111111111111111110000111111111111111111111111111111111111111111111111111111111111101110111111111111000111011111111111111111111111111111111111111111111111110111110000001111111111111111111000000000000111000000000000000000000000001111110100001001010001111111110000111111111111111111111111111111111111111111111111111111111111110001011001110110100000000000001000111111111111010111001011000011100000000001;
back_3[121] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000011110000111111111111111111111111111110001111100100000000000010000000000000111111111111111111100000011111111111111111111111111111111111111111111111111111111111101110111111111111101001001111111111111111111111111111111111111111111111111100000111100001111111111110010111111000000000000111000000000000000000000000001111111000001001011111111111110000111111111111111111111111111111111111111111111111111111111111011110010010110100010000000000010011011111011110000011001111000001100000000100;
back_3[122] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000011100111111111111111111111111111111111000010000000000000000000000000000011111111111111111110000111111000011111111111111111111111111111111111111110111111111110111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111110001011100101100001111111000000000000111000000000000000000000000001111111100111000011100111111111000011111111111111111111111111111111111111111111111111111111110011111011110110000110000011000010000011111100111101101110110010001000000000110;
back_3[123] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011000111111111111111111111111111111111111100000000000000000000000000000000111111111111111000001111111111111000111111111111111111111101111111111111111110011111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111101111111111101100101111000000000000111000000000000000000000000001111111010001001100110111111110010011111111111111111111111111111111111111111111111111111111111111111001110000000000001010110000011111000000000101111111010011111100001000010;
back_3[124] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010111111111111111111111111111111001010000000000000000000000000010011111111111011100000001111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111000000000000111000000000000000000000000001111111100000100100000110001110000011111111111111111111111111111111111111111111111111111100000001001100010000000000011001000010011010100000111111111111000011101100000100010;
back_3[125] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101110000000000011111111111111111110111111111110000000000000000000000000011111111010000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111000000000000000000000000001111111110011100110111010001110000001111111111111111111111111111111111111111111111001110000010001000000000000000000001110111011100010111000101100001011110101111111111101110;
back_3[126] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000011111111111111111110011100000000000000000000000000111111111110000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111000000000000000000000000001111111101000000001111101000110001001111111111111111111111111111111111111111111111100000000000000000000000000001111101000111001111011001100000000100111011000000010000000000;
back_3[127] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001100111111111111111110000000000000000000000000111111110111110000011111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111110000000000000000000000000001111111110000010001011100010101000001100111111111111111111111111111111111111111111110000000000000000010001100001101101100011111001001110000001000000001100000010010000000000;
back_3[128] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000000100111111100000000000000000000000000001101111111110000011111111111111111111111111111111111111111111111111111111111111111111111100111110011111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011000110010000000000000000000000001111111010000110010110100100011111111000111111111111111111111111111111111111111100000000000000001110011001000000010110110000100000000011000010000000000100000010100000000000;
back_3[129] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000110000000010100110000001100000000000000000010101110000000001111111111111111111111111111111111111111111111111111111111111111111111111110111100111110000010011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011110000000001111111000000000000000000000001101111011100001000011010011011000011110000011111100011111111111111111000000000000000001000000011100111111000000011110000100000000000000001000101010011001110010100000000001;
back_3[130] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101011000110000000000000100000000000111000100000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000100010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000100001111100001111011000000000000000000000001101111011100011000000001100001100010000111111001000011111111000000000100000000000001011100111111110000100000100000011001100000000110010010000000001001011111111010000000011;
back_3[131] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001101110000001111100000010000001110000000000000000000000111111111111111111111111111111111011111111111111111111111111111111111111111111111111111011100111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000001000111100000000000111100000000000000000000001101111111010010011000000110001001010111000111111000101111100000000000101001110000011111100000010100011100001010000000000000111111100110000000000000101011001011000000000111;
back_3[132] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001001100000010000000000111000000000111100011100000111110111011111111111111111111111111111111111111111111111111111111111111111111111111110111111111000111101011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000011000000000000000000000000000001100000000000000000001101111011100000101110111011000000001001000010000110000000000000111001000111000100000011000000000000001000000010010000001001111111111000000100000000011111100011110000001001;
back_3[133] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001001110000011110000000000000011111111110011111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000011111010111111111111111111110000000111111111111111100110000000000000000001101111011100001000000011000000001101001010000010111000110110111111000011101100100000111000000000000001000000011000000001100111111110000011111000000001000100000010000000001;
back_3[134] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011110000000001111111111000111111111111111111000111111111111111111111111111111111001000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000111111111111111111111111111111111111111111111111111111111100110000000000000000001101111111111000011110001110111111000000011000010110110100110100111101001101100001000011100000000000000100000010100000011100111111110000011111010100011011100000011010000001;
back_3[135] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110000000001111111110011111111111111111111101111111110011111111111111111111111000000000000011111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000001111111111000001111111111111111111111111111111111111111111111111010101000000000000000001101111111111000011100101000000001111100000000000100000110001110011011101100100000000000000000000000000000000011011000001111111111110000001111010100001001000000111100000000;
back_3[136] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111100000000001111011111111111111111111111111111111111111111111111111111111111110001100000110111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111110000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111101001000000000000000001101111101110100000001111001011001100011111000001010000011101111111100111000000000000000000000000000100000100000100100000011010011110000111111111111100111100000101001000000;
back_3[137] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011100000000001110010111111111100111111111111110111111111111111111111111111111111010111110110111111111111111111111111111111111111110111111111111111111011111110111111111111111111111111111111111111111111111111111000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111101111110000010100000000000000001101111101111010010001001111110010100011001111110010100001111100000000011000000000000000000101110111000001100000001000001111111111111111101111111111101111100001010000000000;
back_3[138] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011100000000001111000111111110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111010111111111111111111111111111111111111111111111100000000000000000000000000111111111111111111111111111111111111111111111111111111111111101111111111111111111100111110000100100000000000000001001111101111110001100111111111111100101100000111110000000010000000000000000000000001100000000000000000000100111111110011111100110111111101011111111101000000000001000000000;
back_3[139] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001011111000000001110000011111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000101111111111111111111111111111111111111111111111111111111111111110111101111111111110111011100111110000111110000000000000001101111101111001110011000001111111111110001101000000111111000111100000000000000000000000000000000001111111111111110000100111111111011111111011111111100011000000100100000001;
back_3[140] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001001100011111101110000111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000001011111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111100111111010110000000000000000000111111101111100001100000111000111110100111111010110000000000111110000000000000000011111111111111111010110111111011001110011101111111111011000000000111001000000000110000001;
back_3[141] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001100000001111101111100111111110100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000001111111100111111111111111111111111111111111111111111111111111111101111111111111111111011111110011111100111111101111000110111010111000000000000000111101111111111001001111111100000101011111111100100100111111111110000001111111110000000100100111111111111101000011111100000011100000000000000011111001000000001110010011;
back_3[142] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010010000111101111000111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000011111111111111111111111111111111111111111111111111111101111101001111111100111111111111111111011111100011111111111111101001010000001001100000000000000000111101111111111111100110111111110111011111111111111110000000011111111111001110000001011111111111011111111111111111100000000000110100000100001111010000100000000111100000;
back_3[143] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000100011110000111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000111111111111111111111111111111111111111111111111111111111111110011111101011111101111111000111111111101111111011111111111111000000000000001100100100111111000000000000000000101111111111111111111001001111000100011111111101110111111000000101111011111000000011111111111111111100000000000000000000000001001101001000100010000100000000011000001;
back_3[144] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110000011111100111111111011111111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000001111111111111111111111111111111111111111111111111111111111111111110011000011111101011111010111111011111111111111111111110000000000000000000000000000110010101101111111111111000000011001111111111111111111111100111110110000000011101111111111111111111111011111111111111111100000000000000111100000011111100000100000111100000000111000000000000001110100;
back_3[145] = 640'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011111111011110101111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000011111111111111111111111111111111111111111111111111111110011111111111111111000011010010111101011111000111111111111111111000000000000000000000000000000000000000010010010000000000000000000011110001111111111111111111111111111100101111101000001111111111111111111111111101111111100000000111111111111111100100111111110111111101011101111100101101000000000000010001;
back_3[146] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111011111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000011111111111111111111111111111111111111111111111111111111001111100011111111111111111000011110010110101111111111111111111000000000000000000000000000000000000000001000000011000000000000000000111111111110001111111111111111111111111111111110011011001110001111111111111110011111000111111100001111111111111111111111100111111111111111100000111001101100010100000011101100100;
back_3[147] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010011111111111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000001111111111111111111111111111111111111111111111111111111111111100000100010111111111111111111000011110011111111111111111100000000000000000000000000000000001111111100000000000000001110100000000000000000000000011001111111111111111111111111111111111111100110011000111011000000000000000010000000001111111111111111111111111101111111111111111001101110110000001000000100000000011110;
back_3[148] = 640'b0101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010011111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111110001001100011111111111111111111111111111111111111000000000000000000000000000000000000111111111111111100001110010101000111011000011111111111111101111101111111111111111111011000011111111111111110011110000000000000000000000111111111111111111111111111111111111011111111111101110000000000011110011000110001100000111110;
back_3[149] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010011111111111111111110000011111111111111111111111111111111111111111111111111111111111111111000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111011111110101101100011111111111111111111111111111010000000000000000000000000000101000001111111111111111111111110011110011101000000011011011011111111111001100000111111111111111111011110000000011111111110001111000000000111111110011111111111111111111111111111111111111011111111111111110110000111111100110100100100110000010110;
back_3[150] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010011111111111011111111010011111111111111111111111111111111111111111111111111110100000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111001111010111110001101100010111111111111111110000000000001000000000000000111111000000000000011111111111111111111111100111111001011100000001111111111111100000000110000111111111111111111011111110000000001111111000111000000001111111111111111111111111111111111111111111111111011111111111111100100001111111000110000000010011000100110;
back_3[151] = 640'b0011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010011111111111111111111010111111111111111111111111111111111111111111111110000000000000000000000000000111111111111101111111111111111111111111111111111111111111111111111111111111111001011111110111111111111111111011100000000000000000000000000111111111111111111100000110001111111111111111111111111100111111011001100000001111111111000001111111100100111111111111111111011100011111110000111111000011100000011111111111111111111111111111111111111111111111111011111111111111100000001111111000010000111000000000110011;
back_3[152] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010011111111111111111111111111111111111111111111111111111111101100000000000000000000000000000001111001111111111111111111111111111111111111111111111111111111111110111111111111111110111111111111111111110000000000001000000100000000001111111111111111110000011111110011110001110111111111111110011111110100001111010000011111111100000011111110000010011011111111111111111011011101100011100111101000011110000111111111111111111111111111111111111111111111111111011111111111111100001000111111000000111111100101100011100;
back_3[153] = 640'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100010011111111111111111111111111111111111111111111111110000000000000000000000001111101111111110000011111111111111111111111111111111111111111111111111111111111111010011111111111111111111111111100000000000000000000000010001011111111111111111001000000000000000000110011111001110110111111111111000000010110001110110011111110111000001111110100000101010011111111111111111011100011001100100111101100011111100111111111111111111111111111111111110000000011111111011111111111111001110100111111000000111111101110000001001;
back_3[154] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011111111111111111111111111111111111111111100000000000000000000000111111111111111110000111111111111111111111111111111111110111111111111111111111111111000111110011111111111111111000000000000000000000000000000001111111111111111000111010000000111111100000000110011111001111111111100100000001000001111101011000011111110110000111111100000001110110111111111111111111011100000111100100111110100011111111111111111111111111111111111111110111111100000001111011111111111101100110001111111000010111111110000110100010;
back_3[155] = 640'b0100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011111111111111111111111111111111110000000000000000000111111111111111111111111111111111111111111111111111111111111111110101111111111111111111111111111000111111111111111111011000000001000000000000000001101101111111111111110000000000000001111111111111111100011010001001000100000000000000100000000111101011110111111100101111111110000000001110110111111111111111111001101111111100100111111100001111111111111010111111111111111111111110110000000000001111011111111111101111100001111111000011111000100101011000011;
back_3[156] = 640'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111111111111000000000000000000111111111111111111111111111111111111111111111111111111111111111111111011110101111111111111001111110111111111111110000000011011111100000000000011111111111011110000100111111110000000000000000111111111111111111110000110011000000000000000000000001110111111111011101011111000001111110000000000001110011011111111111111111001101111100000100111111100001111111111110000111111111111111111111110110000000011111111101111111111111101110011111111000011111111111000100000000;
back_3[157] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110111111111000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111110101111011111111111111111111111111111111100000000000000000011011111110111111111111111111110011101111111111111100000111111111111111111111111111111110001111110010000000000111111111111111000000111111011001110000011111100000000000001111110111111111111111111001110011101010110111111010001111111111100000111111111111111111111110000000011111111111101111111111111011110111111110000011111111111111001101100;
back_3[158] = 640'b0010011111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111100111100000000000000000000011111111111111111111111111111111111111111111111111111111111111101111000111110111111011111111111111111111101100000000100010000000000111111111111111111111111111011111110111111111111100001100001111111111111111111111111111101100000111111001111111111101000001111111111111111111011010000001011111000000000000111111010111111111111111111001101110101010010111110010000111111111000000011111111111111111111110000001111111111111111111111111111111100111111111000000111111110010000001000;
back_3[159] = 640'b0001000111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111100000000000000000111111111111111111111111111111111111111111111111111111111111111111111111001111101111110111111111111111111000000000000000000000000001111111111111111110001111111101101111011111111111111111101100001011111111111111111111111111001101101111111100000000000001111111100110111111111110000111100000000001111111000000000011111011110001111111111111111001101111001011010111111110000101111111000000011111111111111111111111000011111111111111111111111111111111111011111111000100111111110110000001011;
back_3[160] = 640'b0011000110100111011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111111000000001110011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000001111111111111111111111111111000000111101101101111110111111111101101000100010011111111111111100010011111111111111111000110111111010011011111111111100000011111110000111100000001111111010000000000000011111011111111111111111001101110001001010111111110000000111110000000001111111111111111111111000000111111111111101111111111111011110111111111000100111111110000000001101;
back_3[161] = 640'b0000000110000011011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111110000000111110001100111111111111111111111111111111111111111111111111111110111111111111011111111111111111111110000001100000000000001111111111111111111111111111111111111000000110101111101101110110001011011001000000010010111111111111111111111111100000011111111001111111111110000000000111111100000000000000111010011111111111111111111100010100101000111111111111111001101110001001010111111100000000111110000000001111111111111111111111000000000000011111101111111111110011111111111111100100011111000000110010001;
back_3[162] = 640'b0000001000001001100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000111110000000001111111111111111111111111111111111111111111111111111111111111000111100111111111111111001001001000110000000010111111111111111111111111111111111111111111111011100000100101001101000100011101000000000000000001111111111111111100000111111111111111111111110000000011111111000001000011111111111110000111001000000001000100101011110011101111100111111111111111001101110001001010111110100000000111111000000001111111010100011111111000000000000011111101111111110111111111111111111111100011110000000011001001;
back_3[163] = 640'b0000000000000001000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011000001111111111111111111111111111111111111111111111111111110011111011111000111111111111100001100000000000000111111111111111001111111111111111111100110111111111111111011101110111011011001000000000000000000001111111111111110000011111111111111111111111100000111111111000001100111111111111111111111110000000111111111111111111110101001011001100110100011111111111111001110001000001010111111100000100111111000000000000000000110111111111000000000000001111101111111111111110011111111111111000010111111111101010011;
back_3[164] = 640'b0000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101011000001111111111111111111111111111111111111111111100111111111110011111111111111111111111001001100000000000111111101111111111111101111000111001110111100110111111111111111000101111011010010000000001011111111111111111000011111111111111111111111011000001111111000000011111111111111111111111110111111111111110000111101111111111100001110000101111010110010111111111111111001100110011001010111111100001100111110000000000000000011111111111111000000000000001111101111111111111000111111111111110010000111110000000100001;
back_3[165] = 640'b0000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011000000011111111111111111111111111111111111111111100111111111111111111111111111111111111001011111011111111111111111111011001100110100000110001100011100100111111110111000000000000100001001111111111111110000001111111111111111111111100000011111111110110000111111111111111111111111111111111111111111111111100011011101111000011100000000001111111010011110101111111111111001100011001011010111111000001111111100000000000000000001111111111111000000000000001111101111111111111101111111111111111000100001101101100100000;
back_3[166] = 640'b0000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010000000111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111011001111111111111110001101010110100110001100100100011101000000010000000000011111111111111100000011111111111111111111110000011111011000000101111111111111111111111101111011111111100000000001111111111110000000001100010111101100100010000110111011101000001111111111111001101110001011010111111000000111111000000000000000000000000101111111011100000000001111101111111111101111111111111111111001100110010111000101011;
back_3[167] = 640'b0000000000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000011111111111111111111111111111111111111111111111111111111111110111111111111100111111111111011111111101111111001100000111000001100011000111010000000000000000010011111111111000000011011111111111111111110000000111110000000000011111111111111111111100000000001111111111111001111111111000000000000000100000000100010000010011110000000111111011011011001111111111111001101110000011010011101100001111111000000000000000000000000001111111000000000000011111101111111111111111111111111111110011000000001110000111101;
back_3[168] = 640'b0001010000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000100000011100011110011111111111111111111010001111111111111111111111111111111111111000111100111111111111111101111111001111110000100011100000000000010000000110111110111111000000111111111111111111111000011111111000000000000011111111111111111111000000011111111111111111111111111110000111111111100100000101111111000100000000101000000000010111111011111101000111111111111101101110100011010011101100001111111110000000000000000000001111111111000000000000011111101111111111111111111111111111111100010010000000001111001;
back_3[169] = 640'b0011000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000001000000011100011110111111111111111100000000001111111111111111111111111000100111111001010001111111111111111111111101000011111000011011100000000111111111111100000111111111111111111111111000000001111110000000000011111111111111111000000000001111111001111111111111111111111000001111111111111100000000111110001101101001000010111111100000000111100011100100101111111111111101101110100111010011101100001111111100000000000000000000000111111111000000000000011111111111111111111111111111111111110111000000011000001000010;
back_3[170] = 640'b0000000000000100111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000000000000000000000111000000011111111111111110000111110110111001001111111111110000011000010000000011001000011001011101101111111111010000010011111111111111111111111111100000011111111111111111111100000001111110000000000011111111111111111111000000000000011111111111111111111000000000101010000100000111111111111111110100001111111100001100010101010111110000000011111111110110001001111111111111101110100111010011101000001111111100000000000000000101101111111111000000000000001111100111111111101111111111110111111101100110111000110000000;
back_3[171] = 640'b0000000000000000111101111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001000000110100111101101000111111100011111000000110011110011111001111101000000000000000000000000001001000010000011101101110100000000000000111111111111111100000011111111111111111111111000011111110100000000001111111111111111111000100111111111111111110111001011111000000000000000000110000111111100010000000000000010001000010111011000101110000010000111100000001111111110010100110000011111111101110100111010011011000001111111110000000010000011111111111111111000000000000100111111111111111111111111111111011111111000110110011000000000;
back_3[172] = 640'b0000000010000110100111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000001111100111000000000000100111111011111111111111111111111111001111111111000000000000000000000000001100000100111000001100000000000000000111111111111110000111111111111111111100000000111111100000000000111111111111111110010000000011111111110111111111011111111110001111111111000000000001011111111111000001000000000000000000011111111011101101011111111110111110100000011001111011000111000000000001111111100111010011011000001111111111000011111101111111111111111111100000000000100011111111111111111111111111111011100101011010000000000000000;
back_3[173] = 640'b0000000000000010000011110111111111111111111111111111111111111111111111111111111111111111111111111111101110100111010000000001000000000000011110110111011111111111111111111101111111100000000000000000000000000011100000010000000000000000000011111111011000001111111111111111110000001111111110000000001111111111111111111110000000101111111111111111111110000000000000010000000000011111111111111110000000011111100000011000000000000000001101100000001001111101111111111000011111100001001111001011011111111000000011001110111010011101000001111111111111001111111111111111111111101100000100000101010111111111110110111000000010000001111110010001111001100010;
back_3[174] = 640'b1000000000000000000001000111111111111111111111111111111111111111111111111111111111111111111111111111111001000000010000000000000000000000000111101111111111111111111111111111111111000001111111111111000001000011000000000000000001111111111110000111111111111111110100000011110000000000000001111111111111111100000000011111111111111111111111111100000001100000000000111111000010001011111100000001000000100010110000001000000000000001011100011110000111011101111111111100011001110111111111101101001001100111111000111111110010011101100001111111111111111111111111111111111111100100101001110000000001100110000000000000000000001111111111010011111100000100;
back_3[175] = 640'b0000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000000000000000000011111101111111111111111110111111111001110001111111111111111110000100011011111111111111110000101111111111111111110000011110001000000000000111111111111100000000000011111111110011111111111111111110000011011111110000000000001000000001100000000000000000001000000011111110111101000000000000000111101001111000110011000111100001101100001111100011111100100000000001001000111110000111100011101000011111111111111111111111111111111111100000000110010000000000000000000000000010000000000000000100110000011011100001000;
back_3[176] = 640'b0000000001010000000000001110111111111111111111111111111111111111111111111111111111111111111111111111101111100000100000000000000000000000011111111111111111111111010101101110001100011111111111111100000011111111111111110001111111111111111111000000011111000000000000001111111111111100000000000111111111111111111111110000000000010000000000011111111111111111100000101101011100011100000000000001011100101111100011010000000000000000011111011111110110010101000000000010110111111100011111110111100100000000001001100111100000111111100111111111111111111111110000000000000000000000000000000000000000000000000000000000010000000001011001101010010000010010;
back_3[177] = 640'b0000100111000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111000111000000000000000001111100000000001111111001110111111001000000000110001101111111011111111111111111110000001101101111111111100000001111100000100000001011101011100000000000000011111111111111010111111000000000011000000000010011111101100000010000000000101000010001011100111100000000000000111100011111001101110000000000000000001111011111110000011100000000000111111111111100011111110110100001110000000000000101100111110001111000111111111111000000000000000000000000000000000010000100000000010011001111111100011000010000010111000000111000000001;
back_3[178] = 640'b0000001110100000000000000001111111111111111111111110111111111111111111111111111111111111111111111111100011100000001111111101111100001111111111110001100000000000000111100110111000111111111111111010001111111111111100000000011111111100000000011111111111111000000000000000111111111111111111111111101100001110111100000000000011001101101010010101010000000000100100011100001101100000000000000000011011001111101111000000000000000000000111011100010001010000000111110010111111111100011111110011000000111001111100000111000101100011001000000000000000000000000000000000000001111101000000000111110111111111000011000000010000000000111100000000001110001111;
back_3[179] = 640'b0001000000000000000000000000001111111111111110111100111111111111111111111111111111111111111111111111100011000000001000001101111111111111111111110001101111111111111111111000001111111110000011111111111111100000011111110000000000111111111111111111100000000000000010001110111111111111100000000101000000110111111111111111111000000010111110000111000000000000001110001111110000001100000000000000000111001111100111000000000000000000000010011100110001000000001111111010111111110100011111111011011000000000011110000000000110000100101110000000000000000000000000000000111111111001101111101111111010000000000101100000001100010000010001100000000001011011;
back_3[180] = 640'b0010010000000000000000000000000111111111111111111000111111111111111111111111111111111111111111111111100001111000001111111111111111111111111100110011011111111111111111111111100000111111111111111000000011100000000000000011111111111111001100000111111111111111000010001111100000000000000000001111111111001000101111100000000110001010111110100011000000000000010110001111110110100100000000000000000111011111100011000000000000000000000010011100100010000000111111111011111111100000011111111001111111110000011101101100000000001111111100000111111100000000111111111011111011111111111111111111100000000000000000000001001100100010111000101000100000100001;
back_3[181] = 640'b0000000000000000000000100000001111111111001111101010001111111111111111111111111111111111111111111111111111001111111111111111111111110000000000011110111111101111111100000111111111111100000011111100000000000000111111111111000000000000111111111111111111111111111111110001110000000000000000010011111101000000000111000000000110001010000000011001000000000000001111100111110011100000000000000000000011011111110011000000000000000000000010011101000010110011111111111011111111100000011111111101111111111111111100000011000100000111111111111111111111111111110011000001111100011100111111111111100000000110000000000010001100000111101100001101000000000101;
back_3[182] = 640'b0000000000000000001001100000000001111111101011111000011011111111111111111111111111111111111111111111110111001111111111111111111111100000000011111111111110000001111111111110000001111100000000000000001111111111110000000000111111111111111111111100000000000000010111110000011111111111111110000001111000110001000000000000000111110001111100000011000000000000000011101111110001100000000000000000000010011111110001000000000000000000000010011101000010110011111111111011111111110000011111111100111111111111111111110000000010101001111111111111111111111111111111111111111110001000011111111000000000000010000000001010001100001111001011111100000000011100;
back_3[183] = 640'b1110010100000000000110000000000001101111110110111000111000111111111111111111111111111111111111111111111101000111111111111111110000000000001111000000110111111101000000111111000000000000000110111111100000000000111111111111111111111111101000000000000000000000100000000100110111110000000001000011101111110000010000000000000011101001111100111101000000000000000001001111111000100000000000000000000000011111111001000000000000000000000010011101000010111111111111111011111111111000011111111110111111111111111111111111111101000110001111111111111111111111111111111111111110000010000110000000000000000010000000001111110100011111111101111100000000001000;
back_3[184] = 640'b0000100100000000000100000000000000001111111110110000011110111111111111111111111111111111111111111111111000101000000000000000000000000000000011110010000010011111000000000000101111111111111000000000000111111111111111111111111111100000010101111000000000000001100000011001100001110000000001101111101111011110111000000000000001111101111100011101110000000000000001101111111000100000000000000000000000011111111001000000000000000000000010011101000010111111111111111111111111110100011111111110011111111111111111111111111110001011000001111111101111111111111111111111110000000000000000000000000110010011101100110100110000011100111011111000000000000000;
back_3[185] = 640'b0000000000000000010000000000000000001111111100000000111100111111111111111111111111111111111111111111111100111111110000000000000000000000000000001110000000000000000111111111111010000000011111111111111111101111111000000000000100000011100001111111111111100000000001101111111000010000000000001100011111000001111000000000000000011001111110011101100000000000000000101111111100100000000000000000000000011111111001100000000000000000000010011101000010011111111111111111111111110100011111111111011111111111111111111111111111111001110000000111000000111000000000000000000000000000100010001000011111100010000101100100110000011101110001111000000000000100;
back_3[186] = 640'b1111100000000000000010000000000000011110111111001000010100100100111111111111111111111111111111111111111100001111111111100000000000000000000010000000000000111111111111110000000010111111111111110011111111110011100000000000000011101100010001000000000000000101111100001000101110000000000000111111011111001111010000000000000000001001111110001100000000000000000000101111111100100000000000000000000000011111111001100000000000000000000010011101100010011111111110000101111111111100011111111111101001111111111111111111111111111000111110000000000000000000000000000000000100001110010000011100111000101100001000010000000010010001100010110011000000100000;
back_3[187] = 640'b1111110000000000001000000000000000001111111111110001001101000100011111111111111111111111111111111111111100000111111111111100000000000000000100010000000101101111110111011101111110011111111111000000000100000011111000000000000011100001000010100010000000001010010111101001101111000000000000001010011111000111010100000000000000000001111111000100000000000000000000101111111100011000000000000000000000011111111001110000000000000000000010011101100010011111111110000001111111111100011111111111110011000001111111111111111111111010001111000000001000000011111111111000001010011010001000001101110000010111110000000000001000000000111010111111110000100101;
back_3[188] = 640'b1111100000000010010000000000000000011101111111110001011101000000111111111111111111111111111111111111111111100111111111111100000000000000000010010000000111111111111110001000111110000000000000000000111110001000111111111111100000111000111110110000000000011110001111100000111111100000000000000010011111100011000000000000000000000011110111000100000000000000000000101111111100011100000000000000000000001111111000111000000000000000000010011101100010011110000000000001111111111100011111111111111100010010110001111111111111111110000111110000111111111111111111111111111110111111111001001000001110001111110100001100001000000000000001011111101101000001;
back_3[189] = 640'b1111100000000101100000000000000000000101111111101001101100000001101111111111111111111111111111111111111111100111111111111000000000000000000010010000010111111111111111111111001000111100000000000001000000110011110011110001100011110110100010111000000000001111100111100001111111000000000000000001111111100001000000000000000000000011111111000100000000000000000000101111111100011000000000000000000000001111111000111000000000000000000010011101100010111100000000000001111111111100011111111111111111111111000100101000111111111110000111111001111111111111111111111111111111111000000000000001000110000000000000011010000100000000011001000111000000000000;
back_3[190] = 640'b1111110000001010000000000000000000011100111100001100110000000011111111111111111111111111111111111111111110100111111111111000000000000001001011111101111111000000000000000011111100011111111111100000011111011011010001111101101101011111100001111010000000000010100110110000101111000000000000000000111011100001000000000000000000000011110111100111000000000000000000101111111110011100000000000000000000001111111000111100000000000000000010011101100011111100000000000001111111111100011111111111111111111111111111101001101000001101000111111111111111111111111111111111111111111000010000001001000000000000000000010000000000001101110001011111111010000000;
back_3[191] = 640'b1111000000010000000000000000000000001100011100011010110010010111110011111111111111111111111111111111111110100111111111111000000000100000000011111111111110000000000000010000000111101100111110111011111011010001011100000000101010111110000011110010000000000000101110111000100000000000000000000000111001110001000000000000000000000011110111100111000000000000000000101111111110011100000000000000000000001111111100111100000000000000000010011101100011111100000000000001111111111100011111111111111111111111111111111110011100100010101111111111111111111111111111111001000000000010011011001101101000001000001100000100000001011110111110111111111000010101;
back_3[192] = 640'b0111000100100000000000000000000000000011010100010000010010011000101111111111111111111111111111111111111110100111111111111000000000001011111111111111000111111111111000011100010111111100011110100101101111110000111100000000011111011110000111110110000000000000101100111100100000000000000000000000111000110001000000000000000000000011111111100111000000000000000000101111111110011110000000000000000000001111111100111100000000000000000010011101100011101000000000000001111111111100011111101111111111111111111111111111111110110010100101111111111111011110000000110110110110011110111100010000010111111110111110000000000000011111111101111111110010000001;
back_3[193] = 640'b0000000000000000000000000000000000000110010000011001000000000011111111111111111111111111111111111111111110100111111111111000000000011111111100010000101011111111101010000000110111111111000100101100011111100001111111000000000001011011000011011000000000000000101100111100100000000000000000000000111111110001000000000000000000001011111111100111100000000000000000101111111111011110000000000000000000001111111000111100000000000000000010011101100011101000000000000001111111111100011111111111111111111111111111111111111111111000011010100000000100100100110110110110011010101111111111110100011110111011001101100000001000011011111100011111110111111101;
back_3[194] = 640'b0010000000000000000000000000000000000000011011001000000000000111011111111111111111111111111111111111111110100111111111110000000000011111111100000011001111100000000010011000011000100111000000011011101101000011111110000000000001111011100010000000000000000000101100111100100000000000000000000000111001111001000000000000000000001011111111100111100000000000000000101111111110011111000000000000000000001111111000111110000000000000000010011101100011101000000000000001111111111100011111111111111111111111111111111111111111111011000101100111101100100101101001111001101111111111111110100111000111111011110100110000010001001111111000001111000100011101;
back_3[195] = 640'b0100000000000000000000000000000000000000000011100000000010000000000110011111111111111111111111111111111110100111111110100000000000111111110000111101111101110000000001001111111100011111110000000001111001100001111110000000000001110011100010000000000000000000101100011100100000000000000000000000111011111001000000000000000000001011111111110111110000000000000000101111111110011111000000000000000010001111111100111110000000000000000010011101100011100100000000000001111111111100011111111111111111111111111111111111111111111010000000111100010011011110111110111111111111111111100101111110010011111011110000000111111110000011110011000110011010111101;
back_3[196] = 640'b0000000000000000000000000100000000000000001110010100001100000000000100011011111111111111111111111111111110000111111100000000000000000001111111000001001101111100000110011011110000011111110000000000111001110001100000000000000001110001111010000000000000000000101110011110100000000000000000000000111110111001000000000000000000001011111111110111111000000000000000101111111111011111000000000000000000001111111100111110000000000000000010011100100011100100000000000001111111111100011111111111111111111111111111111111111111111110000111111111111011111011001101111101101111111111001111000011111110111101100000111101001101110011011110000000111011111101;
back_3[197] = 640'b0000100000000000000000000000000000000000000000001000000000000000000000001111111111111111111111111111111110000111111100000000000000000000110111011111000011111100000000001111111000011111100000000000111000111001100000000000000000100000111010000000000000000000111110111110100000000000000000000000011111111001000000000000000000001011111111110011111000000000000000101111111111011111100000000000000010001111111100111111000000000000000010001100100011100000000000000001111111111100011111111111111111111111111111111111111111110110000011110000000011011110111110010111111111111110111100011111111111100101110000001111110111001101000111110000000000110101;
back_3[198] = 640'b0000000000000000000000000000000000000000000001000000010000000000000000000001111111111111111111111111111110000111111000000000000000000010111100111110000111111110000000001110111100011011000000000000111000011001100000000000000000110000111000000000000000000000111110111110100000000000000000000000011111111001000000000000000000001011111111110011111100000000000000001111111111011111110000000000000000000111111100111111000000000000000010011100100011000100000000000001111111111100011111111111111111111111111111111111111111110110000011111110111111111111111111111111111111111111110011111100000000000000101111011111100000000101111010010000000010011001;
back_3[199] = 640'b0000000000000000000000000000000000000000100000001110000000010000000001111101111111111111111111111111111110001111110000000000000000000000001011111010000011111110000000001110111100010000000000000000011000111001000000000000000000110010111000000000000000000000111111111110100000000000000000000000111111111001000000000000000000001011111111110011111110000000000000101111111111011111110000000000000000001111111100011111000000000000000010011110100011000000000000000001111111111100011111111111111111111111111111111111111111100000000000111000011111111111111110011111111111111111111111111111111100010010011110011111011001000000010110000100010011100010;
back_3[200] = 640'b0000000000001000001000011011111000000000000000001010001000000000000011000111111101111111111111111111111110001111110000000000000000000000000010100011000011111110000000001111101110010000000000000000011000111001000000000000000000111011111000000000000000000000111111011110100000000000000000000000111111111001000000000000000000001011111111110011111110000000000000100111111111011111110000000000000000001111111100011111000000000000000010011110100011000000000000000001111111111110011111101111111111111111110111111111111111101100011111111111111111111111111111111111111111111111111111111111111001100010011100111111010000011000110000000000010011101000;
back_3[201] = 640'b0000000100000000011000000011001100000101000101010010000000000010000000010011111001111111111111111111111110001111110000000000000000000000001010100011100011111110000000001111111110010000000000000000011010111101100000000000000000111011111001000000000000000000111111111110100000000000000000000010011111111001000000000000000000001011111111110011111111000000000000100111111111001111110000000000000000001111111100111111000000000000000010011110100011000000000000000001111111111110011111101111111111111111110111111111111111110110000011110000000011111111110000000011111111111111111111111000000000000100111111111110010000000011001001011100100010010000;
back_3[202] = 640'b0000000100001100010000000000001111110111101100000010000001000000000100011000101001111111111111111111111110001111100000000000000000111111111010111001110011100111000000000111111110010000000000001100011010111101000000000000000000111011111001000000000000000000011111011110100000000000000000000010011111111001000000000000000000001011111111110011111111000000000000101111111111001111111000000000000010001111111100011111000000000000000010011110100011000000000000000001111111111110011111101111111111111111110111111111111111110100000000111111111111100000000000000000111111101110000001111100100001101000111111111111010000000011001001100101001000000100;
back_3[203] = 640'b0000001000011000000000000001111111110011111110000001010000000000000110000110000000111111111111111111111111001111000000000000000000111111111010110001110011111111000000000111111110010000000000001100011110111101000000000000000010111011111000000000000000000001011111111110100000000000000000000010011111111001000000000000000000011011111111110011111111000000000000000111111111001111111000000000000010001111111100011111100000000000000010001110110000000000000000000001111111111110011111101111111111111111110111111111111111100100000000111111111111000000000000000000011111111111111111111111101111100011011101111111110000010000001100100010000010000000;
back_3[204] = 640'b0000011110111000000000000111111111111001100000000000000000001000011111000001011000111111111111111111111111111111000000000000000000110111111010110001111011111111000000000111111111010000000000001101011111111101000000000000000010111011111000000000000000000001011111111110000000000000000000000010111111111001000000000000000000111111111111110011111111000000000000100111111111001111111000000000000010001111111100011111100000000000000010001110110001000000000000000001111111111110011111101111111111111111110111111111111111100100000000111111111111000000000000000000100111111111111111111101000111000010001111111100100000000000000100011111000000100011;
back_3[205] = 640'b0000110000110000000000000000111111111000111000100101000000000001001101011000010000100101111111111111111101111110000000000000000000111111111011110011111011111111000000010111111111010000000000011101011111111101000000000000000011111011111000001111111000000101011111111110000000000000000000000010111111111001000000000000000000011111111111111011111111000000000000000111111111001111111000000000000010001111111100011111100000000000000010001111110001000000000000000001111111111110001111101111111111111111110111111111111111100000000001111111111000000000000000000000001111111100000001111110101010000000111101111000000000000000011000100010100010001011;
back_3[206] = 640'b0000000001000000010000000100111111111110010000000000000000000001011111100111011001111101111111111111111101111100000000000000000000111111111011111011111011111111000000010111111111010000000000111101111111111101000000000000100011111111111000001111111110000101011111111110000000000000000000000010111111111001000000000000000000111111111111110011111110000000000000000111111111001111111000000000000010001111111100011111100000000000000010001110110001000000000000000001111111111110001111101111111111111111110111111111111111110100000001111111111000000000000000000000000111111110111100000000000011100001011100000000000001000000010001111010000100011100;
back_3[207] = 640'b0000010001000000000000011111111111111111000000000000000100000000001111111110111100000101111111111111111000111000000000000000000000111111111011111111111011111111000000010111111111010000000000111101111111111001000011011110100011111111111000001111111110000111011111111111000000000000000000000011111111111101000000000000000000111111111111110011111110000000000000001111111111001111111000000000000010000111111100011111100000000000000010001110110001000000000000000001111111111110001111101111111111111111110111111111111111111100000000001111010000000000000000000000000011111101100000000000000010000001000010100000000000000000000111001000010100000001;
back_3[208] = 640'b0001000010001000000000010011011111111111100100000100000000000000000111111111111001110011110111111111111011111000000000000000001110110111111011111111111011111111000000010111111110010000000111111101111111111001000011111110100011111111111000001111111110001111011111111111000000000000000000001011111111111101000000000000000000111111111111111011111110000000000000000111111111001111111000000000000010000111111100011111100000000000000010001110010000000000000000000000111111111110001111101111111111111111110111111111111111101100000000011110000000000000000000000000011111111100000000000100000011110010000110000000000010000000011111001001100000000001;
back_3[209] = 640'b1010010010100000000000000001001111111111100000000000000001001111101011111001011100110001110111111111111001110000001111111111111110000111111001111101111011111111000000010111111110010000010111111101111111111001000011111111100011111111111000011111111110001111011111111111000000000000000000000011111111111111011111111111000000111111111111111011111110000000000000000111111111001111111000000000000010000111111100011111100000000000000010001110011000000000000000000000111111111110001111101111111111111111110111111111111111011000000000011100000000000000000000000000011011111101000111111111110001100011110010000000000110000010011011010110001000100101;
back_3[210] = 640'b0110010010010000001100111001000111111111111000011000111000000001100111000000001101110011110111111111100110000111111111111111111100000111111001111111111011111111100000011111111110010000011111111101111111111001000011111111100011111111111000011111111110001111011111111111000000000000000000000101111111111100000001100111100001110111111111111011111110000000000000000111111111001111111000000000000010001111111100011111100000000000000010011110011000000100000000000000111111111110001111101111111111111111110111111111111111011000000010111100111000000000000000000000001111111100001111111111111011110001111000001001000000000010000111010111001010000010;
back_3[211] = 640'b1100001101100011111110000011001111111111010100111001000000000000001111101111100000110011110111111111111000000000111111111111111110000111111001111111111011111111100000011111111110010000011111111101111111111101000011111111100111111111111000011111111110001111011111111111000000000000111111110001111111111100000001111111101001110111111111110011111110000000000000000111111111001111111000000000000010001111111100011111100000000000000010001110011000010100000000000000111111111110001111101111111111111111110111111111111111011000000000111100010000000000000000000000011111111100011111010010011011110001111100011010000000000000000111110110101000000000;
back_3[212] = 640'b0000000100001111111111100000001111111111000011110000000001000001011100111111100000000001110111111111111110000111111111000000000110000011111001111111111011111111110001011111111110010000111111111100111111111001000111111111100111111111111000011111111110001111011111111111011111111111111100100001111111111110000000100011100001110111111111110011111111000000000000001111111111001111111000000000000010001111111100011111100000000000000010011110011000010000000000000000111111111111001111111111111111111111110111111111111111011000000001111110110000000000000000000000011111111110011110100000011111110001111000000000000000000000000001100101101101001001;
back_3[213] = 640'b0000000001001011111111110000011111111111000011110010000000000001101111111110101000111111110111111111100001111111111111111111111110000001111101111111111011111111110001111111111110010000111111111100111111111001000111111111100101111111111000011111111110011111011111111111000000001111111100100001111111111100000000111111000011110111111111110011111111000000000000001111111111001111111000000000000010011111111100011111100000000000000010011110001001010100000000000000111111111111001111111111111111111111110011111111111111011000000001111110110000000000000000000000011111111110011100000100010111110001110000001001000000000000000000110011000000000000;
back_3[214] = 640'b0011000000011111111111101111100111111100000110001000010000110111111111110010011100111111111111111111111110000111111111111111111100000011111101111111111011111111111001101111111110010000111111111100111111111001000111111111100101111111111100011111111110011111011111111111000000001011000000000001111111111110011111111111000011110111111111111011111111000000000000001111111111001111111000000000000110001111111000011111100000000000001110011110001001010000000000000000111111111111001111111111111111111111110011111111111111101000000000111110100000000000000000000000011111111110011100001100001011110011000000000001100000000000000001111110101100000000;
back_3[215] = 640'b0000110101001110011111111100001111110000011101100110000110100001000110100011011100000011111111111111111001100000011011111111100000000100111101111111111011111111111001101111111110010000111111111100111111111001000111111111100101110111111100011111111110011111111111111111000000001111111111111101111111111110111111111001000111110111111111111011111111000000000000001111111111001111111000000000001000001111111000011111100000000000011110011110001001010000000000000000111111111111001111111111111111111111110011111111111111111000000000001110000000000000000000000000011111111110011110001000001011100000000000000000100000000000111000001101111110110100;
back_3[216] = 640'b0000111001111111111111111110001100010000011111010111111111101111001101101001010010000001111111111111111011100000000000000000000000000000111101111111111011111111111001101111111110010000111111111110111111111001000111111111100101110111111100011111111110011111111111011111000111111111111111111101111111111110111111111111000111110111111111111011111110000000000000001111111111001111111000000000001000011111111100011111100000000111111100011110001001010000000000000000111111111111001111111111111111111111110001000011111111110100000000111110000000000000000000000000001111111110011111100001011111100000000000000000000000000011110100011111000000110101;
back_3[217] = 640'b0000101111111111111111111111111110000000010011001011100111111110001100111111010100000000111111111111111111110000000000000000000000000011110101111111111011111111100001101111111110010000111111111110111111111001000111111111100101111111111100011111111110011111111111011111001001111111111111111101111111111110111111111111101111110111111111111011111111000000000000101111111111001111111000000000001110011111111100011111110011111111111100011110001001010010000000000000111111111111001111111111111111111111111111000001000000000100000001111110000000000000000000000010101111111110011101000001111010000000001000000000000101011000100110111010100110101000;
back_3[218] = 640'b0000101111001111111111111111111001000000100100001100000000001111110111110111010000010000111111111111101111110000000000000000000000000110110111111111111011111111100011101111111110010000111111111110111111111001000111111111100101111111111100011111111110011110111100011111001111111111111111111101111111111110111111111101111111110111111111111011111111000000000011101111111110001111111000000001111100011111111000011111110011111111111100011110011001010000000000000000111111111111001111111111111111111111111101111110001110001000000000111100000000000000000000000000011111111110000011111100100000000000000110000100100000000110000000111111000101011111;
back_3[219] = 640'b0000100101111111111111111111111100000000001000100000000000001010111111111110010000100000111111111111011111100000000000000000000000000001110111111111111011111111101011101111111110010000111111111111111111111001000111111111101101111111111101111111111110011110111100011111011111111111111111111111111111111110001111110001111111110111111111111011111111000000000001001111111110001111111000111111111100011111111000011111110111111111111100011110011001010000000000000000111111111111001111111111111111111111111111111111111110010000000000000000000000000000000000000000001111111110110000111011011000000000000000000000010000000011000011101111000000001110;
back_3[220] = 640'b0001001100111111111111111111110100000000011101001110000000000010011111011111111110110000011111111111001111110000000000000000000000000001110111111111111011111111111111101111111110010000111111111111111111111001000111111111101101111111111000011111111110011110111111011111011111111111111110000001111111111110000000110001111111110111111111111011111111100000000011001111111111001111111000111111111100011111110000011111111111111111111100011110011001010000000000000000111111111111001111111111111111111111111111111111111111011011110000000100000000000000000000001001111111111110000111110101111100000000000000000000000000011100100000101101011110100010;
back_3[221] = 640'b0111001000000111111111111111110000000001110101111100000000000010000111001101101111110000010011111111000011000000000111111111111100000001010111111111111011111111111111101111111110010000111111111111111111111001110111111111101101111111111000011111111110011110011111111111001111111111100000000011111111111110000000010001111111110111111111111011111111100011111111001111111111001111111101111111111100011111111000011111111111111111111100011110011000010000000000000000111111111111001111111111111111111111111111111111111111101110110000011100000000000000000011011111111111111110011111100110001010000000000000000000000000010110110001010011100010111100;
back_3[222] = 640'b0010000011000111111111111101100000000100001111111111010000001010000001011101000111111000000011111110001000011111111111111111111100000000010011111111111011111111111111101111111110000000111111111111111111111001000111111111101101111111111010011111111110011110111111111111001111111110000000000011111111111110000000000001111111100111111111110001111111100011111111011111111110001111111111111111111100011111111000011111111111111111111100011110011001010000000000000000111111111111001111111111111111111111111111111111111111110011110000000110000000000000000000111111111111111110011111001101110010000000000000000000000000000000001000101010100010000110;
back_3[223] = 640'b0010000001001011110111111111100001000011001000111111101111000110001000000100100110011100000000111110000000000001000000000000000000000000010011111111111001111111111111101111111110010000111111111111111111111001000111111111101101111111111110011111111110011110111111111111001111100000000000000011111111111110000000000001111111110111111111111011111111100111111111001111111111001111111111111111111100011111111000011111111111111111111100011110011001110010000000000000111111111111001111111111111111111111111111100100111111100111110000001011000000000000000001100111111111111110011111101101110000000000000000000000001100010011100000100010000100111100;
back_3[224] = 640'b0000000000011001110111110000010000000000111001111111111100000111000110000000001110111011000000000000001111000000000000000000000000000000010011111111111001111111111111111111111110010000111111111111111111111001000111111111101111111111111110011111111110011110011111111111000111000000000000000011111111111110111111111001111111110111111111111011111111101111111110001111111111001111111111111111111100011111111000011111111111111111111100011110011000110010000000000000111111111111001111111111111111111111111111111111011001111111110000011111100000000000000011011111111111111110011111111110101000000000000000001000000001101111110000011100110001001001;
back_3[225] = 640'b0000010100000000001100110100000010100011101110100000010111111101000000101000001111111011000000000000001110000000000000000000000000000000010011111111111001111111111111111111111110000000111111111111111111111001000111111111100111111111111110111111111110111110011111111111000110000000000000000011111111111110100000000000111111110111111111111011111111101111111111001111111111001111111111111111111100011111111000011111111111111111111100011110011000110010000000000000111101111111001111111011111111111111111111110111000000111111110000000111100000000000000011111111111111111110011111110110011000000000000000110101111010110001000011111100100001100001;
back_3[226] = 640'b1010000000000000000110100000000100010011101100010110011110000001000110010001000110111111011110000001001110000000000000000000000000000000010011111111111001111111111111111111111110000001111111111101111111111001000111111111100111111111111111111111111110111110011111111111000111111111111111100011111111111110000000000010111111100111111111111011111111111111111111001111111111001111111111111111111100011111111000011111111111111111111100011110011000010010000000000000111101111111001111111111111111111111111111101111111111011111110000000111100000000000000011111111111111111110001110000000101000000000000111110011111110000000000011110001100001000000;
back_3[227] = 640'b0010000000000000001110000000001000110111111000000010011100001100000100000001001100111111111101000011001110000000000000000000011000000000010011111111111011111111111111011111111110000001111111111101111111111001001111111111101111111111111101111111111110111110111111111111000111111101000000000011111111111110000000000111111111000111111111111011111111100111111111001111111111001111111111111111111100011111111100001011111111111111111100011110011000010010000000000000111101111111001111111111111111111111111111100011110110011111110000011111111100001000101111111111111111111110000001111100100000000100001100001101101110000000100010001110110111000111;
back_3[228] = 640'b1000000000000000000100000000001000111011010010000010001111101000001000010000001101111111111111100110010100000000000000000000000000000000011011111111111001111111111111011111111110000001111111111101111111111001111111111111101111111111111001111111111110011110111111111111000100000000000000000011111111111110000000101111111111000111111111110001111111100011111111001111111110001111111111111111111110011111111111000000111111111111111100011110011000010010000000000000111111111111111111001111111111111111111111100011110110111111110000011111111111111100011111111111111111111110011111111110000000000010000000011011000000101000000011101101101100000101;
back_3[229] = 640'b1100000000000000000000000000001100111011111101100011110101101010000000000001000111111111111011111011110000000000000000000000000000000000011011111111110001111111111111011111111110000001111111111101111111111001111111111111101011111111111001111111111110111110111111111111000100000000000000000111111111111110000000001111111111100111111111111011111111110011111111001111111110001111111111111111111110011111111111000000011111111111111100011110011000000010000000000000111111111111111111100000011111111111111111110011111110111111110000011111111111111111001111111111111111111110011111100001100000000100010000001111110000000010000010011000100010100001;
back_3[230] = 640'b0100000000000000000000000000001000001111110001111100100011010110000000100001100110111111111111111111100000000000000000000001111100000000011011111111110000111111111111011111111111011111111111111101111111111001111111111111111011111111111001111111111110111110111111111111011100000000000110000011111111111110000000001111111111000111111111111011111111101111111111001111111110001111111111111111111110011111111111101110011111111111111100011110011000000010000000000000111101111111111111100000001111111111111111100110101100111111010000011111111111111111100111111111111111111110111111000001100111000010000001110000100100001000011011011100101000101001;
back_3[231] = 640'b0100000000000000000000000000000001011111111111111111011010000110000000000000001111111111111111111111101000000000000000000001110000000001111011111111110001111111111111011111111111011111111111111101111111111001111111111111111011111111111001111111111110111110111111111111111100000000000000000011111111111110000000001001111110000111111111111011111111101111111111001111111110001111111111111111111100011111111111111111001111111111111100011110011000100010000000000000011101111111111111110011011111111111111111100111001100111111010000011111111111111101111111111111111111111110110000000110000000000000001010100000000000000100000010001001100110111110;
back_3[232] = 640'b0101000000000000000000000000000110000011110010000001011000100100100000000000010110011111111110010011111100000000000000000011111100000000111011111111110011111111111111011111111110011111111111111101111111111101111111111111111011111111111001111111111110111110111111111111011100000000110000000011111111111111111100000111111110001111111111111011111111101111111111001111111110001111111111111111111110001111111111110010101111111111111100011110011000100010000000000000111101111111110111011000100111111111111111101111000000111111000000011111111111111000011111111111111111111111000010000000000000000111110011000000000000000010000010001101000010010011;
back_3[233] = 640'b1000000000000000000000000000111011111101010111100010001110000000010000010010111100011111111111011111110100000000000000000011010100000000101011111111110011111111111111011111111110011111111111111101111111111101111111111111111011111111111001111111111100111110111111111111011100000011111111111101111111111111000100000101111100001111111111111011111111101111111111001111111110001111111111111111111110011111111110101101111110111111111100001110011000100010000000000000011101111111110111000001111111111111111111111111011100111111000000001111111100000000000000000011111111111111111000000000000000000111011100000000001000000000100100100010111010011101;
back_3[234] = 640'b1000000111000001101100101111100011111010100100010110100001011000000000000110111000010001001101111101110000000000000000000011110100000000101111111111110001111111111111011111111110011111111111111101111111111000111111111111111011111111111011111111111100111110111111111111011101000010000000000101111111111111000100001111111100001111111111111001111111101111111111001111111110001111111111111111111110001111111110100010011110111111111100001110011000100010000000000000011101111111110111100010010011111111111111111111010101111111000000011111111100000000000000000011111111111110100000000000000000000000010000000000000000000000110000100101001010101001;
back_3[235] = 640'b0110001111000011100111001010001111101001011011111010100111011111111100000001110110000001111100111111111000000000000000000011110100000000101111111111110001111111111111011111111110011111111111111101111111111001111111111111111011111111111011111111111100111110111111111111001100000110000000000101111111111011000100001111111100001111111111111001111111101111111110001111111110001111111111111111111110000111111011100001110001111111111100011110011000000010000000000000011101111111110111100011111101111111111111110111010101011111000000011111111111000000000000000011111111111100100000000000000000000001000000000000000000000000100000011100010110111100;
back_3[236] = 640'b0011001110001111001010011000100001111001001101111101100101011101111110000011110011000000111110111110101000000000000000000011110100000000101111111111110001111111111111111111111111011111111111111101111111111101111111111111111011111111111011111111111100111110111111111111001100000110000000000101111111111011000100001111111100001111111111111001111111101111111110001111111110001111111111111111111100000111111101000100101111111111111110011111011000000010000000000000011101111111110111000001101101111111111111110010100011011111100000011111111100000000000000100111111111110110000000000000000000000000000000001000000000000000011000111111000000001010;
back_3[237] = 640'b0001111100111001110111100100001000110000101111111010000100110110011011110011111001000011111111111000111000000000000000000011110100000000101111111111110011111111111111011111111110011111111111111101111111111001111111111111111011111111111011111111111100111110111111111111011000000110000000000101111111111001000100100111111100001111111111111011111111101111111110001111111110001111111111111111111100000111111000000001110001111111111110011111011000000010000000000000011100111111110111000111100011111111111111100010010011011111100000111111111111100000000111110111111111111011111111110011111110000000000000000001100000000000001000110110000000000011;
back_3[238] = 640'b0001111111011111111111001000000011011111111111111011011110010011011000000011100110001110011111101101111000000000000000000111110100000000100111111111110011111111111111111111111110011111111111111101111111111001111111111111111011111111111011111111111110111110111111111111001000000110000000000100111111111001000101100110110000001111111111111001111111101111111110001111111110001111111111111111111100001111110111100000001100111111111110001111011000000010000000000000011101111111110111011000000111111111111111100011001010111111100000111111111111111000011111111111111111110111111111100011011101000000001000000000000000000100001100001101000000100000;
back_3[239] = 640'b1001110110011111111011101000000000111000010110011011011111010001110000001110001110001101011111111110110000000000000000001111110100000000100111111111110001111111111111111111111110011111111111111111111111111001111111111111111011111111110011111111111100111110111111111111000000001110000000000100111111111001000100000110110000001111111111111000011111101111111110001111111110001111111111111111111100011111110111000000000111111111111110001111011000000010000000000000011101111111110111010010000111111111111111100000101001101111100000111111111111110000001111111111111111111001111111110000000000000000000001001000110000000000000100010010000000000000;
back_3[240] = 640'b0000011111100001111111111000000001110100100001110001000110001000011101000000100100000111111111111110110000000000000000011111110100000000100111111111110001111111111111111111111110011111111111111111111111111001111111111111111011111111111011111111111100111110111111111111000001111110000000000100111111111001000100000110110000001111111111111000001111101111111110001111111111001111111111111111111110011111111011111111011111111111111110000111011000000010000000000000011101111111110111000100000111111111011111110001001001101110000001111111111111111111111111111111111111111100100000000000000000000010000000101100001000001110000110100000001000001110;
back_3[241] = 640'b1011100010000100001010110000000001111011011011010100001110000000001100000000000001110111111111111100110000000000000000011111110100000000100111111111110001111111111110111111111110011111111111111111111111111001111111111111011011111111111011111111111100111110111111111111000000001110000000000100111111111001000100000100110000001111111111111000001111001111111110011111111111001111111111111111111110010111110011100011010011111111111110000111011000000010000000000000011100111111110111101001000111111110111011000000100011101110000001111111111111111111101101111111111111000000000000000000000000000000001000001000000000000011011110010100000100011100;
back_3[242] = 640'b0010011111111000100010011000100010110000110011101111101111000000001111101000000001011111111111111000110000000000000000111111110100000000100111111111100011111111111110111111111110011111111111111111111111111001111111111111011011111111110011111111111000111110111111111111000001001110000000000100111111111001000100000100110100001111111111111010001111001111111110011111111110001111111111111111111110001111110000100000001111111111111110001111011000000010000000000000011000011111110111111100001111111100001000000111001111011111101111111111111111110000000000111111111100000000000000000000000000111000011110101000000000000000000110110010000000001110;
back_3[243] = 640'b0100111000110011111100011000000110010000110011110000101110000000000011110000000111001111111110111011100000000000000011111111110000000000110111111111100011111111111110111111111110111111111111111111111111111001111111111111011011111111110011111111111000111110111111111111000000001100000000000100111111111001000100000110111000001111111111110000011110001111111110011111111111001111111111111111111110001111100000100000111111111111111110001111011000000010000000000000011000111111110111111000000111111000011001100011010010111001111000111111111111100000000000000111110000000111111111111111111111111111111111000000000000000000000001100010000000011101;
back_3[244] = 640'b0011111000011111110100000001111011111111111011001000100010000000000011000000100110011111111101111011100000000000000001111111110000000000010111111111100011111111111110111111111110111111111111111111111111111001111111111111011011111111110011111111111000111101111111111110000001001100000000000100111111111001000100000110111101101111111111110011011100001111111111011111111111001111111111111111111110000111110000110001111111111111111110000111011000000010000000000000001100011111110111111110011111110100110001111101111101000111100001111111111111110000000000000111100111111111111111111111111111111111111111110000000000000000011000000000000000001101;
back_3[245] = 640'b0011100010110000001101000000111011110011110111011001000001000000000001110000111111001111110101100100010000000000000011111111110000000000010111111111100011111111111110111111111110111111111111111011111111110001111111111111011011111111110011100111111101111101111111111111000001001100000000000100111111111000000100000100111001101111111111110000011100000111111111001111111111001111111111111111111110000111110000000010011111111111111110000111001000000010000000000000011100011111110111111010111111111001010010000010011110100111000011011111111111111000000000010111101111111111111111111111111111111110010111110000000000000000100000001001000000001111;
back_3[246] = 640'b1010111110011101101000100000110011110110001000011001000000110000000011110000001110111110110110100101010000000000000111111111111000000000010111111111100011111111111110111111111110111111111111111011111111110011111111111111111011111111110011000111111000111101111111111110000000001100000000000100111111111000000100000100111100101111111111110010111100000111111111001111111111000111111111111111111110000111110001001100111110001111111110001111001100000010000000000000011000000111110111111101011111101100010011000001111101000001111110111111111111111111111111101111100111111111111111111111111111111110011111000000000000000000100000001000000000011101;
back_3[247] = 640'b0010110011010000010100100111100111111100100000010010000110110011000111010000011100111111100110001101110000000000001111111111111000000000010111111111100011111111111110111111111110111111111111111011111111110011111111111111111111111111110011000111111100111100111111111110000000001100000000000100111111111000000101100100111111101111111111110010011010000111111111001111111110000111111111100001001110001111110011110010010110111111111110001111001100000010000000000000011100001111110111111100011111011100000101000000001111111111111100011111111100000000000000111111000100000000000000011111111111100001011111000000000000000000001011000000001010110110;
back_3[248] = 640'b1000011011110000110001110111111111111011110011100101000011110000000011001100011100111111101110001101100000000001111111111111111000000000010111111111100111111111111110111111111100111111111111111011111111110011111111111111111111111111110011111111111000111100111111111110000001111100000000000100111111110000000100000100111111101111111111100010011111000011111111001111111110000111111111100000011110001111110000110000111110111111000000001111001100000010000000000000001100001111111111111101111111011100000010100010000110010111110110110110000000100010010010001010100101100000000000011111111000000001001110000001000000000000000011100000010001000000;
back_3[249] = 640'b0001111100010000101010111100111101111100111001011011111111110000000110001111111110111111111101110001110000000011111111111111111000000000011111111111100111111111111110111111111110111111111111111011111111110011111111111111110111111111110011100001111001111101111111111110000001111100000000000100111111111000000100000100111111101111111111110010000111000000000001001111111110000111111111100001111110011111010000011011011111110000001110011111001100000011000000000000000000011111111111110001001111101110101011101011000010011011000100111000111000000001011110001100000010010000000000111111111111111111111111000000000000000000000010001100000001011001;
back_3[250] = 640'b1111111110100101111111000001011011110111101000011011010111110010001110101111111110111111111101110011000000010001111111111111111000000000011111111111100111111111111110111111111100111111111111111011111111110011111111111111110111111111110011000000100101111101111111111110000001011100000000000100111111111000000100000100111111101111111111110010000111000000001111011111111110000111111111100001111100011111110000011110101110110000111110011111001100000011000000000000001000000111111111110011011111111011010010110000000010101000100000001111111111111111111111110110100011100000000001111111111111111111111111000000010000000001001100100000010000001100;
back_3[251] = 640'b1111111110101100000100110001001011101001100010100000000110001110001100010100011110111111111011001010000000111111111111111111111000000000010111111111000111111111111110111111111100111111111111111011111111110011111111111111110111111111110011000011111101111101111111111110000000011100000000000100111111111000000100000110111111001111111111100011000111000000000111001111111110000111111111101111111000001111110000000000011111110000111110011111001100000011000000000000000000000111111111100111011111111011010110111111110101100000000101111110010111110000001010011100000001100000000011111111111111111111111110000000000000000000011111000001111000000000;
back_3[252] = 640'b1111111111101000011011000010100111111111110000111110000100000000101011100111110111111110111101000100000001111111111111111111111000000000011111111111100111111111111110111111111100111111111111111011111111110011111111111111110111111111110011100001111101111101111111111110000000011100000000000100111111111000000100001110111111101111111111100011000111000000000111011111111110000111111111101111100000111111111000100011110010110000111111111111001100000010000000000000000000001111111111100111011111111011010100000000011111101000011100111000000111111000011110001100100010100000000000000000000000001111110110000000000000000000000011000011101000010010;
back_3[253] = 640'b1111111111110001001000000111100001111110100101100000000101111100101101010111111011011110011100011100101001101111111111111111101000000000011111111111100111111111111110111111111100111111111111111011111111110011111111111111110111111111110011100000001101111101111111111110000000011100000000000100111111110000000100001100111111101111111111110011001111001000001110001111111110000111111111101111100000111111110101100000101000110000111111111111001100000011000000000000000000000111111111101110111111111011100001110100000000001011000100111100001111111100111100011011100010100000000000000110110011111111111100000010000000000000000000001011010000000000;
back_3[254] = 640'b1111111111110000101110100101100000011001111101110111101110111110001011000010011111011110001110001011000111111111111111111111111000000000001111111111100111111111111111111111111100111111111111111011111111110011111111111111110111111111110011110000001101111101111111111110000000011100000000000100111111110000000100001100111111101111111111110011011111101000001110001111111110000111111111101111100000111111110111110000110010110000111111111111001100000011000000000000000000000111111111101110111111111101110001101111110111011010001100011111111111111111111110001111100010000000000011111100000000000111111100000000000000000000000001011000001000000110;
back_3[255] = 640'b1111111000101010011000001101001000011001001100000111110011111110100000111010001111011111101011100101001100111111111111111111110000000000001111111111000111111111111111111111111100111111111111111011111111100011111111111111110111111111100100110000011101111101111111111110000010011100000000000100111111110000000100000100111111101111111111110011111111101000011110001111111110000111111111101111100000111111111100101100010010110000111111111111001100000011000000000000000000000111111111100110111111111111110000111111010101110000010001011111111111111111001010111111100010000100000000000000000000000011111100000000000000000000000001001000110000000111;
back_3[256] = 640'b1111111000100011110100100111001010110001110001010000010011001111000100001100111111101011111010110010100011111111111111111111110000000000001111111111100111111111111111111111111100111111111111111011111111110010011111111111110111111111100100111000011111111101111111111110000000011100000000000100111111110000000101100100111111101111111111110011111111101000011110001111111110000011111111101111100000111111111110011110000111110000111111111111001100000011000000000000000000000111111111101110111111111111111000101111001111000101101010101001110001100110001101011111110011100000010000000000000000000111101100000000000000100100000000101000001100101111;
back_3[257] = 640'b1111111001011000010110001111001100000010011110100000100010111000000000011000111111001011011111111110110111111111111111111111110000000000001111111111000111111111111111111111111001111111111111111011111111100000011111111111110111111111100100111000111111111101111111111110000011111100000000000100111111110000000101101100111111101111111111110011111111111100011110001111111110000011111111101111100000111111111110000010001111110000111111111111001100001011000000000000000000000111111111111110111111111110101100111000100001010101101111000100000001100001101000111111110010010000010000000000001000001111011100000000000000000000000000000000011111001111;
back_3[258] = 640'b0000110010101001000101100100111000000010011111000011111111111001110001101001001110000101000011111101001111111111111111111111110000000000101111111111001111111111111111111111111001000011111111111011111111100010011111111111110111111111100101111000111111111101111111111110000011111100000000000100111111110000000100001100111111101111111111110011111111111100011110001111111110000011111111101111100000111111111111000101111111110000111111111111001100001011000000000000000000000011111111110110111111111110111110110001010011001111110010101111101110011110010111000111111001100100000000000000001000001111011100000000000000000000011111100001000000011110;
back_3[259] = 640'b1110000100100000100100000010010010001111101111010000111111111001111000000101011110000000000111001100011111111111111111111111110000000000101111111111001111111111111101111111111001100011111111111111111111100010011111111111110111111111100101111101111111111101111111111110000011111100000000000100111111110000000100000100111111101111111111110011111111111100011110011111111110000011111111100111100000111111111111010111001111110000000110111111001100001011000000000000000000000001111111110110111111111110010100010100000100000011111100011111111111111010111111000111110001101111000000011111111111111111001100000000000000000001110011100010000101100011;
back_3[260] = 640'b0000111110001110010100011010011101110001010001000001011111001110111110001110000001010000000001111110001111111111111111111111110000000000101111111111001111111111111101111111111001100011111111111111111111100000011111111111110111111111100101111111111111111101111111111110000010011100000000000100111111110000000100001100111111101111111111110011111111101000011110001111111111000011111111101111100000111111111111101011101011111111111110111111001100001001000000000000000000000001111111110110111111111111010101000101000101011011110001110111111111110100111111010011111001111111001111111111111111111111011000000000000000000111110111000000001111110011;
back_3[261] = 640'b1010001000001011000010010000110100011110000010110000100010110110111100000011000101111001000000010110101111111111111111111111110000000000101111111111001111111111111101111111111001000011111111111111111111100000011111111111110111111111100101111111111111111101111111111110000000001100000000000100111111110000000100001100111111101111111111110011111111111000011110001111111111000011111111101111111100111111111111001010010011111110000001111111001100001011000000000000000000000001111111110110111111111111101111011100100110110101111011111111111111110101111111110011111001111111111111111100111111111111111100000000000110100101101110000000000000000011;
back_3[262] = 640'b0000011101011100001010000010111010011000101110000011010010111111110101011000110100111110000000100111011111111111111111111111110000000000101111111111001111111111111101111111111001000011111111111111111111100000011111111111110111111111100101111111111111111101111111111110000000001100000000000100111111110000000100001100111111101111111111110011111111101000001111001111111111000111111111100001111110111111111110001011001101110000111111111111001100001011000000000000000000000001111111110110111111111111111111110101100100111011011000111111111111110101111110010011111001011111111111111110111111111111100000000000000100010010001110000000000000000001;
back_3[263] = 640'b1110111011110000101110011110011001000000011110111001111111111111111110001011001100111101101100000001001111111111111111110111110000000000101111111111001111111111111101111111111001000111111111111111111111100111111111111111110111111111100101111111111111111101111111111110000000011100000000000100111111110000000100001101111111100111111111110011111111101000001111011111111111000111111111101011111100111111111100011011000100110100111111111111001100001011000000000000000000000001111111110110111111111111100101100111110111101011100000011111111111100001111100011101110001111111110111011011111111111111110000011000000001011001110000000000000000000000;
back_3[264] = 640'b0011111010110000110100011101101000110000011010110001001101111100111011110100110011110110111101001011001111111111111000000000010000000000101111111111001111111111111101111111111001010111111111111111111111100100011111111111110111111111100101111111111111111101111111111110000000011100000000000000111111110000000100001101111111101111111111110011111111101000001111001111111111000111111111101111100000111111111111111011111111110100111111111111001100001001000000000000000000000001111011110110111111111111111011111100110010010010100010011111111111101001111101001111110001111111111011110111111111101111100111000001111000011001100000010000000000000000;
back_3[265] = 640'b0000111111110100110000110111110001110110011101011001101001111110111000000000100000000100011011001011011111111111111100000000010000000000101111111111001111111111111101111111111001000111111111111111111111100100011111111111110111111111100101111111111111111101111111111110000000011100000000000100111111110010000101101111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111111111100011111111111111111111111000100001011000000000000000000000000111011110110111101111111001110011111111111001011110010011011111101100000111111100111110001111111111111111111111111110100100100000100000001011001100011000000000100000010;
back_3[266] = 640'b0001010111010101101100011010000011100000101011110001111111111110110000001010000101100111011101011011011111111111111100000000010000000000101111111111001111111111111101111111110001000111111111110111111111100100011111111111110111111111100101111111111111111101111111111110000010011100000000000000111111110010000111111111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111111111000000011110111111111111111000100001001000000000000000000000000111011110101111010010011011010001100111110111111100110001101011111011100011111011111110001111111111111111111111111111000000000010011000001111011111011110010001000001100;
back_3[267] = 640'b0001110110010110111111110011101100100011000011010000000110111111110100111001100001111000000100111001011111111111111110000000010000000000101111111110001111111111111101111111110001000111111111110111111111100100011111111111110111111111000101111111111111111101111111111110000011111100000000000001111111110010000100101101111111101111111111110011111111111000011110011111111111000111111111100111000000111111111111111000000001110111111111111111000100001001000000000000000000000000111011110101001011100110110110011000111110010110100000011111111111111010001111100011000001111111111111111111111111110000000010011111011101111111101110110000000101110110;
back_3[268] = 640'b0000000100010000001111100000101101000001110011000111101011011111111110100010111111011100001100100110011111111111111111000000010000000000101111111110001111111111111101111111110000000111111111110111111111100100011111111111110111111111000101111111111111111101111111111100000011111100000000000001111111110010000100001111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111111001001100101110111111111111111000100101001000000000000000000000000011011110001010101011000000001010000100101110111110000111111111111110010100110110111001000111111111111111011111111111100011110001110011101101111100111110000001011011010;
back_3[269] = 640'b0001001000111000111000101011000000001001110000001101111011001110010001110000110101001010001110111110011111111111111111000001010000000000101111111110001111111111111101111111110000000111111111110111111111000100111111111111110111111111000101111111111111111101111111111100000010011000000000000000111111110010000110111111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111110001001101101110111111111111111000100001001000000000000000000000000011011000110110110000100010111011100110110101111011100011111011111110101100010000111000001111111111111111111111111111100000001001000101101101110111110111100000101100000;
back_3[270] = 640'b1110000000011000011000101110111010111111111000101110111110100000110111100111000110011010100001010011011111111111111110000011110000000000011111111110001111111111111101111111110000000111111111110111111111100100111111111111110111111111000101111111111111111101111111111100000010111000000000000001111111110010000110111111111111101111111111110011111111111000111100011111111111000111111111101111000000111111111110001000101001110111111111111111000100001001000000000000000000000000010011011000100100111110010011101111011111110000011000001111111111110100010000011111100001110111111111111111111111111110010000010010111001111111110001110100110110110111;
back_3[271] = 640'b1100001000010011001110001111011011111111111101000101110101110011101001001010100110101111110100001101011111111111111110000011110000000000011111111110011111111111111101111111110000000111111111110111111111000100111111111111110111111111000101111111111111111100111111111000000010111000000000000001111111110010000110011111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111110000100100001110100111111111111000100001001000000000000000000000000000111010001100111111111111111111101111111000110011100101111111111110101001000011011110011101111111111111011111111111100110001000111111111011111100001110111011001101111;
back_3[272] = 640'b1101100000010001111010001100110001111111111000100011110001001001111100011010010101111111001100100000111111111111111110001111110000000000011111111110001111111111111101111111110010000111111111110111111111000100111111111111110111111111000101111111111111111100111111111100000111111000000000000000111111110010000111111111111111101111111111110011111111111000011110011111111111000111111111101111000000111111111110110100100001110100111111111111000100011001000000000000000000000000000111000101111111111111100101111111011011000110000100000111111010111101000100111111100001111111111111111111111111111100100000100001110101111111111111111111010000000010;
back_3[273] = 640'b1100110000110000111100011101011000011111000111000001010000000101000110011100000101110101000111100111011111111111111111000000010000000000011111111110011111111111111101111111100010000111111111110111111111000100111111111111110111111111000111111111111111111100111111111100000111111000000000000000111111110010000111111111111111101111111111110011111111101000011110011111111111000111111111100111000000011111111110110111110011110100111111111111001100011001000000000000000000000000000001101111110000000111000111111111011010000011011111111011110011111110000101111111000000001111111110111111111111111111110000100111111111111101111110000100000000001000;
back_3[274] = 640'b0010011011011111111001110000101000001111111111000000000001100101010101111000011111111110001111101000111111111111111111001000010000000000011111111110011111111111111101111111110010000111111111110111111110000111111111111111110111111110000111111111111111111100111111111000011111111000000000000000111111110010000111111111111111101111111111110011111111101000111110011111111111000111111111100111100000011111111110011111011001110110111111111111001100011001000000000000000000000000101101101111111100000000001000111111011100000011011000111000111001111110001111111111100000001111111111111101111111111110111100000110111111111100110111000100000000010011;
back_3[275] = 640'b1110001111101101100101110011000000000111111111000010000001110101100001111101101011011011110010000010111111111111111111001100010000000001011111111100011111111111111101111111100010000111111111110111111111000100111111111111110111111111000001111111111111111100111111111000000111111000000000000000111111110010000111111111111111101111111111110011111111101000011110111111111111001111111111100011111110011111111101001111001101110011000010111111001100001001000000000000000000000000110110011001011110000000001000111110111100001010100000111000000000000011111111111111100001111111111111111111111111111001111111111111111111010011011110111000000010011011;
back_3[276] = 640'b1001011111101110000001000000011000000111111111100000000011111100111000111110001000111011101100100000111111111111111111001100011100000001011111111100011111111111111101111111100010000111111111110111111111000100111111111111110111111111000001111111111111111100111111111000000011111000000000000000111111110010000111111111111111101111111111110011111111101000011110011111111111001111111111100000010010101111111001111111011011011111111110111111001100001001000000000000000000000001101001000110010011000000001000011111000111010000000000011100011000000111111111111111110000111111111111111111111111111110110111111111111111000111111110001100000001110101;
back_3[277] = 640'b1111110111101011101001010000000110011011111111100110001011100010011010111000011100011101100100000001111111111111111111011100011100000001011111111100011111111111111101111111100010000111111111110111111110000100111111111111110111111110000001111111111111111100111111111000000111111000000000000001111111110010000111111111111111101111111111110011111111101000011110011111111111001111111111000000111110000000000000000111111100000001101110111111001100001001000000000000000000000011101110011001100001000001001000110001110011010111000001111110000000001011011111111111000100111111111111111111111111111010101111111111101111110111110100001100000001100111;
back_3[278] = 640'b0001110000011000111011000001100111001101111111111111110011111000011011111111011100111101000000011110111111111111111111011100011100000001011111101000011111111111111101111111100010000111111111110111111110000100111111111111110111111110000001111111111111111100111111111000000111111000000000000001111111110010000111111111111111101111111111110011111111101000011110011111111111001111111111000000010000000000000000000000000000000000001110111101001100001001000000000000000000000011110100110000000000100001000001001100000001100011100000000011101111110111111111111111000000001111111111111111011111111111111111111111111111011110010000001111000110000111;
back_3[279] = 640'b1100111000000000110110100010010101010000111111111111110011110100001011111111111100011100000100000111111111111111111111111100011000000001011110100000011111111111111101111111100010000111111111110111111110000100111111111111110011111110000001111111111111111101111111111000000111111000000000000001111111110010000111111111111111101111111111100011111111100000011110011111111111001111111111000000111000000000000000000000000000011011100000111100001100001001000000000000000000001111101100000000000000000000000011100111010001001011000000000111010111010000111101111110000000001111111111111111111111111111001111111111111101110001110000111111111101001111;
back_3[280] = 640'b1111111100000000010001100001010110000000001111110011100110000110001011111111110100001100000100000000111111111111111111111100010000000001001110100000011111111111111101111111100010000111111111110111111110000000111111111111110011111110000001111111111111111100111111111000010111111000000000000001111111110010000111111111111111101111111111110011111111100000011110011111111111001111111111000000111000000000000000000000000000000010011110110100001100001001000000000000000000001101100110000000000000000000100111110000100011110101000000000000001011010110111001110010000000001111111111111111111111111101111011100110011011111000000001111111001111100111;
back_3[281] = 640'b1110011111110000101000111000111110111010001111110101100111011100110111111111111100010100000100110000111111111111111111111100011100000001000110100110011111111111111101111111100010000111111111110111111110001000111111111111110011111110001001111111111111111101111111111000011100111000000000000000111111110010000111111111111111101111111111100011111111100000001110011111111111001111111111000000111111110001100000100000000000000010000011001000001100000001000000000000000000001101010110000000000000000000000011111000110111010011100000000001100011111011110011000100001000011111111111111111111111101100111110111111011011101100000001111011111010011011;
back_3[282] = 640'b1101110011111111111110010010000101110100001111111001001111111000110111111111111000011110001101110000111111111111111111111100011100000001001110111110111111111111111001111111100010000111111111110111111110001000111111111111110011111100001001111111111111111101111111110001011100111000000000000000111111110010000111111111111111101111111111110011111111100000001110011111111111001111111111000000110011110011100000000000000000000101000010111000001100000001000000000000000000001101100000000000000000000000000000111100010101101010000000000000101010111011001010000000000000011111111111111111111111111110011111011000011110000101000000000001000000101001;
back_3[283] = 640'b1000010001111111111101010101001000011000111100001001000001111000011000111111110000001011101001111101111111111111111111111100111110000001000010111100111111111111111001111111100010000111111111110111111110001000111111111111110011111100001001111111111101111100111111110001111111100000000000000000111111110010000111111111111111101111111111100011111111000000001110011111111111001111111111000000110011000000000000000000000000001010010110010000001100000000000000000000000000011101000000000000000000000000000000001110101000111001000000000000111011010110000000000000000001111111111111111111111111110010001111000011111100000000000000000001001100101111;
back_3[284] = 640'b0000100100111111100000011101110101001010000110110000000011111110001101111111010011111101101011100000111111111111111111111100101100000001000010001000111111111111111001111111100010000111111111110111111110001000111111111111110011111100001001111111111111111100111111100001011111100000000000000000111111110010000111111111111111100111111111100111111111000000001110011111111110001111111111000000110011100000000000000000000000000101111110001011101100000000000000000000000001011111000000000000000000000000000000000011000101011011000000000001111110000111100010000000000011111111111111111111111111100110010010000001010000100000000000000011011001010011;
back_3[285] = 640'b0100010111111111001110001111110001111100000010001000111111100100010101111110110000000001101011100000111111111111111111111100110100000011000000111000111111111111111001111111000010000111111111110011111110001000111111111111100011111100001001111111111101111100111111000001111000000000000000000000111111110010000111111111111111101111111111100111111111000000001111011111111111001111111111000001111111100000000000000000000000001100110110010111110100000000000000000000000001111110100000000000000000000000000000000001100010011011110000000001100110001111110111100000000000111111111111111111111111111111010011100010100000000001100000000000100001000000;
back_3[286] = 640'b0011000001101111000110100111001000100110000000000111000010000100011111111111111100000001100001011001111111111111111111111100111110000011000000011000111111111111111001111111000010000111111111110111111110001000111111111111100011111100001001111111111101111100111111100001111001100000000000000000111111100010000111111111111111101111111111100111111111000000001111011111111111001111111111000000111111000000000000000000011111101000100000010000100100000100000000000000000001110010100000000000000000000000000000000000111101100111100000000011101000000111111100110000000000111111111111111111111111111100001001111110000000000001100000000000000010000001;
back_3[287] = 640'b1001010000111110011100100101100000111011110000010000011000001111110000011111011110011000011011011000011111111111111111111100111011100011000010100100111111111111111001111111000010000111111111110111111110001000111111111111100011111100001011111111111101111100111111000001111000000000000000000000111111100010000111111111111111101111111111100111111111000000000111011111111111001111111111111111111110000000000000000011001111110000111101000000111100010110000000000000000001110100000000000000000000000000000000000000011100101001000000000100111111100001111110111100000000111111111111111111111110111000010000011100000000000101100000000000001000011011;
back_3[288] = 640'b0111010001010011011001101100101000111110010000100011011111111111110000111111110110001110000011011000001111111111111111111100111101011011011001111011110111111111111001111111000010000111111111110111111110001000111111111111100011111100001011111111111101111100111110000011111000000000000000001000111111100010000111111111111111101111111111100111111111000001111110011111111111001111111111111111111110000000000000001111111111110000111111011011000100011110000000000000100111111111100000000000000000000000000000000000000001111001000000001000010010000011000111110111100000111111111111111111111101111100010010010000000000000011011100000000100010011110;
back_3[289] = 640'b0111001000111000000000101001010000111110001000000111111111111111100011111111111111001100100011011100001111111111111111001000111101110111110101111111111011111111111001111111000110001111111111110011111110001100111111111111100011111100001111111111111101111100111110000011111000000000000000001000111111100010000111111111111111101111111111100111111111000011111110011111111111001111111111111111111100000001001111111111001111110001111111100100000100111010000000000111111111110000110000000000000000000001110000000000000000000110000000010101101000111110000001100111000011111111111111111111111111111100011000000000000000000001001000000001000001101001;
back_3[290] = 640'b1111001110011000000010101011000001111000001000001111111111111111100000111111111111111110010111001010001111111000011110000000101110110001111111111101000011111011111001111110000111001111111111110111111100001111111111111111100011111100001111111111111111111100111100100011111000000000000000001001111111110010000111111111111111101111111111100011111111000011111110111111111111001111111111111111111000000111111111111111111111001011011111111010000000011111000000001101111111111110000000000000000000000000010000000000000000011000000000000001110111111111111111110001011100111111111111001110110111111000000000000000100000000000000000000000000011100000;
back_3[291] = 640'b0110010101111011100110111010001011110000110000000110001111111111111000100011111111111111111100010110000011110010001111000000100000111011011111011100000001111111111001111111000111111111111111110111111110001111111111111111100111111110001111111111111111111000110000000011111101000000000000001001111111110010000111111111111111101111100111110111111111000111111100111000000111100111111111111111111010011111111111111111111111000011001111111000001101000000000011111111111110100010000000000000000000000000011000000000000000011000000000000001111111111111111111110110100001111111111111011111111111111000000000000000000000000011000000001000000110100100;
back_3[292] = 640'b0111001000110100101110011001011111000000001000001001111111111111100000011111111111111111111111111100101000010010000111111111100000110011101000011000000000111111111001111111000111111111111111110111111100001111111111111111101111111110001111111111111111111011000111000011111101011100000000001011110001110010000111111111111111010000000000111011111111101111111101110000000011100011111111111111111011111111111111111111111111000011111111111111110001111101111111110011000000001100000000000000000000000000001000000000000011110000000000000001111111111111111001000101000011111111111111100111011111111110000000000000101000000100100000001000010000111010;
back_3[293] = 640'b0100000110111101100110100010000010000000100000010111111111111100000011011111111111111111111111111111111001011001100111111111000000111001001000001000000110111111111011111111100011111111111111101111111110001111111111111111101111111110001111111111111111111000111111000001111001110000000000010100001000001101000111111111111111111000000000111001111111111111111101100000000000110011111111111111110111111111111111111111111110000011111111111111000000100111111111101111110100001001000001000000000000000000000000000000001011100000000000010000000000000000000000010110000000111111111100000010010111111111000000000000001101000111100000001011101111111111;
back_3[294] = 640'b0000001010101011000001011011100001010001110100000111111000000000000111111111111111111111111111111111111111111011010011111111000000010000000000000000001011011111111011111111100011111111111111101111111110001111111111111111011100000111100111111111111111111010011011111000111101000000000000001100000000001111000111111111111111110000000000011101111111111111111011000000000000111011111111111111110111111111111111111111111110001011111111111111111111000000111001100110000110011000000010000000000000000000000000000000011011111000000000111100000000000000000100011100000000111111111100000110000001011110010000000000000011111110011110011111110011110010;
back_3[295] = 640'b1111111011110001000111000111000000011000011000000011111110000000000111111111111111111111111111111111111111111111110010100011010000010000000000000000001011011111110111001111100011111111111111011100011111100111111111111111110000000011110111111111111111101100011001111001100011000000000000001100001110000111000111111111111110110000000000011101111111111111110011111111111111100001111111111111110001111111111111111111111110001011111111111111011000100110000000001110111111110000000000000000000000000000000000000000110011111110000010101000011000000000000000001100000001111111111100000011111111111111011001000000000000011100110000001101011000001110;
back_3[296] = 640'b1110110111010100100010001110000101111100001101000000111100000000000110111111111111111111111111111111101111111111111111110000011000010000110111000000001000111111101100000000111001111111111111111101001111100111111111111111110000000001110111111111111110101100001000101000001100010100000000011100000000000110100111111111111101011111111111110000111111111111111100000000000000011111111111111110000001111111111111111111111111001011111111111111011100011010000100011110111111110100000000000000000000000000000000000000110011111111101110100000001110000000000000001000000001111111111111111110000000000000100110011010000000000111111111111111111111111111;
back_3[297] = 640'b0000100011101111111011111100000100111111011111000000111111100000000111111111111111111111111111111111111111111111111111111111100101011111111000001000001001111111100000000000011001111111111111100000000000110111111111111110000000000000111011111111110011001111011111011111011100010100000001000000111111111100010111111111111111110000000001111111111111111111111100000000000000000000000000000000000001111111111111111111011111001111111111111111011110101000000111110000001101111110000000000000000000000000000000000000110011111011111100110000000000100000000011110011111100000000000000000000000011111111111111111111111111111101111111111111111111101111;
back_3[298] = 640'b0001011010010001110010110011010011111111001001101100001111111111100011111111111111111111111111111111111111111111011111111111111011111111011011000101001101111111100000111000001101111111111101100100000000111011111111111101111111111111111001111111001111010110000000111000011100010110000001111000000000011111111111111111111111000000000000000000000000000000000000000111111110000000000000000000000011111111111111111111111111000111111111111111000010011110011111111000000110000100000000000000000000000000000000000000110111111111101111100000111111111111000000000000100111111111111111111111111111111111111111111111111111111111111111111111111111101110;
back_3[299] = 640'b1001011100011011110011000011111111100011110011111100011111111000000110111111111111111111111111111111111111111111111100000111110111001011010111111010101111111111111100000000011110111111111100000001001110000001111111111100000000000000000001111101011111000100000010111111111010111111111111111100000000000000100111111110101000000000000000000000000000000000000010011110000000000000000000000000000001111111111111111111111111000111111111111111110111100011101110110000001000000100000000000000000000001000000000000000110110011010111110100000000000000000000001111111111111111111111111111111111111111111111111111111111111111100111111111111111100001111;
back_3[300] = 640'b0001000001000111101000000111111111110001111111100000111111101000000110111111111111111111111111111111111111111111111111111100011100011010111100001111100111111110000111111110000000111111111110000000000001111111111111111110000000001001111111100100011111001001000011110111111010111011111110000000000000001000001000000000000000001111000000011111101110000000011111111111011000000000000000000000000001111111111111111111111111000011111111111111000111011011111000110000000000000011000010000011010100001100000010100011110110011100001111100000000000000000000000000011111111111111111111111111111111111111111111111111111111111100111111111111111101111111;
back_3[301] = 640'b0010110110001001000010000111011111111000111111110001111111000000000110111111111111111111111111111111111111111111111111111111110111110110010101100101011111111110000000000000000001000011100000000000000111001111111111110000111100000101101110001010011011001101001000111111110010101000000000001110110011111111101100000000000000111101111111111111111111100111111111111101110010010000000000000000000001111111111111111111111111000011111111111111010101011111001100000000000000000000000000000001100000000000000011111111110010010010100101000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[302] = 640'b1101000111000000111101001011101111111111111111010001111110000000001110111111111111111111111111111111111111111111111111111111100011111110001110011101110000000000000000000000000000000000000000000000000000000100111111111110111111110000110000001100010001011100110000101000000101000111111111111111111111111111111101001111111111111111111111111111111110100111111111111101100000000000000000000000000001111111111111111111111111001011111111111111001000110011101111111111010110000000000000000100000000001100000011111111101101101101001011000000000000000000000001110111111001011111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[303] = 640'b1010111110011011111100001011000011111111111111100001111110000000001110111111111111111111111111111111111111111111111111111111100111111000111110010011001000000000000000000000000000000000000000000000000000000000100111111111100000000001001000000100010000010001111001101000001100111111111111111111111111111111111101111111111111111111111111111111111111110111111111111111000000000000000000000000000000111111111111111111111111000011111111111111111001000000001111111111111110000000000000000000000000001100011111011111111110111111011111100000100110000000000000000011000000000001111111111111111111111111100001011111111111111111111111111111111111111111;
back_3[304] = 640'b1001111111000111100100100111001111110110110011111001111000000000011110111111111111111111111111111111111111111111111111111111001111110100001010010001110000000000000000000000000000000000000000000000000000000000000000111100000000000001100000000101100011100101000000101000001111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111000000000000000000000000000000000111111111111111111111111100011111111111111111011000000000111111011101100000000000000000000000000001111011011110111100000101101010101011110011111111111111000000010000000000001110111011111111111110111100001001011111111111111111111111111111111111111;
back_3[305] = 640'b0001111100000010110000111011100111110001110001111001111000000000011110111111111111111111111111111111111111111111111111111111001111010100010111111000011100000000000000011101000000000000000000000001111111101101100000000111011111111100101111111011111111010111000001101001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000001000000011111111111111111111111100011111111111111110101000000000000000001100000000000000000111110010011100000111001010010101000101000100001110010110001100111001100001100000000000000110000001111111100000101100000000011111011111111111111111111111111111111;
back_3[306] = 640'b1100111100000000111011110111100111100001111000111001111000000000011111111111111111111111111111111111111111111111111111111111001111010110010001010010010000111111111111111111111111111111111111111111111111111111111111111111111111100010100111111010011100110111000001100111111111111100111111111111111111111111111111111111111111111111111111111111111111111101111100100000000000000000000000000000000110001111111111111111111111100011111111111111011011100000000000000000000000111010110001010010011000111110010110000110111011111000110000100000101110101000111111111111111001100000100000000111111110111111000000000111110011111111111111111111111111111111;
back_3[307] = 640'b0000000110001100000001111111111010110111111110111000111010000000011111111111111111111111111111111111111111111111111111011111111111110111110101011001100001010000000000000001000110011111011100010011111111101111111111111111011000001100100111111010000011111111011111110111111101001100011111001111100000001111111110001111111111111111111111111111111111111111111110000000000000000000000000001111111110000111111111111111111111110011111111111111011001100000000000000001110000110111100111111111010111101110111110111100011000110011100111001000110011011011100010000110010000110100100000010111111111110111100000000111110001111111111111111111111111111111;
back_3[308] = 640'b0000000000000001100100001111000001111111111111110001111110000000011111111111111111111111111111111111111111111111111100111111011110110101110001001011110001010000000000000000000000000000000000000011000100000000001100110001000000000000000000001000101111110011111111111100000000000000000001000010000000111111111100011111110111111111111111111111111111111111111110000000000000000000000000111111111110000000001110010000000011111011111111111111011111100000000000111001111011001100000000000000000000000000000000000000100000111111111111111111011110000000101000101101011000010010000000001111111111110111100000000011100001011111111111111111111111111111;
back_3[309] = 640'b0000110010000001001000101111100000111110101101111101111110000000011111111111111111111111111111111111111111111111111010111110111110010101100011011011110001000000000000000000000000000000000000001011000000011000000100000000001000000000100000001100011111110101111110010000000000000000000000000010001100111111111101100111111111111111111111111111111111111111111110010100000000000000000111111111111110000000111110011000111111111011011111111111011110000000000011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000001101100111000001111110100100000001111111111110111100000000011000111011111111111111111111111111111;
back_3[310] = 640'b1110011111101001001000000111000000001111111111111100111110000000011111111111111111111111111111111111111111111111110100110110111110010000010011111001110001000000000000000000000000000000000000000000000000000000000010001000001000000000000000000011011111110101111110010000000000000000000000000000000010111110000001100110111101111111111111111111111111111111111111110000000000000000000111111111111110000011111111100110011111111000110011111100011110000000000110000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101001010000000011111111110111001000000110000011111111111111111111111111111111;
back_3[311] = 640'b1111111100100110110011011100000000011111111111111100111100000000001111111111111111111111111111111111111111111111100111001100111100001011010010111001100001000000000000000000000000000000000000000000000000000000000000000000011000000001000000001010011111110101111100000000000000110000000000000000000110111000000000000000011100111000111111111111111111111100100000000000000000000011111111111111111110000000111111110100000001111000011011110100000010100000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111110101000000011111111110111000000001110000111111111111111111111111111111111;
back_3[312] = 640'b0111111111111111110001011110000000011111111111111100111100000000000111111111111111111111111111111111111111111111111100011110011100011011010111011001100001000000001000000000000000000000000000000000000000000000000000000000001000000000100000011011011111110100100000000000000000000000000000000000101111111100000000000101011101110001111111111111111111110000000000000000000111111111111111111111111110000000000000000000000000101000001011101000011000010000001111000000000000000010011100011000100000000000000000000000000000000000000000000000000000000000000000000000000000111110100000001111111111110111000000001110001111111111111111111111111111111111;
back_3[313] = 640'b1111111011111100111111111110000000000111111111111110001111110100000111111111111111111111111111111111111111111111100000110000011100010111000001111011100001000000000000000000000000000000000000000000000000000000000001000000001000000000010011111011011111110110000000000000000000000000000000000001100011000100000000010111111111111111111111110000011100000000000000000000000111111111111111111111111110000000111000000000000000001001000011101111011110000000111111100000001111111111111100111110100000000000000000000000000000000000000000000000000000000000100000000000111111111110000000001111111111111111000000111111100111111111111111111111111111111111;
back_3[314] = 640'b0111111101110001111101111111100000000111001111111110011100100000001111111111111111111111111111111111111111111111110000000000010101111011100010100101000001000000000000000000000000000000000000000000000000000000000100000000001000000001110111111011011111110100000000000000000000000000010000000000100001101110000000000111101111111111111111111110110000000000000000000000010011111111111111111111111110011111111111000000000000000111010100101100111000000000111111111111111111111111111110011111110000000000000000000000000000000000000000000000000000000000100000000000111111111110000000011011111111110011000011111111101111111111111111111111111111111111;
back_3[315] = 640'b0010011111000011001101101111000000000010000110000010111000000000011101111111111111111111111111111111111111110011110010100000111111110010110010111110000001000000011000000000000000000000000000000000000000000000110100000000001000000011000111111011011111100100000000000000000000000000000000000000000000000000000000110000101111111111111111111111100000000000000000000000011111111111111111111111111110011111111111000000000000000101001111001100000000000000111111111111111111111111111110001110011000000000000000000000000000000000000000000000000000000000000000000111111111111100001000111111111111111111000011111111101111111111111111111111111110111111;
back_3[316] = 640'b0000001111100000110000000011111000000000100000000011111000000000111101111111111111111111111111111111111110001111110010110000011110011111111111001011000001000000000000000000000100000000000000000000000000000010100100000000000000000000101111111011011111100000000000000000000000000000000000011111000010000010000011110001111111111111111111000000000000000000000110000000111111111111111111100100111110001111110110000000000000001111000000000000000000000000110111111111111111111111101110001111001100000000000000000000000000000000000000000000000000000000000011011111111111011000001110111111111111111111111111111111111111111111111111111111111111111111;
back_3[317] = 640'b0000000011101000011110001011111000000000000000000011111000000000111101111111111111111111111111111111100100000111110000110000110000001100011111001101111111000000000000000000000000000000000000000000000010000000100100000000001000001100101111111011011110000000000000000000000000000000000000000000000010001011000011111111111111111111111111000000000000000000000110001111111111111111111111100000111110001111111100000000000001111000000000000000000000000000000100011111111111111111111111111011110110000000000000000000000000000000000000000000000001011001111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111;
back_3[318] = 640'b0000000000000101101111111110000000000000000000000001111000000000111101111111111111111111111111111111000000001111100011110011111111111111111101111001111111000000000000000000000000000000000000000000001000010000100000000000001000111100101111111010011000100000000000000000000000000000000000000000000000011101011011111111111111111111111111111100000000000000000011111111111111111111111111111111111110000111111100000000000001111000000000000000000000000000000010011111111111111111111111111111111111100000000000000000000000000000000000011111111111111111111111111111111111100010001111111111111111111000000001111111011111100111110101111111111111111111;
back_3[319] = 640'b0000000000000100000000000000000000000000000000000001111000000000111101111111111111111111111111111010000000011111001100001110000111111110000110000001111111110000000000000000000000000000010011000000011101000000100000000000001000111100101111111010000000000000000000000000000000000000000000000000000000111100000011111111011111111111111011111000000000000000000111111111111111111111111111110011111110000001100000000000000011111000000000000000000000000000000001111111111100111111111111111111111111100000000000000000000000000000000000111111111111111111111111111111111101000000001001000000000000000000000111111111111111111111110111111111111111111111;
back_3[320] = 640'b0000000000000000000000000000110000000000000000000001110000000001111101111111111111111111111111000000000011111111111100001100100010010000011011100000111000000000000000000000000000000000100111100000010001100000000100000000010011111101101111111011000000000000000000000000000010000000000000000000110101111110000011111111111111111111000000010000000000000001111111111111111111111111111100100111111110000000000000000000000001111000000000000000000000000000000000011111110000000111111111111111111111100000000000000000000000000000000000101111111111111111111111111111000100000000001101000000111111111111111111111111111111111111111111111111111111101100;
back_3[321] = 640'b0000000000000000000000000000000011111111111110001101110000000000111101111111111111111111111000000000011111111110000000111111110111111000000000011101100001011100111000000000000000000010111101110110010011000000000010000000010111111101101111110000000000000000000000000000000000000110000000000000001100010110000001110111111111111111011001000000000000000111111111111111111111111111111111111111111110000000000000000000000001111000000000000000000000000000000000000001111000001111111111111111111000000000000000000000000000000000000001111111111111111111111111111000000101001010001111111111111111111111111111111111111111111111111111111111111111101001;
back_3[322] = 640'b0000000000000000000000000000000000000111111110000001110000000000111101111111111111111111110000000000111111111010010000010111000111110000000110111111100001000001111101000000000000010111011011111111101111100000100000001110110111111100101111100000000000000000000000000000000000000010000000011000001110111100001100011111111111111111011100000100000000011111111111111111111111111111111111111111111100011111111111000000111111111000000000000000000000000000000000000000001111100011111111111111111111000000000000000000000000000000000000111111111111111111111000000111111110011111011111111111111111111111111111111111111111111111111111111111111111111111;
back_3[323] = 640'b0000000000000000000000000000000000000011111110000100011111111000011101111111111111111110000000000111111111110100110010000000000111001110001111111111101111000001111111111100000000001111010011110110010011100000100000011111110111111000101110100000000100000000000000000000000000000000000100111011111111001111111111111111111111111111001111111000000000111111111111111111111111111111111111111111111100011111111100000001111111111000000000000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000000011111111111111110000100010111000001100000000110100111111111101111111111111111111111011111111111111111111111111111;
back_3[324] = 640'b0000000000000000000000000000000000011011110010001011111000000001111001111111111111100000000000001111111100000000110001100000000000000000111111111111111111110000111111111111100000001111100001000100100011111000100100001111110111111100111000001111100010010100100000000000000001001000000110000111111111111111111111111111111111111111110000000000000011111111111111111111111111111111111111111111111100000110000000000111111111111000000000000000000000000000000000000000000011111001011111111111111100000000000000000000000000000000000000000111111110000000000000000000000000000000000011010111111111111111111111111111111100001111111111111111111111111111;
back_3[325] = 640'b0000000000000000000000000000000000111110100010110110000000000111111101111111111110000110000111111111111100000010011111111111111111111111100011111111111111110000000111111111110000000001110001011100101111111000100011111111110111111100100000000100000010001100000000000000000000000000000000101111111111111111111111111111111111000000000000000000011111111111111111111111111111111111111111111111111000000000000000001111111111111100000000000000000000000000000000000000000000101001000000001111111100110000000000000000000000000000000000001110000000000000000000000110000000000000000010000000000000000000000000000000000000000001111111111111111111111111;
back_3[326] = 640'b0000000000000000000000000000000000111110000011110110000000000011111101111111100100000110011111111111110000000001011111111111111111111111000111111111111111111111000000011111110000000111111011111000101110100000010011111111110111111101110000000000000000000000000001000000000000000000001101111111011111111100111100000000000000000000000000000000111111111111111111111111111111111111111111110000000000000000000000001111111111111110000000000000000000000000000000000000000110101001000000000001101111111010000000000000000000000000000001111101011111111111111100011111000000000000010010000000000000000000000000000000000000000001111111111111111111111110;
back_3[327] = 640'b0000000000000000000000000000000000011100000001000111111111110101000011111111011100000101111111111000000000000011011111111111111111111110001101111111111111111111111111110001111000011011011011110110001100000000000111111111110111110000000000000000000000000000000001000000000000000011000111111111111111000000000000000000000000000000000000100000000000000011000000011111111001111111111111110000000000000000000000000000000000011111000000000000000000000000000000000000000001100011100111111110110001111111000000000000000000000000000001111000111111111111111110111110000000000000000010000000000000000000000000000000000000000011111111111111111111111110;
back_3[328] = 640'b0001000000000101111111111111111111111001111111111111110000000000000000000111111111111101111111111000001111101111111111111111111111111110001101111111111111111111111111111111111000111011011111110100100100000000000111111111110000000000001000000000010011111000000000111111111111110011111111111110111111111111111111111111111111001111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000011101100111111001100111111111101111110001011111100000000000000000000000000111110010111111111111111110111000000000000000000010000000000000000000000000000000000000001011111111111111111111111111;
back_3[329] = 640'b0000000010011111000000111111111111111111101000000000000000000000001110111111111111111101111011000000011111111101111111111111111111111110011101111111111111111111111111111111111000011011011100111000111110000000000100111111101001011111100011111110111111111100000001111111011111011111111111111111101111111111111111111111111111111111101111111111111111100111111111111100011100110010010000000011010001000000000000000000000000000000111111100000000000000000111111111111110000011000000000000100101101101111110000000000000000000000000111100001111111111111111100011000000000000000000011000000000000000011100000000111110000001111111111111111111111111111;
back_3[330] = 640'b1100111111111111001111111111111111111111111101000000000000000000001111111100111110111100000011000111111111111111111111111111111111111111011101111111111111111111111111111111001101111111011010111100111101110000000100111111111001011110000000000000011111111100011111111111100100010011111111111111111111111111111111111111111111111111111111111111111001111111111111111111111000000011100111001000000000000000000000000000000000000011111111101111110100111001111111111111101100011111110000000000011101010111110000000000000000000000001111000000111111110000000000000000000000001000000111100001011111111111111111111111111111111111111111111111111111101000;
back_3[331] = 640'b1111111111111111111111111111111111110111000000000000000000000000000011111100000000001100000011110111111111011111111111001001011001111101001101111111111111111111111111111111111001110011111110110100011100100000000000000000000000001000001100000000011001111101111111111001111000110000001111111111111111111111111111111111111111111111111111111111111111111100111111111111111111100011101111001111010001000110000000000000000000000000011111111111111111111111111011111110111100011010010000000000011111001001111100000000000000000000011110000000000000000000000000000001111111111100000111111111111111111111111111111111111111111111000000000000010000000000;
back_3[332] = 640'b1111111111111111100001001110010011001000000000000000000000000000000000000000000000011111000011100111111101111111111111111111111111111111011101111111111111111111111111110001110000010011111110000000011111100000000111010000011011110100111100000011111111111111111111100000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000111001011000000000000000000000000000000000111111111111111111111110111111100111000011010000110000000001111111001111100000000000000000000001111000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[333] = 640'b1111111111100000010000000000000000000000000000000000000000000000000000000000000000010111000001100001111111111111111111111111111111100100011111111111111111111111111111101111100000011101111111000100011110110000001111000100110000000110000010000001111100000000000001000110000000001011111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111100000001111001111111111110100000100000000000001000000000000000100111111110011001000001001011111100000000001010011111100111100000000000000000000011100000000000000000000000000000011111111111111101111111111111111111111111111111111111111111111111111111111111111111111;
back_3[334] = 640'b1111110000000000110000000000000000000000000000000000000000000000000000000011000000001111000001100011111111111111111111111111111111101000011111111111111111111111111100011111000000011110001111000100011110000000110010001100000000101100000100000111111000010000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000011011111111000000000000000000000000000000000000000011000111111111111111101011111000001001011011000000110011000111111111111110000000000000000000011100000000000000000000000000000000010111111111001111111111111111111111111111111111111111111111111111111111111111111111;
back_3[335] = 640'b0000000000000000100000000000000000000000000000000000000000000000000000011111100011111111101101011111110000000001111111111111111111111100011111111111111111111111111011111110000000001001001000011110001110110000000000000000000000110000000000000110000000000000000000000000010000000000010001011111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111001111110000000000000000000000000000000000000000011000000000000001111000000100000001001111111110000010011111001111110101110000000000000000000011110000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
back_3[336] = 640'b0000000000000000000000000000000000000000000000010000000000000100001111111111111111111110111101100000000000000000111111111110101111110000011011111111111111111110000111110000000111110111100110011110001111110000000011111000000000100001111111111111111111100000000001111110010000011111111111001111111111111111111111111111111111111111111111111111111111111111101111111111111100000000001001000110000000000000000000000000000000000000000111100111111011111111000011110000001011011110000001100000001010111011111110000000000000000000001111111100000000101100000000001111111101111111111111111111111111111111111111000111111111111111111111111111111111111111;
back_3[337] = 640'b0000000000000000000000000000000000000000000000000000000000000100000111111111111000001111111110100000000000000000111111111101110011110000011111111111111111111110111111100000001100000000100000111011001111111000000001000000000000001111111110001100100000000000001100000000000000011111111110000000000000111011101101111111111111111111111111110111111111111111111111111111111100000000000000000000010000000000000000000000000000000000000001000010100000011110100000000000001011111110000000001111001010111000101100000000000000000000011110000000000000000000000000000011101001111111111100011110000110001111110000000000010000011101111111111111111111111000;
back_3[338] = 640'b0000000000000000000000000000000000000000000000000000000000001100000000111111110000001110111010100000000111111111111111111111111001111000001101111111111111100011111110000000011100000000111000111011110111111000000001110000000011111111111111111100000001000000001100000000000011111111111111111111011011111111111111111111111111111111111111111111111111111111111111111111111111110111000111000001111111110100000000000000000000000000000000000000111000100010010000000000000111111010000000110011111100111111111100000000000000000000011000000000000100000000000000000001000000111111101101011000000000000110110000000000000000011101001111111111111111110000;
back_3[339] = 640'b0000000000000000000000000000000000000000000000000000011111111100100001111111111000011111111010100000000111111100000111111111111011111000001110111111111111111111111100000000011100000001011000111010110111110000000000111010000001111000100011100100000000000000001101100000000111111111111111101111111111111111111111111111111111111111111101111111011111111111111111111111111111111101011111111111111100100100000000000000100101111111111011000001111010110001000110000010001111111100000001110011110010111111111100000000000000000000010000001000011000000000011100000000000000111111101101101000000000000110110000000000000000000100011111111111111111110000;
back_3[340] = 640'b0000010100000000000000000000000000000000000000000000111111111001111111111111110000011111111010110000001111000000001111111100010110111000001111111111111011111110000000001111110000000001111101001110110111000000000100011000000000111001101111101101011100000001001111100010011111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111101100000000000000000000011101111111111011100000000100000110000000001111111110000001111011111111111110111100000000000000000000010000000001111001001001111111000000000000111111101111000110000000000000010000000000000000000100000011111111111111000000;
back_3[341] = 640'b0000001011000000000000000000000000000000000000000000010000000011111111111111100000001110001111110000001111000000001000011101001011110000011111111111110111101100000000001110000000100001001110000111110110000000010100110000010000011001101111111110110010011101111111000011111111111111011100111111111111111111111011111110111111111111111110111111111111111111111111010011110011000000000001111100000000000000000000000111111000000011111111111111111111111011110010000000001111111010000000111111111110011110111100000000000000000000010001111111101011111111111111000000000000111011110111100000000000000000000000000000000000000000000001111111111111000000;
back_3[342] = 640'b1011001011110000000000000000000000000000000000010000000000000000110111111011100000001110001111111000001111000000010000011101110001000000001111111111011100000000000001111111111111100010001110011111110110000000000000000000010100000000000000001111110000010011111111101000000000111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111011110000001000111111111111111000000000000000000010000001111111111111100000011101000000000000101110111011000010101101111101001101111100000000000000000000010111111111111111111111111111001000000000111111000011100000000000000000000000000000000000000000000000000111000000000000;
back_3[343] = 640'b0011101011111111111111110000000000000000000000111000000000000011111111111111111111101110001011111100001111000000010011110100000000011000000001000111011001000000001111111111111110001010110010001101110110000000011000000000001100000000000010011111111100010110111101111111111111111111111111111111111111111111111111111011110000111111111111111111111111011000011001110011011100010110000000000111111111010000000000001111111111111100000111111111000110111011000110000000101110000000000111100101111110000010111110000000000000000000010111111111111111111111111111100000000000111101000000100000000000000000000000000000000000000000000000010111010000000000;
back_3[344] = 640'b0101111000000000000000011111111111111111110011111111000000000011111001001000111111001110000011000111111111000000011111100100000000011001100000101010100101001111111111111111111101111100101100001111011111000000010000000000000000000000000000011110111100111110110000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011110011110000000000001111000000000000000000100011111000110000011111111000011110011000100000000011110000000001100100110100111011000111110000000000000000000110111111111111111111111111111110000000000111111000000100000000000000000000000000000000000000000000000000011000000000000;
back_3[345] = 640'b0001101100000000000001001111011111110000010111101110000000000001100011000000110001111100111011100111111111111111111111111100000000100000010110000010001111111111111111111111111011110000110000011000011111000000000000000000011111110010111111111110110111111110110111001111111111111111111111111111111111111111111111111101111111111111111111001100111111111111111110000000000000000000000000000000000000000000000000000000011100000010001111111111000000010011000100000000001010000000000001000010000000000001111110000000000000000000010111111011111111111111111111110100000000111111110011100000000000000000000000000000000000000000000000000111000101000000;
back_3[346] = 640'b0111111100000000000000110111011011010000011000000000010000010010011110000000000001000000111101100010001111111111111111010000011001100100001010000011001100111111110111111011111111110011110011010100001100000000000010000000001100000001111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111110111111111111000011111001111111000000000000000000000010000000000001000000000000000000001000000100000000111111111111100000011110100000000001101000000111001111010010000000001111111000000010000000000110111110001111111111111111111111000000000111111101101110000000000000000000000000000000000000000000000010011001100000000;
back_3[347] = 640'b0101011010000000000010100010000010000000011000000110010000110101001001111010000000000000000000000000101111111111111111011100001100100000010110000101001101111111111111111111111111111001111000111100000000001111111111100000000000000000000011111111111001111111111011111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111100000000000000000000000001011111111111110000000000001100000000000000001111111000000110010000100000101111000000000000001101101000000000001111110000000000000000001110111111011111111111111111111111000000000111111100111100000000000000000000000000000111110000000000000011111111111100000;
back_3[348] = 640'b0100111100000101100101111111111000000000011000000000010101110001001011100000000000000000000000000000111111111111111101010100100010101010101000001000110000111111111111111100111110011111111100001000000001011111111111111011111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111101111111110111111111100110001111111111110100000000000000000000000000000000000000000000001100001111110000000000000000000000000001010000000100000111111111000000111000110111100000000001111111111110000000000001110111111110100111111111111111111000000001111111111111000000000000000000000000000000011110111101000000000000000000000100;
back_3[349] = 640'b0111010111000000000001110011111000000000011000000000010010000100011111100000000011110011000000011111111111111111100001000100100100010100000010010011011101111111111111111111111111111010000000011000000000000111111111111011101111111111111111111111001011111111001111111111111111111111111111111111111111111111111111111111111111111111111100000000000000111111111100000000001110011000000000000000000001110001110000000000000000000000000000000000000001010011000100000011111101100000111111101000001111100001111111111110010000000001110111111011101111111111111111111000000000111111111111111100000000000000000000000111111111000000111100000100000000011100;
back_3[350] = 640'b1110010011100011101111110111111100000000011001100111111001100100110000000000000001000011000000011110111111111111110001100000100110010101010100001000001001111111111111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001101111111111111111100001110000000000000000000001111111010000000000000000000000000000000000000010010010000100000000000000000000011111000100000000000011111111111111110100000111110111111101111111111111111111111000000001111111111111111110000000000000000000001111111111001111001111111111111111100000;
back_3[351] = 640'b1101010110000000000111110001100000000000010000000011110101101111000000000000000000001010001000111111111111111000001100111001101110110101011111101101010011111111111111111111111111111110111011101111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111100111101111111111101000000000000100000000000000111111111111011111100100000000001000000000111111011000001110000000000000000000000000000000010010001110000000000000000000001110111000000000000111111111110011110110010111110111111111111111100111111111111000000001111111111111111110000000000000010000001111111111000011000000000100000111110000;
back_3[352] = 640'b1101010000000000000000000000000000000000010011000101110011110000000000000010000000000000000110011111111111100000011000111111001111101001010110011000100010111111111111110111111111111111111111111111111111111111111111111111111111111111010111111111111111111111111111111111111111111111111111111111111111111111111111110001111111110000000001011100001000000000000000000000000001100000000000000000000000000000111000011110001100010000000000000000000101010010000100000000000000000000001111011110000001011111111111111111101101111111110111111111111111111111111111111000000001111111111111111111100000100001111001111111111111000100000001111111100011011001;
back_3[353] = 640'b1111111000000011110011111111111110000000010101110010111111000111000000000110000000010111111111111111111111110000011110111111001100010101111111110000110111111111111111111111111111111111111111111111111111111111111111111111111111111111100101000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011111001011111111111111110011111000010000000100000000000000000001110111111111111111111110000011110000100101010011110110000000011111110111111110111111100100000000000000000001100001011111110111111111111111111111111000000000110111111111111111111111111111111111111111111111111111000000000011111111111111111001;
back_3[354] = 640'b1111111000000000000001100001110101100000111000001000110000000000000000011000000000101111111111111111111111110001110110111111111110000111111101000000000011111111111111111111111111111101011101111111111111111111111111111111111111011101001001111111111111111111111111111111111100011111101111111111111111111111111110011111111111111111000000011111000001110000111111110011111111100000101101100001110001101001110111111111111111111110001111111111101101111011111110000000111111100111111111111100000000000000000000000000010100111110011111111111111011111111111110101000000001111111111111111111100100000011111111111111111111000000000111111111111111111100;
back_3[355] = 640'b1111111000000000111111111011111100100111001010001111010000000000000000000000000010001111111111111111111111110000011100000100110000000000000000000001000001111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111100111000000000000000000111111111111100000000000000000000000000000001001000000000000000001110010000000000000000000011101010010000000011100010001100000111110111000000000000000000000000000001110111111111111111111111111111111111111111110000000111111111111111111110000000011101111111111111111001000000111111111111111111100;
back_3[356] = 640'b1110111110000001111111000000000101000010001100100010000000011111111111111111110100001111111111111111111111110001001000000011010000000000000000001111000000111101011111111111111111111111111111111111111111111111111111111111111111111111111111111111110010110010110001110111111111111111111111111111011111111111111111111111111111111111110000000000001011111011111111110000000000000000000000000000000110011000000000110000000000000000000000000000011100000011000100110000000111111111111110111000000000000000000000000000000110111101111111111111111111111111111101111111000000111111111111111111111111000111111111111111111111001000000111111111111111111110;
back_3[357] = 640'b1110110000000111111110000000000000101001101011100000000000011111111111111111111110111111111111111111111111111111110111000101000000000000000000001110010001111101111111111111111111111111111111111111111111111111111111111111111110011011110000111101111111111111111111111100111111111111111110111110111111111111111111111111111111111111110000000000001011111011111111100000110001010000000000000000000011010000000111111111001100000000000000000000010100010011000110000000011111111111111110100000000000000000000000000000000101101011111111111111111111111111111100111111000000111111111111111111111111000111111111111111111111110000011111111101101111111111;
back_3[358] = 640'b1010100000011111100000000000101000001100011100000000110000011100100011111111110011011110111111111111111111111111111111000011011111100001001111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111101111111111111111111111111111111111111111111111111111111011111111111111110000100111111110000000110001111111111111111100000000000000000000000000000000000001111111111111111000111000000001111111110011100011110000010000000011111111111111010110000000000001111111100000000000111110011111111111111111111111111111100111111000000111111111111111111111111000111111111111111111111110000001111111101000011110111;
back_3[359] = 640'b1000100000011110000000000000101010010010001101000001100000000011111111111000111111110011111001111111111111111111111110111111111111111111001111110010111111111111011111111011000111111111111111111111111111111111111111111111111110110001011111111111101111111111111111111111111111111111111111111111111111011111111111111111111110111111111110000100001000111111110000000100101000000000000011011100000000111001111111100000000000000000000001111110101100111101110000001111111111111111111010110000000001111111000001000000000111011011111111111111111111110001001100111100000000111111111111111111111111110011111111111110011110110000001111111111000011110111;
back_3[360] = 640'b1010100000000000000000101111100011001101101100000000100000000111110001111111111111111111111111111111111111111111111111111111111111111111111111011111111111111110001100100000001101111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111111111101111111111111111100111111111111111111111111111110001100101100111111100000001111001100000000000001100000010000000001001111010000000000000000000000001100110101111111000001111111111111111111110010110000000001111101100000010000000111011001111111000000001111111111111100010000000000111111111111111111111111111111111111111111011110110100000111111111000000010010;
back_3[361] = 640'b1000110000000000000011101000111011000000101100000000100000000000011110000000001100011111111111111111111111111100001111000001000000011111110000111111111111111111000001111110111111111111111111111111111111111001111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001110001000000000000000111101000000000000000000000000011100000011111111110010000000000000000000111111110100101101100000010011111111111111110010100000000001100011111011111000000111011001011110000110101010000010000000000000000000111111101111111111111011111111111111111110000110110111111111111110000000000000;
back_3[362] = 640'b1011110000000000000010011110100111100000101100000000100000000001100000000001111000011100111110011100000101111111111111111111111110011111110000111111111111111111101111111111111111111111111111111111111111111111111111111111111111111000010000000000011000000000000001111111111111111111111111111111111111111111111111111111111111111111111100001111000010000000000100000000000000000011111010000000000011100111100111111000000000000001111111111111110101100100111100000000000000010111011110110000000000000000000011100100000111101100010110100110100111111110001000000000000000111111111111111111111111111111111111111000000110111011111111100000000000000000;
back_3[363] = 640'b1011111110000000101110011000011010000001101100000000100000000111111110011111111111111111111111111111111111101111111111111111111111111111111111111110001100000000000000011111111111111111111111111111011111110001000000000011111111100111111111111111111111111111100111011111111111111001100000001011011111111111111111111111111111111111111000001111000011011111100111110000000000000001111110100100000000000100000000000000000000000000000000000000000100111111100100111111111111111111110110101100000000000000000000000001011111100100000111100111111111111111110000101000000000111111111111111111111111111111111111111000000000100011000000111111110000000110;
back_3[364] = 640'b1011111000011101010111010001110000000001101100000111111100000000000000001011111111111111111111111111111110001111111110111110011111111110111111111111101011100000000000010000000000000000000011111111111111111111111111111111111111100111111111111111111111111111111111111111100000001111111111111111111111111001111111111111111111111111111110000000000000000000000000001110000000000000000000000000000000000010011111110000000000000000000000001100100100011111100110001111111111111111000011111100000000000000000000000001001011010000001111011000111111001100000001100100000000111111111111111111111111111111111111111000000000101111010111000000000000000000;
back_3[365] = 640'b1001111100000101000001001001100100000000101100000001100000011111111111111000100111000000010000000011111111111111111111111110011111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001110100011111111111111111101111111111110111111111111111111111111111111111111111111111111111111111100111100000000000000000000000001100000000000111000000000000011111111111011111100110000000001101111111111111110000111100000000000000111011001111010000100000000000010000000000000000101011100100001111011001110011011001111000101100000000111111111111111111111111111111111111100000000000011100001000000000000000000000;
back_3[366] = 640'b1001111000010101110011101100010001111111101110000001100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000011001101100011111111111111111111111111111111111010000001111110001101110011111111111111111111111111111110100000011011111111111111111111111111111111111111111111111111111111111111100111000100000000000100000000001000000000000111111011000000000000111111001011100000000000000000011111111110111101111110000000000001001110001110001000110000000000000000000000000001101010101100110001110011000011111110111000010110000100111111111111111111111111111111111111001110000000000000000000000000000000000000;
back_3[367] = 640'b1101001100100110110011110000000000001111011111111111111100000000000000000000011111111111111111111111111111001111111111110100111000111111111111111111111001111000001000000000000000000011011111110000011111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111100001100010000001000001100000000000000011000000000000001000111111111101100000000000001000001111001110101101111111011000000000000000000011110000110000000000000000000000000010111010001111100110110100110001111001110101001100100000111111111111111111111111011111111111111110000000000000000000000000000000000000;
back_3[368] = 640'b1001110010011110011111111000000000000000010000000001100000111111111111110000110100110000000000011111111111111111111111111011111000111101111111111100111111111111111111111111111111111111111111111111111111111111110000000000000000000001101011000111001101100000101111111111111111110111111111101111111111111111111111111111111111111111111111100110000001000000000011100000000000000000001111111111111111111111111111111111110000101000001111111111110101111111011111100000000000000101100000100000000000000000000000000111001011110001100110000011000001110111101111100100000000111111111111111111111111111111111111111111000000000000000000000000000000000000;
back_3[369] = 640'b1011011001010111000000000011111100000111010111110001100000011111111111111111101101011111111111111111111111111100111111111111111111111111011111111111111111111111111111111111111111111111100111111111100000000010011111101111111111111111111111111110000000000000000000000000001111111111111111111111111111111101111111111111111111111111111111101000000000000000010011011000000001011111100000000000000000000011111111111111111101000111111111011111111101111011000111111111111111000110001010100000000000000000000000000011100011000000000011001101000000011111111001111110000000111111111111111111111111111111101111101111111110000000000000000000000000000000;
back_3[370] = 640'b1111011110110111000110000000000000000001010111111111111100000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000011101111111111111100001111111111111101111111011111111111111111111111111111111111111111111111111111111111111000000000000000000000100000000000000000111111111100100000000000000001001111000000000000000000001000000000000001111111111101010000111110001111101111111111101111110000111110100000000000111111100100000000000000000000000000001111011000000000000110011100000101111111001010100000000011100110001111101111111111111111111111111111110000000000000000000000000000000;
back_3[371] = 640'b1111111001010000000000000100011111111001010100000001110000011111100000000000000000010000000000011111111111111111111111011111111100111111111111111111111000001111111111111111111111111111111111111111111111111111111111111111111011101111111111111111111111111111111111111111111011111111111111111111111111111111111111110001111111111111111111100101111110001011111111111111111101000110111111111110111111111111111111111111000001101111111111110011001011000010000000111111110000000101111111100000000000000000000000000001101011000000000000100011111011101111110110010011111111110000001100000000000111000011111000111111111110000000000000000000000000000000;
back_3[372] = 640'b1111100000000000000000000000111111111010110010000001110000111111111111111111111111111111110000000000000000000000000000000000000111111111100000011100111111001111111111111111111111111111111111111111011110011111111111111111110000000000000010010111110000000000000000000000000100111110111111100111111111111111111110111111111111101111111111001100000100000111111111100000000000011000000000000011111111111111100000000011100111001111110001111101000000000000000000011111111101111001111101100000000000000000000000000000011011111100011111100011001110110011110110000011111111111111111101111111111100110000110111000011111110000000000000000000000000000000;
back_3[373] = 640'b1111111111110101000111111110000000000000011111100000110001111111000000000001111111111111111111111100001000000000010000000101100100000011001100000000000000000000000000000000100000011111111111111111111111111111111111101111111000110000111111111111111111111111111110100000000000000000000000000000000000000000110000000100111111111111111110000110010100000111111111111000000000011000000000000000110000000000000000000010000001110000000000001111111111111111101000000000000000000000111101100000000000000000000000000000011010000000011111100001110101111100000000001000000100000001111110000000000000000000001000000111111111000000000000000000000000000000;
back_3[374] = 640'b1111111111111001110011111100001101011000011111100011111100000000000000000000000001000000001111111111100000000000000000000111001111111111111111111111111000000010000001100000000000000000000000100000000000000000000000111000111000010000100111111111111111111111111111111110111111111111111111111111000000000000000000000000000000000000000000000000111011111100000000111111000000000000000011110000111110110000000000000000000000000000111101111111110000000000000010111111111111101101111111100000000000000000000000000000000010111100111011100100110100010100000000011111111111111111111111111111111111111111001111111000111111000000000000000000000000000000;
back_3[375] = 640'b1111111111000000000000000000000000011100011111101111111111111111111111111111111111111111111111111111000000000000000000110011111111111111100000000000010111111111111111111111111011111111111111111111111000011100000000000000000000000000000000000000000000000111111111111111111111111100100000010111111111111111111111111111111111111111111111111111011011111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000110111011111111110100000000011000000001100000000000000000000000000000000001001100100000000101010010010011101010011111111111111111111111111111111111111111110111111100111111000000000000000000000000000000;
back_3[376] = 640'b1111111111111111111111111111111111000000011111000111111111111000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000011111111111000000000001111111111111111111111111100111110000011100000001000000000000000000000000000000000000000000001110000111000000000000000011111111111111111111111111111111111111111111110000000110110000000000000000111100000000000000000110000101000000000000000000000000000000000000000000000000000000000001111011111111110010101100000000000000000000000000000001001111111011110000100001110010000101010000101011111111111111111111111111111111111110111111101111111000000000000000000000000000000;
back_3[377] = 640'b1111111111111100000000000000000000000000000000000111111111100000000000000000001111111001111111111111111111111111111111111000000000000010000111111111100000000001000000000000000000000001001111111110000000111111000111100011100000000000000000000011110001111111100000001111111111111110000000000000000000000000000000000000000110000000110010111111000011111111111000000000000011000000000000000000000000000000000000000000000110000000000000000000000000000000000000001000000000000000000011100000000000000000000000000000001000111111100110000111101000011111010011001000000000000010011111111111111111111111110011011101111111000000000000000000000000000000;
back_3[378] = 640'b1111111110111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000001001111111111111111111111111100000000000000000000000000000000000000000000000000000000001111111111000010000000000011111111111111111111110000011111111100111111111110001111111111111111111111111110011010000000000000000000111100100011000000111111111111111111111111111111111111110000000000000000011111100000000000000000000000000000000000000000000000000000000010000000001111111110000000000000001000101111111111000111111110010000001110000111110000000000000000000000000000000000000000001101111110000000000000000000000000000000;
back_3[379] = 640'b1111111110000000000111111111111111111111111111111111111111110000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000111110000000000000001111111111111111111111111011111111111111111111111100010011000111000010000001111111111111111000000000000001000000111111111111111111000000000000000000000000000000000000000000000000000000010011111111111111111000000000000001000000000000000000100110010010011111100000000001111111111110100000000000000000010000100000101111110000000000000000000000000000000;
back_3[380] = 640'b1111111111110000000000000000000000000001111111111111111111111111111111111100000000000000000000000000001111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000011111111111111111111111111011100000000000000000000000000000000000000000000000000000000000111111111111111000000000100011111101111111111111111111111000111000000000000000010000000000000000001011001001111111111111111111111111111111101111111110110001100000000000000000000000111110010000011111111111000000000000001000000000000000001100011110011100000111111100000110110000011111110000111111111101111111110111111110000000000000000000000000000000;
back_3[381] = 640'b1111111111111111111111111111111111111111111000000000000000000000000011111111111111111111111111111111110000000000000000000000000011111110000000000000000000000000000000000000000000000111111111111111111111111111111111111111100000000000000100111100100000000000000000000000001111111111111111111111111111111111110000000000000000000000001111111101100000000111100111111111111111111010000000011001011111111101111111111111111111111111111111111111111111111111111111001111111111111111111111011100001111111111100000000000001000000000000101001000011100001111111111000000001011011011011111111111111111111110000100001011111100000000000000000000000000000000;
back_3[382] = 640'b1111111111111111111111111111111111111111111111111111111111111000000000000000000000000000011111111111111111111111111111111111100000000000000000000100000011111111111111111111111111111111111111111111111111110000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111000000000101111111000000000000000000000100000000000000000000000000000000001111111100000000000001111110011111111110000000011111111111111111111111111111111111111111111111111111111111011100000111111111100000000000000100111111111011000001111100001111111111111111111111111111111011111111110100010000000000000011111000000000000000000000000000000000;
back_3[383] = 640'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000011111111111111110000000000000000000000000000000000000000000000000000000000010101111111111111101111111111111111111111111111111111111111111111111111111111111010110000011111111110000000000011110000000000000000000001100011111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000;
back_3[384] = 640'b1000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011111111111111100000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000011111111111111111111111111111111110011111110000000000000000000000000000000000000000000000000110111111111111111111111111111111111111111111111111111111111111111111111111111110111000011111111111100000000010100000000000000000000011100000111111111111111111111111111110011111111111111111111111111111111110000000000000000000000000000000000;
back_3[385] = 640'b1111111111111111111111000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111010000000000000000000100000000000000000000011111111111111111111111111111111100000000011111111111001111111111111111100000000000000000000000000000000000010111111111111111110111111111111111111111111111111111110111011101111111111111110011100001101111111110000000010101100000000000000000011000001011111111111111111111111111111111110111101111111111111111111111110000000000000000000000000000000000;
back_3[386] = 640'b1111111111111111111111111111111111000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000001000000000000000001111111111111111111111111111111000000000000000000000111011111111111111111111111111111111111111111111111111111111111100000011111111111111111111111111111111111111111111111111111111111111111111111011010011100000000011111111100000010101111110000000000100011100000111111111111111111111111111111111111111111011111000001111111111100000000000000000000000000000000000;
back_3[387] = 640'b0000000001111111111111111111111111111111111111111111100000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000001111111111111111111111111111111111111110000000000000000011111111111000111110011111111111111111111111111111111111111111111111111111111111010001111111111111111111111111111111111111111111111111111111111111111111111111000001100000000000111111110000011110000000000000000000011100000111111111111111111111111111111111111111101111110011000100011111110000000000000000000000000000000000;
back_3[388] = 640'b1111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000100111111111111111111111111111111111111111111100000000001111111110000000011111111111111111011110001111100000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111100111111111111111000011100000000000111111111000101101000000000000000000101100110111111111111111111111111111111111111111110000011111111110000111111000000000000000000000000000000000;
back_3[389] = 640'b1111111111111111111111111111111111111100000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000001011011111111111111111111111100010000000000111111111111111111110000000000111111111111111111111111111110000000111111111111111111111111111111111111111111111111111111110011111111111111000011100000000000011111111100100111000000000000000000101100000111111111111111111111111111111111111111111100010011001110010111110000000000000000000000000000000000;
back_3[390] = 640'b1111111111100000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000010100111110000000000001100100000001011100011101000101110000000000000101000000000000000100011111111111111111111111111111111111111111111111111111111111111111111111111000010000000000000011111111100010101100000000000000100000010000111111111111111111111111111111111111111011110011000110000001101000000000000000000000000000000000000;
back_3[391] = 640'b0000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000100000000000000000000011100101111111111111111100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000111000000000011111100000000111101000000000000000010100011111111111111111111111111111110000111100011110000010111000000011110000000000000000000000000000000000;
back_3[392] = 640'b0000000000000000000000000000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000111110010111000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000011111100000000000000111000000000000000101011010001111111111111111111111100000110011111111101100000000011000000001111100000000000000000000000000000000;
back_3[393] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001111111110000000000000011111111110001111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000110000000000000000111011110001111111111110000011000100111111111111111101000100000011000000011111100000000000000000000000000000000;
back_3[394] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111100000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111110000011100001111111000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000111000000000000000110010110001111110000000000011001111111111111110000101000000001111000000010111100000000000000000000000000000000;
back_3[395] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111000000000000000000111100000000100000000000000000000000000000000000000000001111111100000000000000000000000000000000000001111111111111111111111010000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011111101000000000000100000010011111000000000110011111111111110110000001100000000000001100000010111110000000000000000000000000000000;
back_3[396] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111110000010111111111111111111111111111111111111111111111111000111100000000000000000000000000000000000000000000000001111111111111111111111111111111111111010100010011111000000000011000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011111100000000000000110010110011100000001100011111111111000110100000000000000000000010100000000111110000000000000000000000000000000;
back_3[397] = 640'b1111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111100000000000000000000000000000000110010000000000000000010000011111111111111111111111111111111111111111111110000000111111111001111111111111111111111111111100000011000011111000000011111111000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011101100000000000000010010110011100011000111111111111110000000000000000010110100111100100000000111100000000000000000000000000000000;
back_3[398] = 640'b1111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111100000000000000000000000000000001111111111111110000000000000100011101111110000011010000001111111111111111111111111111111000110110100000111111111111111111111111111111111100101010001111000000000000001110110110000000000111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000011101100000000000000011011010011100011111111111100000000000000000000000010011101011101110000000111100000000000000000000000000000000;
back_3[399] = 640'b1111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000001011111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000011111111111111111111111111111000000011010111011011011111111111111011111111111111111111111111111111100011010000110111000011111111111111111111111111111011000011100000000000000000000000000011100011100000000001111111111111111111111111111111111111111111111111111111111111111111110010000000000000000000000000000011101100000000000000001010010011100001111111111111111000000000000000000010011110110011000000000111100000000000000000000000000000000;
back_3[400] = 640'b0000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000011111111111111111111111111111111111111110000001001001111111111111111111111111100111111111111111111111111111111110011111100000000111111111001111111111111111111111111001100111100000000000000000000000000000000011111110011111111000000000000000010000111111111111111111111111111111111111110000000000000000000000000000000001001011111111110000101111000011100000001111111111111110000000000000000011111011010001100000001111100000000000000000000000000000000;
back_3[401] = 640'b0000010001000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000001111111111111111111111111111111111111111111111111111110000000010011111111111111111111111111000111111111111111111111111111111111100000000111110000000001111111111111111111111111011111111001111111000000000000000000000000000000000000000000000000011111111111111111000000000000011111111111110000011001001000000000000000000000000000001011000000000000000101110100111100001111111111111101111110000000000000000110001100100000000001111100000000000000000000000000000000;
back_3[402] = 640'b0010010000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111110001100000000110011111111111111111111100000011111111111111111111111111111111110000000001111100000000000011111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000011111001011000000000000000000000000000001011100000000000000010101000111111000111111111111111111111111111111111111110000100000000001111111000000000000000000000000000000000;
back_3[403] = 640'b1000100010000000000000000000000000000000000000001011111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000010001111111111111111111111111000000000111111111111111111111111111111111110000000000000000011101101100101111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000010111111011000000000000000000000000000001011000000000000001000101000111011111111111111111111111111111000100000100111001100000000001111111000000000000000000000000000000000;
back_3[404] = 640'b1011110000010000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000100000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000001010011111111111111111110011110000000000011111111111111111111111111111111111110000000010101110001111110111111111111111111111111111111111100110001111111111100000000011111111110000000000000000000000000000000000011100110011000000000000000000000000011001011100011111010001110100000111100000000000000000000000000000000000000000000001000000000001111111000000000000000000000000000000000;
back_3[405] = 640'b1111100000000000000011111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000001000100000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000110000111111001111111111110111111111111110000001111111111111111111111111111111111111110000000110011001111111111000111110001111111111111111111111111110000010110000011000000000111111101111110000000000000000000000010011010000000000000000000000000011001001011111111110111001110010111100000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000;
back_3[406] = 640'b0000011111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000001000000011001100100000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111111111111111111111111111111111111001000000011111111111111111111111111111111111000000000000111111111111111001111111111111111111111111110011010111111111000011111110111110000000010010000110010000000010001110000011111111111100111111000011011000000000000111101111000111100000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000;
back_3[407] = 640'b1111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000011000011111111111111100100000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001111111111111111111111111111111111111111111001000000001111111111111111111111111111111111111110010000000011111111000000111111111110011111111111111111100000000011111111111111111111111111111101111001110001111111111111111111111111111110011011000000000000001101111010111001111111111111100000011111000000000011111111111110000000000100100000000000000000000000000000000000;
back_3[408] = 640'b0000111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000010111000010000101100111110000000110011111110111111110000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111100000001110000001101111111111111111111111111111111111111111111111101111000110111111110111110010011111111110000001100111111111111111111111111100000000000011000011011111111110000001111100000111011101111111100010000100100100111100000000000011111100000011110000011111111000000100110000000100000000000000000000000000000000000000;
back_3[409] = 640'b0001111101001000000000111111111111111111111111111111111111111111111111111111111111111111111100000000000011100111100010000011110001111111110110000011000000000000000010000111100000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111111111111111101111111001000110000000000000001000111111111111111111111111111111111111111111111000011111111111111001110000111011111111111010100010001101111100000000000001110000000000111001001111010100000000000000000000000001011001110000000110000000101110101101000010100111111000000100000100000011111111111011111111000000000000000000000000000000000000000000;
back_3[410] = 640'b0100011111101111101111111000000000000000011111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000001100010000001110000001110010010000000000000000010000000001100010000000000000000111001111111111111111111111111111111111111111111111111100000111111111111111111111111111111000000000000000000000000011111111111111111111111111111111111111111111100000111111111111111110100011011111111111111111110011110011111110000000000000111100001110000000001000000010000000000000000000000000000011000000000001110001101001010000100000011111000000110011000000000001111111111101001000000000000000000000000000000000000000000000000;
back_3[411] = 640'b1111111111111111111111111011111111111111000100000000000011111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000001110001000000000000000000011000110010111000100000000000000000000000000000000111111111111111111110000000000111110011101111111111111110000000000000000000000000000111111111111111111111111111111111111111111111110011111111111111111111111111111111111111100011110010011000000010010000000110110011111111111111111111000000000000000000000000000000000000011000000000000110000011001010001011100010000111100111100100000000111111111000000000000000000000000000000000000000000000000000000000;
back_3[412] = 640'b1111111111111011111111111110111111101100011001110111111000001000000000000111111111111111111111111111111111111111111111111111111111111111111000000000000000000001100000000001000000000000100000000010001000000000000000000000000000000000010010000000000111111100000010000001100000011111111011111111000110000000000000000000011111111111111111111111111111111111111111111111111000000110111111111100011111111111111111111111101101110010000111001110001111001111011111111111111111111111100010100000000000000000000000000000011000100000000110011001101010000000000010011001111111111000000001011111110000000000000000000000000000000000000000000000000000000000;
back_3[413] = 640'b1111111111111111111111111111111111101110111111111111111111101111111111111000000000000001111111111111111111111111111111111111111111111111111111111111111110000000000000000000000010000000000000000000001000000011000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000011111111111111111111111111111111111111111111111111111100000111111111111001111111111111111111110011111111100011000000100000001101111111111111111111111111111111111111110100100000000000001111111111110111010100000000111000100000100011100000010111111011100000000000111111111000000000000000000000000000000000000000000000000000000000000;
back_3[414] = 640'b1111111111101111001100110111101111101110001111111111001110011100111101111111111110111111111110000000000000111111111111111111111111111111111111111111111111111111111111111111100000000000000001111111000000010010000000000000000000000000000000000000000000000000010000000000000000010000000000000000000000000011111111111111111111111111111111111111111111111111111111111000000011111111111111111111111011111111111110001110011111111101000000011011111111111111111111111111111111100000000000100000000000000000000000000011101010100000000001000100111010100000011111111111101100000000111111111000000000000000000000000000000000000000000000000000000000000000;
back_3[415] = 640'b0000000000001000011000110001100000000000000001101111000110001111011111111110011110111011000011111111111111110011000000001111111111111111111111111111111111111111111111111111111111111111111111000000000000011110001001000100000000000000000000000000000000000000000110000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111110000000001111111111111111111111111111111111100000110110111111110011000010111111111111111111111111111111111110000000000000000000000000000000000000000000101000100000001101011000001000111000111111111111000000000000111111111000000000000000000000000000000000000000000000000000000000000000;
back_3[416] = 640'b0000000000010000010000000000000000010000110001111111000010000000100111101111111111111111111111111111111111111111111111111000000010010000000011111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111000000000111111111100111111111111111111111111111111111110111111110011000110011111111111111111111111111111111000000000000000000110100000000000000000000000000101000100000000111000000000000111001000011111110000110000001101111111111000000000000000000000000000000000000000000000000000000000000;
back_3[417] = 640'b1111111111110000010000000000001100001000000000000000000000011000110011100111000100110111011111111111111111111111111111110111111111111111111111010000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000100000000000000000011010000000000000000111111111111111111111111111111111111111111111111111111111111111111100000000001111111111111111111111111111111111100100000111111111110011100010111111111111111111111111111111000000000000011000000010111010000000000000000000000000101010010000001110011010101011110110100000010111100000100001100111111011000000000000000000000000000000000000000000000000000000000000;
back_3[418] = 640'b1111111111111111111111111111111110000000000000000110000001000000000000000010000000011111101111111111111111111011111111111001111111011111111111101111111111111111000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000111111111111111111110111111111111111111111111111111111111100000100011111111111111111111111111111111110000000000000000000010111100000000000000000000001111100101101011001110000100100001001100110011110000000000011111110111110000000000000000000000000000000000000000000000000000000000000000;
back_3[419] = 640'b1111111111111111111111111111111111111111111111110000000010000001100001000011000000001100000000000111111111111111111111111111111111111111111111111111111111001111110111111111111110000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010011111111111111111111011111111111111111110000000111111111111111100100011111111111111111111111111111111111111111100000000000000010011011000000000000000000000000011010000111111010010101010101011010111110000000000000000111111111000000000000000000000000000000000000000000000000000000000000000000;
back_3[420] = 640'b1111111111111111111111111111111111111111111111111111111111111100000000110000000000000000110001010011111111011111111001101111110111111111111111011101111111111111111111101111110111101111101111000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010111111111111111111111111111111111111111111011111110111111111111110110111101011111111111111111111111111111111111111111111000000000011010110000000000000000000000000010011110000111110011010101001101111111111100100000000001111111111000000000000000000000000000000000000000000000000000000000000000000;
back_3[421] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111110000000000000001000010000000010100010100010111111111111111111111111110111111111111111111011111111111111111111111111111111111111110000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000010000111111111111111111111111111111111000001111111111111111111111111110000000000000000000000001111111111111111111111111111111111100000011011001010011111111100000000001010111000000010110111010001000011111111110010000000000001111111111000000000000000000000000000000000000000000000000000000000000000000;
back_3[422] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001111111111110001110001100001100001100100111111111111111111111111111100111111111111111101011111111111111111010111111011110111111111110111111111101000110000000000000000000000001111111111111111111111111111111111111111111111111111111111111100000000000000011011111111111111111111111111111111110001111111110110011111111110000111111111110000000000000000000000000000000011111111111111111111111101100011111111111000000111111111010010010000111110010011101101110011111100000010000000101111111100000000000000000000000000000000000000000000000000000000000000000000;
back_3[423] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000011000001000100000110000010000011001111011110111111101111110011111011111111111001111111110111111111110111111111101111111110110111111011110011111111111111111111111110100000000000001011101111111111111111111111111111111111111100000000000000111111111000011111111111111111111111000001111111110111111110011000000111000000000000101000011111110011111111111111111111111111111111111010010100111111110000001111111000110010111000000000100101001101000010011101110000010000011111111111000000000000000000000000000000000000000000000000000000000000000000000;
back_3[424] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000101100011000000101000011111111101100111111110001111111111111111111111100110001101111111111011111111011011001100111111111111011111111111111101111111111111111111110000000000000000001010000000011111111110000000000000111001111111111111110001111111111111111100000100111111111111111111110000111100011111100010111100000000000111111111111100000001111111111000010000101111101111111000000000000000100001000000000010111110001100001101110000010000001000011111111111110000000000000000000000000000000000000000000000000000000000000000000;
back_3[425] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010001000101011011011111100011101100111100111111111000100000000000011001111111111111110111110111011111111111111111111111001111111111111111111111111111011111111111001100111110000010000000001100000000000000011111111111001111111111111111111111111100001000111111111111111111111111111111111011001100011111111111111111010000000000000000000000000111111111110001110000111111111111111111000110100000000000000111001000100000110100111000000000000001111111111111000000000000000000000000000000000000000000000000000000000000000000;
back_3[426] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100011001000110000000110001000000100000000000001100001100100111100011000001000111111111111111111111111111111111111111111100111111111111111111111111111111111111000011111111111110011000001000111101111111001111111111111111111111111111101111011111111111111111111110111111111110011000001101011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111101000110111100110011001000000000000111111111110000000000000000000000000000000000000000000000000000000000000000000;
back_3[427] = 640'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000110011111100111000000010000000000000111000010000000000000111001111111111111001011111010001110111111111111111111111111111111111111111111111111111111111110000011111111110000111111111111111111111101110111101111111111111111110011111111111111111111111111111111010000000010111110011011111100000000010110001111111000110000000000000000000000000000000000000000000000000000000000001111011100000010001010010000000000000000111111111111110000000000000000000000000000000000000000000000000000000000000000000;
back_3[428] = 640'b0000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000100000000000000111100110100000000000000100011110001110001110000000000010001111111111111111111111111111001111111111111111111110111111101111110001111111111111111101111110001111111111111111111111111110111011111111111111111111111111111111011011000000011111111111111111111111111111111111111111111111100001111111111111111111111111111100000000000000000000000000000000111101111110010000000000001000101111111101010100000000000000000000000000000000000000000000000000000000000000000000000;
back_3[429] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001101000111000001000000000000111011111111111111000001111111011111110011111111110101110111111111111111111111111111111101111111111111111111111111111111111111011111111111011111111111111111111111111111111100000111111111111111111111111111111111111111111111111111111010011111111111111111111111111111111111111111100000111110000000111111101110001000000010000100011111101110000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[430] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000001100000000000001100001110010110000000001001111111000000000000100000000000111110111111111111101100000000101111111111111111111001111111111111000011111111111111111111111111111111111111011000001000111111111111111111111111111111111111111111111111111111111101011111111111111111111111111111111111111111111111111110000000111101001111110000000001110111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[431] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000001010000111111111110000000001001110111000000000000000001111100001100000111100000000000010111111111111011111101111111110111001111000011111100111111111111110111111111110000000000011111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111001111101110111111000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[432] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000001100011000000001000000000000000011111111100000000000000000000011110111111111111011001000000011011111111111111110111111111111111111111111111100000000000011111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111101011101010011111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[433] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000011001111110111110000000000111000011111111111111110001111011100000011111111111110000000000011111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111101111101110001111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[434] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111100000001100000011000000000000000101110000000001110111110010000111111111111111110000000000011111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111001111101101001110110000001011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[435] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111000000001100011111000000000000000000001010111111110011111111000000011111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111100111111111111111111111111111111111111001111101010011100000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[436] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010000000000000001111111000111100000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010011111111111111111111111111111111100010011101100011000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[437] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000010000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100001111111111111111111111111100001001000011101011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[438] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000111111111111111111111111111111110000101111111111111111111100011100100111011000111111110100011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[439] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000100010000111111111111111000000000001111111000100110111111010011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[440] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000010000000010111000000000000000000011111110111001111111100100011111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[441] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010101111111111111111111111111110111110000000011010100111011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[442] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000100111111111111111111111111111111111111111000000000111110000000110111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[443] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001100011111111111111111111111111111111111111000000000000000111110111111000001111111000000000000000000000000000000000000000000000000000000000000000000000000000;
back_3[444] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010110001111111111111001111111111111111111111111000000000000101111111111001111110110000011111111100000000000000000000000000000000000000000000000000000000000000;
back_3[445] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110101110111111111000011111000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111111111110000011111111100101101111100001110000000011111111111111111000000000000000000000000000000000000000000000000;
back_3[446] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011001111111111111000000111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011001100001111111111111111111111111111111111111111111111110000000000000011000000100000111100000000111111111111110011111111111111000000010000000000000000000000;
back_3[447] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011110000000110110101111111111111111111111111111111111111111111111111111111100011000000101111110000011110000001111111111111111111111111111111111111111111111000011111;
back_3[448] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011110000001001000011001001111111111111111111111111111111111111111111111111111111000010110110011111100001111000000111110000000000001111111111111110111011111111111111;
back_3[449] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100010010000011000010011111111111111111111111111111111111111111111110111000010110010011110000011110000010100000000000000000100000111111111111111001000011110;
back_3[450] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000111001010000000111111111111111111111111111111111111111111111111111111000001110011100011100000111100010100000000101100010100000101000000111011001111111111;
back_3[451] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111011000000111101111111111111111111111111111111111111111111111111111000000111111111101011000000100001000000011000111100010000100000001011111000111111001;
back_3[452] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011001001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000111011001101101111111111111111111111111111111111111111111111111000111000000111000000101101110000100001000000000111100000000101000100010101110110011111101;
back_3[453] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111111111111111111111110110000011001010011111111111111111111111111111111111111111111111110111000000000110111111101100011110100000000000011000000011011001001001101111111101001111001;
back_3[454] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001100000111110101111111111111001110011000001001111111111111111111111111111111111111111111110001100000000000110111111011100000100100000000010100000000000001001000000000000001110011111001;
back_3[455] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111111111111100101110100000101111111111111111111111111111111111111111111100000000000001111110011000011100011100111000000010100000000011110000000000110110000011100111101;
back_3[456] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111010110001001111111111111111111111111111111111111111111100000000000111111110000000001111111110100000011001000000000000000010000000000110000001001111111;
back_3[457] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111001000101111111111111111111111111111111111100011100000011110001010110100000001011111010100000000000000001000010000000000000000001000001101100001;
back_3[458] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011111111010101111111111111111111111111111111111100011001100011010100010110111100001101111110100000000101000000010001111100000000000110110000101100001;
back_3[459] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111000001111011111111111010111111111111111111111111111111111111111111111111111111110100010010011110110000000001011100010101111110100000001010100000001000000000010110101000111101;
back_3[460] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110100000011111110100110110110001111111111111111111111111111111111111111111111111111111101100111011000000110111001000110100010110000001100111110001010000001000000000110100001100111101;
back_3[461] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100001110010111111000010001111111111111111111111111111111111111111111111111111111111110111011000000110111111000110011100001111110001000010000001111100001000000110111111000111111;
back_3[462] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111011110010100111011111111111111111111111111111111111111111111111111111111110111110000000110111111011001011100000000001000000001011010100000000000000110011111000111111;
back_3[463] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000011111011111111111111111111111111111111111111111111111111100011110000000111111111100100001100001110001001000000000100000000000000000100000001100111101;
back_3[464] = 640'b1111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111110110000000000000111011111000000110100001110001000100000011000000000000000000100000001100101001;
back_3[465] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000010111011111000000011100001100001010100000000000000101000000000100010001100101101;
back_3[466] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111000000000011110101110000000000111100000000001011011011110000001010000000000110110001100111111;
back_3[467] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011100000001000110100111000000000111110000100001010100010000001000101000000000110010001100111111;
back_3[468] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001111111111111111100011000000000000000000000000100011000111100010010100000000000000000000111111;
back_3[469] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000011111100011000010011000001010000110111111110100000101111110101101001111111111111111111111111;
back_3[470] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000111111111000000000011100000000000000000000000000000001110011111111111111111111111111111;
back_3[471] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000011111111110000001111111000000000000000000000000000000001110111111111111111111111111111;
back_3[472] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010000000000000111111111000001111111110000000000000000000000000000111111111111111111111111111111111;
back_3[473] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010000000000000001111111100000000111111000000000000000000000001111111111111111111111111111111111111;
back_3[474] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000011111111000000111111100000000000000000000111111111111111111111111111111111111111;
back_3[475] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000011111111100000001111110000000000000000000000000001111111111111111111111111111111;
back_3[476] = 640'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001000000000001111111111000000000111111000000000000000000000000000000000001111111111111111111111;
back_3[477] = 640'b0011111001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000011111111100000011111111111000000000000000000000000000000000001000011111111111111;
back_3[478] = 640'b0011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000001111111110000011111111111000000000000000000000000000000000000000000000001001101;
back_3[479] = 640'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100000000000001111111111111000011111100000000010000011011000000001100111111111111111111111111111;


back_4[  0] = 640'b1111111111111100000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111011101101101011101110011100100010010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111111111;
back_4[  1] = 640'b1111111111111101000000000000000000000000000000011100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000011100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010001111111111111111111111111111111111111111;
back_4[  2] = 640'b1111111001111000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011101001000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111111111111;
back_4[  3] = 640'b1111111010100000000000000000000000000000010101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010001000000000110000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111;
back_4[  4] = 640'b1111111110000000000000000000000000000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110001110001010000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111011111111111111111111111111111111111;
back_4[  5] = 640'b1111110100000000000000000000000000000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000110100000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111111;
back_4[  6] = 640'b1111111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111001011100010001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111111111111111111111111111111111111;
back_4[  7] = 640'b1111100000000000000000000000000000000011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010011010000001011011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111011111111111111111111111111111111;
back_4[  8] = 640'b1101001000000000000000000000000000000111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000001010100010101001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111;
back_4[  9] = 640'b1110000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101001101110110111100110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000111011111111111111111111111111111111;
back_4[ 10] = 640'b1111000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111111000000001100100001110001000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111111111111111111111111111;
back_4[ 11] = 640'b1110000000000000000000000000000000111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010100010000010000000111111001000000100000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111011111111111111111111111111111;
back_4[ 12] = 640'b1010100000000000000000000000000000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000100000000000001000001111110001000000000010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111;
back_4[ 13] = 640'b1100000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000111000001110101011110110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001111111111111111111111111111111;
back_4[ 14] = 640'b1000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000100010111011011000000001111010000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101011111111111111111111111111111;
back_4[ 15] = 640'b0000000000000000000000000000000001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000010000000000010000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111;
back_4[ 16] = 640'b0000000000000000000000000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000010000000000000000010111011010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111;
back_4[ 17] = 640'b0000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111011111011110000000000000000010000000000000010000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010111111111111111111111111111;
back_4[ 18] = 640'b0000000000000000000000000001111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111110101100000000000000000000100000010110011000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010011010111111111111111111111;
back_4[ 19] = 640'b0000000000000000000000000011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111101110101100000000010000000010000001110111101101000000000000001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110111111111111111111111;
back_4[ 20] = 640'b0000000000000000000000000111101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100110011100000110110100000000111000110110001011111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111;
back_4[ 21] = 640'b0000000000000000000000001101001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000010111111111111000000000101011011100000011101011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111;
back_4[ 22] = 640'b0000000000000000000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100100011111101100010100000010011111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011010111111111111111111;
back_4[ 23] = 640'b0000000000000000000000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110010111001111100010000000000001110000000000000000000000101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111;
back_4[ 24] = 640'b0000000000000000000001110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101111100000011010101111010000000101111101000000000000000011001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000011101111111111111111;
back_4[ 25] = 640'b0000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111011111100000011110000000001111001000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000001111111111111111111;
back_4[ 26] = 640'b0000000000000000000110011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011101100011011111100000000110000000001110000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111;
back_4[ 27] = 640'b0000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101101010100000010000000001111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101111111111111;
back_4[ 28] = 640'b0000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100101011110100000000110000000000101000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111111;
back_4[ 29] = 640'b0000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101000001111000000000000000000000000111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111111111;
back_4[ 30] = 640'b0000000000000011101111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111111111;
back_4[ 31] = 640'b0000000000000111011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101111111101000000110011000000100000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111;
back_4[ 32] = 640'b0000000000011001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111;
back_4[ 33] = 640'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111;
back_4[ 34] = 640'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111101100010111111111111111100000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011011111111;
back_4[ 35] = 640'b0000000110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010111111101011111111111111111110000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111110;
back_4[ 36] = 640'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111101111111100011100000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110111110;
back_4[ 37] = 640'b0000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111110110011111110101101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111110;
back_4[ 38] = 640'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101001111111100000000101101010000000000000000001011111111111111111111111001010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111110;
back_4[ 39] = 640'b0001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000011110011011000000000001111101000000000000000101111111111111111111111111111110110110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011110;
back_4[ 40] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111100000010010101000000000000010110111111111111111111111111111111111111101111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110;
back_4[ 41] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011011101111101101110100001111111110000000000011011111011011111111111110111111111111011111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110;
back_4[ 42] = 640'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111001101000011111111111000000001001011011011001100110111011001101101110111111111111111111111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000