//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Legal Notice: (C)2012 Altera Corporation. All rights reserved.  Your
//use of Altera Corporation's design tools, logic functions and other
//software and tools, and its AMPP partner logic functions, and any
//output files any of the foregoing (including device programming or
//simulation files), and any associated documentation or information are
//expressly subject to the terms and conditions of the Altera Program
//License Subscription Agreement or other applicable license agreement,
//including, without limitation, that your use is for the sole purpose
//of programming logic devices manufactured by Altera and sold by Altera
//or its authorized distributors.  Please refer to the applicable
//agreement for further details.

// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module DM9000A_avalonS_arbitrator (
                                    // inputs:
                                     DM9000A_avalonS_irq,
                                     DM9000A_avalonS_readdata,
                                     clk,
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_latency_counter,
                                     cpu_data_master_read,
                                     cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     reset_n,

                                    // outputs:
                                     DM9000A_avalonS_address,
                                     DM9000A_avalonS_chipselect_n,
                                     DM9000A_avalonS_irq_from_sa,
                                     DM9000A_avalonS_read_n,
                                     DM9000A_avalonS_readdata_from_sa,
                                     DM9000A_avalonS_reset_n,
                                     DM9000A_avalonS_wait_counter_eq_0,
                                     DM9000A_avalonS_write_n,
                                     DM9000A_avalonS_writedata,
                                     cpu_data_master_granted_DM9000A_avalonS,
                                     cpu_data_master_qualified_request_DM9000A_avalonS,
                                     cpu_data_master_read_data_valid_DM9000A_avalonS,
                                     cpu_data_master_requests_DM9000A_avalonS,
                                     d1_DM9000A_avalonS_end_xfer
                                  )
;

  output           DM9000A_avalonS_address;
  output           DM9000A_avalonS_chipselect_n;
  output           DM9000A_avalonS_irq_from_sa;
  output           DM9000A_avalonS_read_n;
  output  [ 15: 0] DM9000A_avalonS_readdata_from_sa;
  output           DM9000A_avalonS_reset_n;
  output           DM9000A_avalonS_wait_counter_eq_0;
  output           DM9000A_avalonS_write_n;
  output  [ 15: 0] DM9000A_avalonS_writedata;
  output           cpu_data_master_granted_DM9000A_avalonS;
  output           cpu_data_master_qualified_request_DM9000A_avalonS;
  output           cpu_data_master_read_data_valid_DM9000A_avalonS;
  output           cpu_data_master_requests_DM9000A_avalonS;
  output           d1_DM9000A_avalonS_end_xfer;
  input            DM9000A_avalonS_irq;
  input   [ 15: 0] DM9000A_avalonS_readdata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input            reset_n;

  wire             DM9000A_avalonS_address;
  wire             DM9000A_avalonS_allgrants;
  wire             DM9000A_avalonS_allow_new_arb_cycle;
  wire             DM9000A_avalonS_any_bursting_master_saved_grant;
  wire             DM9000A_avalonS_any_continuerequest;
  wire             DM9000A_avalonS_arb_counter_enable;
  reg     [  1: 0] DM9000A_avalonS_arb_share_counter;
  wire    [  1: 0] DM9000A_avalonS_arb_share_counter_next_value;
  wire    [  1: 0] DM9000A_avalonS_arb_share_set_values;
  wire             DM9000A_avalonS_beginbursttransfer_internal;
  wire             DM9000A_avalonS_begins_xfer;
  wire             DM9000A_avalonS_chipselect_n;
  wire             DM9000A_avalonS_counter_load_value;
  wire             DM9000A_avalonS_end_xfer;
  wire             DM9000A_avalonS_firsttransfer;
  wire             DM9000A_avalonS_grant_vector;
  wire             DM9000A_avalonS_in_a_read_cycle;
  wire             DM9000A_avalonS_in_a_write_cycle;
  wire             DM9000A_avalonS_irq_from_sa;
  wire             DM9000A_avalonS_master_qreq_vector;
  wire             DM9000A_avalonS_non_bursting_master_requests;
  wire             DM9000A_avalonS_read_n;
  wire    [ 15: 0] DM9000A_avalonS_readdata_from_sa;
  reg              DM9000A_avalonS_reg_firsttransfer;
  wire             DM9000A_avalonS_reset_n;
  reg              DM9000A_avalonS_slavearbiterlockenable;
  wire             DM9000A_avalonS_slavearbiterlockenable2;
  wire             DM9000A_avalonS_unreg_firsttransfer;
  reg              DM9000A_avalonS_wait_counter;
  wire             DM9000A_avalonS_wait_counter_eq_0;
  wire             DM9000A_avalonS_waits_for_read;
  wire             DM9000A_avalonS_waits_for_write;
  wire             DM9000A_avalonS_write_n;
  wire    [ 15: 0] DM9000A_avalonS_writedata;
  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_DM9000A_avalonS;
  wire             cpu_data_master_qualified_request_DM9000A_avalonS;
  wire             cpu_data_master_read_data_valid_DM9000A_avalonS;
  wire             cpu_data_master_requests_DM9000A_avalonS;
  wire             cpu_data_master_saved_grant_DM9000A_avalonS;
  reg              d1_DM9000A_avalonS_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_DM9000A_avalonS;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 25: 0] shifted_address_to_DM9000A_avalonS_from_cpu_data_master;
  wire             wait_for_DM9000A_avalonS_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~DM9000A_avalonS_end_xfer;
    end


  assign DM9000A_avalonS_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_DM9000A_avalonS));
  //assign DM9000A_avalonS_readdata_from_sa = DM9000A_avalonS_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign DM9000A_avalonS_readdata_from_sa = DM9000A_avalonS_readdata;

  assign cpu_data_master_requests_DM9000A_avalonS = ({cpu_data_master_address_to_slave[25 : 3] , 3'b0} == 26'h60) & (cpu_data_master_read | cpu_data_master_write);
  //DM9000A_avalonS_arb_share_counter set values, which is an e_mux
  assign DM9000A_avalonS_arb_share_set_values = 1;

  //DM9000A_avalonS_non_bursting_master_requests mux, which is an e_mux
  assign DM9000A_avalonS_non_bursting_master_requests = cpu_data_master_requests_DM9000A_avalonS;

  //DM9000A_avalonS_any_bursting_master_saved_grant mux, which is an e_mux
  assign DM9000A_avalonS_any_bursting_master_saved_grant = 0;

  //DM9000A_avalonS_arb_share_counter_next_value assignment, which is an e_assign
  assign DM9000A_avalonS_arb_share_counter_next_value = DM9000A_avalonS_firsttransfer ? (DM9000A_avalonS_arb_share_set_values - 1) : |DM9000A_avalonS_arb_share_counter ? (DM9000A_avalonS_arb_share_counter - 1) : 0;

  //DM9000A_avalonS_allgrants all slave grants, which is an e_mux
  assign DM9000A_avalonS_allgrants = |DM9000A_avalonS_grant_vector;

  //DM9000A_avalonS_end_xfer assignment, which is an e_assign
  assign DM9000A_avalonS_end_xfer = ~(DM9000A_avalonS_waits_for_read | DM9000A_avalonS_waits_for_write);

  //end_xfer_arb_share_counter_term_DM9000A_avalonS arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_DM9000A_avalonS = DM9000A_avalonS_end_xfer & (~DM9000A_avalonS_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //DM9000A_avalonS_arb_share_counter arbitration counter enable, which is an e_assign
  assign DM9000A_avalonS_arb_counter_enable = (end_xfer_arb_share_counter_term_DM9000A_avalonS & DM9000A_avalonS_allgrants) | (end_xfer_arb_share_counter_term_DM9000A_avalonS & ~DM9000A_avalonS_non_bursting_master_requests);

  //DM9000A_avalonS_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          DM9000A_avalonS_arb_share_counter <= 0;
      else if (DM9000A_avalonS_arb_counter_enable)
          DM9000A_avalonS_arb_share_counter <= DM9000A_avalonS_arb_share_counter_next_value;
    end


  //DM9000A_avalonS_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          DM9000A_avalonS_slavearbiterlockenable <= 0;
      else if ((|DM9000A_avalonS_master_qreq_vector & end_xfer_arb_share_counter_term_DM9000A_avalonS) | (end_xfer_arb_share_counter_term_DM9000A_avalonS & ~DM9000A_avalonS_non_bursting_master_requests))
          DM9000A_avalonS_slavearbiterlockenable <= |DM9000A_avalonS_arb_share_counter_next_value;
    end


  //cpu/data_master DM9000A/avalonS arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = DM9000A_avalonS_slavearbiterlockenable & cpu_data_master_continuerequest;

  //DM9000A_avalonS_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign DM9000A_avalonS_slavearbiterlockenable2 = |DM9000A_avalonS_arb_share_counter_next_value;

  //cpu/data_master DM9000A/avalonS arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = DM9000A_avalonS_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //DM9000A_avalonS_any_continuerequest at least one master continues requesting, which is an e_assign
  assign DM9000A_avalonS_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_DM9000A_avalonS = cpu_data_master_requests_DM9000A_avalonS & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_DM9000A_avalonS, which is an e_mux
  assign cpu_data_master_read_data_valid_DM9000A_avalonS = cpu_data_master_granted_DM9000A_avalonS & cpu_data_master_read & ~DM9000A_avalonS_waits_for_read;

  //DM9000A_avalonS_writedata mux, which is an e_mux
  assign DM9000A_avalonS_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_DM9000A_avalonS = cpu_data_master_qualified_request_DM9000A_avalonS;

  //cpu/data_master saved-grant DM9000A/avalonS, which is an e_assign
  assign cpu_data_master_saved_grant_DM9000A_avalonS = cpu_data_master_requests_DM9000A_avalonS;

  //allow new arb cycle for DM9000A/avalonS, which is an e_assign
  assign DM9000A_avalonS_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign DM9000A_avalonS_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign DM9000A_avalonS_master_qreq_vector = 1;

  //DM9000A_avalonS_reset_n assignment, which is an e_assign
  assign DM9000A_avalonS_reset_n = reset_n;

  assign DM9000A_avalonS_chipselect_n = ~cpu_data_master_granted_DM9000A_avalonS;
  //DM9000A_avalonS_firsttransfer first transaction, which is an e_assign
  assign DM9000A_avalonS_firsttransfer = DM9000A_avalonS_begins_xfer ? DM9000A_avalonS_unreg_firsttransfer : DM9000A_avalonS_reg_firsttransfer;

  //DM9000A_avalonS_unreg_firsttransfer first transaction, which is an e_assign
  assign DM9000A_avalonS_unreg_firsttransfer = ~(DM9000A_avalonS_slavearbiterlockenable & DM9000A_avalonS_any_continuerequest);

  //DM9000A_avalonS_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          DM9000A_avalonS_reg_firsttransfer <= 1'b1;
      else if (DM9000A_avalonS_begins_xfer)
          DM9000A_avalonS_reg_firsttransfer <= DM9000A_avalonS_unreg_firsttransfer;
    end


  //DM9000A_avalonS_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign DM9000A_avalonS_beginbursttransfer_internal = DM9000A_avalonS_begins_xfer;

  //~DM9000A_avalonS_read_n assignment, which is an e_mux
  assign DM9000A_avalonS_read_n = ~(((cpu_data_master_granted_DM9000A_avalonS & cpu_data_master_read))& ~DM9000A_avalonS_begins_xfer);

  //~DM9000A_avalonS_write_n assignment, which is an e_mux
  assign DM9000A_avalonS_write_n = ~(((cpu_data_master_granted_DM9000A_avalonS & cpu_data_master_write)) & ~DM9000A_avalonS_begins_xfer & (DM9000A_avalonS_wait_counter >= 1));

  assign shifted_address_to_DM9000A_avalonS_from_cpu_data_master = cpu_data_master_address_to_slave;
  //DM9000A_avalonS_address mux, which is an e_mux
  assign DM9000A_avalonS_address = shifted_address_to_DM9000A_avalonS_from_cpu_data_master >> 2;

  //d1_DM9000A_avalonS_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_DM9000A_avalonS_end_xfer <= 1;
      else 
        d1_DM9000A_avalonS_end_xfer <= DM9000A_avalonS_end_xfer;
    end


  //DM9000A_avalonS_waits_for_read in a cycle, which is an e_mux
  assign DM9000A_avalonS_waits_for_read = DM9000A_avalonS_in_a_read_cycle & DM9000A_avalonS_begins_xfer;

  //DM9000A_avalonS_in_a_read_cycle assignment, which is an e_assign
  assign DM9000A_avalonS_in_a_read_cycle = cpu_data_master_granted_DM9000A_avalonS & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = DM9000A_avalonS_in_a_read_cycle;

  //DM9000A_avalonS_waits_for_write in a cycle, which is an e_mux
  assign DM9000A_avalonS_waits_for_write = DM9000A_avalonS_in_a_write_cycle & wait_for_DM9000A_avalonS_counter;

  //DM9000A_avalonS_in_a_write_cycle assignment, which is an e_assign
  assign DM9000A_avalonS_in_a_write_cycle = cpu_data_master_granted_DM9000A_avalonS & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = DM9000A_avalonS_in_a_write_cycle;

  assign DM9000A_avalonS_wait_counter_eq_0 = DM9000A_avalonS_wait_counter == 0;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          DM9000A_avalonS_wait_counter <= 0;
      else 
        DM9000A_avalonS_wait_counter <= DM9000A_avalonS_counter_load_value;
    end


  assign DM9000A_avalonS_counter_load_value = ((DM9000A_avalonS_in_a_write_cycle & DM9000A_avalonS_begins_xfer))? 1 :
    (~DM9000A_avalonS_wait_counter_eq_0)? DM9000A_avalonS_wait_counter - 1 :
    0;

  assign wait_for_DM9000A_avalonS_counter = DM9000A_avalonS_begins_xfer | ~DM9000A_avalonS_wait_counter_eq_0;
  //assign DM9000A_avalonS_irq_from_sa = DM9000A_avalonS_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign DM9000A_avalonS_irq_from_sa = DM9000A_avalonS_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //DM9000A/avalonS enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_jtag_debug_module_arbitrator (
                                          // inputs:
                                           clk,
                                           cpu_data_master_address_to_slave,
                                           cpu_data_master_byteenable,
                                           cpu_data_master_debugaccess,
                                           cpu_data_master_latency_counter,
                                           cpu_data_master_read,
                                           cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                           cpu_data_master_write,
                                           cpu_data_master_writedata,
                                           cpu_instruction_master_address_to_slave,
                                           cpu_instruction_master_latency_counter,
                                           cpu_instruction_master_read,
                                           cpu_instruction_master_read_data_valid_sdram_s1_shift_register,
                                           cpu_jtag_debug_module_readdata,
                                           cpu_jtag_debug_module_resetrequest,
                                           reset_n,

                                          // outputs:
                                           cpu_data_master_granted_cpu_jtag_debug_module,
                                           cpu_data_master_qualified_request_cpu_jtag_debug_module,
                                           cpu_data_master_read_data_valid_cpu_jtag_debug_module,
                                           cpu_data_master_requests_cpu_jtag_debug_module,
                                           cpu_instruction_master_granted_cpu_jtag_debug_module,
                                           cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
                                           cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
                                           cpu_instruction_master_requests_cpu_jtag_debug_module,
                                           cpu_jtag_debug_module_address,
                                           cpu_jtag_debug_module_begintransfer,
                                           cpu_jtag_debug_module_byteenable,
                                           cpu_jtag_debug_module_chipselect,
                                           cpu_jtag_debug_module_debugaccess,
                                           cpu_jtag_debug_module_readdata_from_sa,
                                           cpu_jtag_debug_module_reset_n,
                                           cpu_jtag_debug_module_resetrequest_from_sa,
                                           cpu_jtag_debug_module_write,
                                           cpu_jtag_debug_module_writedata,
                                           d1_cpu_jtag_debug_module_end_xfer
                                        )
;

  output           cpu_data_master_granted_cpu_jtag_debug_module;
  output           cpu_data_master_qualified_request_cpu_jtag_debug_module;
  output           cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  output           cpu_data_master_requests_cpu_jtag_debug_module;
  output           cpu_instruction_master_granted_cpu_jtag_debug_module;
  output           cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  output           cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  output           cpu_instruction_master_requests_cpu_jtag_debug_module;
  output  [  8: 0] cpu_jtag_debug_module_address;
  output           cpu_jtag_debug_module_begintransfer;
  output  [  3: 0] cpu_jtag_debug_module_byteenable;
  output           cpu_jtag_debug_module_chipselect;
  output           cpu_jtag_debug_module_debugaccess;
  output  [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  output           cpu_jtag_debug_module_reset_n;
  output           cpu_jtag_debug_module_resetrequest_from_sa;
  output           cpu_jtag_debug_module_write;
  output  [ 31: 0] cpu_jtag_debug_module_writedata;
  output           d1_cpu_jtag_debug_module_end_xfer;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input   [  3: 0] cpu_data_master_byteenable;
  input            cpu_data_master_debugaccess;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 25: 0] cpu_instruction_master_address_to_slave;
  input            cpu_instruction_master_latency_counter;
  input            cpu_instruction_master_read;
  input            cpu_instruction_master_read_data_valid_sdram_s1_shift_register;
  input   [ 31: 0] cpu_jtag_debug_module_readdata;
  input            cpu_jtag_debug_module_resetrequest;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_cpu_jtag_debug_module;
  wire             cpu_data_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_data_master_requests_cpu_jtag_debug_module;
  wire             cpu_data_master_saved_grant_cpu_jtag_debug_module;
  wire             cpu_instruction_master_arbiterlock;
  wire             cpu_instruction_master_arbiterlock2;
  wire             cpu_instruction_master_continuerequest;
  wire             cpu_instruction_master_granted_cpu_jtag_debug_module;
  wire             cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_instruction_master_requests_cpu_jtag_debug_module;
  wire             cpu_instruction_master_saved_grant_cpu_jtag_debug_module;
  wire    [  8: 0] cpu_jtag_debug_module_address;
  wire             cpu_jtag_debug_module_allgrants;
  wire             cpu_jtag_debug_module_allow_new_arb_cycle;
  wire             cpu_jtag_debug_module_any_bursting_master_saved_grant;
  wire             cpu_jtag_debug_module_any_continuerequest;
  reg     [  1: 0] cpu_jtag_debug_module_arb_addend;
  wire             cpu_jtag_debug_module_arb_counter_enable;
  reg     [  1: 0] cpu_jtag_debug_module_arb_share_counter;
  wire    [  1: 0] cpu_jtag_debug_module_arb_share_counter_next_value;
  wire    [  1: 0] cpu_jtag_debug_module_arb_share_set_values;
  wire    [  1: 0] cpu_jtag_debug_module_arb_winner;
  wire             cpu_jtag_debug_module_arbitration_holdoff_internal;
  wire             cpu_jtag_debug_module_beginbursttransfer_internal;
  wire             cpu_jtag_debug_module_begins_xfer;
  wire             cpu_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_jtag_debug_module_byteenable;
  wire             cpu_jtag_debug_module_chipselect;
  wire    [  3: 0] cpu_jtag_debug_module_chosen_master_double_vector;
  wire    [  1: 0] cpu_jtag_debug_module_chosen_master_rot_left;
  wire             cpu_jtag_debug_module_debugaccess;
  wire             cpu_jtag_debug_module_end_xfer;
  wire             cpu_jtag_debug_module_firsttransfer;
  wire    [  1: 0] cpu_jtag_debug_module_grant_vector;
  wire             cpu_jtag_debug_module_in_a_read_cycle;
  wire             cpu_jtag_debug_module_in_a_write_cycle;
  wire    [  1: 0] cpu_jtag_debug_module_master_qreq_vector;
  wire             cpu_jtag_debug_module_non_bursting_master_requests;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  reg              cpu_jtag_debug_module_reg_firsttransfer;
  wire             cpu_jtag_debug_module_reset_n;
  wire             cpu_jtag_debug_module_resetrequest_from_sa;
  reg     [  1: 0] cpu_jtag_debug_module_saved_chosen_master_vector;
  reg              cpu_jtag_debug_module_slavearbiterlockenable;
  wire             cpu_jtag_debug_module_slavearbiterlockenable2;
  wire             cpu_jtag_debug_module_unreg_firsttransfer;
  wire             cpu_jtag_debug_module_waits_for_read;
  wire             cpu_jtag_debug_module_waits_for_write;
  wire             cpu_jtag_debug_module_write;
  wire    [ 31: 0] cpu_jtag_debug_module_writedata;
  reg              d1_cpu_jtag_debug_module_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_cpu_jtag_debug_module;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module;
  reg              last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module;
  wire    [ 25: 0] shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master;
  wire    [ 25: 0] shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master;
  wire             wait_for_cpu_jtag_debug_module_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~cpu_jtag_debug_module_end_xfer;
    end


  assign cpu_jtag_debug_module_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_cpu_jtag_debug_module | cpu_instruction_master_qualified_request_cpu_jtag_debug_module));
  //assign cpu_jtag_debug_module_readdata_from_sa = cpu_jtag_debug_module_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_jtag_debug_module_readdata_from_sa = cpu_jtag_debug_module_readdata;

  assign cpu_data_master_requests_cpu_jtag_debug_module = ({cpu_data_master_address_to_slave[25 : 11] , 11'b0} == 26'h800) & (cpu_data_master_read | cpu_data_master_write);
  //cpu_jtag_debug_module_arb_share_counter set values, which is an e_mux
  assign cpu_jtag_debug_module_arb_share_set_values = 1;

  //cpu_jtag_debug_module_non_bursting_master_requests mux, which is an e_mux
  assign cpu_jtag_debug_module_non_bursting_master_requests = cpu_data_master_requests_cpu_jtag_debug_module |
    cpu_instruction_master_requests_cpu_jtag_debug_module |
    cpu_data_master_requests_cpu_jtag_debug_module |
    cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu_jtag_debug_module_any_bursting_master_saved_grant mux, which is an e_mux
  assign cpu_jtag_debug_module_any_bursting_master_saved_grant = 0;

  //cpu_jtag_debug_module_arb_share_counter_next_value assignment, which is an e_assign
  assign cpu_jtag_debug_module_arb_share_counter_next_value = cpu_jtag_debug_module_firsttransfer ? (cpu_jtag_debug_module_arb_share_set_values - 1) : |cpu_jtag_debug_module_arb_share_counter ? (cpu_jtag_debug_module_arb_share_counter - 1) : 0;

  //cpu_jtag_debug_module_allgrants all slave grants, which is an e_mux
  assign cpu_jtag_debug_module_allgrants = (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector);

  //cpu_jtag_debug_module_end_xfer assignment, which is an e_assign
  assign cpu_jtag_debug_module_end_xfer = ~(cpu_jtag_debug_module_waits_for_read | cpu_jtag_debug_module_waits_for_write);

  //end_xfer_arb_share_counter_term_cpu_jtag_debug_module arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_cpu_jtag_debug_module = cpu_jtag_debug_module_end_xfer & (~cpu_jtag_debug_module_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //cpu_jtag_debug_module_arb_share_counter arbitration counter enable, which is an e_assign
  assign cpu_jtag_debug_module_arb_counter_enable = (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & cpu_jtag_debug_module_allgrants) | (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & ~cpu_jtag_debug_module_non_bursting_master_requests);

  //cpu_jtag_debug_module_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_arb_share_counter <= 0;
      else if (cpu_jtag_debug_module_arb_counter_enable)
          cpu_jtag_debug_module_arb_share_counter <= cpu_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu_jtag_debug_module_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_slavearbiterlockenable <= 0;
      else if ((|cpu_jtag_debug_module_master_qreq_vector & end_xfer_arb_share_counter_term_cpu_jtag_debug_module) | (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & ~cpu_jtag_debug_module_non_bursting_master_requests))
          cpu_jtag_debug_module_slavearbiterlockenable <= |cpu_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu/data_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = cpu_jtag_debug_module_slavearbiterlockenable & cpu_data_master_continuerequest;

  //cpu_jtag_debug_module_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign cpu_jtag_debug_module_slavearbiterlockenable2 = |cpu_jtag_debug_module_arb_share_counter_next_value;

  //cpu/data_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = cpu_jtag_debug_module_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //cpu/instruction_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_instruction_master_arbiterlock = cpu_jtag_debug_module_slavearbiterlockenable & cpu_instruction_master_continuerequest;

  //cpu/instruction_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_instruction_master_arbiterlock2 = cpu_jtag_debug_module_slavearbiterlockenable2 & cpu_instruction_master_continuerequest;

  //cpu/instruction_master granted cpu/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= 0;
      else 
        last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= cpu_instruction_master_saved_grant_cpu_jtag_debug_module ? 1 : (cpu_jtag_debug_module_arbitration_holdoff_internal | ~cpu_instruction_master_requests_cpu_jtag_debug_module) ? 0 : last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module;
    end


  //cpu_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_instruction_master_continuerequest = last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module & cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu_jtag_debug_module_any_continuerequest at least one master continues requesting, which is an e_mux
  assign cpu_jtag_debug_module_any_continuerequest = cpu_instruction_master_continuerequest |
    cpu_data_master_continuerequest;

  assign cpu_data_master_qualified_request_cpu_jtag_debug_module = cpu_data_master_requests_cpu_jtag_debug_module & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))) | cpu_instruction_master_arbiterlock);
  //local readdatavalid cpu_data_master_read_data_valid_cpu_jtag_debug_module, which is an e_mux
  assign cpu_data_master_read_data_valid_cpu_jtag_debug_module = cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_read & ~cpu_jtag_debug_module_waits_for_read;

  //cpu_jtag_debug_module_writedata mux, which is an e_mux
  assign cpu_jtag_debug_module_writedata = cpu_data_master_writedata;

  assign cpu_instruction_master_requests_cpu_jtag_debug_module = (({cpu_instruction_master_address_to_slave[25 : 11] , 11'b0} == 26'h800) & (cpu_instruction_master_read)) & cpu_instruction_master_read;
  //cpu/data_master granted cpu/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= 0;
      else 
        last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= cpu_data_master_saved_grant_cpu_jtag_debug_module ? 1 : (cpu_jtag_debug_module_arbitration_holdoff_internal | ~cpu_data_master_requests_cpu_jtag_debug_module) ? 0 : last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module;
    end


  //cpu_data_master_continuerequest continued request, which is an e_mux
  assign cpu_data_master_continuerequest = last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module & cpu_data_master_requests_cpu_jtag_debug_module;

  assign cpu_instruction_master_qualified_request_cpu_jtag_debug_module = cpu_instruction_master_requests_cpu_jtag_debug_module & ~((cpu_instruction_master_read & ((cpu_instruction_master_latency_counter != 0) | (|cpu_instruction_master_read_data_valid_sdram_s1_shift_register))) | cpu_data_master_arbiterlock);
  //local readdatavalid cpu_instruction_master_read_data_valid_cpu_jtag_debug_module, which is an e_mux
  assign cpu_instruction_master_read_data_valid_cpu_jtag_debug_module = cpu_instruction_master_granted_cpu_jtag_debug_module & cpu_instruction_master_read & ~cpu_jtag_debug_module_waits_for_read;

  //allow new arb cycle for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_allow_new_arb_cycle = ~cpu_data_master_arbiterlock & ~cpu_instruction_master_arbiterlock;

  //cpu/instruction_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_master_qreq_vector[0] = cpu_instruction_master_qualified_request_cpu_jtag_debug_module;

  //cpu/instruction_master grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_instruction_master_granted_cpu_jtag_debug_module = cpu_jtag_debug_module_grant_vector[0];

  //cpu/instruction_master saved-grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_instruction_master_saved_grant_cpu_jtag_debug_module = cpu_jtag_debug_module_arb_winner[0] && cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu/data_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_master_qreq_vector[1] = cpu_data_master_qualified_request_cpu_jtag_debug_module;

  //cpu/data_master grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_data_master_granted_cpu_jtag_debug_module = cpu_jtag_debug_module_grant_vector[1];

  //cpu/data_master saved-grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_data_master_saved_grant_cpu_jtag_debug_module = cpu_jtag_debug_module_arb_winner[1] && cpu_data_master_requests_cpu_jtag_debug_module;

  //cpu/jtag_debug_module chosen-master double-vector, which is an e_assign
  assign cpu_jtag_debug_module_chosen_master_double_vector = {cpu_jtag_debug_module_master_qreq_vector, cpu_jtag_debug_module_master_qreq_vector} & ({~cpu_jtag_debug_module_master_qreq_vector, ~cpu_jtag_debug_module_master_qreq_vector} + cpu_jtag_debug_module_arb_addend);

  //stable onehot encoding of arb winner
  assign cpu_jtag_debug_module_arb_winner = (cpu_jtag_debug_module_allow_new_arb_cycle & | cpu_jtag_debug_module_grant_vector) ? cpu_jtag_debug_module_grant_vector : cpu_jtag_debug_module_saved_chosen_master_vector;

  //saved cpu_jtag_debug_module_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_saved_chosen_master_vector <= 0;
      else if (cpu_jtag_debug_module_allow_new_arb_cycle)
          cpu_jtag_debug_module_saved_chosen_master_vector <= |cpu_jtag_debug_module_grant_vector ? cpu_jtag_debug_module_grant_vector : cpu_jtag_debug_module_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign cpu_jtag_debug_module_grant_vector = {(cpu_jtag_debug_module_chosen_master_double_vector[1] | cpu_jtag_debug_module_chosen_master_double_vector[3]),
    (cpu_jtag_debug_module_chosen_master_double_vector[0] | cpu_jtag_debug_module_chosen_master_double_vector[2])};

  //cpu/jtag_debug_module chosen master rotated left, which is an e_assign
  assign cpu_jtag_debug_module_chosen_master_rot_left = (cpu_jtag_debug_module_arb_winner << 1) ? (cpu_jtag_debug_module_arb_winner << 1) : 1;

  //cpu/jtag_debug_module's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_arb_addend <= 1;
      else if (|cpu_jtag_debug_module_grant_vector)
          cpu_jtag_debug_module_arb_addend <= cpu_jtag_debug_module_end_xfer? cpu_jtag_debug_module_chosen_master_rot_left : cpu_jtag_debug_module_grant_vector;
    end


  assign cpu_jtag_debug_module_begintransfer = cpu_jtag_debug_module_begins_xfer;
  //cpu_jtag_debug_module_reset_n assignment, which is an e_assign
  assign cpu_jtag_debug_module_reset_n = reset_n;

  //assign cpu_jtag_debug_module_resetrequest_from_sa = cpu_jtag_debug_module_resetrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_jtag_debug_module_resetrequest_from_sa = cpu_jtag_debug_module_resetrequest;

  assign cpu_jtag_debug_module_chipselect = cpu_data_master_granted_cpu_jtag_debug_module | cpu_instruction_master_granted_cpu_jtag_debug_module;
  //cpu_jtag_debug_module_firsttransfer first transaction, which is an e_assign
  assign cpu_jtag_debug_module_firsttransfer = cpu_jtag_debug_module_begins_xfer ? cpu_jtag_debug_module_unreg_firsttransfer : cpu_jtag_debug_module_reg_firsttransfer;

  //cpu_jtag_debug_module_unreg_firsttransfer first transaction, which is an e_assign
  assign cpu_jtag_debug_module_unreg_firsttransfer = ~(cpu_jtag_debug_module_slavearbiterlockenable & cpu_jtag_debug_module_any_continuerequest);

  //cpu_jtag_debug_module_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_reg_firsttransfer <= 1'b1;
      else if (cpu_jtag_debug_module_begins_xfer)
          cpu_jtag_debug_module_reg_firsttransfer <= cpu_jtag_debug_module_unreg_firsttransfer;
    end


  //cpu_jtag_debug_module_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign cpu_jtag_debug_module_beginbursttransfer_internal = cpu_jtag_debug_module_begins_xfer;

  //cpu_jtag_debug_module_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign cpu_jtag_debug_module_arbitration_holdoff_internal = cpu_jtag_debug_module_begins_xfer & cpu_jtag_debug_module_firsttransfer;

  //cpu_jtag_debug_module_write assignment, which is an e_mux
  assign cpu_jtag_debug_module_write = cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_write;

  assign shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master = cpu_data_master_address_to_slave;
  //cpu_jtag_debug_module_address mux, which is an e_mux
  assign cpu_jtag_debug_module_address = (cpu_data_master_granted_cpu_jtag_debug_module)? (shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master >> 2) :
    (shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master >> 2);

  assign shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master = cpu_instruction_master_address_to_slave;
  //d1_cpu_jtag_debug_module_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_cpu_jtag_debug_module_end_xfer <= 1;
      else 
        d1_cpu_jtag_debug_module_end_xfer <= cpu_jtag_debug_module_end_xfer;
    end


  //cpu_jtag_debug_module_waits_for_read in a cycle, which is an e_mux
  assign cpu_jtag_debug_module_waits_for_read = cpu_jtag_debug_module_in_a_read_cycle & cpu_jtag_debug_module_begins_xfer;

  //cpu_jtag_debug_module_in_a_read_cycle assignment, which is an e_assign
  assign cpu_jtag_debug_module_in_a_read_cycle = (cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_read) | (cpu_instruction_master_granted_cpu_jtag_debug_module & cpu_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = cpu_jtag_debug_module_in_a_read_cycle;

  //cpu_jtag_debug_module_waits_for_write in a cycle, which is an e_mux
  assign cpu_jtag_debug_module_waits_for_write = cpu_jtag_debug_module_in_a_write_cycle & 0;

  //cpu_jtag_debug_module_in_a_write_cycle assignment, which is an e_assign
  assign cpu_jtag_debug_module_in_a_write_cycle = cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = cpu_jtag_debug_module_in_a_write_cycle;

  assign wait_for_cpu_jtag_debug_module_counter = 0;
  //cpu_jtag_debug_module_byteenable byte enable port mux, which is an e_mux
  assign cpu_jtag_debug_module_byteenable = (cpu_data_master_granted_cpu_jtag_debug_module)? cpu_data_master_byteenable :
    -1;

  //debugaccess mux, which is an e_mux
  assign cpu_jtag_debug_module_debugaccess = (cpu_data_master_granted_cpu_jtag_debug_module)? cpu_data_master_debugaccess :
    0;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu/jtag_debug_module enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_granted_cpu_jtag_debug_module + cpu_instruction_master_granted_cpu_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_saved_grant_cpu_jtag_debug_module + cpu_instruction_master_saved_grant_cpu_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_data_master_arbitrator (
                                    // inputs:
                                     DM9000A_avalonS_irq_from_sa,
                                     DM9000A_avalonS_readdata_from_sa,
                                     DM9000A_avalonS_wait_counter_eq_0,
                                     clk,
                                     cpu_data_master_address,
                                     cpu_data_master_byteenable,
                                     cpu_data_master_byteenable_sdram_s1,
                                     cpu_data_master_granted_DM9000A_avalonS,
                                     cpu_data_master_granted_cpu_jtag_debug_module,
                                     cpu_data_master_granted_jtag_uart_avalon_jtag_slave,
                                     cpu_data_master_granted_keyboardscancode_s1,
                                     cpu_data_master_granted_keycounter_s1,
                                     cpu_data_master_granted_outputsramdata_s1,
                                     cpu_data_master_granted_outputxcoord_s1,
                                     cpu_data_master_granted_outputycoord_s1,
                                     cpu_data_master_granted_pio_flag_s1,
                                     cpu_data_master_granted_scoreofplayer_s1,
                                     cpu_data_master_granted_sdram_s1,
                                     cpu_data_master_granted_uart1_s1,
                                     cpu_data_master_qualified_request_DM9000A_avalonS,
                                     cpu_data_master_qualified_request_cpu_jtag_debug_module,
                                     cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave,
                                     cpu_data_master_qualified_request_keyboardscancode_s1,
                                     cpu_data_master_qualified_request_keycounter_s1,
                                     cpu_data_master_qualified_request_outputsramdata_s1,
                                     cpu_data_master_qualified_request_outputxcoord_s1,
                                     cpu_data_master_qualified_request_outputycoord_s1,
                                     cpu_data_master_qualified_request_pio_flag_s1,
                                     cpu_data_master_qualified_request_scoreofplayer_s1,
                                     cpu_data_master_qualified_request_sdram_s1,
                                     cpu_data_master_qualified_request_uart1_s1,
                                     cpu_data_master_read,
                                     cpu_data_master_read_data_valid_DM9000A_avalonS,
                                     cpu_data_master_read_data_valid_cpu_jtag_debug_module,
                                     cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave,
                                     cpu_data_master_read_data_valid_keyboardscancode_s1,
                                     cpu_data_master_read_data_valid_keycounter_s1,
                                     cpu_data_master_read_data_valid_outputsramdata_s1,
                                     cpu_data_master_read_data_valid_outputxcoord_s1,
                                     cpu_data_master_read_data_valid_outputycoord_s1,
                                     cpu_data_master_read_data_valid_pio_flag_s1,
                                     cpu_data_master_read_data_valid_scoreofplayer_s1,
                                     cpu_data_master_read_data_valid_sdram_s1,
                                     cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                     cpu_data_master_read_data_valid_uart1_s1,
                                     cpu_data_master_requests_DM9000A_avalonS,
                                     cpu_data_master_requests_cpu_jtag_debug_module,
                                     cpu_data_master_requests_jtag_uart_avalon_jtag_slave,
                                     cpu_data_master_requests_keyboardscancode_s1,
                                     cpu_data_master_requests_keycounter_s1,
                                     cpu_data_master_requests_outputsramdata_s1,
                                     cpu_data_master_requests_outputxcoord_s1,
                                     cpu_data_master_requests_outputycoord_s1,
                                     cpu_data_master_requests_pio_flag_s1,
                                     cpu_data_master_requests_scoreofplayer_s1,
                                     cpu_data_master_requests_sdram_s1,
                                     cpu_data_master_requests_uart1_s1,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     cpu_jtag_debug_module_readdata_from_sa,
                                     d1_DM9000A_avalonS_end_xfer,
                                     d1_cpu_jtag_debug_module_end_xfer,
                                     d1_jtag_uart_avalon_jtag_slave_end_xfer,
                                     d1_keyboardscancode_s1_end_xfer,
                                     d1_keycounter_s1_end_xfer,
                                     d1_outputsramdata_s1_end_xfer,
                                     d1_outputxcoord_s1_end_xfer,
                                     d1_outputycoord_s1_end_xfer,
                                     d1_pio_flag_s1_end_xfer,
                                     d1_scoreofplayer_s1_end_xfer,
                                     d1_sdram_s1_end_xfer,
                                     d1_uart1_s1_end_xfer,
                                     jtag_uart_avalon_jtag_slave_irq_from_sa,
                                     jtag_uart_avalon_jtag_slave_readdata_from_sa,
                                     jtag_uart_avalon_jtag_slave_waitrequest_from_sa,
                                     keyboardscancode_s1_readdata_from_sa,
                                     keycounter_s1_readdata_from_sa,
                                     outputsramdata_s1_readdata_from_sa,
                                     outputxcoord_s1_readdata_from_sa,
                                     outputycoord_s1_readdata_from_sa,
                                     pio_flag_s1_readdata_from_sa,
                                     reset_n,
                                     scoreofplayer_s1_readdata_from_sa,
                                     sdram_s1_readdata_from_sa,
                                     sdram_s1_waitrequest_from_sa,
                                     uart1_s1_irq_from_sa,
                                     uart1_s1_readdata_from_sa,

                                    // outputs:
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_dbs_address,
                                     cpu_data_master_dbs_write_16,
                                     cpu_data_master_irq,
                                     cpu_data_master_latency_counter,
                                     cpu_data_master_readdata,
                                     cpu_data_master_readdatavalid,
                                     cpu_data_master_waitrequest
                                  )
;

  output  [ 25: 0] cpu_data_master_address_to_slave;
  output  [  1: 0] cpu_data_master_dbs_address;
  output  [ 15: 0] cpu_data_master_dbs_write_16;
  output  [ 31: 0] cpu_data_master_irq;
  output           cpu_data_master_latency_counter;
  output  [ 31: 0] cpu_data_master_readdata;
  output           cpu_data_master_readdatavalid;
  output           cpu_data_master_waitrequest;
  input            DM9000A_avalonS_irq_from_sa;
  input   [ 15: 0] DM9000A_avalonS_readdata_from_sa;
  input            DM9000A_avalonS_wait_counter_eq_0;
  input            clk;
  input   [ 25: 0] cpu_data_master_address;
  input   [  3: 0] cpu_data_master_byteenable;
  input   [  1: 0] cpu_data_master_byteenable_sdram_s1;
  input            cpu_data_master_granted_DM9000A_avalonS;
  input            cpu_data_master_granted_cpu_jtag_debug_module;
  input            cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  input            cpu_data_master_granted_keyboardscancode_s1;
  input            cpu_data_master_granted_keycounter_s1;
  input            cpu_data_master_granted_outputsramdata_s1;
  input            cpu_data_master_granted_outputxcoord_s1;
  input            cpu_data_master_granted_outputycoord_s1;
  input            cpu_data_master_granted_pio_flag_s1;
  input            cpu_data_master_granted_scoreofplayer_s1;
  input            cpu_data_master_granted_sdram_s1;
  input            cpu_data_master_granted_uart1_s1;
  input            cpu_data_master_qualified_request_DM9000A_avalonS;
  input            cpu_data_master_qualified_request_cpu_jtag_debug_module;
  input            cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  input            cpu_data_master_qualified_request_keyboardscancode_s1;
  input            cpu_data_master_qualified_request_keycounter_s1;
  input            cpu_data_master_qualified_request_outputsramdata_s1;
  input            cpu_data_master_qualified_request_outputxcoord_s1;
  input            cpu_data_master_qualified_request_outputycoord_s1;
  input            cpu_data_master_qualified_request_pio_flag_s1;
  input            cpu_data_master_qualified_request_scoreofplayer_s1;
  input            cpu_data_master_qualified_request_sdram_s1;
  input            cpu_data_master_qualified_request_uart1_s1;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_DM9000A_avalonS;
  input            cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  input            cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave;
  input            cpu_data_master_read_data_valid_keyboardscancode_s1;
  input            cpu_data_master_read_data_valid_keycounter_s1;
  input            cpu_data_master_read_data_valid_outputsramdata_s1;
  input            cpu_data_master_read_data_valid_outputxcoord_s1;
  input            cpu_data_master_read_data_valid_outputycoord_s1;
  input            cpu_data_master_read_data_valid_pio_flag_s1;
  input            cpu_data_master_read_data_valid_scoreofplayer_s1;
  input            cpu_data_master_read_data_valid_sdram_s1;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_read_data_valid_uart1_s1;
  input            cpu_data_master_requests_DM9000A_avalonS;
  input            cpu_data_master_requests_cpu_jtag_debug_module;
  input            cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  input            cpu_data_master_requests_keyboardscancode_s1;
  input            cpu_data_master_requests_keycounter_s1;
  input            cpu_data_master_requests_outputsramdata_s1;
  input            cpu_data_master_requests_outputxcoord_s1;
  input            cpu_data_master_requests_outputycoord_s1;
  input            cpu_data_master_requests_pio_flag_s1;
  input            cpu_data_master_requests_scoreofplayer_s1;
  input            cpu_data_master_requests_sdram_s1;
  input            cpu_data_master_requests_uart1_s1;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  input            d1_DM9000A_avalonS_end_xfer;
  input            d1_cpu_jtag_debug_module_end_xfer;
  input            d1_jtag_uart_avalon_jtag_slave_end_xfer;
  input            d1_keyboardscancode_s1_end_xfer;
  input            d1_keycounter_s1_end_xfer;
  input            d1_outputsramdata_s1_end_xfer;
  input            d1_outputxcoord_s1_end_xfer;
  input            d1_outputycoord_s1_end_xfer;
  input            d1_pio_flag_s1_end_xfer;
  input            d1_scoreofplayer_s1_end_xfer;
  input            d1_sdram_s1_end_xfer;
  input            d1_uart1_s1_end_xfer;
  input            jtag_uart_avalon_jtag_slave_irq_from_sa;
  input   [ 31: 0] jtag_uart_avalon_jtag_slave_readdata_from_sa;
  input            jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  input   [ 31: 0] keyboardscancode_s1_readdata_from_sa;
  input   [ 31: 0] keycounter_s1_readdata_from_sa;
  input   [ 31: 0] outputsramdata_s1_readdata_from_sa;
  input   [ 31: 0] outputxcoord_s1_readdata_from_sa;
  input   [ 31: 0] outputycoord_s1_readdata_from_sa;
  input   [ 31: 0] pio_flag_s1_readdata_from_sa;
  input            reset_n;
  input   [ 31: 0] scoreofplayer_s1_readdata_from_sa;
  input   [ 15: 0] sdram_s1_readdata_from_sa;
  input            sdram_s1_waitrequest_from_sa;
  input            uart1_s1_irq_from_sa;
  input   [ 15: 0] uart1_s1_readdata_from_sa;

  reg              active_and_waiting_last_time;
  reg     [ 25: 0] cpu_data_master_address_last_time;
  wire    [ 25: 0] cpu_data_master_address_to_slave;
  reg     [  3: 0] cpu_data_master_byteenable_last_time;
  reg     [  1: 0] cpu_data_master_dbs_address;
  wire    [  1: 0] cpu_data_master_dbs_increment;
  reg     [  1: 0] cpu_data_master_dbs_rdv_counter;
  wire    [  1: 0] cpu_data_master_dbs_rdv_counter_inc;
  wire    [ 15: 0] cpu_data_master_dbs_write_16;
  wire    [ 31: 0] cpu_data_master_irq;
  wire             cpu_data_master_is_granted_some_slave;
  reg              cpu_data_master_latency_counter;
  wire    [  1: 0] cpu_data_master_next_dbs_rdv_counter;
  reg              cpu_data_master_read_but_no_slave_selected;
  reg              cpu_data_master_read_last_time;
  wire    [ 31: 0] cpu_data_master_readdata;
  wire             cpu_data_master_readdatavalid;
  wire             cpu_data_master_run;
  wire             cpu_data_master_waitrequest;
  reg              cpu_data_master_write_last_time;
  reg     [ 31: 0] cpu_data_master_writedata_last_time;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  reg     [ 15: 0] dbs_latent_16_reg_segment_0;
  wire             dbs_rdv_count_enable;
  wire             dbs_rdv_counter_overflow;
  wire             latency_load_value;
  wire    [  1: 0] next_dbs_address;
  wire             p1_cpu_data_master_latency_counter;
  wire    [ 15: 0] p1_dbs_latent_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             pre_flush_cpu_data_master_readdatavalid;
  wire             r_0;
  wire             r_1;
  wire             r_2;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (cpu_data_master_qualified_request_DM9000A_avalonS | ~cpu_data_master_requests_DM9000A_avalonS) & ((~cpu_data_master_qualified_request_DM9000A_avalonS | ~cpu_data_master_read | (1 & ~d1_DM9000A_avalonS_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_DM9000A_avalonS | ~cpu_data_master_write | (1 & ((DM9000A_avalonS_wait_counter_eq_0 & ~d1_DM9000A_avalonS_end_xfer)) & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_requests_cpu_jtag_debug_module) & (cpu_data_master_granted_cpu_jtag_debug_module | ~cpu_data_master_qualified_request_cpu_jtag_debug_module) & ((~cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_read | (1 & ~d1_cpu_jtag_debug_module_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave | ~cpu_data_master_requests_jtag_uart_avalon_jtag_slave) & ((~cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave | ~(cpu_data_master_read | cpu_data_master_write) | (1 & ~jtag_uart_avalon_jtag_slave_waitrequest_from_sa & (cpu_data_master_read | cpu_data_master_write)))) & ((~cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave | ~(cpu_data_master_read | cpu_data_master_write) | (1 & ~jtag_uart_avalon_jtag_slave_waitrequest_from_sa & (cpu_data_master_read | cpu_data_master_write)))) & 1 & (cpu_data_master_qualified_request_keyboardscancode_s1 | ~cpu_data_master_requests_keyboardscancode_s1) & ((~cpu_data_master_qualified_request_keyboardscancode_s1 | ~cpu_data_master_read | (1 & ~d1_keyboardscancode_s1_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_keyboardscancode_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_keycounter_s1 | ~cpu_data_master_requests_keycounter_s1) & ((~cpu_data_master_qualified_request_keycounter_s1 | ~cpu_data_master_read | (1 & ~d1_keycounter_s1_end_xfer & cpu_data_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu_data_master_run = r_0 & r_1 & r_2;

  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = ((~cpu_data_master_qualified_request_keycounter_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_outputsramdata_s1 | ~cpu_data_master_requests_outputsramdata_s1) & ((~cpu_data_master_qualified_request_outputsramdata_s1 | ~cpu_data_master_read | (1 & ~d1_outputsramdata_s1_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_outputsramdata_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_outputxcoord_s1 | ~cpu_data_master_requests_outputxcoord_s1) & ((~cpu_data_master_qualified_request_outputxcoord_s1 | ~cpu_data_master_read | (1 & ~d1_outputxcoord_s1_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_outputxcoord_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_outputycoord_s1 | ~cpu_data_master_requests_outputycoord_s1) & ((~cpu_data_master_qualified_request_outputycoord_s1 | ~cpu_data_master_read | (1 & ~d1_outputycoord_s1_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_outputycoord_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_flag_s1 | ~cpu_data_master_requests_pio_flag_s1) & ((~cpu_data_master_qualified_request_pio_flag_s1 | ~cpu_data_master_read | (1 & ~d1_pio_flag_s1_end_xfer & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_flag_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_scoreofplayer_s1 | ~cpu_data_master_requests_scoreofplayer_s1) & ((~cpu_data_master_qualified_request_scoreofplayer_s1 | ~cpu_data_master_read | (1 & ~d1_scoreofplayer_s1_end_xfer & cpu_data_master_read)));

  //r_2 master_run cascaded wait assignment, which is an e_assign
  assign r_2 = ((~cpu_data_master_qualified_request_scoreofplayer_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_sdram_s1 | (cpu_data_master_write & !cpu_data_master_byteenable_sdram_s1 & cpu_data_master_dbs_address[1]) | ~cpu_data_master_requests_sdram_s1) & (cpu_data_master_granted_sdram_s1 | ~cpu_data_master_qualified_request_sdram_s1) & ((~cpu_data_master_qualified_request_sdram_s1 | ~cpu_data_master_read | (1 & ~sdram_s1_waitrequest_from_sa & (cpu_data_master_dbs_address[1]) & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_sdram_s1 | ~cpu_data_master_write | (1 & ~sdram_s1_waitrequest_from_sa & (cpu_data_master_dbs_address[1]) & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_uart1_s1 | ~cpu_data_master_requests_uart1_s1) & ((~cpu_data_master_qualified_request_uart1_s1 | ~(cpu_data_master_read | cpu_data_master_write) | (1 & ~d1_uart1_s1_end_xfer & (cpu_data_master_read | cpu_data_master_write)))) & ((~cpu_data_master_qualified_request_uart1_s1 | ~(cpu_data_master_read | cpu_data_master_write) | (1 & ~d1_uart1_s1_end_xfer & (cpu_data_master_read | cpu_data_master_write))));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_data_master_address_to_slave = {cpu_data_master_address[25],
    2'b0,
    cpu_data_master_address[22 : 0]};

  //cpu_data_master_read_but_no_slave_selected assignment, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_read_but_no_slave_selected <= 0;
      else 
        cpu_data_master_read_but_no_slave_selected <= cpu_data_master_read & cpu_data_master_run & ~cpu_data_master_is_granted_some_slave;
    end


  //some slave is getting selected, which is an e_mux
  assign cpu_data_master_is_granted_some_slave = cpu_data_master_granted_DM9000A_avalonS |
    cpu_data_master_granted_cpu_jtag_debug_module |
    cpu_data_master_granted_jtag_uart_avalon_jtag_slave |
    cpu_data_master_granted_keyboardscancode_s1 |
    cpu_data_master_granted_keycounter_s1 |
    cpu_data_master_granted_outputsramdata_s1 |
    cpu_data_master_granted_outputxcoord_s1 |
    cpu_data_master_granted_outputycoord_s1 |
    cpu_data_master_granted_pio_flag_s1 |
    cpu_data_master_granted_scoreofplayer_s1 |
    cpu_data_master_granted_sdram_s1 |
    cpu_data_master_granted_uart1_s1;

  //latent slave read data valids which may be flushed, which is an e_mux
  assign pre_flush_cpu_data_master_readdatavalid = cpu_data_master_read_data_valid_sdram_s1 & dbs_rdv_counter_overflow;

  //latent slave read data valid which is not flushed, which is an e_mux
  assign cpu_data_master_readdatavalid = cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_DM9000A_avalonS |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_cpu_jtag_debug_module |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_keyboardscancode_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_keycounter_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_outputsramdata_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_outputxcoord_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_outputycoord_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_pio_flag_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_scoreofplayer_s1 |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_but_no_slave_selected |
    pre_flush_cpu_data_master_readdatavalid |
    cpu_data_master_read_data_valid_uart1_s1;

  //cpu/data_master readdata mux, which is an e_mux
  assign cpu_data_master_readdata = ({32 {~(cpu_data_master_qualified_request_DM9000A_avalonS & cpu_data_master_read)}} | DM9000A_avalonS_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_cpu_jtag_debug_module & cpu_data_master_read)}} | cpu_jtag_debug_module_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave & cpu_data_master_read)}} | jtag_uart_avalon_jtag_slave_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_keyboardscancode_s1 & cpu_data_master_read)}} | keyboardscancode_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_keycounter_s1 & cpu_data_master_read)}} | keycounter_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_outputsramdata_s1 & cpu_data_master_read)}} | outputsramdata_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_outputxcoord_s1 & cpu_data_master_read)}} | outputxcoord_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_outputycoord_s1 & cpu_data_master_read)}} | outputycoord_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_pio_flag_s1 & cpu_data_master_read)}} | pio_flag_s1_readdata_from_sa) &
    ({32 {~(cpu_data_master_qualified_request_scoreofplayer_s1 & cpu_data_master_read)}} | scoreofplayer_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_read_data_valid_sdram_s1}} | {sdram_s1_readdata_from_sa[15 : 0],
    dbs_latent_16_reg_segment_0}) &
    ({32 {~(cpu_data_master_qualified_request_uart1_s1 & cpu_data_master_read)}} | uart1_s1_readdata_from_sa);

  //actual waitrequest port, which is an e_assign
  assign cpu_data_master_waitrequest = ~cpu_data_master_run;

  //latent max counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_latency_counter <= 0;
      else 
        cpu_data_master_latency_counter <= p1_cpu_data_master_latency_counter;
    end


  //latency counter load mux, which is an e_mux
  assign p1_cpu_data_master_latency_counter = ((cpu_data_master_run & cpu_data_master_read))? latency_load_value :
    (cpu_data_master_latency_counter)? cpu_data_master_latency_counter - 1 :
    0;

  //read latency load values, which is an e_mux
  assign latency_load_value = 0;

  //irq assign, which is an e_assign
  assign cpu_data_master_irq = {1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    DM9000A_avalonS_irq_from_sa,
    uart1_s1_irq_from_sa,
    jtag_uart_avalon_jtag_slave_irq_from_sa};

  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = (((~0) & cpu_data_master_requests_sdram_s1 & cpu_data_master_write & !cpu_data_master_byteenable_sdram_s1)) |
    (cpu_data_master_granted_sdram_s1 & cpu_data_master_read & 1 & 1 & ~sdram_s1_waitrequest_from_sa) |
    (cpu_data_master_granted_sdram_s1 & cpu_data_master_write & 1 & 1 & ~sdram_s1_waitrequest_from_sa);

  //input to latent dbs-16 stored 0, which is an e_mux
  assign p1_dbs_latent_16_reg_segment_0 = sdram_s1_readdata_from_sa;

  //dbs register for latent dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_latent_16_reg_segment_0 <= 0;
      else if (dbs_rdv_count_enable & ((cpu_data_master_dbs_rdv_counter[1]) == 0))
          dbs_latent_16_reg_segment_0 <= p1_dbs_latent_16_reg_segment_0;
    end


  //mux write dbs 1, which is an e_mux
  assign cpu_data_master_dbs_write_16 = (cpu_data_master_dbs_address[1])? cpu_data_master_writedata[31 : 16] :
    cpu_data_master_writedata[15 : 0];

  //dbs count increment, which is an e_mux
  assign cpu_data_master_dbs_increment = (cpu_data_master_requests_sdram_s1)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_data_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_data_master_dbs_address + cpu_data_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_data_master_dbs_address <= next_dbs_address;
    end


  //p1 dbs rdv counter, which is an e_assign
  assign cpu_data_master_next_dbs_rdv_counter = cpu_data_master_dbs_rdv_counter + cpu_data_master_dbs_rdv_counter_inc;

  //cpu_data_master_rdv_inc_mux, which is an e_mux
  assign cpu_data_master_dbs_rdv_counter_inc = 2;

  //master any slave rdv, which is an e_mux
  assign dbs_rdv_count_enable = cpu_data_master_read_data_valid_sdram_s1;

  //dbs rdv counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_dbs_rdv_counter <= 0;
      else if (dbs_rdv_count_enable)
          cpu_data_master_dbs_rdv_counter <= cpu_data_master_next_dbs_rdv_counter;
    end


  //dbs rdv counter overflow, which is an e_assign
  assign dbs_rdv_counter_overflow = cpu_data_master_dbs_rdv_counter[1] & ~cpu_data_master_next_dbs_rdv_counter[1];


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu_data_master_address check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_address_last_time <= 0;
      else 
        cpu_data_master_address_last_time <= cpu_data_master_address;
    end


  //cpu/data_master waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else 
        active_and_waiting_last_time <= cpu_data_master_waitrequest & (cpu_data_master_read | cpu_data_master_write);
    end


  //cpu_data_master_address matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_data_master_address != cpu_data_master_address_last_time))
        begin
          $write("%0d ns: cpu_data_master_address did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_data_master_byteenable check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_byteenable_last_time <= 0;
      else 
        cpu_data_master_byteenable_last_time <= cpu_data_master_byteenable;
    end


  //cpu_data_master_byteenable matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_data_master_byteenable != cpu_data_master_byteenable_last_time))
        begin
          $write("%0d ns: cpu_data_master_byteenable did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_data_master_read check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_read_last_time <= 0;
      else 
        cpu_data_master_read_last_time <= cpu_data_master_read;
    end


  //cpu_data_master_read matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_data_master_read != cpu_data_master_read_last_time))
        begin
          $write("%0d ns: cpu_data_master_read did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_data_master_write check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_write_last_time <= 0;
      else 
        cpu_data_master_write_last_time <= cpu_data_master_write;
    end


  //cpu_data_master_write matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_data_master_write != cpu_data_master_write_last_time))
        begin
          $write("%0d ns: cpu_data_master_write did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_data_master_writedata check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_writedata_last_time <= 0;
      else 
        cpu_data_master_writedata_last_time <= cpu_data_master_writedata;
    end


  //cpu_data_master_writedata matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_data_master_writedata != cpu_data_master_writedata_last_time) & cpu_data_master_write)
        begin
          $write("%0d ns: cpu_data_master_writedata did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_instruction_master_arbitrator (
                                           // inputs:
                                            clk,
                                            cpu_instruction_master_address,
                                            cpu_instruction_master_granted_cpu_jtag_debug_module,
                                            cpu_instruction_master_granted_sdram_s1,
                                            cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
                                            cpu_instruction_master_qualified_request_sdram_s1,
                                            cpu_instruction_master_read,
                                            cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
                                            cpu_instruction_master_read_data_valid_sdram_s1,
                                            cpu_instruction_master_read_data_valid_sdram_s1_shift_register,
                                            cpu_instruction_master_requests_cpu_jtag_debug_module,
                                            cpu_instruction_master_requests_sdram_s1,
                                            cpu_jtag_debug_module_readdata_from_sa,
                                            d1_cpu_jtag_debug_module_end_xfer,
                                            d1_sdram_s1_end_xfer,
                                            reset_n,
                                            sdram_s1_readdata_from_sa,
                                            sdram_s1_waitrequest_from_sa,

                                           // outputs:
                                            cpu_instruction_master_address_to_slave,
                                            cpu_instruction_master_dbs_address,
                                            cpu_instruction_master_latency_counter,
                                            cpu_instruction_master_readdata,
                                            cpu_instruction_master_readdatavalid,
                                            cpu_instruction_master_waitrequest
                                         )
;

  output  [ 25: 0] cpu_instruction_master_address_to_slave;
  output  [  1: 0] cpu_instruction_master_dbs_address;
  output           cpu_instruction_master_latency_counter;
  output  [ 31: 0] cpu_instruction_master_readdata;
  output           cpu_instruction_master_readdatavalid;
  output           cpu_instruction_master_waitrequest;
  input            clk;
  input   [ 25: 0] cpu_instruction_master_address;
  input            cpu_instruction_master_granted_cpu_jtag_debug_module;
  input            cpu_instruction_master_granted_sdram_s1;
  input            cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  input            cpu_instruction_master_qualified_request_sdram_s1;
  input            cpu_instruction_master_read;
  input            cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  input            cpu_instruction_master_read_data_valid_sdram_s1;
  input            cpu_instruction_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_instruction_master_requests_cpu_jtag_debug_module;
  input            cpu_instruction_master_requests_sdram_s1;
  input   [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  input            d1_cpu_jtag_debug_module_end_xfer;
  input            d1_sdram_s1_end_xfer;
  input            reset_n;
  input   [ 15: 0] sdram_s1_readdata_from_sa;
  input            sdram_s1_waitrequest_from_sa;

  reg              active_and_waiting_last_time;
  reg     [ 25: 0] cpu_instruction_master_address_last_time;
  wire    [ 25: 0] cpu_instruction_master_address_to_slave;
  reg     [  1: 0] cpu_instruction_master_dbs_address;
  wire    [  1: 0] cpu_instruction_master_dbs_increment;
  reg     [  1: 0] cpu_instruction_master_dbs_rdv_counter;
  wire    [  1: 0] cpu_instruction_master_dbs_rdv_counter_inc;
  wire             cpu_instruction_master_is_granted_some_slave;
  reg              cpu_instruction_master_latency_counter;
  wire    [  1: 0] cpu_instruction_master_next_dbs_rdv_counter;
  reg              cpu_instruction_master_read_but_no_slave_selected;
  reg              cpu_instruction_master_read_last_time;
  wire    [ 31: 0] cpu_instruction_master_readdata;
  wire             cpu_instruction_master_readdatavalid;
  wire             cpu_instruction_master_run;
  wire             cpu_instruction_master_waitrequest;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  reg     [ 15: 0] dbs_latent_16_reg_segment_0;
  wire             dbs_rdv_count_enable;
  wire             dbs_rdv_counter_overflow;
  wire             latency_load_value;
  wire    [  1: 0] next_dbs_address;
  wire             p1_cpu_instruction_master_latency_counter;
  wire    [ 15: 0] p1_dbs_latent_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             pre_flush_cpu_instruction_master_readdatavalid;
  wire             r_0;
  wire             r_2;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (cpu_instruction_master_qualified_request_cpu_jtag_debug_module | ~cpu_instruction_master_requests_cpu_jtag_debug_module) & (cpu_instruction_master_granted_cpu_jtag_debug_module | ~cpu_instruction_master_qualified_request_cpu_jtag_debug_module) & ((~cpu_instruction_master_qualified_request_cpu_jtag_debug_module | ~cpu_instruction_master_read | (1 & ~d1_cpu_jtag_debug_module_end_xfer & cpu_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu_instruction_master_run = r_0 & r_2;

  //r_2 master_run cascaded wait assignment, which is an e_assign
  assign r_2 = 1 & (cpu_instruction_master_qualified_request_sdram_s1 | ~cpu_instruction_master_requests_sdram_s1) & (cpu_instruction_master_granted_sdram_s1 | ~cpu_instruction_master_qualified_request_sdram_s1) & ((~cpu_instruction_master_qualified_request_sdram_s1 | ~cpu_instruction_master_read | (1 & ~sdram_s1_waitrequest_from_sa & (cpu_instruction_master_dbs_address[1]) & cpu_instruction_master_read)));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_instruction_master_address_to_slave = {cpu_instruction_master_address[25],
    2'b0,
    cpu_instruction_master_address[22 : 0]};

  //cpu_instruction_master_read_but_no_slave_selected assignment, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_read_but_no_slave_selected <= 0;
      else 
        cpu_instruction_master_read_but_no_slave_selected <= cpu_instruction_master_read & cpu_instruction_master_run & ~cpu_instruction_master_is_granted_some_slave;
    end


  //some slave is getting selected, which is an e_mux
  assign cpu_instruction_master_is_granted_some_slave = cpu_instruction_master_granted_cpu_jtag_debug_module |
    cpu_instruction_master_granted_sdram_s1;

  //latent slave read data valids which may be flushed, which is an e_mux
  assign pre_flush_cpu_instruction_master_readdatavalid = cpu_instruction_master_read_data_valid_sdram_s1 & dbs_rdv_counter_overflow;

  //latent slave read data valid which is not flushed, which is an e_mux
  assign cpu_instruction_master_readdatavalid = cpu_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_instruction_master_readdatavalid |
    cpu_instruction_master_read_data_valid_cpu_jtag_debug_module |
    cpu_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_instruction_master_readdatavalid;

  //cpu/instruction_master readdata mux, which is an e_mux
  assign cpu_instruction_master_readdata = ({32 {~(cpu_instruction_master_qualified_request_cpu_jtag_debug_module & cpu_instruction_master_read)}} | cpu_jtag_debug_module_readdata_from_sa) &
    ({32 {~cpu_instruction_master_read_data_valid_sdram_s1}} | {sdram_s1_readdata_from_sa[15 : 0],
    dbs_latent_16_reg_segment_0});

  //actual waitrequest port, which is an e_assign
  assign cpu_instruction_master_waitrequest = ~cpu_instruction_master_run;

  //latent max counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_latency_counter <= 0;
      else 
        cpu_instruction_master_latency_counter <= p1_cpu_instruction_master_latency_counter;
    end


  //latency counter load mux, which is an e_mux
  assign p1_cpu_instruction_master_latency_counter = ((cpu_instruction_master_run & cpu_instruction_master_read))? latency_load_value :
    (cpu_instruction_master_latency_counter)? cpu_instruction_master_latency_counter - 1 :
    0;

  //read latency load values, which is an e_mux
  assign latency_load_value = 0;

  //input to latent dbs-16 stored 0, which is an e_mux
  assign p1_dbs_latent_16_reg_segment_0 = sdram_s1_readdata_from_sa;

  //dbs register for latent dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_latent_16_reg_segment_0 <= 0;
      else if (dbs_rdv_count_enable & ((cpu_instruction_master_dbs_rdv_counter[1]) == 0))
          dbs_latent_16_reg_segment_0 <= p1_dbs_latent_16_reg_segment_0;
    end


  //dbs count increment, which is an e_mux
  assign cpu_instruction_master_dbs_increment = (cpu_instruction_master_requests_sdram_s1)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_instruction_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_instruction_master_dbs_address + cpu_instruction_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_instruction_master_dbs_address <= next_dbs_address;
    end


  //p1 dbs rdv counter, which is an e_assign
  assign cpu_instruction_master_next_dbs_rdv_counter = cpu_instruction_master_dbs_rdv_counter + cpu_instruction_master_dbs_rdv_counter_inc;

  //cpu_instruction_master_rdv_inc_mux, which is an e_mux
  assign cpu_instruction_master_dbs_rdv_counter_inc = 2;

  //master any slave rdv, which is an e_mux
  assign dbs_rdv_count_enable = cpu_instruction_master_read_data_valid_sdram_s1;

  //dbs rdv counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_dbs_rdv_counter <= 0;
      else if (dbs_rdv_count_enable)
          cpu_instruction_master_dbs_rdv_counter <= cpu_instruction_master_next_dbs_rdv_counter;
    end


  //dbs rdv counter overflow, which is an e_assign
  assign dbs_rdv_counter_overflow = cpu_instruction_master_dbs_rdv_counter[1] & ~cpu_instruction_master_next_dbs_rdv_counter[1];

  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = cpu_instruction_master_granted_sdram_s1 & cpu_instruction_master_read & 1 & 1 & ~sdram_s1_waitrequest_from_sa;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu_instruction_master_address check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_address_last_time <= 0;
      else 
        cpu_instruction_master_address_last_time <= cpu_instruction_master_address;
    end


  //cpu/instruction_master waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else 
        active_and_waiting_last_time <= cpu_instruction_master_waitrequest & (cpu_instruction_master_read);
    end


  //cpu_instruction_master_address matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_instruction_master_address != cpu_instruction_master_address_last_time))
        begin
          $write("%0d ns: cpu_instruction_master_address did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_instruction_master_read check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_read_last_time <= 0;
      else 
        cpu_instruction_master_read_last_time <= cpu_instruction_master_read;
    end


  //cpu_instruction_master_read matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_instruction_master_read != cpu_instruction_master_read_last_time))
        begin
          $write("%0d ns: cpu_instruction_master_read did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module jtag_uart_avalon_jtag_slave_arbitrator (
                                                // inputs:
                                                 clk,
                                                 cpu_data_master_address_to_slave,
                                                 cpu_data_master_latency_counter,
                                                 cpu_data_master_read,
                                                 cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                                 cpu_data_master_write,
                                                 cpu_data_master_writedata,
                                                 jtag_uart_avalon_jtag_slave_dataavailable,
                                                 jtag_uart_avalon_jtag_slave_irq,
                                                 jtag_uart_avalon_jtag_slave_readdata,
                                                 jtag_uart_avalon_jtag_slave_readyfordata,
                                                 jtag_uart_avalon_jtag_slave_waitrequest,
                                                 reset_n,

                                                // outputs:
                                                 cpu_data_master_granted_jtag_uart_avalon_jtag_slave,
                                                 cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave,
                                                 cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave,
                                                 cpu_data_master_requests_jtag_uart_avalon_jtag_slave,
                                                 d1_jtag_uart_avalon_jtag_slave_end_xfer,
                                                 jtag_uart_avalon_jtag_slave_address,
                                                 jtag_uart_avalon_jtag_slave_chipselect,
                                                 jtag_uart_avalon_jtag_slave_dataavailable_from_sa,
                                                 jtag_uart_avalon_jtag_slave_irq_from_sa,
                                                 jtag_uart_avalon_jtag_slave_read_n,
                                                 jtag_uart_avalon_jtag_slave_readdata_from_sa,
                                                 jtag_uart_avalon_jtag_slave_readyfordata_from_sa,
                                                 jtag_uart_avalon_jtag_slave_reset_n,
                                                 jtag_uart_avalon_jtag_slave_waitrequest_from_sa,
                                                 jtag_uart_avalon_jtag_slave_write_n,
                                                 jtag_uart_avalon_jtag_slave_writedata
                                              )
;

  output           cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  output           cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  output           cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave;
  output           cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  output           d1_jtag_uart_avalon_jtag_slave_end_xfer;
  output           jtag_uart_avalon_jtag_slave_address;
  output           jtag_uart_avalon_jtag_slave_chipselect;
  output           jtag_uart_avalon_jtag_slave_dataavailable_from_sa;
  output           jtag_uart_avalon_jtag_slave_irq_from_sa;
  output           jtag_uart_avalon_jtag_slave_read_n;
  output  [ 31: 0] jtag_uart_avalon_jtag_slave_readdata_from_sa;
  output           jtag_uart_avalon_jtag_slave_readyfordata_from_sa;
  output           jtag_uart_avalon_jtag_slave_reset_n;
  output           jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  output           jtag_uart_avalon_jtag_slave_write_n;
  output  [ 31: 0] jtag_uart_avalon_jtag_slave_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input            jtag_uart_avalon_jtag_slave_dataavailable;
  input            jtag_uart_avalon_jtag_slave_irq;
  input   [ 31: 0] jtag_uart_avalon_jtag_slave_readdata;
  input            jtag_uart_avalon_jtag_slave_readyfordata;
  input            jtag_uart_avalon_jtag_slave_waitrequest;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_saved_grant_jtag_uart_avalon_jtag_slave;
  reg              d1_jtag_uart_avalon_jtag_slave_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire             jtag_uart_avalon_jtag_slave_address;
  wire             jtag_uart_avalon_jtag_slave_allgrants;
  wire             jtag_uart_avalon_jtag_slave_allow_new_arb_cycle;
  wire             jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant;
  wire             jtag_uart_avalon_jtag_slave_any_continuerequest;
  wire             jtag_uart_avalon_jtag_slave_arb_counter_enable;
  reg     [  1: 0] jtag_uart_avalon_jtag_slave_arb_share_counter;
  wire    [  1: 0] jtag_uart_avalon_jtag_slave_arb_share_counter_next_value;
  wire    [  1: 0] jtag_uart_avalon_jtag_slave_arb_share_set_values;
  wire             jtag_uart_avalon_jtag_slave_beginbursttransfer_internal;
  wire             jtag_uart_avalon_jtag_slave_begins_xfer;
  wire             jtag_uart_avalon_jtag_slave_chipselect;
  wire             jtag_uart_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_avalon_jtag_slave_end_xfer;
  wire             jtag_uart_avalon_jtag_slave_firsttransfer;
  wire             jtag_uart_avalon_jtag_slave_grant_vector;
  wire             jtag_uart_avalon_jtag_slave_in_a_read_cycle;
  wire             jtag_uart_avalon_jtag_slave_in_a_write_cycle;
  wire             jtag_uart_avalon_jtag_slave_irq_from_sa;
  wire             jtag_uart_avalon_jtag_slave_master_qreq_vector;
  wire             jtag_uart_avalon_jtag_slave_non_bursting_master_requests;
  wire             jtag_uart_avalon_jtag_slave_read_n;
  wire    [ 31: 0] jtag_uart_avalon_jtag_slave_readdata_from_sa;
  wire             jtag_uart_avalon_jtag_slave_readyfordata_from_sa;
  reg              jtag_uart_avalon_jtag_slave_reg_firsttransfer;
  wire             jtag_uart_avalon_jtag_slave_reset_n;
  reg              jtag_uart_avalon_jtag_slave_slavearbiterlockenable;
  wire             jtag_uart_avalon_jtag_slave_slavearbiterlockenable2;
  wire             jtag_uart_avalon_jtag_slave_unreg_firsttransfer;
  wire             jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  wire             jtag_uart_avalon_jtag_slave_waits_for_read;
  wire             jtag_uart_avalon_jtag_slave_waits_for_write;
  wire             jtag_uart_avalon_jtag_slave_write_n;
  wire    [ 31: 0] jtag_uart_avalon_jtag_slave_writedata;
  wire    [ 25: 0] shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master;
  wire             wait_for_jtag_uart_avalon_jtag_slave_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~jtag_uart_avalon_jtag_slave_end_xfer;
    end


  assign jtag_uart_avalon_jtag_slave_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave));
  //assign jtag_uart_avalon_jtag_slave_readdata_from_sa = jtag_uart_avalon_jtag_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_readdata_from_sa = jtag_uart_avalon_jtag_slave_readdata;

  assign cpu_data_master_requests_jtag_uart_avalon_jtag_slave = ({cpu_data_master_address_to_slave[25 : 3] , 3'b0} == 26'h0) & (cpu_data_master_read | cpu_data_master_write);
  //assign jtag_uart_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_avalon_jtag_slave_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_avalon_jtag_slave_dataavailable;

  //assign jtag_uart_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_avalon_jtag_slave_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_avalon_jtag_slave_readyfordata;

  //assign jtag_uart_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_avalon_jtag_slave_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_avalon_jtag_slave_waitrequest;

  //jtag_uart_avalon_jtag_slave_arb_share_counter set values, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_arb_share_set_values = 1;

  //jtag_uart_avalon_jtag_slave_non_bursting_master_requests mux, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_non_bursting_master_requests = cpu_data_master_requests_jtag_uart_avalon_jtag_slave;

  //jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant mux, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant = 0;

  //jtag_uart_avalon_jtag_slave_arb_share_counter_next_value assignment, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_arb_share_counter_next_value = jtag_uart_avalon_jtag_slave_firsttransfer ? (jtag_uart_avalon_jtag_slave_arb_share_set_values - 1) : |jtag_uart_avalon_jtag_slave_arb_share_counter ? (jtag_uart_avalon_jtag_slave_arb_share_counter - 1) : 0;

  //jtag_uart_avalon_jtag_slave_allgrants all slave grants, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_allgrants = |jtag_uart_avalon_jtag_slave_grant_vector;

  //jtag_uart_avalon_jtag_slave_end_xfer assignment, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_end_xfer = ~(jtag_uart_avalon_jtag_slave_waits_for_read | jtag_uart_avalon_jtag_slave_waits_for_write);

  //end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave = jtag_uart_avalon_jtag_slave_end_xfer & (~jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //jtag_uart_avalon_jtag_slave_arb_share_counter arbitration counter enable, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_arb_counter_enable = (end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave & jtag_uart_avalon_jtag_slave_allgrants) | (end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave & ~jtag_uart_avalon_jtag_slave_non_bursting_master_requests);

  //jtag_uart_avalon_jtag_slave_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_avalon_jtag_slave_arb_share_counter <= 0;
      else if (jtag_uart_avalon_jtag_slave_arb_counter_enable)
          jtag_uart_avalon_jtag_slave_arb_share_counter <= jtag_uart_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //jtag_uart_avalon_jtag_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_avalon_jtag_slave_slavearbiterlockenable <= 0;
      else if ((|jtag_uart_avalon_jtag_slave_master_qreq_vector & end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave) | (end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave & ~jtag_uart_avalon_jtag_slave_non_bursting_master_requests))
          jtag_uart_avalon_jtag_slave_slavearbiterlockenable <= |jtag_uart_avalon_jtag_slave_arb_share_counter_next_value;
    end


  //cpu/data_master jtag_uart/avalon_jtag_slave arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = jtag_uart_avalon_jtag_slave_slavearbiterlockenable & cpu_data_master_continuerequest;

  //jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 = |jtag_uart_avalon_jtag_slave_arb_share_counter_next_value;

  //cpu/data_master jtag_uart/avalon_jtag_slave arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //jtag_uart_avalon_jtag_slave_any_continuerequest at least one master continues requesting, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave = cpu_data_master_requests_jtag_uart_avalon_jtag_slave & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave, which is an e_mux
  assign cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave = cpu_data_master_granted_jtag_uart_avalon_jtag_slave & cpu_data_master_read & ~jtag_uart_avalon_jtag_slave_waits_for_read;

  //jtag_uart_avalon_jtag_slave_writedata mux, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_jtag_uart_avalon_jtag_slave = cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;

  //cpu/data_master saved-grant jtag_uart/avalon_jtag_slave, which is an e_assign
  assign cpu_data_master_saved_grant_jtag_uart_avalon_jtag_slave = cpu_data_master_requests_jtag_uart_avalon_jtag_slave;

  //allow new arb cycle for jtag_uart/avalon_jtag_slave, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign jtag_uart_avalon_jtag_slave_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign jtag_uart_avalon_jtag_slave_master_qreq_vector = 1;

  //jtag_uart_avalon_jtag_slave_reset_n assignment, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_reset_n = reset_n;

  assign jtag_uart_avalon_jtag_slave_chipselect = cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  //jtag_uart_avalon_jtag_slave_firsttransfer first transaction, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_firsttransfer = jtag_uart_avalon_jtag_slave_begins_xfer ? jtag_uart_avalon_jtag_slave_unreg_firsttransfer : jtag_uart_avalon_jtag_slave_reg_firsttransfer;

  //jtag_uart_avalon_jtag_slave_unreg_firsttransfer first transaction, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_unreg_firsttransfer = ~(jtag_uart_avalon_jtag_slave_slavearbiterlockenable & jtag_uart_avalon_jtag_slave_any_continuerequest);

  //jtag_uart_avalon_jtag_slave_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          jtag_uart_avalon_jtag_slave_reg_firsttransfer <= 1'b1;
      else if (jtag_uart_avalon_jtag_slave_begins_xfer)
          jtag_uart_avalon_jtag_slave_reg_firsttransfer <= jtag_uart_avalon_jtag_slave_unreg_firsttransfer;
    end


  //jtag_uart_avalon_jtag_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_beginbursttransfer_internal = jtag_uart_avalon_jtag_slave_begins_xfer;

  //~jtag_uart_avalon_jtag_slave_read_n assignment, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_read_n = ~(cpu_data_master_granted_jtag_uart_avalon_jtag_slave & cpu_data_master_read);

  //~jtag_uart_avalon_jtag_slave_write_n assignment, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_write_n = ~(cpu_data_master_granted_jtag_uart_avalon_jtag_slave & cpu_data_master_write);

  assign shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master = cpu_data_master_address_to_slave;
  //jtag_uart_avalon_jtag_slave_address mux, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_address = shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master >> 2;

  //d1_jtag_uart_avalon_jtag_slave_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_jtag_uart_avalon_jtag_slave_end_xfer <= 1;
      else 
        d1_jtag_uart_avalon_jtag_slave_end_xfer <= jtag_uart_avalon_jtag_slave_end_xfer;
    end


  //jtag_uart_avalon_jtag_slave_waits_for_read in a cycle, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_waits_for_read = jtag_uart_avalon_jtag_slave_in_a_read_cycle & jtag_uart_avalon_jtag_slave_waitrequest_from_sa;

  //jtag_uart_avalon_jtag_slave_in_a_read_cycle assignment, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_in_a_read_cycle = cpu_data_master_granted_jtag_uart_avalon_jtag_slave & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = jtag_uart_avalon_jtag_slave_in_a_read_cycle;

  //jtag_uart_avalon_jtag_slave_waits_for_write in a cycle, which is an e_mux
  assign jtag_uart_avalon_jtag_slave_waits_for_write = jtag_uart_avalon_jtag_slave_in_a_write_cycle & jtag_uart_avalon_jtag_slave_waitrequest_from_sa;

  //jtag_uart_avalon_jtag_slave_in_a_write_cycle assignment, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_in_a_write_cycle = cpu_data_master_granted_jtag_uart_avalon_jtag_slave & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = jtag_uart_avalon_jtag_slave_in_a_write_cycle;

  assign wait_for_jtag_uart_avalon_jtag_slave_counter = 0;
  //assign jtag_uart_avalon_jtag_slave_irq_from_sa = jtag_uart_avalon_jtag_slave_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign jtag_uart_avalon_jtag_slave_irq_from_sa = jtag_uart_avalon_jtag_slave_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //jtag_uart/avalon_jtag_slave enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module keyboardscancode_s1_arbitrator (
                                        // inputs:
                                         clk,
                                         cpu_data_master_address_to_slave,
                                         cpu_data_master_latency_counter,
                                         cpu_data_master_read,
                                         cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                         cpu_data_master_write,
                                         keyboardscancode_s1_readdata,
                                         reset_n,

                                        // outputs:
                                         cpu_data_master_granted_keyboardscancode_s1,
                                         cpu_data_master_qualified_request_keyboardscancode_s1,
                                         cpu_data_master_read_data_valid_keyboardscancode_s1,
                                         cpu_data_master_requests_keyboardscancode_s1,
                                         d1_keyboardscancode_s1_end_xfer,
                                         keyboardscancode_s1_address,
                                         keyboardscancode_s1_readdata_from_sa,
                                         keyboardscancode_s1_reset_n
                                      )
;

  output           cpu_data_master_granted_keyboardscancode_s1;
  output           cpu_data_master_qualified_request_keyboardscancode_s1;
  output           cpu_data_master_read_data_valid_keyboardscancode_s1;
  output           cpu_data_master_requests_keyboardscancode_s1;
  output           d1_keyboardscancode_s1_end_xfer;
  output  [  1: 0] keyboardscancode_s1_address;
  output  [ 31: 0] keyboardscancode_s1_readdata_from_sa;
  output           keyboardscancode_s1_reset_n;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] keyboardscancode_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_keyboardscancode_s1;
  wire             cpu_data_master_qualified_request_keyboardscancode_s1;
  wire             cpu_data_master_read_data_valid_keyboardscancode_s1;
  wire             cpu_data_master_requests_keyboardscancode_s1;
  wire             cpu_data_master_saved_grant_keyboardscancode_s1;
  reg              d1_keyboardscancode_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_keyboardscancode_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] keyboardscancode_s1_address;
  wire             keyboardscancode_s1_allgrants;
  wire             keyboardscancode_s1_allow_new_arb_cycle;
  wire             keyboardscancode_s1_any_bursting_master_saved_grant;
  wire             keyboardscancode_s1_any_continuerequest;
  wire             keyboardscancode_s1_arb_counter_enable;
  reg     [  1: 0] keyboardscancode_s1_arb_share_counter;
  wire    [  1: 0] keyboardscancode_s1_arb_share_counter_next_value;
  wire    [  1: 0] keyboardscancode_s1_arb_share_set_values;
  wire             keyboardscancode_s1_beginbursttransfer_internal;
  wire             keyboardscancode_s1_begins_xfer;
  wire             keyboardscancode_s1_end_xfer;
  wire             keyboardscancode_s1_firsttransfer;
  wire             keyboardscancode_s1_grant_vector;
  wire             keyboardscancode_s1_in_a_read_cycle;
  wire             keyboardscancode_s1_in_a_write_cycle;
  wire             keyboardscancode_s1_master_qreq_vector;
  wire             keyboardscancode_s1_non_bursting_master_requests;
  wire    [ 31: 0] keyboardscancode_s1_readdata_from_sa;
  reg              keyboardscancode_s1_reg_firsttransfer;
  wire             keyboardscancode_s1_reset_n;
  reg              keyboardscancode_s1_slavearbiterlockenable;
  wire             keyboardscancode_s1_slavearbiterlockenable2;
  wire             keyboardscancode_s1_unreg_firsttransfer;
  wire             keyboardscancode_s1_waits_for_read;
  wire             keyboardscancode_s1_waits_for_write;
  wire    [ 25: 0] shifted_address_to_keyboardscancode_s1_from_cpu_data_master;
  wire             wait_for_keyboardscancode_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~keyboardscancode_s1_end_xfer;
    end


  assign keyboardscancode_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_keyboardscancode_s1));
  //assign keyboardscancode_s1_readdata_from_sa = keyboardscancode_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign keyboardscancode_s1_readdata_from_sa = keyboardscancode_s1_readdata;

  assign cpu_data_master_requests_keyboardscancode_s1 = (({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h70) & (cpu_data_master_read | cpu_data_master_write)) & cpu_data_master_read;
  //keyboardscancode_s1_arb_share_counter set values, which is an e_mux
  assign keyboardscancode_s1_arb_share_set_values = 1;

  //keyboardscancode_s1_non_bursting_master_requests mux, which is an e_mux
  assign keyboardscancode_s1_non_bursting_master_requests = cpu_data_master_requests_keyboardscancode_s1;

  //keyboardscancode_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign keyboardscancode_s1_any_bursting_master_saved_grant = 0;

  //keyboardscancode_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign keyboardscancode_s1_arb_share_counter_next_value = keyboardscancode_s1_firsttransfer ? (keyboardscancode_s1_arb_share_set_values - 1) : |keyboardscancode_s1_arb_share_counter ? (keyboardscancode_s1_arb_share_counter - 1) : 0;

  //keyboardscancode_s1_allgrants all slave grants, which is an e_mux
  assign keyboardscancode_s1_allgrants = |keyboardscancode_s1_grant_vector;

  //keyboardscancode_s1_end_xfer assignment, which is an e_assign
  assign keyboardscancode_s1_end_xfer = ~(keyboardscancode_s1_waits_for_read | keyboardscancode_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_keyboardscancode_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_keyboardscancode_s1 = keyboardscancode_s1_end_xfer & (~keyboardscancode_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //keyboardscancode_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign keyboardscancode_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_keyboardscancode_s1 & keyboardscancode_s1_allgrants) | (end_xfer_arb_share_counter_term_keyboardscancode_s1 & ~keyboardscancode_s1_non_bursting_master_requests);

  //keyboardscancode_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keyboardscancode_s1_arb_share_counter <= 0;
      else if (keyboardscancode_s1_arb_counter_enable)
          keyboardscancode_s1_arb_share_counter <= keyboardscancode_s1_arb_share_counter_next_value;
    end


  //keyboardscancode_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keyboardscancode_s1_slavearbiterlockenable <= 0;
      else if ((|keyboardscancode_s1_master_qreq_vector & end_xfer_arb_share_counter_term_keyboardscancode_s1) | (end_xfer_arb_share_counter_term_keyboardscancode_s1 & ~keyboardscancode_s1_non_bursting_master_requests))
          keyboardscancode_s1_slavearbiterlockenable <= |keyboardscancode_s1_arb_share_counter_next_value;
    end


  //cpu/data_master keyboardscancode/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = keyboardscancode_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //keyboardscancode_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign keyboardscancode_s1_slavearbiterlockenable2 = |keyboardscancode_s1_arb_share_counter_next_value;

  //cpu/data_master keyboardscancode/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = keyboardscancode_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //keyboardscancode_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign keyboardscancode_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_keyboardscancode_s1 = cpu_data_master_requests_keyboardscancode_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_keyboardscancode_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_keyboardscancode_s1 = cpu_data_master_granted_keyboardscancode_s1 & cpu_data_master_read & ~keyboardscancode_s1_waits_for_read;

  //master is always granted when requested
  assign cpu_data_master_granted_keyboardscancode_s1 = cpu_data_master_qualified_request_keyboardscancode_s1;

  //cpu/data_master saved-grant keyboardscancode/s1, which is an e_assign
  assign cpu_data_master_saved_grant_keyboardscancode_s1 = cpu_data_master_requests_keyboardscancode_s1;

  //allow new arb cycle for keyboardscancode/s1, which is an e_assign
  assign keyboardscancode_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign keyboardscancode_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign keyboardscancode_s1_master_qreq_vector = 1;

  //keyboardscancode_s1_reset_n assignment, which is an e_assign
  assign keyboardscancode_s1_reset_n = reset_n;

  //keyboardscancode_s1_firsttransfer first transaction, which is an e_assign
  assign keyboardscancode_s1_firsttransfer = keyboardscancode_s1_begins_xfer ? keyboardscancode_s1_unreg_firsttransfer : keyboardscancode_s1_reg_firsttransfer;

  //keyboardscancode_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign keyboardscancode_s1_unreg_firsttransfer = ~(keyboardscancode_s1_slavearbiterlockenable & keyboardscancode_s1_any_continuerequest);

  //keyboardscancode_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keyboardscancode_s1_reg_firsttransfer <= 1'b1;
      else if (keyboardscancode_s1_begins_xfer)
          keyboardscancode_s1_reg_firsttransfer <= keyboardscancode_s1_unreg_firsttransfer;
    end


  //keyboardscancode_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign keyboardscancode_s1_beginbursttransfer_internal = keyboardscancode_s1_begins_xfer;

  assign shifted_address_to_keyboardscancode_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //keyboardscancode_s1_address mux, which is an e_mux
  assign keyboardscancode_s1_address = shifted_address_to_keyboardscancode_s1_from_cpu_data_master >> 2;

  //d1_keyboardscancode_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_keyboardscancode_s1_end_xfer <= 1;
      else 
        d1_keyboardscancode_s1_end_xfer <= keyboardscancode_s1_end_xfer;
    end


  //keyboardscancode_s1_waits_for_read in a cycle, which is an e_mux
  assign keyboardscancode_s1_waits_for_read = keyboardscancode_s1_in_a_read_cycle & keyboardscancode_s1_begins_xfer;

  //keyboardscancode_s1_in_a_read_cycle assignment, which is an e_assign
  assign keyboardscancode_s1_in_a_read_cycle = cpu_data_master_granted_keyboardscancode_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = keyboardscancode_s1_in_a_read_cycle;

  //keyboardscancode_s1_waits_for_write in a cycle, which is an e_mux
  assign keyboardscancode_s1_waits_for_write = keyboardscancode_s1_in_a_write_cycle & 0;

  //keyboardscancode_s1_in_a_write_cycle assignment, which is an e_assign
  assign keyboardscancode_s1_in_a_write_cycle = cpu_data_master_granted_keyboardscancode_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = keyboardscancode_s1_in_a_write_cycle;

  assign wait_for_keyboardscancode_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //keyboardscancode/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module keycounter_s1_arbitrator (
                                  // inputs:
                                   clk,
                                   cpu_data_master_address_to_slave,
                                   cpu_data_master_latency_counter,
                                   cpu_data_master_read,
                                   cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                   cpu_data_master_write,
                                   keycounter_s1_readdata,
                                   reset_n,

                                  // outputs:
                                   cpu_data_master_granted_keycounter_s1,
                                   cpu_data_master_qualified_request_keycounter_s1,
                                   cpu_data_master_read_data_valid_keycounter_s1,
                                   cpu_data_master_requests_keycounter_s1,
                                   d1_keycounter_s1_end_xfer,
                                   keycounter_s1_address,
                                   keycounter_s1_readdata_from_sa,
                                   keycounter_s1_reset_n
                                )
;

  output           cpu_data_master_granted_keycounter_s1;
  output           cpu_data_master_qualified_request_keycounter_s1;
  output           cpu_data_master_read_data_valid_keycounter_s1;
  output           cpu_data_master_requests_keycounter_s1;
  output           d1_keycounter_s1_end_xfer;
  output  [  1: 0] keycounter_s1_address;
  output  [ 31: 0] keycounter_s1_readdata_from_sa;
  output           keycounter_s1_reset_n;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] keycounter_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_keycounter_s1;
  wire             cpu_data_master_qualified_request_keycounter_s1;
  wire             cpu_data_master_read_data_valid_keycounter_s1;
  wire             cpu_data_master_requests_keycounter_s1;
  wire             cpu_data_master_saved_grant_keycounter_s1;
  reg              d1_keycounter_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_keycounter_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] keycounter_s1_address;
  wire             keycounter_s1_allgrants;
  wire             keycounter_s1_allow_new_arb_cycle;
  wire             keycounter_s1_any_bursting_master_saved_grant;
  wire             keycounter_s1_any_continuerequest;
  wire             keycounter_s1_arb_counter_enable;
  reg     [  1: 0] keycounter_s1_arb_share_counter;
  wire    [  1: 0] keycounter_s1_arb_share_counter_next_value;
  wire    [  1: 0] keycounter_s1_arb_share_set_values;
  wire             keycounter_s1_beginbursttransfer_internal;
  wire             keycounter_s1_begins_xfer;
  wire             keycounter_s1_end_xfer;
  wire             keycounter_s1_firsttransfer;
  wire             keycounter_s1_grant_vector;
  wire             keycounter_s1_in_a_read_cycle;
  wire             keycounter_s1_in_a_write_cycle;
  wire             keycounter_s1_master_qreq_vector;
  wire             keycounter_s1_non_bursting_master_requests;
  wire    [ 31: 0] keycounter_s1_readdata_from_sa;
  reg              keycounter_s1_reg_firsttransfer;
  wire             keycounter_s1_reset_n;
  reg              keycounter_s1_slavearbiterlockenable;
  wire             keycounter_s1_slavearbiterlockenable2;
  wire             keycounter_s1_unreg_firsttransfer;
  wire             keycounter_s1_waits_for_read;
  wire             keycounter_s1_waits_for_write;
  wire    [ 25: 0] shifted_address_to_keycounter_s1_from_cpu_data_master;
  wire             wait_for_keycounter_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~keycounter_s1_end_xfer;
    end


  assign keycounter_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_keycounter_s1));
  //assign keycounter_s1_readdata_from_sa = keycounter_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign keycounter_s1_readdata_from_sa = keycounter_s1_readdata;

  assign cpu_data_master_requests_keycounter_s1 = (({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h80) & (cpu_data_master_read | cpu_data_master_write)) & cpu_data_master_read;
  //keycounter_s1_arb_share_counter set values, which is an e_mux
  assign keycounter_s1_arb_share_set_values = 1;

  //keycounter_s1_non_bursting_master_requests mux, which is an e_mux
  assign keycounter_s1_non_bursting_master_requests = cpu_data_master_requests_keycounter_s1;

  //keycounter_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign keycounter_s1_any_bursting_master_saved_grant = 0;

  //keycounter_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign keycounter_s1_arb_share_counter_next_value = keycounter_s1_firsttransfer ? (keycounter_s1_arb_share_set_values - 1) : |keycounter_s1_arb_share_counter ? (keycounter_s1_arb_share_counter - 1) : 0;

  //keycounter_s1_allgrants all slave grants, which is an e_mux
  assign keycounter_s1_allgrants = |keycounter_s1_grant_vector;

  //keycounter_s1_end_xfer assignment, which is an e_assign
  assign keycounter_s1_end_xfer = ~(keycounter_s1_waits_for_read | keycounter_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_keycounter_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_keycounter_s1 = keycounter_s1_end_xfer & (~keycounter_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //keycounter_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign keycounter_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_keycounter_s1 & keycounter_s1_allgrants) | (end_xfer_arb_share_counter_term_keycounter_s1 & ~keycounter_s1_non_bursting_master_requests);

  //keycounter_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keycounter_s1_arb_share_counter <= 0;
      else if (keycounter_s1_arb_counter_enable)
          keycounter_s1_arb_share_counter <= keycounter_s1_arb_share_counter_next_value;
    end


  //keycounter_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keycounter_s1_slavearbiterlockenable <= 0;
      else if ((|keycounter_s1_master_qreq_vector & end_xfer_arb_share_counter_term_keycounter_s1) | (end_xfer_arb_share_counter_term_keycounter_s1 & ~keycounter_s1_non_bursting_master_requests))
          keycounter_s1_slavearbiterlockenable <= |keycounter_s1_arb_share_counter_next_value;
    end


  //cpu/data_master keycounter/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = keycounter_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //keycounter_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign keycounter_s1_slavearbiterlockenable2 = |keycounter_s1_arb_share_counter_next_value;

  //cpu/data_master keycounter/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = keycounter_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //keycounter_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign keycounter_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_keycounter_s1 = cpu_data_master_requests_keycounter_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_keycounter_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_keycounter_s1 = cpu_data_master_granted_keycounter_s1 & cpu_data_master_read & ~keycounter_s1_waits_for_read;

  //master is always granted when requested
  assign cpu_data_master_granted_keycounter_s1 = cpu_data_master_qualified_request_keycounter_s1;

  //cpu/data_master saved-grant keycounter/s1, which is an e_assign
  assign cpu_data_master_saved_grant_keycounter_s1 = cpu_data_master_requests_keycounter_s1;

  //allow new arb cycle for keycounter/s1, which is an e_assign
  assign keycounter_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign keycounter_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign keycounter_s1_master_qreq_vector = 1;

  //keycounter_s1_reset_n assignment, which is an e_assign
  assign keycounter_s1_reset_n = reset_n;

  //keycounter_s1_firsttransfer first transaction, which is an e_assign
  assign keycounter_s1_firsttransfer = keycounter_s1_begins_xfer ? keycounter_s1_unreg_firsttransfer : keycounter_s1_reg_firsttransfer;

  //keycounter_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign keycounter_s1_unreg_firsttransfer = ~(keycounter_s1_slavearbiterlockenable & keycounter_s1_any_continuerequest);

  //keycounter_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          keycounter_s1_reg_firsttransfer <= 1'b1;
      else if (keycounter_s1_begins_xfer)
          keycounter_s1_reg_firsttransfer <= keycounter_s1_unreg_firsttransfer;
    end


  //keycounter_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign keycounter_s1_beginbursttransfer_internal = keycounter_s1_begins_xfer;

  assign shifted_address_to_keycounter_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //keycounter_s1_address mux, which is an e_mux
  assign keycounter_s1_address = shifted_address_to_keycounter_s1_from_cpu_data_master >> 2;

  //d1_keycounter_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_keycounter_s1_end_xfer <= 1;
      else 
        d1_keycounter_s1_end_xfer <= keycounter_s1_end_xfer;
    end


  //keycounter_s1_waits_for_read in a cycle, which is an e_mux
  assign keycounter_s1_waits_for_read = keycounter_s1_in_a_read_cycle & keycounter_s1_begins_xfer;

  //keycounter_s1_in_a_read_cycle assignment, which is an e_assign
  assign keycounter_s1_in_a_read_cycle = cpu_data_master_granted_keycounter_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = keycounter_s1_in_a_read_cycle;

  //keycounter_s1_waits_for_write in a cycle, which is an e_mux
  assign keycounter_s1_waits_for_write = keycounter_s1_in_a_write_cycle & 0;

  //keycounter_s1_in_a_write_cycle assignment, which is an e_assign
  assign keycounter_s1_in_a_write_cycle = cpu_data_master_granted_keycounter_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = keycounter_s1_in_a_write_cycle;

  assign wait_for_keycounter_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //keycounter/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module outputsramdata_s1_arbitrator (
                                      // inputs:
                                       clk,
                                       cpu_data_master_address_to_slave,
                                       cpu_data_master_latency_counter,
                                       cpu_data_master_read,
                                       cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                       cpu_data_master_write,
                                       cpu_data_master_writedata,
                                       outputsramdata_s1_readdata,
                                       reset_n,

                                      // outputs:
                                       cpu_data_master_granted_outputsramdata_s1,
                                       cpu_data_master_qualified_request_outputsramdata_s1,
                                       cpu_data_master_read_data_valid_outputsramdata_s1,
                                       cpu_data_master_requests_outputsramdata_s1,
                                       d1_outputsramdata_s1_end_xfer,
                                       outputsramdata_s1_address,
                                       outputsramdata_s1_chipselect,
                                       outputsramdata_s1_readdata_from_sa,
                                       outputsramdata_s1_reset_n,
                                       outputsramdata_s1_write_n,
                                       outputsramdata_s1_writedata
                                    )
;

  output           cpu_data_master_granted_outputsramdata_s1;
  output           cpu_data_master_qualified_request_outputsramdata_s1;
  output           cpu_data_master_read_data_valid_outputsramdata_s1;
  output           cpu_data_master_requests_outputsramdata_s1;
  output           d1_outputsramdata_s1_end_xfer;
  output  [  1: 0] outputsramdata_s1_address;
  output           outputsramdata_s1_chipselect;
  output  [ 31: 0] outputsramdata_s1_readdata_from_sa;
  output           outputsramdata_s1_reset_n;
  output           outputsramdata_s1_write_n;
  output  [ 31: 0] outputsramdata_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] outputsramdata_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_outputsramdata_s1;
  wire             cpu_data_master_qualified_request_outputsramdata_s1;
  wire             cpu_data_master_read_data_valid_outputsramdata_s1;
  wire             cpu_data_master_requests_outputsramdata_s1;
  wire             cpu_data_master_saved_grant_outputsramdata_s1;
  reg              d1_outputsramdata_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_outputsramdata_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] outputsramdata_s1_address;
  wire             outputsramdata_s1_allgrants;
  wire             outputsramdata_s1_allow_new_arb_cycle;
  wire             outputsramdata_s1_any_bursting_master_saved_grant;
  wire             outputsramdata_s1_any_continuerequest;
  wire             outputsramdata_s1_arb_counter_enable;
  reg     [  1: 0] outputsramdata_s1_arb_share_counter;
  wire    [  1: 0] outputsramdata_s1_arb_share_counter_next_value;
  wire    [  1: 0] outputsramdata_s1_arb_share_set_values;
  wire             outputsramdata_s1_beginbursttransfer_internal;
  wire             outputsramdata_s1_begins_xfer;
  wire             outputsramdata_s1_chipselect;
  wire             outputsramdata_s1_end_xfer;
  wire             outputsramdata_s1_firsttransfer;
  wire             outputsramdata_s1_grant_vector;
  wire             outputsramdata_s1_in_a_read_cycle;
  wire             outputsramdata_s1_in_a_write_cycle;
  wire             outputsramdata_s1_master_qreq_vector;
  wire             outputsramdata_s1_non_bursting_master_requests;
  wire    [ 31: 0] outputsramdata_s1_readdata_from_sa;
  reg              outputsramdata_s1_reg_firsttransfer;
  wire             outputsramdata_s1_reset_n;
  reg              outputsramdata_s1_slavearbiterlockenable;
  wire             outputsramdata_s1_slavearbiterlockenable2;
  wire             outputsramdata_s1_unreg_firsttransfer;
  wire             outputsramdata_s1_waits_for_read;
  wire             outputsramdata_s1_waits_for_write;
  wire             outputsramdata_s1_write_n;
  wire    [ 31: 0] outputsramdata_s1_writedata;
  wire    [ 25: 0] shifted_address_to_outputsramdata_s1_from_cpu_data_master;
  wire             wait_for_outputsramdata_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~outputsramdata_s1_end_xfer;
    end


  assign outputsramdata_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_outputsramdata_s1));
  //assign outputsramdata_s1_readdata_from_sa = outputsramdata_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign outputsramdata_s1_readdata_from_sa = outputsramdata_s1_readdata;

  assign cpu_data_master_requests_outputsramdata_s1 = ({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h10) & (cpu_data_master_read | cpu_data_master_write);
  //outputsramdata_s1_arb_share_counter set values, which is an e_mux
  assign outputsramdata_s1_arb_share_set_values = 1;

  //outputsramdata_s1_non_bursting_master_requests mux, which is an e_mux
  assign outputsramdata_s1_non_bursting_master_requests = cpu_data_master_requests_outputsramdata_s1;

  //outputsramdata_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign outputsramdata_s1_any_bursting_master_saved_grant = 0;

  //outputsramdata_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign outputsramdata_s1_arb_share_counter_next_value = outputsramdata_s1_firsttransfer ? (outputsramdata_s1_arb_share_set_values - 1) : |outputsramdata_s1_arb_share_counter ? (outputsramdata_s1_arb_share_counter - 1) : 0;

  //outputsramdata_s1_allgrants all slave grants, which is an e_mux
  assign outputsramdata_s1_allgrants = |outputsramdata_s1_grant_vector;

  //outputsramdata_s1_end_xfer assignment, which is an e_assign
  assign outputsramdata_s1_end_xfer = ~(outputsramdata_s1_waits_for_read | outputsramdata_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_outputsramdata_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_outputsramdata_s1 = outputsramdata_s1_end_xfer & (~outputsramdata_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //outputsramdata_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign outputsramdata_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_outputsramdata_s1 & outputsramdata_s1_allgrants) | (end_xfer_arb_share_counter_term_outputsramdata_s1 & ~outputsramdata_s1_non_bursting_master_requests);

  //outputsramdata_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputsramdata_s1_arb_share_counter <= 0;
      else if (outputsramdata_s1_arb_counter_enable)
          outputsramdata_s1_arb_share_counter <= outputsramdata_s1_arb_share_counter_next_value;
    end


  //outputsramdata_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputsramdata_s1_slavearbiterlockenable <= 0;
      else if ((|outputsramdata_s1_master_qreq_vector & end_xfer_arb_share_counter_term_outputsramdata_s1) | (end_xfer_arb_share_counter_term_outputsramdata_s1 & ~outputsramdata_s1_non_bursting_master_requests))
          outputsramdata_s1_slavearbiterlockenable <= |outputsramdata_s1_arb_share_counter_next_value;
    end


  //cpu/data_master outputsramdata/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = outputsramdata_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //outputsramdata_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign outputsramdata_s1_slavearbiterlockenable2 = |outputsramdata_s1_arb_share_counter_next_value;

  //cpu/data_master outputsramdata/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = outputsramdata_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //outputsramdata_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign outputsramdata_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_outputsramdata_s1 = cpu_data_master_requests_outputsramdata_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_outputsramdata_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_outputsramdata_s1 = cpu_data_master_granted_outputsramdata_s1 & cpu_data_master_read & ~outputsramdata_s1_waits_for_read;

  //outputsramdata_s1_writedata mux, which is an e_mux
  assign outputsramdata_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_outputsramdata_s1 = cpu_data_master_qualified_request_outputsramdata_s1;

  //cpu/data_master saved-grant outputsramdata/s1, which is an e_assign
  assign cpu_data_master_saved_grant_outputsramdata_s1 = cpu_data_master_requests_outputsramdata_s1;

  //allow new arb cycle for outputsramdata/s1, which is an e_assign
  assign outputsramdata_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign outputsramdata_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign outputsramdata_s1_master_qreq_vector = 1;

  //outputsramdata_s1_reset_n assignment, which is an e_assign
  assign outputsramdata_s1_reset_n = reset_n;

  assign outputsramdata_s1_chipselect = cpu_data_master_granted_outputsramdata_s1;
  //outputsramdata_s1_firsttransfer first transaction, which is an e_assign
  assign outputsramdata_s1_firsttransfer = outputsramdata_s1_begins_xfer ? outputsramdata_s1_unreg_firsttransfer : outputsramdata_s1_reg_firsttransfer;

  //outputsramdata_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign outputsramdata_s1_unreg_firsttransfer = ~(outputsramdata_s1_slavearbiterlockenable & outputsramdata_s1_any_continuerequest);

  //outputsramdata_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputsramdata_s1_reg_firsttransfer <= 1'b1;
      else if (outputsramdata_s1_begins_xfer)
          outputsramdata_s1_reg_firsttransfer <= outputsramdata_s1_unreg_firsttransfer;
    end


  //outputsramdata_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign outputsramdata_s1_beginbursttransfer_internal = outputsramdata_s1_begins_xfer;

  //~outputsramdata_s1_write_n assignment, which is an e_mux
  assign outputsramdata_s1_write_n = ~(cpu_data_master_granted_outputsramdata_s1 & cpu_data_master_write);

  assign shifted_address_to_outputsramdata_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //outputsramdata_s1_address mux, which is an e_mux
  assign outputsramdata_s1_address = shifted_address_to_outputsramdata_s1_from_cpu_data_master >> 2;

  //d1_outputsramdata_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_outputsramdata_s1_end_xfer <= 1;
      else 
        d1_outputsramdata_s1_end_xfer <= outputsramdata_s1_end_xfer;
    end


  //outputsramdata_s1_waits_for_read in a cycle, which is an e_mux
  assign outputsramdata_s1_waits_for_read = outputsramdata_s1_in_a_read_cycle & outputsramdata_s1_begins_xfer;

  //outputsramdata_s1_in_a_read_cycle assignment, which is an e_assign
  assign outputsramdata_s1_in_a_read_cycle = cpu_data_master_granted_outputsramdata_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = outputsramdata_s1_in_a_read_cycle;

  //outputsramdata_s1_waits_for_write in a cycle, which is an e_mux
  assign outputsramdata_s1_waits_for_write = outputsramdata_s1_in_a_write_cycle & 0;

  //outputsramdata_s1_in_a_write_cycle assignment, which is an e_assign
  assign outputsramdata_s1_in_a_write_cycle = cpu_data_master_granted_outputsramdata_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = outputsramdata_s1_in_a_write_cycle;

  assign wait_for_outputsramdata_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //outputsramdata/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module outputxcoord_s1_arbitrator (
                                    // inputs:
                                     clk,
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_latency_counter,
                                     cpu_data_master_read,
                                     cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     outputxcoord_s1_readdata,
                                     reset_n,

                                    // outputs:
                                     cpu_data_master_granted_outputxcoord_s1,
                                     cpu_data_master_qualified_request_outputxcoord_s1,
                                     cpu_data_master_read_data_valid_outputxcoord_s1,
                                     cpu_data_master_requests_outputxcoord_s1,
                                     d1_outputxcoord_s1_end_xfer,
                                     outputxcoord_s1_address,
                                     outputxcoord_s1_chipselect,
                                     outputxcoord_s1_readdata_from_sa,
                                     outputxcoord_s1_reset_n,
                                     outputxcoord_s1_write_n,
                                     outputxcoord_s1_writedata
                                  )
;

  output           cpu_data_master_granted_outputxcoord_s1;
  output           cpu_data_master_qualified_request_outputxcoord_s1;
  output           cpu_data_master_read_data_valid_outputxcoord_s1;
  output           cpu_data_master_requests_outputxcoord_s1;
  output           d1_outputxcoord_s1_end_xfer;
  output  [  1: 0] outputxcoord_s1_address;
  output           outputxcoord_s1_chipselect;
  output  [ 31: 0] outputxcoord_s1_readdata_from_sa;
  output           outputxcoord_s1_reset_n;
  output           outputxcoord_s1_write_n;
  output  [ 31: 0] outputxcoord_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] outputxcoord_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_outputxcoord_s1;
  wire             cpu_data_master_qualified_request_outputxcoord_s1;
  wire             cpu_data_master_read_data_valid_outputxcoord_s1;
  wire             cpu_data_master_requests_outputxcoord_s1;
  wire             cpu_data_master_saved_grant_outputxcoord_s1;
  reg              d1_outputxcoord_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_outputxcoord_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] outputxcoord_s1_address;
  wire             outputxcoord_s1_allgrants;
  wire             outputxcoord_s1_allow_new_arb_cycle;
  wire             outputxcoord_s1_any_bursting_master_saved_grant;
  wire             outputxcoord_s1_any_continuerequest;
  wire             outputxcoord_s1_arb_counter_enable;
  reg     [  1: 0] outputxcoord_s1_arb_share_counter;
  wire    [  1: 0] outputxcoord_s1_arb_share_counter_next_value;
  wire    [  1: 0] outputxcoord_s1_arb_share_set_values;
  wire             outputxcoord_s1_beginbursttransfer_internal;
  wire             outputxcoord_s1_begins_xfer;
  wire             outputxcoord_s1_chipselect;
  wire             outputxcoord_s1_end_xfer;
  wire             outputxcoord_s1_firsttransfer;
  wire             outputxcoord_s1_grant_vector;
  wire             outputxcoord_s1_in_a_read_cycle;
  wire             outputxcoord_s1_in_a_write_cycle;
  wire             outputxcoord_s1_master_qreq_vector;
  wire             outputxcoord_s1_non_bursting_master_requests;
  wire    [ 31: 0] outputxcoord_s1_readdata_from_sa;
  reg              outputxcoord_s1_reg_firsttransfer;
  wire             outputxcoord_s1_reset_n;
  reg              outputxcoord_s1_slavearbiterlockenable;
  wire             outputxcoord_s1_slavearbiterlockenable2;
  wire             outputxcoord_s1_unreg_firsttransfer;
  wire             outputxcoord_s1_waits_for_read;
  wire             outputxcoord_s1_waits_for_write;
  wire             outputxcoord_s1_write_n;
  wire    [ 31: 0] outputxcoord_s1_writedata;
  wire    [ 25: 0] shifted_address_to_outputxcoord_s1_from_cpu_data_master;
  wire             wait_for_outputxcoord_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~outputxcoord_s1_end_xfer;
    end


  assign outputxcoord_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_outputxcoord_s1));
  //assign outputxcoord_s1_readdata_from_sa = outputxcoord_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign outputxcoord_s1_readdata_from_sa = outputxcoord_s1_readdata;

  assign cpu_data_master_requests_outputxcoord_s1 = ({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h40) & (cpu_data_master_read | cpu_data_master_write);
  //outputxcoord_s1_arb_share_counter set values, which is an e_mux
  assign outputxcoord_s1_arb_share_set_values = 1;

  //outputxcoord_s1_non_bursting_master_requests mux, which is an e_mux
  assign outputxcoord_s1_non_bursting_master_requests = cpu_data_master_requests_outputxcoord_s1;

  //outputxcoord_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign outputxcoord_s1_any_bursting_master_saved_grant = 0;

  //outputxcoord_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign outputxcoord_s1_arb_share_counter_next_value = outputxcoord_s1_firsttransfer ? (outputxcoord_s1_arb_share_set_values - 1) : |outputxcoord_s1_arb_share_counter ? (outputxcoord_s1_arb_share_counter - 1) : 0;

  //outputxcoord_s1_allgrants all slave grants, which is an e_mux
  assign outputxcoord_s1_allgrants = |outputxcoord_s1_grant_vector;

  //outputxcoord_s1_end_xfer assignment, which is an e_assign
  assign outputxcoord_s1_end_xfer = ~(outputxcoord_s1_waits_for_read | outputxcoord_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_outputxcoord_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_outputxcoord_s1 = outputxcoord_s1_end_xfer & (~outputxcoord_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //outputxcoord_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign outputxcoord_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_outputxcoord_s1 & outputxcoord_s1_allgrants) | (end_xfer_arb_share_counter_term_outputxcoord_s1 & ~outputxcoord_s1_non_bursting_master_requests);

  //outputxcoord_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputxcoord_s1_arb_share_counter <= 0;
      else if (outputxcoord_s1_arb_counter_enable)
          outputxcoord_s1_arb_share_counter <= outputxcoord_s1_arb_share_counter_next_value;
    end


  //outputxcoord_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputxcoord_s1_slavearbiterlockenable <= 0;
      else if ((|outputxcoord_s1_master_qreq_vector & end_xfer_arb_share_counter_term_outputxcoord_s1) | (end_xfer_arb_share_counter_term_outputxcoord_s1 & ~outputxcoord_s1_non_bursting_master_requests))
          outputxcoord_s1_slavearbiterlockenable <= |outputxcoord_s1_arb_share_counter_next_value;
    end


  //cpu/data_master outputxcoord/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = outputxcoord_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //outputxcoord_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign outputxcoord_s1_slavearbiterlockenable2 = |outputxcoord_s1_arb_share_counter_next_value;

  //cpu/data_master outputxcoord/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = outputxcoord_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //outputxcoord_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign outputxcoord_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_outputxcoord_s1 = cpu_data_master_requests_outputxcoord_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_outputxcoord_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_outputxcoord_s1 = cpu_data_master_granted_outputxcoord_s1 & cpu_data_master_read & ~outputxcoord_s1_waits_for_read;

  //outputxcoord_s1_writedata mux, which is an e_mux
  assign outputxcoord_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_outputxcoord_s1 = cpu_data_master_qualified_request_outputxcoord_s1;

  //cpu/data_master saved-grant outputxcoord/s1, which is an e_assign
  assign cpu_data_master_saved_grant_outputxcoord_s1 = cpu_data_master_requests_outputxcoord_s1;

  //allow new arb cycle for outputxcoord/s1, which is an e_assign
  assign outputxcoord_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign outputxcoord_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign outputxcoord_s1_master_qreq_vector = 1;

  //outputxcoord_s1_reset_n assignment, which is an e_assign
  assign outputxcoord_s1_reset_n = reset_n;

  assign outputxcoord_s1_chipselect = cpu_data_master_granted_outputxcoord_s1;
  //outputxcoord_s1_firsttransfer first transaction, which is an e_assign
  assign outputxcoord_s1_firsttransfer = outputxcoord_s1_begins_xfer ? outputxcoord_s1_unreg_firsttransfer : outputxcoord_s1_reg_firsttransfer;

  //outputxcoord_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign outputxcoord_s1_unreg_firsttransfer = ~(outputxcoord_s1_slavearbiterlockenable & outputxcoord_s1_any_continuerequest);

  //outputxcoord_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputxcoord_s1_reg_firsttransfer <= 1'b1;
      else if (outputxcoord_s1_begins_xfer)
          outputxcoord_s1_reg_firsttransfer <= outputxcoord_s1_unreg_firsttransfer;
    end


  //outputxcoord_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign outputxcoord_s1_beginbursttransfer_internal = outputxcoord_s1_begins_xfer;

  //~outputxcoord_s1_write_n assignment, which is an e_mux
  assign outputxcoord_s1_write_n = ~(cpu_data_master_granted_outputxcoord_s1 & cpu_data_master_write);

  assign shifted_address_to_outputxcoord_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //outputxcoord_s1_address mux, which is an e_mux
  assign outputxcoord_s1_address = shifted_address_to_outputxcoord_s1_from_cpu_data_master >> 2;

  //d1_outputxcoord_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_outputxcoord_s1_end_xfer <= 1;
      else 
        d1_outputxcoord_s1_end_xfer <= outputxcoord_s1_end_xfer;
    end


  //outputxcoord_s1_waits_for_read in a cycle, which is an e_mux
  assign outputxcoord_s1_waits_for_read = outputxcoord_s1_in_a_read_cycle & outputxcoord_s1_begins_xfer;

  //outputxcoord_s1_in_a_read_cycle assignment, which is an e_assign
  assign outputxcoord_s1_in_a_read_cycle = cpu_data_master_granted_outputxcoord_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = outputxcoord_s1_in_a_read_cycle;

  //outputxcoord_s1_waits_for_write in a cycle, which is an e_mux
  assign outputxcoord_s1_waits_for_write = outputxcoord_s1_in_a_write_cycle & 0;

  //outputxcoord_s1_in_a_write_cycle assignment, which is an e_assign
  assign outputxcoord_s1_in_a_write_cycle = cpu_data_master_granted_outputxcoord_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = outputxcoord_s1_in_a_write_cycle;

  assign wait_for_outputxcoord_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //outputxcoord/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module outputycoord_s1_arbitrator (
                                    // inputs:
                                     clk,
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_latency_counter,
                                     cpu_data_master_read,
                                     cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     outputycoord_s1_readdata,
                                     reset_n,

                                    // outputs:
                                     cpu_data_master_granted_outputycoord_s1,
                                     cpu_data_master_qualified_request_outputycoord_s1,
                                     cpu_data_master_read_data_valid_outputycoord_s1,
                                     cpu_data_master_requests_outputycoord_s1,
                                     d1_outputycoord_s1_end_xfer,
                                     outputycoord_s1_address,
                                     outputycoord_s1_chipselect,
                                     outputycoord_s1_readdata_from_sa,
                                     outputycoord_s1_reset_n,
                                     outputycoord_s1_write_n,
                                     outputycoord_s1_writedata
                                  )
;

  output           cpu_data_master_granted_outputycoord_s1;
  output           cpu_data_master_qualified_request_outputycoord_s1;
  output           cpu_data_master_read_data_valid_outputycoord_s1;
  output           cpu_data_master_requests_outputycoord_s1;
  output           d1_outputycoord_s1_end_xfer;
  output  [  1: 0] outputycoord_s1_address;
  output           outputycoord_s1_chipselect;
  output  [ 31: 0] outputycoord_s1_readdata_from_sa;
  output           outputycoord_s1_reset_n;
  output           outputycoord_s1_write_n;
  output  [ 31: 0] outputycoord_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] outputycoord_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_outputycoord_s1;
  wire             cpu_data_master_qualified_request_outputycoord_s1;
  wire             cpu_data_master_read_data_valid_outputycoord_s1;
  wire             cpu_data_master_requests_outputycoord_s1;
  wire             cpu_data_master_saved_grant_outputycoord_s1;
  reg              d1_outputycoord_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_outputycoord_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] outputycoord_s1_address;
  wire             outputycoord_s1_allgrants;
  wire             outputycoord_s1_allow_new_arb_cycle;
  wire             outputycoord_s1_any_bursting_master_saved_grant;
  wire             outputycoord_s1_any_continuerequest;
  wire             outputycoord_s1_arb_counter_enable;
  reg     [  1: 0] outputycoord_s1_arb_share_counter;
  wire    [  1: 0] outputycoord_s1_arb_share_counter_next_value;
  wire    [  1: 0] outputycoord_s1_arb_share_set_values;
  wire             outputycoord_s1_beginbursttransfer_internal;
  wire             outputycoord_s1_begins_xfer;
  wire             outputycoord_s1_chipselect;
  wire             outputycoord_s1_end_xfer;
  wire             outputycoord_s1_firsttransfer;
  wire             outputycoord_s1_grant_vector;
  wire             outputycoord_s1_in_a_read_cycle;
  wire             outputycoord_s1_in_a_write_cycle;
  wire             outputycoord_s1_master_qreq_vector;
  wire             outputycoord_s1_non_bursting_master_requests;
  wire    [ 31: 0] outputycoord_s1_readdata_from_sa;
  reg              outputycoord_s1_reg_firsttransfer;
  wire             outputycoord_s1_reset_n;
  reg              outputycoord_s1_slavearbiterlockenable;
  wire             outputycoord_s1_slavearbiterlockenable2;
  wire             outputycoord_s1_unreg_firsttransfer;
  wire             outputycoord_s1_waits_for_read;
  wire             outputycoord_s1_waits_for_write;
  wire             outputycoord_s1_write_n;
  wire    [ 31: 0] outputycoord_s1_writedata;
  wire    [ 25: 0] shifted_address_to_outputycoord_s1_from_cpu_data_master;
  wire             wait_for_outputycoord_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~outputycoord_s1_end_xfer;
    end


  assign outputycoord_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_outputycoord_s1));
  //assign outputycoord_s1_readdata_from_sa = outputycoord_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign outputycoord_s1_readdata_from_sa = outputycoord_s1_readdata;

  assign cpu_data_master_requests_outputycoord_s1 = ({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h50) & (cpu_data_master_read | cpu_data_master_write);
  //outputycoord_s1_arb_share_counter set values, which is an e_mux
  assign outputycoord_s1_arb_share_set_values = 1;

  //outputycoord_s1_non_bursting_master_requests mux, which is an e_mux
  assign outputycoord_s1_non_bursting_master_requests = cpu_data_master_requests_outputycoord_s1;

  //outputycoord_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign outputycoord_s1_any_bursting_master_saved_grant = 0;

  //outputycoord_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign outputycoord_s1_arb_share_counter_next_value = outputycoord_s1_firsttransfer ? (outputycoord_s1_arb_share_set_values - 1) : |outputycoord_s1_arb_share_counter ? (outputycoord_s1_arb_share_counter - 1) : 0;

  //outputycoord_s1_allgrants all slave grants, which is an e_mux
  assign outputycoord_s1_allgrants = |outputycoord_s1_grant_vector;

  //outputycoord_s1_end_xfer assignment, which is an e_assign
  assign outputycoord_s1_end_xfer = ~(outputycoord_s1_waits_for_read | outputycoord_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_outputycoord_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_outputycoord_s1 = outputycoord_s1_end_xfer & (~outputycoord_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //outputycoord_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign outputycoord_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_outputycoord_s1 & outputycoord_s1_allgrants) | (end_xfer_arb_share_counter_term_outputycoord_s1 & ~outputycoord_s1_non_bursting_master_requests);

  //outputycoord_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputycoord_s1_arb_share_counter <= 0;
      else if (outputycoord_s1_arb_counter_enable)
          outputycoord_s1_arb_share_counter <= outputycoord_s1_arb_share_counter_next_value;
    end


  //outputycoord_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputycoord_s1_slavearbiterlockenable <= 0;
      else if ((|outputycoord_s1_master_qreq_vector & end_xfer_arb_share_counter_term_outputycoord_s1) | (end_xfer_arb_share_counter_term_outputycoord_s1 & ~outputycoord_s1_non_bursting_master_requests))
          outputycoord_s1_slavearbiterlockenable <= |outputycoord_s1_arb_share_counter_next_value;
    end


  //cpu/data_master outputycoord/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = outputycoord_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //outputycoord_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign outputycoord_s1_slavearbiterlockenable2 = |outputycoord_s1_arb_share_counter_next_value;

  //cpu/data_master outputycoord/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = outputycoord_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //outputycoord_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign outputycoord_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_outputycoord_s1 = cpu_data_master_requests_outputycoord_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_outputycoord_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_outputycoord_s1 = cpu_data_master_granted_outputycoord_s1 & cpu_data_master_read & ~outputycoord_s1_waits_for_read;

  //outputycoord_s1_writedata mux, which is an e_mux
  assign outputycoord_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_outputycoord_s1 = cpu_data_master_qualified_request_outputycoord_s1;

  //cpu/data_master saved-grant outputycoord/s1, which is an e_assign
  assign cpu_data_master_saved_grant_outputycoord_s1 = cpu_data_master_requests_outputycoord_s1;

  //allow new arb cycle for outputycoord/s1, which is an e_assign
  assign outputycoord_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign outputycoord_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign outputycoord_s1_master_qreq_vector = 1;

  //outputycoord_s1_reset_n assignment, which is an e_assign
  assign outputycoord_s1_reset_n = reset_n;

  assign outputycoord_s1_chipselect = cpu_data_master_granted_outputycoord_s1;
  //outputycoord_s1_firsttransfer first transaction, which is an e_assign
  assign outputycoord_s1_firsttransfer = outputycoord_s1_begins_xfer ? outputycoord_s1_unreg_firsttransfer : outputycoord_s1_reg_firsttransfer;

  //outputycoord_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign outputycoord_s1_unreg_firsttransfer = ~(outputycoord_s1_slavearbiterlockenable & outputycoord_s1_any_continuerequest);

  //outputycoord_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          outputycoord_s1_reg_firsttransfer <= 1'b1;
      else if (outputycoord_s1_begins_xfer)
          outputycoord_s1_reg_firsttransfer <= outputycoord_s1_unreg_firsttransfer;
    end


  //outputycoord_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign outputycoord_s1_beginbursttransfer_internal = outputycoord_s1_begins_xfer;

  //~outputycoord_s1_write_n assignment, which is an e_mux
  assign outputycoord_s1_write_n = ~(cpu_data_master_granted_outputycoord_s1 & cpu_data_master_write);

  assign shifted_address_to_outputycoord_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //outputycoord_s1_address mux, which is an e_mux
  assign outputycoord_s1_address = shifted_address_to_outputycoord_s1_from_cpu_data_master >> 2;

  //d1_outputycoord_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_outputycoord_s1_end_xfer <= 1;
      else 
        d1_outputycoord_s1_end_xfer <= outputycoord_s1_end_xfer;
    end


  //outputycoord_s1_waits_for_read in a cycle, which is an e_mux
  assign outputycoord_s1_waits_for_read = outputycoord_s1_in_a_read_cycle & outputycoord_s1_begins_xfer;

  //outputycoord_s1_in_a_read_cycle assignment, which is an e_assign
  assign outputycoord_s1_in_a_read_cycle = cpu_data_master_granted_outputycoord_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = outputycoord_s1_in_a_read_cycle;

  //outputycoord_s1_waits_for_write in a cycle, which is an e_mux
  assign outputycoord_s1_waits_for_write = outputycoord_s1_in_a_write_cycle & 0;

  //outputycoord_s1_in_a_write_cycle assignment, which is an e_assign
  assign outputycoord_s1_in_a_write_cycle = cpu_data_master_granted_outputycoord_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = outputycoord_s1_in_a_write_cycle;

  assign wait_for_outputycoord_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //outputycoord/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_flag_s1_arbitrator (
                                // inputs:
                                 clk,
                                 cpu_data_master_address_to_slave,
                                 cpu_data_master_latency_counter,
                                 cpu_data_master_read,
                                 cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                 cpu_data_master_write,
                                 cpu_data_master_writedata,
                                 pio_flag_s1_readdata,
                                 reset_n,

                                // outputs:
                                 cpu_data_master_granted_pio_flag_s1,
                                 cpu_data_master_qualified_request_pio_flag_s1,
                                 cpu_data_master_read_data_valid_pio_flag_s1,
                                 cpu_data_master_requests_pio_flag_s1,
                                 d1_pio_flag_s1_end_xfer,
                                 pio_flag_s1_address,
                                 pio_flag_s1_chipselect,
                                 pio_flag_s1_readdata_from_sa,
                                 pio_flag_s1_reset_n,
                                 pio_flag_s1_write_n,
                                 pio_flag_s1_writedata
                              )
;

  output           cpu_data_master_granted_pio_flag_s1;
  output           cpu_data_master_qualified_request_pio_flag_s1;
  output           cpu_data_master_read_data_valid_pio_flag_s1;
  output           cpu_data_master_requests_pio_flag_s1;
  output           d1_pio_flag_s1_end_xfer;
  output  [  1: 0] pio_flag_s1_address;
  output           pio_flag_s1_chipselect;
  output  [ 31: 0] pio_flag_s1_readdata_from_sa;
  output           pio_flag_s1_reset_n;
  output           pio_flag_s1_write_n;
  output  [ 31: 0] pio_flag_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] pio_flag_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_flag_s1;
  wire             cpu_data_master_qualified_request_pio_flag_s1;
  wire             cpu_data_master_read_data_valid_pio_flag_s1;
  wire             cpu_data_master_requests_pio_flag_s1;
  wire             cpu_data_master_saved_grant_pio_flag_s1;
  reg              d1_pio_flag_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_flag_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_flag_s1_address;
  wire             pio_flag_s1_allgrants;
  wire             pio_flag_s1_allow_new_arb_cycle;
  wire             pio_flag_s1_any_bursting_master_saved_grant;
  wire             pio_flag_s1_any_continuerequest;
  wire             pio_flag_s1_arb_counter_enable;
  reg     [  1: 0] pio_flag_s1_arb_share_counter;
  wire    [  1: 0] pio_flag_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_flag_s1_arb_share_set_values;
  wire             pio_flag_s1_beginbursttransfer_internal;
  wire             pio_flag_s1_begins_xfer;
  wire             pio_flag_s1_chipselect;
  wire             pio_flag_s1_end_xfer;
  wire             pio_flag_s1_firsttransfer;
  wire             pio_flag_s1_grant_vector;
  wire             pio_flag_s1_in_a_read_cycle;
  wire             pio_flag_s1_in_a_write_cycle;
  wire             pio_flag_s1_master_qreq_vector;
  wire             pio_flag_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_flag_s1_readdata_from_sa;
  reg              pio_flag_s1_reg_firsttransfer;
  wire             pio_flag_s1_reset_n;
  reg              pio_flag_s1_slavearbiterlockenable;
  wire             pio_flag_s1_slavearbiterlockenable2;
  wire             pio_flag_s1_unreg_firsttransfer;
  wire             pio_flag_s1_waits_for_read;
  wire             pio_flag_s1_waits_for_write;
  wire             pio_flag_s1_write_n;
  wire    [ 31: 0] pio_flag_s1_writedata;
  wire    [ 25: 0] shifted_address_to_pio_flag_s1_from_cpu_data_master;
  wire             wait_for_pio_flag_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_flag_s1_end_xfer;
    end


  assign pio_flag_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_flag_s1));
  //assign pio_flag_s1_readdata_from_sa = pio_flag_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_flag_s1_readdata_from_sa = pio_flag_s1_readdata;

  assign cpu_data_master_requests_pio_flag_s1 = ({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h170) & (cpu_data_master_read | cpu_data_master_write);
  //pio_flag_s1_arb_share_counter set values, which is an e_mux
  assign pio_flag_s1_arb_share_set_values = 1;

  //pio_flag_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_flag_s1_non_bursting_master_requests = cpu_data_master_requests_pio_flag_s1;

  //pio_flag_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_flag_s1_any_bursting_master_saved_grant = 0;

  //pio_flag_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_flag_s1_arb_share_counter_next_value = pio_flag_s1_firsttransfer ? (pio_flag_s1_arb_share_set_values - 1) : |pio_flag_s1_arb_share_counter ? (pio_flag_s1_arb_share_counter - 1) : 0;

  //pio_flag_s1_allgrants all slave grants, which is an e_mux
  assign pio_flag_s1_allgrants = |pio_flag_s1_grant_vector;

  //pio_flag_s1_end_xfer assignment, which is an e_assign
  assign pio_flag_s1_end_xfer = ~(pio_flag_s1_waits_for_read | pio_flag_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_flag_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_flag_s1 = pio_flag_s1_end_xfer & (~pio_flag_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_flag_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_flag_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_flag_s1 & pio_flag_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_flag_s1 & ~pio_flag_s1_non_bursting_master_requests);

  //pio_flag_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_flag_s1_arb_share_counter <= 0;
      else if (pio_flag_s1_arb_counter_enable)
          pio_flag_s1_arb_share_counter <= pio_flag_s1_arb_share_counter_next_value;
    end


  //pio_flag_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_flag_s1_slavearbiterlockenable <= 0;
      else if ((|pio_flag_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_flag_s1) | (end_xfer_arb_share_counter_term_pio_flag_s1 & ~pio_flag_s1_non_bursting_master_requests))
          pio_flag_s1_slavearbiterlockenable <= |pio_flag_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_flag/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_flag_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_flag_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_flag_s1_slavearbiterlockenable2 = |pio_flag_s1_arb_share_counter_next_value;

  //cpu/data_master pio_flag/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_flag_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_flag_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_flag_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_flag_s1 = cpu_data_master_requests_pio_flag_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_pio_flag_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_pio_flag_s1 = cpu_data_master_granted_pio_flag_s1 & cpu_data_master_read & ~pio_flag_s1_waits_for_read;

  //pio_flag_s1_writedata mux, which is an e_mux
  assign pio_flag_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_flag_s1 = cpu_data_master_qualified_request_pio_flag_s1;

  //cpu/data_master saved-grant pio_flag/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_flag_s1 = cpu_data_master_requests_pio_flag_s1;

  //allow new arb cycle for pio_flag/s1, which is an e_assign
  assign pio_flag_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_flag_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_flag_s1_master_qreq_vector = 1;

  //pio_flag_s1_reset_n assignment, which is an e_assign
  assign pio_flag_s1_reset_n = reset_n;

  assign pio_flag_s1_chipselect = cpu_data_master_granted_pio_flag_s1;
  //pio_flag_s1_firsttransfer first transaction, which is an e_assign
  assign pio_flag_s1_firsttransfer = pio_flag_s1_begins_xfer ? pio_flag_s1_unreg_firsttransfer : pio_flag_s1_reg_firsttransfer;

  //pio_flag_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_flag_s1_unreg_firsttransfer = ~(pio_flag_s1_slavearbiterlockenable & pio_flag_s1_any_continuerequest);

  //pio_flag_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_flag_s1_reg_firsttransfer <= 1'b1;
      else if (pio_flag_s1_begins_xfer)
          pio_flag_s1_reg_firsttransfer <= pio_flag_s1_unreg_firsttransfer;
    end


  //pio_flag_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_flag_s1_beginbursttransfer_internal = pio_flag_s1_begins_xfer;

  //~pio_flag_s1_write_n assignment, which is an e_mux
  assign pio_flag_s1_write_n = ~(cpu_data_master_granted_pio_flag_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_flag_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_flag_s1_address mux, which is an e_mux
  assign pio_flag_s1_address = shifted_address_to_pio_flag_s1_from_cpu_data_master >> 2;

  //d1_pio_flag_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_flag_s1_end_xfer <= 1;
      else 
        d1_pio_flag_s1_end_xfer <= pio_flag_s1_end_xfer;
    end


  //pio_flag_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_flag_s1_waits_for_read = pio_flag_s1_in_a_read_cycle & pio_flag_s1_begins_xfer;

  //pio_flag_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_flag_s1_in_a_read_cycle = cpu_data_master_granted_pio_flag_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_flag_s1_in_a_read_cycle;

  //pio_flag_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_flag_s1_waits_for_write = pio_flag_s1_in_a_write_cycle & 0;

  //pio_flag_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_flag_s1_in_a_write_cycle = cpu_data_master_granted_pio_flag_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_flag_s1_in_a_write_cycle;

  assign wait_for_pio_flag_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_flag/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module scoreofplayer_s1_arbitrator (
                                     // inputs:
                                      clk,
                                      cpu_data_master_address_to_slave,
                                      cpu_data_master_latency_counter,
                                      cpu_data_master_read,
                                      cpu_data_master_read_data_valid_sdram_s1_shift_register,
                                      cpu_data_master_write,
                                      cpu_data_master_writedata,
                                      reset_n,
                                      scoreofplayer_s1_readdata,

                                     // outputs:
                                      cpu_data_master_granted_scoreofplayer_s1,
                                      cpu_data_master_qualified_request_scoreofplayer_s1,
                                      cpu_data_master_read_data_valid_scoreofplayer_s1,
                                      cpu_data_master_requests_scoreofplayer_s1,
                                      d1_scoreofplayer_s1_end_xfer,
                                      scoreofplayer_s1_address,
                                      scoreofplayer_s1_chipselect,
                                      scoreofplayer_s1_readdata_from_sa,
                                      scoreofplayer_s1_reset_n,
                                      scoreofplayer_s1_write_n,
                                      scoreofplayer_s1_writedata
                                   )
;

  output           cpu_data_master_granted_scoreofplayer_s1;
  output           cpu_data_master_qualified_request_scoreofplayer_s1;
  output           cpu_data_master_read_data_valid_scoreofplayer_s1;
  output           cpu_data_master_requests_scoreofplayer_s1;
  output           d1_scoreofplayer_s1_end_xfer;
  output  [  1: 0] scoreofplayer_s1_address;
  output           scoreofplayer_s1_chipselect;
  output  [ 31: 0] scoreofplayer_s1_readdata_from_sa;
  output           scoreofplayer_s1_reset_n;
  output           scoreofplayer_s1_write_n;
  output  [ 31: 0] scoreofplayer_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input            reset_n;
  input   [ 31: 0] scoreofplayer_s1_readdata;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_scoreofplayer_s1;
  wire             cpu_data_master_qualified_request_scoreofplayer_s1;
  wire             cpu_data_master_read_data_valid_scoreofplayer_s1;
  wire             cpu_data_master_requests_scoreofplayer_s1;
  wire             cpu_data_master_saved_grant_scoreofplayer_s1;
  reg              d1_reasons_to_wait;
  reg              d1_scoreofplayer_s1_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_scoreofplayer_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] scoreofplayer_s1_address;
  wire             scoreofplayer_s1_allgrants;
  wire             scoreofplayer_s1_allow_new_arb_cycle;
  wire             scoreofplayer_s1_any_bursting_master_saved_grant;
  wire             scoreofplayer_s1_any_continuerequest;
  wire             scoreofplayer_s1_arb_counter_enable;
  reg     [  1: 0] scoreofplayer_s1_arb_share_counter;
  wire    [  1: 0] scoreofplayer_s1_arb_share_counter_next_value;
  wire    [  1: 0] scoreofplayer_s1_arb_share_set_values;
  wire             scoreofplayer_s1_beginbursttransfer_internal;
  wire             scoreofplayer_s1_begins_xfer;
  wire             scoreofplayer_s1_chipselect;
  wire             scoreofplayer_s1_end_xfer;
  wire             scoreofplayer_s1_firsttransfer;
  wire             scoreofplayer_s1_grant_vector;
  wire             scoreofplayer_s1_in_a_read_cycle;
  wire             scoreofplayer_s1_in_a_write_cycle;
  wire             scoreofplayer_s1_master_qreq_vector;
  wire             scoreofplayer_s1_non_bursting_master_requests;
  wire    [ 31: 0] scoreofplayer_s1_readdata_from_sa;
  reg              scoreofplayer_s1_reg_firsttransfer;
  wire             scoreofplayer_s1_reset_n;
  reg              scoreofplayer_s1_slavearbiterlockenable;
  wire             scoreofplayer_s1_slavearbiterlockenable2;
  wire             scoreofplayer_s1_unreg_firsttransfer;
  wire             scoreofplayer_s1_waits_for_read;
  wire             scoreofplayer_s1_waits_for_write;
  wire             scoreofplayer_s1_write_n;
  wire    [ 31: 0] scoreofplayer_s1_writedata;
  wire    [ 25: 0] shifted_address_to_scoreofplayer_s1_from_cpu_data_master;
  wire             wait_for_scoreofplayer_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~scoreofplayer_s1_end_xfer;
    end


  assign scoreofplayer_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_scoreofplayer_s1));
  //assign scoreofplayer_s1_readdata_from_sa = scoreofplayer_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign scoreofplayer_s1_readdata_from_sa = scoreofplayer_s1_readdata;

  assign cpu_data_master_requests_scoreofplayer_s1 = ({cpu_data_master_address_to_slave[25 : 4] , 4'b0} == 26'h160) & (cpu_data_master_read | cpu_data_master_write);
  //scoreofplayer_s1_arb_share_counter set values, which is an e_mux
  assign scoreofplayer_s1_arb_share_set_values = 1;

  //scoreofplayer_s1_non_bursting_master_requests mux, which is an e_mux
  assign scoreofplayer_s1_non_bursting_master_requests = cpu_data_master_requests_scoreofplayer_s1;

  //scoreofplayer_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign scoreofplayer_s1_any_bursting_master_saved_grant = 0;

  //scoreofplayer_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign scoreofplayer_s1_arb_share_counter_next_value = scoreofplayer_s1_firsttransfer ? (scoreofplayer_s1_arb_share_set_values - 1) : |scoreofplayer_s1_arb_share_counter ? (scoreofplayer_s1_arb_share_counter - 1) : 0;

  //scoreofplayer_s1_allgrants all slave grants, which is an e_mux
  assign scoreofplayer_s1_allgrants = |scoreofplayer_s1_grant_vector;

  //scoreofplayer_s1_end_xfer assignment, which is an e_assign
  assign scoreofplayer_s1_end_xfer = ~(scoreofplayer_s1_waits_for_read | scoreofplayer_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_scoreofplayer_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_scoreofplayer_s1 = scoreofplayer_s1_end_xfer & (~scoreofplayer_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //scoreofplayer_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign scoreofplayer_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_scoreofplayer_s1 & scoreofplayer_s1_allgrants) | (end_xfer_arb_share_counter_term_scoreofplayer_s1 & ~scoreofplayer_s1_non_bursting_master_requests);

  //scoreofplayer_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          scoreofplayer_s1_arb_share_counter <= 0;
      else if (scoreofplayer_s1_arb_counter_enable)
          scoreofplayer_s1_arb_share_counter <= scoreofplayer_s1_arb_share_counter_next_value;
    end


  //scoreofplayer_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          scoreofplayer_s1_slavearbiterlockenable <= 0;
      else if ((|scoreofplayer_s1_master_qreq_vector & end_xfer_arb_share_counter_term_scoreofplayer_s1) | (end_xfer_arb_share_counter_term_scoreofplayer_s1 & ~scoreofplayer_s1_non_bursting_master_requests))
          scoreofplayer_s1_slavearbiterlockenable <= |scoreofplayer_s1_arb_share_counter_next_value;
    end


  //cpu/data_master scoreofplayer/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = scoreofplayer_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //scoreofplayer_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign scoreofplayer_s1_slavearbiterlockenable2 = |scoreofplayer_s1_arb_share_counter_next_value;

  //cpu/data_master scoreofplayer/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = scoreofplayer_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //scoreofplayer_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign scoreofplayer_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_scoreofplayer_s1 = cpu_data_master_requests_scoreofplayer_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_scoreofplayer_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_scoreofplayer_s1 = cpu_data_master_granted_scoreofplayer_s1 & cpu_data_master_read & ~scoreofplayer_s1_waits_for_read;

  //scoreofplayer_s1_writedata mux, which is an e_mux
  assign scoreofplayer_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_scoreofplayer_s1 = cpu_data_master_qualified_request_scoreofplayer_s1;

  //cpu/data_master saved-grant scoreofplayer/s1, which is an e_assign
  assign cpu_data_master_saved_grant_scoreofplayer_s1 = cpu_data_master_requests_scoreofplayer_s1;

  //allow new arb cycle for scoreofplayer/s1, which is an e_assign
  assign scoreofplayer_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign scoreofplayer_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign scoreofplayer_s1_master_qreq_vector = 1;

  //scoreofplayer_s1_reset_n assignment, which is an e_assign
  assign scoreofplayer_s1_reset_n = reset_n;

  assign scoreofplayer_s1_chipselect = cpu_data_master_granted_scoreofplayer_s1;
  //scoreofplayer_s1_firsttransfer first transaction, which is an e_assign
  assign scoreofplayer_s1_firsttransfer = scoreofplayer_s1_begins_xfer ? scoreofplayer_s1_unreg_firsttransfer : scoreofplayer_s1_reg_firsttransfer;

  //scoreofplayer_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign scoreofplayer_s1_unreg_firsttransfer = ~(scoreofplayer_s1_slavearbiterlockenable & scoreofplayer_s1_any_continuerequest);

  //scoreofplayer_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          scoreofplayer_s1_reg_firsttransfer <= 1'b1;
      else if (scoreofplayer_s1_begins_xfer)
          scoreofplayer_s1_reg_firsttransfer <= scoreofplayer_s1_unreg_firsttransfer;
    end


  //scoreofplayer_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign scoreofplayer_s1_beginbursttransfer_internal = scoreofplayer_s1_begins_xfer;

  //~scoreofplayer_s1_write_n assignment, which is an e_mux
  assign scoreofplayer_s1_write_n = ~(cpu_data_master_granted_scoreofplayer_s1 & cpu_data_master_write);

  assign shifted_address_to_scoreofplayer_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //scoreofplayer_s1_address mux, which is an e_mux
  assign scoreofplayer_s1_address = shifted_address_to_scoreofplayer_s1_from_cpu_data_master >> 2;

  //d1_scoreofplayer_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_scoreofplayer_s1_end_xfer <= 1;
      else 
        d1_scoreofplayer_s1_end_xfer <= scoreofplayer_s1_end_xfer;
    end


  //scoreofplayer_s1_waits_for_read in a cycle, which is an e_mux
  assign scoreofplayer_s1_waits_for_read = scoreofplayer_s1_in_a_read_cycle & scoreofplayer_s1_begins_xfer;

  //scoreofplayer_s1_in_a_read_cycle assignment, which is an e_assign
  assign scoreofplayer_s1_in_a_read_cycle = cpu_data_master_granted_scoreofplayer_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = scoreofplayer_s1_in_a_read_cycle;

  //scoreofplayer_s1_waits_for_write in a cycle, which is an e_mux
  assign scoreofplayer_s1_waits_for_write = scoreofplayer_s1_in_a_write_cycle & 0;

  //scoreofplayer_s1_in_a_write_cycle assignment, which is an e_assign
  assign scoreofplayer_s1_in_a_write_cycle = cpu_data_master_granted_scoreofplayer_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = scoreofplayer_s1_in_a_write_cycle;

  assign wait_for_scoreofplayer_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //scoreofplayer/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module rdv_fifo_for_cpu_data_master_to_sdram_s1_module (
                                                         // inputs:
                                                          clear_fifo,
                                                          clk,
                                                          data_in,
                                                          read,
                                                          reset_n,
                                                          sync_reset,
                                                          write,

                                                         // outputs:
                                                          data_out,
                                                          empty,
                                                          fifo_contains_ones_n,
                                                          full
                                                       )
;

  output           data_out;
  output           empty;
  output           fifo_contains_ones_n;
  output           full;
  input            clear_fifo;
  input            clk;
  input            data_in;
  input            read;
  input            reset_n;
  input            sync_reset;
  input            write;

  wire             data_out;
  wire             empty;
  reg              fifo_contains_ones_n;
  wire             full;
  reg              full_0;
  reg              full_1;
  reg              full_2;
  reg              full_3;
  reg              full_4;
  reg              full_5;
  reg              full_6;
  wire             full_7;
  reg     [  3: 0] how_many_ones;
  wire    [  3: 0] one_count_minus_one;
  wire    [  3: 0] one_count_plus_one;
  wire             p0_full_0;
  wire             p0_stage_0;
  wire             p1_full_1;
  wire             p1_stage_1;
  wire             p2_full_2;
  wire             p2_stage_2;
  wire             p3_full_3;
  wire             p3_stage_3;
  wire             p4_full_4;
  wire             p4_stage_4;
  wire             p5_full_5;
  wire             p5_stage_5;
  wire             p6_full_6;
  wire             p6_stage_6;
  reg              stage_0;
  reg              stage_1;
  reg              stage_2;
  reg              stage_3;
  reg              stage_4;
  reg              stage_5;
  reg              stage_6;
  wire    [  3: 0] updated_one_count;
  assign data_out = stage_0;
  assign full = full_6;
  assign empty = !full_0;
  assign full_7 = 0;
  //data_6, which is an e_mux
  assign p6_stage_6 = ((full_7 & ~clear_fifo) == 0)? data_in :
    data_in;

  //data_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_6 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_6))
          if (sync_reset & full_6 & !((full_7 == 0) & read & write))
              stage_6 <= 0;
          else 
            stage_6 <= p6_stage_6;
    end


  //control_6, which is an e_mux
  assign p6_full_6 = ((read & !write) == 0)? full_5 :
    0;

  //control_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_6 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_6 <= 0;
          else 
            full_6 <= p6_full_6;
    end


  //data_5, which is an e_mux
  assign p5_stage_5 = ((full_6 & ~clear_fifo) == 0)? data_in :
    stage_6;

  //data_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_5 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_5))
          if (sync_reset & full_5 & !((full_6 == 0) & read & write))
              stage_5 <= 0;
          else 
            stage_5 <= p5_stage_5;
    end


  //control_5, which is an e_mux
  assign p5_full_5 = ((read & !write) == 0)? full_4 :
    full_6;

  //control_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_5 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_5 <= 0;
          else 
            full_5 <= p5_full_5;
    end


  //data_4, which is an e_mux
  assign p4_stage_4 = ((full_5 & ~clear_fifo) == 0)? data_in :
    stage_5;

  //data_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_4 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_4))
          if (sync_reset & full_4 & !((full_5 == 0) & read & write))
              stage_4 <= 0;
          else 
            stage_4 <= p4_stage_4;
    end


  //control_4, which is an e_mux
  assign p4_full_4 = ((read & !write) == 0)? full_3 :
    full_5;

  //control_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_4 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_4 <= 0;
          else 
            full_4 <= p4_full_4;
    end


  //data_3, which is an e_mux
  assign p3_stage_3 = ((full_4 & ~clear_fifo) == 0)? data_in :
    stage_4;

  //data_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_3 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_3))
          if (sync_reset & full_3 & !((full_4 == 0) & read & write))
              stage_3 <= 0;
          else 
            stage_3 <= p3_stage_3;
    end


  //control_3, which is an e_mux
  assign p3_full_3 = ((read & !write) == 0)? full_2 :
    full_4;

  //control_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_3 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_3 <= 0;
          else 
            full_3 <= p3_full_3;
    end


  //data_2, which is an e_mux
  assign p2_stage_2 = ((full_3 & ~clear_fifo) == 0)? data_in :
    stage_3;

  //data_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_2 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_2))
          if (sync_reset & full_2 & !((full_3 == 0) & read & write))
              stage_2 <= 0;
          else 
            stage_2 <= p2_stage_2;
    end


  //control_2, which is an e_mux
  assign p2_full_2 = ((read & !write) == 0)? full_1 :
    full_3;

  //control_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_2 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_2 <= 0;
          else 
            full_2 <= p2_full_2;
    end


  //data_1, which is an e_mux
  assign p1_stage_1 = ((full_2 & ~clear_fifo) == 0)? data_in :
    stage_2;

  //data_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_1 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_1))
          if (sync_reset & full_1 & !((full_2 == 0) & read & write))
              stage_1 <= 0;
          else 
            stage_1 <= p1_stage_1;
    end


  //control_1, which is an e_mux
  assign p1_full_1 = ((read & !write) == 0)? full_0 :
    full_2;

  //control_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_1 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_1 <= 0;
          else 
            full_1 <= p1_full_1;
    end


  //data_0, which is an e_mux
  assign p0_stage_0 = ((full_1 & ~clear_fifo) == 0)? data_in :
    stage_1;

  //data_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_0 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_0))
          if (sync_reset & full_0 & !((full_1 == 0) & read & write))
              stage_0 <= 0;
          else 
            stage_0 <= p0_stage_0;
    end


  //control_0, which is an e_mux
  assign p0_full_0 = ((read & !write) == 0)? 1 :
    full_1;

  //control_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_0 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo & ~write)
              full_0 <= 0;
          else 
            full_0 <= p0_full_0;
    end


  assign one_count_plus_one = how_many_ones + 1;
  assign one_count_minus_one = how_many_ones - 1;
  //updated_one_count, which is an e_mux
  assign updated_one_count = ((((clear_fifo | sync_reset) & !write)))? 0 :
    ((((clear_fifo | sync_reset) & write)))? |data_in :
    ((read & (|data_in) & write & (|stage_0)))? how_many_ones :
    ((write & (|data_in)))? one_count_plus_one :
    ((read & (|stage_0)))? one_count_minus_one :
    how_many_ones;

  //counts how many ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          how_many_ones <= 0;
      else if (clear_fifo | sync_reset | read | write)
          how_many_ones <= updated_one_count;
    end


  //this fifo contains ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          fifo_contains_ones_n <= 1;
      else if (clear_fifo | sync_reset | read | write)
          fifo_contains_ones_n <= ~(|updated_one_count);
    end



endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module rdv_fifo_for_cpu_instruction_master_to_sdram_s1_module (
                                                                // inputs:
                                                                 clear_fifo,
                                                                 clk,
                                                                 data_in,
                                                                 read,
                                                                 reset_n,
                                                                 sync_reset,
                                                                 write,

                                                                // outputs:
                                                                 data_out,
                                                                 empty,
                                                                 fifo_contains_ones_n,
                                                                 full
                                                              )
;

  output           data_out;
  output           empty;
  output           fifo_contains_ones_n;
  output           full;
  input            clear_fifo;
  input            clk;
  input            data_in;
  input            read;
  input            reset_n;
  input            sync_reset;
  input            write;

  wire             data_out;
  wire             empty;
  reg              fifo_contains_ones_n;
  wire             full;
  reg              full_0;
  reg              full_1;
  reg              full_2;
  reg              full_3;
  reg              full_4;
  reg              full_5;
  reg              full_6;
  wire             full_7;
  reg     [  3: 0] how_many_ones;
  wire    [  3: 0] one_count_minus_one;
  wire    [  3: 0] one_count_plus_one;
  wire             p0_full_0;
  wire             p0_stage_0;
  wire             p1_full_1;
  wire             p1_stage_1;
  wire             p2_full_2;
  wire             p2_stage_2;
  wire             p3_full_3;
  wire             p3_stage_3;
  wire             p4_full_4;
  wire             p4_stage_4;
  wire             p5_full_5;
  wire             p5_stage_5;
  wire             p6_full_6;
  wire             p6_stage_6;
  reg              stage_0;
  reg              stage_1;
  reg              stage_2;
  reg              stage_3;
  reg              stage_4;
  reg              stage_5;
  reg              stage_6;
  wire    [  3: 0] updated_one_count;
  assign data_out = stage_0;
  assign full = full_6;
  assign empty = !full_0;
  assign full_7 = 0;
  //data_6, which is an e_mux
  assign p6_stage_6 = ((full_7 & ~clear_fifo) == 0)? data_in :
    data_in;

  //data_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_6 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_6))
          if (sync_reset & full_6 & !((full_7 == 0) & read & write))
              stage_6 <= 0;
          else 
            stage_6 <= p6_stage_6;
    end


  //control_6, which is an e_mux
  assign p6_full_6 = ((read & !write) == 0)? full_5 :
    0;

  //control_reg_6, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_6 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_6 <= 0;
          else 
            full_6 <= p6_full_6;
    end


  //data_5, which is an e_mux
  assign p5_stage_5 = ((full_6 & ~clear_fifo) == 0)? data_in :
    stage_6;

  //data_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_5 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_5))
          if (sync_reset & full_5 & !((full_6 == 0) & read & write))
              stage_5 <= 0;
          else 
            stage_5 <= p5_stage_5;
    end


  //control_5, which is an e_mux
  assign p5_full_5 = ((read & !write) == 0)? full_4 :
    full_6;

  //control_reg_5, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_5 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_5 <= 0;
          else 
            full_5 <= p5_full_5;
    end


  //data_4, which is an e_mux
  assign p4_stage_4 = ((full_5 & ~clear_fifo) == 0)? data_in :
    stage_5;

  //data_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_4 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_4))
          if (sync_reset & full_4 & !((full_5 == 0) & read & write))
              stage_4 <= 0;
          else 
            stage_4 <= p4_stage_4;
    end


  //control_4, which is an e_mux
  assign p4_full_4 = ((read & !write) == 0)? full_3 :
    full_5;

  //control_reg_4, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_4 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_4 <= 0;
          else 
            full_4 <= p4_full_4;
    end


  //data_3, which is an e_mux
  assign p3_stage_3 = ((full_4 & ~clear_fifo) == 0)? data_in :
    stage_4;

  //data_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_3 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_3))
          if (sync_reset & full_3 & !((full_4 == 0) & read & write))
              stage_3 <= 0;
          else 
            stage_3 <= p3_stage_3;
    end


  //control_3, which is an e_mux
  assign p3_full_3 = ((read & !write) == 0)? full_2 :
    full_4;

  //control_reg_3, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_3 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_3 <= 0;
          else 
            full_3 <= p3_full_3;
    end


  //data_2, which is an e_mux
  assign p2_stage_2 = ((full_3 & ~clear_fifo) == 0)? data_in :
    stage_3;

  //data_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_2 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_2))
          if (sync_reset & full_2 & !((full_3 == 0) & read & write))
              stage_2 <= 0;
          else 
            stage_2 <= p2_stage_2;
    end


  //control_2, which is an e_mux
  assign p2_full_2 = ((read & !write) == 0)? full_1 :
    full_3;

  //control_reg_2, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_2 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_2 <= 0;
          else 
            full_2 <= p2_full_2;
    end


  //data_1, which is an e_mux
  assign p1_stage_1 = ((full_2 & ~clear_fifo) == 0)? data_in :
    stage_2;

  //data_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_1 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_1))
          if (sync_reset & full_1 & !((full_2 == 0) & read & write))
              stage_1 <= 0;
          else 
            stage_1 <= p1_stage_1;
    end


  //control_1, which is an e_mux
  assign p1_full_1 = ((read & !write) == 0)? full_0 :
    full_2;

  //control_reg_1, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_1 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo)
              full_1 <= 0;
          else 
            full_1 <= p1_full_1;
    end


  //data_0, which is an e_mux
  assign p0_stage_0 = ((full_1 & ~clear_fifo) == 0)? data_in :
    stage_1;

  //data_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          stage_0 <= 0;
      else if (clear_fifo | sync_reset | read | (write & !full_0))
          if (sync_reset & full_0 & !((full_1 == 0) & read & write))
              stage_0 <= 0;
          else 
            stage_0 <= p0_stage_0;
    end


  //control_0, which is an e_mux
  assign p0_full_0 = ((read & !write) == 0)? 1 :
    full_1;

  //control_reg_0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          full_0 <= 0;
      else if (clear_fifo | (read ^ write) | (write & !full_0))
          if (clear_fifo & ~write)
              full_0 <= 0;
          else 
            full_0 <= p0_full_0;
    end


  assign one_count_plus_one = how_many_ones + 1;
  assign one_count_minus_one = how_many_ones - 1;
  //updated_one_count, which is an e_mux
  assign updated_one_count = ((((clear_fifo | sync_reset) & !write)))? 0 :
    ((((clear_fifo | sync_reset) & write)))? |data_in :
    ((read & (|data_in) & write & (|stage_0)))? how_many_ones :
    ((write & (|data_in)))? one_count_plus_one :
    ((read & (|stage_0)))? one_count_minus_one :
    how_many_ones;

  //counts how many ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          how_many_ones <= 0;
      else if (clear_fifo | sync_reset | read | write)
          how_many_ones <= updated_one_count;
    end


  //this fifo contains ones in the data pipeline, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          fifo_contains_ones_n <= 1;
      else if (clear_fifo | sync_reset | read | write)
          fifo_contains_ones_n <= ~(|updated_one_count);
    end



endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module sdram_s1_arbitrator (
                             // inputs:
                              clk,
                              cpu_data_master_address_to_slave,
                              cpu_data_master_byteenable,
                              cpu_data_master_dbs_address,
                              cpu_data_master_dbs_write_16,
                              cpu_data_master_latency_counter,
                              cpu_data_master_read,
                              cpu_data_master_write,
                              cpu_instruction_master_address_to_slave,
                              cpu_instruction_master_dbs_address,
                              cpu_instruction_master_latency_counter,
                              cpu_instruction_master_read,
                              reset_n,
                              sdram_s1_readdata,
                              sdram_s1_readdatavalid,
                              sdram_s1_waitrequest,

                             // outputs:
                              cpu_data_master_byteenable_sdram_s1,
                              cpu_data_master_granted_sdram_s1,
                              cpu_data_master_qualified_request_sdram_s1,
                              cpu_data_master_read_data_valid_sdram_s1,
                              cpu_data_master_read_data_valid_sdram_s1_shift_register,
                              cpu_data_master_requests_sdram_s1,
                              cpu_instruction_master_granted_sdram_s1,
                              cpu_instruction_master_qualified_request_sdram_s1,
                              cpu_instruction_master_read_data_valid_sdram_s1,
                              cpu_instruction_master_read_data_valid_sdram_s1_shift_register,
                              cpu_instruction_master_requests_sdram_s1,
                              d1_sdram_s1_end_xfer,
                              sdram_s1_address,
                              sdram_s1_byteenable_n,
                              sdram_s1_chipselect,
                              sdram_s1_read_n,
                              sdram_s1_readdata_from_sa,
                              sdram_s1_reset_n,
                              sdram_s1_waitrequest_from_sa,
                              sdram_s1_write_n,
                              sdram_s1_writedata
                           )
;

  output  [  1: 0] cpu_data_master_byteenable_sdram_s1;
  output           cpu_data_master_granted_sdram_s1;
  output           cpu_data_master_qualified_request_sdram_s1;
  output           cpu_data_master_read_data_valid_sdram_s1;
  output           cpu_data_master_read_data_valid_sdram_s1_shift_register;
  output           cpu_data_master_requests_sdram_s1;
  output           cpu_instruction_master_granted_sdram_s1;
  output           cpu_instruction_master_qualified_request_sdram_s1;
  output           cpu_instruction_master_read_data_valid_sdram_s1;
  output           cpu_instruction_master_read_data_valid_sdram_s1_shift_register;
  output           cpu_instruction_master_requests_sdram_s1;
  output           d1_sdram_s1_end_xfer;
  output  [ 21: 0] sdram_s1_address;
  output  [  1: 0] sdram_s1_byteenable_n;
  output           sdram_s1_chipselect;
  output           sdram_s1_read_n;
  output  [ 15: 0] sdram_s1_readdata_from_sa;
  output           sdram_s1_reset_n;
  output           sdram_s1_waitrequest_from_sa;
  output           sdram_s1_write_n;
  output  [ 15: 0] sdram_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input   [  3: 0] cpu_data_master_byteenable;
  input   [  1: 0] cpu_data_master_dbs_address;
  input   [ 15: 0] cpu_data_master_dbs_write_16;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_write;
  input   [ 25: 0] cpu_instruction_master_address_to_slave;
  input   [  1: 0] cpu_instruction_master_dbs_address;
  input            cpu_instruction_master_latency_counter;
  input            cpu_instruction_master_read;
  input            reset_n;
  input   [ 15: 0] sdram_s1_readdata;
  input            sdram_s1_readdatavalid;
  input            sdram_s1_waitrequest;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire    [  1: 0] cpu_data_master_byteenable_sdram_s1;
  wire    [  1: 0] cpu_data_master_byteenable_sdram_s1_segment_0;
  wire    [  1: 0] cpu_data_master_byteenable_sdram_s1_segment_1;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_sdram_s1;
  wire             cpu_data_master_qualified_request_sdram_s1;
  wire             cpu_data_master_rdv_fifo_empty_sdram_s1;
  wire             cpu_data_master_rdv_fifo_output_from_sdram_s1;
  wire             cpu_data_master_read_data_valid_sdram_s1;
  wire             cpu_data_master_read_data_valid_sdram_s1_shift_register;
  wire             cpu_data_master_requests_sdram_s1;
  wire             cpu_data_master_saved_grant_sdram_s1;
  wire             cpu_instruction_master_arbiterlock;
  wire             cpu_instruction_master_arbiterlock2;
  wire             cpu_instruction_master_continuerequest;
  wire             cpu_instruction_master_granted_sdram_s1;
  wire             cpu_instruction_master_qualified_request_sdram_s1;
  wire             cpu_instruction_master_rdv_fifo_empty_sdram_s1;
  wire             cpu_instruction_master_rdv_fifo_output_from_sdram_s1;
  wire             cpu_instruction_master_read_data_valid_sdram_s1;
  wire             cpu_instruction_master_read_data_valid_sdram_s1_shift_register;
  wire             cpu_instruction_master_requests_sdram_s1;
  wire             cpu_instruction_master_saved_grant_sdram_s1;
  reg              d1_reasons_to_wait;
  reg              d1_sdram_s1_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_sdram_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_data_master_granted_slave_sdram_s1;
  reg              last_cycle_cpu_instruction_master_granted_slave_sdram_s1;
  wire    [ 21: 0] sdram_s1_address;
  wire             sdram_s1_allgrants;
  wire             sdram_s1_allow_new_arb_cycle;
  wire             sdram_s1_any_bursting_master_saved_grant;
  wire             sdram_s1_any_continuerequest;
  reg     [  1: 0] sdram_s1_arb_addend;
  wire             sdram_s1_arb_counter_enable;
  reg     [  1: 0] sdram_s1_arb_share_counter;
  wire    [  1: 0] sdram_s1_arb_share_counter_next_value;
  wire    [  1: 0] sdram_s1_arb_share_set_values;
  wire    [  1: 0] sdram_s1_arb_winner;
  wire             sdram_s1_arbitration_holdoff_internal;
  wire             sdram_s1_beginbursttransfer_internal;
  wire             sdram_s1_begins_xfer;
  wire    [  1: 0] sdram_s1_byteenable_n;
  wire             sdram_s1_chipselect;
  wire    [  3: 0] sdram_s1_chosen_master_double_vector;
  wire    [  1: 0] sdram_s1_chosen_master_rot_left;
  wire             sdram_s1_end_xfer;
  wire             sdram_s1_firsttransfer;
  wire    [  1: 0] sdram_s1_grant_vector;
  wire             sdram_s1_in_a_read_cycle;
  wire             sdram_s1_in_a_write_cycle;
  wire    [  1: 0] sdram_s1_master_qreq_vector;
  wire             sdram_s1_move_on_to_next_transaction;
  wire             sdram_s1_non_bursting_master_requests;
  wire             sdram_s1_read_n;
  wire    [ 15: 0] sdram_s1_readdata_from_sa;
  wire             sdram_s1_readdatavalid_from_sa;
  reg              sdram_s1_reg_firsttransfer;
  wire             sdram_s1_reset_n;
  reg     [  1: 0] sdram_s1_saved_chosen_master_vector;
  reg              sdram_s1_slavearbiterlockenable;
  wire             sdram_s1_slavearbiterlockenable2;
  wire             sdram_s1_unreg_firsttransfer;
  wire             sdram_s1_waitrequest_from_sa;
  wire             sdram_s1_waits_for_read;
  wire             sdram_s1_waits_for_write;
  wire             sdram_s1_write_n;
  wire    [ 15: 0] sdram_s1_writedata;
  wire    [ 25: 0] shifted_address_to_sdram_s1_from_cpu_data_master;
  wire    [ 25: 0] shifted_address_to_sdram_s1_from_cpu_instruction_master;
  wire             wait_for_sdram_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~sdram_s1_end_xfer;
    end


  assign sdram_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_sdram_s1 | cpu_instruction_master_qualified_request_sdram_s1));
  //assign sdram_s1_readdatavalid_from_sa = sdram_s1_readdatavalid so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_readdatavalid_from_sa = sdram_s1_readdatavalid;

  //assign sdram_s1_readdata_from_sa = sdram_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_readdata_from_sa = sdram_s1_readdata;

  assign cpu_data_master_requests_sdram_s1 = ({cpu_data_master_address_to_slave[25 : 23] , 23'b0} == 26'h2000000) & (cpu_data_master_read | cpu_data_master_write);
  //assign sdram_s1_waitrequest_from_sa = sdram_s1_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sdram_s1_waitrequest_from_sa = sdram_s1_waitrequest;

  //sdram_s1_arb_share_counter set values, which is an e_mux
  assign sdram_s1_arb_share_set_values = (cpu_data_master_granted_sdram_s1)? 2 :
    (cpu_instruction_master_granted_sdram_s1)? 2 :
    (cpu_data_master_granted_sdram_s1)? 2 :
    (cpu_instruction_master_granted_sdram_s1)? 2 :
    1;

  //sdram_s1_non_bursting_master_requests mux, which is an e_mux
  assign sdram_s1_non_bursting_master_requests = cpu_data_master_requests_sdram_s1 |
    cpu_instruction_master_requests_sdram_s1 |
    cpu_data_master_requests_sdram_s1 |
    cpu_instruction_master_requests_sdram_s1;

  //sdram_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign sdram_s1_any_bursting_master_saved_grant = 0;

  //sdram_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign sdram_s1_arb_share_counter_next_value = sdram_s1_firsttransfer ? (sdram_s1_arb_share_set_values - 1) : |sdram_s1_arb_share_counter ? (sdram_s1_arb_share_counter - 1) : 0;

  //sdram_s1_allgrants all slave grants, which is an e_mux
  assign sdram_s1_allgrants = (|sdram_s1_grant_vector) |
    (|sdram_s1_grant_vector) |
    (|sdram_s1_grant_vector) |
    (|sdram_s1_grant_vector);

  //sdram_s1_end_xfer assignment, which is an e_assign
  assign sdram_s1_end_xfer = ~(sdram_s1_waits_for_read | sdram_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_sdram_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_sdram_s1 = sdram_s1_end_xfer & (~sdram_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //sdram_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign sdram_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_sdram_s1 & sdram_s1_allgrants) | (end_xfer_arb_share_counter_term_sdram_s1 & ~sdram_s1_non_bursting_master_requests);

  //sdram_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_arb_share_counter <= 0;
      else if (sdram_s1_arb_counter_enable)
          sdram_s1_arb_share_counter <= sdram_s1_arb_share_counter_next_value;
    end


  //sdram_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_slavearbiterlockenable <= 0;
      else if ((|sdram_s1_master_qreq_vector & end_xfer_arb_share_counter_term_sdram_s1) | (end_xfer_arb_share_counter_term_sdram_s1 & ~sdram_s1_non_bursting_master_requests))
          sdram_s1_slavearbiterlockenable <= |sdram_s1_arb_share_counter_next_value;
    end


  //cpu/data_master sdram/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = sdram_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //sdram_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign sdram_s1_slavearbiterlockenable2 = |sdram_s1_arb_share_counter_next_value;

  //cpu/data_master sdram/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = sdram_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //cpu/instruction_master sdram/s1 arbiterlock, which is an e_assign
  assign cpu_instruction_master_arbiterlock = sdram_s1_slavearbiterlockenable & cpu_instruction_master_continuerequest;

  //cpu/instruction_master sdram/s1 arbiterlock2, which is an e_assign
  assign cpu_instruction_master_arbiterlock2 = sdram_s1_slavearbiterlockenable2 & cpu_instruction_master_continuerequest;

  //cpu/instruction_master granted sdram/s1 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_instruction_master_granted_slave_sdram_s1 <= 0;
      else 
        last_cycle_cpu_instruction_master_granted_slave_sdram_s1 <= cpu_instruction_master_saved_grant_sdram_s1 ? 1 : (sdram_s1_arbitration_holdoff_internal | ~cpu_instruction_master_requests_sdram_s1) ? 0 : last_cycle_cpu_instruction_master_granted_slave_sdram_s1;
    end


  //cpu_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_instruction_master_continuerequest = last_cycle_cpu_instruction_master_granted_slave_sdram_s1 & cpu_instruction_master_requests_sdram_s1;

  //sdram_s1_any_continuerequest at least one master continues requesting, which is an e_mux
  assign sdram_s1_any_continuerequest = cpu_instruction_master_continuerequest |
    cpu_data_master_continuerequest;

  assign cpu_data_master_qualified_request_sdram_s1 = cpu_data_master_requests_sdram_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (1 < cpu_data_master_latency_counter))) | ((!cpu_data_master_byteenable_sdram_s1) & cpu_data_master_write) | cpu_instruction_master_arbiterlock);
  //unique name for sdram_s1_move_on_to_next_transaction, which is an e_assign
  assign sdram_s1_move_on_to_next_transaction = sdram_s1_readdatavalid_from_sa;

  //rdv_fifo_for_cpu_data_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_cpu_data_master_to_sdram_s1_module rdv_fifo_for_cpu_data_master_to_sdram_s1
    (
      .clear_fifo           (1'b0),
      .clk                  (clk),
      .data_in              (cpu_data_master_granted_sdram_s1),
      .data_out             (cpu_data_master_rdv_fifo_output_from_sdram_s1),
      .empty                (),
      .fifo_contains_ones_n (cpu_data_master_rdv_fifo_empty_sdram_s1),
      .full                 (),
      .read                 (sdram_s1_move_on_to_next_transaction),
      .reset_n              (reset_n),
      .sync_reset           (1'b0),
      .write                (in_a_read_cycle & ~sdram_s1_waits_for_read)
    );

  assign cpu_data_master_read_data_valid_sdram_s1_shift_register = ~cpu_data_master_rdv_fifo_empty_sdram_s1;
  //local readdatavalid cpu_data_master_read_data_valid_sdram_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_sdram_s1 = (sdram_s1_readdatavalid_from_sa & cpu_data_master_rdv_fifo_output_from_sdram_s1) & ~ cpu_data_master_rdv_fifo_empty_sdram_s1;

  //sdram_s1_writedata mux, which is an e_mux
  assign sdram_s1_writedata = cpu_data_master_dbs_write_16;

  assign cpu_instruction_master_requests_sdram_s1 = (({cpu_instruction_master_address_to_slave[25 : 23] , 23'b0} == 26'h2000000) & (cpu_instruction_master_read)) & cpu_instruction_master_read;
  //cpu/data_master granted sdram/s1 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_data_master_granted_slave_sdram_s1 <= 0;
      else 
        last_cycle_cpu_data_master_granted_slave_sdram_s1 <= cpu_data_master_saved_grant_sdram_s1 ? 1 : (sdram_s1_arbitration_holdoff_internal | ~cpu_data_master_requests_sdram_s1) ? 0 : last_cycle_cpu_data_master_granted_slave_sdram_s1;
    end


  //cpu_data_master_continuerequest continued request, which is an e_mux
  assign cpu_data_master_continuerequest = last_cycle_cpu_data_master_granted_slave_sdram_s1 & cpu_data_master_requests_sdram_s1;

  assign cpu_instruction_master_qualified_request_sdram_s1 = cpu_instruction_master_requests_sdram_s1 & ~((cpu_instruction_master_read & ((cpu_instruction_master_latency_counter != 0) | (1 < cpu_instruction_master_latency_counter))) | cpu_data_master_arbiterlock);
  //rdv_fifo_for_cpu_instruction_master_to_sdram_s1, which is an e_fifo_with_registered_outputs
  rdv_fifo_for_cpu_instruction_master_to_sdram_s1_module rdv_fifo_for_cpu_instruction_master_to_sdram_s1
    (
      .clear_fifo           (1'b0),
      .clk                  (clk),
      .data_in              (cpu_instruction_master_granted_sdram_s1),
      .data_out             (cpu_instruction_master_rdv_fifo_output_from_sdram_s1),
      .empty                (),
      .fifo_contains_ones_n (cpu_instruction_master_rdv_fifo_empty_sdram_s1),
      .full                 (),
      .read                 (sdram_s1_move_on_to_next_transaction),
      .reset_n              (reset_n),
      .sync_reset           (1'b0),
      .write                (in_a_read_cycle & ~sdram_s1_waits_for_read)
    );

  assign cpu_instruction_master_read_data_valid_sdram_s1_shift_register = ~cpu_instruction_master_rdv_fifo_empty_sdram_s1;
  //local readdatavalid cpu_instruction_master_read_data_valid_sdram_s1, which is an e_mux
  assign cpu_instruction_master_read_data_valid_sdram_s1 = (sdram_s1_readdatavalid_from_sa & cpu_instruction_master_rdv_fifo_output_from_sdram_s1) & ~ cpu_instruction_master_rdv_fifo_empty_sdram_s1;

  //allow new arb cycle for sdram/s1, which is an e_assign
  assign sdram_s1_allow_new_arb_cycle = ~cpu_data_master_arbiterlock & ~cpu_instruction_master_arbiterlock;

  //cpu/instruction_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  assign sdram_s1_master_qreq_vector[0] = cpu_instruction_master_qualified_request_sdram_s1;

  //cpu/instruction_master grant sdram/s1, which is an e_assign
  assign cpu_instruction_master_granted_sdram_s1 = sdram_s1_grant_vector[0];

  //cpu/instruction_master saved-grant sdram/s1, which is an e_assign
  assign cpu_instruction_master_saved_grant_sdram_s1 = sdram_s1_arb_winner[0] && cpu_instruction_master_requests_sdram_s1;

  //cpu/data_master assignment into master qualified-requests vector for sdram/s1, which is an e_assign
  assign sdram_s1_master_qreq_vector[1] = cpu_data_master_qualified_request_sdram_s1;

  //cpu/data_master grant sdram/s1, which is an e_assign
  assign cpu_data_master_granted_sdram_s1 = sdram_s1_grant_vector[1];

  //cpu/data_master saved-grant sdram/s1, which is an e_assign
  assign cpu_data_master_saved_grant_sdram_s1 = sdram_s1_arb_winner[1] && cpu_data_master_requests_sdram_s1;

  //sdram/s1 chosen-master double-vector, which is an e_assign
  assign sdram_s1_chosen_master_double_vector = {sdram_s1_master_qreq_vector, sdram_s1_master_qreq_vector} & ({~sdram_s1_master_qreq_vector, ~sdram_s1_master_qreq_vector} + sdram_s1_arb_addend);

  //stable onehot encoding of arb winner
  assign sdram_s1_arb_winner = (sdram_s1_allow_new_arb_cycle & | sdram_s1_grant_vector) ? sdram_s1_grant_vector : sdram_s1_saved_chosen_master_vector;

  //saved sdram_s1_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_saved_chosen_master_vector <= 0;
      else if (sdram_s1_allow_new_arb_cycle)
          sdram_s1_saved_chosen_master_vector <= |sdram_s1_grant_vector ? sdram_s1_grant_vector : sdram_s1_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign sdram_s1_grant_vector = {(sdram_s1_chosen_master_double_vector[1] | sdram_s1_chosen_master_double_vector[3]),
    (sdram_s1_chosen_master_double_vector[0] | sdram_s1_chosen_master_double_vector[2])};

  //sdram/s1 chosen master rotated left, which is an e_assign
  assign sdram_s1_chosen_master_rot_left = (sdram_s1_arb_winner << 1) ? (sdram_s1_arb_winner << 1) : 1;

  //sdram/s1's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_arb_addend <= 1;
      else if (|sdram_s1_grant_vector)
          sdram_s1_arb_addend <= sdram_s1_end_xfer? sdram_s1_chosen_master_rot_left : sdram_s1_grant_vector;
    end


  //sdram_s1_reset_n assignment, which is an e_assign
  assign sdram_s1_reset_n = reset_n;

  assign sdram_s1_chipselect = cpu_data_master_granted_sdram_s1 | cpu_instruction_master_granted_sdram_s1;
  //sdram_s1_firsttransfer first transaction, which is an e_assign
  assign sdram_s1_firsttransfer = sdram_s1_begins_xfer ? sdram_s1_unreg_firsttransfer : sdram_s1_reg_firsttransfer;

  //sdram_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign sdram_s1_unreg_firsttransfer = ~(sdram_s1_slavearbiterlockenable & sdram_s1_any_continuerequest);

  //sdram_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sdram_s1_reg_firsttransfer <= 1'b1;
      else if (sdram_s1_begins_xfer)
          sdram_s1_reg_firsttransfer <= sdram_s1_unreg_firsttransfer;
    end


  //sdram_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign sdram_s1_beginbursttransfer_internal = sdram_s1_begins_xfer;

  //sdram_s1_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign sdram_s1_arbitration_holdoff_internal = sdram_s1_begins_xfer & sdram_s1_firsttransfer;

  //~sdram_s1_read_n assignment, which is an e_mux
  assign sdram_s1_read_n = ~((cpu_data_master_granted_sdram_s1 & cpu_data_master_read) | (cpu_instruction_master_granted_sdram_s1 & cpu_instruction_master_read));

  //~sdram_s1_write_n assignment, which is an e_mux
  assign sdram_s1_write_n = ~(cpu_data_master_granted_sdram_s1 & cpu_data_master_write);

  assign shifted_address_to_sdram_s1_from_cpu_data_master = {cpu_data_master_address_to_slave >> 2,
    cpu_data_master_dbs_address[1],
    {1 {1'b0}}};

  //sdram_s1_address mux, which is an e_mux
  assign sdram_s1_address = (cpu_data_master_granted_sdram_s1)? (shifted_address_to_sdram_s1_from_cpu_data_master >> 1) :
    (shifted_address_to_sdram_s1_from_cpu_instruction_master >> 1);

  assign shifted_address_to_sdram_s1_from_cpu_instruction_master = {cpu_instruction_master_address_to_slave >> 2,
    cpu_instruction_master_dbs_address[1],
    {1 {1'b0}}};

  //d1_sdram_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_sdram_s1_end_xfer <= 1;
      else 
        d1_sdram_s1_end_xfer <= sdram_s1_end_xfer;
    end


  //sdram_s1_waits_for_read in a cycle, which is an e_mux
  assign sdram_s1_waits_for_read = sdram_s1_in_a_read_cycle & sdram_s1_waitrequest_from_sa;

  //sdram_s1_in_a_read_cycle assignment, which is an e_assign
  assign sdram_s1_in_a_read_cycle = (cpu_data_master_granted_sdram_s1 & cpu_data_master_read) | (cpu_instruction_master_granted_sdram_s1 & cpu_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = sdram_s1_in_a_read_cycle;

  //sdram_s1_waits_for_write in a cycle, which is an e_mux
  assign sdram_s1_waits_for_write = sdram_s1_in_a_write_cycle & sdram_s1_waitrequest_from_sa;

  //sdram_s1_in_a_write_cycle assignment, which is an e_assign
  assign sdram_s1_in_a_write_cycle = cpu_data_master_granted_sdram_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = sdram_s1_in_a_write_cycle;

  assign wait_for_sdram_s1_counter = 0;
  //~sdram_s1_byteenable_n byte enable port mux, which is an e_mux
  assign sdram_s1_byteenable_n = ~((cpu_data_master_granted_sdram_s1)? cpu_data_master_byteenable_sdram_s1 :
    -1);

  assign {cpu_data_master_byteenable_sdram_s1_segment_1,
cpu_data_master_byteenable_sdram_s1_segment_0} = cpu_data_master_byteenable;
  assign cpu_data_master_byteenable_sdram_s1 = ((cpu_data_master_dbs_address[1] == 0))? cpu_data_master_byteenable_sdram_s1_segment_0 :
    cpu_data_master_byteenable_sdram_s1_segment_1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //sdram/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_granted_sdram_s1 + cpu_instruction_master_granted_sdram_s1 > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_saved_grant_sdram_s1 + cpu_instruction_master_saved_grant_sdram_s1 > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module uart1_s1_arbitrator (
                             // inputs:
                              clk,
                              cpu_data_master_address_to_slave,
                              cpu_data_master_latency_counter,
                              cpu_data_master_read,
                              cpu_data_master_read_data_valid_sdram_s1_shift_register,
                              cpu_data_master_write,
                              cpu_data_master_writedata,
                              reset_n,
                              uart1_s1_dataavailable,
                              uart1_s1_irq,
                              uart1_s1_readdata,
                              uart1_s1_readyfordata,

                             // outputs:
                              cpu_data_master_granted_uart1_s1,
                              cpu_data_master_qualified_request_uart1_s1,
                              cpu_data_master_read_data_valid_uart1_s1,
                              cpu_data_master_requests_uart1_s1,
                              d1_uart1_s1_end_xfer,
                              uart1_s1_address,
                              uart1_s1_begintransfer,
                              uart1_s1_chipselect,
                              uart1_s1_dataavailable_from_sa,
                              uart1_s1_irq_from_sa,
                              uart1_s1_read_n,
                              uart1_s1_readdata_from_sa,
                              uart1_s1_readyfordata_from_sa,
                              uart1_s1_reset_n,
                              uart1_s1_write_n,
                              uart1_s1_writedata
                           )
;

  output           cpu_data_master_granted_uart1_s1;
  output           cpu_data_master_qualified_request_uart1_s1;
  output           cpu_data_master_read_data_valid_uart1_s1;
  output           cpu_data_master_requests_uart1_s1;
  output           d1_uart1_s1_end_xfer;
  output  [  2: 0] uart1_s1_address;
  output           uart1_s1_begintransfer;
  output           uart1_s1_chipselect;
  output           uart1_s1_dataavailable_from_sa;
  output           uart1_s1_irq_from_sa;
  output           uart1_s1_read_n;
  output  [ 15: 0] uart1_s1_readdata_from_sa;
  output           uart1_s1_readyfordata_from_sa;
  output           uart1_s1_reset_n;
  output           uart1_s1_write_n;
  output  [ 15: 0] uart1_s1_writedata;
  input            clk;
  input   [ 25: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_latency_counter;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_sdram_s1_shift_register;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input            reset_n;
  input            uart1_s1_dataavailable;
  input            uart1_s1_irq;
  input   [ 15: 0] uart1_s1_readdata;
  input            uart1_s1_readyfordata;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_uart1_s1;
  wire             cpu_data_master_qualified_request_uart1_s1;
  wire             cpu_data_master_read_data_valid_uart1_s1;
  wire             cpu_data_master_requests_uart1_s1;
  wire             cpu_data_master_saved_grant_uart1_s1;
  reg              d1_reasons_to_wait;
  reg              d1_uart1_s1_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_uart1_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [ 25: 0] shifted_address_to_uart1_s1_from_cpu_data_master;
  wire    [  2: 0] uart1_s1_address;
  wire             uart1_s1_allgrants;
  wire             uart1_s1_allow_new_arb_cycle;
  wire             uart1_s1_any_bursting_master_saved_grant;
  wire             uart1_s1_any_continuerequest;
  wire             uart1_s1_arb_counter_enable;
  reg     [  1: 0] uart1_s1_arb_share_counter;
  wire    [  1: 0] uart1_s1_arb_share_counter_next_value;
  wire    [  1: 0] uart1_s1_arb_share_set_values;
  wire             uart1_s1_beginbursttransfer_internal;
  wire             uart1_s1_begins_xfer;
  wire             uart1_s1_begintransfer;
  wire             uart1_s1_chipselect;
  wire             uart1_s1_dataavailable_from_sa;
  wire             uart1_s1_end_xfer;
  wire             uart1_s1_firsttransfer;
  wire             uart1_s1_grant_vector;
  wire             uart1_s1_in_a_read_cycle;
  wire             uart1_s1_in_a_write_cycle;
  wire             uart1_s1_irq_from_sa;
  wire             uart1_s1_master_qreq_vector;
  wire             uart1_s1_non_bursting_master_requests;
  wire             uart1_s1_read_n;
  wire    [ 15: 0] uart1_s1_readdata_from_sa;
  wire             uart1_s1_readyfordata_from_sa;
  reg              uart1_s1_reg_firsttransfer;
  wire             uart1_s1_reset_n;
  reg              uart1_s1_slavearbiterlockenable;
  wire             uart1_s1_slavearbiterlockenable2;
  wire             uart1_s1_unreg_firsttransfer;
  wire             uart1_s1_waits_for_read;
  wire             uart1_s1_waits_for_write;
  wire             uart1_s1_write_n;
  wire    [ 15: 0] uart1_s1_writedata;
  wire             wait_for_uart1_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~uart1_s1_end_xfer;
    end


  assign uart1_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_uart1_s1));
  //assign uart1_s1_readdata_from_sa = uart1_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign uart1_s1_readdata_from_sa = uart1_s1_readdata;

  assign cpu_data_master_requests_uart1_s1 = ({cpu_data_master_address_to_slave[25 : 5] , 5'b0} == 26'ha0) & (cpu_data_master_read | cpu_data_master_write);
  //assign uart1_s1_dataavailable_from_sa = uart1_s1_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign uart1_s1_dataavailable_from_sa = uart1_s1_dataavailable;

  //assign uart1_s1_readyfordata_from_sa = uart1_s1_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign uart1_s1_readyfordata_from_sa = uart1_s1_readyfordata;

  //uart1_s1_arb_share_counter set values, which is an e_mux
  assign uart1_s1_arb_share_set_values = 1;

  //uart1_s1_non_bursting_master_requests mux, which is an e_mux
  assign uart1_s1_non_bursting_master_requests = cpu_data_master_requests_uart1_s1;

  //uart1_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign uart1_s1_any_bursting_master_saved_grant = 0;

  //uart1_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign uart1_s1_arb_share_counter_next_value = uart1_s1_firsttransfer ? (uart1_s1_arb_share_set_values - 1) : |uart1_s1_arb_share_counter ? (uart1_s1_arb_share_counter - 1) : 0;

  //uart1_s1_allgrants all slave grants, which is an e_mux
  assign uart1_s1_allgrants = |uart1_s1_grant_vector;

  //uart1_s1_end_xfer assignment, which is an e_assign
  assign uart1_s1_end_xfer = ~(uart1_s1_waits_for_read | uart1_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_uart1_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_uart1_s1 = uart1_s1_end_xfer & (~uart1_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //uart1_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign uart1_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_uart1_s1 & uart1_s1_allgrants) | (end_xfer_arb_share_counter_term_uart1_s1 & ~uart1_s1_non_bursting_master_requests);

  //uart1_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          uart1_s1_arb_share_counter <= 0;
      else if (uart1_s1_arb_counter_enable)
          uart1_s1_arb_share_counter <= uart1_s1_arb_share_counter_next_value;
    end


  //uart1_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          uart1_s1_slavearbiterlockenable <= 0;
      else if ((|uart1_s1_master_qreq_vector & end_xfer_arb_share_counter_term_uart1_s1) | (end_xfer_arb_share_counter_term_uart1_s1 & ~uart1_s1_non_bursting_master_requests))
          uart1_s1_slavearbiterlockenable <= |uart1_s1_arb_share_counter_next_value;
    end


  //cpu/data_master uart1/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = uart1_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //uart1_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign uart1_s1_slavearbiterlockenable2 = |uart1_s1_arb_share_counter_next_value;

  //cpu/data_master uart1/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = uart1_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //uart1_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign uart1_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_uart1_s1 = cpu_data_master_requests_uart1_s1 & ~((cpu_data_master_read & ((cpu_data_master_latency_counter != 0) | (|cpu_data_master_read_data_valid_sdram_s1_shift_register))));
  //local readdatavalid cpu_data_master_read_data_valid_uart1_s1, which is an e_mux
  assign cpu_data_master_read_data_valid_uart1_s1 = cpu_data_master_granted_uart1_s1 & cpu_data_master_read & ~uart1_s1_waits_for_read;

  //uart1_s1_writedata mux, which is an e_mux
  assign uart1_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_uart1_s1 = cpu_data_master_qualified_request_uart1_s1;

  //cpu/data_master saved-grant uart1/s1, which is an e_assign
  assign cpu_data_master_saved_grant_uart1_s1 = cpu_data_master_requests_uart1_s1;

  //allow new arb cycle for uart1/s1, which is an e_assign
  assign uart1_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign uart1_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign uart1_s1_master_qreq_vector = 1;

  assign uart1_s1_begintransfer = uart1_s1_begins_xfer;
  //uart1_s1_reset_n assignment, which is an e_assign
  assign uart1_s1_reset_n = reset_n;

  assign uart1_s1_chipselect = cpu_data_master_granted_uart1_s1;
  //uart1_s1_firsttransfer first transaction, which is an e_assign
  assign uart1_s1_firsttransfer = uart1_s1_begins_xfer ? uart1_s1_unreg_firsttransfer : uart1_s1_reg_firsttransfer;

  //uart1_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign uart1_s1_unreg_firsttransfer = ~(uart1_s1_slavearbiterlockenable & uart1_s1_any_continuerequest);

  //uart1_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          uart1_s1_reg_firsttransfer <= 1'b1;
      else if (uart1_s1_begins_xfer)
          uart1_s1_reg_firsttransfer <= uart1_s1_unreg_firsttransfer;
    end


  //uart1_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign uart1_s1_beginbursttransfer_internal = uart1_s1_begins_xfer;

  //~uart1_s1_read_n assignment, which is an e_mux
  assign uart1_s1_read_n = ~(cpu_data_master_granted_uart1_s1 & cpu_data_master_read);

  //~uart1_s1_write_n assignment, which is an e_mux
  assign uart1_s1_write_n = ~(cpu_data_master_granted_uart1_s1 & cpu_data_master_write);

  assign shifted_address_to_uart1_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //uart1_s1_address mux, which is an e_mux
  assign uart1_s1_address = shifted_address_to_uart1_s1_from_cpu_data_master >> 2;

  //d1_uart1_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_uart1_s1_end_xfer <= 1;
      else 
        d1_uart1_s1_end_xfer <= uart1_s1_end_xfer;
    end


  //uart1_s1_waits_for_read in a cycle, which is an e_mux
  assign uart1_s1_waits_for_read = uart1_s1_in_a_read_cycle & uart1_s1_begins_xfer;

  //uart1_s1_in_a_read_cycle assignment, which is an e_assign
  assign uart1_s1_in_a_read_cycle = cpu_data_master_granted_uart1_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = uart1_s1_in_a_read_cycle;

  //uart1_s1_waits_for_write in a cycle, which is an e_mux
  assign uart1_s1_waits_for_write = uart1_s1_in_a_write_cycle & uart1_s1_begins_xfer;

  //uart1_s1_in_a_write_cycle assignment, which is an e_assign
  assign uart1_s1_in_a_write_cycle = cpu_data_master_granted_uart1_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = uart1_s1_in_a_write_cycle;

  assign wait_for_uart1_s1_counter = 0;
  //assign uart1_s1_irq_from_sa = uart1_s1_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign uart1_s1_irq_from_sa = uart1_s1_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //uart1/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module TETRISCPU_reset_clk_domain_synch_module (
                                                 // inputs:
                                                  clk,
                                                  data_in,
                                                  reset_n,

                                                 // outputs:
                                                  data_out
                                               )
;

  output           data_out;
  input            clk;
  input            data_in;
  input            reset_n;

  reg              data_in_d1 /* synthesis ALTERA_ATTRIBUTE = "{-from \"*\"} CUT=ON ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  reg              data_out /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_in_d1 <= 0;
      else 
        data_in_d1 <= data_in;
    end


  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_out <= 0;
      else 
        data_out <= data_in_d1;
    end



endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module TETRISCPU (
                   // 1) global signals:
                    clk,
                    reset_n,

                   // the_DM9000A
                    ENET_CMD_from_the_DM9000A,
                    ENET_CS_N_from_the_DM9000A,
                    ENET_DATA_to_and_from_the_DM9000A,
                    ENET_INT_to_the_DM9000A,
                    ENET_RD_N_from_the_DM9000A,
                    ENET_RST_N_from_the_DM9000A,
                    ENET_WR_N_from_the_DM9000A,

                   // the_keyboardscancode
                    in_port_to_the_keyboardscancode,

                   // the_keycounter
                    in_port_to_the_keycounter,

                   // the_outputsramdata
                    out_port_from_the_outputsramdata,

                   // the_outputxcoord
                    out_port_from_the_outputxcoord,

                   // the_outputycoord
                    out_port_from_the_outputycoord,

                   // the_pio_flag
                    out_port_from_the_pio_flag,

                   // the_scoreofplayer
                    out_port_from_the_scoreofplayer,

                   // the_sdram
                    zs_addr_from_the_sdram,
                    zs_ba_from_the_sdram,
                    zs_cas_n_from_the_sdram,
                    zs_cke_from_the_sdram,
                    zs_cs_n_from_the_sdram,
                    zs_dq_to_and_from_the_sdram,
                    zs_dqm_from_the_sdram,
                    zs_ras_n_from_the_sdram,
                    zs_we_n_from_the_sdram,

                   // the_uart1
                    rxd_to_the_uart1,
                    txd_from_the_uart1
                 )
;

  output           ENET_CMD_from_the_DM9000A;
  output           ENET_CS_N_from_the_DM9000A;
  inout   [ 15: 0] ENET_DATA_to_and_from_the_DM9000A;
  output           ENET_RD_N_from_the_DM9000A;
  output           ENET_RST_N_from_the_DM9000A;
  output           ENET_WR_N_from_the_DM9000A;
  output  [ 15: 0] out_port_from_the_outputsramdata;
  output  [  9: 0] out_port_from_the_outputxcoord;
  output  [  9: 0] out_port_from_the_outputycoord;
  output  [  7: 0] out_port_from_the_pio_flag;
  output  [ 15: 0] out_port_from_the_scoreofplayer;
  output           txd_from_the_uart1;
  output  [ 11: 0] zs_addr_from_the_sdram;
  output  [  1: 0] zs_ba_from_the_sdram;
  output           zs_cas_n_from_the_sdram;
  output           zs_cke_from_the_sdram;
  output           zs_cs_n_from_the_sdram;
  inout   [ 15: 0] zs_dq_to_and_from_the_sdram;
  output  [  1: 0] zs_dqm_from_the_sdram;
  output           zs_ras_n_from_the_sdram;
  output           zs_we_n_from_the_sdram;
  input            ENET_INT_to_the_DM9000A;
  input            clk;
  input   [ 23: 0] in_port_to_the_keyboardscancode;
  input   [ 15: 0] in_port_to_the_keycounter;
  input            reset_n;
  input            rxd_to_the_uart1;

  wire             DM9000A_avalonS_address;
  wire             DM9000A_avalonS_chipselect_n;
  wire             DM9000A_avalonS_irq;
  wire             DM9000A_avalonS_irq_from_sa;
  wire             DM9000A_avalonS_read_n;
  wire    [ 15: 0] DM9000A_avalonS_readdata;
  wire    [ 15: 0] DM9000A_avalonS_readdata_from_sa;
  wire             DM9000A_avalonS_reset_n;
  wire             DM9000A_avalonS_wait_counter_eq_0;
  wire             DM9000A_avalonS_write_n;
  wire    [ 15: 0] DM9000A_avalonS_writedata;
  wire             ENET_CMD_from_the_DM9000A;
  wire             ENET_CS_N_from_the_DM9000A;
  wire    [ 15: 0] ENET_DATA_to_and_from_the_DM9000A;
  wire             ENET_RD_N_from_the_DM9000A;
  wire             ENET_RST_N_from_the_DM9000A;
  wire             ENET_WR_N_from_the_DM9000A;
  wire             clk_reset_n;
  wire    [ 25: 0] cpu_data_master_address;
  wire    [ 25: 0] cpu_data_master_address_to_slave;
  wire    [  3: 0] cpu_data_master_byteenable;
  wire    [  1: 0] cpu_data_master_byteenable_sdram_s1;
  wire    [  1: 0] cpu_data_master_dbs_address;
  wire    [ 15: 0] cpu_data_master_dbs_write_16;
  wire             cpu_data_master_debugaccess;
  wire             cpu_data_master_granted_DM9000A_avalonS;
  wire             cpu_data_master_granted_cpu_jtag_debug_module;
  wire             cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_granted_keyboardscancode_s1;
  wire             cpu_data_master_granted_keycounter_s1;
  wire             cpu_data_master_granted_outputsramdata_s1;
  wire             cpu_data_master_granted_outputxcoord_s1;
  wire             cpu_data_master_granted_outputycoord_s1;
  wire             cpu_data_master_granted_pio_flag_s1;
  wire             cpu_data_master_granted_scoreofplayer_s1;
  wire             cpu_data_master_granted_sdram_s1;
  wire             cpu_data_master_granted_uart1_s1;
  wire    [ 31: 0] cpu_data_master_irq;
  wire             cpu_data_master_latency_counter;
  wire             cpu_data_master_qualified_request_DM9000A_avalonS;
  wire             cpu_data_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_qualified_request_keyboardscancode_s1;
  wire             cpu_data_master_qualified_request_keycounter_s1;
  wire             cpu_data_master_qualified_request_outputsramdata_s1;
  wire             cpu_data_master_qualified_request_outputxcoord_s1;
  wire             cpu_data_master_qualified_request_outputycoord_s1;
  wire             cpu_data_master_qualified_request_pio_flag_s1;
  wire             cpu_data_master_qualified_request_scoreofplayer_s1;
  wire             cpu_data_master_qualified_request_sdram_s1;
  wire             cpu_data_master_qualified_request_uart1_s1;
  wire             cpu_data_master_read;
  wire             cpu_data_master_read_data_valid_DM9000A_avalonS;
  wire             cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_read_data_valid_keyboardscancode_s1;
  wire             cpu_data_master_read_data_valid_keycounter_s1;
  wire             cpu_data_master_read_data_valid_outputsramdata_s1;
  wire             cpu_data_master_read_data_valid_outputxcoord_s1;
  wire             cpu_data_master_read_data_valid_outputycoord_s1;
  wire             cpu_data_master_read_data_valid_pio_flag_s1;
  wire             cpu_data_master_read_data_valid_scoreofplayer_s1;
  wire             cpu_data_master_read_data_valid_sdram_s1;
  wire             cpu_data_master_read_data_valid_sdram_s1_shift_register;
  wire             cpu_data_master_read_data_valid_uart1_s1;
  wire    [ 31: 0] cpu_data_master_readdata;
  wire             cpu_data_master_readdatavalid;
  wire             cpu_data_master_requests_DM9000A_avalonS;
  wire             cpu_data_master_requests_cpu_jtag_debug_module;
  wire             cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  wire             cpu_data_master_requests_keyboardscancode_s1;
  wire             cpu_data_master_requests_keycounter_s1;
  wire             cpu_data_master_requests_outputsramdata_s1;
  wire             cpu_data_master_requests_outputxcoord_s1;
  wire             cpu_data_master_requests_outputycoord_s1;
  wire             cpu_data_master_requests_pio_flag_s1;
  wire             cpu_data_master_requests_scoreofplayer_s1;
  wire             cpu_data_master_requests_sdram_s1;
  wire             cpu_data_master_requests_uart1_s1;
  wire             cpu_data_master_waitrequest;
  wire             cpu_data_master_write;
  wire    [ 31: 0] cpu_data_master_writedata;
  wire    [ 25: 0] cpu_instruction_master_address;
  wire    [ 25: 0] cpu_instruction_master_address_to_slave;
  wire    [  1: 0] cpu_instruction_master_dbs_address;
  wire             cpu_instruction_master_granted_cpu_jtag_debug_module;
  wire             cpu_instruction_master_granted_sdram_s1;
  wire             cpu_instruction_master_latency_counter;
  wire             cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_instruction_master_qualified_request_sdram_s1;
  wire             cpu_instruction_master_read;
  wire             cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_instruction_master_read_data_valid_sdram_s1;
  wire             cpu_instruction_master_read_data_valid_sdram_s1_shift_register;
  wire    [ 31: 0] cpu_instruction_master_readdata;
  wire             cpu_instruction_master_readdatavalid;
  wire             cpu_instruction_master_requests_cpu_jtag_debug_module;
  wire             cpu_instruction_master_requests_sdram_s1;
  wire             cpu_instruction_master_waitrequest;
  wire    [  8: 0] cpu_jtag_debug_module_address;
  wire             cpu_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_jtag_debug_module_byteenable;
  wire             cpu_jtag_debug_module_chipselect;
  wire             cpu_jtag_debug_module_debugaccess;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  wire             cpu_jtag_debug_module_reset_n;
  wire             cpu_jtag_debug_module_resetrequest;
  wire             cpu_jtag_debug_module_resetrequest_from_sa;
  wire             cpu_jtag_debug_module_write;
  wire    [ 31: 0] cpu_jtag_debug_module_writedata;
  wire             d1_DM9000A_avalonS_end_xfer;
  wire             d1_cpu_jtag_debug_module_end_xfer;
  wire             d1_jtag_uart_avalon_jtag_slave_end_xfer;
  wire             d1_keyboardscancode_s1_end_xfer;
  wire             d1_keycounter_s1_end_xfer;
  wire             d1_outputsramdata_s1_end_xfer;
  wire             d1_outputxcoord_s1_end_xfer;
  wire             d1_outputycoord_s1_end_xfer;
  wire             d1_pio_flag_s1_end_xfer;
  wire             d1_scoreofplayer_s1_end_xfer;
  wire             d1_sdram_s1_end_xfer;
  wire             d1_uart1_s1_end_xfer;
  wire             jtag_uart_avalon_jtag_slave_address;
  wire             jtag_uart_avalon_jtag_slave_chipselect;
  wire             jtag_uart_avalon_jtag_slave_dataavailable;
  wire             jtag_uart_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_avalon_jtag_slave_irq;
  wire             jtag_uart_avalon_jtag_slave_irq_from_sa;
  wire             jtag_uart_avalon_jtag_slave_read_n;
  wire    [ 31: 0] jtag_uart_avalon_jtag_slave_readdata;
  wire    [ 31: 0] jtag_uart_avalon_jtag_slave_readdata_from_sa;
  wire             jtag_uart_avalon_jtag_slave_readyfordata;
  wire             jtag_uart_avalon_jtag_slave_readyfordata_from_sa;
  wire             jtag_uart_avalon_jtag_slave_reset_n;
  wire             jtag_uart_avalon_jtag_slave_waitrequest;
  wire             jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  wire             jtag_uart_avalon_jtag_slave_write_n;
  wire    [ 31: 0] jtag_uart_avalon_jtag_slave_writedata;
  wire    [  1: 0] keyboardscancode_s1_address;
  wire    [ 31: 0] keyboardscancode_s1_readdata;
  wire    [ 31: 0] keyboardscancode_s1_readdata_from_sa;
  wire             keyboardscancode_s1_reset_n;
  wire    [  1: 0] keycounter_s1_address;
  wire    [ 31: 0] keycounter_s1_readdata;
  wire    [ 31: 0] keycounter_s1_readdata_from_sa;
  wire             keycounter_s1_reset_n;
  wire    [ 15: 0] out_port_from_the_outputsramdata;
  wire    [  9: 0] out_port_from_the_outputxcoord;
  wire    [  9: 0] out_port_from_the_outputycoord;
  wire    [  7: 0] out_port_from_the_pio_flag;
  wire    [ 15: 0] out_port_from_the_scoreofplayer;
  wire    [  1: 0] outputsramdata_s1_address;
  wire             outputsramdata_s1_chipselect;
  wire    [ 31: 0] outputsramdata_s1_readdata;
  wire    [ 31: 0] outputsramdata_s1_readdata_from_sa;
  wire             outputsramdata_s1_reset_n;
  wire             outputsramdata_s1_write_n;
  wire    [ 31: 0] outputsramdata_s1_writedata;
  wire    [  1: 0] outputxcoord_s1_address;
  wire             outputxcoord_s1_chipselect;
  wire    [ 31: 0] outputxcoord_s1_readdata;
  wire    [ 31: 0] outputxcoord_s1_readdata_from_sa;
  wire             outputxcoord_s1_reset_n;
  wire             outputxcoord_s1_write_n;
  wire    [ 31: 0] outputxcoord_s1_writedata;
  wire    [  1: 0] outputycoord_s1_address;
  wire             outputycoord_s1_chipselect;
  wire    [ 31: 0] outputycoord_s1_readdata;
  wire    [ 31: 0] outputycoord_s1_readdata_from_sa;
  wire             outputycoord_s1_reset_n;
  wire             outputycoord_s1_write_n;
  wire    [ 31: 0] outputycoord_s1_writedata;
  wire    [  1: 0] pio_flag_s1_address;
  wire             pio_flag_s1_chipselect;
  wire    [ 31: 0] pio_flag_s1_readdata;
  wire    [ 31: 0] pio_flag_s1_readdata_from_sa;
  wire             pio_flag_s1_reset_n;
  wire             pio_flag_s1_write_n;
  wire    [ 31: 0] pio_flag_s1_writedata;
  wire             reset_n_sources;
  wire    [  1: 0] scoreofplayer_s1_address;
  wire             scoreofplayer_s1_chipselect;
  wire    [ 31: 0] scoreofplayer_s1_readdata;
  wire    [ 31: 0] scoreofplayer_s1_readdata_from_sa;
  wire             scoreofplayer_s1_reset_n;
  wire             scoreofplayer_s1_write_n;
  wire    [ 31: 0] scoreofplayer_s1_writedata;
  wire    [ 21: 0] sdram_s1_address;
  wire    [  1: 0] sdram_s1_byteenable_n;
  wire             sdram_s1_chipselect;
  wire             sdram_s1_read_n;
  wire    [ 15: 0] sdram_s1_readdata;
  wire    [ 15: 0] sdram_s1_readdata_from_sa;
  wire             sdram_s1_readdatavalid;
  wire             sdram_s1_reset_n;
  wire             sdram_s1_waitrequest;
  wire             sdram_s1_waitrequest_from_sa;
  wire             sdram_s1_write_n;
  wire    [ 15: 0] sdram_s1_writedata;
  wire             txd_from_the_uart1;
  wire    [  2: 0] uart1_s1_address;
  wire             uart1_s1_begintransfer;
  wire             uart1_s1_chipselect;
  wire             uart1_s1_dataavailable;
  wire             uart1_s1_dataavailable_from_sa;
  wire             uart1_s1_irq;
  wire             uart1_s1_irq_from_sa;
  wire             uart1_s1_read_n;
  wire    [ 15: 0] uart1_s1_readdata;
  wire    [ 15: 0] uart1_s1_readdata_from_sa;
  wire             uart1_s1_readyfordata;
  wire             uart1_s1_readyfordata_from_sa;
  wire             uart1_s1_reset_n;
  wire             uart1_s1_write_n;
  wire    [ 15: 0] uart1_s1_writedata;
  wire    [ 11: 0] zs_addr_from_the_sdram;
  wire    [  1: 0] zs_ba_from_the_sdram;
  wire             zs_cas_n_from_the_sdram;
  wire             zs_cke_from_the_sdram;
  wire             zs_cs_n_from_the_sdram;
  wire    [ 15: 0] zs_dq_to_and_from_the_sdram;
  wire    [  1: 0] zs_dqm_from_the_sdram;
  wire             zs_ras_n_from_the_sdram;
  wire             zs_we_n_from_the_sdram;
  DM9000A_avalonS_arbitrator the_DM9000A_avalonS
    (
      .DM9000A_avalonS_address                                 (DM9000A_avalonS_address),
      .DM9000A_avalonS_chipselect_n                            (DM9000A_avalonS_chipselect_n),
      .DM9000A_avalonS_irq                                     (DM9000A_avalonS_irq),
      .DM9000A_avalonS_irq_from_sa                             (DM9000A_avalonS_irq_from_sa),
      .DM9000A_avalonS_read_n                                  (DM9000A_avalonS_read_n),
      .DM9000A_avalonS_readdata                                (DM9000A_avalonS_readdata),
      .DM9000A_avalonS_readdata_from_sa                        (DM9000A_avalonS_readdata_from_sa),
      .DM9000A_avalonS_reset_n                                 (DM9000A_avalonS_reset_n),
      .DM9000A_avalonS_wait_counter_eq_0                       (DM9000A_avalonS_wait_counter_eq_0),
      .DM9000A_avalonS_write_n                                 (DM9000A_avalonS_write_n),
      .DM9000A_avalonS_writedata                               (DM9000A_avalonS_writedata),
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_DM9000A_avalonS                 (cpu_data_master_granted_DM9000A_avalonS),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_DM9000A_avalonS       (cpu_data_master_qualified_request_DM9000A_avalonS),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_DM9000A_avalonS         (cpu_data_master_read_data_valid_DM9000A_avalonS),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_DM9000A_avalonS                (cpu_data_master_requests_DM9000A_avalonS),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_DM9000A_avalonS_end_xfer                             (d1_DM9000A_avalonS_end_xfer),
      .reset_n                                                 (clk_reset_n)
    );

  DM9000A the_DM9000A
    (
      .ENET_CMD   (ENET_CMD_from_the_DM9000A),
      .ENET_CS_N  (ENET_CS_N_from_the_DM9000A),
      .ENET_DATA  (ENET_DATA_to_and_from_the_DM9000A),
      .ENET_INT   (ENET_INT_to_the_DM9000A),
      .ENET_RD_N  (ENET_RD_N_from_the_DM9000A),
      .ENET_RST_N (ENET_RST_N_from_the_DM9000A),
      .ENET_WR_N  (ENET_WR_N_from_the_DM9000A),
      .iCMD       (DM9000A_avalonS_address),
      .iCS_N      (DM9000A_avalonS_chipselect_n),
      .iDATA      (DM9000A_avalonS_writedata),
      .iRD_N      (DM9000A_avalonS_read_n),
      .iRST_N     (DM9000A_avalonS_reset_n),
      .iWR_N      (DM9000A_avalonS_write_n),
      .oDATA      (DM9000A_avalonS_readdata),
      .oINT       (DM9000A_avalonS_irq)
    );

  cpu_jtag_debug_module_arbitrator the_cpu_jtag_debug_module
    (
      .clk                                                            (clk),
      .cpu_data_master_address_to_slave                               (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable                                     (cpu_data_master_byteenable),
      .cpu_data_master_debugaccess                                    (cpu_data_master_debugaccess),
      .cpu_data_master_granted_cpu_jtag_debug_module                  (cpu_data_master_granted_cpu_jtag_debug_module),
      .cpu_data_master_latency_counter                                (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_cpu_jtag_debug_module        (cpu_data_master_qualified_request_cpu_jtag_debug_module),
      .cpu_data_master_read                                           (cpu_data_master_read),
      .cpu_data_master_read_data_valid_cpu_jtag_debug_module          (cpu_data_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register        (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_cpu_jtag_debug_module                 (cpu_data_master_requests_cpu_jtag_debug_module),
      .cpu_data_master_write                                          (cpu_data_master_write),
      .cpu_data_master_writedata                                      (cpu_data_master_writedata),
      .cpu_instruction_master_address_to_slave                        (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_granted_cpu_jtag_debug_module           (cpu_instruction_master_granted_cpu_jtag_debug_module),
      .cpu_instruction_master_latency_counter                         (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_cpu_jtag_debug_module (cpu_instruction_master_qualified_request_cpu_jtag_debug_module),
      .cpu_instruction_master_read                                    (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_cpu_jtag_debug_module   (cpu_instruction_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_instruction_master_read_data_valid_sdram_s1_shift_register (cpu_instruction_master_read_data_valid_sdram_s1_shift_register),
      .cpu_instruction_master_requests_cpu_jtag_debug_module          (cpu_instruction_master_requests_cpu_jtag_debug_module),
      .cpu_jtag_debug_module_address                                  (cpu_jtag_debug_module_address),
      .cpu_jtag_debug_module_begintransfer                            (cpu_jtag_debug_module_begintransfer),
      .cpu_jtag_debug_module_byteenable                               (cpu_jtag_debug_module_byteenable),
      .cpu_jtag_debug_module_chipselect                               (cpu_jtag_debug_module_chipselect),
      .cpu_jtag_debug_module_debugaccess                              (cpu_jtag_debug_module_debugaccess),
      .cpu_jtag_debug_module_readdata                                 (cpu_jtag_debug_module_readdata),
      .cpu_jtag_debug_module_readdata_from_sa                         (cpu_jtag_debug_module_readdata_from_sa),
      .cpu_jtag_debug_module_reset_n                                  (cpu_jtag_debug_module_reset_n),
      .cpu_jtag_debug_module_resetrequest                             (cpu_jtag_debug_module_resetrequest),
      .cpu_jtag_debug_module_resetrequest_from_sa                     (cpu_jtag_debug_module_resetrequest_from_sa),
      .cpu_jtag_debug_module_write                                    (cpu_jtag_debug_module_write),
      .cpu_jtag_debug_module_writedata                                (cpu_jtag_debug_module_writedata),
      .d1_cpu_jtag_debug_module_end_xfer                              (d1_cpu_jtag_debug_module_end_xfer),
      .reset_n                                                        (clk_reset_n)
    );

  cpu_data_master_arbitrator the_cpu_data_master
    (
      .DM9000A_avalonS_irq_from_sa                                   (DM9000A_avalonS_irq_from_sa),
      .DM9000A_avalonS_readdata_from_sa                              (DM9000A_avalonS_readdata_from_sa),
      .DM9000A_avalonS_wait_counter_eq_0                             (DM9000A_avalonS_wait_counter_eq_0),
      .clk                                                           (clk),
      .cpu_data_master_address                                       (cpu_data_master_address),
      .cpu_data_master_address_to_slave                              (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable                                    (cpu_data_master_byteenable),
      .cpu_data_master_byteenable_sdram_s1                           (cpu_data_master_byteenable_sdram_s1),
      .cpu_data_master_dbs_address                                   (cpu_data_master_dbs_address),
      .cpu_data_master_dbs_write_16                                  (cpu_data_master_dbs_write_16),
      .cpu_data_master_granted_DM9000A_avalonS                       (cpu_data_master_granted_DM9000A_avalonS),
      .cpu_data_master_granted_cpu_jtag_debug_module                 (cpu_data_master_granted_cpu_jtag_debug_module),
      .cpu_data_master_granted_jtag_uart_avalon_jtag_slave           (cpu_data_master_granted_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_granted_keyboardscancode_s1                   (cpu_data_master_granted_keyboardscancode_s1),
      .cpu_data_master_granted_keycounter_s1                         (cpu_data_master_granted_keycounter_s1),
      .cpu_data_master_granted_outputsramdata_s1                     (cpu_data_master_granted_outputsramdata_s1),
      .cpu_data_master_granted_outputxcoord_s1                       (cpu_data_master_granted_outputxcoord_s1),
      .cpu_data_master_granted_outputycoord_s1                       (cpu_data_master_granted_outputycoord_s1),
      .cpu_data_master_granted_pio_flag_s1                           (cpu_data_master_granted_pio_flag_s1),
      .cpu_data_master_granted_scoreofplayer_s1                      (cpu_data_master_granted_scoreofplayer_s1),
      .cpu_data_master_granted_sdram_s1                              (cpu_data_master_granted_sdram_s1),
      .cpu_data_master_granted_uart1_s1                              (cpu_data_master_granted_uart1_s1),
      .cpu_data_master_irq                                           (cpu_data_master_irq),
      .cpu_data_master_latency_counter                               (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_DM9000A_avalonS             (cpu_data_master_qualified_request_DM9000A_avalonS),
      .cpu_data_master_qualified_request_cpu_jtag_debug_module       (cpu_data_master_qualified_request_cpu_jtag_debug_module),
      .cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave (cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_qualified_request_keyboardscancode_s1         (cpu_data_master_qualified_request_keyboardscancode_s1),
      .cpu_data_master_qualified_request_keycounter_s1               (cpu_data_master_qualified_request_keycounter_s1),
      .cpu_data_master_qualified_request_outputsramdata_s1           (cpu_data_master_qualified_request_outputsramdata_s1),
      .cpu_data_master_qualified_request_outputxcoord_s1             (cpu_data_master_qualified_request_outputxcoord_s1),
      .cpu_data_master_qualified_request_outputycoord_s1             (cpu_data_master_qualified_request_outputycoord_s1),
      .cpu_data_master_qualified_request_pio_flag_s1                 (cpu_data_master_qualified_request_pio_flag_s1),
      .cpu_data_master_qualified_request_scoreofplayer_s1            (cpu_data_master_qualified_request_scoreofplayer_s1),
      .cpu_data_master_qualified_request_sdram_s1                    (cpu_data_master_qualified_request_sdram_s1),
      .cpu_data_master_qualified_request_uart1_s1                    (cpu_data_master_qualified_request_uart1_s1),
      .cpu_data_master_read                                          (cpu_data_master_read),
      .cpu_data_master_read_data_valid_DM9000A_avalonS               (cpu_data_master_read_data_valid_DM9000A_avalonS),
      .cpu_data_master_read_data_valid_cpu_jtag_debug_module         (cpu_data_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave   (cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_read_data_valid_keyboardscancode_s1           (cpu_data_master_read_data_valid_keyboardscancode_s1),
      .cpu_data_master_read_data_valid_keycounter_s1                 (cpu_data_master_read_data_valid_keycounter_s1),
      .cpu_data_master_read_data_valid_outputsramdata_s1             (cpu_data_master_read_data_valid_outputsramdata_s1),
      .cpu_data_master_read_data_valid_outputxcoord_s1               (cpu_data_master_read_data_valid_outputxcoord_s1),
      .cpu_data_master_read_data_valid_outputycoord_s1               (cpu_data_master_read_data_valid_outputycoord_s1),
      .cpu_data_master_read_data_valid_pio_flag_s1                   (cpu_data_master_read_data_valid_pio_flag_s1),
      .cpu_data_master_read_data_valid_scoreofplayer_s1              (cpu_data_master_read_data_valid_scoreofplayer_s1),
      .cpu_data_master_read_data_valid_sdram_s1                      (cpu_data_master_read_data_valid_sdram_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register       (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_read_data_valid_uart1_s1                      (cpu_data_master_read_data_valid_uart1_s1),
      .cpu_data_master_readdata                                      (cpu_data_master_readdata),
      .cpu_data_master_readdatavalid                                 (cpu_data_master_readdatavalid),
      .cpu_data_master_requests_DM9000A_avalonS                      (cpu_data_master_requests_DM9000A_avalonS),
      .cpu_data_master_requests_cpu_jtag_debug_module                (cpu_data_master_requests_cpu_jtag_debug_module),
      .cpu_data_master_requests_jtag_uart_avalon_jtag_slave          (cpu_data_master_requests_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_requests_keyboardscancode_s1                  (cpu_data_master_requests_keyboardscancode_s1),
      .cpu_data_master_requests_keycounter_s1                        (cpu_data_master_requests_keycounter_s1),
      .cpu_data_master_requests_outputsramdata_s1                    (cpu_data_master_requests_outputsramdata_s1),
      .cpu_data_master_requests_outputxcoord_s1                      (cpu_data_master_requests_outputxcoord_s1),
      .cpu_data_master_requests_outputycoord_s1                      (cpu_data_master_requests_outputycoord_s1),
      .cpu_data_master_requests_pio_flag_s1                          (cpu_data_master_requests_pio_flag_s1),
      .cpu_data_master_requests_scoreofplayer_s1                     (cpu_data_master_requests_scoreofplayer_s1),
      .cpu_data_master_requests_sdram_s1                             (cpu_data_master_requests_sdram_s1),
      .cpu_data_master_requests_uart1_s1                             (cpu_data_master_requests_uart1_s1),
      .cpu_data_master_waitrequest                                   (cpu_data_master_waitrequest),
      .cpu_data_master_write                                         (cpu_data_master_write),
      .cpu_data_master_writedata                                     (cpu_data_master_writedata),
      .cpu_jtag_debug_module_readdata_from_sa                        (cpu_jtag_debug_module_readdata_from_sa),
      .d1_DM9000A_avalonS_end_xfer                                   (d1_DM9000A_avalonS_end_xfer),
      .d1_cpu_jtag_debug_module_end_xfer                             (d1_cpu_jtag_debug_module_end_xfer),
      .d1_jtag_uart_avalon_jtag_slave_end_xfer                       (d1_jtag_uart_avalon_jtag_slave_end_xfer),
      .d1_keyboardscancode_s1_end_xfer                               (d1_keyboardscancode_s1_end_xfer),
      .d1_keycounter_s1_end_xfer                                     (d1_keycounter_s1_end_xfer),
      .d1_outputsramdata_s1_end_xfer                                 (d1_outputsramdata_s1_end_xfer),
      .d1_outputxcoord_s1_end_xfer                                   (d1_outputxcoord_s1_end_xfer),
      .d1_outputycoord_s1_end_xfer                                   (d1_outputycoord_s1_end_xfer),
      .d1_pio_flag_s1_end_xfer                                       (d1_pio_flag_s1_end_xfer),
      .d1_scoreofplayer_s1_end_xfer                                  (d1_scoreofplayer_s1_end_xfer),
      .d1_sdram_s1_end_xfer                                          (d1_sdram_s1_end_xfer),
      .d1_uart1_s1_end_xfer                                          (d1_uart1_s1_end_xfer),
      .jtag_uart_avalon_jtag_slave_irq_from_sa                       (jtag_uart_avalon_jtag_slave_irq_from_sa),
      .jtag_uart_avalon_jtag_slave_readdata_from_sa                  (jtag_uart_avalon_jtag_slave_readdata_from_sa),
      .jtag_uart_avalon_jtag_slave_waitrequest_from_sa               (jtag_uart_avalon_jtag_slave_waitrequest_from_sa),
      .keyboardscancode_s1_readdata_from_sa                          (keyboardscancode_s1_readdata_from_sa),
      .keycounter_s1_readdata_from_sa                                (keycounter_s1_readdata_from_sa),
      .outputsramdata_s1_readdata_from_sa                            (outputsramdata_s1_readdata_from_sa),
      .outputxcoord_s1_readdata_from_sa                              (outputxcoord_s1_readdata_from_sa),
      .outputycoord_s1_readdata_from_sa                              (outputycoord_s1_readdata_from_sa),
      .pio_flag_s1_readdata_from_sa                                  (pio_flag_s1_readdata_from_sa),
      .reset_n                                                       (clk_reset_n),
      .scoreofplayer_s1_readdata_from_sa                             (scoreofplayer_s1_readdata_from_sa),
      .sdram_s1_readdata_from_sa                                     (sdram_s1_readdata_from_sa),
      .sdram_s1_waitrequest_from_sa                                  (sdram_s1_waitrequest_from_sa),
      .uart1_s1_irq_from_sa                                          (uart1_s1_irq_from_sa),
      .uart1_s1_readdata_from_sa                                     (uart1_s1_readdata_from_sa)
    );

  cpu_instruction_master_arbitrator the_cpu_instruction_master
    (
      .clk                                                            (clk),
      .cpu_instruction_master_address                                 (cpu_instruction_master_address),
      .cpu_instruction_master_address_to_slave                        (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_dbs_address                             (cpu_instruction_master_dbs_address),
      .cpu_instruction_master_granted_cpu_jtag_debug_module           (cpu_instruction_master_granted_cpu_jtag_debug_module),
      .cpu_instruction_master_granted_sdram_s1                        (cpu_instruction_master_granted_sdram_s1),
      .cpu_instruction_master_latency_counter                         (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_cpu_jtag_debug_module (cpu_instruction_master_qualified_request_cpu_jtag_debug_module),
      .cpu_instruction_master_qualified_request_sdram_s1              (cpu_instruction_master_qualified_request_sdram_s1),
      .cpu_instruction_master_read                                    (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_cpu_jtag_debug_module   (cpu_instruction_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_instruction_master_read_data_valid_sdram_s1                (cpu_instruction_master_read_data_valid_sdram_s1),
      .cpu_instruction_master_read_data_valid_sdram_s1_shift_register (cpu_instruction_master_read_data_valid_sdram_s1_shift_register),
      .cpu_instruction_master_readdata                                (cpu_instruction_master_readdata),
      .cpu_instruction_master_readdatavalid                           (cpu_instruction_master_readdatavalid),
      .cpu_instruction_master_requests_cpu_jtag_debug_module          (cpu_instruction_master_requests_cpu_jtag_debug_module),
      .cpu_instruction_master_requests_sdram_s1                       (cpu_instruction_master_requests_sdram_s1),
      .cpu_instruction_master_waitrequest                             (cpu_instruction_master_waitrequest),
      .cpu_jtag_debug_module_readdata_from_sa                         (cpu_jtag_debug_module_readdata_from_sa),
      .d1_cpu_jtag_debug_module_end_xfer                              (d1_cpu_jtag_debug_module_end_xfer),
      .d1_sdram_s1_end_xfer                                           (d1_sdram_s1_end_xfer),
      .reset_n                                                        (clk_reset_n),
      .sdram_s1_readdata_from_sa                                      (sdram_s1_readdata_from_sa),
      .sdram_s1_waitrequest_from_sa                                   (sdram_s1_waitrequest_from_sa)
    );

  cpu the_cpu
    (
      .clk                                   (clk),
      .d_address                             (cpu_data_master_address),
      .d_byteenable                          (cpu_data_master_byteenable),
      .d_irq                                 (cpu_data_master_irq),
      .d_read                                (cpu_data_master_read),
      .d_readdata                            (cpu_data_master_readdata),
      .d_readdatavalid                       (cpu_data_master_readdatavalid),
      .d_waitrequest                         (cpu_data_master_waitrequest),
      .d_write                               (cpu_data_master_write),
      .d_writedata                           (cpu_data_master_writedata),
      .i_address                             (cpu_instruction_master_address),
      .i_read                                (cpu_instruction_master_read),
      .i_readdata                            (cpu_instruction_master_readdata),
      .i_readdatavalid                       (cpu_instruction_master_readdatavalid),
      .i_waitrequest                         (cpu_instruction_master_waitrequest),
      .jtag_debug_module_address             (cpu_jtag_debug_module_address),
      .jtag_debug_module_begintransfer       (cpu_jtag_debug_module_begintransfer),
      .jtag_debug_module_byteenable          (cpu_jtag_debug_module_byteenable),
      .jtag_debug_module_debugaccess         (cpu_jtag_debug_module_debugaccess),
      .jtag_debug_module_debugaccess_to_roms (cpu_data_master_debugaccess),
      .jtag_debug_module_readdata            (cpu_jtag_debug_module_readdata),
      .jtag_debug_module_resetrequest        (cpu_jtag_debug_module_resetrequest),
      .jtag_debug_module_select              (cpu_jtag_debug_module_chipselect),
      .jtag_debug_module_write               (cpu_jtag_debug_module_write),
      .jtag_debug_module_writedata           (cpu_jtag_debug_module_writedata),
      .reset_n                               (cpu_jtag_debug_module_reset_n)
    );

  jtag_uart_avalon_jtag_slave_arbitrator the_jtag_uart_avalon_jtag_slave
    (
      .clk                                                           (clk),
      .cpu_data_master_address_to_slave                              (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_jtag_uart_avalon_jtag_slave           (cpu_data_master_granted_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_latency_counter                               (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave (cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_read                                          (cpu_data_master_read),
      .cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave   (cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register       (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_jtag_uart_avalon_jtag_slave          (cpu_data_master_requests_jtag_uart_avalon_jtag_slave),
      .cpu_data_master_write                                         (cpu_data_master_write),
      .cpu_data_master_writedata                                     (cpu_data_master_writedata),
      .d1_jtag_uart_avalon_jtag_slave_end_xfer                       (d1_jtag_uart_avalon_jtag_slave_end_xfer),
      .jtag_uart_avalon_jtag_slave_address                           (jtag_uart_avalon_jtag_slave_address),
      .jtag_uart_avalon_jtag_slave_chipselect                        (jtag_uart_avalon_jtag_slave_chipselect),
      .jtag_uart_avalon_jtag_slave_dataavailable                     (jtag_uart_avalon_jtag_slave_dataavailable),
      .jtag_uart_avalon_jtag_slave_dataavailable_from_sa             (jtag_uart_avalon_jtag_slave_dataavailable_from_sa),
      .jtag_uart_avalon_jtag_slave_irq                               (jtag_uart_avalon_jtag_slave_irq),
      .jtag_uart_avalon_jtag_slave_irq_from_sa                       (jtag_uart_avalon_jtag_slave_irq_from_sa),
      .jtag_uart_avalon_jtag_slave_read_n                            (jtag_uart_avalon_jtag_slave_read_n),
      .jtag_uart_avalon_jtag_slave_readdata                          (jtag_uart_avalon_jtag_slave_readdata),
      .jtag_uart_avalon_jtag_slave_readdata_from_sa                  (jtag_uart_avalon_jtag_slave_readdata_from_sa),
      .jtag_uart_avalon_jtag_slave_readyfordata                      (jtag_uart_avalon_jtag_slave_readyfordata),
      .jtag_uart_avalon_jtag_slave_readyfordata_from_sa              (jtag_uart_avalon_jtag_slave_readyfordata_from_sa),
      .jtag_uart_avalon_jtag_slave_reset_n                           (jtag_uart_avalon_jtag_slave_reset_n),
      .jtag_uart_avalon_jtag_slave_waitrequest                       (jtag_uart_avalon_jtag_slave_waitrequest),
      .jtag_uart_avalon_jtag_slave_waitrequest_from_sa               (jtag_uart_avalon_jtag_slave_waitrequest_from_sa),
      .jtag_uart_avalon_jtag_slave_write_n                           (jtag_uart_avalon_jtag_slave_write_n),
      .jtag_uart_avalon_jtag_slave_writedata                         (jtag_uart_avalon_jtag_slave_writedata),
      .reset_n                                                       (clk_reset_n)
    );

  jtag_uart the_jtag_uart
    (
      .av_address     (jtag_uart_avalon_jtag_slave_address),
      .av_chipselect  (jtag_uart_avalon_jtag_slave_chipselect),
      .av_irq         (jtag_uart_avalon_jtag_slave_irq),
      .av_read_n      (jtag_uart_avalon_jtag_slave_read_n),
      .av_readdata    (jtag_uart_avalon_jtag_slave_readdata),
      .av_waitrequest (jtag_uart_avalon_jtag_slave_waitrequest),
      .av_write_n     (jtag_uart_avalon_jtag_slave_write_n),
      .av_writedata   (jtag_uart_avalon_jtag_slave_writedata),
      .clk            (clk),
      .dataavailable  (jtag_uart_avalon_jtag_slave_dataavailable),
      .readyfordata   (jtag_uart_avalon_jtag_slave_readyfordata),
      .rst_n          (jtag_uart_avalon_jtag_slave_reset_n)
    );

  keyboardscancode_s1_arbitrator the_keyboardscancode_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_keyboardscancode_s1             (cpu_data_master_granted_keyboardscancode_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_keyboardscancode_s1   (cpu_data_master_qualified_request_keyboardscancode_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_keyboardscancode_s1     (cpu_data_master_read_data_valid_keyboardscancode_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_keyboardscancode_s1            (cpu_data_master_requests_keyboardscancode_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .d1_keyboardscancode_s1_end_xfer                         (d1_keyboardscancode_s1_end_xfer),
      .keyboardscancode_s1_address                             (keyboardscancode_s1_address),
      .keyboardscancode_s1_readdata                            (keyboardscancode_s1_readdata),
      .keyboardscancode_s1_readdata_from_sa                    (keyboardscancode_s1_readdata_from_sa),
      .keyboardscancode_s1_reset_n                             (keyboardscancode_s1_reset_n),
      .reset_n                                                 (clk_reset_n)
    );

  keyboardscancode the_keyboardscancode
    (
      .address  (keyboardscancode_s1_address),
      .clk      (clk),
      .in_port  (in_port_to_the_keyboardscancode),
      .readdata (keyboardscancode_s1_readdata),
      .reset_n  (keyboardscancode_s1_reset_n)
    );

  keycounter_s1_arbitrator the_keycounter_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_keycounter_s1                   (cpu_data_master_granted_keycounter_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_keycounter_s1         (cpu_data_master_qualified_request_keycounter_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_keycounter_s1           (cpu_data_master_read_data_valid_keycounter_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_keycounter_s1                  (cpu_data_master_requests_keycounter_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .d1_keycounter_s1_end_xfer                               (d1_keycounter_s1_end_xfer),
      .keycounter_s1_address                                   (keycounter_s1_address),
      .keycounter_s1_readdata                                  (keycounter_s1_readdata),
      .keycounter_s1_readdata_from_sa                          (keycounter_s1_readdata_from_sa),
      .keycounter_s1_reset_n                                   (keycounter_s1_reset_n),
      .reset_n                                                 (clk_reset_n)
    );

  keycounter the_keycounter
    (
      .address  (keycounter_s1_address),
      .clk      (clk),
      .in_port  (in_port_to_the_keycounter),
      .readdata (keycounter_s1_readdata),
      .reset_n  (keycounter_s1_reset_n)
    );

  outputsramdata_s1_arbitrator the_outputsramdata_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_outputsramdata_s1               (cpu_data_master_granted_outputsramdata_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_outputsramdata_s1     (cpu_data_master_qualified_request_outputsramdata_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_outputsramdata_s1       (cpu_data_master_read_data_valid_outputsramdata_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_outputsramdata_s1              (cpu_data_master_requests_outputsramdata_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_outputsramdata_s1_end_xfer                           (d1_outputsramdata_s1_end_xfer),
      .outputsramdata_s1_address                               (outputsramdata_s1_address),
      .outputsramdata_s1_chipselect                            (outputsramdata_s1_chipselect),
      .outputsramdata_s1_readdata                              (outputsramdata_s1_readdata),
      .outputsramdata_s1_readdata_from_sa                      (outputsramdata_s1_readdata_from_sa),
      .outputsramdata_s1_reset_n                               (outputsramdata_s1_reset_n),
      .outputsramdata_s1_write_n                               (outputsramdata_s1_write_n),
      .outputsramdata_s1_writedata                             (outputsramdata_s1_writedata),
      .reset_n                                                 (clk_reset_n)
    );

  outputsramdata the_outputsramdata
    (
      .address    (outputsramdata_s1_address),
      .chipselect (outputsramdata_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_outputsramdata),
      .readdata   (outputsramdata_s1_readdata),
      .reset_n    (outputsramdata_s1_reset_n),
      .write_n    (outputsramdata_s1_write_n),
      .writedata  (outputsramdata_s1_writedata)
    );

  outputxcoord_s1_arbitrator the_outputxcoord_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_outputxcoord_s1                 (cpu_data_master_granted_outputxcoord_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_outputxcoord_s1       (cpu_data_master_qualified_request_outputxcoord_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_outputxcoord_s1         (cpu_data_master_read_data_valid_outputxcoord_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_outputxcoord_s1                (cpu_data_master_requests_outputxcoord_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_outputxcoord_s1_end_xfer                             (d1_outputxcoord_s1_end_xfer),
      .outputxcoord_s1_address                                 (outputxcoord_s1_address),
      .outputxcoord_s1_chipselect                              (outputxcoord_s1_chipselect),
      .outputxcoord_s1_readdata                                (outputxcoord_s1_readdata),
      .outputxcoord_s1_readdata_from_sa                        (outputxcoord_s1_readdata_from_sa),
      .outputxcoord_s1_reset_n                                 (outputxcoord_s1_reset_n),
      .outputxcoord_s1_write_n                                 (outputxcoord_s1_write_n),
      .outputxcoord_s1_writedata                               (outputxcoord_s1_writedata),
      .reset_n                                                 (clk_reset_n)
    );

  outputxcoord the_outputxcoord
    (
      .address    (outputxcoord_s1_address),
      .chipselect (outputxcoord_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_outputxcoord),
      .readdata   (outputxcoord_s1_readdata),
      .reset_n    (outputxcoord_s1_reset_n),
      .write_n    (outputxcoord_s1_write_n),
      .writedata  (outputxcoord_s1_writedata)
    );

  outputycoord_s1_arbitrator the_outputycoord_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_outputycoord_s1                 (cpu_data_master_granted_outputycoord_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_outputycoord_s1       (cpu_data_master_qualified_request_outputycoord_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_outputycoord_s1         (cpu_data_master_read_data_valid_outputycoord_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_outputycoord_s1                (cpu_data_master_requests_outputycoord_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_outputycoord_s1_end_xfer                             (d1_outputycoord_s1_end_xfer),
      .outputycoord_s1_address                                 (outputycoord_s1_address),
      .outputycoord_s1_chipselect                              (outputycoord_s1_chipselect),
      .outputycoord_s1_readdata                                (outputycoord_s1_readdata),
      .outputycoord_s1_readdata_from_sa                        (outputycoord_s1_readdata_from_sa),
      .outputycoord_s1_reset_n                                 (outputycoord_s1_reset_n),
      .outputycoord_s1_write_n                                 (outputycoord_s1_write_n),
      .outputycoord_s1_writedata                               (outputycoord_s1_writedata),
      .reset_n                                                 (clk_reset_n)
    );

  outputycoord the_outputycoord
    (
      .address    (outputycoord_s1_address),
      .chipselect (outputycoord_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_outputycoord),
      .readdata   (outputycoord_s1_readdata),
      .reset_n    (outputycoord_s1_reset_n),
      .write_n    (outputycoord_s1_write_n),
      .writedata  (outputycoord_s1_writedata)
    );

  pio_flag_s1_arbitrator the_pio_flag_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_flag_s1                     (cpu_data_master_granted_pio_flag_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_pio_flag_s1           (cpu_data_master_qualified_request_pio_flag_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_flag_s1             (cpu_data_master_read_data_valid_pio_flag_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_pio_flag_s1                    (cpu_data_master_requests_pio_flag_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_pio_flag_s1_end_xfer                                 (d1_pio_flag_s1_end_xfer),
      .pio_flag_s1_address                                     (pio_flag_s1_address),
      .pio_flag_s1_chipselect                                  (pio_flag_s1_chipselect),
      .pio_flag_s1_readdata                                    (pio_flag_s1_readdata),
      .pio_flag_s1_readdata_from_sa                            (pio_flag_s1_readdata_from_sa),
      .pio_flag_s1_reset_n                                     (pio_flag_s1_reset_n),
      .pio_flag_s1_write_n                                     (pio_flag_s1_write_n),
      .pio_flag_s1_writedata                                   (pio_flag_s1_writedata),
      .reset_n                                                 (clk_reset_n)
    );

  pio_flag the_pio_flag
    (
      .address    (pio_flag_s1_address),
      .chipselect (pio_flag_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_pio_flag),
      .readdata   (pio_flag_s1_readdata),
      .reset_n    (pio_flag_s1_reset_n),
      .write_n    (pio_flag_s1_write_n),
      .writedata  (pio_flag_s1_writedata)
    );

  scoreofplayer_s1_arbitrator the_scoreofplayer_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_scoreofplayer_s1                (cpu_data_master_granted_scoreofplayer_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_scoreofplayer_s1      (cpu_data_master_qualified_request_scoreofplayer_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_scoreofplayer_s1        (cpu_data_master_read_data_valid_scoreofplayer_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_scoreofplayer_s1               (cpu_data_master_requests_scoreofplayer_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_scoreofplayer_s1_end_xfer                            (d1_scoreofplayer_s1_end_xfer),
      .reset_n                                                 (clk_reset_n),
      .scoreofplayer_s1_address                                (scoreofplayer_s1_address),
      .scoreofplayer_s1_chipselect                             (scoreofplayer_s1_chipselect),
      .scoreofplayer_s1_readdata                               (scoreofplayer_s1_readdata),
      .scoreofplayer_s1_readdata_from_sa                       (scoreofplayer_s1_readdata_from_sa),
      .scoreofplayer_s1_reset_n                                (scoreofplayer_s1_reset_n),
      .scoreofplayer_s1_write_n                                (scoreofplayer_s1_write_n),
      .scoreofplayer_s1_writedata                              (scoreofplayer_s1_writedata)
    );

  scoreofplayer the_scoreofplayer
    (
      .address    (scoreofplayer_s1_address),
      .chipselect (scoreofplayer_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_scoreofplayer),
      .readdata   (scoreofplayer_s1_readdata),
      .reset_n    (scoreofplayer_s1_reset_n),
      .write_n    (scoreofplayer_s1_write_n),
      .writedata  (scoreofplayer_s1_writedata)
    );

  sdram_s1_arbitrator the_sdram_s1
    (
      .clk                                                            (clk),
      .cpu_data_master_address_to_slave                               (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable                                     (cpu_data_master_byteenable),
      .cpu_data_master_byteenable_sdram_s1                            (cpu_data_master_byteenable_sdram_s1),
      .cpu_data_master_dbs_address                                    (cpu_data_master_dbs_address),
      .cpu_data_master_dbs_write_16                                   (cpu_data_master_dbs_write_16),
      .cpu_data_master_granted_sdram_s1                               (cpu_data_master_granted_sdram_s1),
      .cpu_data_master_latency_counter                                (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_sdram_s1                     (cpu_data_master_qualified_request_sdram_s1),
      .cpu_data_master_read                                           (cpu_data_master_read),
      .cpu_data_master_read_data_valid_sdram_s1                       (cpu_data_master_read_data_valid_sdram_s1),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register        (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_requests_sdram_s1                              (cpu_data_master_requests_sdram_s1),
      .cpu_data_master_write                                          (cpu_data_master_write),
      .cpu_instruction_master_address_to_slave                        (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_dbs_address                             (cpu_instruction_master_dbs_address),
      .cpu_instruction_master_granted_sdram_s1                        (cpu_instruction_master_granted_sdram_s1),
      .cpu_instruction_master_latency_counter                         (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_sdram_s1              (cpu_instruction_master_qualified_request_sdram_s1),
      .cpu_instruction_master_read                                    (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_sdram_s1                (cpu_instruction_master_read_data_valid_sdram_s1),
      .cpu_instruction_master_read_data_valid_sdram_s1_shift_register (cpu_instruction_master_read_data_valid_sdram_s1_shift_register),
      .cpu_instruction_master_requests_sdram_s1                       (cpu_instruction_master_requests_sdram_s1),
      .d1_sdram_s1_end_xfer                                           (d1_sdram_s1_end_xfer),
      .reset_n                                                        (clk_reset_n),
      .sdram_s1_address                                               (sdram_s1_address),
      .sdram_s1_byteenable_n                                          (sdram_s1_byteenable_n),
      .sdram_s1_chipselect                                            (sdram_s1_chipselect),
      .sdram_s1_read_n                                                (sdram_s1_read_n),
      .sdram_s1_readdata                                              (sdram_s1_readdata),
      .sdram_s1_readdata_from_sa                                      (sdram_s1_readdata_from_sa),
      .sdram_s1_readdatavalid                                         (sdram_s1_readdatavalid),
      .sdram_s1_reset_n                                               (sdram_s1_reset_n),
      .sdram_s1_waitrequest                                           (sdram_s1_waitrequest),
      .sdram_s1_waitrequest_from_sa                                   (sdram_s1_waitrequest_from_sa),
      .sdram_s1_write_n                                               (sdram_s1_write_n),
      .sdram_s1_writedata                                             (sdram_s1_writedata)
    );

  sdram the_sdram
    (
      .az_addr        (sdram_s1_address),
      .az_be_n        (sdram_s1_byteenable_n),
      .az_cs          (sdram_s1_chipselect),
      .az_data        (sdram_s1_writedata),
      .az_rd_n        (sdram_s1_read_n),
      .az_wr_n        (sdram_s1_write_n),
      .clk            (clk),
      .reset_n        (sdram_s1_reset_n),
      .za_data        (sdram_s1_readdata),
      .za_valid       (sdram_s1_readdatavalid),
      .za_waitrequest (sdram_s1_waitrequest),
      .zs_addr        (zs_addr_from_the_sdram),
      .zs_ba          (zs_ba_from_the_sdram),
      .zs_cas_n       (zs_cas_n_from_the_sdram),
      .zs_cke         (zs_cke_from_the_sdram),
      .zs_cs_n        (zs_cs_n_from_the_sdram),
      .zs_dq          (zs_dq_to_and_from_the_sdram),
      .zs_dqm         (zs_dqm_from_the_sdram),
      .zs_ras_n       (zs_ras_n_from_the_sdram),
      .zs_we_n        (zs_we_n_from_the_sdram)
    );

  uart1_s1_arbitrator the_uart1_s1
    (
      .clk                                                     (clk),
      .cpu_data_master_address_to_slave                        (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_uart1_s1                        (cpu_data_master_granted_uart1_s1),
      .cpu_data_master_latency_counter                         (cpu_data_master_latency_counter),
      .cpu_data_master_qualified_request_uart1_s1              (cpu_data_master_qualified_request_uart1_s1),
      .cpu_data_master_read                                    (cpu_data_master_read),
      .cpu_data_master_read_data_valid_sdram_s1_shift_register (cpu_data_master_read_data_valid_sdram_s1_shift_register),
      .cpu_data_master_read_data_valid_uart1_s1                (cpu_data_master_read_data_valid_uart1_s1),
      .cpu_data_master_requests_uart1_s1                       (cpu_data_master_requests_uart1_s1),
      .cpu_data_master_write                                   (cpu_data_master_write),
      .cpu_data_master_writedata                               (cpu_data_master_writedata),
      .d1_uart1_s1_end_xfer                                    (d1_uart1_s1_end_xfer),
      .reset_n                                                 (clk_reset_n),
      .uart1_s1_address                                        (uart1_s1_address),
      .uart1_s1_begintransfer                                  (uart1_s1_begintransfer),
      .uart1_s1_chipselect                                     (uart1_s1_chipselect),
      .uart1_s1_dataavailable                                  (uart1_s1_dataavailable),
      .uart1_s1_dataavailable_from_sa                          (uart1_s1_dataavailable_from_sa),
      .uart1_s1_irq                                            (uart1_s1_irq),
      .uart1_s1_irq_from_sa                                    (uart1_s1_irq_from_sa),
      .uart1_s1_read_n                                         (uart1_s1_read_n),
      .uart1_s1_readdata                                       (uart1_s1_readdata),
      .uart1_s1_readdata_from_sa                               (uart1_s1_readdata_from_sa),
      .uart1_s1_readyfordata                                   (uart1_s1_readyfordata),
      .uart1_s1_readyfordata_from_sa                           (uart1_s1_readyfordata_from_sa),
      .uart1_s1_reset_n                                        (uart1_s1_reset_n),
      .uart1_s1_write_n                                        (uart1_s1_write_n),
      .uart1_s1_writedata                                      (uart1_s1_writedata)
    );

  uart1 the_uart1
    (
      .address       (uart1_s1_address),
      .begintransfer (uart1_s1_begintransfer),
      .chipselect    (uart1_s1_chipselect),
      .clk           (clk),
      .dataavailable (uart1_s1_dataavailable),
      .irq           (uart1_s1_irq),
      .read_n        (uart1_s1_read_n),
      .readdata      (uart1_s1_readdata),
      .readyfordata  (uart1_s1_readyfordata),
      .reset_n       (uart1_s1_reset_n),
      .rxd           (rxd_to_the_uart1),
      .txd           (txd_from_the_uart1),
      .write_n       (uart1_s1_write_n),
      .writedata     (uart1_s1_writedata)
    );

  //reset is asserted asynchronously and deasserted synchronously
  TETRISCPU_reset_clk_domain_synch_module TETRISCPU_reset_clk_domain_synch
    (
      .clk      (clk),
      .data_in  (1'b1),
      .data_out (clk_reset_n),
      .reset_n  (reset_n_sources)
    );

  //reset sources mux, which is an e_mux
  assign reset_n_sources = ~(~reset_n |
    0 |
    cpu_jtag_debug_module_resetrequest_from_sa |
    cpu_jtag_debug_module_resetrequest_from_sa);


endmodule


//synthesis translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

// `ifdef USE_convert_hex2ver
// `else
// `define NO_PLI 1
// `endif

`include "c:/altera/11.1/quartus/eda/sim_lib/altera_mf.v"
`include "c:/altera/11.1/quartus/eda/sim_lib/220model.v"
`include "c:/altera/11.1/quartus/eda/sim_lib/sgate.v"
`include "pio_flag.v"
`include "scoreofplayer.v"
`include "cpu_test_bench.v"
`include "cpu_mult_cell.v"
`include "cpu_oci_test_bench.v"
`include "cpu_jtag_debug_module_tck.v"
`include "cpu_jtag_debug_module_sysclk.v"
`include "cpu_jtag_debug_module_wrapper.v"
`include "cpu.v"
`include "uart1.v"
`include "sdram.v"
`include "sdram_test_component.v"
`include "outputycoord.v"
`include "keyboardscancode.v"
`include "jtag_uart.v"
`include "DM9000A_IF.v"
`include "DM9000A.v"
`include "outputxcoord.v"
`include "outputsramdata.v"
`include "keycounter.v"

`timescale 1ns / 1ps

module test_bench 
;


  wire             ENET_CMD_from_the_DM9000A;
  wire             ENET_CS_N_from_the_DM9000A;
  wire    [ 15: 0] ENET_DATA_to_and_from_the_DM9000A;
  wire             ENET_INT_to_the_DM9000A;
  wire             ENET_RD_N_from_the_DM9000A;
  wire             ENET_RST_N_from_the_DM9000A;
  wire             ENET_WR_N_from_the_DM9000A;
  reg              clk;
  wire    [ 23: 0] in_port_to_the_keyboardscancode;
  wire    [ 15: 0] in_port_to_the_keycounter;
  wire             jtag_uart_avalon_jtag_slave_dataavailable_from_sa;
  wire             jtag_uart_avalon_jtag_slave_readyfordata_from_sa;
  wire    [ 15: 0] out_port_from_the_outputsramdata;
  wire    [  9: 0] out_port_from_the_outputxcoord;
  wire    [  9: 0] out_port_from_the_outputycoord;
  wire    [  7: 0] out_port_from_the_pio_flag;
  wire    [ 15: 0] out_port_from_the_scoreofplayer;
  reg              reset_n;
  wire             rxd_to_the_uart1;
  wire             txd_from_the_uart1;
  wire             uart1_s1_dataavailable_from_sa;
  wire             uart1_s1_readyfordata_from_sa;
  wire    [ 11: 0] zs_addr_from_the_sdram;
  wire    [  1: 0] zs_ba_from_the_sdram;
  wire             zs_cas_n_from_the_sdram;
  wire             zs_cke_from_the_sdram;
  wire             zs_cs_n_from_the_sdram;
  wire    [ 15: 0] zs_dq_to_and_from_the_sdram;
  wire    [  1: 0] zs_dqm_from_the_sdram;
  wire             zs_ras_n_from_the_sdram;
  wire             zs_we_n_from_the_sdram;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  //Set us up the Dut
  TETRISCPU DUT
    (
      .ENET_CMD_from_the_DM9000A         (ENET_CMD_from_the_DM9000A),
      .ENET_CS_N_from_the_DM9000A        (ENET_CS_N_from_the_DM9000A),
      .ENET_DATA_to_and_from_the_DM9000A (ENET_DATA_to_and_from_the_DM9000A),
      .ENET_INT_to_the_DM9000A           (ENET_INT_to_the_DM9000A),
      .ENET_RD_N_from_the_DM9000A        (ENET_RD_N_from_the_DM9000A),
      .ENET_RST_N_from_the_DM9000A       (ENET_RST_N_from_the_DM9000A),
      .ENET_WR_N_from_the_DM9000A        (ENET_WR_N_from_the_DM9000A),
      .clk                               (clk),
      .in_port_to_the_keyboardscancode   (in_port_to_the_keyboardscancode),
      .in_port_to_the_keycounter         (in_port_to_the_keycounter),
      .out_port_from_the_outputsramdata  (out_port_from_the_outputsramdata),
      .out_port_from_the_outputxcoord    (out_port_from_the_outputxcoord),
      .out_port_from_the_outputycoord    (out_port_from_the_outputycoord),
      .out_port_from_the_pio_flag        (out_port_from_the_pio_flag),
      .out_port_from_the_scoreofplayer   (out_port_from_the_scoreofplayer),
      .reset_n                           (reset_n),
      .rxd_to_the_uart1                  (rxd_to_the_uart1),
      .txd_from_the_uart1                (txd_from_the_uart1),
      .zs_addr_from_the_sdram            (zs_addr_from_the_sdram),
      .zs_ba_from_the_sdram              (zs_ba_from_the_sdram),
      .zs_cas_n_from_the_sdram           (zs_cas_n_from_the_sdram),
      .zs_cke_from_the_sdram             (zs_cke_from_the_sdram),
      .zs_cs_n_from_the_sdram            (zs_cs_n_from_the_sdram),
      .zs_dq_to_and_from_the_sdram       (zs_dq_to_and_from_the_sdram),
      .zs_dqm_from_the_sdram             (zs_dqm_from_the_sdram),
      .zs_ras_n_from_the_sdram           (zs_ras_n_from_the_sdram),
      .zs_we_n_from_the_sdram            (zs_we_n_from_the_sdram)
    );

  sdram_test_component the_sdram_test_component
    (
      .clk      (clk),
      .zs_addr  (zs_addr_from_the_sdram),
      .zs_ba    (zs_ba_from_the_sdram),
      .zs_cas_n (zs_cas_n_from_the_sdram),
      .zs_cke   (zs_cke_from_the_sdram),
      .zs_cs_n  (zs_cs_n_from_the_sdram),
      .zs_dq    (zs_dq_to_and_from_the_sdram),
      .zs_dqm   (zs_dqm_from_the_sdram),
      .zs_ras_n (zs_ras_n_from_the_sdram),
      .zs_we_n  (zs_we_n_from_the_sdram)
    );

  initial
    clk = 1'b0;
  always
    #10 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #200 reset_n <= 1;
    end

endmodule


//synthesis translate_on