//********************Verilog Edition *************************//

module DE2_Default
	(
		////////////////////	Clock Input	 	////////////////////	 
		CLOCK_27,						//	27 MHz
		CLOCK_50,						//	50 MHz
		EXT_CLOCK,						//	External Clock
		////////////////////	Push Button		////////////////////
		KEY,							//	Pushbutton[3:0]
		////////////////////	DPDT Switch		////////////////////
		SW,								//	Toggle Switch[17:0]
		////////////////////	7-SEG Dispaly	////////////////////
		HEX0,							//	Seven Segment Digit 0
		HEX1,							//	Seven Segment Digit 1
		HEX2,							//	Seven Segment Digit 2
		HEX3,							//	Seven Segment Digit 3
		HEX4,							//	Seven Segment Digit 4
		HEX5,							//	Seven Segment Digit 5
		HEX6,							//	Seven Segment Digit 6
		HEX7,							//	Seven Segment Digit 7
		////////////////////////	LED		////////////////////////
		LEDG,							//	LED Green[8:0]
		LEDR,							//	LED Red[17:0]
		////////////////////////	UART	////////////////////////
		UART_TXD,						//	UART Transmitter
		UART_RXD,						//	UART Receiver
		////////////////////////	IRDA	////////////////////////
		IRDA_TXD,						//	IRDA Transmitter
		IRDA_RXD,						//	IRDA Receiver
		/////////////////////	SDRAM Interface		////////////////
		DRAM_DQ,						//	SDRAM Data bus 16 Bits
		DRAM_ADDR,						//	SDRAM Address bus 12 Bits
		DRAM_LDQM,						//	SDRAM Low-byte Data Mask 
		DRAM_UDQM,						//	SDRAM High-byte Data Mask
		DRAM_WE_N,						//	SDRAM Write Enable
		DRAM_CAS_N,						//	SDRAM Column Address Strobe
		DRAM_RAS_N,						//	SDRAM Row Address Strobe
		DRAM_CS_N,						//	SDRAM Chip Select
		DRAM_BA_0,						//	SDRAM Bank Address 0
		DRAM_BA_1,						//	SDRAM Bank Address 0
		DRAM_CLK,						//	SDRAM Clock
		DRAM_CKE,						//	SDRAM Clock Enable
		////////////////////	Flash Interface		////////////////
		FL_DQ,							//	FLASH Data bus 8 Bits
		FL_ADDR,						//	FLASH Address bus 22 Bits
		FL_WE_N,						//	FLASH Write Enable
		FL_RST_N,						//	FLASH Reset
		FL_OE_N,						//	FLASH Output Enable
		FL_CE_N,						//	FLASH Chip Enable
		////////////////////	SRAM Interface		////////////////
		SRAM_DQ,						   //	SRAM Data bus 16 Bits
		SRAM_ADDR,						//	SRAM Address bus 18 Bits
		SRAM_UB_N,						//	SRAM High-byte Data Mask 
		SRAM_LB_N,						//	SRAM Low-byte Data Mask 
		SRAM_WE_N,						//	SRAM Write Enable
		SRAM_CE_N,						//	SRAM Chip Enable
		SRAM_OE_N,						//	SRAM Output Enable
		
		////////////////////	ISP1362 Interface	////////////////
		OTG_DATA,						//	ISP1362 Data bus 16 Bits
		OTG_ADDR,						//	ISP1362 Address 2 Bits
		OTG_CS_N,						//	ISP1362 Chip Select
		OTG_RD_N,						//	ISP1362 Write
		OTG_WR_N,						//	ISP1362 Read
		OTG_RST_N,						//	ISP1362 Reset
		OTG_FSPEED,						//	USB Full Speed,	0 = Enable, Z = Disable
		OTG_LSPEED,						//	USB Low Speed, 	0 = Enable, Z = Disable
		OTG_INT0,						//	ISP1362 Interrupt 0
		OTG_INT1,						//	ISP1362 Interrupt 1
		OTG_DREQ0,						//	ISP1362 DMA Request 0
		OTG_DREQ1,						//	ISP1362 DMA Request 1
		OTG_DACK0_N,					//	ISP1362 DMA Acknowledge 0
		OTG_DACK1_N,					//	ISP1362 DMA Acknowledge 1
		////////////////////	LCD Module 16X2		////////////////
		LCD_ON,							//	LCD Power ON/OFF
		LCD_BLON,						//	LCD Back Light ON/OFF
		LCD_RW,							//	LCD Read/Write Select, 0 = Write, 1 = Read
		LCD_EN,							//	LCD Enable
		LCD_RS,							//	LCD Command/Data Select, 0 = Command, 1 = Data
		LCD_DATA,						//	LCD Data bus 8 bits
		////////////////////	SD_Card Interface	////////////////
		SD_DAT,							//	SD Card Data
		SD_DAT3,						//	SD Card Data 3
		SD_CMD,							//	SD Card Command Signal
		SD_CLK,							//	SD Card Clock
		////////////////////	USB JTAG link	////////////////////
		TDI,  							// CPLD -> FPGA (data in)
		TCK,  							// CPLD -> FPGA (clk)
		TCS,  							// CPLD -> FPGA (CS)
	    TDO,  							// FPGA -> CPLD (data out)
		////////////////////	I2C		////////////////////////////
		I2C_SDAT,						//	I2C Data
		I2C_SCLK,						//	I2C Clock
		////////////////////	PS2		////////////////////////////
		PS2_DAT,						//	PS2 Data
		PS2_CLK,						//	PS2 Clock
		////////////////////	VGA		////////////////////////////
		VGA_CLK,   						//	VGA Clock
		VGA_HS,							//	VGA H_SYNC
		VGA_VS,							//	VGA V_SYNC
		VGA_BLANK,						//	VGA BLANK
		VGA_SYNC,						//	VGA SYNC
		VGA_R,   						//	VGA Red[9:0]
		VGA_G,	 						//	VGA Green[9:0]
		VGA_B,  						//	VGA Blue[9:0]
		////////////	Ethernet Interface	////////////////////////
		ENET_DATA,						//	DM9000A DATA bus 16Bits
		ENET_CMD,						//	DM9000A Command/Data Select, 0 = Command, 1 = Data
		ENET_CS_N,						//	DM9000A Chip Select
		ENET_WR_N,						//	DM9000A Write
		ENET_RD_N,						//	DM9000A Read
		ENET_RST_N,						//	DM9000A Reset
		ENET_INT,						//	DM9000A Interrupt
		ENET_CLK,						//	DM9000A Clock 25 MHz
		////////////////	Audio CODEC		////////////////////////
		AUD_ADCLRCK,					//	Audio CODEC ADC LR Clock
		AUD_ADCDAT,						//	Audio CODEC ADC Data
		AUD_DACLRCK,					//	Audio CODEC DAC LR Clock
		AUD_DACDAT,						//	Audio CODEC DAC Data
		AUD_BCLK,						//	Audio CODEC Bit-Stream Clock
		AUD_XCK,						//	Audio CODEC Chip Clock
		////////////////	TV Decoder		////////////////////////
		TD_DATA,    					//	TV Decoder Data bus 8 bits
		TD_HS,							//	TV Decoder H_SYNC
		TD_VS,							//	TV Decoder V_SYNC
		TD_RESET,						//	TV Decoder Reset
		////////////////////	GPIO	////////////////////////////
		GPIO_0,							//	GPIO Connection 0
		GPIO_1							//	GPIO Connection 1
		
	);

////////////////////////	Clock Input	 	////////////////////////
input			CLOCK_27;				//	27 MHz
input			CLOCK_50;				//	50 MHz
input			EXT_CLOCK;				//	External Clock
////////////////////////	Push Button		////////////////////////
input	[3:0]	KEY;					//	Pushbutton[3:0]
////////////////////////	DPDT Switch		////////////////////////
input	[17:0]	SW;						//	Toggle Switch[17:0]
////////////////////////	7-SEG Dispaly	////////////////////////
output	[6:0]	HEX0;					//	Seven Segment Digit 0
output	[6:0]	HEX1;					//	Seven Segment Digit 1
output	[6:0]	HEX2;					//	Seven Segment Digit 2
output	[6:0]	HEX3;					//	Seven Segment Digit 3
output	[6:0]	HEX4;					//	Seven Segment Digit 4
output	[6:0]	HEX5;					//	Seven Segment Digit 5
output	[6:0]	HEX6;					//	Seven Segment Digit 6
output	[6:0]	HEX7;					//	Seven Segment Digit 7
////////////////////////////	LED		////////////////////////////
output	[8:0]	LEDG;					//	LED Green[8:0]
output	[17:0]	LEDR;					//	LED Red[17:0]
////////////////////////////	UART	////////////////////////////
output			UART_TXD;				//	UART Transmitter
input			UART_RXD;				//	UART Receiver
////////////////////////////	IRDA	////////////////////////////
output			IRDA_TXD;				//	IRDA Transmitter
input			IRDA_RXD;				//	IRDA Receiver
///////////////////////		SDRAM Interface	////////////////////////
inout	[15:0]	DRAM_DQ;				//	SDRAM Data bus 16 Bits
output	[11:0]	DRAM_ADDR;				//	SDRAM Address bus 12 Bits
output			DRAM_LDQM;				//	SDRAM Low-byte Data Mask 
output			DRAM_UDQM;				//	SDRAM High-byte Data Mask
output			DRAM_WE_N;				//	SDRAM Write Enable
output			DRAM_CAS_N;				//	SDRAM Column Address Strobe
output			DRAM_RAS_N;				//	SDRAM Row Address Strobe
output			DRAM_CS_N;				//	SDRAM Chip Select
output			DRAM_BA_0;				//	SDRAM Bank Address 0
output			DRAM_BA_1;				//	SDRAM Bank Address 0
output			DRAM_CLK;				//	SDRAM Clock
output			DRAM_CKE;				//	SDRAM Clock Enable
////////////////////////	Flash Interface	////////////////////////
inout	         [7:0]	FL_DQ;					//	FLASH Data bus 8 Bits
output	      [21:0]	FL_ADDR;				//	FLASH Address bus 22 Bits
output			FL_WE_N;				//	FLASH Write Enable
output			FL_RST_N;				//	FLASH Reset
output			FL_OE_N;				//	FLASH Output Enable
output			FL_CE_N;				//	FLASH Chip Enable
////////////////////////	SRAM Interface	////////////////////////
inout	[15:0]	SRAM_DQ;				//	SRAM Data bus 16 Bits
output	[17:0]	SRAM_ADDR;				//	SRAM Address bus 18 Bits
output			SRAM_UB_N;				//	SRAM High-byte Data Mask
output			SRAM_LB_N;				//	SRAM Low-byte Data Mask 
output			SRAM_WE_N;				//	SRAM Write Enable
output			SRAM_CE_N;				//	SRAM Chip Enable
output			SRAM_OE_N;				//	SRAM Output Enable
////////////////////	ISP1362 Interface	////////////////////////
inout	[15:0]	OTG_DATA;				//	ISP1362 Data bus 16 Bits
output	[1:0]	OTG_ADDR;				//	ISP1362 Address 2 Bits
output			OTG_CS_N;				//	ISP1362 Chip Select
output			OTG_RD_N;				//	ISP1362 Write
output			OTG_WR_N;				//	ISP1362 Read
output			OTG_RST_N;				//	ISP1362 Reset
output			OTG_FSPEED;				//	USB Full Speed,	0 = Enable, Z = Disable
output			OTG_LSPEED;				//	USB Low Speed, 	0 = Enable, Z = Disable
input			OTG_INT0;				//	ISP1362 Interrupt 0
input			OTG_INT1;				//	ISP1362 Interrupt 1
input			OTG_DREQ0;				//	ISP1362 DMA Request 0
input			OTG_DREQ1;				//	ISP1362 DMA Request 1
output			OTG_DACK0_N;			//	ISP1362 DMA Acknowledge 0
output			OTG_DACK1_N;			//	ISP1362 DMA Acknowledge 1
////////////////////	LCD Module 16X2	////////////////////////////
inout	[7:0]	LCD_DATA;				//	LCD Data bus 8 bits
output			LCD_ON;					//	LCD Power ON/OFF
output			LCD_BLON;				//	LCD Back Light ON/OFF
output			LCD_RW;					//	LCD Read/Write Select, 0 = Write, 1 = Read
output			LCD_EN;					//	LCD Enable
output			LCD_RS;					//	LCD Command/Data Select, 0 = Command, 1 = Data
////////////////////	SD Card Interface	////////////////////////
inout			SD_DAT;					//	SD Card Data
inout			SD_DAT3;				//	SD Card Data 3
inout			SD_CMD;					//	SD Card Command Signal
output			SD_CLK;					//	SD Card Clock
////////////////////////	I2C		////////////////////////////////
inout			I2C_SDAT;				//	I2C Data
output			I2C_SCLK;				//	I2C Clock
////////////////////////	PS2		////////////////////////////////
input		 	PS2_DAT;				//	PS2 Data
input			PS2_CLK;				//	PS2 Clock
////////////////////	USB JTAG link	////////////////////////////
input  			TDI;					// CPLD -> FPGA (data in)
input  			TCK;					// CPLD -> FPGA (clk)
input  			TCS;					// CPLD -> FPGA (CS)
output 			TDO;					// FPGA -> CPLD (data out)
////////////////////////	VGA			////////////////////////////
output			VGA_CLK;   				//	VGA Clock
output			VGA_HS;					//	VGA H_SYNC
output			VGA_VS;					//	VGA V_SYNC
output			VGA_BLANK;				//	VGA BLANK
output			VGA_SYNC;				//	VGA SYNC
output	[9:0]	VGA_R;   				//	VGA Red[9:0]
output	[9:0]	VGA_G;	 				//	VGA Green[9:0]
output	[9:0]	VGA_B;   				//	VGA Blue[9:0]
////////////////	Ethernet Interface	////////////////////////////
inout	[15:0]	ENET_DATA;				//	DM9000A DATA bus 16Bits
output			ENET_CMD;				//	DM9000A Command/Data Select, 0 = Command, 1 = Data
output			ENET_CS_N;				//	DM9000A Chip Select
output			ENET_WR_N;				//	DM9000A Write
output			ENET_RD_N;				//	DM9000A Read
output			ENET_RST_N;				//	DM9000A Reset
input			ENET_INT;				//	DM9000A Interrupt
output			ENET_CLK;				//	DM9000A Clock 25 MHz
////////////////////	Audio CODEC		////////////////////////////
output/*inout*/	AUD_ADCLRCK;			//	Audio CODEC ADC LR Clock
input			AUD_ADCDAT;				//	Audio CODEC ADC Data
inout			AUD_DACLRCK;			//	Audio CODEC DAC LR Clock
output			AUD_DACDAT;				//	Audio CODEC DAC Data
inout			AUD_BCLK;				//	Audio CODEC Bit-Stream Clock
output			AUD_XCK;				//	Audio CODEC Chip Clock
////////////////////	TV Devoder		////////////////////////////
input	[7:0]	TD_DATA;    			//	TV Decoder Data bus 8 bits
input			TD_HS;					//	TV Decoder H_SYNC
input			TD_VS;					//	TV Decoder V_SYNC
output			TD_RESET;				//	TV Decoder Reset
////////////////////////	GPIO	////////////////////////////////
inout	[35:0]	GPIO_0;					//	GPIO Connection 0
inout	[35:0]	GPIO_1;					//	GPIO Connection 1

//////////////////////////////////////////////////////////////////////
////////////////////////////////////
//DLA state machine variables
wire reset;
reg [17:0] cpu_addr_reg; //memory address register for SRAM
reg [17:0] vga_addr_reg;
reg [15:0] data_reg; //memory data register  for SRAM
reg we_vga;
reg we_cpu ;		 //write enable for SRAM
reg flag;


////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

//	LCD ON
assign	LCD_ON		=	1'b0;
assign	LCD_BLON	=	1'b0;

//	All inout port turn to tri-state
assign	DRAM_DQ		=	16'hzzzz;
assign	FL_DQ		=	8'hzz;
assign	SRAM_DQ		=	16'hzzzz;
assign	OTG_DATA	=	16'hzzzz;
assign	SD_DAT		=	1'bz;
//assign	ENET_DATA	=	16'hzzzz;
assign	GPIO_0		=	36'hzzzzzzzzz;
assign	GPIO_1		=	36'hzzzzzzzzz;

//DM9000A Clock
reg				ENET_CLK;
always@(posedge CPU_CLK)	ENET_CLK=~ENET_CLK;

wire [31:0]	mSEG7_DIG;
reg	 [31:0]	Cont;
wire		VGA_CTRL_CLK;
wire		AUD_CTRL_CLK;
wire [9:0]	mVGA_R;
wire [9:0]	mVGA_G;
wire [9:0]	mVGA_B;
wire [19:0]	mVGA_ADDR;			//video memory address
wire [9:0]  Coord_X, Coord_Y;	//display coods
wire		DLY_RST;

assign	TD_RESET	=	1'b1;	//	Allow 27 MHz input
//assign	AUD_ADCLRCK	=	AUD_DACLRCK;
//assign	AUD_XCK		=	AUD_CTRL_CLK;

//assign	LEDR =	18'h0;

Reset_Delay			r0	(	.iCLK(CLOCK_50),.oRESET(DLY_RST)	);

VGA_Audio_PLL 		p1	(	.areset(~DLY_RST),.inclk0(CLOCK_27),.c0(VGA_CTRL_CLK),.c1(AUD_CTRL_CLK),.c2(VGA_CLK)	);



/***************************SDRAM PLL****************************************************/
wire CPU_CLK ;
sdrampll pll1(CLOCK_50, DRAM_CLK ,  CPU_CLK);

//*******************************************************************************************

//***********************************************************************************
//******************************CPU instantiation***********************************

wire [15:0] out_sram_data ; 
wire [23:0] keyboardscancode , keyboardscancode1;
reg [23:0] keyscanreg ; 
wire [7:0] out_flag;
wire [15:0] scoreofplayer ; 



  TETRISCPU cpu1
    ( //DM9000A
      .ENET_CMD_from_the_DM9000A            (ENET_CMD),
      .ENET_CS_N_from_the_DM9000A           (ENET_CS_N),
      .ENET_DATA_to_and_from_the_DM9000A    (ENET_DATA),
      .ENET_INT_to_the_DM9000A              (ENET_INT),
      .ENET_RD_N_from_the_DM9000A           (ENET_RD_N),
      .ENET_RST_N_from_the_DM9000A          (ENET_RST_N),
      .ENET_WR_N_from_the_DM9000A           (ENET_WR_N),
		
      .clk                                  (CPU_CLK),
		.reset_n                              (KEY[0]),
		
      .in_port_to_the_keyboardscancode      (keyscanreg),
      .in_port_to_the_keycounter            (count1),

		
		
		//VGA control
		
      .out_port_from_the_outputsramdata     (out_sram_data),
		
      .out_port_from_the_outputxcoord       (x_ptr),
      .out_port_from_the_outputycoord       (y_ptr),
		
		
      .out_port_from_the_pio_flag           (out_flag),
      .out_port_from_the_scoreofplayer      (scoreofplayer),
		
      
		
      .rxd_to_the_uart1                     (UART_RXD),
      .txd_from_the_uart1                   (UART_TXD),
		
      .zs_addr_from_the_sdram               (DRAM_ADDR),
      .zs_ba_from_the_sdram                 ({DRAM_BA_1, DRAM_BA_0}),
      .zs_cas_n_from_the_sdram              (DRAM_CAS_N),
      .zs_cke_from_the_sdram                (DRAM_CKE),
      .zs_cs_n_from_the_sdram               (DRAM_CS_N),
      .zs_dq_to_and_from_the_sdram          (DRAM_DQ),
      .zs_dqm_from_the_sdram                ({DRAM_UDQM, DRAM_LDQM}),
      .zs_ras_n_from_the_sdram              (DRAM_RAS_N),
      .zs_we_n_from_the_sdram               (DRAM_WE_N)
    );
   
 
    // assign LEDR[9:0] =  row161514write[9:0] ; 
 //***********************************************************************************
     
  

VGA_Controller		u1	(
                   	//	Host Side
							.iCursor_RGB_EN(4'b0111),
							
							.oAddress(mVGA_ADDR),
							
							.oCoord_X(Coord_X),
							.oCoord_Y(Coord_Y),
							
							.iRed(mVGA_R),
							.iGreen(mVGA_G),
							.iBlue(mVGA_B),
							.iFlag(out_flag[7:0]),
					//		.iFlag1(out_flag[1]|SW[1]),
							
							//	VGA Side
							.oVGA_R(VGA_R),
							.oVGA_G(VGA_G),
							.oVGA_B(VGA_B),
							.oVGA_H_SYNC(VGA_HS),
							.oVGA_V_SYNC(VGA_VS),
							.oVGA_SYNC(VGA_SYNC),
							.oVGA_BLANK(VGA_BLANK),
							
							//	Control Signal
							.iCLK(ENET_CLK),
							.iRST_N(DLY_RST),
							
							.iscoreofplayer (scoreofplayer)	);


							
							
							
wire [9:0]  x_ptr,y_ptr;    //nios inputs to the sram

reg  [8:0] counter ;    //for the 
reg [3:0] counter1 ;    //keeps track of the number of rows of the character drawn
reg [15:0] counter3;

reg vga_addr_flag;

wire [7:0] romout ; 


//assign LEDR[7:0] = romout[7:0] ;
//assign LEDR[7:0] = counter3 ;

// SRAM_control
assign SRAM_ADDR = (vga_addr_flag) ? vga_addr_reg:cpu_addr_reg;
assign SRAM_DQ = (we_vga | we_cpu)? 16'hzzzz : data_reg ;
assign SRAM_UB_N = 0;					// hi byte select enabled
assign SRAM_LB_N = 0;					// lo byte select enabled
assign SRAM_CE_N = 0;					// chip is enabled
assign SRAM_WE_N = (we_vga | we_cpu);					// write when ZERO
assign SRAM_OE_N = 0;					//output enable is overidden by WE



// Show SRAM on the VGA
//assign  mVGA_R = {(Coord_X[0]?SRAM_DQ[15:14]:SRAM_DQ[7:6]), 8'b0} ;
//assign  mVGA_G = {(Coord_X[0]?SRAM_DQ[13:10]:SRAM_DQ[5:2]), 6'b0} ;
//assign  mVGA_B = {(Coord_X[0]?SRAM_DQ[9:8]:SRAM_DQ[1:0]), 8'b0} ;

assign  mVGA_R = {SRAM_DQ[11:8],6'b000000};
assign  mVGA_G = {SRAM_DQ[7:4],6'b000000};
assign  mVGA_B = {SRAM_DQ[3:0],6'b000000};






// DLA state machine
assign reset = ~KEY[0];
//assign LEDG = led;


reg [11:0]trial[2:0];





// VGA Cycles
always @ (posedge ENET_CLK )
begin
   trial[0] = 12'hcba;
	trial[1] = 4'b1011;
	trial[2] = 4'hc;

   if (VGA_VS & VGA_HS)
	begin
	//READ 
	vga_addr_flag <=1;
	flag <=0;
	vga_addr_reg <= {Coord_X[9:1],Coord_Y[8:0]} ;
	we_vga <= 1'b1;
	end
	//Write when syncing
	else 
	begin
	vga_addr_flag <=0;
	flag <=1;
	we_vga <= 1'b0;
	end
   
end

	
//CPU Cycles
always@(posedge CPU_CLK)
begin
 if(flag)
   begin
    if (reset)		//synch reset assumes KEY0 is held down 1/60 second
	 begin
		//clear the screen
		cpu_addr_reg <= {Coord_X[9:1],Coord_Y[8:0]} ;	// [17:0]
		we_cpu <= 1'b0;								//write some memory
		data_reg <= 16'b0;						//write all zeros (black)		
		counter <= 9'o330 ;
		counter1 <= 4'b0000 ;		
	 end
	 else
	 begin
		cpu_addr_reg <= {x_ptr[9:1],y_ptr[8:0]};		// [17:0]
		we_cpu <= 1'b0;									//write some memory
		data_reg <= out_sram_data;			
	 end
	end
	end

//*********************************************************************************************************
//*****************************Keyboardfiles. Source cited in the report************************************
wire reset1 = 1'b0;
wire [7:0] scan_code;

reg [7:0] history[1:4];
wire read, scan_ready;

oneshot pulser(
   .pulse_out(read),
   .trigger_in(scan_ready),
   .clk(CLOCK_50)
);

keyboard kbd(
  .keyboard_clk(PS2_CLK),
  .keyboard_data(PS2_DAT),
  .clock50(CLOCK_50),
  .reset(reset1),
  .read(read),
  .scan_ready(scan_ready),
  .scan_code(scan_code)
);



assign keyboardscancode  = {history[3] , history[2] , history[1]};

always @(posedge scan_ready or posedge reset)
begin
	if ( reset == 1'b1)
	begin
	 history[4] <= 8'd0 ;
    history[3] <= 8'd0 ;
    history[2] <= 8'd0 ;
    history[1] <= 8'd0 ;
	end
	else
	begin
    history[4] <= history[3];
    history[3] <= history[2];
    history[2] <= history[1];
    history[1] <= scan_code;
    end
end

reg [2:0]  count ;
reg [15:0] count1 ;  //counts number of keypresses


always @ (posedge scan_ready or posedge reset)
begin
		if (reset == 1'b1)
		begin
		count  <=  3'd0   ; 
		count1 <=  16'd0  ;
		end
		else if ( count == 3'd2)
		begin
		count1 <= count1 + 1 ; 
		count <= 3'd0 ;
		end
		else 
		begin
		count <= count + 1 ; 
		end
end



always @ (count1 or  reset)
begin 
		if (reset == 1'b1)
		begin
		keyscanreg  <=  24'd0   ; 
		end
		else
		begin
		keyscanreg  <= keyboardscancode ;
		end
end

assign LEDG[2:0]  = count ; 

//assign LEDR[7:0]  = count1 ;
assign LEDR[5:0] = count1;




hex_7seg dsp0(keyscanreg [3:0],HEX0);
hex_7seg dsp1(keyscanreg [7:4],HEX1);

hex_7seg dsp2(keyscanreg [11:8],HEX2);
hex_7seg dsp3(keyscanreg [15:12],HEX3);

hex_7seg dsp4(keyscanreg [19:16],HEX4);
hex_7seg dsp5(keyscanreg [23:20],HEX5);

hex_7seg dsp6(history[4][3:0],HEX6);
hex_7seg dsp7(history[4][7:4],HEX7);


endmodule //top module
