/*
 * "Hello World" example.
 *
 * This example prints 'Hello from Nios II' to the STDOUT stream. It runs on
 * the Nios II 'standard', 'full_featured', 'fast', and 'low_cost' example
 * designs. It runs with or without the MicroC/OS-II RTOS and requires a STDOUT
 * device in your system's hardware.
 * The memory footprint of this hosted application is ~69 kbytes by default
 * using the standard reference design.
 *
 * For a reduced footprint version of this template, and an explanation of how
 * to reduce the memory footprint for a given application, see the
 * "small_hello_world" template.
 *
 */

#include <stdio.h>
#include <system.h>
#include <io.h>
#define RED 0
#define GREEN 1
#define BLUE 2
#define BROWN 3
#define PURPLE 4

void draw(col,lig,color){
    int val = 0x0001+(color<<1);
IOWR_16DIRECT(VGA_CIRCLE_INST_BASE,(col+lig*15)*2,val );
}
void clear(col,lig){
IOWR_16DIRECT(VGA_CIRCLE_INST_BASE,(col+lig*15)*2, 0x0000);
}
int read(val){
return IORD_16DIRECT(VGA_CIRCLE_INST_BASE,val*2);
}

int main()
{
   int i ;
   int k = 0;
   
  
   for (i = 0 ; i < 0xffff; i ++)
        IOWR_16DIRECT(VGA_CIRCLE_INST_BASE,i*2, 0x00);
   
   
   for (i = 5 ; i < 15 ; i ++){
    
    clear(3,i-1);
    draw(3,i,GREEN);
    clear(2,i-2);
    draw(2,i-1,RED);
    clear(1,i-2);
    draw(1,i-1,BROWN);
    clear(4,i-3);
    draw(4,i-2,PURPLE);
    for (k = 0 ; k < 200000 ; k ++);
    
   }

 

  return 0;
}











