library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity sprite_controller is
 
  port (
    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out unsigned(9 downto 0); -- Blue[9:0]
    clkin      : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(8 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0)
    );

end sprite_controller;

architecture rtl of sprite_controller is


  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
 
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;

  signal clk25: std_logic :='0';
  signal clkslow: std_logic :='0';

  signal EndOfLine, EndOfField : std_logic;
  signal data_received : unsigned (11 downto 0);
  signal internal_read : unsigned (11 downto 0);
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
 
  signal vga_hblank, vga_hsync,
  vga_vsync : std_logic;  -- Sync. signals
  signal vga_vblank:std_logic;
  signal reset:std_logic;

--signal spritno:integer:=0; 
--signal x:integer;
--signal yc,xc:integer;
--signal delay:unsigned(31 downto 0);--it has to store values upto 640*480


signal xcoordinate:integer:=0;
signal ycoordinate:integer:=0;
---------------------------------------------------RAM-------------------------------------------------------------
 type ram_type is array(15 downto 0) of unsigned(14 downto 0); --max of 16 beats can be displayed on the screen..X-3 bits,Y-10 bits,correct/wrong-1bit,print or not--Since the X represents the sprite no we need to have a value to indicate whether we need to print the sprite or print nothin there
 --type Matrix1_type is array(14 downto 0) of ram_type;
 signal RAM : ram_type:=("111111111111111",others=>"000000000000000");
 --type ram_data is array(15 downto 0) of unsigned (14 downto 0);
 signal ram_address:unsigned(3 downto 0);
 type xbutton_type is array(15 downto 0) of integer;
 type ybutton_type is array(15 downto 0) of integer;
 type ritwrong_type is array(15 downto 0) of  std_logic;
 type pixeloutxy_type is array(15 downto 0) of integer;
 type spritno_type is array (15 downto 0) of integer; 
type enable_type is array(15 downto 0) of std_logic; 
type display_type is array(15 downto 0) of std_logic; 
 
signal xbutton:xbutton_type;
 signal ybutton:ybutton_type;
 signal ritwrong:ritwrong_type ;
 signal enable:enable_type;
signal display:display_type;
signal pixelx:pixeloutxy_type;
signal pixely:pixeloutxy_type;
signal spritno:spritno_type;
signal printspritepixelx:integer:=0;
signal printspritepixely:integer:=0;
signal printsprite:integer:=0;

signal temp0,temp1,temp2,temp3:unsigned (13 downto 0);
signal Xbutton0:integer:=0;
signal Ybutton0:integer:=0;
signal displayoutsum:unsigned(27 downto 0);
signal readfromrom1:unsigned (31 downto 0);
signal readfromrom2:unsigned (31 downto 0);
signal readfromrom3:unsigned (31 downto 0);
signal readfromrom4:unsigned (31 downto 0);
signal readfromrom5:unsigned (31 downto 0);
signal temp :unsigned(31 downto 0);



signal rom_data:unsigned(31 downto 0);
signal score:integer:=0;
component buttondisplay is
port(Xcoordinate:in integer;
Ycoordinate:in integer;
Xbutton: in integer;
Ybutton: in integer;
display:in std_logic;
ritwrong:in std_logic;
pixeloutx: out integer;--The pixel that need to be displayed
pixelouty: out integer;
spritno:out integer;
enable:out std_logic);

end component;



component rom123 is
port (
Clk : in std_logic;
en : in std_logic; -- Read enable
addrx : in integer;
addry: in integer;
printspritenumber:in integer;
data : out unsigned(31 downto 0)
);
end component;


begin

tryrom1:rom123 port map(Clk =>clkin,en=>'1',addrx=>printspritepixelx,addry=>printspritepixely,printspritenumber=>printsprite,data=>readfromrom1 );
tryrom2:rom123 port map(Clk =>clkin,en=>'1',addrx=>printspritepixelx,addry=>printspritepixely,printspritenumber=>printsprite,data=>readfromrom2 );
tryrom3:rom123 port map(Clk =>clkin,en=>'1',addrx=>printspritepixelx,addry=>printspritepixely,printspritenumber=>printsprite,data=>readfromrom3 );
tryrom4:rom123 port map(Clk =>clkin,en=>'1',addrx=>printspritepixelx,addry=>printspritepixely,printspritenumber=>printsprite,data=>readfromrom4 );
tryrom5:rom123 port map(Clk =>clkin,en=>'1',addrx=>printspritepixelx,addry=>printspritepixely,printspritenumber=>printsprite,data=>readfromrom5 );


try1:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(0),Ybutton=>Ybutton(0),display=>display(0),ritwrong=>ritwrong(0),pixeloutx=>pixelx(0),pixelouty=>pixely(0),spritno=>spritno(0),enable=>enable(0));
try2:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(1),Ybutton=>Ybutton(1),display=>display(1),ritwrong=>ritwrong(1),pixeloutx=>pixelx(1),pixelouty=>pixely(1),spritno=>spritno(1),enable=>enable(1));
try3:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(2),Ybutton=>Ybutton(2),display=>display(2),ritwrong=>ritwrong(2),pixeloutx=>pixelx(2),pixelouty=>pixely(2),spritno=>spritno(2),enable=>enable(2));
try4:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(3),Ybutton=>Ybutton(3),display=>display(3),ritwrong=>ritwrong(3),pixeloutx=>pixelx(3),pixelouty=>pixely(3),spritno=>spritno(3),enable=>enable(3));
try5:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(4),Ybutton=>Ybutton(4),display=>display(4),ritwrong=>ritwrong(4),pixeloutx=>pixelx(4),pixelouty=>pixely(4),spritno=>spritno(4),enable=>enable(4));
try6:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(5),Ybutton=>Ybutton(5),display=>display(5),ritwrong=>ritwrong(5),pixeloutx=>pixelx(5),pixelouty=>pixely(5),spritno=>spritno(5),enable=>enable(5));
try7:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(6),Ybutton=>Ybutton(6),display=>display(6),ritwrong=>ritwrong(6),pixeloutx=>pixelx(6),pixelouty=>pixely(6),spritno=>spritno(6),enable=>enable(6));
try8:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(7),Ybutton=>Ybutton(7),display=>display(7),ritwrong=>ritwrong(7),pixeloutx=>pixelx(7),pixelouty=>pixely(7),spritno=>spritno(7),enable=>enable(7));
try9:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(8),Ybutton=>Ybutton(8),display=>display(8),ritwrong=>ritwrong(8),pixeloutx=>pixelx(8),pixelouty=>pixely(8),spritno=>spritno(8),enable=>enable(8));
try10:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(9),Ybutton=>Ybutton(9),display=>display(9),ritwrong=>ritwrong(9),pixeloutx=>pixelx(9),pixelouty=>pixely(9),spritno=>spritno(9),enable=>enable(9));
try11:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(10),Ybutton=>Ybutton(10),display=>display(10),ritwrong=>ritwrong(10),pixeloutx=>pixelx(10),pixelouty=>pixely(10),spritno=>spritno(10),enable=>enable(10));
try12:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(11),Ybutton=>Ybutton(11),display=>display(11),ritwrong=>ritwrong(11),pixeloutx=>pixelx(11),pixelouty=>pixely(11),spritno=>spritno(11),enable=>enable(11));
try13:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(12),Ybutton=>Ybutton(12),display=>display(12),ritwrong=>ritwrong(12),pixeloutx=>pixelx(12),pixelouty=>pixely(12),spritno=>spritno(12),enable=>enable(12));
try14:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(13),Ybutton=>Ybutton(13),display=>display(13),ritwrong=>ritwrong(13),pixeloutx=>pixelx(13),pixelouty=>pixely(13),spritno=>spritno(13),enable=>enable(13));
try15:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(14),Ybutton=>Ybutton(14),display=>display(14),ritwrong=>ritwrong(14),pixeloutx=>pixelx(14),pixelouty=>pixely(14),spritno=>spritno(14),enable=>enable(14));
try16:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton(15),Ybutton=>Ybutton(15),display=>display(15),ritwrong=>ritwrong(15),pixeloutx=>pixelx(15),pixelouty=>pixely(15),spritno=>spritno(15),enable=>enable(15));

--try4:buttondisplay port map(Xcoordinate=>Xcoordinate,Ycoordinate=>Ycoordinate,Xbutton=>Xbutton3,Ybutton=>Ybutton3,pixelout=>displayout3);



--displayoutsum<=displayout(0)+displayout(1)+displayout(2)+displayout(3)+displayout(4)+displayout(5)+displayout(6)+displayout(7)+displayout(8)+displayout(9)+displayout(10)+displayout(11)+displayout(12)+displayout(13)+displayout(14)+displayout(15);


--------------------------------------------------------------------------------------------------------------------

printsprite <= spritno(0) when enable(0) = '1'else
spritno(1) when enable(1) = '1' else
spritno(2) when enable(2) = '1' else
spritno(3) when enable(3) = '1' else
spritno(4) when enable(4) = '1' else
spritno(5) when enable(5) = '1' else
spritno(6) when enable(6) = '1' else
spritno(7) when enable(7) = '1' else
spritno(8) when enable(8) = '1' else
spritno(9) when enable(9) = '1' else
spritno(10) when enable(10) = '1' else
spritno(11) when enable(11) = '1' else
spritno(12) when enable(12) = '1' else
spritno(13) when enable(13) = '1' else
spritno(14) when enable(14) ='1' else
spritno(15) when enable(15) = '1' else
0;

printspritepixelx <= pixelx(0) when enable(0) = '1'else
pixelx(1) when enable(1) = '1' else
pixelx(2) when enable(2) = '1' else
pixelx(3) when enable(3) = '1' else
pixelx(4) when enable(4) = '1' else
pixelx(5) when enable(5) = '1' else
pixelx(6) when enable(6) = '1' else
pixelx(7) when enable(7) = '1' else
pixelx(8) when enable(8) = '1' else
pixelx(9) when enable(9) = '1' else
pixelx(10) when enable(10) = '1' else
pixelx(11) when enable(11) = '1' else
pixelx(12) when enable(12) = '1' else
pixelx(13) when enable(13) = '1' else
pixelx(14) when enable(14) ='1' else
pixelx(15) when enable(15) = '1' else
0;

printspritepixely <= pixely(0) when enable(0) = '1'else
pixely(1) when enable(1) = '1' else
pixely(2) when enable(2) = '1' else
pixely(3) when enable(3) = '1' else
pixely(4) when enable(4) = '1' else
pixely(5) when enable(5) = '1' else
pixely(6) when enable(6) = '1' else
pixely(7) when enable(7) = '1' else
pixely(8) when enable(8) = '1' else
pixely(9) when enable(9) = '1' else
pixely(10) when enable(10) = '1' else
pixely(11) when enable(11) = '1' else
pixely(12) when enable(12) = '1' else
pixely(13) when enable(13) = '1' else
pixely(14) when enable(14) ='1' else
pixely(15) when enable(15) = '1' else
0;







 -- Horizontal and vertical counters
 HCounter : process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;     
    end if;

  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
 
  VCounter: process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' then
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';



 ------------------------------- Registered video signals going to the video DAC------------------------------------------

 

  ------------------------------ State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK--------------------------------

  HSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then    
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
 
  HBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;     
    end if;
  end process HBlankGen;

  VSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;     
    end if;
  end process VSyncGen;

  VBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then   
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;


--

------------------------------------------------------------------------------------------------------------------
Xcoordinate<=(to_integer(Hcount)-HSYNC - HBACK_PORCH);
Ycoordinate<=(to_integer(Vcount)-VSYNC - VBACK_PORCH);


-----------------------------EXCTRACTING DATA FROM RAM------------------------------------------------------
 reset <= not reset_n;
  ram_address<= address(3 downto 0) ;--ram_adress is 6 bits
 

 process (clkin)      -----Process for reading/writing data from the RAM based on chipselect and reset_n
 begin
    if rising_edge(clkin) then
      if reset_n = '0' then
        readdata <= (others => '0');
      else
        if chipselect = '1' then
            if read = '1' then
              --readdata <= "00" & RAM(to_integer(ram_address));
               --readdata <= "0001011111111111" ;
readdata <= "0" & RAM(to_integer(ram_address));
--readdata <=rom_data(15 downto 0);
temp<=X"0ff3fc00";
--readdata <= "000000000000000" & display(6);
--readdata <= "00000000" & (ram_data(7 downto 0));
                elsif write = '1' then
                RAM(to_integer(ram_address)) <= writedata(15 downto 0);
                 
               
                end if;
            else


end if;


 end if;
 end if;
 end process;


--Xbutton(0)<=to_integer(RAM(0)(2 downto 0));
--Ybutton(0)<=to_integer(RAM(0)(12 downto 3));
--display(0)<=(RAM(0)(13));
--ritwrong(0)<=(RAM(0)(14));

Xbutton(1)<=to_integer(RAM(1)(2 downto 0));
Ybutton(1)<=to_integer(RAM(1)(12 downto 3));
display(1)<=(RAM(1)(13));
ritwrong(1)<=(RAM(1)(14));

Xbutton(2)<=to_integer(RAM(2)(2 downto 0));
Ybutton(2)<=to_integer(RAM(2)(12 downto 3));
display(2)<=(RAM(2)(13));
ritwrong(2)<=(RAM(2)(14));

Xbutton(3)<=to_integer(RAM(3)(2 downto 0));
Ybutton(3)<=to_integer(RAM(3)(12 downto 3));
display(3)<=(RAM(3)(13));
ritwrong(3)<=(RAM(3)(14));

Xbutton(4)<=to_integer(RAM(4)(2 downto 0));
Ybutton(4)<=to_integer(RAM(4)(12 downto 3));
display(4)<=(RAM(4)(13));
ritwrong(4)<=(RAM(4)(14));


Xbutton(5)<=to_integer(RAM(5)(2 downto 0));
Ybutton(5)<=to_integer(RAM(5)(12 downto 3));
display(5)<=(RAM(5)(13));
ritwrong(5)<=(RAM(5)(14));


Xbutton(6)<=to_integer(RAM(6)(2 downto 0));
Ybutton(6)<=to_integer(RAM(6)(12 downto 3));
display(6)<=(RAM(6)(13));
ritwrong(6)<=(RAM(6)(14));


Xbutton(7)<=to_integer(RAM(7)(2 downto 0));
Ybutton(7)<=to_integer(RAM(7)(12 downto 3));
display(7)<=(RAM(7)(13));
ritwrong(7)<=(RAM(7)(14));


Xbutton(8)<=to_integer(RAM(8)(2 downto 0));
Ybutton(8)<=to_integer(RAM(8)(12 downto 3));
display(8)<=(RAM(8)(13));
ritwrong(8)<=(RAM(8)(14));

Xbutton(9)<=to_integer(RAM(9)(2 downto 0));
Ybutton(9)<=to_integer(RAM(9)(12 downto 3));
display(9)<=(RAM(9)(13));
ritwrong(9)<=(RAM(9)(14));

Xbutton(10)<=to_integer(RAM(10)(2 downto 0));
Ybutton(10)<=to_integer(RAM(10)(12 downto 3));
display(10)<=(RAM(10)(13));
ritwrong(10)<=(RAM(10)(14));

Xbutton(11)<=to_integer(RAM(11)(2 downto 0));
Ybutton(11)<=to_integer(RAM(11)(12 downto 3));
display(11)<=(RAM(11)(13));
ritwrong(11)<=(RAM(11)(14));

Xbutton(12)<=to_integer(RAM(12)(2 downto 0));
Ybutton(12)<=to_integer(RAM(12)(12 downto 3));
display(12)<=(RAM(12)(13));
ritwrong(12)<=(RAM(12)(14));

Xbutton(13)<=to_integer(RAM(13)(2 downto 0));
Ybutton(13)<=to_integer(RAM(13)(12 downto 3));
display(13)<=(RAM(13)(13));
ritwrong(13)<=(RAM(13)(14));

Xbutton(14)<=to_integer(RAM(14)(2 downto 0));
Ybutton(14)<=to_integer(RAM(14)(12 downto 3));
display(14)<=(RAM(14)(13));
ritwrong(14)<=(RAM(14)(14));

Xbutton(15)<=to_integer(RAM(15)(2 downto 0));
Ybutton(15)<=to_integer(RAM(15)(12 downto 3));
display(15)<=(RAM(15)(13));
ritwrong(15)<=(RAM(15)(14));

score<=to_integer(RAM(0));



------------------------------------------------------generating clock for the VGA-----------------------------------------
 process (clkin)  
  begin
    if rising_edge(clkin) then
      clk25 <= not clk25;
    end if;
 end process;
--------------------------------------------ASSIGNING THE RAM DATA TO THE VARIABLES ----------------------------------------


--------------------------------------------dealing with sprite offset-----------------------------------







process (clk25)      -----Process for reading data from the ROM based on reset_n ??????????????????????????????
 begin

if rising_edge(clk25) then
if reset_n = '0' then
rom_data<=X"00000000";

else if (printsprite=0 and Xcoordinate>140 and Xcoordinate<370 and Ycoordinate>380 and Ycoordinate<400) then
rom_data<=X"0ff3fc00";

else if (printsprite=0 and Xcoordinate=156)or (printsprite=0 and Xcoordinate=156+50) or (printsprite=0 and Xcoordinate=156+100) or (printsprite=0 and Xcoordinate=156+150) or (printsprite=0 and Xcoordinate=156+200) then --displaying the white lines
rom_data<=X"ffffffff";

else if (printsprite=0 and (Xcoordinate-475)*(Xcoordinate-475)+(Ycoordinate-75)*(Ycoordinate-75)<625 and score>0        ) then
rom_data<=X"f1f1f1f1";
else if (printsprite=0 and (Xcoordinate-525)*(Xcoordinate-525)+(Ycoordinate-80)*(Ycoordinate-80)<400 and score>1) then
rom_data<=X"f1f1f1f1";
else if (printsprite=0 and (Xcoordinate-565)*(Xcoordinate-565)+(Ycoordinate-85)*(Ycoordinate-85)<225 and score>2) then
rom_data<=X"f1f1f1f1";
else if (printsprite=0 and (Xcoordinate-595)*(Xcoordinate-595)+(Ycoordinate-90)*(Ycoordinate-90)<100 and score>3) then
rom_data<=X"f1f1f1f1";
else if (printsprite=0 and (Xcoordinate-615)*(Xcoordinate-615)+(Ycoordinate-95)*(Ycoordinate-95)<25 and score>4) then
rom_data<=X"f1f1f1f1";

else if (printsprite=0 and Xcoordinate>140 and Xcoordinate<370 and Ycoordinate>380 and Ycoordinate<400) then
rom_data<=X"0ff3fc00";

else if (printsprite=0 and Xcoordinate=156)or (printsprite=0 and Xcoordinate=156+50) or (printsprite=0 and Xcoordinate=156+100) or (printsprite=0 and Xcoordinate=156+150) or (printsprite=0 and Xcoordinate=156+200) then --displaying the white lines
rom_data<=X"ffffffff";

else if (printsprite=0) then
rom_data<=X"00000000";

else  if (printsprite=1) then
rom_data <= readfromrom1;

else if (printsprite=2) then
--rom_data <= Ma2(printspritepixelx)(printspritepixely);
rom_data <= readfromrom1;

else if (printsprite=3) then
--rom_data <= Ma2(printspritepixelx)(printspritepixely);
rom_data <= readfromrom1;

else if (printsprite=4) then
--rom_data <= Ma1(printspritepixelx)(printspritepixely);
rom_data <= readfromrom2;

else if (printsprite=5) then
--rom_data <= Ma1(printspritepixelx)(printspritepixely);
rom_data <= readfromrom3;

else if (printsprite=6) then
--rom_data <= Ma1(printspritepixelx)(printspritepixely);
rom_data <= readfromrom4;
else if (printsprite=7) then
--rom_data <= Ma1(printspritepixelx)(printspritepixely);
rom_data <= readfromrom5;

else rom_data<=X"00000000";

end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end if;
end process;
--
----readdata <= x"0" & internal_read (11 downto 0);
----data_received <= writedata (11 downto 0);




VideoOut: process (clk25, reset)
begin
if reset = '1' then
   
VGA_R <= "0000000000" ;
VGA_G <= "0000000000"  ;--& rom_data(17 downto 9);
VGA_B <= "0000000000";-- & rom_data(26 downto 18);--"1111111111";



else if clk25'event and clk25 = '1' then
   if vga_hblank='0' and vga_vblank='0' then
   if(printsprite>0 and Xcoordinate>140 and Xcoordinate<370 and Ycoordinate>380 and Ycoordinate<400 and rom_data(29 downto 0)=0)then
		  VGA_G <=temp  (19 downto 10);
   VGA_R <= temp(9 downto 0);
   VGA_B <=  temp(29 downto 20);--"1111111111";
	else
   VGA_G <=  rom_data(19 downto 10);
   VGA_R <= rom_data(9 downto 0);
   VGA_B <=  rom_data(29 downto 20);--"1111111111";
end if;

   
else
     VGA_R <= "0000000000";
     VGA_G <= "0000000000";
    VGA_B <= "0000000000";   
   end if;
   end if;
end if;
 end process VideoOut;

VGA_CLK <= clk25;
VGA_HS <= not vga_hsync;
VGA_VS <= not vga_vsync;
VGA_SYNC <= '0';
VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
--

 
 

