// This file is part of The Awesome Guitar Game.
//
//    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    The Awesome Guitar Game is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
//
//
//###########################################################
// The awesome guitar game (A clone of Guitar Hero for FPGA #
//###########################################################
// EMBEDDED SYSTEM PROJECT
// Columbia Unviersity Spring 2012
//
// Avijit Singh Wasu -- asw2156@columbia.edu
// Laurent Charignon -- lc2817@columbia.edu
// 
// Licensed under the GPL license
// Have a look at the license file in the root of 
// the project to have more details about the license
//
//##########################################################

#include <stdio.h>
#include <system.h>
#include <math.h>
#include<io.h>
#include <sys/alt_irq.h>


/*******************
** DEFINES
********************/
#define REPRBREAT(beat) ((beat.color)+(beat.Y) << 3);
#define READNEWNOTE(address)  IORD_8DIRECT(CFI_FLASH_BASE, address);
#define READNEWBEAT(current_note)  IORD_16DIRECT(BEATCONTROLLER_INST_BASE, current_note*2)
#define WRITENOTE(note)  IOWR_8DIRECT( MUSICCONTROLLER_INST_BASE, 0, (note-127)&0xFF);
#define WRITEBEAT(v) IOWR_16DIRECT(VGA_BASE,v*2,(beats[v]));
#define NUMCELL 16
#define PACE 2
#define MAX_Y 480

/***************** 
 * STRUCTS
 ****************/
//A beat
typedef struct beat {
  unsigned char color;    // Color between 2 and 6 for notes
  int Y;                  // Y value of the note
} beat ; 

/*****************
 ** ISR CALLBACKS
 *****************/
// We have tree types of callbacks
static void  note_isr ( void* context, alt_u32 id);
static void  input_isr ( void* context, alt_u32 id);
static void  timer_isr ( void* context, alt_u32 id);  

/**********************
 **GENERAL PROTOTYPES
 ***********************/
void init_sys();
void vga_reset();                                     //TODO determine if it is needed
inline int get_rand_1_6();

/***********************
** GLOBAL VARIABLES
************************/
volatile int current_beat_number  = 0;               //Current note: 40, TODO: compute it instead
volatile int next_beat            = 0; 
volatile long time                = 0;              //Start time for the beats, it has to be the 
volatile int UP                   = 0;                //time it takes to cross the screen
volatile int NEWBEAT              = 0 ;
volatile long notes_address       = 0;
volatile int next_sample          = 0;
volatile int numballs             = 5;
volatile int numpressed           = 2 ;
volatile int totalballs           = 0 ;
volatile int scoretrigger         = 0;


 #define threshold  100
//TODO CONSTANT

 int rbase              = 480;//TOBEDEFINED
 int hbase              = 380-threshold;
volatile int score                = 0;
volatile int string = 0;
volatile int should_fetch_new_sample = 1;

/***********************
 ** IMPLEMENTATION
 ***********************/
// Sends the new notes to the music controller
// @trigger: 16 000 times per second
static void  note_isr ( void* context, alt_u32 id){
  static int count =0  ; 
  // This whole thing plays one note every two interrupts
  count ++;
  if (count == 1){
    notes_address +=2;count = 0;
    
  }
  // Write the note thus cleaning the exception
  should_fetch_new_sample = 1;
  WRITENOTE(next_sample);
  
  return;
}   

// Keeps track of user's input
// @trigger: when a key is pressed
static void  input_isr ( void* context, alt_u32 id){
  int col =   IORD_16DIRECT( INPUTCONTROLLER_INST_BASE, 0);
  if (numpressed > 0) 
    numpressed --;
  switch(col){
  case 1:
  string = 2;
  break;
  case 2:
  string = 3;
  break;
  case 4:
  string = 4;
  break;
  case 8:
  string = 5;
  break;
  case 16:
  string = 6;
  break;
  default:
  break;
  }
  
  IOWR_8DIRECT( INPUTCONTROLLER_INST_BASE, 0, 0);
    
  

  //TODO implement the score computation
  /* HOW TO USE THE HEX DISPLAY 
     if ((current_note&0x2) == 2)
     IOWR_16DIRECT(SCORECONTROLLER_INST_BASE,0,0xdead);
     else
     IOWR_16DIRECT(SCORECONTROLLER_INST_BASE,0,0xbeef);

*/
  return;
}  


// Synchronize the timing of the whole system, keeps track of the ellapsed time
// @trigger: 100 times per second
static void  timer_isr ( void* context, alt_u32 id){
  time ++;
  //printf("%d NEXT %d beat_number %d\n",time,next_beat,current_beat_number);
  
  //UP = 1 means enable a function in the main loop to move 
  //the beats down one step
  UP = 1;
  if(scoretrigger == 0 && time > 1500)
    scoretrigger =1;

  //If a new beat shows up
  if (next_beat == time){
    current_beat_number++;
    NEWBEAT = 1;
  }

  //Clear the exception
  IOWR_16DIRECT( TIMER_BASE, 0, 0);
  return;
}   



inline int get_rand_1_6(){
        int shifter=0 ; 
        do{
          shifter = (rand()&0x7);
        } while (shifter == 7 || (shifter < 1)  );
        
        return shifter;
}

int main()
{
if(380+threshold > 480)
 rbase              = 480;
else
 rbase              = 380+threshold;


    
  int i = 0;
  int beats[NUMCELL];
  for ( i = 0 ; i<NUMCELL ; i ++){
  IOWR_16DIRECT(VGA_BASE,i*2,0);
  beats[i] = 0;
}




alt_irq_register(INPUTCONTROLLER_INST_IRQ, (void*)0, input_isr);
while(numpressed > 0);


  //TODO MOVE
  IOWR_16DIRECT(TIMER_BASE, 2, 0x7);
  alt_irq_register(TIMER_IRQ, (void*)0, timer_isr);
  alt_irq_register(MUSICCONTROLLER_INST_IRQ , (void*)0, note_isr);
  
  //printf("%d %d %d\n",READNEWBEAT(0),READNEWBEAT(1),READNEWBEAT(2));
  //the cursors of the ARRAY
  int low = 1;
  int high = 1;
  int v = 0;
  int should_fetch_new_beat = 1;
  int u ;
  int pos = 0 ;
  //the array that stores the notes
  
  for(;;){
     IOWR_16DIRECT(SCORECONTROLLER_INST_BASE,0,score);
IOWR_16DIRECT(VGA_BASE,0,numballs);
    if(string > 0){
            
            u = low;
            printf("TREATING %d %d\n",low,high);
            //printf("DEALING with strings %d \n",string);
            while (u !=high){
                pos = (beats[u]>>3) ;
                printf("color: %d %d %d %d\n",(beats[u]&0x7), (beats[u]>>3),hbase,rbase);
                if( ((beats[u]&0x7) == string) && (hbase<pos) && (rbase>pos) ){
                    beats[u]= 0 ;
                    if (u == low){
                        low ++;
                        if ( low == NUMCELL)
                            low = 1;
                    }
                    printf("gotcha !\n");
                    score ++;
                    if(scoretrigger ==1)
                        numballs = ((5*score)/totalballs+1);
                    
                    break;
            }
		//Optimization ...
               /* if((beats[u]>>3)<hbase){
                 printf("too late !\n");
                    break;
                }*/
                
             u++;
             if (u == NUMCELL)
             u = 1;   
            }
                 string = 0;
        }
        
        
    
    
    if(should_fetch_new_beat == 1){
       
    next_beat        = READNEWBEAT(current_beat_number);
    should_fetch_new_beat =0 ;
    }
    
    if(should_fetch_new_sample == 1){
    next_sample = READNEWNOTE(notes_address);
    should_fetch_new_sample = 0;
    }

    
    if(UP){
      // 1) Process new beats
      if(NEWBEAT){
     //  printf("at %d = %d \n",v,beats[v]);
        beats[high] = get_rand_1_6();
        high++; 
        should_fetch_new_beat =1 ;
        
        if (high == NUMCELL)    high= 1 ;
      }
        v           = low;
      //2) Move the beats one step below
        //  printf("at %d = %d \n",v,beats[v]);
      while (v != high){
        beats[v]+= (PACE<<3);
        //
        if(beats[v] >=  3846){ //MAX_Y){
           beats[v] = 0;
           low++;
           totalballs++;
           if(scoretrigger ==1)
           numballs = ((5*score)/totalballs+1);
        }
        WRITEBEAT(v);
       
        v++;
        
        if(v == NUMCELL)
          v = 1;   
          
         
      }

      //3) Check if boundaries are reached
      if (high  == NUMCELL)         high = 1 ;
      if (low   == NUMCELL)         low = 1 ;

      //4) Reset the flags
      UP        = 0; 
      NEWBEAT   = 0;
      
   
    }
    
  }
  return 0;
}

