-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
--This component is in charge of displaying the score
--On the 4 rightmost HEX displays

entity scoreController is
  
  port (
    --Avalon
	clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(1 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0);
	--To HEX DISPLAY
	HEX_0    : out std_logic_vector(6 downto 0);
	HEX_1	: out std_logic_vector(6 downto 0);
	HEX_2	: out std_logic_vector(6 downto 0);
	HEX_3	: out std_logic_vector(6 downto 0)
	);
end scoreController;

architecture ar of scoreController is

component hex_decoder is port(
	di		: in unsigned(3 downto 0);
	do		: out std_logic_vector( 6 downto 0 )
);
end component hex_decoder; 
signal we:std_logic;
signal in_val: unsigned (15 downto 0) ; 
signal d0: unsigned (3 downto 0);
signal d1: unsigned (3 downto 0);
signal d2: unsigned (3 downto 0);
signal d3: unsigned (3 downto 0);
begin
H0: hex_decoder port map(d0,HEX_0);
H1: hex_decoder port map(d1,HEX_1);
H2: hex_decoder port map(d2,HEX_2);
H3: hex_decoder port map(d3,HEX_3);
we <= '1' when chipselect ='1' and write='1' else '0';
--in_val <= writedata when we ='1' else in_val;
d0 <= in_val(3 downto 0); 
d1 <= in_val(7 downto 4); 
d2 <= in_val(11 downto 8); 
d3 <= in_val(15 downto 12); 




process(clk)
begin
if(rising_edge(clk)) then 
	in_val <= in_val;
	if( reset_n='0' )
	then
			in_val <= x"0000";
	else
			if (we = '1') then 
				in_val <= writedata ;
			end if;
	end if ;
end if ; 
end process ;

end ar;







