-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity rom123 is
port (
Clk : in std_logic;
en : in std_logic; -- Read enable
addrx : in integer;
addry: in integer;
printspritenumber:in integer;
data : out unsigned(31 downto 0)
);
end rom123;

architecture imp of rom123 is
signal index:integer;


type rom_type is array (8192 downto 0) of unsigned( 31 downto 0);           --Rom used to store the sprites
--type Matrix_type is array (31 downto 0) of rom_type;
constant ROM1 : rom_type :=
(x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"358d535c", x"358d635c", x"358d735c", x"358d635c", x"354d5358", x"348d234c", x"334cd338", x"318c6320", x"2f8be300", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"378de378", x"37ce0380", x"394e5398", x"3bcee3bc", x"3dcf73dc", x"3ecfb3ec", x"3f0fc3f0", x"3ecfb3ec", x"3dcf83e0", x"3bcef3bc", x"380e1384", x"33ccf340", x"2fcbf300", x"2ccb42d4", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"384e1388", x"38ce3390", x"3b4ee3b8", x"3f8fe3f8", x"3fcff3fc", x"3c4ef3cc", x"360d5374", x"314c2324", x"2ecb92fc", x"2f8bb304", x"330ca340", x"38ce0398", x"3e0f63e8", x"3fcff3fc", x"3c8f23c8", x"340d1344", x"2dcb72e4", x"2a4a92b0", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"38ce338c", x"3a8ea3a8", x"3f4fe3f8", x"3f0fb3f4", x"328c733c", x"2308b230", x"17862148", x"110500bc", x"0dc4d084", x"0cc4d06c", x"0d04f070", x"0f051094", x"13c5c0ec", x"1cc781a4", x"2a0a82a8", x"38ce039c", x"3fcff3fc", x"3b4ed3b8", x"2fcbf300", x"2a0a82a8", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"390e4394", x"3c0f03c0", x"3fcff3fc", x"354d3364", x"1e8791e4", x"0f44909c", x"09850048", x"0806d08c", x"080830e8", x"0888f120", x"08c93134", x"08c8f120", x"084840f0", x"07c720a0", x"07c5c048", x"0ac4e040", x"15c64110", x"298a629c", x"3c0ee3cc", x"3fcff3fc", x"320c8324", x"294a529c", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"390e4394", x"3ccf33cc", x"3fcff3fc", x"2b4aa2c8", x"12c4f0f0", x"0905003c", x"080850e8", x"09cae1a8", x"0a8b91e4", x"0a8b61d4", x"0a8b01bc", x"0a8ab1a8", x"0a8a819c", x"0a8a6194", x"0aca418c", x"0a89f174", x"0948c118", x"06c63060", x"0ac4d038", x"1e4801bc", x"36cd8380", x"3fcff3fc", x"324ca328", x"27ca0284", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"38ce4390", x"3c4f13c4", x"3fcff3fc", x"2749a288", x"0e846090", x"07c6b084", x"098b01b0", x"0a8bd1f4", x"0a8b41d0", x"0a8b21c4", x"0a8b11c0", x"0a8af1b8", x"0a8ac1a8", x"0a8a7198", x"0a8a418c", x"0a8a017c", x"0a89c16c", x"0a89b164", x"0ac9c168", x"08c820f0", x"06c4f014", x"1907114c", x"358d3368", x"3fcff3fc", x"2fcc0304", x"25897264", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"388e238c", x"3acea3ac", x"3fcff3fc", x"2a4a72b8", x"0e846090", x"07c7c0c8", x"0a0bf1f8", x"0a4b81e4", x"0a4b41d0", x"0a8b41cc", x"0a8b31c8", x"0a8b21c4", x"0a8b11c0", x"0a8af1b8", x"0a8aa1a4", x"0a8a7194", x"0a8a3184", x"0a89f174", x"0a89b164", x"0a896154", x"0a896154", x"0a08f12c", x"06055024", x"1a875160", x"388df398", x"3ecfb3ec", x"2b0ad2b8", x"23890244", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"394e5394", x"3fcff3fc", x"338cc34c", x"1284f0e4", x"07c790c0", x"0a0c2208", x"0a4b81e0", x"0a4b61d8", x"0a4b61d8", x"0a4b51d4", x"0a4b41d0", x"0a8b31cc", x"0a8b21c4", x"0a8b11c0", x"0a8ae1b4", x"0a8aa1a0", x"0a8a5190", x"0a8a1180", x"0a89d16c", x"0a89915c", x"0a894148", x"0a892140", x"0a08e128", x"06c5402c", x"22c90200", x"3e4f73f0", x"37ce0380", x"25496260", x"40000000", x"40000000", 
 x"40000000", x"37cde380", x"3bcf03c0", x"3e4f83e8", x"1d4711c0", x"09065094", x"094bf1f4", x"0a0bb1ec", x"0a0b81e4", x"0a0b81e0", x"0a4b71dc", x"0a4b61d8", x"0a4b51d4", x"0a4b41d0", x"0a8b31c8", x"0a8b21c4", x"0a8b01bc", x"0a8ac1ac", x"0a8a8198", x"0a8a3188", x"0a89f174", x"0a89b164", x"0a896150", x"0a89113c", x"0a88f134", x"08c830f4", x"0c45a078", x"30cc1308", x"3fcff3fc", x"2ccb42d4", x"20883218", x"40000000", 
 x"40000000", x"384e2388", x"3fcff3fc", x"304bd310", x"0ec510bc", x"080aa18c", x"0a0c0204", x"0a0ba1e8", x"0a0b91e8", x"0a0b91e4", x"0a0b81e0", x"0a4b71dc", x"0a4b61d8", x"0a4b51d4", x"0a8b41cc", x"0a8b31c8", x"0a8b11c0", x"0a8af1b8", x"0a8aa1a0", x"0a8a5190", x"0a8a1180", x"0a89c16c", x"0a897158", x"0a893144", x"0a88e130", x"0ac8e130", x"0646c088", x"1cc82190", x"3e4f63f0", x"370dc374", x"2348e240", x"40000000", 
 x"360d8368", x"39ce83a0", x"3fcff3fc", x"2147e1f4", x"0947b0f8", x"094c5210", x"09cbb1f0", x"09cbb1f0", x"09cbb1f0", x"0a0ba1ec", x"0a0b91e8", x"0a0b81e0", x"0a4b71dc", x"0a4b61d8", x"0a4b41d0", x"0a8b31cc", x"0a8b21c4", x"0a8b01bc", x"0a8ac1ac", x"0a8a7198", x"0a8a2184", x"0a89e170", x"0a89915c", x"0a894148", x"0a890138", x"0a88b120", x"09086104", x"0dc680b8", x"350d0344", x"3ecfb3ec", x"280a1288", x"40000000", 
 x"364d9368", x"3c8f23c8", x"3a8e73b0", x"16064144", x"080aa190", x"09cc220c", x"09cbd1f8", x"09cbd1f8", x"09cbc1f4", x"09cbb1f0", x"0a0ba1ec", x"0a0b91e4", x"0a0b81e0", x"0a4b61d8", x"0a4b51d4", x"0a8b41cc", x"0a8b21c8", x"0a8b11c0", x"0a8ad1b0", x"0a8a819c", x"0a8a3188", x"0a89f174", x"0a89a160", x"0a89514c", x"0a890138", x"0a88b124", x"0a88a11c", x"07c6e0a0", x"28caa26c", x"3fcff3fc", x"2d8b72e0", x"1cc741dc", 
 x"364da368", x"3e8fa3e8", x"340c7338", x"10070130", x"080c01ec", x"098be200", x"098be200", x"09cbe1fc", x"09cbd1f8", x"09cbc1f4", x"09cbb1f0", x"0a0b91e8", x"0a0b81e0", x"0a4b71dc", x"0a4b51d4", x"0a4b41cc", x"0a8b21c8", x"0a8b11c4", x"0a8ae1b4", x"0a8a91a0", x"0a8a418c", x"0a8a0178", x"0a89b164", x"0a896150", x"0a89113c", x"0a88c128", x"0a888118", x"06c780bc", x"1ec941d0", x"3fcff3fc", x"328ca32c", x"1e4791f0", 
 x"364d9368", x"3f8fe3f8", x"2ecb02d4", x"0d088168", x"084c520c", x"098bf204", x"098c0208", x"098bf204", x"09cbe1fc", x"09cbd1f8", x"09cbb1f0", x"0a0ba1e8", x"0a0b91e4", x"0a4b71dc", x"0a4b61d4", x"0a4b41d0", x"0a8b31c8", x"0a8b21c4", x"0a8af1b8", x"0a8aa1a0", x"0a8a518c", x"0a8a017c", x"0a89b164", x"0a896150", x"0a892140", x"0a88d12c", x"0a888114", x"0747d0d8", x"1848d184", x"3f8f73f4", x"360d8364", x"1f87f204", 
 x"35cd7360", x"3fcff3fc", x"2cca92b4", x"0c49b1a8", x"084c4208", x"098c0208", x"098c120c", x"098c0204", x"098be200", x"09cbd1f8", x"09cbb1f0", x"0a0ba1ec", x"0a0b91e4", x"0a4b71dc", x"0a4b61d8", x"0a4b41d0", x"0a8b31c8", x"0a8b21c4", x"0a8af1b8", x"0a8aa1a4", x"0a8a5190", x"0a8a017c", x"0a89b168", x"0a896154", x"0a892140", x"0a88d12c", x"0a888118", x"07c7e0e0", x"1588e178", x"3e4f33dc", x"378de378", x"2008120c", 
 x"350d5354", x"3f8fe3f8", x"2d4ae2c8", x"0cca61d8", x"084c2200", x"098c0204", x"098c0208", x"098c0204", x"09cbe200", x"09cbd1f8", x"09cbb1f0", x"0a0ba1e8", x"0a0b91e4", x"0a4b71dc", x"0a4b61d4", x"0a4b41d0", x"0a8b31c8", x"0a8b21c4", x"0a8af1b8", x"0a8aa1a4", x"0a8a518c", x"0a8a017c", x"0a89b164", x"0a896150", x"0a892140", x"0a88d12c", x"0a888114", x"07c7d0dc", x"16094190", x"3ecf53e8", x"374dd378", x"1f87f204", 
 x"344d1348", x"3ecfb3ec", x"304b72f4", x"0e4a41e0", x"084c11f8", x"098be200", x"098be200", x"09cbe200", x"09cbd1f8", x"09cbc1f4", x"09cbb1f0", x"0a0b91e8", x"0a0b81e0", x"0a4b71dc", x"0a4b51d4", x"0a4b41cc", x"0a8b21c8", x"0a8b11c4", x"0a8ae1b4", x"0a8a91a0", x"0a8a418c", x"0a8a0178", x"0a89b164", x"0a896150", x"0a89113c", x"0a88c128", x"0a887114", x"0747b0d0", x"1a09e1d0", x"3fcfd3fc", x"354d5358", x"1d8771e4", 
 x"32ccb330", x"3d0f43d4", x"360cc348", x"1289c1e8", x"078c01f0", x"09cbd1f8", x"09cbd1f8", x"09cbd1f8", x"09cbc1f4", x"09cbb1f0", x"0a0ba1ec", x"0a0b91e8", x"0a0b81e0", x"0a4b61d8", x"0a4b51d4", x"0a8b41cc", x"0a8b21c8", x"0a8b11c0", x"0a8ad1b0", x"0a8a819c", x"0a8a318c", x"0a89f174", x"0a89a160", x"0a89514c", x"0a89113c", x"0a88c124", x"0a887114", x"068790c0", x"218ae23c", x"3fcff3fc", x"310c5314", x"1a86b1b8", 
 x"30cc4314", x"39ce73a0", x"3c4e73b0", x"1a898214", x"078be1e8", x"09cbb1f0", x"09cbc1f4", x"09cbb1f0", x"09cbb1f0", x"0a0ba1ec", x"0a0b91e8", x"0a0b81e0", x"0a4b71dc", x"0a4b61d8", x"0a4b51d0", x"0a8b31cc", x"0a8b21c4", x"0a8b01bc", x"0a8ac1ac", x"0a8a7198", x"0a8a2184", x"0a89e170", x"0a89915c", x"0a894148", x"0a890138", x"0a88b124", x"0a88610c", x"07c7a0d0", x"2d8ca2e8", x"3fcff3fc", x"2acac2b4", x"1785f188", 
 x"2d8b62dc", x"358d6358", x"3fcfd3f8", x"270a2284", x"0a8b41e0", x"094bb1e8", x"0a0ba1ec", x"0a0ba1ec", x"0a0ba1e8", x"0a0b91e4", x"0a0b81e4", x"0a4b71dc", x"0a4b61d8", x"0a4b51d4", x"0a4b41cc", x"0a8b31c8", x"0a8b11c4", x"0a8af1b8", x"0a8aa1a4", x"0a8a5190", x"0a8a1180", x"0a89d16c", x"0a898158", x"0a893144", x"0a88f134", x"0a88a120", x"08c810f0", x"0f48a13c", x"3aceb3ac", x"3ecfa3ec", x"2348e240", x"0cc360f0", 
 x"40000000", x"314c5318", x"3dcf73dc", x"354c9340", x"140a11f8", x"074bc1d8", x"0a0b91e4", x"0a0b91e4", x"0a0b81e4", x"0a0b81e0", x"0a4b71dc", x"0a4b61d8", x"0a4b51d4", x"0a4b41d0", x"0a8b31c8", x"0a8b21c4", x"0a8b01bc", x"0a8ac1b0", x"0a8a819c", x"0a8a3188", x"0a89f178", x"0a89b164", x"0a896150", x"0a892140", x"0a88d12c", x"0ac8911c", x"05c790c0", x"224b224c", x"3fcff3fc", x"34cd3350", x"1c4711d0", x"40000000", 
 x"40000000", x"2e0b82e8", x"364da368", x"3f4f93ec", x"264a3280", x"0a4b41d8", x"090b91d8", x"0a0b71dc", x"0a4b71dc", x"0a4b61d8", x"0a4b61d8", x"0a4b51d4", x"0a4b41d0", x"0a8b31cc", x"0a8b21c8", x"0a8b11c0", x"0a8af1b8", x"0a8aa1a4", x"0a8a6190", x"0a8a1180", x"0a89d16c", x"0a89915c", x"0a89514c", x"0a890138", x"0a88c128", x"088820f4", x"0e089130", x"398e839c", x"3fcff3fc", x"2749e280", x"1685c178", x"40000000", 
 x"40000000", x"40000000", x"2f4be2fc", x"3ccf43d0", x"390d8378", x"1bca1230", x"074b71c4", x"0a0b61d4", x"0a4b61d4", x"0a4b51d4", x"0a4b51d0", x"0a4b41cc", x"0a8b31cc", x"0a8b21c8", x"0a8b21c0", x"0a8af1b8", x"0a8ab1a8", x"0a8a7198", x"0a8a3188", x"0a89f178", x"0a89b164", x"0a897154", x"0a893144", x"0a88e130", x"0a088114", x"0687c0d0", x"2c0c92dc", x"3fcff3fc", x"350d4350", x"1b8701c8", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"2b8af2c0", x"320c8324", x"3fcff3fc", x"338c3328", x"168a8214", x"06cb51b8", x"0a0b41d0", x"0a8b41cc", x"0a8b31cc", x"0a8b31c8", x"0a8b21c4", x"0a8b11c0", x"0a8af1b8", x"0a8ac1ac", x"0a8a819c", x"0a8a418c", x"0a8a017c", x"0a89c16c", x"0a89815c", x"0a894148", x"0a890138", x"0a08a120", x"0587c0cc", x"22cb725c", x"3fcff3fc", x"3e0f83e0", x"2248a230", x"1645a174", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"2b4ae2bc", x"34cd334c", x"3fcff3fc", x"32cc131c", x"17cab220", x"070b21ac", x"094b21bc", x"0acb21c4", x"0a8b11c4", x"0a8b11c0", x"0a8af1b8", x"0a8ac1a8", x"0a8a819c", x"0a8a518c", x"0a8a1180", x"0a89d170", x"0a89a160", x"0a896150", x"0ac92144", x"0888a114", x"064800e4", x"228b725c", x"3fcfb3fc", x"3fcff3fc", x"284a2290", x"18061190", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"2acac2b4", x"354d6358", x"3fcff3fc", x"364ce350", x"1f8af264", x"0b4af1c0", x"06caf19c", x"098ae1b0", x"0a8ad1b0", x"0a8ab1a4", x"0a8a7198", x"0a8a418c", x"0a8a1180", x"0a89e170", x"0a89a164", x"0a896154", x"09090130", x"05c850f4", x"0d090148", x"2b4ca2d8", x"3fcfe3fc", x"3fcff3fc", x"2b0ad2b8", x"194671a4", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"294a629c", x"330cc334", x"3fcff3fc", x"3d0e93bc", x"2dcc02f4", x"1a0b2238", x"0c4aa1b4", x"074a517c", x"070a216c", x"07ca0168", x"0809d160", x"0809a154", x"0789613c", x"06890124", x"0708d118", x"0dc95160", x"208b524c", x"38ce7394", x"3fcff3fc", x"3ecfb3ec", x"288a3294", x"19c681ac", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"2749d27c", x"2d8b72e0", x"3b4ee3b8", x"3fcff3fc", x"3d0e93bc", x"324ce334", x"260be2ac", x"1c0b323c", x"160ac1f8", x"144a81dc", x"148a71d4", x"174a91ec", x"1f0b5248", x"2b4ca2e0", x"39ce93a0", x"3fcff3fc", x"3fcff3fc", x"36cdc370", x"22c8c238", x"18863198", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"24893254", x"27c9f284", x"2fcbf300", x"3a8ea3a8", x"3fcff3fc", x"3fcff3fc", x"3fcf83f4", x"3e4f03d4", x"3d4ee3c8", x"3e0f13d4", x"3f8f93f4", x"3fcff3fc", x"3fcff3fc", x"3f8fe3f8", x"370dc374", x"288a2290", x"1cc741d8", x"1685c178", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"2288a230", x"25896260", x"2a8ab2b0", x"304c230c", x"354d5358", x"384e1384", x"39ce639c", x"398e5398", x"374dd378", x"334cd338", x"2ccb42d4", x"25094258", x"1d4761e4", x"17860188", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", 
 x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"1c4731d4", x"1e87b1f8", x"20883214", x"21486220", x"20883214", x"1fc80208", x"1f07d1fc", x"1c8731d4", x"18c6419c", x"1384f148", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000", x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"358d535c",x"358d635c",x"358d735c",x"358d635c",x"354d5358",x"348d234c",x"334cd338",x"318c6320",x"2f8be300",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"378de378",x"37ce0380",x"394e5398",x"3bcee3bc",x"3dcf73dc",x"3ecfb3ec",x"3f0fc3f0",x"3ecfb3ec",x"3dcf83e0",x"3bcef3bc",x"380e1384",x"33ccf340",x"2fcbf300",x"2ccb42d4",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"384e1388",x"38ce3390",x"3b4ee3b8",x"3f8fe3f8",x"3fcff3fc",x"3c4ef3cc",x"360d5374",x"314c2324",x"2ecb92fc",x"2f8bb304",x"330ca340",x"38ce0398",x"3e0f63e8",x"3fcff3fc",x"3c8f23c8",x"340d1344",x"2dcb72e4",x"2a4a92b0",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"38ce338c",x"3a8ea3a8",x"3f4fe3f8",x"3f0fb3f4",x"328c733c",x"1f062244",x"1883717c",x"1c027100",x"1f41e0c4",x"2081b0b0",x"1f41e0c4",x"1b0250f8",x"16c3415c",x"188551fc",x"2a0a82a8",x"38ce039c",x"3fcff3fc",x"3b4ed3b8",x"2fcbf300",x"2a0a82a8",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3c0f03c0",x"3fcff3fc",x"354d3364",x"1a44e200",x"1c0220e0",x"2141a0b0",x"2501d0c4",x"27c200d0",x"2a0210dc",x"2a8220e0",x"2a0210dc",x"284200d4",x"2501d0c4",x"2201b0b4",x"1c0220e0",x"144431a0",x"298a629c",x"3c0ee3cc",x"3fcff3fc",x"320c8324",x"294a529c",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3ccf33cc",x"3fcff3fc",x"2a0992c4",x"1882c128",x"2141a0b0",x"284200d4",x"31827104",x"34c2a118",x"34029110",x"32428108",x"31027104",x"30426100",x"30426100",x"2f8260f8",x"2e4250f4",x"2a0210dc",x"22c1c0b8",x"16028108",x"1c4721f0",x"36cd8380",x"3fcff3fc",x"324ca328",x"27ca0284",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"38ce4390",x"3c4f13c4",x"3fcff3fc",x"24c8328c",x"1b4220e0",x"2441d0c0",x"31827104",x"3502d120",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31827104",x"30426100",x"2f8260f8",x"2e8250f4",x"2d4240f0",x"2c0230e8",x"2d4240f0",x"27c200d0",x"1a8220dc",x"1685e1a8",x"358d3368",x"3fcff3fc",x"2fcc0304",x"25897264",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"388e238c",x"3acea3ac",x"3fcff3fc",x"2949b2b8",x"1b0230e8",x"2781f0d0",x"3502d120",x"34c2a118",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31027104",x"30426100",x"2f0250f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"1ac230e8",x"1946c190",x"388df398",x"3ecfb3ec",x"2b0ad2b8",x"23890244",x"40000000",x"40000000",
x"40000000",x"40000000",x"394e5394",x"3fcff3fc",x"338cc34c",x"16c2e138",x"2701f0cc",x"3543012c",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2dc240f0",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"1502c11c",x"22c90200",x"3e4f73f0",x"37ce0380",x"25496260",x"40000000",x"40000000",
x"40000000",x"37cde380",x"3bcf03c0",x"3e4f83e8",x"1804f1f8",x"23c1c0bc",x"3502d120",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2f0250f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a8220e0",x"27c200d0",x"0ec4014c",x"30cc1308",x"3fcff3fc",x"2ccb42d4",x"20883218",x"40000000",
x"40000000",x"384e2388",x"3fcff3fc",x"304bd310",x"1a428104",x"30426100",x"3543012c",x"34c2a118",x"34c2a118",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2d4240f0",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"2a0210dc",x"1c42b11c",x"1cc82190",x"3e4f63f0",x"370dc374",x"2348e240",x"40000000",
x"360d8368",x"39ce83a0",x"3fcff3fc",x"1c060228",x"2781f0d0",x"35833138",x"3502b11c",x"3502b11c",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2e8250f4",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"284200d4",x"0f450164",x"350d0344",x"3ecfb3ec",x"280a1288",x"40000000",
x"364d9368",x"3c8f23c8",x"3a8e73b0",x"16c3c198",x"30426100",x"3543012c",x"3502d120",x"3502d120",x"3502b11c",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2f0250f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"2a0210dc",x"14c3d17c",x"28caa26c",x"3fcff3fc",x"2d8b72e0",x"1cc741dc",
x"364da368",x"3e8fa3e8",x"340c7338",x"1d831148",x"3542e124",x"3502d120",x"3502d120",x"3502d120",x"3502d120",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32c2810c",x"32428108",x"31027104",x"2f8260f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"290210d8",x"1cc2f140",x"1ec941d0",x"3fcff3fc",x"328ca32c",x"1e4791f0",
x"364d9368",x"3f8fe3f8",x"2ecb02d4",x"2602a110",x"35833138",x"3542e124",x"3543012c",x"3542e124",x"3502d120",x"3502d120",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"33829110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"290210d8",x"234260fc",x"1848d184",x"3f8f73f4",x"360d8364",x"1f87f204",
x"35cd7360",x"3fcff3fc",x"2cca92b4",x"2e4250f4",x"35833138",x"3543012c",x"3543012c",x"3543012c",x"3502d120",x"3502d120",x"3502b11c",x"3502b11c",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2cc240ec",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"290210d8",x"2781f0d0",x"1588e178",x"3e4f33dc",x"378de378",x"2008120c",
x"350d5354",x"3f8fe3f8",x"2d4ae2c8",x"3082910c",x"3543012c",x"3543012c",x"3543012c",x"3543012c",x"3502d120",x"3502d120",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"33829110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"290210d8",x"268200d4",x"16094190",x"3ecf53e8",x"374dd378",x"1f87f204",
x"344d1348",x"3ecfb3ec",x"304b72f4",x"2cc30138",x"3543012c",x"3502d120",x"3502d120",x"3502d120",x"3502d120",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32c2810c",x"32428108",x"31027104",x"2f8260f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"28c200d8",x"230260fc",x"1a09e1d0",x"3fcfd3fc",x"354d5358",x"1d8771e4",
x"32ccb330",x"3d0f43d4",x"360cc348",x"2603d188",x"3542e124",x"3502d120",x"3502d120",x"3502d120",x"3502b11c",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2f8260f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"28c200d8",x"1cc2f140",x"218ae23c",x"3fcff3fc",x"310c5314",x"1a86b1b8",
x"30cc4314",x"39ce73a0",x"3c4e73b0",x"20c52200",x"3502b11c",x"3502b11c",x"3502b11c",x"3502b11c",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2e8250f4",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"28c200d8",x"16040198",x"2d8ca2e8",x"3fcff3fc",x"2acac2b4",x"1785f188",
x"2d8b62dc",x"358d6358",x"3fcfd3f8",x"2587e284",x"33829110",x"34c2a118",x"3502b11c",x"3502b11c",x"34c2a118",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"32c2810c",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2dc240f0",x"2b8230e4",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"27c200d0",x"138651d0",x"3aceb3ac",x"3ecfa3ec",x"2348e240",x"0cc360f0",
x"40000000",x"314c5318",x"3dcf73dc",x"354c9340",x"2843b178",x"3502b11c",x"34c2a118",x"34c2a118",x"34c2a118",x"34c2a118",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"31827104",x"30426100",x"2f0250f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"290210d8",x"1dc2d12c",x"224b224c",x"3fcff3fc",x"34cd3350",x"1c4711d0",x"40000000",
x"40000000",x"2e0b82e8",x"364da368",x"3f4f93ec",x"25872268",x"3302910c",x"34c2a118",x"34029110",x"34029110",x"34029110",x"34029110",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31027104",x"30426100",x"2e8250f4",x"2dc240f0",x"2c0230e8",x"2b4220e4",x"2a8220e0",x"2a0210dc",x"27c200d0",x"14c571dc",x"398e839c",x"3fcff3fc",x"2749e280",x"1685c178",x"40000000",
x"40000000",x"40000000",x"2f4be2fc",x"3ccf43d0",x"390d8378",x"2744a1cc",x"33829110",x"33829110",x"33829110",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32c2810c",x"32428108",x"31027104",x"30426100",x"2f0250f8",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"2a0210dc",x"28c200d8",x"1a83616c",x"2c0c92dc",x"3fcff3fc",x"350d4350",x"1b8701c8",x"40000000",x"40000000",
x"40000000",x"40000000",x"2b8af2c0",x"320c8324",x"3fcff3fc",x"324b9320",x"2cc39168",x"32c2810c",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"3302910c",x"32428108",x"32428108",x"31827104",x"30426100",x"2f8260f8",x"2e8250f4",x"2d4240f0",x"2b8230e4",x"2b4220e4",x"2a8220e0",x"290210d8",x"2042a11c",x"238a9270",x"3fcff3fc",x"3e0f83e0",x"2248a230",x"1645a174",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"2b4ae2bc",x"34cd334c",x"3fcff3fc",x"308a9300",x"2e839164",x"32428108",x"32428108",x"3302910c",x"32c2810c",x"32428108",x"32428108",x"31827104",x"30426100",x"30426100",x"2e8250f4",x"2dc240f0",x"2c0230e8",x"2b4220e4",x"2b4220e4",x"290210d8",x"2202a118",x"24c9827c",x"3fcfb3fc",x"3fcff3fc",x"284a2290",x"18061190",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"2acac2b4",x"354d6358",x"3fcff3fc",x"34cc033c",x"2cc4b1c0",x"32428108",x"31027104",x"31827104",x"31827104",x"31027104",x"30426100",x"2f8260f8",x"2e8250f4",x"2e4250f4",x"2c0230e8",x"2b4220e4",x"2a0210dc",x"284200d4",x"1fc39184",x"2bcb92dc",x"3fcfe3fc",x"3fcff3fc",x"2b0ad2b8",x"194671a4",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"294a629c",x"330cc334",x"3fcff3fc",x"3d0e93bc",x"2dc86298",x"30c3a168",x"31027104",x"2f8260f8",x"2e4250f4",x"2e4250f4",x"2cc240ec",x"2c0230e8",x"2b4220e4",x"2a0210dc",x"2a0210dc",x"2602e130",x"2747124c",x"38ce7394",x"3fcff3fc",x"3ecfb3ec",x"288a3294",x"19c681ac",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2749d27c",x"2d8b72e0",x"3b4ee3b8",x"3fcff3fc",x"3d0e93bc",x"314a22e4",x"2e067224",x"3004118c",x"3142f12c",x"3182910c",x"2f42d124",x"2bc3b174",x"2b0591fc",x"2d8992bc",x"39ce93a0",x"3fcff3fc",x"3fcff3fc",x"36cdc370",x"22c8c238",x"18863198",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"24893254",x"27c9f284",x"2fcbf300",x"3a8ea3a8",x"3fcff3fc",x"3fcff3fc",x"3fcf83f4",x"3e4f03d4",x"3d4ee3c8",x"3e0f13d4",x"3f8f93f4",x"3fcff3fc",x"3fcff3fc",x"3f8fe3f8",x"370dc374",x"288a2290",x"1cc741d8",x"1685c178",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2288a230",x"25896260",x"2a8ab2b0",x"304c230c",x"354d5358",x"384e1384",x"39ce639c",x"398e5398",x"374dd378",x"334cd338",x"2ccb42d4",x"25094258",x"1d4761e4",x"17860188",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"1c4731d4",x"1e87b1f8",x"20883214",x"21486220",x"20883214",x"1fc80208",x"1f07d1fc",x"1c8731d4",x"18c6419c",x"1384f148",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"358d535c",x"358d635c",x"358d735c",x"358d635c",x"354d5358",x"348d234c",x"334cd338",x"318c6320",x"2f8be300",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"378de378",x"37ce0380",x"394e5398",x"3bcee3bc",x"3dcf73dc",x"3ecfb3ec",x"3f0fc3f0",x"3ecfb3ec",x"3dcf83e0",x"3bcef3bc",x"380e1384",x"33ccf340",x"2fcbf300",x"2ccb42d4",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"384e1388",x"38ce3390",x"3b4ee3b8",x"3f8fe3f8",x"3fcff3fc",x"3c4ef3cc",x"360d5374",x"314c2324",x"2ecb92fc",x"2f8bb304",x"330ca340",x"38ce0398",x"3e0f63e8",x"3fcff3fc",x"3c8f23c8",x"340d1344",x"2dcb72e4",x"2a4a92b0",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"38ce338c",x"3a8ea3a8",x"3f4fe3f8",x"3f0fb3f4",x"328c733c",x"198812ec",x"098652bc",x"06c62284",x"0646627c",x"06467278",x"06465274",x"0685f278",x"08c5f280",x"1306f290",x"2a0a82a8",x"38ce039c",x"3fcff3fc",x"3b4ed3b8",x"2fcbf300",x"2a0a82a8",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3c0f03c0",x"3fcff3fc",x"354d3364",x"11c712e0",x"06060270",x"06468278",x"06c732c0",x"0787c2f4",x"07c83320",x"07c84328",x"07c83320",x"0787d2fc",x"070742c4",x"0646b290",x"0606026c",x"0c461254",x"298a629c",x"3c0ee3cc",x"3fcff3fc",x"320c8324",x"294a529c",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3ccf33cc",x"3fcff3fc",x"28ca62f4",x"0745e27c",x"06468278",x"0787d2fc",x"0e09b37c",x"138a638c",x"124a3388",x"0fc9e380",x"0d89a37c",x"0c497378",x"0bc96378",x"0b094374",x"0888f36c",x"07c82318",x"0686e2a4",x"06457234",x"1b47b214",x"36cd8380",x"3fcff3fc",x"324ca328",x"27ca0284",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"38ce4390",x"3c4f13c4",x"3fcff3fc",x"22c952dc",x"0605f26c",x"06c722b8",x"0e89b37c",x"154a9390",x"110a1384",x"110a1384",x"0fc9e380",x"0fc9e380",x"0e09b37c",x"0c497378",x"0b094374",x"09491370",x"0888d35c",x"08489348",x"0888d35c",x"0787c2f4",x"0605d258",x"1486c1dc",x"358d3368",x"3fcff3fc",x"2fcc0304",x"25897264",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"388e238c",x"3acea3ac",x"3fcff3fc",x"288a42d8",x"0645e264",x"0747a2e8",x"154a9390",x"134a5388",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0fc9e380",x"0d89a37c",x"0c497378",x"0a093374",x"0888f36c",x"08489348",x"08086334",x"08086334",x"07c83320",x"0605e264",x"188721a0",x"388df398",x"3ecfb3ec",x"2b0ad2b8",x"23890244",x"40000000",x"40000000",
x"40000000",x"40000000",x"394e5394",x"3fcff3fc",x"338cc34c",x"07c5b26c",x"074792e0",x"168ac394",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0f49d380",x"0d89a37c",x"0bc96378",x"09c92370",x"0888e364",x"08489348",x"0808532c",x"0808532c",x"07c82318",x"06058234",x"22c90200",x"3e4f73f0",x"37ce0380",x"25496260",x"40000000",x"40000000",
x"40000000",x"37cde380",x"3bcf03c0",x"3e4f83e8",x"1246a2a0",x"06c712b0",x"154a9390",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"0a093374",x"0888f36c",x"08489348",x"08086334",x"07c84328",x"07c84328",x"0787c2f4",x"08c561b4",x"30cc1308",x"3fcff3fc",x"2ccb42d4",x"20883218",x"40000000",
x"40000000",x"384e2388",x"3fcff3fc",x"304bd310",x"06c60278",x"0c497378",x"168ac394",x"138a638c",x"134a5388",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09c92370",x"0888d35c",x"08086334",x"0808532c",x"07c83320",x"07c83320",x"06c682b0",x"1cc82190",x"3e4f63f0",x"370dc374",x"2348e240",x"40000000",
x"360d8368",x"39ce83a0",x"3fcff3fc",x"18c75298",x"0747a2e8",x"180af394",x"148a838c",x"148a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"09c92370",x"0888f36c",x"08489348",x"0808532c",x"07c84328",x"07c82318",x"0787d2fc",x"0b0621a4",x"350d0344",x"3ecfb3ec",x"280a1288",x"40000000",
x"364d9368",x"3c8f23c8",x"3a8e73b0",x"0a8632a0",x"0c497378",x"168ac394",x"150a838c",x"150a838c",x"148a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"0a093374",x"0888f36c",x"08489348",x"0808532c",x"07c84328",x"07c82318",x"07c82318",x"0746426c",x"28caa26c",x"3fcff3fc",x"2d8b72e0",x"1cc741dc",
x"364da368",x"3e8fa3e8",x"340c7338",x"0806e2f0",x"164ab390",x"154a9390",x"154a9390",x"154a9390",x"150a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"108a0384",x"0f49d380",x"0d09937c",x"0b094374",x"08c90370",x"08489348",x"08086334",x"07c84328",x"07c82318",x"07c80310",x"0746c2d8",x"1ec941d0",x"3fcff3fc",x"328ca32c",x"1e4791f0",
x"364d9368",x"3f8fe3f8",x"2ecb02d4",x"0807d330",x"180af394",x"164ab390",x"168ac394",x"164ab390",x"154a9390",x"150a838c",x"148a838c",x"138a638c",x"134a5388",x"124a3388",x"118a2384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09491370",x"08489348",x"08086334",x"0808532c",x"07c82318",x"07c80310",x"078742f4",x"1848d184",x"3f8f73f4",x"360d8364",x"1f87f204",
x"35cd7360",x"3fcff3fc",x"2cca92b4",x"0888f36c",x"180af394",x"168ac394",x"168ac394",x"168ac394",x"154a9390",x"150a838c",x"148a838c",x"148a838c",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09491370",x"0848b350",x"08086334",x"0808532c",x"07c82318",x"07c80310",x"0747b2f0",x"1588e178",x"3e4f33dc",x"378de378",x"2008120c",
x"350d5354",x"3f8fe3f8",x"2d4ae2c8",x"0d89937c",x"168ac394",x"168ac394",x"168ac394",x"168ac394",x"154a9390",x"150a838c",x"148a838c",x"138a638c",x"134a5388",x"124a3388",x"118a2384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09491370",x"08489348",x"08086334",x"0808532c",x"07c82318",x"07c80310",x"074792f0",x"16094190",x"3ecf53e8",x"374dd378",x"1f87f204",
x"344d1348",x"3ecfb3ec",x"304b72f4",x"0ec9437c",x"168ac394",x"154a9390",x"154a9390",x"154a9390",x"150a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"108a0384",x"0f49d380",x"0d09937c",x"0b094374",x"08c90370",x"08489348",x"08086334",x"07c84328",x"07c82318",x"0787f30c",x"074732ec",x"1a09e1d0",x"3fcfd3fc",x"354d5358",x"1d8771e4",
x"32ccb330",x"3d0f43d4",x"360cc348",x"0f48a368",x"164ab390",x"150a838c",x"150a838c",x"150a838c",x"148a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"0a894374",x"0888f36c",x"08489348",x"0808532c",x"07c84328",x"07c82318",x"0787f30c",x"0746c2d8",x"218ae23c",x"3fcff3fc",x"310c5314",x"1a86b1b8",
x"30cc4314",x"39ce73a0",x"3c4e73b0",x"13888338",x"148a838c",x"148a838c",x"148a838c",x"148a838c",x"148a838c",x"148a838c",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"09c92370",x"0888f36c",x"08489348",x"0808532c",x"07c84328",x"07c82318",x"0787e304",x"0786b2a0",x"2d8ca2e8",x"3fcff3fc",x"2acac2b4",x"1785f188",
x"2d8b62dc",x"358d6358",x"3fcfd3f8",x"21c9a2fc",x"118a2384",x"138a638c",x"148a838c",x"148a838c",x"138a638c",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"108a0384",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09c92370",x"0888e364",x"0808733c",x"0808532c",x"07c84328",x"07c82318",x"0787c2f4",x"0e07b224",x"3aceb3ac",x"3ecfa3ec",x"2348e240",x"0cc360f0",
x"40000000",x"314c5318",x"3dcf73dc",x"354c9340",x"10890374",x"148a838c",x"134a5388",x"134a5388",x"134a5388",x"134a5388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0e09b37c",x"0c497378",x"0a093374",x"0888f36c",x"08489348",x"08086334",x"0808532c",x"07c82318",x"07c80310",x"0746d2dc",x"224b224c",x"3fcff3fc",x"34cd3350",x"1c4711d0",x"40000000",
x"40000000",x"2e0b82e8",x"364da368",x"3f4f93ec",x"1f49a324",x"110a1384",x"134a5388",x"124a3388",x"124a3388",x"124a3388",x"124a3388",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0fc9e380",x"0d89a37c",x"0bc96378",x"09c92370",x"0888e364",x"08489348",x"0808532c",x"07c84328",x"07c82318",x"0787c2f4",x"0c476270",x"398e839c",x"3fcff3fc",x"2749e280",x"1685c178",x"40000000",
x"40000000",x"40000000",x"2f4be2fc",x"3ccf43d0",x"390d8378",x"15493368",x"118a2384",x"118a2384",x"118a2384",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"108a0384",x"0fc9e380",x"0d89a37c",x"0c497378",x"0a093374",x"0888f36c",x"08489348",x"08086334",x"0808532c",x"07c83320",x"0787f30c",x"0786c2d0",x"2c0c92dc",x"3fcff3fc",x"350d4350",x"1b8701c8",x"40000000",x"40000000",
x"40000000",x"40000000",x"2b8af2c0",x"320c8324",x"3fcff3fc",x"320c2340",x"13499380",x"108a0384",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"110a1384",x"0fc9e380",x"0fc9e380",x"0e09b37c",x"0c497378",x"0b094374",x"09491370",x"0888d35c",x"0808733c",x"0808532c",x"07c84328",x"07c80310",x"074712ec",x"224b328c",x"3fcff3fc",x"3e0f83e0",x"2248a230",x"1645a174",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"2b4ae2bc",x"34cd334c",x"3fcff3fc",x"2f8bd350",x"1409d388",x"0fc9e380",x"0fc9e380",x"110a1384",x"108a0384",x"0fc9e380",x"0fc9e380",x"0e09b37c",x"0c497378",x"0bc96378",x"09c92370",x"0888e364",x"08489348",x"08086334",x"0808532c",x"07c80310",x"078742fc",x"218ae2c4",x"3fcfb3fc",x"3fcff3fc",x"284a2290",x"18061190",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"2acac2b4",x"354d6358",x"3fcff3fc",x"348cc368",x"1a0a2380",x"0fc9e380",x"0d89a37c",x"0e09b37c",x"0e09b37c",x"0d89a37c",x"0c497378",x"0b094374",x"09c92370",x"0888f36c",x"08489348",x"08086334",x"07c83320",x"0787d2fc",x"08c79340",x"2a8c6304",x"3fcfe3fc",x"3fcff3fc",x"2b0ad2b8",x"194671a4",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"294a629c",x"330cc334",x"3fcff3fc",x"3d0e93bc",x"280b8378",x"16ca3390",x"0d89a37c",x"0a894374",x"08c90370",x"0888f36c",x"0848b350",x"08489348",x"0808532c",x"07c82318",x"07c82318",x"08480354",x"1e4a5330",x"38ce7394",x"3fcff3fc",x"3ecfb3ec",x"288a3294",x"19c681ac",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2749d27c",x"2d8b72e0",x"3b4ee3b8",x"3fcff3fc",x"3d0e93bc",x"2e8c9384",x"218b1388",x"18ca5390",x"1249f388",x"0f49c380",x"0ec98380",x"12c9737c",x"1bca3370",x"294c1358",x"39ce93a0",x"3fcff3fc",x"3fcff3fc",x"36cdc370",x"22c8c238",x"18863198",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"24893254",x"27c9f284",x"2fcbf300",x"3a8ea3a8",x"3fcff3fc",x"3fcff3fc",x"3fcf83f4",x"3e4f03d4",x"3d4ee3c8",x"3e0f13d4",x"3f8f93f4",x"3fcff3fc",x"3fcff3fc",x"3f8fe3f8",x"370dc374",x"288a2290",x"1cc741d8",x"1685c178",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2288a230",x"25896260",x"2a8ab2b0",x"304c230c",x"354d5358",x"384e1384",x"39ce639c",x"398e5398",x"374dd378",x"334cd338",x"2ccb42d4",x"25094258",x"1d4761e4",x"17860188",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"1c4731d4",x"1e87b1f8",x"20883214",x"21486220",x"20883214",x"1fc80208",x"1f07d1fc",x"1c8731d4",x"18c6419c",x"1384f148",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"358d535c",x"358d635c",x"358d735c",x"358d635c",x"354d5358",x"348d234c",x"334cd338",x"318c6320",x"2f8be300",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"378de378",x"37ce0380",x"394e5398",x"3bcee3bc",x"3dcf73dc",x"3ecfb3ec",x"3f0fc3f0",x"3ecfb3ec",x"3dcf83e0",x"3bcef3bc",x"380e1384",x"33ccf340",x"2fcbf300",x"2ccb42d4",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"384e1388",x"38ce3390",x"3b4ee3b8",x"3f8fe3f8",x"3fcff3fc",x"3c4ef3cc",x"360d5374",x"314c2324",x"2ecb92fc",x"2f8bb304",x"330ca340",x"38ce0398",x"3e0f63e8",x"3fcff3fc",x"3c8f23c8",x"340d1344",x"2dcb72e4",x"2a4a92b0",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"38ce338c",x"3a8ea3a8",x"3f4fe3f8",x"3f0fb3f4",x"328c733c",x"1bc6e2a0",x"0c833210",x"0681c1b4",x"044121b8",x"03c0f1b4",x"044121b0",x"0601b1a4",x"0ac301bc",x"15c5a220",x"2a0a82a8",x"38ce039c",x"3fcff3fc",x"3b4ed3b8",x"2fcbf300",x"2a0a82a8",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3c0f03c0",x"3fcff3fc",x"354d3364",x"14c53274",x"0541719c",x"03c0f1b0",x"05415258",x"0681a2ec",x"0741d340",x"0781e35c",x"0741d340",x"0681a2f4",x"0581627c",x"044111e8",x"04c1717c",x"0f0441a8",x"298a629c",x"3c0ee3cc",x"3fcff3fc",x"320c8324",x"294a529c",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3ccf33cc",x"3fcff3fc",x"298a32e0",x"084231b4",x"03c0f1b0",x"0681a2fc",x"10c43390",x"1605839c",x"14c53398",x"12048394",x"10441390",x"0f03c38c",x"0e03838c",x"0dc37388",x"0b02c384",x"0701c32c",x"04812214",x"0582013c",x"1c0761e8",x"36cd8380",x"3fcff3fc",x"324ca328",x"27ca0284",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"38ce4390",x"3c4f13c4",x"3fcff3fc",x"2408e2b4",x"05417184",x"05014254",x"11445390",x"17c5f3a0",x"13c4f398",x"1344d398",x"1284a394",x"12048394",x"10c43390",x"0e83a38c",x"0dc37388",x"0c030384",x"0a429380",x"09425380",x"0a429380",x"0681a2e4",x"0401715c",x"1606318c",x"358d3368",x"3fcff3fc",x"2fcc0304",x"25897264",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"388e238c",x"3acea3ac",x"3fcff3fc",x"290a22c8",x"05818180",x"060182bc",x"17c5f3a0",x"1505439c",x"1344d398",x"13c4f398",x"13c4f398",x"1344d398",x"1284a394",x"12048394",x"0fc3f390",x"0e83a38c",x"0cc33388",x"0b02c384",x"09425380",x"0802037c",x"0802037c",x"0741d340",x"0401a170",x"1906f17c",x"388df398",x"3ecfb3ec",x"2b0ad2b8",x"23890244",x"40000000",x"40000000",
x"40000000",x"40000000",x"394e5394",x"3fcff3fc",x"338cc34c",x"090251a4",x"060182ac",x"190643a4",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"1344d398",x"13c4f398",x"1344d398",x"1284a394",x"11846394",x"0fc3f390",x"0e03838c",x"0c431388",x"0a82a384",x"08c23380",x"0781e36c",x"0781e364",x"0741d338",x"04c26134",x"22c90200",x"3e4f73f0",x"37ce0380",x"25496260",x"40000000",x"40000000",
x"40000000",x"37cde380",x"3bcf03c0",x"3e4f83e8",x"15853230",x"04c13238",x"17c5f3a0",x"1685a39c",x"1505439c",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"10c43390",x"0f03c38c",x"0cc33388",x"0b02c384",x"09425380",x"07c1f378",x"0781e358",x"0741d350",x"0681a2ec",x"09841100",x"30cc1308",x"3fcff3fc",x"2ccb42d4",x"20883218",x"40000000",
x"40000000",x"384e2388",x"3fcff3fc",x"304bd310",x"0681e1a8",x"0f03c38c",x"188623a4",x"1605839c",x"1585639c",x"1585639c",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"13c4f398",x"13c4f398",x"1284a394",x"12048394",x"0fc3f390",x"0e03838c",x"0c431388",x"0a429380",x"0802037c",x"0781e36c",x"0741d348",x"0741d348",x"054261f4",x"1cc82190",x"3e4f63f0",x"370dc374",x"2348e240",x"40000000",
x"360d8368",x"39ce83a0",x"3fcff3fc",x"1b06724c",x"064192c8",x"1a4693a8",x"1685a39c",x"1685a39c",x"1685a39c",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"14c53398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"10c43390",x"0e83a38c",x"0c431388",x"0b02c384",x"08c23380",x"0781e36c",x"0741d350",x"0701c334",x"06c1b300",x"0bc5411c",x"350d0344",x"3ecfb3ec",x"280a1288",x"40000000",
x"364d9368",x"3c8f23c8",x"3a8e73b0",x"0d43b1f4",x"0f03c38c",x"190643a4",x"1745d3a0",x"1745d3a0",x"16c5b3a0",x"1685a39c",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"13c4f398",x"13c4f398",x"1344d398",x"1284a394",x"10c43390",x"0f03c38c",x"0cc33388",x"0b02c384",x"09425380",x"0781e374",x"0741d350",x"0701c334",x"0701c32c",x"0683f194",x"28caa26c",x"3fcff3fc",x"2d8b72e0",x"1cc741dc",
x"364da368",x"3e8fa3e8",x"340c7338",x"0882d25c",x"184613a0",x"17c5f3a0",x"17c5f3a0",x"17c5f3a0",x"1745d3a0",x"16c5b3a0",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"13c4f398",x"1344d398",x"1344d398",x"1304c394",x"11846394",x"0f83e38c",x"0dc37388",x"0b82e384",x"09425380",x"07c1f378",x"0781e358",x"0741d338",x"0701c31c",x"0602f224",x"1ec941d0",x"3fcff3fc",x"328ca32c",x"1e4791f0",
x"364d9368",x"3f8fe3f8",x"2ecb02d4",x"07c27314",x"1a0683a4",x"184613a0",x"188623a4",x"184613a0",x"17c5f3a0",x"1745d3a0",x"1685a39c",x"1605839c",x"1585639c",x"14c53398",x"14451398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"0fc3f390",x"0e03838c",x"0c030384",x"09425380",x"07c1f378",x"0781e364",x"0741d338",x"0701c31c",x"06422298",x"1848d184",x"3f8f73f4",x"360d8364",x"1f87f204",
x"35cd7360",x"3fcff3fc",x"2cca92b4",x"0b02c384",x"1a0683a4",x"188623a4",x"190643a4",x"188623a4",x"17c5f3a0",x"1745d3a0",x"1685a39c",x"1685a39c",x"1585639c",x"14c53398",x"14c53398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"0fc3f390",x"0e03838c",x"0c030384",x"09c27380",x"0802037c",x"0781e364",x"0741d338",x"0701c31c",x"064192d0",x"1588e178",x"3e4f33dc",x"378de378",x"2008120c",
x"350d5354",x"3f8fe3f8",x"2d4ae2c8",x"0fc41388",x"190643a4",x"188623a4",x"188623a4",x"188623a4",x"17c5f3a0",x"1745d3a0",x"1685a39c",x"1605839c",x"1585639c",x"14c53398",x"14451398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"0fc3f390",x"0e03838c",x"0c030384",x"09425380",x"07c1f378",x"0781e364",x"0741d338",x"0701c31c",x"0641b2c0",x"16094190",x"3ecf53e8",x"374dd378",x"1f87f204",
x"344d1348",x"3ecfb3ec",x"304b72f4",x"0f849368",x"188623a4",x"17c5f3a0",x"17c5f3a0",x"17c5f3a0",x"1745d3a0",x"16c5b3a0",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"13c4f398",x"1344d398",x"1344d398",x"1304c394",x"11846394",x"0f83e38c",x"0dc37388",x"0b82e384",x"09425380",x"07c1f378",x"0781e358",x"0741d338",x"06c1b318",x"0602128c",x"1a09e1d0",x"3fcfd3fc",x"354d5358",x"1d8771e4",
x"32ccb330",x"3d0f43d4",x"360cc348",x"0f050324",x"184613a0",x"1745d3a0",x"1745d3a0",x"1745d3a0",x"16c5b3a0",x"1685a39c",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"13c4f398",x"13c4f398",x"1344d398",x"1284a394",x"10c43390",x"0f03c38c",x"0d435388",x"0b02c384",x"09425380",x"0781e374",x"0781e358",x"0741d338",x"06c1b318",x"0602f230",x"218ae23c",x"3fcff3fc",x"310c5314",x"1a86b1b8",
x"30cc4314",x"39ce73a0",x"3c4e73b0",x"140662dc",x"16c5b3a0",x"1685a39c",x"16c5b3a0",x"1685a39c",x"1685a39c",x"1685a39c",x"1585639c",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"13c4f398",x"1344d398",x"12048394",x"10c43390",x"0e83a38c",x"0c431388",x"0b02c384",x"08c23380",x"0781e36c",x"0741d350",x"0701c334",x"06c1b310",x"06c461d8",x"2d8ca2e8",x"3fcff3fc",x"2acac2b4",x"1785f188",
x"2d8b62dc",x"358d6358",x"3fcfd3f8",x"230902c8",x"14451398",x"1605839c",x"1685a39c",x"1685a39c",x"1605839c",x"1585639c",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"1344d398",x"13c4f398",x"1304c394",x"12048394",x"0fc3f390",x"0e03838c",x"0c431388",x"0a82a384",x"08421380",x"0781e36c",x"0741d350",x"0701c32c",x"0681a2e4",x"0d4701b4",x"3aceb3ac",x"3ecfa3ec",x"2348e240",x"0cc360f0",
x"40000000",x"314c5318",x"3dcf73dc",x"354c9340",x"10c5333c",x"1685a39c",x"1585639c",x"1585639c",x"1505439c",x"1505439c",x"14c53398",x"14c53398",x"13c4f398",x"1344d398",x"13c4f398",x"1344d398",x"12048394",x"10c43390",x"0f03c38c",x"0cc33388",x"0b02c384",x"09425380",x"07c1f378",x"0781e364",x"0741d338",x"0701c324",x"05c2b244",x"224b224c",x"3fcff3fc",x"34cd3350",x"1c4711d0",x"40000000",
x"40000000",x"2e0b82e8",x"364da368",x"3f4f93ec",x"20c8a2e4",x"13c4f398",x"1585639c",x"14c53398",x"14c53398",x"14c53398",x"14c53398",x"13c4f398",x"1344d398",x"13c4f398",x"1344d398",x"1284a394",x"12048394",x"0fc3f390",x"0e03838c",x"0c431388",x"0a82a384",x"08c23380",x"0781e374",x"0741d350",x"0741d338",x"0681a2e4",x"0b8631e4",x"398e839c",x"3fcff3fc",x"2749e280",x"1685c178",x"40000000",
x"40000000",x"40000000",x"2f4be2fc",x"3ccf43d0",x"390d8378",x"15867320",x"14451398",x"14451398",x"14451398",x"13c4f398",x"13c4f398",x"1344d398",x"13c4f398",x"1344d398",x"1304c394",x"12048394",x"10441390",x"0e83a38c",x"0cc33388",x"0b02c384",x"09425380",x"0802037c",x"0781e36c",x"0741d348",x"06c1b318",x"06439218",x"2c0c92dc",x"3fcff3fc",x"350d4350",x"1b8701c8",x"40000000",x"40000000",
x"40000000",x"40000000",x"2b8af2c0",x"320c8324",x"3fcff3fc",x"328c0334",x"13c5b35c",x"1304c394",x"1344d398",x"13c4f398",x"13c4f398",x"13c4f398",x"1344d398",x"1284a394",x"12048394",x"10c43390",x"0f03c38c",x"0dc37388",x"0c030384",x"0a429380",x"08421380",x"0781e36c",x"0741d350",x"0701c324",x"06028268",x"224b2274",x"3fcff3fc",x"3e0f83e0",x"2248a230",x"1645a174",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"2b4ae2bc",x"34cd334c",x"3fcff3fc",x"308b9338",x"14c5e364",x"12048394",x"1284a394",x"1344d398",x"1304c394",x"1284a394",x"12048394",x"10c43390",x"0f03c38c",x"0e03838c",x"0c431388",x"0a82a384",x"09425380",x"07c1f378",x"0781e364",x"0701c31c",x"06428290",x"214aa294",x"3fcfb3fc",x"3fcff3fc",x"284a2290",x"18061190",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"2acac2b4",x"354d6358",x"3fcff3fc",x"350ca35c",x"1a878348",x"12048394",x"10441390",x"10c43390",x"10c43390",x"10441390",x"0e83a38c",x"0dc37388",x"0c431388",x"0b02c384",x"09425380",x"0802037c",x"0741d348",x"0681a2f4",x"0903e2c4",x"2a8c42f0",x"3fcfe3fc",x"3fcff3fc",x"2b0ad2b8",x"194671a4",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"294a629c",x"330cc334",x"3fcff3fc",x"3d0e93bc",x"294aa348",x"1806a370",x"10441390",x"0d435388",x"0b82e384",x"0b02c384",x"09c27380",x"08c23380",x"0781e36c",x"0741d338",x"0701c32c",x"0882e334",x"1dc952dc",x"38ce7394",x"3fcff3fc",x"3ecfb3ec",x"288a3294",x"19c681ac",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2749d27c",x"2d8b72e0",x"3b4ee3b8",x"3fcff3fc",x"3d0e93bc",x"2f4c1364",x"21c9634c",x"19070364",x"13c54384",x"11847390",x"11048378",x"1345b348",x"1b884320",x"294b9328",x"39ce93a0",x"3fcff3fc",x"3fcff3fc",x"36cdc370",x"22c8c238",x"18863198",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"24893254",x"27c9f284",x"2fcbf300",x"3a8ea3a8",x"3fcff3fc",x"3fcff3fc",x"3fcf83f4",x"3e4f03d4",x"3d4ee3c8",x"3e0f13d4",x"3f8f93f4",x"3fcff3fc",x"3fcff3fc",x"3f8fe3f8",x"370dc374",x"288a2290",x"1cc741d8",x"1685c178",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2288a230",x"25896260",x"2a8ab2b0",x"304c230c",x"354d5358",x"384e1384",x"39ce639c",x"398e5398",x"374dd378",x"334cd338",x"2ccb42d4",x"25094258",x"1d4761e4",x"17860188",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"1c4731d4",x"1e87b1f8",x"20883214",x"21486220",x"20883214",x"1fc80208",x"1f07d1fc",x"1c8731d4",x"18c6419c",x"1384f148",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"358d535c",x"358d635c",x"358d735c",x"358d635c",x"354d5358",x"348d234c",x"334cd338",x"318c6320",x"2f8be300",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"378de378",x"37ce0380",x"394e5398",x"3bcee3bc",x"3dcf73dc",x"3ecfb3ec",x"3f0fc3f0",x"3ecfb3ec",x"3dcf83e0",x"3bcef3bc",x"380e1384",x"33ccf340",x"2fcbf300",x"2ccb42d4",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"384e1388",x"38ce3390",x"3b4ee3b8",x"3f8fe3f8",x"3fcff3fc",x"3c4ef3cc",x"360d5374",x"314c2324",x"2ecb92fc",x"2f8bb304",x"330ca340",x"38ce0398",x"3e0f63e8",x"3fcff3fc",x"3c8f23c8",x"340d1344",x"2dcb72e4",x"2a4a92b0",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"38ce338c",x"3a8ea3a8",x"3f4fe3f8",x"3f0fb3f4",x"328c733c",x"1cc8929c",x"11897284",x"0d8a929c",x"0b0b52b8",x"0a4b82c4",x"0b0b52b8",x"0d8a7298",x"10095278",x"1747f268",x"2a0a82a8",x"38ce039c",x"3fcff3fc",x"3b4ed3b8",x"2fcbf300",x"2a0a82a8",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3c0f03c0",x"3fcff3fc",x"354d3364",x"17487288",x"0c8ac2a0",x"0a0b92c8",x"0a0bd2d4",x"0a4c22e8",x"0a8c32f0",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"0a0bd2d4",x"0a0b92c8",x"0c8ac2a0",x"12080248",x"298a629c",x"3c0ee3cc",x"3fcff3fc",x"320c8324",x"294a529c",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"390e4394",x"3ccf33cc",x"3fcff3fc",x"298a12d8",x"0ec9e288",x"0a0b92c8",x"0a4c22e8",x"0b0cb310",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c32f0",x"0a0bd2d4",x"0dc99268",x"1c07d214",x"36cd8380",x"3fcff3fc",x"324ca328",x"27ca0284",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"38ce4390",x"3c4f13c4",x"3fcff3fc",x"240932b4",x"0ccaa29c",x"0a0bd2d4",x"0b0cb310",x"0bcd2328",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0acc8300",x"0a4c22e8",x"0c8aa29c",x"164721ec",x"358d3368",x"3fcff3fc",x"2fcc0304",x"25897264",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"388e238c",x"3acea3ac",x"3fcff3fc",x"290a02c8",x"0d0a9298",x"0a4c22e8",x"0bcd2328",x"0b8d1324",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acca308",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0cca9298",x"190741b0",x"388df398",x"3ecfb3ec",x"2b0ad2b8",x"23890244",x"40000000",x"40000000",
x"40000000",x"40000000",x"394e5394",x"3fcff3fc",x"338cc34c",x"0ec97274",x"0a4c02e4",x"0ccd232c",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0e496264",x"22c90200",x"3e4f73f0",x"37ce0380",x"25496260",x"40000000",x"40000000",
x"40000000",x"37cde380",x"3bcf03c0",x"3e4f83e8",x"1647e26c",x"0a0bd2d4",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acca308",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c52f4",x"0a4c22e8",x"0e4731f0",x"30cc1308",x"3fcff3fc",x"2ccb42d4",x"20883218",x"40000000",
x"40000000",x"384e2388",x"3fcff3fc",x"304bd310",x"0dca428c",x"0b0cb310",x"0ccd232c",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0e8aa2a8",x"1cc82190",x"3e4f63f0",x"370dc374",x"2348e240",x"40000000",
x"360d8368",x"39ce83a0",x"3fcff3fc",x"1ac7e270",x"0a4c22e8",x"0d8d332c",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"0f8701d4",x"350d0344",x"3ecfb3ec",x"280a1288",x"40000000",
x"364d9368",x"3c8f23c8",x"3a8e73b0",x"1208d270",x"0b0cb310",x"0ccd232c",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acca308",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"1108d264",x"28caa26c",x"3fcff3fc",x"2d8b72e0",x"1cc741dc",
x"364da368",x"3e8fa3e8",x"340c7338",x"100aa2b0",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0f8a92ac",x"1ec941d0",x"3fcff3fc",x"328ca32c",x"1e4791f0",
x"364d9368",x"3f8fe3f8",x"2ecb02d4",x"0d8bc2e0",x"0d8d332c",x"0bcd2328",x"0ccd232c",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0d0b92d0",x"1848d184",x"3f8f73f4",x"360d8364",x"1f87f204",
x"35cd7360",x"3fcff3fc",x"2cca92b4",x"0acc8300",x"0d8d332c",x"0ccd232c",x"0ccd232c",x"0ccd232c",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0a4c22e8",x"1588e178",x"3e4f33dc",x"378de378",x"2008120c",
x"350d5354",x"3f8fe3f8",x"2d4ae2c8",x"0b8cc314",x"0ccd232c",x"0ccd232c",x"0ccd232c",x"0ccd232c",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0acbf2e0",x"16094190",x"3ecf53e8",x"374dd378",x"1f87f204",
x"344d1348",x"3ecfb3ec",x"304b72f4",x"0ecc32f8",x"0ccd232c",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"0d0b92d0",x"1a09e1d0",x"3fcfd3fc",x"354d5358",x"1d8771e4",
x"32ccb330",x"3d0f43d4",x"360cc348",x"148b02cc",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0bcd2328",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"0f8a92ac",x"218ae23c",x"3fcff3fc",x"310c5314",x"1a86b1b8",
x"30cc4314",x"39ce73a0",x"3c4e73b0",x"1a49a2b0",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"1248f274",x"2d8ca2e8",x"3fcff3fc",x"2acac2b4",x"1785f188",
x"2d8b62dc",x"358d6358",x"3fcfd3f8",x"240962bc",x"0b0cf31c",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"1448122c",x"3aceb3ac",x"3ecfa3ec",x"2348e240",x"0cc360f0",
x"40000000",x"314c5318",x"3dcf73dc",x"354c9340",x"140b42d8",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acca308",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0f0ac2b0",x"224b224c",x"3fcff3fc",x"34cd3350",x"1c4711d0",x"40000000",
x"40000000",x"2e0b82e8",x"364da368",x"3f4f93ec",x"224982c0",x"0b0cf31c",x"0b8d1324",x"0b4d0320",x"0b4d0320",x"0b4d0320",x"0b4d0320",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"14884258",x"398e839c",x"3fcff3fc",x"2749e280",x"1685c178",x"40000000",
x"40000000",x"40000000",x"2f4be2fc",x"3ccf43d0",x"390d8378",x"198a92c8",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0acca308",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"1149f298",x"2c0c92dc",x"3fcff3fc",x"350d4350",x"1b8701c8",x"40000000",x"40000000",
x"40000000",x"40000000",x"2b8af2c0",x"320c8324",x"3fcff3fc",x"320bd32c",x"130bc2e8",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0e4b22c0",x"23cae284",x"3fcff3fc",x"3e0f83e0",x"2248a230",x"1645a174",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"2b4ae2bc",x"34cd334c",x"3fcff3fc",x"2f8b431c",x"12cbe2f0",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c52f4",x"0a8c32f0",x"0e4b42c8",x"248a52a8",x"3fcfb3fc",x"3fcff3fc",x"284a2290",x"18061190",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"2acac2b4",x"354d6358",x"3fcff3fc",x"344c5348",x"1a0b02d8",x"0b0cf31c",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c52f4",x"0a8c32f0",x"0a4c22e8",x"12ca82b8",x"2bcbe2f0",x"3fcfe3fc",x"3fcff3fc",x"2b0ad2b8",x"194671a4",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"294a629c",x"330cc334",x"3fcff3fc",x"3d0e93bc",x"28cad2f8",x"134c12f8",x"0b0cb310",x"0b0cb310",x"0acc8300",x"0acc8300",x"0a8c72fc",x"0a8c72fc",x"0a8c52f4",x"0a8c32f0",x"0a8c32f0",x"0ecbb2e0",x"2289f2c4",x"38ce7394",x"3fcff3fc",x"3ecfb3ec",x"288a3294",x"19c681ac",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2749d27c",x"2d8b72e0",x"3b4ee3b8",x"3fcff3fc",x"3d0e93bc",x"2e4b9320",x"21cb02e8",x"164bc2f0",x"0dcca310",x"0b4ce318",x"0d4c9308",x"140ba2e4",x"1e8a92d0",x"2b0b2300",x"39ce93a0",x"3fcff3fc",x"3fcff3fc",x"36cdc370",x"22c8c238",x"18863198",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"24893254",x"27c9f284",x"2fcbf300",x"3a8ea3a8",x"3fcff3fc",x"3fcff3fc",x"3fcf83f4",x"3e4f03d4",x"3d4ee3c8",x"3e0f13d4",x"3f8f93f4",x"3fcff3fc",x"3fcff3fc",x"3f8fe3f8",x"370dc374",x"288a2290",x"1cc741d8",x"1685c178",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"2288a230",x"25896260",x"2a8ab2b0",x"304c230c",x"354d5358",x"384e1384",x"39ce639c",x"398e5398",x"374dd378",x"334cd338",x"2ccb42d4",x"25094258",x"1d4761e4",x"17860188",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",
x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"1c4731d4",x"1e87b1f8",x"20883214",x"21486220",x"20883214",x"1fc80208",x"1f07d1fc",x"1c8731d4",x"18c6419c",x"1384f148",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",x"40000000",others=>x"00000000");



begin

process (Clk)
begin

index<=addrx*32+addry+(8192-(printspritenumber-1)*1024);


if rising_edge(Clk) then
if en = '1' then
data <= ROM1(index);
end if;
end if;
end process;



end imp;