--Pulser generator
--When the input signal switches to 1 
--it generates a pulse

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;



entity pulser is

	port 
	(
		clk		: in std_logic;
		key_in 	: in std_logic;
		key_out : out std_logic;
		reset : in std_logic

	);

end pulser ;


architecture A1 of pulser is
type states is (ZERO, ONE_PULSE, ONE_STANDBY);
signal state, next_state : states;
begin

	--FSM Strandard next_state => state
	process(clk)
	begin
		if(rising_edge(clk)) then 
			if( reset='1' )
				then
					state <= ZERO;
				else
					state <= next_state;
				end if;
		end if;
	end process;
	
	
	--Computation of the next state
	process (state,key_in)
	begin
	next_state <= state;
	case state is
		--State ZERO
		--Signal generated 0
		when ZERO =>
			key_out <= '0';
			if (key_in = '1') 
			then 
				next_state <= ONE_PULSE;
			end if;
		
		--State ONE_PULSE
		--Signal generated 1
		when ONE_PULSE =>
			key_out <= '1';
			next_state <= ONE_STANDBY;
		--State ONE_STANDBY
		--Signal generated: - 
		when ONE_STANDBY =>
			key_out <= '0';
			if (key_in = '0') 
			then 
				next_state <= ZERO;
			end if;
		end case;
	end process;
end A1;
