-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity musicController is
port (
	-- Avalon:
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(1 downto 0);
    readdata   : out unsigned(7 downto 0);
    writedata  : in  unsigned(7 downto 0);
	-- connection to the component inside:
	 irq : 		OUT STD_LOGIC;
	AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
	AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
	AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
	AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
	AUD_BCLK     : inout std_logic ; --    Audio CODEC Bit-Stream Clock
	AUX_XCK     : out std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  musicController;
architecture ar of musicController is
 

 --FSM
 type states is (IDLE,WAITING);
 signal state, next_state : states;
 --Audio Interface
 signal audio_clock : unsigned(1 downto 0) := "00";
 signal indata : unsigned (7 downto 0) ;
signal data_to_music : unsigned (15 downto 0);
signal we,inter:std_logic;
 signal audio_request : std_logic;

	component de2_wm8731_audio is port(
		    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    		reset_n : in std_logic;
		    test_mode : in std_logic;       --    Audio CODEC controller test mode
		    audio_request : out std_logic;  --    Audio controller request new data
		    data : in unsigned(15 downto 0);
  
		    -- Audio interface signals
    		    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
		    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
		    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
		    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
		    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
		 
		
		);
	end component de2_wm8731_audio; 
begin
we      <= '1' when chipselect = '1'and write ='1'  else '0' ;
data_to_music <= indata & x"00"; --Since the audio is on 16 bits, we pad the data with 0s

  V1: de2_wm8731_audio port map (
    clk => audio_clock(1),
    reset_n => '1',
    test_mode => '0',                   -- Don t output a sine wave
    audio_request => audio_request,
    data => data_to_music,
  
    -- Audio interface signals
    AUD_ADCLRCK  => AUD_ADCLRCK,
    AUD_ADCDAT   => AUD_ADCDAT,
    AUD_DACLRCK  => AUD_DACLRCK,
    AUD_DACDAT   => AUD_DACDAT,
    AUD_BCLK     => AUD_BCLK
  );




--Audio clock generation 
process (clk)
begin
  if rising_edge(clk) then
    audio_clock <= audio_clock + "1";
  end if;
end process;

AUX_XCK<=audio_clock(1);


--FSM next state
process(clk)
begin
	if(rising_edge(clk)) then 
		if( reset_n='0' )
		then
			state <= IDLE;
		else
			state <= next_state;				
		end if;
	end if;
end process;


--Combinational process
process (state,we,audio_request)
begin
	--By default reset the interuption signal
	irq <= '0';
	next_state <= state;
	
case state is

	--Waiting for a note request
	when IDLE =>
	indata <=indata;
		irq <='0';
		if (audio_request = '1') 	then 
		next_state <= WAITING;
	end if;


	--A button has been pressed
	when WAITING =>
	irq <='1';
	if (we='1') 
	then 
	indata <=writedata;
	next_state <= IDLE;
	end if;
	end case;
end process;



end architecture;
