-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
--Hex Decoder

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity hex_decoder is

	
	port 
	(
		di: in unsigned(3 downto 0);
		do: out std_logic_vector(6 downto 0)

	);

end hex_decoder;

--Inspired by Stephen A. Edwards' slides
architecture ar1 of hex_decoder is

begin
	with di select do <=
"1000000" when x"0", 
"1111001" when x"1",
"0100100" when x"2", 
"0110000" when x"3",
"0011001" when x"4", 
"0010010" when x"5",
"0000010" when x"6", 
"1111000" when x"7",
"0000000" when x"8", 
"0010000" when x"9",
"0001000" when x"A", 
"0000011" when x"B",
"1000110" when x"C", 
"0100001" when x"D",
"0000110" when x"E", 
"0001110" when x"F",
"XXXXXXX" when others;
	
end ar1;
