-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
--
-- DE2 top-level module
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guitar_top is

  port (
	signal CLOCK_50 : in std_logic; 
	HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7 -- 7-segment displays
       : out std_logic_vector(6 downto 0);         -- (active low)
	SRAM_DQ : inout std_logic_vector(15 downto 0);
	SRAM_ADDR : out std_logic_vector(17 downto 0);
	KEY : in std_logic_vector(3 downto 0);
	
	SRAM_UB_N,
	SRAM_LB_N, 
	SRAM_WE_N, 
	SRAM_CE_N, 
	SRAM_OE_N : out std_logic ;
	-- FLASH
	FL_DQ : inout std_logic_vector(7 downto 0);      -- Data bus
	FL_ADDR : out std_logic_vector(21 downto 0);  -- Address bus
	FL_WE_N,                                         -- Write Enable
	FL_RST_N,                                        -- Reset
	FL_OE_N,                                         -- Output Enable
	FL_CE_N : out std_logic;                         -- Chip Enable
	-- AUDIO
	AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic ;     --    Audio CODEC Bit-Stream Clock
	AUD_XCK  : out std_logic;
    --I2C
	iCLK : in std_logic;
    iRST_N : in std_logic;
    I2C_SCLK : out std_logic;
    I2C_SDAT : inout std_logic;
-- VGA output
    
    VGA_CLK,                            -- Clock
    VGA_HS,                             -- H_SYNC
    VGA_VS,                             -- V_SYNC
    VGA_BLANK,                          -- BLANK
    VGA_SYNC : out std_logic;           -- SYNC
    VGA_R,                              -- Red[9:0]
    VGA_G,                              -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0);   -- Blue[9:0]


	--GPIOS
	GPIO_0,                                      -- GPIO Connection 0
	GPIO_1 : inout std_logic_vector(35 downto 0) -- GPIO Connection 1   
    );
  
end guitar_top;

architecture datapath of guitar_top is

signal reset_n :std_logic;
signal new_res:std_logic;
signal audio_clock : unsigned(1 downto 0) := "00";
signal counter : unsigned(15 downto 0);

--entity
  component de2_i2c_av_config is
  port (
    iCLK : in std_logic;
    iRST_N : in std_logic;
    I2C_SCLK : out std_logic;
    I2C_SDAT : inout std_logic
  );
  end component;
begin

process (CLOCK_50)
begin
if rising_edge(CLOCK_50) then
if counter = x"ffff" then
reset_n <= '1';
else
reset_n <= '0';
counter <= counter + 1;
end if;
end if;
end process;


process (CLOCK_50)
begin
   if rising_edge(CLOCK_50) then
     audio_clock <= audio_clock + "1";
   end if;
end process;

  

  i2c : de2_i2c_av_config port map (
    iCLK     => CLOCK_50,
    iRST_n   => '1',
    I2C_SCLK => I2C_SCLK,
    I2C_SDAT => I2C_SDAT
  );



nios : entity work.nios_system port map (
	clk 											=> CLOCK_50,
	reset_n 										=> reset_n,
	SRAM_ADDR_from_the_sram 						=> SRAM_ADDR,
	SRAM_CE_N_from_the_sram 						=> SRAM_CE_N,
	SRAM_DQ_to_and_from_the_sram 					=> SRAM_DQ,
	SRAM_LB_N_from_the_sram 						=> SRAM_LB_N,
	SRAM_OE_N_from_the_sram 						=> SRAM_OE_N,
	SRAM_UB_N_from_the_sram 						=> SRAM_UB_N,
	SRAM_WE_N_from_the_sram 						=> SRAM_WE_N,
	data_to_and_from_the_cfi_flash 					=> FL_DQ, 
	address_to_the_cfi_flash 						=> FL_ADDR, 
	write_n_to_the_cfi_flash 						=> FL_WE_N,
	read_n_to_the_cfi_flash 						=> FL_OE_N,
	select_n_to_the_cfi_flash						=> FL_CE_N,
	AUD_ADCDAT_to_the_musicController_inst 			=> AUD_ADCDAT,
	AUD_ADCLRCK_from_the_musicController_inst 		=> AUD_ADCLRCK ,
	AUD_BCLK_to_and_from_the_musicController_inst	=> AUD_BCLK,
	AUD_DACDAT_from_the_musicController_inst 		=> AUD_DACDAT,
	AUD_DACLRCK_from_the_musicController_inst 		=> AUD_DACLRCK,
	AUX_XCK_from_the_musicController_inst 			=> AUD_XCK,
	SWITCH_1_to_the_InputController_inst 			=> GPIO_0(1),
	SWITCH_2_to_the_InputController_inst 			=> GPIO_0(3) ,
	SWITCH_3_to_the_InputController_inst 			=> GPIO_0(5) ,
	SWITCH_4_to_the_InputController_inst 			=> GPIO_0(7), 
	SWITCH_5_to_the_InputController_inst 			=> GPIO_0(9),
	HEX_0_from_the_scoreController_inst 			=> HEX0,
	HEX_1_from_the_scoreController_inst 			=> HEX1,
	HEX_2_from_the_scoreController_inst 			=> HEX2,
	HEX_3_from_the_scoreController_inst 			=> HEX3,
	VGA_CLK_from_the_vga 							=> VGA_CLK,                        
    VGA_HS_from_the_vga 							=> VGA_HS,                            
    VGA_VS_from_the_vga 							=> VGA_VS,                            
    VGA_BLANK_from_the_vga 							=> VGA_BLANK,                          
    VGA_SYNC_from_the_vga 							=> VGA_SYNC, 
    VGA_R_from_the_vga 								=> VGA_R,                             
    VGA_G_from_the_vga 								=> VGA_G,                           
    VGA_B_from_the_vga 								=> VGA_B 
	
);

--	Todo multiplex the inputs


  FL_RST_N <= reset_n ;
  

end datapath;
