library ieee;

use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity counter is

port 
(
--Synchronous reset
reset : in std_logic;
clk: in std_logic;
do: out unsigned(31 downto 0);
di : in unsigned (31 downto 0)
);

end counter;


architecture ar1 of counter is
signal value : unsigned(31 downto 0);
begin 
process(clk)
	begin
	if(rising_edge(clk)) then 
		if( reset='1' )
		then
			value <= di;
		else
			value <= value -1;
		end if;
	end if;
	end process;
	do <= value; --copy value to the output
end ar1;
