-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity cell is
  
  port (
	clk		: in std_logic;
	X  		: in unsigned(9 downto 0);
	Y  		: in  unsigned(9 downto 0);
	REGVAL	: in  unsigned(11 downto 0);
	RGB 	: out  unsigned(30 downto 0); -- First bit is transparency 0 = transparent
	ADD_cell: out unsigned(9 downto 0 );
	RGB_CELL: in unsigned (24 downto 0 );
	en 		: out std_logic
	);
end cell;

architecture rtl of cell is
signal Yin : unsigned (8 downto 0);
signal Xin : unsigned (9 downto 0); 
signal XCELL : unsigned (9 downto 0 );
signal YCELL : unsigned (9 downto 0);
signal ins: std_logic;
signal add: integer;


	begin 
Yin 	<= REGVAL(8 downto 0);
Xin		<= "00"&REGVAL(11 downto 9)&"00000"; -- *32
XCELL 	<= X - XIN;
YCELL	<= Y-YIN;
ins 	<= '1' when (X > Xin and X <Xin+32 and Y >Yin and Y <Yin +32 and to_integer(REGVAL(11 downto 9))>0 ) else '0';
en <=ins;
ADD_cell <= XCELL(4 downto 0) &"00000"+ YCELL;

process(clk)
begin
if(rising_edge(clk)) then 
	if (ins = '0' or (ins='1' and RGB_CELL(24) ='1')) then 
	RGB <= "0000000000000000000000000000000";
	else
	RGB <=RGB_CELL(24) & RGB_CELL(23 downto 16) & "00" & RGB_CELL(15 downto 8) & "00"& RGB_CELL(7 downto 0) & "00";
end if ;
end if;
end process;
-- On clock


end;
