-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity buttondisplay is
port(Xcoordinate:in integer;--x coordinate of the screen 
Ycoordinate:in integer;--y coordinate of the screen 
Xbutton: in integer;--X coordinate of the starting position of the sprite
Ybutton: in integer;--Y coordinate of the starting position of the sprite
display:in std_logic;
ritwrong:in std_logic;
pixeloutx: out integer;--The x-pixel of the sprite that need to be displayed
pixelouty: out integer;--The y-pixel of the sprite that need to be displayed
spritno:out integer;
enable:out std_logic);
end buttondisplay;

architecture behv of buttondisplay is 

--type rom_type is array (0 to 31) of unsigned(27 downto 0);-->?????            ///Rom used to store the sprites
----constant ROM : rom_type;
--type Matrix_type is array (0 to 31) of rom_type;
--constant Ma1: Matrix_type := (
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1fffcfd",x"1ffffff",x"1ffffff",x"1f3eef0",x"1e7e2dc",x"1e9ceb8",x"1f8bd92",x"1feb186",x"1f7b086",x"1dfb999",x"1d5c9c0",x"1e4dce1",x"1f8ecef",x"1ffffff",x"1ffffff",x"1fffdfd",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ebe8e6",x"1fdbe96",x"1ff9a5c",x"1ff8847",x"1ff8543",x"1ff8441",x"1ff833f",x"1ff803b",x"1ff7f39",x"1ff7e37",x"1ff7b33",x"1fc8d4e",x"1c1afad",x"1f1e2e7",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f8c8a5",x"1ff904d",x"1ff8949",x"1ff8745",x"1ff8644",x"1ff8341",x"1ff813b",x"1ff8039",x"1ff7d35",x"1ff7d35",x"1ff7b33",x"1ff7a31",x"1ff762b",x"1ff7327",x"1f4752f",x"1b9a8b5",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1fffefe",x"1ffffff",x"1f2f1f0",x"1ffa56f",x"1ff8b4b",x"1ff8847",x"1ff8441",x"1ff803c",x"1ff7b33",x"1ff7930",x"1ff772c",x"1ff7428",x"1ff7428",x"1ff7326",x"1ff7225",x"1ff7225",x"1ff7326",x"1ff7123",x"1ff6f21",x"1ff6b1b",x"1967b82",x"1f0dde0",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f4f3f2",x"1fe9860",x"1ff8847",x"1ff8645",x"1ff803c",x"1ff7c34",x"1ff772c",x"1ff7224",x"1ff6e1e",x"1ff6b1a",x"1ff6a18",x"1ff6a18",x"1ff6a18",x"1ff6917",x"1ff6b1a",x"1ff6c1c",x"1ff6c1c",x"1ff6c1c",x"1ff6b1b",x"1ff6c13",x"1867072",x"1eadcdf",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1fcfbfb",x"1fca976",x"1ff8f45",x"1ff8442",x"1ff7e37",x"1ff762b",x"1ff6e1f",x"1ff6917",x"1ff6511",x"1ff620d",x"1ff610b",x"1ff610b",x"1ff610b",x"1ff610b",x"1ff610b",x"1ff620d",x"1ff640f",x"1ff6613",x"1ff6613",x"1ff6613",x"1ff6510",x"1ff6609",x"1796471",x"1e9e9e9",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f2c1a4",x"1ff8e43",x"1ff8340",x"1ff7d36",x"1ff7529",x"1ff6b1b",x"1ff6714",x"1ff620c",x"1ff6009",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff620c",x"1ff620c",x"1ff6510",x"1ff6510",x"1ff630e",x"1ff6008",x"1f26102",x"1a97c87",x"1f9ffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1f5f4f2",x"1f99057",x"1ff813e",x"1ff7e37",x"1ff762a",x"1ff6b1b",x"1ff640f",x"1ff620c",x"1ff610a",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff610a",x"1ff620c",x"1ff620c",x"1ff610a",x"1ff5d05",x"1fc6001",x"17c6363",x"1d7d0d3",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1f4c0a3",x"1ff8d39",x"1ff7f38",x"1ff772c",x"1ff6c1c",x"1ff6511",x"1ff610b",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff610a",x"1ff6008",x"1ff5d04",x"1fa5901",x"1ed6b01",x"19e747f",x"1ecf7f5",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1fafafa",x"1ee9f74",x"1ff8934",x"1ff7930",x"1ff7022",x"1ff6714",x"1ff610b",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5d04",x"1fa5901",x"1ec7001",x"1776b71",x"1cdd5d7",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1fdffff",x"1e9e7e4",x"1ff7c2d",x"1ff772d",x"1ff7327",x"1ff6b1b",x"1ff6510",x"1ff6009",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5b01",x"1f85800",x"1ee5f00",x"1734842",x"1b6b8bd",x"1cdd3d6",x"1ffffff"),
--(x"1ffffff",x"1f4ffff",x"1dcd2c8",x"1ff8626",x"1ff7428",x"1ff6f20",x"1ff6714",x"1ff620c",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5c02",x"1f65801",x"1ea5401",x"1a6621a",x"1a2a1a7",x"1a5b1b5",x"1ffffff"),
--(x"1fffefe",x"1e7f8fb",x"1d4bcad",x"1ff8024",x"1ff7022",x"1ff6c1c",x"1ff6612",x"1ff610a",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1fe5b01",x"1f25601",x"1e65201",x"1ce7403",x"1868189",x"196a4aa",x"1f0f0f0"),
--(x"1f7f7f9",x"1dcedf1",x"1cfb3a2",x"1ff7c1b",x"1ff6b1b",x"1ff6917",x"1ff640f",x"1ff610a",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5d05",x"1fe5a00",x"1f05500",x"1e25000",x"1d26f01",x"16b636d",x"17f8f98",x"1c4c6c9"),
--(x"1edeff1",x"1d7e6e9",x"1c9b7a9",x"1ff7b11",x"1ff6714",x"1ff6714",x"1ff630e",x"1ff610a",x"1ff5f07",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5e06",x"1fa5901",x"1ea5300",x"1de4f01",x"1c46902",x"15e5861",x"174838e",x"1a6a8ad"),
--(x"1eaebec",x"1c9d7de",x"1cbc6c0",x"1fe7e00",x"1ff6510",x"1ff630e",x"1ff620c",x"1ff6008",x"1ff5f07",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5d04",x"1f65801",x"1e45101",x"1d64d01",x"1985318",x"15e5c63",x"1687580",x"1a0a2a6"),
--(x"1ecedef",x"1afbdc7",x"1dadad9",x"1f26100",x"1ff6508",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5d04",x"1fa5901",x"1ee5501",x"1dc4f01",x"1d05401",x"1613f3c",x"1606469",x"1606b76",x"19ea0a3"),
--(x"1f3f3f4",x"195a2af",x"1e5e7e7",x"1c38159",x"1fa7101",x"1fe5b01",x"1ff5d04",x"1ff5d04",x"1ff5f07",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5e06",x"1fe5b01",x"1f25601",x"1e25101",x"1d44b00",x"1ca6001",x"14c424d",x"16b7074",x"1575f6a",x"19d9fa2"),
--(x"1f7f7f7",x"1949eaa",x"1c9d1d8",x"1c3bfb8",x"1ea7f00",x"1fa5800",x"1fa5800",x"1fe5b01",x"1ff5c03",x"1ff5d05",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5f07",x"1ff5d05",x"1ff5b01",x"1f65700",x"1e65100",x"1d84c00",x"1d04900",x"1c85600",x"14f4042",x"16b7279",x"1494e58",x"1a7a8ab"),
--(x"1fcfcfc",x"1a5adb5",x"18894a1",x"1f4f4f5",x"1bd6f40",x"1f26201",x"1f25601",x"1f65801",x"1fa5901",x"1fe5a00",x"1ff5d04",x"1ff5e06",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff6008",x"1ff5f07",x"1ff6008",x"1ff5d04",x"1fe5b01",x"1f45701",x"1e65201",x"1da4e01",x"1d04a01",x"1cc5301",x"1534144",x"1686566",x"1677079",x"145474d",x"1c7c7c8"),
--(x"1ffffff",x"1bcc3c8",x"1778592",x"1c3cbd0",x"1d4d3d0",x"1d66601",x"1ec5f01",x"1ec5401",x"1f05601",x"1f65700",x"1fa5901",x"1fe5b01",x"1ff5c02",x"1ff5d04",x"1ff5e06",x"1ff5e06",x"1ff5e06",x"1ff5d04",x"1ff5c03",x"1fe5b01",x"1f85901",x"1ee5501",x"1e45101",x"1d84d01",x"1d04a01",x"1ce4f01",x"1bb4d02",x"143383c",x"1a7abaf",x"1636971",x"1525356",x"1e7e7e8"),
--(x"1ffffff",x"1dbdfe0",x"1838e9b",x"178828f",x"1e1e2e3",x"1acaaab",x"1d07500",x"1e65201",x"1e45000",x"1e65100",x"1ec5300",x"1f05500",x"1f25500",x"1f65700",x"1f85800",x"1f85800",x"1f85800",x"1f65700",x"1f25500",x"1ec5300",x"1e65100",x"1dc4e00",x"1d44b00",x"1ce4900",x"1ce4e00",x"1c64f00",x"13b353e",x"1949594",x"1dbd9d9",x"152545c",x"1828385",x"1fefefe"),
--(x"1ffffff",x"1ffffff",x"189919f",x"1737e8b",x"1818c97",x"1cfcfd1",x"1938683",x"1ce6c01",x"1de4e00",x"1de4e00",x"1de4f01",x"1e25101",x"1e45000",x"1e65201",x"1e85301",x"1e85301",x"1e65201",x"1e45101",x"1e04f00",x"1da4e01",x"1d64d01",x"1d04a01",x"1ce4a01",x"1cc4901",x"1c65001",x"14b3d42",x"16e6969",x"1e6e0de",x"1b2adaf",x"14a4a50",x"1c3c4c5",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1bfc4c8",x"1697783",x"1747d88",x"1848e9a",x"1adadaf",x"1958274",x"1cc5b00",x"1d25400",x"1d44c01",x"1d64d01",x"1d64d01",x"1d84d01",x"1d84d01",x"1d84d01",x"1d64d01",x"1d44c01",x"1d24a00",x"1d04a01",x"1ce4a01",x"1cc4901",x"1ca5701",x"1c65501",x"152494a",x"1595457",x"19ba1a6",x"1a9a4a9",x"15d5a5e",x"1707072",x"1f8f8f8",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1929ba0",x"1666f78",x"1717a83",x"1828e99",x"1999b9c",x"1958d7f",x"1b67324",x"1cc5701",x"1ca4d01",x"1cc4401",x"1ce4501",x"1ce4a01",x"1ce4a01",x"1ce4501",x"1ce4a01",x"1ce4900",x"1ca4801",x"1ca5201",x"1ca5701",x"19b6c30",x"1555054",x"15a5a5a",x"1696f72",x"162676d",x"1474a50",x"13c3d3f",x"1c9cacb",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ededed",x"174787e",x"15e656d",x"16f767f",x"17f8994",x"1838e94",x"1878787",x"19e8468",x"1b27a2f",x"1c5690f",x"1ca5b01",x"1ca5701",x"1ca5701",x"1c85601",x"1c85601",x"1ca5a00",x"1bd6516",x"1a1763c",x"1625d5c",x"1554f50",x"1585a5c",x"1595a5c",x"14b494a",x"1373437",x"1272525",x"1959699",x"1fcfcfd",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1dedfdf",x"166686e",x"15a5c62",x"175757a",x"17e8289",x"17d878f",x"178818a",x"17f8080",x"17c7978",x"186796c",x"1947c5f",x"19e7c53",x"1957956",x"17e725e",x"16a6662",x"15f5d5f",x"1535152",x"1505253",x"1505051",x"14c4a4b",x"13f3d3d",x"12f2d2e",x"1242221",x"169696a",x"1ebebed",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1e8e8e8",x"16d6c6f",x"1545153",x"17a7574",x"1948b85",x"1958f8a",x"1908b89",x"1828385",x"171787c",x"1676c6e",x"1606365",x"15b5e60",x"156595a",x"1535456",x"1505253",x"14b4b4b",x"1464445",x"1403c3c",x"1333031",x"1272325",x"1232121",x"1737475",x"1dfdfe1",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f0f0f0",x"1868688",x"1424043",x"16b6160",x"1988a7c",x"1b2a08a",x"1b2a290",x"1a3958b",x"18d847f",x"1797371",x"1686563",x"1585656",x"14e4d4d",x"1434142",x"13c3a3a",x"1322f2f",x"1292526",x"1211f1b",x"13f3e3e",x"1939596",x"1eaeaec",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1c0c1c2",x"1656568",x"13b393a",x"1534d47",x"1756c5c",x"186796b",x"187776c",x"1726763",x"15d5752",x"1484545",x"1393636",x"12d2a2a",x"1252324",x"1242220",x"13d3d39",x"1808182",x"1cccdce",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f6f6f6",x"1c4c5c6",x"1838385",x"1575659",x"13b3b3e",x"1373537",x"1373537",x"1363338",x"1323131",x"1373534",x"1494948",x"16c6c6e",x"19e9ea1",x"1cfcfd2",x"1f8f8f8",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"),
--(x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1f3f4f5",x"1dcddde",x"1c6c7c7",x"1bebfc1",x"1c0c0c2",x"1c0c0c1",x"1cbcccd",x"1e0e1e3",x"1f2f3f3",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff",x"1ffffff"));
--signal spritno:integer:=0; 
signal spx:integer:=0;
signal spy:integer:=0;
signal temp:integer:=0;
begin


process (Xcoordinate,Ycoordinate,Xbutton,Ybutton) 
begin
temp<=((Xbutton))*50+40;--30 is the offset from the leftmost pixel on the screen1

--if (Xcoordinate-temp)>=0 and  (Xcoordinate-temp)<32 and (Ycoordinate-Ybutton)>=0 and (Ycoordinate-Ybutton)<32  and display='1' then
if (Xcoordinate-temp)>=0 and  (Xcoordinate-temp)<32 and (Ycoordinate-Ybutton)>=0 and (Ycoordinate-Ybutton)<32  then
  
  spritno<=(Xbutton);
  enable<='1';
--pixelout<=Ma1(Xcoordinate-temp)(Ycoordinate-Ybutton);
  pixeloutx<=(Xcoordinate-temp);
  pixelouty<=(Ycoordinate-Ybutton);	
else
spritno<=0;
enable<='0';
pixeloutx<=0;
pixelouty<=0;

--pixelout<=Ma1(spx)(spy);
end if;
end process;
end behv;