-- This file is part of The Awesome Guitar Game.
--
--    The Awesome Guitar Game is a free software: you can redistribute it and/or modify
--    it under the terms of the GNU General Public License as published by
--    the Free Software Foundation, either version 3 of the License, or
--    (at your option) any later version.
--
--    The Awesome Guitar Game is distributed in the hope that it will be useful,
--    but WITHOUT ANY WARRANTY; without even the implied warranty of
--    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--    GNU General Public License for more details.
--
--    You should have received a copy of the GNU General Public License
--    along with The Awesome Guitar Game.  If not, see <http://www.gnu.org/licenses/>.
--
--
--###########################################################
-- The awesome guitar game (A clone of Guitar Hero for FPGA #
--###########################################################
-- EMBEDDED SYSTEM PROJECT
-- Columbia Unviersity Spring 2012
--
-- Avijit Singh Wasu -- asw2156@columbia.edu
-- Laurent Charignon -- lc2817@columbia.edu
-- 
-- Licensed under the GPL license
-- Have a look at the license file in the root of 
-- the project to have more details about the license
--
--##########################################################
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity beatController is
  
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(9 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0)
    );
end beatController;



architecture rtl of beatController is


signal re: std_logic;
signal read_in : unsigned (15 downto 0);
signal write_out : unsigned (15 downto 0);
component beatRom is
port 
(
clk		: in std_logic;
en : in std_logic;
address : in unsigned(9 downto 0);
data : out unsigned(15 downto 0)
);
end component beatRom; 
begin
re      <= '1' when chipselect = '1'and read ='1'  else '0' ;
C0: beatRom port map(clk,re,address,readdata);
end rtl;

















