library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity synth is
	port (
		--clocks
		CLOCK_27, CLOCK_50, EXT_CLOCK : in std_logic; 
		--leds
		LEDR : out std_logic_vector(17 downto 0); --LEDs
		LEDG : out std_logic_vector(7 downto 0);
		--buttons and switches
		KEY : in std_logic_vector(3 downto 0);
		SW  : in std_logic_vector(17 downto 0);
			
		--SRAM
		SRAM_DQ : inout std_logic_vector(15 downto 0);
		SRAM_ADDR : out std_logic_vector(17 downto 0);
		SRAM_UB_N, --Highbyte Data Mask
		SRAM_LB_N, --Lowbyte Data Mask
		SRAM_WE_N, --Write Enable
		SRAM_CE_N, --Chip Enable
		SRAM_OE_N : out std_logic; --Output Enable

		 -- I2C bus    
		I2C_SDAT : inout std_logic; -- I2C Data
		I2C_SCLK : out std_logic;   -- I2C Clock

		--Audio CODEC
		AUD_ADCLRCK : inout std_logic; --ADC LR Clock
		AUD_ADCDAT : in std_logic;                          -- ADC Data
		AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
		AUD_DACDAT : out std_logic;                         -- DAC Data
		AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
		AUD_XCK : out std_logic                            -- Chip Clock
	);
end synth;

architecture rtl of synth is
	
	--Synthesizer declaration
	component synthesizer is
	port(
		clk, reset_n : in std_logic;
		
		--FM synthesis inputs (from NIOS processor via Avalon bus)
		fm_dat_1 : in std_logic_vector(15 downto 0);
		fm_en_1 : in std_logic;  
		
		-- Switch data
		SW  : in std_logic_vector(17 downto 0);
		
		-- I2C bus (from pins)    
		I2C_SDAT : inout std_logic; -- I2C Data
		I2C_SCLK : out std_logic;   -- I2C Clock

		--Audio CODEC (from pins)
		AUD_ADCLRCK : inout std_logic; --ADC LR Clock
		AUD_ADCDAT : in std_logic;                          -- ADC Data
		AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
		AUD_DACDAT : out std_logic;                         -- DAC Data
		AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
		AUD_XCK : out std_logic                            -- Chip Clock
	);
	end component;

	--signals
	signal reset_n : std_logic;	
	
	signal out_sample  	: std_logic_vector(23 downto 0);
	signal in_sample   	: std_logic_vector(23 downto 0);
	
	signal note_data1   : std_logic_vector(15 downto 0);

	signal note_enable1 : std_logic;
begin
	-- turn off reset
	process(CLOCK_50) begin
		reset_n <= '1';
	end process;	

	-- LED business
	LEDR <= SW;
	LEDG <= note_data1(7 downto 0);

	note_enable1 <= '0' when note_data1 = x"0000" else '1';

	-- Instantiate synthesizer
	syn : synthesizer port map (
		clk => CLOCK_50,
		reset_n => reset_n,
		
		-- pitch data
		--fm_dat_1 => x"01B8",
		fm_dat_1 =>  "00" & SW(15 downto 13) & SW(12 downto 9) & SW(8 downto 5) & "000",
--		fm_dat_2 => x"0220",
--		fm_dat_3 => x"0293",
--		fm_dat_4 => x"00DF",
--		fm_dat_5 => x"00EF",
		
		-- voice enable
		fm_en_1  => SW(1),
--		fm_en_2  => SW(1),
--		fm_en_3  => SW(2),
--		fm_en_4  => SW(3),
--		fm_en_5  => SW(4),
		
		-- Switch data
		SW => SW,
		
		-- I2C bus (from pins)    
		I2C_SDAT => I2C_SDAT,
		I2C_SCLK => I2C_SCLK,

		--Audio CODEC (from pins)
		AUD_ADCLRCK => AUD_ADCLRCK,
		AUD_ADCDAT  => AUD_ADCDAT,
		AUD_DACLRCK => AUD_DACLRCK,
		AUD_DACDAT  => AUD_DACDAT,
		AUD_BCLK 	=> AUD_BCLK,
		AUD_XCK     => AUD_XCK		
	);

	-- Instantiate processor
--	nios : entity work.nios_system port map (
--		--Connect clock at reset to NIOS proc
--		clk => CLOCK_50,
--		reset_n => reset_n,
--
--		-- MIDI data
--		out_port_from_the_pio => note_data1,
--
--		SRAM_ADDR_from_the_sram => SRAM_ADDR,
--		SRAM_CE_N_from_the_sram => SRAM_CE_N,
--		SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
--		SRAM_LB_N_from_the_sram => SRAM_LB_N,
--		SRAM_OE_N_from_the_sram => SRAM_OE_N,
--		SRAM_UB_N_from_the_sram => SRAM_UB_N,
--		SRAM_WE_N_from_the_sram => SRAM_WE_N
--	);
--	

end rtl;