library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity sq_lowpass_imp is
port (  clk : in std_logic;
input1 : in signed(31 downto 0);	-- 16 bit long amplitude input comes from the audio codec
input2 : in signed(31 downto 0);
input3 : in signed(31 downto 0);
input4 : in signed(31 downto 0);
input5 : in signed(31 downto 0);
input6 : in signed(31 downto 0);
input7 : in signed(31 downto 0);
input8 : in signed(31 downto 0);
input9 : in signed(31 downto 0);
input10 : in signed(31 downto 0);
output1 : out signed(31 downto 0);
output2 : out signed(31 downto 0);
output3 : out signed(31 downto 0);
output4 : out signed(31 downto 0);
output5 : out signed(31 downto 0);
output6 : out signed(31 downto 0);
output7 : out signed(31 downto 0);
output8 : out signed(31 downto 0);
output9 : out signed(31 downto 0);
output10 : out signed(31 downto 0));  -- naturally to stay consistent, we have a 16 bit output       
                                                                                                                                                                                                                                                                  
end sq_lowpass_imp;

architecture sq_lowpass_ar of sq_lowpass_imp is

component sq_lowpass_en
port ( 
x0 : in signed(31 downto 0);	-- 16 bit long amplitude input comes from the audio codec
x1 : in signed(31 downto 0);	-- Amplitude input delayed by 1 time unit
y1 : in signed(31 downto 0);  	-- Ampltiude output delayed by 1 time unit
y0 : out signed(31 downto 0));  -- naturally to stay consistent, we have a 16 bit output                                                                                                                                                                                                                                                                       
end component;

signal input2_1 : signed(31 downto 0);
signal output2_1 : signed(31 downto 0);
signal outputbuffer_1 : signed(31 downto 0);

signal input2_2 : signed(31 downto 0);
signal output2_2 : signed(31 downto 0);
signal outputbuffer_2 : signed(31 downto 0);

signal input2_3 : signed(31 downto 0);
signal output2_3 : signed(31 downto 0);
signal outputbuffer_3 : signed(31 downto 0);

signal input2_4 : signed(31 downto 0);
signal output2_4 : signed(31 downto 0);
signal outputbuffer_4 : signed(31 downto 0);

signal input2_5 : signed(31 downto 0);
signal output2_5 : signed(31 downto 0);
signal outputbuffer_5 : signed(31 downto 0);

signal input2_6 : signed(31 downto 0);
signal output2_6 : signed(31 downto 0);
signal outputbuffer_6 : signed(31 downto 0);

signal input2_7 : signed(31 downto 0);
signal output2_7 : signed(31 downto 0);
signal outputbuffer_7 : signed(31 downto 0);

signal input2_8 : signed(31 downto 0);
signal output2_8 : signed(31 downto 0);
signal outputbuffer_8 : signed(31 downto 0);

signal input2_9 : signed(31 downto 0);
signal output2_9 : signed(31 downto 0);
signal outputbuffer_9 : signed(31 downto 0);

signal input2_10 : signed(31 downto 0);
signal output2_10 : signed(31 downto 0);
signal outputbuffer_10 : signed(31 downto 0);

begin

lpfilter1 : sq_lowpass_en port map
(input1, input2_1, output2_1, outputbuffer_1);

lpfilter2 : sq_lowpass_en port map
(input2, input2_2, output2_2, outputbuffer_2);

lpfilter3 : sq_lowpass_en port map
(input3, input2_3, output2_3, outputbuffer_3);

lpfilter4 : sq_lowpass_en port map
(input4, input2_4, output2_4, outputbuffer_4);

lpfilter5 : sq_lowpass_en port map
(input5, input2_5, output2_5, outputbuffer_5);

lpfilter6 : sq_lowpass_en port map
(input6, input2_6, output2_6, outputbuffer_6);

lpfilter7 : sq_lowpass_en port map
(input7, input2_7, output2_7, outputbuffer_7);

lpfilter8 : sq_lowpass_en port map
(input8, input2_8, output2_8, outputbuffer_8);

lpfilter9 : sq_lowpass_en port map
(input9, input2_9, output2_9, outputbuffer_9);

lpfilter10 : sq_lowpass_en port map
(input10, input2_10, output2_10, outputbuffer_10);

process(clk)
begin
if rising_edge(clk) then
input2_1 <= input1;
output2_1 <= outputbuffer_1;
output1 <= outputbuffer_1;

input2_2 <= input2;
output2_2 <= outputbuffer_2;
output2 <= outputbuffer_2;

input2_3 <= input3;
output2_3 <= outputbuffer_3;
output3 <= outputbuffer_3;

input2_4 <= input4;
output2_4 <= outputbuffer_4;
output4 <= outputbuffer_4;

input2_5 <= input5;
output2_5 <= outputbuffer_5;
output5 <= outputbuffer_5;

input2_6 <= input6;
output2_6 <= outputbuffer_6;
output6 <= outputbuffer_6;

input2_7 <= input7;
output2_7 <= outputbuffer_7;
output7 <= outputbuffer_7;

input2_8 <= input8;
output2_8 <= outputbuffer_8;
output8 <= outputbuffer_8;

input2_9 <= input9;
output2_9 <= outputbuffer_9;
output9 <= outputbuffer_9;

input2_10 <= input10;
output2_10 <= outputbuffer_10;
output10 <= outputbuffer_10;


end if;
end process;

end sq_lowpass_ar;
