library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity sq_lowpass_en is
port ( 
x0 : in signed(31 downto 0);	-- 16 bit long amplitude input comes from the audio codec
x1 : in signed(31 downto 0);	-- Amplitude input delayed by 1 time unit
y1 : in signed(31 downto 0);  	-- Ampltiude output delayed by 1 time unit
y0 : out signed(31 downto 0));  -- naturally to stay consistent, we have a 16 bit output       
                                                                                                                                                                                                                                                                  
end sq_lowpass_en;

architecture sq_lowpass_ar of sq_lowpass_en is

signal y0buffer : signed(63 downto 0);
signal x0buffer : signed(63 downto 0);

begin
x0buffer <= (x0 * x0);
y0buffer <= ((229 * x0buffer(63 downto 32)) + (229 * x1) - (-7733 * y1));
y0 <= y0buffer(44 downto 13);    -- Even though we are cutting a 32 bit signal to a 16 bit signal,
-- we are losing no valuable information because the filter
-- does not amplify the input.
end sq_lowpass_ar;