library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity bpfilter_en is
port (  a1 : in signed(31 downto 0);  	-- Although 16 bits long,we will only use 8 to store the 
a2 : in signed(31 downto 0);  	-- information regarding coefficients
a3 : in signed(31 downto 0);
b1 : in signed(31 downto 0);
b2 : in signed(31 downto 0);
b3 : in signed(31 downto 0);
x0 : in signed(31 downto 0);	-- 16 bit long amplitude input comes from the audio codec
x1 : in signed(31 downto 0);	-- Amplitude input delayed by 1 time unit
x2 : in signed(31 downto 0);	-- Amplitude input delayed by 2 time units 
y1 : in signed(31 downto 0);  	-- Ampltiude output delayed by 1 time unit
y2 : in signed(31 downto 0);  	-- Amplitude output delayed by 2 time units  
--inp : in signed(0 downto 0);
y0 : out signed(31 downto 0));  -- naturally to stay consistent, we have a 16 bit output       
                                                                                                                                                                                                                                                                  
end bpfilter_en;

architecture bpfilter_ar of bpfilter_en is

signal y0buffer : signed(63 downto 0);

begin
--y0buffer <= ((b1 * x0) + (b2 * x1) + (b3 * x2) - (a2 * y1) - (a3 * y2)) / a1;
--y0 <= y0buffer(31 downto 0); 
y0buffer <= ((b1 * x0) + (b2 * x1) + (b3 * x2) - (a2 * y1) - (a3 * y2));
y0 <= y0buffer(44 downto 13);    -- Even though we are cutting a 64 bit signal to a 32 bit signal,
-- we are losing no valuable information because the filter
-- does not amplify the input.
end bpfilter_ar;