library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity tick_counter is
	port (
		clk, rst: in std_logic;
		tick: out std_logic
	);
end tick_counter;

architecture arch of tick_counter is
	signal current_val : unsigned (7 downto 0);
	signal next_val	: unsigned (7 downto 0);

	begin
	process (clk)
		begin
		if rising_edge(clk) then
			if(rst = '1') then
				current_val <= (others => '0');
			else
				current_val <= next_val;
			end if;
		end if;
	end process;

	next_val <= (others => '0') when current_val = 99 else current_val + 1;
	tick <= '1' when current_val = 99 else '0';
end arch;