--megafunction wizard: %Altera SOPC Builder%
--GENERATION: STANDARD
--VERSION: WM1.0


--Legal Notice: (C)2007 Altera Corporation. All rights reserved.  Your
--use of Altera Corporation's design tools, logic functions and other
--software and tools, and its AMPP partner logic functions, and any
--output files any of the foregoing (including device programming or
--simulation files), and any associated documentation or information are
--expressly subject to the terms and conditions of the Altera Program
--License Subscription Agreement or other applicable license agreement,
--including, without limitation, that your use is for the sole purpose
--of programming logic devices manufactured by Altera and sold by Altera
--or its authorized distributors.  Please refer to the applicable
--agreement for further details.


-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity cpu_jtag_debug_module_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_data_master_debugaccess : IN STD_LOGIC;
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_instruction_master_latency_counter : IN STD_LOGIC;
                 signal cpu_instruction_master_read : IN STD_LOGIC;
                 signal cpu_jtag_debug_module_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_jtag_debug_module_resetrequest : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_data_master_requests_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_instruction_master_granted_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_instruction_master_qualified_request_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_instruction_master_read_data_valid_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_instruction_master_requests_cpu_jtag_debug_module : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                 signal cpu_jtag_debug_module_begintransfer : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_jtag_debug_module_chipselect : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_debugaccess : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_jtag_debug_module_reset : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_reset_n : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_resetrequest_from_sa : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_write : OUT STD_LOGIC;
                 signal cpu_jtag_debug_module_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_cpu_jtag_debug_module_end_xfer : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_jtag_debug_module_arbitrator : entity is FALSE;
end entity cpu_jtag_debug_module_arbitrator;


architecture europa of cpu_jtag_debug_module_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_instruction_master_arbiterlock :  STD_LOGIC;
                signal cpu_instruction_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_instruction_master_continuerequest :  STD_LOGIC;
                signal cpu_instruction_master_saved_grant_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_jtag_debug_module_allgrants :  STD_LOGIC;
                signal cpu_jtag_debug_module_allow_new_arb_cycle :  STD_LOGIC;
                signal cpu_jtag_debug_module_any_bursting_master_saved_grant :  STD_LOGIC;
                signal cpu_jtag_debug_module_any_continuerequest :  STD_LOGIC;
                signal cpu_jtag_debug_module_arb_addend :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_arb_counter_enable :  STD_LOGIC;
                signal cpu_jtag_debug_module_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_arb_winner :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_arbitration_holdoff_internal :  STD_LOGIC;
                signal cpu_jtag_debug_module_beginbursttransfer_internal :  STD_LOGIC;
                signal cpu_jtag_debug_module_begins_xfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_chosen_master_double_vector :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_jtag_debug_module_chosen_master_rot_left :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_end_xfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_firsttransfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_grant_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_in_a_read_cycle :  STD_LOGIC;
                signal cpu_jtag_debug_module_in_a_write_cycle :  STD_LOGIC;
                signal cpu_jtag_debug_module_master_qreq_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_non_bursting_master_requests :  STD_LOGIC;
                signal cpu_jtag_debug_module_reg_firsttransfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_saved_chosen_master_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_jtag_debug_module_slavearbiterlockenable :  STD_LOGIC;
                signal cpu_jtag_debug_module_slavearbiterlockenable2 :  STD_LOGIC;
                signal cpu_jtag_debug_module_unreg_firsttransfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_waits_for_read :  STD_LOGIC;
                signal cpu_jtag_debug_module_waits_for_write :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_cpu_jtag_debug_module :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_data_master_requests_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_instruction_master_granted_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_instruction_master_qualified_request_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_instruction_master_requests_cpu_jtag_debug_module :  STD_LOGIC;
                signal internal_cpu_jtag_debug_module_reset_n :  STD_LOGIC;
                signal last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module :  STD_LOGIC;
                signal last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module :  STD_LOGIC;
                signal shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_cpu_jtag_debug_module_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT cpu_jtag_debug_module_end_xfer;
      end if;
    end if;

  end process;

  cpu_jtag_debug_module_begins_xfer <= NOT d1_reasons_to_wait AND ((internal_cpu_data_master_qualified_request_cpu_jtag_debug_module OR internal_cpu_instruction_master_qualified_request_cpu_jtag_debug_module));
  --assign cpu_jtag_debug_module_readdata_from_sa = cpu_jtag_debug_module_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  cpu_jtag_debug_module_readdata_from_sa <= cpu_jtag_debug_module_readdata;
  internal_cpu_data_master_requests_cpu_jtag_debug_module <= to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("100000000100000000000")))) AND ((cpu_data_master_read OR cpu_data_master_write));
  --cpu_jtag_debug_module_arb_share_counter set values, which is an e_mux
  cpu_jtag_debug_module_arb_share_set_values <= std_logic_vector'("01");
  --cpu_jtag_debug_module_non_bursting_master_requests mux, which is an e_mux
  cpu_jtag_debug_module_non_bursting_master_requests <= ((internal_cpu_data_master_requests_cpu_jtag_debug_module OR internal_cpu_instruction_master_requests_cpu_jtag_debug_module) OR internal_cpu_data_master_requests_cpu_jtag_debug_module) OR internal_cpu_instruction_master_requests_cpu_jtag_debug_module;
  --cpu_jtag_debug_module_any_bursting_master_saved_grant mux, which is an e_mux
  cpu_jtag_debug_module_any_bursting_master_saved_grant <= std_logic'('0');
  --cpu_jtag_debug_module_arb_share_counter_next_value assignment, which is an e_assign
  cpu_jtag_debug_module_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(cpu_jtag_debug_module_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (cpu_jtag_debug_module_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(cpu_jtag_debug_module_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (cpu_jtag_debug_module_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --cpu_jtag_debug_module_allgrants all slave grants, which is an e_mux
  cpu_jtag_debug_module_allgrants <= ((or_reduce(cpu_jtag_debug_module_grant_vector) OR or_reduce(cpu_jtag_debug_module_grant_vector)) OR or_reduce(cpu_jtag_debug_module_grant_vector)) OR or_reduce(cpu_jtag_debug_module_grant_vector);
  --cpu_jtag_debug_module_end_xfer assignment, which is an e_assign
  cpu_jtag_debug_module_end_xfer <= NOT ((cpu_jtag_debug_module_waits_for_read OR cpu_jtag_debug_module_waits_for_write));
  --end_xfer_arb_share_counter_term_cpu_jtag_debug_module arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_cpu_jtag_debug_module <= cpu_jtag_debug_module_end_xfer AND (((NOT cpu_jtag_debug_module_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --cpu_jtag_debug_module_arb_share_counter arbitration counter enable, which is an e_assign
  cpu_jtag_debug_module_arb_counter_enable <= ((end_xfer_arb_share_counter_term_cpu_jtag_debug_module AND cpu_jtag_debug_module_allgrants)) OR ((end_xfer_arb_share_counter_term_cpu_jtag_debug_module AND NOT cpu_jtag_debug_module_non_bursting_master_requests));
  --cpu_jtag_debug_module_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_jtag_debug_module_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_jtag_debug_module_arb_counter_enable) = '1' then 
        cpu_jtag_debug_module_arb_share_counter <= cpu_jtag_debug_module_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --cpu_jtag_debug_module_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_jtag_debug_module_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((or_reduce(cpu_jtag_debug_module_master_qreq_vector) AND end_xfer_arb_share_counter_term_cpu_jtag_debug_module)) OR ((end_xfer_arb_share_counter_term_cpu_jtag_debug_module AND NOT cpu_jtag_debug_module_non_bursting_master_requests)))) = '1' then 
        cpu_jtag_debug_module_slavearbiterlockenable <= or_reduce(cpu_jtag_debug_module_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= cpu_jtag_debug_module_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --cpu_jtag_debug_module_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  cpu_jtag_debug_module_slavearbiterlockenable2 <= or_reduce(cpu_jtag_debug_module_arb_share_counter_next_value);
  --cpu/data_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= cpu_jtag_debug_module_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --cpu/instruction_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  cpu_instruction_master_arbiterlock <= cpu_jtag_debug_module_slavearbiterlockenable AND cpu_instruction_master_continuerequest;
  --cpu/instruction_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  cpu_instruction_master_arbiterlock2 <= cpu_jtag_debug_module_slavearbiterlockenable2 AND cpu_instruction_master_continuerequest;
  --cpu/instruction_master granted cpu/jtag_debug_module last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_instruction_master_saved_grant_cpu_jtag_debug_module) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((cpu_jtag_debug_module_arbitration_holdoff_internal OR NOT internal_cpu_instruction_master_requests_cpu_jtag_debug_module))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module))))));
      end if;
    end if;

  end process;

  --cpu_instruction_master_continuerequest continued request, which is an e_mux
  cpu_instruction_master_continuerequest <= last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module AND internal_cpu_instruction_master_requests_cpu_jtag_debug_module;
  --cpu_jtag_debug_module_any_continuerequest at least one master continues requesting, which is an e_mux
  cpu_jtag_debug_module_any_continuerequest <= cpu_instruction_master_continuerequest OR cpu_data_master_continuerequest;
  internal_cpu_data_master_qualified_request_cpu_jtag_debug_module <= internal_cpu_data_master_requests_cpu_jtag_debug_module AND NOT ((((cpu_data_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))))) OR cpu_instruction_master_arbiterlock));
  --local readdatavalid cpu_data_master_read_data_valid_cpu_jtag_debug_module, which is an e_mux
  cpu_data_master_read_data_valid_cpu_jtag_debug_module <= (internal_cpu_data_master_granted_cpu_jtag_debug_module AND cpu_data_master_read) AND NOT cpu_jtag_debug_module_waits_for_read;
  --cpu_jtag_debug_module_writedata mux, which is an e_mux
  cpu_jtag_debug_module_writedata <= cpu_data_master_writedata;
  --mux cpu_jtag_debug_module_debugaccess, which is an e_mux
  cpu_jtag_debug_module_debugaccess <= cpu_data_master_debugaccess;
  internal_cpu_instruction_master_requests_cpu_jtag_debug_module <= ((to_std_logic(((Std_Logic_Vector'(cpu_instruction_master_address_to_slave(20 DOWNTO 11) & std_logic_vector'("00000000000")) = std_logic_vector'("100000000100000000000")))) AND (cpu_instruction_master_read))) AND cpu_instruction_master_read;
  --cpu/data_master granted cpu/jtag_debug_module last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_data_master_saved_grant_cpu_jtag_debug_module) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((cpu_jtag_debug_module_arbitration_holdoff_internal OR NOT internal_cpu_data_master_requests_cpu_jtag_debug_module))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module))))));
      end if;
    end if;

  end process;

  --cpu_data_master_continuerequest continued request, which is an e_mux
  cpu_data_master_continuerequest <= last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module AND internal_cpu_data_master_requests_cpu_jtag_debug_module;
  internal_cpu_instruction_master_qualified_request_cpu_jtag_debug_module <= internal_cpu_instruction_master_requests_cpu_jtag_debug_module AND NOT ((((cpu_instruction_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))))) OR cpu_data_master_arbiterlock));
  --local readdatavalid cpu_instruction_master_read_data_valid_cpu_jtag_debug_module, which is an e_mux
  cpu_instruction_master_read_data_valid_cpu_jtag_debug_module <= (internal_cpu_instruction_master_granted_cpu_jtag_debug_module AND cpu_instruction_master_read) AND NOT cpu_jtag_debug_module_waits_for_read;
  --allow new arb cycle for cpu/jtag_debug_module, which is an e_assign
  cpu_jtag_debug_module_allow_new_arb_cycle <= NOT cpu_data_master_arbiterlock AND NOT cpu_instruction_master_arbiterlock;
  --cpu/instruction_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  cpu_jtag_debug_module_master_qreq_vector(0) <= internal_cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  --cpu/instruction_master grant cpu/jtag_debug_module, which is an e_assign
  internal_cpu_instruction_master_granted_cpu_jtag_debug_module <= cpu_jtag_debug_module_grant_vector(0);
  --cpu/instruction_master saved-grant cpu/jtag_debug_module, which is an e_assign
  cpu_instruction_master_saved_grant_cpu_jtag_debug_module <= cpu_jtag_debug_module_arb_winner(0) AND internal_cpu_instruction_master_requests_cpu_jtag_debug_module;
  --cpu/data_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  cpu_jtag_debug_module_master_qreq_vector(1) <= internal_cpu_data_master_qualified_request_cpu_jtag_debug_module;
  --cpu/data_master grant cpu/jtag_debug_module, which is an e_assign
  internal_cpu_data_master_granted_cpu_jtag_debug_module <= cpu_jtag_debug_module_grant_vector(1);
  --cpu/data_master saved-grant cpu/jtag_debug_module, which is an e_assign
  cpu_data_master_saved_grant_cpu_jtag_debug_module <= cpu_jtag_debug_module_arb_winner(1) AND internal_cpu_data_master_requests_cpu_jtag_debug_module;
  --cpu/jtag_debug_module chosen-master double-vector, which is an e_assign
  cpu_jtag_debug_module_chosen_master_double_vector <= A_EXT (((std_logic_vector'("0") & ((cpu_jtag_debug_module_master_qreq_vector & cpu_jtag_debug_module_master_qreq_vector))) AND (((std_logic_vector'("0") & (Std_Logic_Vector'(NOT cpu_jtag_debug_module_master_qreq_vector & NOT cpu_jtag_debug_module_master_qreq_vector))) + (std_logic_vector'("000") & (cpu_jtag_debug_module_arb_addend))))), 4);
  --stable onehot encoding of arb winner
  cpu_jtag_debug_module_arb_winner <= A_WE_StdLogicVector((std_logic'(((cpu_jtag_debug_module_allow_new_arb_cycle AND or_reduce(cpu_jtag_debug_module_grant_vector)))) = '1'), cpu_jtag_debug_module_grant_vector, cpu_jtag_debug_module_saved_chosen_master_vector);
  --saved cpu_jtag_debug_module_grant_vector, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_jtag_debug_module_saved_chosen_master_vector <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_jtag_debug_module_allow_new_arb_cycle) = '1' then 
        cpu_jtag_debug_module_saved_chosen_master_vector <= A_WE_StdLogicVector((std_logic'(or_reduce(cpu_jtag_debug_module_grant_vector)) = '1'), cpu_jtag_debug_module_grant_vector, cpu_jtag_debug_module_saved_chosen_master_vector);
      end if;
    end if;

  end process;

  --onehot encoding of chosen master
  cpu_jtag_debug_module_grant_vector <= Std_Logic_Vector'(A_ToStdLogicVector(((cpu_jtag_debug_module_chosen_master_double_vector(1) OR cpu_jtag_debug_module_chosen_master_double_vector(3)))) & A_ToStdLogicVector(((cpu_jtag_debug_module_chosen_master_double_vector(0) OR cpu_jtag_debug_module_chosen_master_double_vector(2)))));
  --cpu/jtag_debug_module chosen master rotated left, which is an e_assign
  cpu_jtag_debug_module_chosen_master_rot_left <= A_EXT (A_WE_StdLogicVector((((A_SLL(cpu_jtag_debug_module_arb_winner,std_logic_vector'("00000000000000000000000000000001")))) /= std_logic_vector'("00")), (std_logic_vector'("000000000000000000000000000000") & ((A_SLL(cpu_jtag_debug_module_arb_winner,std_logic_vector'("00000000000000000000000000000001"))))), std_logic_vector'("00000000000000000000000000000001")), 2);
  --cpu/jtag_debug_module's addend for next-master-grant
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_jtag_debug_module_arb_addend <= std_logic_vector'("01");
    elsif clk'event and clk = '1' then
      if std_logic'(or_reduce(cpu_jtag_debug_module_grant_vector)) = '1' then 
        cpu_jtag_debug_module_arb_addend <= A_WE_StdLogicVector((std_logic'(cpu_jtag_debug_module_end_xfer) = '1'), cpu_jtag_debug_module_chosen_master_rot_left, cpu_jtag_debug_module_grant_vector);
      end if;
    end if;

  end process;

  cpu_jtag_debug_module_begintransfer <= cpu_jtag_debug_module_begins_xfer;
  --assign lhs ~cpu_jtag_debug_module_reset of type reset_n to cpu_jtag_debug_module_reset_n, which is an e_assign
  cpu_jtag_debug_module_reset <= NOT internal_cpu_jtag_debug_module_reset_n;
  --cpu_jtag_debug_module_reset_n assignment, which is an e_assign
  internal_cpu_jtag_debug_module_reset_n <= reset_n;
  --assign cpu_jtag_debug_module_resetrequest_from_sa = cpu_jtag_debug_module_resetrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  cpu_jtag_debug_module_resetrequest_from_sa <= cpu_jtag_debug_module_resetrequest;
  cpu_jtag_debug_module_chipselect <= internal_cpu_data_master_granted_cpu_jtag_debug_module OR internal_cpu_instruction_master_granted_cpu_jtag_debug_module;
  --cpu_jtag_debug_module_firsttransfer first transaction, which is an e_assign
  cpu_jtag_debug_module_firsttransfer <= A_WE_StdLogic((std_logic'(cpu_jtag_debug_module_begins_xfer) = '1'), cpu_jtag_debug_module_unreg_firsttransfer, cpu_jtag_debug_module_reg_firsttransfer);
  --cpu_jtag_debug_module_unreg_firsttransfer first transaction, which is an e_assign
  cpu_jtag_debug_module_unreg_firsttransfer <= NOT ((cpu_jtag_debug_module_slavearbiterlockenable AND cpu_jtag_debug_module_any_continuerequest));
  --cpu_jtag_debug_module_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_jtag_debug_module_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(cpu_jtag_debug_module_begins_xfer) = '1' then 
        cpu_jtag_debug_module_reg_firsttransfer <= cpu_jtag_debug_module_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --cpu_jtag_debug_module_beginbursttransfer_internal begin burst transfer, which is an e_assign
  cpu_jtag_debug_module_beginbursttransfer_internal <= cpu_jtag_debug_module_begins_xfer;
  --cpu_jtag_debug_module_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  cpu_jtag_debug_module_arbitration_holdoff_internal <= cpu_jtag_debug_module_begins_xfer AND cpu_jtag_debug_module_firsttransfer;
  --cpu_jtag_debug_module_write assignment, which is an e_mux
  cpu_jtag_debug_module_write <= internal_cpu_data_master_granted_cpu_jtag_debug_module AND cpu_data_master_write;
  shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --cpu_jtag_debug_module_address mux, which is an e_mux
  cpu_jtag_debug_module_address <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_cpu_jtag_debug_module)) = '1'), (A_SRL(shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010"))), (A_SRL(shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master,std_logic_vector'("00000000000000000000000000000010")))), 9);
  shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master <= cpu_instruction_master_address_to_slave;
  --d1_cpu_jtag_debug_module_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_cpu_jtag_debug_module_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_cpu_jtag_debug_module_end_xfer <= cpu_jtag_debug_module_end_xfer;
      end if;
    end if;

  end process;

  --cpu_jtag_debug_module_waits_for_read in a cycle, which is an e_mux
  cpu_jtag_debug_module_waits_for_read <= cpu_jtag_debug_module_in_a_read_cycle AND cpu_jtag_debug_module_begins_xfer;
  --cpu_jtag_debug_module_in_a_read_cycle assignment, which is an e_assign
  cpu_jtag_debug_module_in_a_read_cycle <= ((internal_cpu_data_master_granted_cpu_jtag_debug_module AND cpu_data_master_read)) OR ((internal_cpu_instruction_master_granted_cpu_jtag_debug_module AND cpu_instruction_master_read));
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= cpu_jtag_debug_module_in_a_read_cycle;
  --cpu_jtag_debug_module_waits_for_write in a cycle, which is an e_mux
  cpu_jtag_debug_module_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_jtag_debug_module_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --cpu_jtag_debug_module_in_a_write_cycle assignment, which is an e_assign
  cpu_jtag_debug_module_in_a_write_cycle <= internal_cpu_data_master_granted_cpu_jtag_debug_module AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= cpu_jtag_debug_module_in_a_write_cycle;
  wait_for_cpu_jtag_debug_module_counter <= std_logic'('0');
  --cpu_jtag_debug_module_byteenable byte enable port mux, which is an e_mux
  cpu_jtag_debug_module_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_cpu_jtag_debug_module)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 4);
  --vhdl renameroo for output signals
  cpu_data_master_granted_cpu_jtag_debug_module <= internal_cpu_data_master_granted_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_cpu_jtag_debug_module <= internal_cpu_data_master_qualified_request_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_data_master_requests_cpu_jtag_debug_module <= internal_cpu_data_master_requests_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_instruction_master_granted_cpu_jtag_debug_module <= internal_cpu_instruction_master_granted_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_instruction_master_qualified_request_cpu_jtag_debug_module <= internal_cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_instruction_master_requests_cpu_jtag_debug_module <= internal_cpu_instruction_master_requests_cpu_jtag_debug_module;
  --vhdl renameroo for output signals
  cpu_jtag_debug_module_reset_n <= internal_cpu_jtag_debug_module_reset_n;
--synthesis translate_off
    --cpu/jtag_debug_module enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

    --grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_data_master_granted_cpu_jtag_debug_module))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_instruction_master_granted_cpu_jtag_debug_module))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line, now);
          write(write_line, string'(": "));
          write(write_line, string'("> 1 of grant signals are active simultaneously"));
          write(output, write_line.all);
          deallocate (write_line);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

    --saved_grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line1 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_data_master_saved_grant_cpu_jtag_debug_module))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_saved_grant_cpu_jtag_debug_module))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line1, now);
          write(write_line1, string'(": "));
          write(write_line1, string'("> 1 of saved_grant signals are active simultaneously"));
          write(output, write_line1.all);
          deallocate (write_line1);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity cpu_data_master_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_byteenable_sram_sram_slave : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_data_master_debugaccess : IN STD_LOGIC;
                 signal cpu_data_master_granted_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_data_master_granted_data_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                 signal cpu_data_master_granted_note_1_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_note_2_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_note_3_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_note_4_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_note_5_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_granted_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_data_master_granted_status_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_data_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_1_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_2_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_3_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_4_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_5_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_data_master_qualified_request_status_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_data_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_1_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_2_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_3_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_4_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_5_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_data_master_read_data_valid_status_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_data_master_requests_data_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                 signal cpu_data_master_requests_note_1_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_note_2_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_note_3_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_note_4_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_note_5_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_requests_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_data_master_requests_status_pio_s1 : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_cpu_jtag_debug_module_end_xfer : IN STD_LOGIC;
                 signal d1_data_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_jtag_uart_avalon_jtag_slave_end_xfer : IN STD_LOGIC;
                 signal d1_note_1_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_note_2_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_note_3_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_note_4_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_note_5_pio_s1_end_xfer : IN STD_LOGIC;
                 signal d1_sram_sram_slave_end_xfer : IN STD_LOGIC;
                 signal d1_status_pio_s1_end_xfer : IN STD_LOGIC;
                 signal data_pio_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal jtag_uart_avalon_jtag_slave_irq_from_sa : IN STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_avalon_jtag_slave_waitrequest_from_sa : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sram_sram_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal status_pio_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

              -- outputs:
                 signal cpu_data_master_address_to_slave : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_data_master_dbs_write_16 : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_data_master_irq : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_data_master_latency_counter : OUT STD_LOGIC;
                 signal cpu_data_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_data_master_readdatavalid : OUT STD_LOGIC;
                 signal cpu_data_master_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_data_master_arbitrator : entity is FALSE;
end entity cpu_data_master_arbitrator;


architecture europa of cpu_data_master_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal cpu_data_master_address_last_time :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_data_master_dbs_increment :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_data_master_is_granted_some_slave :  STD_LOGIC;
                signal cpu_data_master_read_but_no_slave_selected :  STD_LOGIC;
                signal cpu_data_master_read_last_time :  STD_LOGIC;
                signal cpu_data_master_run :  STD_LOGIC;
                signal cpu_data_master_write_last_time :  STD_LOGIC;
                signal cpu_data_master_writedata_last_time :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal dbs_count_enable :  STD_LOGIC;
                signal dbs_counter_overflow :  STD_LOGIC;
                signal internal_cpu_data_master_address_to_slave :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal internal_cpu_data_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_data_master_latency_counter :  STD_LOGIC;
                signal internal_cpu_data_master_waitrequest :  STD_LOGIC;
                signal latency_load_value :  STD_LOGIC;
                signal next_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal p1_cpu_data_master_latency_counter :  STD_LOGIC;
                signal p1_dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal pre_dbs_count_enable :  STD_LOGIC;
                signal pre_flush_cpu_data_master_readdatavalid :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic((((((((((((((((((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_qualified_request_cpu_jtag_debug_module OR NOT cpu_data_master_requests_cpu_jtag_debug_module)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_granted_cpu_jtag_debug_module OR NOT cpu_data_master_qualified_request_cpu_jtag_debug_module)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_cpu_jtag_debug_module OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_cpu_jtag_debug_module_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_cpu_jtag_debug_module OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_qualified_request_data_pio_s1 OR NOT cpu_data_master_requests_data_pio_s1)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_data_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_data_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_data_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave OR NOT cpu_data_master_requests_jtag_uart_avalon_jtag_slave)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave OR NOT ((cpu_data_master_read OR cpu_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT jtag_uart_avalon_jtag_slave_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_read OR cpu_data_master_write)))))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave OR NOT ((cpu_data_master_read OR cpu_data_master_write)))))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT jtag_uart_avalon_jtag_slave_waitrequest_from_sa)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_read OR cpu_data_master_write)))))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_1_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_note_1_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_1_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_2_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_note_2_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_2_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")));
  --cascaded wait assignment, which is an e_assign
  cpu_data_master_run <= r_0 AND r_1;
  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic((((((((((((((((((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_3_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_note_3_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_3_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_4_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_note_4_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_4_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_5_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_note_5_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_note_5_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((((cpu_data_master_qualified_request_sram_sram_slave OR (((cpu_data_master_write AND NOT(or_reduce(cpu_data_master_byteenable_sram_sram_slave))) AND internal_cpu_data_master_dbs_address(1)))) OR NOT cpu_data_master_requests_sram_sram_slave)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_granted_sram_sram_slave OR NOT cpu_data_master_qualified_request_sram_sram_slave)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_sram_sram_slave OR NOT cpu_data_master_read)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_sram_sram_slave_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_sram_sram_slave OR NOT cpu_data_master_write)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_data_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_data_master_qualified_request_status_pio_s1 OR NOT cpu_data_master_requests_status_pio_s1)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_status_pio_s1 OR NOT cpu_data_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_status_pio_s1_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_read)))))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_data_master_qualified_request_status_pio_s1 OR NOT cpu_data_master_write)))) OR ((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))))))));
  --optimize select-logic by passing only those address bits which matter.
  internal_cpu_data_master_address_to_slave <= cpu_data_master_address(20 DOWNTO 0);
  --cpu_data_master_read_but_no_slave_selected assignment, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_data_master_read_but_no_slave_selected <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        cpu_data_master_read_but_no_slave_selected <= (cpu_data_master_read AND cpu_data_master_run) AND NOT cpu_data_master_is_granted_some_slave;
      end if;
    end if;

  end process;

  --some slave is getting selected, which is an e_mux
  cpu_data_master_is_granted_some_slave <= ((((((((cpu_data_master_granted_cpu_jtag_debug_module OR cpu_data_master_granted_data_pio_s1) OR cpu_data_master_granted_jtag_uart_avalon_jtag_slave) OR cpu_data_master_granted_note_1_pio_s1) OR cpu_data_master_granted_note_2_pio_s1) OR cpu_data_master_granted_note_3_pio_s1) OR cpu_data_master_granted_note_4_pio_s1) OR cpu_data_master_granted_note_5_pio_s1) OR cpu_data_master_granted_sram_sram_slave) OR cpu_data_master_granted_status_pio_s1;
  --latent slave read data valids which may be flushed, which is an e_mux
  pre_flush_cpu_data_master_readdatavalid <= std_logic'('0');
  --latent slave read data valid which is not flushed, which is an e_mux
  cpu_data_master_readdatavalid <= ((((((((((((((((((((((((((((cpu_data_master_read_but_no_slave_selected OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_cpu_jtag_debug_module) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_data_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_note_1_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_note_2_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_note_3_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_note_4_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_note_5_pio_s1) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR ((cpu_data_master_read_data_valid_sram_sram_slave AND dbs_counter_overflow))) OR cpu_data_master_read_but_no_slave_selected) OR pre_flush_cpu_data_master_readdatavalid) OR cpu_data_master_read_data_valid_status_pio_s1;
  --cpu/data_master readdata mux, which is an e_mux
  cpu_data_master_readdata <= (((((A_REP(NOT ((cpu_data_master_qualified_request_cpu_jtag_debug_module AND cpu_data_master_read)) , 32) OR cpu_jtag_debug_module_readdata_from_sa)) AND ((A_REP(NOT ((cpu_data_master_qualified_request_data_pio_s1 AND cpu_data_master_read)) , 32) OR (std_logic_vector'("000000000000000000000000") & (data_pio_s1_readdata_from_sa))))) AND ((A_REP(NOT ((cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave AND cpu_data_master_read)) , 32) OR jtag_uart_avalon_jtag_slave_readdata_from_sa))) AND ((A_REP(NOT ((cpu_data_master_qualified_request_sram_sram_slave AND cpu_data_master_read)) , 32) OR Std_Logic_Vector'(sram_sram_slave_readdata_from_sa(15 DOWNTO 0) & dbs_16_reg_segment_0)))) AND ((A_REP(NOT ((cpu_data_master_qualified_request_status_pio_s1 AND cpu_data_master_read)) , 32) OR (std_logic_vector'("000000000000000000000000") & (status_pio_s1_readdata_from_sa))));
  --actual waitrequest port, which is an e_assign
  internal_cpu_data_master_waitrequest <= NOT cpu_data_master_run;
  --latent max counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_data_master_latency_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        internal_cpu_data_master_latency_counter <= p1_cpu_data_master_latency_counter;
      end if;
    end if;

  end process;

  --latency counter load mux, which is an e_mux
  p1_cpu_data_master_latency_counter <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(((cpu_data_master_run AND cpu_data_master_read))) = '1'), (std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(latency_load_value))), A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_latency_counter)) = '1'), ((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(internal_cpu_data_master_latency_counter))) - std_logic_vector'("000000000000000000000000000000001")), std_logic_vector'("000000000000000000000000000000000"))));
  --read latency load values, which is an e_mux
  latency_load_value <= std_logic'('0');
  --irq assign, which is an e_assign
  cpu_data_master_irq <= Std_Logic_Vector'(A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(std_logic'('0')) & A_ToStdLogicVector(jtag_uart_avalon_jtag_slave_irq_from_sa));
  --pre dbs count enable, which is an e_mux
  pre_dbs_count_enable <= Vector_To_Std_Logic((((((((NOT std_logic_vector'("00000000000000000000000000000000")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_requests_sram_sram_slave)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_write)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT(or_reduce(cpu_data_master_byteenable_sram_sram_slave))))))) OR (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_data_master_granted_sram_sram_slave AND cpu_data_master_read)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_sram_sram_slave_end_xfer)))))) OR ((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_data_master_granted_sram_sram_slave AND cpu_data_master_write)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")))));
  --input to dbs-16 stored 0, which is an e_mux
  p1_dbs_16_reg_segment_0 <= sram_sram_slave_readdata_from_sa;
  --dbs register for dbs-16 segment 0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      dbs_16_reg_segment_0 <= std_logic_vector'("0000000000000000");
    elsif clk'event and clk = '1' then
      if std_logic'((dbs_count_enable AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_data_master_dbs_address(1))))) = std_logic_vector'("00000000000000000000000000000000")))))) = '1' then 
        dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
      end if;
    end if;

  end process;

  --mux write dbs 1, which is an e_mux
  cpu_data_master_dbs_write_16 <= A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_dbs_address(1))) = '1'), cpu_data_master_writedata(31 DOWNTO 16), cpu_data_master_writedata(15 DOWNTO 0));
  --dbs count increment, which is an e_mux
  cpu_data_master_dbs_increment <= A_EXT (A_WE_StdLogicVector((std_logic'((cpu_data_master_requests_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000000")), 2);
  --dbs counter overflow, which is an e_assign
  dbs_counter_overflow <= internal_cpu_data_master_dbs_address(1) AND NOT((next_dbs_address(1)));
  --next master address, which is an e_assign
  next_dbs_address <= A_EXT (((std_logic_vector'("0") & (internal_cpu_data_master_dbs_address)) + (std_logic_vector'("0") & (cpu_data_master_dbs_increment))), 2);
  --dbs count enable, which is an e_mux
  dbs_count_enable <= pre_dbs_count_enable;
  --dbs counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_data_master_dbs_address <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(dbs_count_enable) = '1' then 
        internal_cpu_data_master_dbs_address <= next_dbs_address;
      end if;
    end if;

  end process;

  --vhdl renameroo for output signals
  cpu_data_master_address_to_slave <= internal_cpu_data_master_address_to_slave;
  --vhdl renameroo for output signals
  cpu_data_master_dbs_address <= internal_cpu_data_master_dbs_address;
  --vhdl renameroo for output signals
  cpu_data_master_latency_counter <= internal_cpu_data_master_latency_counter;
  --vhdl renameroo for output signals
  cpu_data_master_waitrequest <= internal_cpu_data_master_waitrequest;
--synthesis translate_off
    --cpu_data_master_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_data_master_address_last_time <= std_logic_vector'("000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_data_master_address_last_time <= cpu_data_master_address;
        end if;
      end if;

    end process;

    --cpu/data_master waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_cpu_data_master_waitrequest AND ((cpu_data_master_read OR cpu_data_master_write));
        end if;
      end if;

    end process;

    --cpu_data_master_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_data_master_address, cpu_data_master_address_last_time)
    VARIABLE write_line2 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((cpu_data_master_address /= cpu_data_master_address_last_time))))) = '1' then 
          write(write_line2, now);
          write(write_line2, string'(": "));
          write(write_line2, string'("cpu_data_master_address did not heed wait!!!"));
          write(output, write_line2.all);
          deallocate (write_line2);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --cpu_data_master_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_data_master_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_data_master_read_last_time <= cpu_data_master_read;
        end if;
      end if;

    end process;

    --cpu_data_master_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_data_master_read, cpu_data_master_read_last_time)
    VARIABLE write_line3 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(cpu_data_master_read) /= std_logic'(cpu_data_master_read_last_time)))))) = '1' then 
          write(write_line3, now);
          write(write_line3, string'(": "));
          write(write_line3, string'("cpu_data_master_read did not heed wait!!!"));
          write(output, write_line3.all);
          deallocate (write_line3);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --cpu_data_master_write check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_data_master_write_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_data_master_write_last_time <= cpu_data_master_write;
        end if;
      end if;

    end process;

    --cpu_data_master_write matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_data_master_write, cpu_data_master_write_last_time)
    VARIABLE write_line4 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(cpu_data_master_write) /= std_logic'(cpu_data_master_write_last_time)))))) = '1' then 
          write(write_line4, now);
          write(write_line4, string'(": "));
          write(write_line4, string'("cpu_data_master_write did not heed wait!!!"));
          write(output, write_line4.all);
          deallocate (write_line4);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --cpu_data_master_writedata check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_data_master_writedata_last_time <= std_logic_vector'("00000000000000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_data_master_writedata_last_time <= cpu_data_master_writedata;
        end if;
      end if;

    end process;

    --cpu_data_master_writedata matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_data_master_write, cpu_data_master_writedata, cpu_data_master_writedata_last_time)
    VARIABLE write_line5 : line;
    begin
        if std_logic'(((active_and_waiting_last_time AND to_std_logic(((cpu_data_master_writedata /= cpu_data_master_writedata_last_time)))) AND cpu_data_master_write)) = '1' then 
          write(write_line5, now);
          write(write_line5, string'(": "));
          write(write_line5, string'("cpu_data_master_writedata did not heed wait!!!"));
          write(output, write_line5.all);
          deallocate (write_line5);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity cpu_instruction_master_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_instruction_master_address : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_instruction_master_granted_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_instruction_master_granted_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_instruction_master_qualified_request_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_instruction_master_qualified_request_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_instruction_master_read : IN STD_LOGIC;
                 signal cpu_instruction_master_read_data_valid_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_instruction_master_read_data_valid_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_instruction_master_requests_cpu_jtag_debug_module : IN STD_LOGIC;
                 signal cpu_instruction_master_requests_sram_sram_slave : IN STD_LOGIC;
                 signal cpu_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal d1_cpu_jtag_debug_module_end_xfer : IN STD_LOGIC;
                 signal d1_sram_sram_slave_end_xfer : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sram_sram_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- outputs:
                 signal cpu_instruction_master_address_to_slave : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_instruction_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_instruction_master_latency_counter : OUT STD_LOGIC;
                 signal cpu_instruction_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal cpu_instruction_master_readdatavalid : OUT STD_LOGIC;
                 signal cpu_instruction_master_waitrequest : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of cpu_instruction_master_arbitrator : entity is FALSE;
end entity cpu_instruction_master_arbitrator;


architecture europa of cpu_instruction_master_arbitrator is
                signal active_and_waiting_last_time :  STD_LOGIC;
                signal cpu_instruction_master_address_last_time :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_instruction_master_dbs_increment :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_instruction_master_is_granted_some_slave :  STD_LOGIC;
                signal cpu_instruction_master_read_but_no_slave_selected :  STD_LOGIC;
                signal cpu_instruction_master_read_last_time :  STD_LOGIC;
                signal cpu_instruction_master_run :  STD_LOGIC;
                signal dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal dbs_count_enable :  STD_LOGIC;
                signal dbs_counter_overflow :  STD_LOGIC;
                signal internal_cpu_instruction_master_address_to_slave :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal internal_cpu_instruction_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_instruction_master_latency_counter :  STD_LOGIC;
                signal internal_cpu_instruction_master_waitrequest :  STD_LOGIC;
                signal latency_load_value :  STD_LOGIC;
                signal next_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal p1_cpu_instruction_master_latency_counter :  STD_LOGIC;
                signal p1_dbs_16_reg_segment_0 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal pre_dbs_count_enable :  STD_LOGIC;
                signal pre_flush_cpu_instruction_master_readdatavalid :  STD_LOGIC;
                signal r_0 :  STD_LOGIC;
                signal r_1 :  STD_LOGIC;

begin

  --r_0 master_run cascaded wait assignment, which is an e_assign
  r_0 <= Vector_To_Std_Logic((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_instruction_master_qualified_request_cpu_jtag_debug_module OR NOT cpu_instruction_master_requests_cpu_jtag_debug_module)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_instruction_master_granted_cpu_jtag_debug_module OR NOT cpu_instruction_master_qualified_request_cpu_jtag_debug_module)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_instruction_master_qualified_request_cpu_jtag_debug_module OR NOT cpu_instruction_master_read)))) OR (((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_cpu_jtag_debug_module_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_read)))))))));
  --cascaded wait assignment, which is an e_assign
  cpu_instruction_master_run <= r_0 AND r_1;
  --r_1 master_run cascaded wait assignment, which is an e_assign
  r_1 <= Vector_To_Std_Logic((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_instruction_master_qualified_request_sram_sram_slave OR NOT cpu_instruction_master_requests_sram_sram_slave)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(((cpu_instruction_master_granted_sram_sram_slave OR NOT cpu_instruction_master_qualified_request_sram_sram_slave)))))) AND (((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((NOT cpu_instruction_master_qualified_request_sram_sram_slave OR NOT cpu_instruction_master_read)))) OR ((((std_logic_vector'("00000000000000000000000000000001") AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_sram_sram_slave_end_xfer)))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_instruction_master_dbs_address(1)))))) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_read)))))))));
  --optimize select-logic by passing only those address bits which matter.
  internal_cpu_instruction_master_address_to_slave <= cpu_instruction_master_address(20 DOWNTO 0);
  --cpu_instruction_master_read_but_no_slave_selected assignment, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      cpu_instruction_master_read_but_no_slave_selected <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        cpu_instruction_master_read_but_no_slave_selected <= (cpu_instruction_master_read AND cpu_instruction_master_run) AND NOT cpu_instruction_master_is_granted_some_slave;
      end if;
    end if;

  end process;

  --some slave is getting selected, which is an e_mux
  cpu_instruction_master_is_granted_some_slave <= cpu_instruction_master_granted_cpu_jtag_debug_module OR cpu_instruction_master_granted_sram_sram_slave;
  --latent slave read data valids which may be flushed, which is an e_mux
  pre_flush_cpu_instruction_master_readdatavalid <= std_logic'('0');
  --latent slave read data valid which is not flushed, which is an e_mux
  cpu_instruction_master_readdatavalid <= ((((cpu_instruction_master_read_but_no_slave_selected OR pre_flush_cpu_instruction_master_readdatavalid) OR cpu_instruction_master_read_data_valid_cpu_jtag_debug_module) OR cpu_instruction_master_read_but_no_slave_selected) OR pre_flush_cpu_instruction_master_readdatavalid) OR ((cpu_instruction_master_read_data_valid_sram_sram_slave AND dbs_counter_overflow));
  --cpu/instruction_master readdata mux, which is an e_mux
  cpu_instruction_master_readdata <= ((A_REP(NOT ((cpu_instruction_master_qualified_request_cpu_jtag_debug_module AND cpu_instruction_master_read)) , 32) OR cpu_jtag_debug_module_readdata_from_sa)) AND ((A_REP(NOT ((cpu_instruction_master_qualified_request_sram_sram_slave AND cpu_instruction_master_read)) , 32) OR Std_Logic_Vector'(sram_sram_slave_readdata_from_sa(15 DOWNTO 0) & dbs_16_reg_segment_0)));
  --actual waitrequest port, which is an e_assign
  internal_cpu_instruction_master_waitrequest <= NOT cpu_instruction_master_run;
  --latent max counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_instruction_master_latency_counter <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        internal_cpu_instruction_master_latency_counter <= p1_cpu_instruction_master_latency_counter;
      end if;
    end if;

  end process;

  --latency counter load mux, which is an e_mux
  p1_cpu_instruction_master_latency_counter <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(((cpu_instruction_master_run AND cpu_instruction_master_read))) = '1'), (std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(latency_load_value))), A_WE_StdLogicVector((std_logic'((internal_cpu_instruction_master_latency_counter)) = '1'), ((std_logic_vector'("00000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(internal_cpu_instruction_master_latency_counter))) - std_logic_vector'("000000000000000000000000000000001")), std_logic_vector'("000000000000000000000000000000000"))));
  --read latency load values, which is an e_mux
  latency_load_value <= std_logic'('0');
  --input to dbs-16 stored 0, which is an e_mux
  p1_dbs_16_reg_segment_0 <= sram_sram_slave_readdata_from_sa;
  --dbs register for dbs-16 segment 0, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      dbs_16_reg_segment_0 <= std_logic_vector'("0000000000000000");
    elsif clk'event and clk = '1' then
      if std_logic'((dbs_count_enable AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((internal_cpu_instruction_master_dbs_address(1))))) = std_logic_vector'("00000000000000000000000000000000")))))) = '1' then 
        dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
      end if;
    end if;

  end process;

  --dbs count increment, which is an e_mux
  cpu_instruction_master_dbs_increment <= A_EXT (A_WE_StdLogicVector((std_logic'((cpu_instruction_master_requests_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000000")), 2);
  --dbs counter overflow, which is an e_assign
  dbs_counter_overflow <= internal_cpu_instruction_master_dbs_address(1) AND NOT((next_dbs_address(1)));
  --next master address, which is an e_assign
  next_dbs_address <= A_EXT (((std_logic_vector'("0") & (internal_cpu_instruction_master_dbs_address)) + (std_logic_vector'("0") & (cpu_instruction_master_dbs_increment))), 2);
  --dbs count enable, which is an e_mux
  dbs_count_enable <= pre_dbs_count_enable;
  --dbs counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      internal_cpu_instruction_master_dbs_address <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(dbs_count_enable) = '1' then 
        internal_cpu_instruction_master_dbs_address <= next_dbs_address;
      end if;
    end if;

  end process;

  --pre dbs count enable, which is an e_mux
  pre_dbs_count_enable <= Vector_To_Std_Logic(((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR((cpu_instruction_master_granted_sram_sram_slave AND cpu_instruction_master_read)))) AND std_logic_vector'("00000000000000000000000000000001")) AND std_logic_vector'("00000000000000000000000000000001")) AND (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT d1_sram_sram_slave_end_xfer)))));
  --vhdl renameroo for output signals
  cpu_instruction_master_address_to_slave <= internal_cpu_instruction_master_address_to_slave;
  --vhdl renameroo for output signals
  cpu_instruction_master_dbs_address <= internal_cpu_instruction_master_dbs_address;
  --vhdl renameroo for output signals
  cpu_instruction_master_latency_counter <= internal_cpu_instruction_master_latency_counter;
  --vhdl renameroo for output signals
  cpu_instruction_master_waitrequest <= internal_cpu_instruction_master_waitrequest;
--synthesis translate_off
    --cpu_instruction_master_address check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_instruction_master_address_last_time <= std_logic_vector'("000000000000000000000");
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_instruction_master_address_last_time <= cpu_instruction_master_address;
        end if;
      end if;

    end process;

    --cpu/instruction_master waited last time, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        active_and_waiting_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          active_and_waiting_last_time <= internal_cpu_instruction_master_waitrequest AND (cpu_instruction_master_read);
        end if;
      end if;

    end process;

    --cpu_instruction_master_address matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_instruction_master_address, cpu_instruction_master_address_last_time)
    VARIABLE write_line6 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((cpu_instruction_master_address /= cpu_instruction_master_address_last_time))))) = '1' then 
          write(write_line6, now);
          write(write_line6, string'(": "));
          write(write_line6, string'("cpu_instruction_master_address did not heed wait!!!"));
          write(output, write_line6.all);
          deallocate (write_line6);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

    --cpu_instruction_master_read check against wait, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        cpu_instruction_master_read_last_time <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          cpu_instruction_master_read_last_time <= cpu_instruction_master_read;
        end if;
      end if;

    end process;

    --cpu_instruction_master_read matches last port_name, which is an e_process
    process (active_and_waiting_last_time, cpu_instruction_master_read, cpu_instruction_master_read_last_time)
    VARIABLE write_line7 : line;
    begin
        if std_logic'((active_and_waiting_last_time AND to_std_logic(((std_logic'(cpu_instruction_master_read) /= std_logic'(cpu_instruction_master_read_last_time)))))) = '1' then 
          write(write_line7, now);
          write(write_line7, string'(": "));
          write(write_line7, string'("cpu_instruction_master_read did not heed wait!!!"));
          write(output, write_line7.all);
          deallocate (write_line7);
          assert false report "VHDL STOP" severity failure;
        end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity data_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal data_pio_s1_readdata : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_data_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_data_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_data_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_data_pio_s1 : OUT STD_LOGIC;
                 signal d1_data_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal data_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal data_pio_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal data_pio_s1_reset_n : OUT STD_LOGIC
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of data_pio_s1_arbitrator : entity is FALSE;
end entity data_pio_s1_arbitrator;


architecture europa of data_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_data_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal data_pio_s1_allgrants :  STD_LOGIC;
                signal data_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal data_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal data_pio_s1_any_continuerequest :  STD_LOGIC;
                signal data_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal data_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal data_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal data_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal data_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal data_pio_s1_begins_xfer :  STD_LOGIC;
                signal data_pio_s1_end_xfer :  STD_LOGIC;
                signal data_pio_s1_firsttransfer :  STD_LOGIC;
                signal data_pio_s1_grant_vector :  STD_LOGIC;
                signal data_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal data_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal data_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal data_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal data_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal data_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal data_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal data_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal data_pio_s1_waits_for_read :  STD_LOGIC;
                signal data_pio_s1_waits_for_write :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_data_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_data_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_data_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_data_pio_s1 :  STD_LOGIC;
                signal shifted_address_to_data_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_data_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT data_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  data_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_data_pio_s1);
  --assign data_pio_s1_readdata_from_sa = data_pio_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  data_pio_s1_readdata_from_sa <= data_pio_s1_readdata;
  internal_cpu_data_master_requests_data_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000000000000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_read;
  --data_pio_s1_arb_share_counter set values, which is an e_mux
  data_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --data_pio_s1_non_bursting_master_requests mux, which is an e_mux
  data_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_data_pio_s1;
  --data_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  data_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --data_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  data_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(data_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (data_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(data_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (data_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --data_pio_s1_allgrants all slave grants, which is an e_mux
  data_pio_s1_allgrants <= data_pio_s1_grant_vector;
  --data_pio_s1_end_xfer assignment, which is an e_assign
  data_pio_s1_end_xfer <= NOT ((data_pio_s1_waits_for_read OR data_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_data_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_data_pio_s1 <= data_pio_s1_end_xfer AND (((NOT data_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --data_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  data_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_data_pio_s1 AND data_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_data_pio_s1 AND NOT data_pio_s1_non_bursting_master_requests));
  --data_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(data_pio_s1_arb_counter_enable) = '1' then 
        data_pio_s1_arb_share_counter <= data_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --data_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((data_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_data_pio_s1)) OR ((end_xfer_arb_share_counter_term_data_pio_s1 AND NOT data_pio_s1_non_bursting_master_requests)))) = '1' then 
        data_pio_s1_slavearbiterlockenable <= or_reduce(data_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master data_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= data_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --data_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  data_pio_s1_slavearbiterlockenable2 <= or_reduce(data_pio_s1_arb_share_counter_next_value);
  --cpu/data_master data_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= data_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --data_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  data_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_data_pio_s1 <= internal_cpu_data_master_requests_data_pio_s1 AND NOT ((cpu_data_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000"))))));
  --local readdatavalid cpu_data_master_read_data_valid_data_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_data_pio_s1 <= (internal_cpu_data_master_granted_data_pio_s1 AND cpu_data_master_read) AND NOT data_pio_s1_waits_for_read;
  --master is always granted when requested
  internal_cpu_data_master_granted_data_pio_s1 <= internal_cpu_data_master_qualified_request_data_pio_s1;
  --cpu/data_master saved-grant data_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_data_pio_s1 <= internal_cpu_data_master_requests_data_pio_s1;
  --allow new arb cycle for data_pio/s1, which is an e_assign
  data_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  data_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  data_pio_s1_master_qreq_vector <= std_logic'('1');
  --data_pio_s1_reset_n assignment, which is an e_assign
  data_pio_s1_reset_n <= reset_n;
  --data_pio_s1_firsttransfer first transaction, which is an e_assign
  data_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(data_pio_s1_begins_xfer) = '1'), data_pio_s1_unreg_firsttransfer, data_pio_s1_reg_firsttransfer);
  --data_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  data_pio_s1_unreg_firsttransfer <= NOT ((data_pio_s1_slavearbiterlockenable AND data_pio_s1_any_continuerequest));
  --data_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(data_pio_s1_begins_xfer) = '1' then 
        data_pio_s1_reg_firsttransfer <= data_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --data_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  data_pio_s1_beginbursttransfer_internal <= data_pio_s1_begins_xfer;
  shifted_address_to_data_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --data_pio_s1_address mux, which is an e_mux
  data_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_data_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_data_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_data_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_data_pio_s1_end_xfer <= data_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --data_pio_s1_waits_for_read in a cycle, which is an e_mux
  data_pio_s1_waits_for_read <= data_pio_s1_in_a_read_cycle AND data_pio_s1_begins_xfer;
  --data_pio_s1_in_a_read_cycle assignment, which is an e_assign
  data_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_data_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= data_pio_s1_in_a_read_cycle;
  --data_pio_s1_waits_for_write in a cycle, which is an e_mux
  data_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(data_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --data_pio_s1_in_a_write_cycle assignment, which is an e_assign
  data_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_data_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= data_pio_s1_in_a_write_cycle;
  wait_for_data_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_data_pio_s1 <= internal_cpu_data_master_granted_data_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_data_pio_s1 <= internal_cpu_data_master_qualified_request_data_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_data_pio_s1 <= internal_cpu_data_master_requests_data_pio_s1;
--synthesis translate_off
    --data_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity jtag_uart_avalon_jtag_slave_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_avalon_jtag_slave_dataavailable : IN STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_irq : IN STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_avalon_jtag_slave_readyfordata : IN STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_waitrequest : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                 signal cpu_data_master_requests_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                 signal d1_jtag_uart_avalon_jtag_slave_end_xfer : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_address : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_chipselect : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_dataavailable_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_irq_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_read_n : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal jtag_uart_avalon_jtag_slave_readyfordata_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_reset_n : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_waitrequest_from_sa : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_write_n : OUT STD_LOGIC;
                 signal jtag_uart_avalon_jtag_slave_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of jtag_uart_avalon_jtag_slave_arbitrator : entity is FALSE;
end entity jtag_uart_avalon_jtag_slave_arbitrator;


architecture europa of jtag_uart_avalon_jtag_slave_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal internal_jtag_uart_avalon_jtag_slave_waitrequest_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_allgrants :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_allow_new_arb_cycle :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_any_continuerequest :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_arb_counter_enable :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_beginbursttransfer_internal :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_begins_xfer :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_end_xfer :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_firsttransfer :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_grant_vector :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_in_a_read_cycle :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_in_a_write_cycle :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_master_qreq_vector :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_non_bursting_master_requests :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_reg_firsttransfer :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_slavearbiterlockenable :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_unreg_firsttransfer :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_waits_for_read :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_jtag_uart_avalon_jtag_slave_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT jtag_uart_avalon_jtag_slave_end_xfer;
      end if;
    end if;

  end process;

  jtag_uart_avalon_jtag_slave_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave);
  --assign jtag_uart_avalon_jtag_slave_readdata_from_sa = jtag_uart_avalon_jtag_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_avalon_jtag_slave_readdata_from_sa <= jtag_uart_avalon_jtag_slave_readdata;
  internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave <= to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 3) & std_logic_vector'("000")) = std_logic_vector'("100000001000001110000")))) AND ((cpu_data_master_read OR cpu_data_master_write));
  --assign jtag_uart_avalon_jtag_slave_dataavailable_from_sa = jtag_uart_avalon_jtag_slave_dataavailable so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_avalon_jtag_slave_dataavailable_from_sa <= jtag_uart_avalon_jtag_slave_dataavailable;
  --assign jtag_uart_avalon_jtag_slave_readyfordata_from_sa = jtag_uart_avalon_jtag_slave_readyfordata so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_avalon_jtag_slave_readyfordata_from_sa <= jtag_uart_avalon_jtag_slave_readyfordata;
  --assign jtag_uart_avalon_jtag_slave_waitrequest_from_sa = jtag_uart_avalon_jtag_slave_waitrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  internal_jtag_uart_avalon_jtag_slave_waitrequest_from_sa <= jtag_uart_avalon_jtag_slave_waitrequest;
  --jtag_uart_avalon_jtag_slave_arb_share_counter set values, which is an e_mux
  jtag_uart_avalon_jtag_slave_arb_share_set_values <= std_logic_vector'("01");
  --jtag_uart_avalon_jtag_slave_non_bursting_master_requests mux, which is an e_mux
  jtag_uart_avalon_jtag_slave_non_bursting_master_requests <= internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  --jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant mux, which is an e_mux
  jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant <= std_logic'('0');
  --jtag_uart_avalon_jtag_slave_arb_share_counter_next_value assignment, which is an e_assign
  jtag_uart_avalon_jtag_slave_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(jtag_uart_avalon_jtag_slave_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (jtag_uart_avalon_jtag_slave_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(jtag_uart_avalon_jtag_slave_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (jtag_uart_avalon_jtag_slave_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --jtag_uart_avalon_jtag_slave_allgrants all slave grants, which is an e_mux
  jtag_uart_avalon_jtag_slave_allgrants <= jtag_uart_avalon_jtag_slave_grant_vector;
  --jtag_uart_avalon_jtag_slave_end_xfer assignment, which is an e_assign
  jtag_uart_avalon_jtag_slave_end_xfer <= NOT ((jtag_uart_avalon_jtag_slave_waits_for_read OR jtag_uart_avalon_jtag_slave_waits_for_write));
  --end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave <= jtag_uart_avalon_jtag_slave_end_xfer AND (((NOT jtag_uart_avalon_jtag_slave_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --jtag_uart_avalon_jtag_slave_arb_share_counter arbitration counter enable, which is an e_assign
  jtag_uart_avalon_jtag_slave_arb_counter_enable <= ((end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave AND jtag_uart_avalon_jtag_slave_allgrants)) OR ((end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave AND NOT jtag_uart_avalon_jtag_slave_non_bursting_master_requests));
  --jtag_uart_avalon_jtag_slave_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_avalon_jtag_slave_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(jtag_uart_avalon_jtag_slave_arb_counter_enable) = '1' then 
        jtag_uart_avalon_jtag_slave_arb_share_counter <= jtag_uart_avalon_jtag_slave_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --jtag_uart_avalon_jtag_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_avalon_jtag_slave_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((jtag_uart_avalon_jtag_slave_master_qreq_vector AND end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave)) OR ((end_xfer_arb_share_counter_term_jtag_uart_avalon_jtag_slave AND NOT jtag_uart_avalon_jtag_slave_non_bursting_master_requests)))) = '1' then 
        jtag_uart_avalon_jtag_slave_slavearbiterlockenable <= or_reduce(jtag_uart_avalon_jtag_slave_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master jtag_uart/avalon_jtag_slave arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= jtag_uart_avalon_jtag_slave_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 <= or_reduce(jtag_uart_avalon_jtag_slave_arb_share_counter_next_value);
  --cpu/data_master jtag_uart/avalon_jtag_slave arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= jtag_uart_avalon_jtag_slave_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --jtag_uart_avalon_jtag_slave_any_continuerequest at least one master continues requesting, which is an e_assign
  jtag_uart_avalon_jtag_slave_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave AND NOT ((cpu_data_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000"))))));
  --local readdatavalid cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave, which is an e_mux
  cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave <= (internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave AND cpu_data_master_read) AND NOT jtag_uart_avalon_jtag_slave_waits_for_read;
  --jtag_uart_avalon_jtag_slave_writedata mux, which is an e_mux
  jtag_uart_avalon_jtag_slave_writedata <= cpu_data_master_writedata;
  --master is always granted when requested
  internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  --cpu/data_master saved-grant jtag_uart/avalon_jtag_slave, which is an e_assign
  cpu_data_master_saved_grant_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  --allow new arb cycle for jtag_uart/avalon_jtag_slave, which is an e_assign
  jtag_uart_avalon_jtag_slave_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  jtag_uart_avalon_jtag_slave_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  jtag_uart_avalon_jtag_slave_master_qreq_vector <= std_logic'('1');
  --jtag_uart_avalon_jtag_slave_reset_n assignment, which is an e_assign
  jtag_uart_avalon_jtag_slave_reset_n <= reset_n;
  jtag_uart_avalon_jtag_slave_chipselect <= internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  --jtag_uart_avalon_jtag_slave_firsttransfer first transaction, which is an e_assign
  jtag_uart_avalon_jtag_slave_firsttransfer <= A_WE_StdLogic((std_logic'(jtag_uart_avalon_jtag_slave_begins_xfer) = '1'), jtag_uart_avalon_jtag_slave_unreg_firsttransfer, jtag_uart_avalon_jtag_slave_reg_firsttransfer);
  --jtag_uart_avalon_jtag_slave_unreg_firsttransfer first transaction, which is an e_assign
  jtag_uart_avalon_jtag_slave_unreg_firsttransfer <= NOT ((jtag_uart_avalon_jtag_slave_slavearbiterlockenable AND jtag_uart_avalon_jtag_slave_any_continuerequest));
  --jtag_uart_avalon_jtag_slave_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      jtag_uart_avalon_jtag_slave_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(jtag_uart_avalon_jtag_slave_begins_xfer) = '1' then 
        jtag_uart_avalon_jtag_slave_reg_firsttransfer <= jtag_uart_avalon_jtag_slave_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --jtag_uart_avalon_jtag_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  jtag_uart_avalon_jtag_slave_beginbursttransfer_internal <= jtag_uart_avalon_jtag_slave_begins_xfer;
  --~jtag_uart_avalon_jtag_slave_read_n assignment, which is an e_mux
  jtag_uart_avalon_jtag_slave_read_n <= NOT ((internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave AND cpu_data_master_read));
  --~jtag_uart_avalon_jtag_slave_write_n assignment, which is an e_mux
  jtag_uart_avalon_jtag_slave_write_n <= NOT ((internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave AND cpu_data_master_write));
  shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --jtag_uart_avalon_jtag_slave_address mux, which is an e_mux
  jtag_uart_avalon_jtag_slave_address <= Vector_To_Std_Logic(A_SRL(shifted_address_to_jtag_uart_avalon_jtag_slave_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")));
  --d1_jtag_uart_avalon_jtag_slave_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_jtag_uart_avalon_jtag_slave_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_jtag_uart_avalon_jtag_slave_end_xfer <= jtag_uart_avalon_jtag_slave_end_xfer;
      end if;
    end if;

  end process;

  --jtag_uart_avalon_jtag_slave_waits_for_read in a cycle, which is an e_mux
  jtag_uart_avalon_jtag_slave_waits_for_read <= jtag_uart_avalon_jtag_slave_in_a_read_cycle AND internal_jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  --jtag_uart_avalon_jtag_slave_in_a_read_cycle assignment, which is an e_assign
  jtag_uart_avalon_jtag_slave_in_a_read_cycle <= internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= jtag_uart_avalon_jtag_slave_in_a_read_cycle;
  --jtag_uart_avalon_jtag_slave_waits_for_write in a cycle, which is an e_mux
  jtag_uart_avalon_jtag_slave_waits_for_write <= jtag_uart_avalon_jtag_slave_in_a_write_cycle AND internal_jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
  --jtag_uart_avalon_jtag_slave_in_a_write_cycle assignment, which is an e_assign
  jtag_uart_avalon_jtag_slave_in_a_write_cycle <= internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= jtag_uart_avalon_jtag_slave_in_a_write_cycle;
  wait_for_jtag_uart_avalon_jtag_slave_counter <= std_logic'('0');
  --assign jtag_uart_avalon_jtag_slave_irq_from_sa = jtag_uart_avalon_jtag_slave_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  jtag_uart_avalon_jtag_slave_irq_from_sa <= jtag_uart_avalon_jtag_slave_irq;
  --vhdl renameroo for output signals
  cpu_data_master_granted_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_granted_jtag_uart_avalon_jtag_slave;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave;
  --vhdl renameroo for output signals
  cpu_data_master_requests_jtag_uart_avalon_jtag_slave <= internal_cpu_data_master_requests_jtag_uart_avalon_jtag_slave;
  --vhdl renameroo for output signals
  jtag_uart_avalon_jtag_slave_waitrequest_from_sa <= internal_jtag_uart_avalon_jtag_slave_waitrequest_from_sa;
--synthesis translate_off
    --jtag_uart/avalon_jtag_slave enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity note_1_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_note_1_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_1_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_1_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_note_1_pio_s1 : OUT STD_LOGIC;
                 signal d1_note_1_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal note_1_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal note_1_pio_s1_chipselect : OUT STD_LOGIC;
                 signal note_1_pio_s1_reset_n : OUT STD_LOGIC;
                 signal note_1_pio_s1_write_n : OUT STD_LOGIC;
                 signal note_1_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of note_1_pio_s1_arbitrator : entity is FALSE;
end entity note_1_pio_s1_arbitrator;


architecture europa of note_1_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_note_1_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_note_1_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_note_1_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_note_1_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_note_1_pio_s1 :  STD_LOGIC;
                signal note_1_pio_s1_allgrants :  STD_LOGIC;
                signal note_1_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal note_1_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal note_1_pio_s1_any_continuerequest :  STD_LOGIC;
                signal note_1_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal note_1_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_1_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_1_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_1_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal note_1_pio_s1_begins_xfer :  STD_LOGIC;
                signal note_1_pio_s1_end_xfer :  STD_LOGIC;
                signal note_1_pio_s1_firsttransfer :  STD_LOGIC;
                signal note_1_pio_s1_grant_vector :  STD_LOGIC;
                signal note_1_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal note_1_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal note_1_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal note_1_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal note_1_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal note_1_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal note_1_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal note_1_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal note_1_pio_s1_waits_for_read :  STD_LOGIC;
                signal note_1_pio_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_note_1_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_note_1_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT note_1_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  note_1_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_note_1_pio_s1);
  internal_cpu_data_master_requests_note_1_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000000100000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_write;
  --note_1_pio_s1_arb_share_counter set values, which is an e_mux
  note_1_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --note_1_pio_s1_non_bursting_master_requests mux, which is an e_mux
  note_1_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_note_1_pio_s1;
  --note_1_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  note_1_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --note_1_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  note_1_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(note_1_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_1_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(note_1_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_1_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --note_1_pio_s1_allgrants all slave grants, which is an e_mux
  note_1_pio_s1_allgrants <= note_1_pio_s1_grant_vector;
  --note_1_pio_s1_end_xfer assignment, which is an e_assign
  note_1_pio_s1_end_xfer <= NOT ((note_1_pio_s1_waits_for_read OR note_1_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_note_1_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_note_1_pio_s1 <= note_1_pio_s1_end_xfer AND (((NOT note_1_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --note_1_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  note_1_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_note_1_pio_s1 AND note_1_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_note_1_pio_s1 AND NOT note_1_pio_s1_non_bursting_master_requests));
  --note_1_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_1_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(note_1_pio_s1_arb_counter_enable) = '1' then 
        note_1_pio_s1_arb_share_counter <= note_1_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --note_1_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_1_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((note_1_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_note_1_pio_s1)) OR ((end_xfer_arb_share_counter_term_note_1_pio_s1 AND NOT note_1_pio_s1_non_bursting_master_requests)))) = '1' then 
        note_1_pio_s1_slavearbiterlockenable <= or_reduce(note_1_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master note_1_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= note_1_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --note_1_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  note_1_pio_s1_slavearbiterlockenable2 <= or_reduce(note_1_pio_s1_arb_share_counter_next_value);
  --cpu/data_master note_1_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= note_1_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --note_1_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  note_1_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_note_1_pio_s1 <= internal_cpu_data_master_requests_note_1_pio_s1;
  --local readdatavalid cpu_data_master_read_data_valid_note_1_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_note_1_pio_s1 <= (internal_cpu_data_master_granted_note_1_pio_s1 AND cpu_data_master_read) AND NOT note_1_pio_s1_waits_for_read;
  --note_1_pio_s1_writedata mux, which is an e_mux
  note_1_pio_s1_writedata <= cpu_data_master_writedata (15 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_note_1_pio_s1 <= internal_cpu_data_master_qualified_request_note_1_pio_s1;
  --cpu/data_master saved-grant note_1_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_note_1_pio_s1 <= internal_cpu_data_master_requests_note_1_pio_s1;
  --allow new arb cycle for note_1_pio/s1, which is an e_assign
  note_1_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  note_1_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  note_1_pio_s1_master_qreq_vector <= std_logic'('1');
  --note_1_pio_s1_reset_n assignment, which is an e_assign
  note_1_pio_s1_reset_n <= reset_n;
  note_1_pio_s1_chipselect <= internal_cpu_data_master_granted_note_1_pio_s1;
  --note_1_pio_s1_firsttransfer first transaction, which is an e_assign
  note_1_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(note_1_pio_s1_begins_xfer) = '1'), note_1_pio_s1_unreg_firsttransfer, note_1_pio_s1_reg_firsttransfer);
  --note_1_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  note_1_pio_s1_unreg_firsttransfer <= NOT ((note_1_pio_s1_slavearbiterlockenable AND note_1_pio_s1_any_continuerequest));
  --note_1_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_1_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(note_1_pio_s1_begins_xfer) = '1' then 
        note_1_pio_s1_reg_firsttransfer <= note_1_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --note_1_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  note_1_pio_s1_beginbursttransfer_internal <= note_1_pio_s1_begins_xfer;
  --~note_1_pio_s1_write_n assignment, which is an e_mux
  note_1_pio_s1_write_n <= NOT ((internal_cpu_data_master_granted_note_1_pio_s1 AND cpu_data_master_write));
  shifted_address_to_note_1_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --note_1_pio_s1_address mux, which is an e_mux
  note_1_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_note_1_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_note_1_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_note_1_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_note_1_pio_s1_end_xfer <= note_1_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --note_1_pio_s1_waits_for_read in a cycle, which is an e_mux
  note_1_pio_s1_waits_for_read <= note_1_pio_s1_in_a_read_cycle AND note_1_pio_s1_begins_xfer;
  --note_1_pio_s1_in_a_read_cycle assignment, which is an e_assign
  note_1_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_note_1_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= note_1_pio_s1_in_a_read_cycle;
  --note_1_pio_s1_waits_for_write in a cycle, which is an e_mux
  note_1_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(note_1_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --note_1_pio_s1_in_a_write_cycle assignment, which is an e_assign
  note_1_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_note_1_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= note_1_pio_s1_in_a_write_cycle;
  wait_for_note_1_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_note_1_pio_s1 <= internal_cpu_data_master_granted_note_1_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_note_1_pio_s1 <= internal_cpu_data_master_qualified_request_note_1_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_note_1_pio_s1 <= internal_cpu_data_master_requests_note_1_pio_s1;
--synthesis translate_off
    --note_1_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity note_2_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_note_2_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_2_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_2_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_note_2_pio_s1 : OUT STD_LOGIC;
                 signal d1_note_2_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal note_2_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal note_2_pio_s1_chipselect : OUT STD_LOGIC;
                 signal note_2_pio_s1_reset_n : OUT STD_LOGIC;
                 signal note_2_pio_s1_write_n : OUT STD_LOGIC;
                 signal note_2_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of note_2_pio_s1_arbitrator : entity is FALSE;
end entity note_2_pio_s1_arbitrator;


architecture europa of note_2_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_note_2_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_note_2_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_note_2_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_note_2_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_note_2_pio_s1 :  STD_LOGIC;
                signal note_2_pio_s1_allgrants :  STD_LOGIC;
                signal note_2_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal note_2_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal note_2_pio_s1_any_continuerequest :  STD_LOGIC;
                signal note_2_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal note_2_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_2_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_2_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_2_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal note_2_pio_s1_begins_xfer :  STD_LOGIC;
                signal note_2_pio_s1_end_xfer :  STD_LOGIC;
                signal note_2_pio_s1_firsttransfer :  STD_LOGIC;
                signal note_2_pio_s1_grant_vector :  STD_LOGIC;
                signal note_2_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal note_2_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal note_2_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal note_2_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal note_2_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal note_2_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal note_2_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal note_2_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal note_2_pio_s1_waits_for_read :  STD_LOGIC;
                signal note_2_pio_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_note_2_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_note_2_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT note_2_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  note_2_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_note_2_pio_s1);
  internal_cpu_data_master_requests_note_2_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000000110000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_write;
  --note_2_pio_s1_arb_share_counter set values, which is an e_mux
  note_2_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --note_2_pio_s1_non_bursting_master_requests mux, which is an e_mux
  note_2_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_note_2_pio_s1;
  --note_2_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  note_2_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --note_2_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  note_2_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(note_2_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_2_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(note_2_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_2_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --note_2_pio_s1_allgrants all slave grants, which is an e_mux
  note_2_pio_s1_allgrants <= note_2_pio_s1_grant_vector;
  --note_2_pio_s1_end_xfer assignment, which is an e_assign
  note_2_pio_s1_end_xfer <= NOT ((note_2_pio_s1_waits_for_read OR note_2_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_note_2_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_note_2_pio_s1 <= note_2_pio_s1_end_xfer AND (((NOT note_2_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --note_2_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  note_2_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_note_2_pio_s1 AND note_2_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_note_2_pio_s1 AND NOT note_2_pio_s1_non_bursting_master_requests));
  --note_2_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_2_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(note_2_pio_s1_arb_counter_enable) = '1' then 
        note_2_pio_s1_arb_share_counter <= note_2_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --note_2_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_2_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((note_2_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_note_2_pio_s1)) OR ((end_xfer_arb_share_counter_term_note_2_pio_s1 AND NOT note_2_pio_s1_non_bursting_master_requests)))) = '1' then 
        note_2_pio_s1_slavearbiterlockenable <= or_reduce(note_2_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master note_2_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= note_2_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --note_2_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  note_2_pio_s1_slavearbiterlockenable2 <= or_reduce(note_2_pio_s1_arb_share_counter_next_value);
  --cpu/data_master note_2_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= note_2_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --note_2_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  note_2_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_note_2_pio_s1 <= internal_cpu_data_master_requests_note_2_pio_s1;
  --local readdatavalid cpu_data_master_read_data_valid_note_2_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_note_2_pio_s1 <= (internal_cpu_data_master_granted_note_2_pio_s1 AND cpu_data_master_read) AND NOT note_2_pio_s1_waits_for_read;
  --note_2_pio_s1_writedata mux, which is an e_mux
  note_2_pio_s1_writedata <= cpu_data_master_writedata (15 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_note_2_pio_s1 <= internal_cpu_data_master_qualified_request_note_2_pio_s1;
  --cpu/data_master saved-grant note_2_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_note_2_pio_s1 <= internal_cpu_data_master_requests_note_2_pio_s1;
  --allow new arb cycle for note_2_pio/s1, which is an e_assign
  note_2_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  note_2_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  note_2_pio_s1_master_qreq_vector <= std_logic'('1');
  --note_2_pio_s1_reset_n assignment, which is an e_assign
  note_2_pio_s1_reset_n <= reset_n;
  note_2_pio_s1_chipselect <= internal_cpu_data_master_granted_note_2_pio_s1;
  --note_2_pio_s1_firsttransfer first transaction, which is an e_assign
  note_2_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(note_2_pio_s1_begins_xfer) = '1'), note_2_pio_s1_unreg_firsttransfer, note_2_pio_s1_reg_firsttransfer);
  --note_2_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  note_2_pio_s1_unreg_firsttransfer <= NOT ((note_2_pio_s1_slavearbiterlockenable AND note_2_pio_s1_any_continuerequest));
  --note_2_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_2_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(note_2_pio_s1_begins_xfer) = '1' then 
        note_2_pio_s1_reg_firsttransfer <= note_2_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --note_2_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  note_2_pio_s1_beginbursttransfer_internal <= note_2_pio_s1_begins_xfer;
  --~note_2_pio_s1_write_n assignment, which is an e_mux
  note_2_pio_s1_write_n <= NOT ((internal_cpu_data_master_granted_note_2_pio_s1 AND cpu_data_master_write));
  shifted_address_to_note_2_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --note_2_pio_s1_address mux, which is an e_mux
  note_2_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_note_2_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_note_2_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_note_2_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_note_2_pio_s1_end_xfer <= note_2_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --note_2_pio_s1_waits_for_read in a cycle, which is an e_mux
  note_2_pio_s1_waits_for_read <= note_2_pio_s1_in_a_read_cycle AND note_2_pio_s1_begins_xfer;
  --note_2_pio_s1_in_a_read_cycle assignment, which is an e_assign
  note_2_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_note_2_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= note_2_pio_s1_in_a_read_cycle;
  --note_2_pio_s1_waits_for_write in a cycle, which is an e_mux
  note_2_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(note_2_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --note_2_pio_s1_in_a_write_cycle assignment, which is an e_assign
  note_2_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_note_2_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= note_2_pio_s1_in_a_write_cycle;
  wait_for_note_2_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_note_2_pio_s1 <= internal_cpu_data_master_granted_note_2_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_note_2_pio_s1 <= internal_cpu_data_master_qualified_request_note_2_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_note_2_pio_s1 <= internal_cpu_data_master_requests_note_2_pio_s1;
--synthesis translate_off
    --note_2_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity note_3_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_note_3_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_3_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_3_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_note_3_pio_s1 : OUT STD_LOGIC;
                 signal d1_note_3_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal note_3_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal note_3_pio_s1_chipselect : OUT STD_LOGIC;
                 signal note_3_pio_s1_reset_n : OUT STD_LOGIC;
                 signal note_3_pio_s1_write_n : OUT STD_LOGIC;
                 signal note_3_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of note_3_pio_s1_arbitrator : entity is FALSE;
end entity note_3_pio_s1_arbitrator;


architecture europa of note_3_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_note_3_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_note_3_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_note_3_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_note_3_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_note_3_pio_s1 :  STD_LOGIC;
                signal note_3_pio_s1_allgrants :  STD_LOGIC;
                signal note_3_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal note_3_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal note_3_pio_s1_any_continuerequest :  STD_LOGIC;
                signal note_3_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal note_3_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_3_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_3_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_3_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal note_3_pio_s1_begins_xfer :  STD_LOGIC;
                signal note_3_pio_s1_end_xfer :  STD_LOGIC;
                signal note_3_pio_s1_firsttransfer :  STD_LOGIC;
                signal note_3_pio_s1_grant_vector :  STD_LOGIC;
                signal note_3_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal note_3_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal note_3_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal note_3_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal note_3_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal note_3_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal note_3_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal note_3_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal note_3_pio_s1_waits_for_read :  STD_LOGIC;
                signal note_3_pio_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_note_3_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_note_3_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT note_3_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  note_3_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_note_3_pio_s1);
  internal_cpu_data_master_requests_note_3_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000001000000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_write;
  --note_3_pio_s1_arb_share_counter set values, which is an e_mux
  note_3_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --note_3_pio_s1_non_bursting_master_requests mux, which is an e_mux
  note_3_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_note_3_pio_s1;
  --note_3_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  note_3_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --note_3_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  note_3_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(note_3_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_3_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(note_3_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_3_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --note_3_pio_s1_allgrants all slave grants, which is an e_mux
  note_3_pio_s1_allgrants <= note_3_pio_s1_grant_vector;
  --note_3_pio_s1_end_xfer assignment, which is an e_assign
  note_3_pio_s1_end_xfer <= NOT ((note_3_pio_s1_waits_for_read OR note_3_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_note_3_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_note_3_pio_s1 <= note_3_pio_s1_end_xfer AND (((NOT note_3_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --note_3_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  note_3_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_note_3_pio_s1 AND note_3_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_note_3_pio_s1 AND NOT note_3_pio_s1_non_bursting_master_requests));
  --note_3_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_3_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(note_3_pio_s1_arb_counter_enable) = '1' then 
        note_3_pio_s1_arb_share_counter <= note_3_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --note_3_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_3_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((note_3_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_note_3_pio_s1)) OR ((end_xfer_arb_share_counter_term_note_3_pio_s1 AND NOT note_3_pio_s1_non_bursting_master_requests)))) = '1' then 
        note_3_pio_s1_slavearbiterlockenable <= or_reduce(note_3_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master note_3_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= note_3_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --note_3_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  note_3_pio_s1_slavearbiterlockenable2 <= or_reduce(note_3_pio_s1_arb_share_counter_next_value);
  --cpu/data_master note_3_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= note_3_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --note_3_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  note_3_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_note_3_pio_s1 <= internal_cpu_data_master_requests_note_3_pio_s1;
  --local readdatavalid cpu_data_master_read_data_valid_note_3_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_note_3_pio_s1 <= (internal_cpu_data_master_granted_note_3_pio_s1 AND cpu_data_master_read) AND NOT note_3_pio_s1_waits_for_read;
  --note_3_pio_s1_writedata mux, which is an e_mux
  note_3_pio_s1_writedata <= cpu_data_master_writedata (15 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_note_3_pio_s1 <= internal_cpu_data_master_qualified_request_note_3_pio_s1;
  --cpu/data_master saved-grant note_3_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_note_3_pio_s1 <= internal_cpu_data_master_requests_note_3_pio_s1;
  --allow new arb cycle for note_3_pio/s1, which is an e_assign
  note_3_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  note_3_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  note_3_pio_s1_master_qreq_vector <= std_logic'('1');
  --note_3_pio_s1_reset_n assignment, which is an e_assign
  note_3_pio_s1_reset_n <= reset_n;
  note_3_pio_s1_chipselect <= internal_cpu_data_master_granted_note_3_pio_s1;
  --note_3_pio_s1_firsttransfer first transaction, which is an e_assign
  note_3_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(note_3_pio_s1_begins_xfer) = '1'), note_3_pio_s1_unreg_firsttransfer, note_3_pio_s1_reg_firsttransfer);
  --note_3_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  note_3_pio_s1_unreg_firsttransfer <= NOT ((note_3_pio_s1_slavearbiterlockenable AND note_3_pio_s1_any_continuerequest));
  --note_3_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_3_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(note_3_pio_s1_begins_xfer) = '1' then 
        note_3_pio_s1_reg_firsttransfer <= note_3_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --note_3_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  note_3_pio_s1_beginbursttransfer_internal <= note_3_pio_s1_begins_xfer;
  --~note_3_pio_s1_write_n assignment, which is an e_mux
  note_3_pio_s1_write_n <= NOT ((internal_cpu_data_master_granted_note_3_pio_s1 AND cpu_data_master_write));
  shifted_address_to_note_3_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --note_3_pio_s1_address mux, which is an e_mux
  note_3_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_note_3_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_note_3_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_note_3_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_note_3_pio_s1_end_xfer <= note_3_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --note_3_pio_s1_waits_for_read in a cycle, which is an e_mux
  note_3_pio_s1_waits_for_read <= note_3_pio_s1_in_a_read_cycle AND note_3_pio_s1_begins_xfer;
  --note_3_pio_s1_in_a_read_cycle assignment, which is an e_assign
  note_3_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_note_3_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= note_3_pio_s1_in_a_read_cycle;
  --note_3_pio_s1_waits_for_write in a cycle, which is an e_mux
  note_3_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(note_3_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --note_3_pio_s1_in_a_write_cycle assignment, which is an e_assign
  note_3_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_note_3_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= note_3_pio_s1_in_a_write_cycle;
  wait_for_note_3_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_note_3_pio_s1 <= internal_cpu_data_master_granted_note_3_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_note_3_pio_s1 <= internal_cpu_data_master_qualified_request_note_3_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_note_3_pio_s1 <= internal_cpu_data_master_requests_note_3_pio_s1;
--synthesis translate_off
    --note_3_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity note_4_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_note_4_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_4_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_4_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_note_4_pio_s1 : OUT STD_LOGIC;
                 signal d1_note_4_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal note_4_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal note_4_pio_s1_chipselect : OUT STD_LOGIC;
                 signal note_4_pio_s1_reset_n : OUT STD_LOGIC;
                 signal note_4_pio_s1_write_n : OUT STD_LOGIC;
                 signal note_4_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of note_4_pio_s1_arbitrator : entity is FALSE;
end entity note_4_pio_s1_arbitrator;


architecture europa of note_4_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_note_4_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_note_4_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_note_4_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_note_4_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_note_4_pio_s1 :  STD_LOGIC;
                signal note_4_pio_s1_allgrants :  STD_LOGIC;
                signal note_4_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal note_4_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal note_4_pio_s1_any_continuerequest :  STD_LOGIC;
                signal note_4_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal note_4_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_4_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_4_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_4_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal note_4_pio_s1_begins_xfer :  STD_LOGIC;
                signal note_4_pio_s1_end_xfer :  STD_LOGIC;
                signal note_4_pio_s1_firsttransfer :  STD_LOGIC;
                signal note_4_pio_s1_grant_vector :  STD_LOGIC;
                signal note_4_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal note_4_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal note_4_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal note_4_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal note_4_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal note_4_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal note_4_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal note_4_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal note_4_pio_s1_waits_for_read :  STD_LOGIC;
                signal note_4_pio_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_note_4_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_note_4_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT note_4_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  note_4_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_note_4_pio_s1);
  internal_cpu_data_master_requests_note_4_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000001010000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_write;
  --note_4_pio_s1_arb_share_counter set values, which is an e_mux
  note_4_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --note_4_pio_s1_non_bursting_master_requests mux, which is an e_mux
  note_4_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_note_4_pio_s1;
  --note_4_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  note_4_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --note_4_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  note_4_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(note_4_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_4_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(note_4_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_4_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --note_4_pio_s1_allgrants all slave grants, which is an e_mux
  note_4_pio_s1_allgrants <= note_4_pio_s1_grant_vector;
  --note_4_pio_s1_end_xfer assignment, which is an e_assign
  note_4_pio_s1_end_xfer <= NOT ((note_4_pio_s1_waits_for_read OR note_4_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_note_4_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_note_4_pio_s1 <= note_4_pio_s1_end_xfer AND (((NOT note_4_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --note_4_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  note_4_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_note_4_pio_s1 AND note_4_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_note_4_pio_s1 AND NOT note_4_pio_s1_non_bursting_master_requests));
  --note_4_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_4_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(note_4_pio_s1_arb_counter_enable) = '1' then 
        note_4_pio_s1_arb_share_counter <= note_4_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --note_4_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_4_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((note_4_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_note_4_pio_s1)) OR ((end_xfer_arb_share_counter_term_note_4_pio_s1 AND NOT note_4_pio_s1_non_bursting_master_requests)))) = '1' then 
        note_4_pio_s1_slavearbiterlockenable <= or_reduce(note_4_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master note_4_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= note_4_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --note_4_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  note_4_pio_s1_slavearbiterlockenable2 <= or_reduce(note_4_pio_s1_arb_share_counter_next_value);
  --cpu/data_master note_4_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= note_4_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --note_4_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  note_4_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_note_4_pio_s1 <= internal_cpu_data_master_requests_note_4_pio_s1;
  --local readdatavalid cpu_data_master_read_data_valid_note_4_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_note_4_pio_s1 <= (internal_cpu_data_master_granted_note_4_pio_s1 AND cpu_data_master_read) AND NOT note_4_pio_s1_waits_for_read;
  --note_4_pio_s1_writedata mux, which is an e_mux
  note_4_pio_s1_writedata <= cpu_data_master_writedata (15 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_note_4_pio_s1 <= internal_cpu_data_master_qualified_request_note_4_pio_s1;
  --cpu/data_master saved-grant note_4_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_note_4_pio_s1 <= internal_cpu_data_master_requests_note_4_pio_s1;
  --allow new arb cycle for note_4_pio/s1, which is an e_assign
  note_4_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  note_4_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  note_4_pio_s1_master_qreq_vector <= std_logic'('1');
  --note_4_pio_s1_reset_n assignment, which is an e_assign
  note_4_pio_s1_reset_n <= reset_n;
  note_4_pio_s1_chipselect <= internal_cpu_data_master_granted_note_4_pio_s1;
  --note_4_pio_s1_firsttransfer first transaction, which is an e_assign
  note_4_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(note_4_pio_s1_begins_xfer) = '1'), note_4_pio_s1_unreg_firsttransfer, note_4_pio_s1_reg_firsttransfer);
  --note_4_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  note_4_pio_s1_unreg_firsttransfer <= NOT ((note_4_pio_s1_slavearbiterlockenable AND note_4_pio_s1_any_continuerequest));
  --note_4_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_4_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(note_4_pio_s1_begins_xfer) = '1' then 
        note_4_pio_s1_reg_firsttransfer <= note_4_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --note_4_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  note_4_pio_s1_beginbursttransfer_internal <= note_4_pio_s1_begins_xfer;
  --~note_4_pio_s1_write_n assignment, which is an e_mux
  note_4_pio_s1_write_n <= NOT ((internal_cpu_data_master_granted_note_4_pio_s1 AND cpu_data_master_write));
  shifted_address_to_note_4_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --note_4_pio_s1_address mux, which is an e_mux
  note_4_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_note_4_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_note_4_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_note_4_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_note_4_pio_s1_end_xfer <= note_4_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --note_4_pio_s1_waits_for_read in a cycle, which is an e_mux
  note_4_pio_s1_waits_for_read <= note_4_pio_s1_in_a_read_cycle AND note_4_pio_s1_begins_xfer;
  --note_4_pio_s1_in_a_read_cycle assignment, which is an e_assign
  note_4_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_note_4_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= note_4_pio_s1_in_a_read_cycle;
  --note_4_pio_s1_waits_for_write in a cycle, which is an e_mux
  note_4_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(note_4_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --note_4_pio_s1_in_a_write_cycle assignment, which is an e_assign
  note_4_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_note_4_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= note_4_pio_s1_in_a_write_cycle;
  wait_for_note_4_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_note_4_pio_s1 <= internal_cpu_data_master_granted_note_4_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_note_4_pio_s1 <= internal_cpu_data_master_qualified_request_note_4_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_note_4_pio_s1 <= internal_cpu_data_master_requests_note_4_pio_s1;
--synthesis translate_off
    --note_4_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity note_5_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal cpu_data_master_granted_note_5_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_note_5_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_note_5_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_note_5_pio_s1 : OUT STD_LOGIC;
                 signal d1_note_5_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal note_5_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal note_5_pio_s1_chipselect : OUT STD_LOGIC;
                 signal note_5_pio_s1_reset_n : OUT STD_LOGIC;
                 signal note_5_pio_s1_write_n : OUT STD_LOGIC;
                 signal note_5_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of note_5_pio_s1_arbitrator : entity is FALSE;
end entity note_5_pio_s1_arbitrator;


architecture europa of note_5_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_note_5_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_note_5_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_note_5_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_note_5_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_note_5_pio_s1 :  STD_LOGIC;
                signal note_5_pio_s1_allgrants :  STD_LOGIC;
                signal note_5_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal note_5_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal note_5_pio_s1_any_continuerequest :  STD_LOGIC;
                signal note_5_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal note_5_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_5_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_5_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_5_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal note_5_pio_s1_begins_xfer :  STD_LOGIC;
                signal note_5_pio_s1_end_xfer :  STD_LOGIC;
                signal note_5_pio_s1_firsttransfer :  STD_LOGIC;
                signal note_5_pio_s1_grant_vector :  STD_LOGIC;
                signal note_5_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal note_5_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal note_5_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal note_5_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal note_5_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal note_5_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal note_5_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal note_5_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal note_5_pio_s1_waits_for_read :  STD_LOGIC;
                signal note_5_pio_s1_waits_for_write :  STD_LOGIC;
                signal shifted_address_to_note_5_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal wait_for_note_5_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT note_5_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  note_5_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_note_5_pio_s1);
  internal_cpu_data_master_requests_note_5_pio_s1 <= ((to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000001100000")))) AND ((cpu_data_master_read OR cpu_data_master_write)))) AND cpu_data_master_write;
  --note_5_pio_s1_arb_share_counter set values, which is an e_mux
  note_5_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --note_5_pio_s1_non_bursting_master_requests mux, which is an e_mux
  note_5_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_note_5_pio_s1;
  --note_5_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  note_5_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --note_5_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  note_5_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(note_5_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_5_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(note_5_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (note_5_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --note_5_pio_s1_allgrants all slave grants, which is an e_mux
  note_5_pio_s1_allgrants <= note_5_pio_s1_grant_vector;
  --note_5_pio_s1_end_xfer assignment, which is an e_assign
  note_5_pio_s1_end_xfer <= NOT ((note_5_pio_s1_waits_for_read OR note_5_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_note_5_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_note_5_pio_s1 <= note_5_pio_s1_end_xfer AND (((NOT note_5_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --note_5_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  note_5_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_note_5_pio_s1 AND note_5_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_note_5_pio_s1 AND NOT note_5_pio_s1_non_bursting_master_requests));
  --note_5_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_5_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(note_5_pio_s1_arb_counter_enable) = '1' then 
        note_5_pio_s1_arb_share_counter <= note_5_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --note_5_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_5_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((note_5_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_note_5_pio_s1)) OR ((end_xfer_arb_share_counter_term_note_5_pio_s1 AND NOT note_5_pio_s1_non_bursting_master_requests)))) = '1' then 
        note_5_pio_s1_slavearbiterlockenable <= or_reduce(note_5_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master note_5_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= note_5_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --note_5_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  note_5_pio_s1_slavearbiterlockenable2 <= or_reduce(note_5_pio_s1_arb_share_counter_next_value);
  --cpu/data_master note_5_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= note_5_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --note_5_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  note_5_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_note_5_pio_s1 <= internal_cpu_data_master_requests_note_5_pio_s1;
  --local readdatavalid cpu_data_master_read_data_valid_note_5_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_note_5_pio_s1 <= (internal_cpu_data_master_granted_note_5_pio_s1 AND cpu_data_master_read) AND NOT note_5_pio_s1_waits_for_read;
  --note_5_pio_s1_writedata mux, which is an e_mux
  note_5_pio_s1_writedata <= cpu_data_master_writedata (15 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_note_5_pio_s1 <= internal_cpu_data_master_qualified_request_note_5_pio_s1;
  --cpu/data_master saved-grant note_5_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_note_5_pio_s1 <= internal_cpu_data_master_requests_note_5_pio_s1;
  --allow new arb cycle for note_5_pio/s1, which is an e_assign
  note_5_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  note_5_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  note_5_pio_s1_master_qreq_vector <= std_logic'('1');
  --note_5_pio_s1_reset_n assignment, which is an e_assign
  note_5_pio_s1_reset_n <= reset_n;
  note_5_pio_s1_chipselect <= internal_cpu_data_master_granted_note_5_pio_s1;
  --note_5_pio_s1_firsttransfer first transaction, which is an e_assign
  note_5_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(note_5_pio_s1_begins_xfer) = '1'), note_5_pio_s1_unreg_firsttransfer, note_5_pio_s1_reg_firsttransfer);
  --note_5_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  note_5_pio_s1_unreg_firsttransfer <= NOT ((note_5_pio_s1_slavearbiterlockenable AND note_5_pio_s1_any_continuerequest));
  --note_5_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      note_5_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(note_5_pio_s1_begins_xfer) = '1' then 
        note_5_pio_s1_reg_firsttransfer <= note_5_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --note_5_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  note_5_pio_s1_beginbursttransfer_internal <= note_5_pio_s1_begins_xfer;
  --~note_5_pio_s1_write_n assignment, which is an e_mux
  note_5_pio_s1_write_n <= NOT ((internal_cpu_data_master_granted_note_5_pio_s1 AND cpu_data_master_write));
  shifted_address_to_note_5_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --note_5_pio_s1_address mux, which is an e_mux
  note_5_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_note_5_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_note_5_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_note_5_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_note_5_pio_s1_end_xfer <= note_5_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --note_5_pio_s1_waits_for_read in a cycle, which is an e_mux
  note_5_pio_s1_waits_for_read <= note_5_pio_s1_in_a_read_cycle AND note_5_pio_s1_begins_xfer;
  --note_5_pio_s1_in_a_read_cycle assignment, which is an e_assign
  note_5_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_note_5_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= note_5_pio_s1_in_a_read_cycle;
  --note_5_pio_s1_waits_for_write in a cycle, which is an e_mux
  note_5_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(note_5_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --note_5_pio_s1_in_a_write_cycle assignment, which is an e_assign
  note_5_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_note_5_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= note_5_pio_s1_in_a_write_cycle;
  wait_for_note_5_pio_s1_counter <= std_logic'('0');
  --vhdl renameroo for output signals
  cpu_data_master_granted_note_5_pio_s1 <= internal_cpu_data_master_granted_note_5_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_note_5_pio_s1 <= internal_cpu_data_master_qualified_request_note_5_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_note_5_pio_s1 <= internal_cpu_data_master_requests_note_5_pio_s1;
--synthesis translate_off
    --note_5_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

library std;
use std.textio.all;

entity sram_sram_slave_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_instruction_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_instruction_master_latency_counter : IN STD_LOGIC;
                 signal cpu_instruction_master_read : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;
                 signal sram_sram_slave_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- outputs:
                 signal cpu_data_master_byteenable_sram_sram_slave : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal cpu_data_master_granted_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_data_master_requests_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_instruction_master_granted_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_instruction_master_qualified_request_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_instruction_master_read_data_valid_sram_sram_slave : OUT STD_LOGIC;
                 signal cpu_instruction_master_requests_sram_sram_slave : OUT STD_LOGIC;
                 signal d1_sram_sram_slave_end_xfer : OUT STD_LOGIC;
                 signal sram_sram_slave_address : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                 signal sram_sram_slave_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal sram_sram_slave_chipselect : OUT STD_LOGIC;
                 signal sram_sram_slave_read : OUT STD_LOGIC;
                 signal sram_sram_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal sram_sram_slave_write : OUT STD_LOGIC;
                 signal sram_sram_slave_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of sram_sram_slave_arbitrator : entity is FALSE;
end entity sram_sram_slave_arbitrator;


architecture europa of sram_sram_slave_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_byteenable_sram_sram_slave_segment_0 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_data_master_byteenable_sram_sram_slave_segment_1 :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_sram_sram_slave :  STD_LOGIC;
                signal cpu_instruction_master_arbiterlock :  STD_LOGIC;
                signal cpu_instruction_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_instruction_master_continuerequest :  STD_LOGIC;
                signal cpu_instruction_master_saved_grant_sram_sram_slave :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_sram_sram_slave :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_byteenable_sram_sram_slave :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal internal_cpu_data_master_granted_sram_sram_slave :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_sram_sram_slave :  STD_LOGIC;
                signal internal_cpu_data_master_requests_sram_sram_slave :  STD_LOGIC;
                signal internal_cpu_instruction_master_granted_sram_sram_slave :  STD_LOGIC;
                signal internal_cpu_instruction_master_qualified_request_sram_sram_slave :  STD_LOGIC;
                signal internal_cpu_instruction_master_requests_sram_sram_slave :  STD_LOGIC;
                signal last_cycle_cpu_data_master_granted_slave_sram_sram_slave :  STD_LOGIC;
                signal last_cycle_cpu_instruction_master_granted_slave_sram_sram_slave :  STD_LOGIC;
                signal shifted_address_to_sram_sram_slave_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal shifted_address_to_sram_sram_slave_from_cpu_instruction_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal sram_sram_slave_allgrants :  STD_LOGIC;
                signal sram_sram_slave_allow_new_arb_cycle :  STD_LOGIC;
                signal sram_sram_slave_any_bursting_master_saved_grant :  STD_LOGIC;
                signal sram_sram_slave_any_continuerequest :  STD_LOGIC;
                signal sram_sram_slave_arb_addend :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_arb_counter_enable :  STD_LOGIC;
                signal sram_sram_slave_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_arb_winner :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_arbitration_holdoff_internal :  STD_LOGIC;
                signal sram_sram_slave_beginbursttransfer_internal :  STD_LOGIC;
                signal sram_sram_slave_begins_xfer :  STD_LOGIC;
                signal sram_sram_slave_chosen_master_double_vector :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal sram_sram_slave_chosen_master_rot_left :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_end_xfer :  STD_LOGIC;
                signal sram_sram_slave_firsttransfer :  STD_LOGIC;
                signal sram_sram_slave_grant_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_in_a_read_cycle :  STD_LOGIC;
                signal sram_sram_slave_in_a_write_cycle :  STD_LOGIC;
                signal sram_sram_slave_master_qreq_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_non_bursting_master_requests :  STD_LOGIC;
                signal sram_sram_slave_reg_firsttransfer :  STD_LOGIC;
                signal sram_sram_slave_saved_chosen_master_vector :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_slavearbiterlockenable :  STD_LOGIC;
                signal sram_sram_slave_slavearbiterlockenable2 :  STD_LOGIC;
                signal sram_sram_slave_unreg_firsttransfer :  STD_LOGIC;
                signal sram_sram_slave_waits_for_read :  STD_LOGIC;
                signal sram_sram_slave_waits_for_write :  STD_LOGIC;
                signal wait_for_sram_sram_slave_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT sram_sram_slave_end_xfer;
      end if;
    end if;

  end process;

  sram_sram_slave_begins_xfer <= NOT d1_reasons_to_wait AND ((internal_cpu_data_master_qualified_request_sram_sram_slave OR internal_cpu_instruction_master_qualified_request_sram_sram_slave));
  --assign sram_sram_slave_readdata_from_sa = sram_sram_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  sram_sram_slave_readdata_from_sa <= sram_sram_slave_readdata;
  internal_cpu_data_master_requests_sram_sram_slave <= to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 19) & std_logic_vector'("0000000000000000000")) = std_logic_vector'("010000000000000000000")))) AND ((cpu_data_master_read OR cpu_data_master_write));
  --sram_sram_slave_arb_share_counter set values, which is an e_mux
  sram_sram_slave_arb_share_set_values <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_instruction_master_granted_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), A_WE_StdLogicVector((std_logic'((internal_cpu_instruction_master_granted_sram_sram_slave)) = '1'), std_logic_vector'("00000000000000000000000000000010"), std_logic_vector'("00000000000000000000000000000001"))))), 2);
  --sram_sram_slave_non_bursting_master_requests mux, which is an e_mux
  sram_sram_slave_non_bursting_master_requests <= ((internal_cpu_data_master_requests_sram_sram_slave OR internal_cpu_instruction_master_requests_sram_sram_slave) OR internal_cpu_data_master_requests_sram_sram_slave) OR internal_cpu_instruction_master_requests_sram_sram_slave;
  --sram_sram_slave_any_bursting_master_saved_grant mux, which is an e_mux
  sram_sram_slave_any_bursting_master_saved_grant <= std_logic'('0');
  --sram_sram_slave_arb_share_counter_next_value assignment, which is an e_assign
  sram_sram_slave_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(sram_sram_slave_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (sram_sram_slave_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(sram_sram_slave_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (sram_sram_slave_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --sram_sram_slave_allgrants all slave grants, which is an e_mux
  sram_sram_slave_allgrants <= ((or_reduce(sram_sram_slave_grant_vector) OR or_reduce(sram_sram_slave_grant_vector)) OR or_reduce(sram_sram_slave_grant_vector)) OR or_reduce(sram_sram_slave_grant_vector);
  --sram_sram_slave_end_xfer assignment, which is an e_assign
  sram_sram_slave_end_xfer <= NOT ((sram_sram_slave_waits_for_read OR sram_sram_slave_waits_for_write));
  --end_xfer_arb_share_counter_term_sram_sram_slave arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_sram_sram_slave <= sram_sram_slave_end_xfer AND (((NOT sram_sram_slave_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --sram_sram_slave_arb_share_counter arbitration counter enable, which is an e_assign
  sram_sram_slave_arb_counter_enable <= ((end_xfer_arb_share_counter_term_sram_sram_slave AND sram_sram_slave_allgrants)) OR ((end_xfer_arb_share_counter_term_sram_sram_slave AND NOT sram_sram_slave_non_bursting_master_requests));
  --sram_sram_slave_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sram_sram_slave_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(sram_sram_slave_arb_counter_enable) = '1' then 
        sram_sram_slave_arb_share_counter <= sram_sram_slave_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --sram_sram_slave_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sram_sram_slave_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((or_reduce(sram_sram_slave_master_qreq_vector) AND end_xfer_arb_share_counter_term_sram_sram_slave)) OR ((end_xfer_arb_share_counter_term_sram_sram_slave AND NOT sram_sram_slave_non_bursting_master_requests)))) = '1' then 
        sram_sram_slave_slavearbiterlockenable <= or_reduce(sram_sram_slave_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master sram/sram_slave arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= sram_sram_slave_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --sram_sram_slave_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  sram_sram_slave_slavearbiterlockenable2 <= or_reduce(sram_sram_slave_arb_share_counter_next_value);
  --cpu/data_master sram/sram_slave arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= sram_sram_slave_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --cpu/instruction_master sram/sram_slave arbiterlock, which is an e_assign
  cpu_instruction_master_arbiterlock <= sram_sram_slave_slavearbiterlockenable AND cpu_instruction_master_continuerequest;
  --cpu/instruction_master sram/sram_slave arbiterlock2, which is an e_assign
  cpu_instruction_master_arbiterlock2 <= sram_sram_slave_slavearbiterlockenable2 AND cpu_instruction_master_continuerequest;
  --cpu/instruction_master granted sram/sram_slave last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_instruction_master_granted_slave_sram_sram_slave <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_instruction_master_granted_slave_sram_sram_slave <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_instruction_master_saved_grant_sram_sram_slave) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((sram_sram_slave_arbitration_holdoff_internal OR NOT internal_cpu_instruction_master_requests_sram_sram_slave))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_instruction_master_granted_slave_sram_sram_slave))))));
      end if;
    end if;

  end process;

  --cpu_instruction_master_continuerequest continued request, which is an e_mux
  cpu_instruction_master_continuerequest <= last_cycle_cpu_instruction_master_granted_slave_sram_sram_slave AND internal_cpu_instruction_master_requests_sram_sram_slave;
  --sram_sram_slave_any_continuerequest at least one master continues requesting, which is an e_mux
  sram_sram_slave_any_continuerequest <= cpu_instruction_master_continuerequest OR cpu_data_master_continuerequest;
  internal_cpu_data_master_qualified_request_sram_sram_slave <= internal_cpu_data_master_requests_sram_sram_slave AND NOT (((((cpu_data_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))))) OR (((NOT(or_reduce(internal_cpu_data_master_byteenable_sram_sram_slave))) AND cpu_data_master_write))) OR cpu_instruction_master_arbiterlock));
  --local readdatavalid cpu_data_master_read_data_valid_sram_sram_slave, which is an e_mux
  cpu_data_master_read_data_valid_sram_sram_slave <= (internal_cpu_data_master_granted_sram_sram_slave AND cpu_data_master_read) AND NOT sram_sram_slave_waits_for_read;
  --sram_sram_slave_writedata mux, which is an e_mux
  sram_sram_slave_writedata <= cpu_data_master_dbs_write_16;
  internal_cpu_instruction_master_requests_sram_sram_slave <= ((to_std_logic(((Std_Logic_Vector'(cpu_instruction_master_address_to_slave(20 DOWNTO 19) & std_logic_vector'("0000000000000000000")) = std_logic_vector'("010000000000000000000")))) AND (cpu_instruction_master_read))) AND cpu_instruction_master_read;
  --cpu/data_master granted sram/sram_slave last time, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      last_cycle_cpu_data_master_granted_slave_sram_sram_slave <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        last_cycle_cpu_data_master_granted_slave_sram_sram_slave <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'(cpu_data_master_saved_grant_sram_sram_slave) = '1'), std_logic_vector'("00000000000000000000000000000001"), A_WE_StdLogicVector((std_logic'(((sram_sram_slave_arbitration_holdoff_internal OR NOT internal_cpu_data_master_requests_sram_sram_slave))) = '1'), std_logic_vector'("00000000000000000000000000000000"), (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(last_cycle_cpu_data_master_granted_slave_sram_sram_slave))))));
      end if;
    end if;

  end process;

  --cpu_data_master_continuerequest continued request, which is an e_mux
  cpu_data_master_continuerequest <= last_cycle_cpu_data_master_granted_slave_sram_sram_slave AND internal_cpu_data_master_requests_sram_sram_slave;
  internal_cpu_instruction_master_qualified_request_sram_sram_slave <= internal_cpu_instruction_master_requests_sram_sram_slave AND NOT ((((cpu_instruction_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000")))))) OR cpu_data_master_arbiterlock));
  --local readdatavalid cpu_instruction_master_read_data_valid_sram_sram_slave, which is an e_mux
  cpu_instruction_master_read_data_valid_sram_sram_slave <= (internal_cpu_instruction_master_granted_sram_sram_slave AND cpu_instruction_master_read) AND NOT sram_sram_slave_waits_for_read;
  --allow new arb cycle for sram/sram_slave, which is an e_assign
  sram_sram_slave_allow_new_arb_cycle <= NOT cpu_data_master_arbiterlock AND NOT cpu_instruction_master_arbiterlock;
  --cpu/instruction_master assignment into master qualified-requests vector for sram/sram_slave, which is an e_assign
  sram_sram_slave_master_qreq_vector(0) <= internal_cpu_instruction_master_qualified_request_sram_sram_slave;
  --cpu/instruction_master grant sram/sram_slave, which is an e_assign
  internal_cpu_instruction_master_granted_sram_sram_slave <= sram_sram_slave_grant_vector(0);
  --cpu/instruction_master saved-grant sram/sram_slave, which is an e_assign
  cpu_instruction_master_saved_grant_sram_sram_slave <= sram_sram_slave_arb_winner(0) AND internal_cpu_instruction_master_requests_sram_sram_slave;
  --cpu/data_master assignment into master qualified-requests vector for sram/sram_slave, which is an e_assign
  sram_sram_slave_master_qreq_vector(1) <= internal_cpu_data_master_qualified_request_sram_sram_slave;
  --cpu/data_master grant sram/sram_slave, which is an e_assign
  internal_cpu_data_master_granted_sram_sram_slave <= sram_sram_slave_grant_vector(1);
  --cpu/data_master saved-grant sram/sram_slave, which is an e_assign
  cpu_data_master_saved_grant_sram_sram_slave <= sram_sram_slave_arb_winner(1) AND internal_cpu_data_master_requests_sram_sram_slave;
  --sram/sram_slave chosen-master double-vector, which is an e_assign
  sram_sram_slave_chosen_master_double_vector <= A_EXT (((std_logic_vector'("0") & ((sram_sram_slave_master_qreq_vector & sram_sram_slave_master_qreq_vector))) AND (((std_logic_vector'("0") & (Std_Logic_Vector'(NOT sram_sram_slave_master_qreq_vector & NOT sram_sram_slave_master_qreq_vector))) + (std_logic_vector'("000") & (sram_sram_slave_arb_addend))))), 4);
  --stable onehot encoding of arb winner
  sram_sram_slave_arb_winner <= A_WE_StdLogicVector((std_logic'(((sram_sram_slave_allow_new_arb_cycle AND or_reduce(sram_sram_slave_grant_vector)))) = '1'), sram_sram_slave_grant_vector, sram_sram_slave_saved_chosen_master_vector);
  --saved sram_sram_slave_grant_vector, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sram_sram_slave_saved_chosen_master_vector <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(sram_sram_slave_allow_new_arb_cycle) = '1' then 
        sram_sram_slave_saved_chosen_master_vector <= A_WE_StdLogicVector((std_logic'(or_reduce(sram_sram_slave_grant_vector)) = '1'), sram_sram_slave_grant_vector, sram_sram_slave_saved_chosen_master_vector);
      end if;
    end if;

  end process;

  --onehot encoding of chosen master
  sram_sram_slave_grant_vector <= Std_Logic_Vector'(A_ToStdLogicVector(((sram_sram_slave_chosen_master_double_vector(1) OR sram_sram_slave_chosen_master_double_vector(3)))) & A_ToStdLogicVector(((sram_sram_slave_chosen_master_double_vector(0) OR sram_sram_slave_chosen_master_double_vector(2)))));
  --sram/sram_slave chosen master rotated left, which is an e_assign
  sram_sram_slave_chosen_master_rot_left <= A_EXT (A_WE_StdLogicVector((((A_SLL(sram_sram_slave_arb_winner,std_logic_vector'("00000000000000000000000000000001")))) /= std_logic_vector'("00")), (std_logic_vector'("000000000000000000000000000000") & ((A_SLL(sram_sram_slave_arb_winner,std_logic_vector'("00000000000000000000000000000001"))))), std_logic_vector'("00000000000000000000000000000001")), 2);
  --sram/sram_slave's addend for next-master-grant
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sram_sram_slave_arb_addend <= std_logic_vector'("01");
    elsif clk'event and clk = '1' then
      if std_logic'(or_reduce(sram_sram_slave_grant_vector)) = '1' then 
        sram_sram_slave_arb_addend <= A_WE_StdLogicVector((std_logic'(sram_sram_slave_end_xfer) = '1'), sram_sram_slave_chosen_master_rot_left, sram_sram_slave_grant_vector);
      end if;
    end if;

  end process;

  sram_sram_slave_chipselect <= internal_cpu_data_master_granted_sram_sram_slave OR internal_cpu_instruction_master_granted_sram_sram_slave;
  --sram_sram_slave_firsttransfer first transaction, which is an e_assign
  sram_sram_slave_firsttransfer <= A_WE_StdLogic((std_logic'(sram_sram_slave_begins_xfer) = '1'), sram_sram_slave_unreg_firsttransfer, sram_sram_slave_reg_firsttransfer);
  --sram_sram_slave_unreg_firsttransfer first transaction, which is an e_assign
  sram_sram_slave_unreg_firsttransfer <= NOT ((sram_sram_slave_slavearbiterlockenable AND sram_sram_slave_any_continuerequest));
  --sram_sram_slave_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      sram_sram_slave_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(sram_sram_slave_begins_xfer) = '1' then 
        sram_sram_slave_reg_firsttransfer <= sram_sram_slave_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --sram_sram_slave_beginbursttransfer_internal begin burst transfer, which is an e_assign
  sram_sram_slave_beginbursttransfer_internal <= sram_sram_slave_begins_xfer;
  --sram_sram_slave_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  sram_sram_slave_arbitration_holdoff_internal <= sram_sram_slave_begins_xfer AND sram_sram_slave_firsttransfer;
  --sram_sram_slave_read assignment, which is an e_mux
  sram_sram_slave_read <= ((internal_cpu_data_master_granted_sram_sram_slave AND cpu_data_master_read)) OR ((internal_cpu_instruction_master_granted_sram_sram_slave AND cpu_instruction_master_read));
  --sram_sram_slave_write assignment, which is an e_mux
  sram_sram_slave_write <= internal_cpu_data_master_granted_sram_sram_slave AND cpu_data_master_write;
  shifted_address_to_sram_sram_slave_from_cpu_data_master <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_data_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_data_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 21);
  --sram_sram_slave_address mux, which is an e_mux
  sram_sram_slave_address <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_sram_sram_slave)) = '1'), (A_SRL(shifted_address_to_sram_sram_slave_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000001"))), (A_SRL(shifted_address_to_sram_sram_slave_from_cpu_instruction_master,std_logic_vector'("00000000000000000000000000000001")))), 18);
  shifted_address_to_sram_sram_slave_from_cpu_instruction_master <= A_EXT (Std_Logic_Vector'(A_SRL(cpu_instruction_master_address_to_slave,std_logic_vector'("00000000000000000000000000000010")) & A_ToStdLogicVector(cpu_instruction_master_dbs_address(1)) & A_ToStdLogicVector(std_logic'('0'))), 21);
  --d1_sram_sram_slave_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_sram_sram_slave_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_sram_sram_slave_end_xfer <= sram_sram_slave_end_xfer;
      end if;
    end if;

  end process;

  --sram_sram_slave_waits_for_read in a cycle, which is an e_mux
  sram_sram_slave_waits_for_read <= sram_sram_slave_in_a_read_cycle AND sram_sram_slave_begins_xfer;
  --sram_sram_slave_in_a_read_cycle assignment, which is an e_assign
  sram_sram_slave_in_a_read_cycle <= ((internal_cpu_data_master_granted_sram_sram_slave AND cpu_data_master_read)) OR ((internal_cpu_instruction_master_granted_sram_sram_slave AND cpu_instruction_master_read));
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= sram_sram_slave_in_a_read_cycle;
  --sram_sram_slave_waits_for_write in a cycle, which is an e_mux
  sram_sram_slave_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(sram_sram_slave_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --sram_sram_slave_in_a_write_cycle assignment, which is an e_assign
  sram_sram_slave_in_a_write_cycle <= internal_cpu_data_master_granted_sram_sram_slave AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= sram_sram_slave_in_a_write_cycle;
  wait_for_sram_sram_slave_counter <= std_logic'('0');
  --sram_sram_slave_byteenable byte enable port mux, which is an e_mux
  sram_sram_slave_byteenable <= A_EXT (A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_sram_sram_slave)) = '1'), (std_logic_vector'("000000000000000000000000000000") & (internal_cpu_data_master_byteenable_sram_sram_slave)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))), 2);
  (cpu_data_master_byteenable_sram_sram_slave_segment_1(1), cpu_data_master_byteenable_sram_sram_slave_segment_1(0), cpu_data_master_byteenable_sram_sram_slave_segment_0(1), cpu_data_master_byteenable_sram_sram_slave_segment_0(0)) <= cpu_data_master_byteenable;
  internal_cpu_data_master_byteenable_sram_sram_slave <= A_WE_StdLogicVector((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_dbs_address(1)))) = std_logic_vector'("00000000000000000000000000000000"))), cpu_data_master_byteenable_sram_sram_slave_segment_0, cpu_data_master_byteenable_sram_sram_slave_segment_1);
  --vhdl renameroo for output signals
  cpu_data_master_byteenable_sram_sram_slave <= internal_cpu_data_master_byteenable_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_data_master_granted_sram_sram_slave <= internal_cpu_data_master_granted_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_sram_sram_slave <= internal_cpu_data_master_qualified_request_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_data_master_requests_sram_sram_slave <= internal_cpu_data_master_requests_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_instruction_master_granted_sram_sram_slave <= internal_cpu_instruction_master_granted_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_instruction_master_qualified_request_sram_sram_slave <= internal_cpu_instruction_master_qualified_request_sram_sram_slave;
  --vhdl renameroo for output signals
  cpu_instruction_master_requests_sram_sram_slave <= internal_cpu_instruction_master_requests_sram_sram_slave;
--synthesis translate_off
    --sram/sram_slave enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

    --grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line8 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_data_master_granted_sram_sram_slave))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(internal_cpu_instruction_master_granted_sram_sram_slave))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line8, now);
          write(write_line8, string'(": "));
          write(write_line8, string'("> 1 of grant signals are active simultaneously"));
          write(output, write_line8.all);
          deallocate (write_line8);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

    --saved_grant signals are active simultaneously, which is an e_process
    process (clk)
    VARIABLE write_line9 : line;
    begin
      if clk'event and clk = '1' then
        if (std_logic_vector'("000000000000000000000000000000") & (((std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_data_master_saved_grant_sram_sram_slave))) + (std_logic_vector'("0") & (A_TOSTDLOGICVECTOR(cpu_instruction_master_saved_grant_sram_sram_slave))))))>std_logic_vector'("00000000000000000000000000000001") then 
          write(write_line9, now);
          write(write_line9, string'(": "));
          write(write_line9, string'("> 1 of saved_grant signals are active simultaneously"));
          write(output, write_line9.all);
          deallocate (write_line9);
          assert false report "VHDL STOP" severity failure;
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity status_pio_s1_arbitrator is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                 signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                 signal cpu_data_master_latency_counter : IN STD_LOGIC;
                 signal cpu_data_master_read : IN STD_LOGIC;
                 signal cpu_data_master_write : IN STD_LOGIC;
                 signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                 signal reset_n : IN STD_LOGIC;
                 signal status_pio_s1_readdata : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

              -- outputs:
                 signal cpu_data_master_granted_status_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_qualified_request_status_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_read_data_valid_status_pio_s1 : OUT STD_LOGIC;
                 signal cpu_data_master_requests_status_pio_s1 : OUT STD_LOGIC;
                 signal d1_status_pio_s1_end_xfer : OUT STD_LOGIC;
                 signal status_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                 signal status_pio_s1_chipselect : OUT STD_LOGIC;
                 signal status_pio_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal status_pio_s1_reset_n : OUT STD_LOGIC;
                 signal status_pio_s1_write_n : OUT STD_LOGIC;
                 signal status_pio_s1_writedata : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
              );
attribute auto_dissolve : boolean;
attribute auto_dissolve of status_pio_s1_arbitrator : entity is FALSE;
end entity status_pio_s1_arbitrator;


architecture europa of status_pio_s1_arbitrator is
                signal cpu_data_master_arbiterlock :  STD_LOGIC;
                signal cpu_data_master_arbiterlock2 :  STD_LOGIC;
                signal cpu_data_master_continuerequest :  STD_LOGIC;
                signal cpu_data_master_saved_grant_status_pio_s1 :  STD_LOGIC;
                signal d1_reasons_to_wait :  STD_LOGIC;
                signal enable_nonzero_assertions :  STD_LOGIC;
                signal end_xfer_arb_share_counter_term_status_pio_s1 :  STD_LOGIC;
                signal in_a_read_cycle :  STD_LOGIC;
                signal in_a_write_cycle :  STD_LOGIC;
                signal internal_cpu_data_master_granted_status_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_qualified_request_status_pio_s1 :  STD_LOGIC;
                signal internal_cpu_data_master_requests_status_pio_s1 :  STD_LOGIC;
                signal shifted_address_to_status_pio_s1_from_cpu_data_master :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal status_pio_s1_allgrants :  STD_LOGIC;
                signal status_pio_s1_allow_new_arb_cycle :  STD_LOGIC;
                signal status_pio_s1_any_bursting_master_saved_grant :  STD_LOGIC;
                signal status_pio_s1_any_continuerequest :  STD_LOGIC;
                signal status_pio_s1_arb_counter_enable :  STD_LOGIC;
                signal status_pio_s1_arb_share_counter :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal status_pio_s1_arb_share_counter_next_value :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal status_pio_s1_arb_share_set_values :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal status_pio_s1_beginbursttransfer_internal :  STD_LOGIC;
                signal status_pio_s1_begins_xfer :  STD_LOGIC;
                signal status_pio_s1_end_xfer :  STD_LOGIC;
                signal status_pio_s1_firsttransfer :  STD_LOGIC;
                signal status_pio_s1_grant_vector :  STD_LOGIC;
                signal status_pio_s1_in_a_read_cycle :  STD_LOGIC;
                signal status_pio_s1_in_a_write_cycle :  STD_LOGIC;
                signal status_pio_s1_master_qreq_vector :  STD_LOGIC;
                signal status_pio_s1_non_bursting_master_requests :  STD_LOGIC;
                signal status_pio_s1_pretend_byte_enable :  STD_LOGIC;
                signal status_pio_s1_reg_firsttransfer :  STD_LOGIC;
                signal status_pio_s1_slavearbiterlockenable :  STD_LOGIC;
                signal status_pio_s1_slavearbiterlockenable2 :  STD_LOGIC;
                signal status_pio_s1_unreg_firsttransfer :  STD_LOGIC;
                signal status_pio_s1_waits_for_read :  STD_LOGIC;
                signal status_pio_s1_waits_for_write :  STD_LOGIC;
                signal wait_for_status_pio_s1_counter :  STD_LOGIC;

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_reasons_to_wait <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_reasons_to_wait <= NOT status_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  status_pio_s1_begins_xfer <= NOT d1_reasons_to_wait AND (internal_cpu_data_master_qualified_request_status_pio_s1);
  --assign status_pio_s1_readdata_from_sa = status_pio_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  status_pio_s1_readdata_from_sa <= status_pio_s1_readdata;
  internal_cpu_data_master_requests_status_pio_s1 <= to_std_logic(((Std_Logic_Vector'(cpu_data_master_address_to_slave(20 DOWNTO 4) & std_logic_vector'("0000")) = std_logic_vector'("100000001000000010000")))) AND ((cpu_data_master_read OR cpu_data_master_write));
  --status_pio_s1_arb_share_counter set values, which is an e_mux
  status_pio_s1_arb_share_set_values <= std_logic_vector'("01");
  --status_pio_s1_non_bursting_master_requests mux, which is an e_mux
  status_pio_s1_non_bursting_master_requests <= internal_cpu_data_master_requests_status_pio_s1;
  --status_pio_s1_any_bursting_master_saved_grant mux, which is an e_mux
  status_pio_s1_any_bursting_master_saved_grant <= std_logic'('0');
  --status_pio_s1_arb_share_counter_next_value assignment, which is an e_assign
  status_pio_s1_arb_share_counter_next_value <= A_EXT (A_WE_StdLogicVector((std_logic'(status_pio_s1_firsttransfer) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (status_pio_s1_arb_share_set_values)) - std_logic_vector'("000000000000000000000000000000001"))), A_WE_StdLogicVector((std_logic'(or_reduce(status_pio_s1_arb_share_counter)) = '1'), (((std_logic_vector'("0000000000000000000000000000000") & (status_pio_s1_arb_share_counter)) - std_logic_vector'("000000000000000000000000000000001"))), std_logic_vector'("000000000000000000000000000000000"))), 2);
  --status_pio_s1_allgrants all slave grants, which is an e_mux
  status_pio_s1_allgrants <= status_pio_s1_grant_vector;
  --status_pio_s1_end_xfer assignment, which is an e_assign
  status_pio_s1_end_xfer <= NOT ((status_pio_s1_waits_for_read OR status_pio_s1_waits_for_write));
  --end_xfer_arb_share_counter_term_status_pio_s1 arb share counter enable term, which is an e_assign
  end_xfer_arb_share_counter_term_status_pio_s1 <= status_pio_s1_end_xfer AND (((NOT status_pio_s1_any_bursting_master_saved_grant OR in_a_read_cycle) OR in_a_write_cycle));
  --status_pio_s1_arb_share_counter arbitration counter enable, which is an e_assign
  status_pio_s1_arb_counter_enable <= ((end_xfer_arb_share_counter_term_status_pio_s1 AND status_pio_s1_allgrants)) OR ((end_xfer_arb_share_counter_term_status_pio_s1 AND NOT status_pio_s1_non_bursting_master_requests));
  --status_pio_s1_arb_share_counter counter, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      status_pio_s1_arb_share_counter <= std_logic_vector'("00");
    elsif clk'event and clk = '1' then
      if std_logic'(status_pio_s1_arb_counter_enable) = '1' then 
        status_pio_s1_arb_share_counter <= status_pio_s1_arb_share_counter_next_value;
      end if;
    end if;

  end process;

  --status_pio_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      status_pio_s1_slavearbiterlockenable <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if std_logic'((((status_pio_s1_master_qreq_vector AND end_xfer_arb_share_counter_term_status_pio_s1)) OR ((end_xfer_arb_share_counter_term_status_pio_s1 AND NOT status_pio_s1_non_bursting_master_requests)))) = '1' then 
        status_pio_s1_slavearbiterlockenable <= or_reduce(status_pio_s1_arb_share_counter_next_value);
      end if;
    end if;

  end process;

  --cpu/data_master status_pio/s1 arbiterlock, which is an e_assign
  cpu_data_master_arbiterlock <= status_pio_s1_slavearbiterlockenable AND cpu_data_master_continuerequest;
  --status_pio_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  status_pio_s1_slavearbiterlockenable2 <= or_reduce(status_pio_s1_arb_share_counter_next_value);
  --cpu/data_master status_pio/s1 arbiterlock2, which is an e_assign
  cpu_data_master_arbiterlock2 <= status_pio_s1_slavearbiterlockenable2 AND cpu_data_master_continuerequest;
  --status_pio_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  status_pio_s1_any_continuerequest <= std_logic'('1');
  --cpu_data_master_continuerequest continued request, which is an e_assign
  cpu_data_master_continuerequest <= std_logic'('1');
  internal_cpu_data_master_qualified_request_status_pio_s1 <= internal_cpu_data_master_requests_status_pio_s1 AND NOT ((cpu_data_master_read AND to_std_logic((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_data_master_latency_counter))) /= std_logic_vector'("00000000000000000000000000000000"))))));
  --local readdatavalid cpu_data_master_read_data_valid_status_pio_s1, which is an e_mux
  cpu_data_master_read_data_valid_status_pio_s1 <= (internal_cpu_data_master_granted_status_pio_s1 AND cpu_data_master_read) AND NOT status_pio_s1_waits_for_read;
  --status_pio_s1_writedata mux, which is an e_mux
  status_pio_s1_writedata <= cpu_data_master_writedata (7 DOWNTO 0);
  --master is always granted when requested
  internal_cpu_data_master_granted_status_pio_s1 <= internal_cpu_data_master_qualified_request_status_pio_s1;
  --cpu/data_master saved-grant status_pio/s1, which is an e_assign
  cpu_data_master_saved_grant_status_pio_s1 <= internal_cpu_data_master_requests_status_pio_s1;
  --allow new arb cycle for status_pio/s1, which is an e_assign
  status_pio_s1_allow_new_arb_cycle <= std_logic'('1');
  --placeholder chosen master
  status_pio_s1_grant_vector <= std_logic'('1');
  --placeholder vector of master qualified-requests
  status_pio_s1_master_qreq_vector <= std_logic'('1');
  --status_pio_s1_reset_n assignment, which is an e_assign
  status_pio_s1_reset_n <= reset_n;
  status_pio_s1_chipselect <= internal_cpu_data_master_granted_status_pio_s1;
  --status_pio_s1_firsttransfer first transaction, which is an e_assign
  status_pio_s1_firsttransfer <= A_WE_StdLogic((std_logic'(status_pio_s1_begins_xfer) = '1'), status_pio_s1_unreg_firsttransfer, status_pio_s1_reg_firsttransfer);
  --status_pio_s1_unreg_firsttransfer first transaction, which is an e_assign
  status_pio_s1_unreg_firsttransfer <= NOT ((status_pio_s1_slavearbiterlockenable AND status_pio_s1_any_continuerequest));
  --status_pio_s1_reg_firsttransfer first transaction, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      status_pio_s1_reg_firsttransfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if std_logic'(status_pio_s1_begins_xfer) = '1' then 
        status_pio_s1_reg_firsttransfer <= status_pio_s1_unreg_firsttransfer;
      end if;
    end if;

  end process;

  --status_pio_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  status_pio_s1_beginbursttransfer_internal <= status_pio_s1_begins_xfer;
  --~status_pio_s1_write_n assignment, which is an e_mux
  status_pio_s1_write_n <= NOT ((((internal_cpu_data_master_granted_status_pio_s1 AND cpu_data_master_write)) AND status_pio_s1_pretend_byte_enable));
  shifted_address_to_status_pio_s1_from_cpu_data_master <= cpu_data_master_address_to_slave;
  --status_pio_s1_address mux, which is an e_mux
  status_pio_s1_address <= A_EXT (A_SRL(shifted_address_to_status_pio_s1_from_cpu_data_master,std_logic_vector'("00000000000000000000000000000010")), 2);
  --d1_status_pio_s1_end_xfer register, which is an e_register
  process (clk, reset_n)
  begin
    if reset_n = '0' then
      d1_status_pio_s1_end_xfer <= std_logic'('1');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        d1_status_pio_s1_end_xfer <= status_pio_s1_end_xfer;
      end if;
    end if;

  end process;

  --status_pio_s1_waits_for_read in a cycle, which is an e_mux
  status_pio_s1_waits_for_read <= status_pio_s1_in_a_read_cycle AND status_pio_s1_begins_xfer;
  --status_pio_s1_in_a_read_cycle assignment, which is an e_assign
  status_pio_s1_in_a_read_cycle <= internal_cpu_data_master_granted_status_pio_s1 AND cpu_data_master_read;
  --in_a_read_cycle assignment, which is an e_mux
  in_a_read_cycle <= status_pio_s1_in_a_read_cycle;
  --status_pio_s1_waits_for_write in a cycle, which is an e_mux
  status_pio_s1_waits_for_write <= Vector_To_Std_Logic(((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(status_pio_s1_in_a_write_cycle))) AND std_logic_vector'("00000000000000000000000000000000")));
  --status_pio_s1_in_a_write_cycle assignment, which is an e_assign
  status_pio_s1_in_a_write_cycle <= internal_cpu_data_master_granted_status_pio_s1 AND cpu_data_master_write;
  --in_a_write_cycle assignment, which is an e_mux
  in_a_write_cycle <= status_pio_s1_in_a_write_cycle;
  wait_for_status_pio_s1_counter <= std_logic'('0');
  --status_pio_s1_pretend_byte_enable byte enable port mux, which is an e_mux
  status_pio_s1_pretend_byte_enable <= Vector_To_Std_Logic(A_WE_StdLogicVector((std_logic'((internal_cpu_data_master_granted_status_pio_s1)) = '1'), (std_logic_vector'("0000000000000000000000000000") & (cpu_data_master_byteenable)), -SIGNED(std_logic_vector'("00000000000000000000000000000001"))));
  --vhdl renameroo for output signals
  cpu_data_master_granted_status_pio_s1 <= internal_cpu_data_master_granted_status_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_qualified_request_status_pio_s1 <= internal_cpu_data_master_qualified_request_status_pio_s1;
  --vhdl renameroo for output signals
  cpu_data_master_requests_status_pio_s1 <= internal_cpu_data_master_requests_status_pio_s1;
--synthesis translate_off
    --status_pio/s1 enable non-zero assertions, which is an e_register
    process (clk, reset_n)
    begin
      if reset_n = '0' then
        enable_nonzero_assertions <= std_logic'('0');
      elsif clk'event and clk = '1' then
        if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
          enable_nonzero_assertions <= std_logic'('1');
        end if;
      end if;

    end process;

--synthesis translate_on

end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nios_system_reset_clk_domain_synch_module is 
        port (
              -- inputs:
                 signal clk : IN STD_LOGIC;
                 signal data_in : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- outputs:
                 signal data_out : OUT STD_LOGIC
              );
end entity nios_system_reset_clk_domain_synch_module;


architecture europa of nios_system_reset_clk_domain_synch_module is
                signal data_in_d1 :  STD_LOGIC;
attribute ALTERA_ATTRIBUTE : string;
attribute ALTERA_ATTRIBUTE of data_in_d1 : signal is "MAX_DELAY=100ns ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";
attribute ALTERA_ATTRIBUTE of data_out : signal is "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101";

begin

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_in_d1 <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_in_d1 <= data_in;
      end if;
    end if;

  end process;

  process (clk, reset_n)
  begin
    if reset_n = '0' then
      data_out <= std_logic'('0');
    elsif clk'event and clk = '1' then
      if (std_logic_vector'("00000000000000000000000000000001")) /= std_logic_vector'("00000000000000000000000000000000") then 
        data_out <= data_in_d1;
      end if;
    end if;

  end process;


end europa;



-- turn off superfluous VHDL processor warnings 
-- altera message_level Level1 
-- altera message_off 10034 10035 10036 10037 10230 10240 10030 

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nios_system is 
        port (
              -- 1) global signals:
                 signal clk : IN STD_LOGIC;
                 signal reset_n : IN STD_LOGIC;

              -- the_data_pio
                 signal in_port_to_the_data_pio : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

              -- the_note_1_pio
                 signal out_port_from_the_note_1_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- the_note_2_pio
                 signal out_port_from_the_note_2_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- the_note_3_pio
                 signal out_port_from_the_note_3_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- the_note_4_pio
                 signal out_port_from_the_note_4_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- the_note_5_pio
                 signal out_port_from_the_note_5_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

              -- the_sram
                 signal SRAM_ADDR_from_the_sram : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                 signal SRAM_CE_N_from_the_sram : OUT STD_LOGIC;
                 signal SRAM_DQ_to_and_from_the_sram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                 signal SRAM_LB_N_from_the_sram : OUT STD_LOGIC;
                 signal SRAM_OE_N_from_the_sram : OUT STD_LOGIC;
                 signal SRAM_UB_N_from_the_sram : OUT STD_LOGIC;
                 signal SRAM_WE_N_from_the_sram : OUT STD_LOGIC;

              -- the_status_pio
                 signal in_port_to_the_status_pio : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                 signal out_port_from_the_status_pio : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
              );
end entity nios_system;


architecture europa of nios_system is
component cpu_jtag_debug_module_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_data_master_debugaccess : IN STD_LOGIC;
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_instruction_master_latency_counter : IN STD_LOGIC;
                    signal cpu_instruction_master_read : IN STD_LOGIC;
                    signal cpu_jtag_debug_module_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_jtag_debug_module_resetrequest : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_data_master_requests_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_instruction_master_granted_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_instruction_master_qualified_request_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_instruction_master_read_data_valid_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_instruction_master_requests_cpu_jtag_debug_module : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_address : OUT STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal cpu_jtag_debug_module_begintransfer : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_jtag_debug_module_chipselect : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_debugaccess : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_jtag_debug_module_reset : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_reset_n : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_resetrequest_from_sa : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_write : OUT STD_LOGIC;
                    signal cpu_jtag_debug_module_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_cpu_jtag_debug_module_end_xfer : OUT STD_LOGIC
                 );
end component cpu_jtag_debug_module_arbitrator;

component cpu_data_master_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_byteenable_sram_sram_slave : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_data_master_debugaccess : IN STD_LOGIC;
                    signal cpu_data_master_granted_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_data_master_granted_data_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                    signal cpu_data_master_granted_note_1_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_note_2_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_note_3_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_note_4_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_note_5_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_granted_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_data_master_granted_status_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_data_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_1_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_2_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_3_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_4_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_5_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_data_master_qualified_request_status_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_data_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_1_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_2_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_3_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_4_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_5_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_data_master_read_data_valid_status_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_data_master_requests_data_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_jtag_uart_avalon_jtag_slave : IN STD_LOGIC;
                    signal cpu_data_master_requests_note_1_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_note_2_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_note_3_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_note_4_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_note_5_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_requests_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_data_master_requests_status_pio_s1 : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_cpu_jtag_debug_module_end_xfer : IN STD_LOGIC;
                    signal d1_data_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_jtag_uart_avalon_jtag_slave_end_xfer : IN STD_LOGIC;
                    signal d1_note_1_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_note_2_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_note_3_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_note_4_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_note_5_pio_s1_end_xfer : IN STD_LOGIC;
                    signal d1_sram_sram_slave_end_xfer : IN STD_LOGIC;
                    signal d1_status_pio_s1_end_xfer : IN STD_LOGIC;
                    signal data_pio_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal jtag_uart_avalon_jtag_slave_irq_from_sa : IN STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_avalon_jtag_slave_waitrequest_from_sa : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sram_sram_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal status_pio_s1_readdata_from_sa : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

                 -- outputs:
                    signal cpu_data_master_address_to_slave : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_data_master_dbs_write_16 : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_data_master_irq : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_data_master_latency_counter : OUT STD_LOGIC;
                    signal cpu_data_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_data_master_readdatavalid : OUT STD_LOGIC;
                    signal cpu_data_master_waitrequest : OUT STD_LOGIC
                 );
end component cpu_data_master_arbitrator;

component cpu_instruction_master_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_instruction_master_address : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_instruction_master_granted_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_instruction_master_granted_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_instruction_master_qualified_request_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_instruction_master_qualified_request_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_instruction_master_read : IN STD_LOGIC;
                    signal cpu_instruction_master_read_data_valid_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_instruction_master_read_data_valid_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_instruction_master_requests_cpu_jtag_debug_module : IN STD_LOGIC;
                    signal cpu_instruction_master_requests_sram_sram_slave : IN STD_LOGIC;
                    signal cpu_jtag_debug_module_readdata_from_sa : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d1_cpu_jtag_debug_module_end_xfer : IN STD_LOGIC;
                    signal d1_sram_sram_slave_end_xfer : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sram_sram_slave_readdata_from_sa : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal cpu_instruction_master_address_to_slave : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_instruction_master_dbs_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_instruction_master_latency_counter : OUT STD_LOGIC;
                    signal cpu_instruction_master_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal cpu_instruction_master_readdatavalid : OUT STD_LOGIC;
                    signal cpu_instruction_master_waitrequest : OUT STD_LOGIC
                 );
end component cpu_instruction_master_arbitrator;

component cpu is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal d_irq : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal d_readdatavalid : IN STD_LOGIC;
                    signal d_waitrequest : IN STD_LOGIC;
                    signal i_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal i_readdatavalid : IN STD_LOGIC;
                    signal i_waitrequest : IN STD_LOGIC;
                    signal jtag_debug_module_address : IN STD_LOGIC_VECTOR (8 DOWNTO 0);
                    signal jtag_debug_module_begintransfer : IN STD_LOGIC;
                    signal jtag_debug_module_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal jtag_debug_module_clk : IN STD_LOGIC;
                    signal jtag_debug_module_debugaccess : IN STD_LOGIC;
                    signal jtag_debug_module_reset : IN STD_LOGIC;
                    signal jtag_debug_module_select : IN STD_LOGIC;
                    signal jtag_debug_module_write : IN STD_LOGIC;
                    signal jtag_debug_module_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal d_address : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal d_byteenable : OUT STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal d_read : OUT STD_LOGIC;
                    signal d_write : OUT STD_LOGIC;
                    signal d_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal i_address : OUT STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal i_read : OUT STD_LOGIC;
                    signal jtag_debug_module_debugaccess_to_roms : OUT STD_LOGIC;
                    signal jtag_debug_module_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_debug_module_resetrequest : OUT STD_LOGIC
                 );
end component cpu;

component data_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal data_pio_s1_readdata : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_data_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_data_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_data_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_data_pio_s1 : OUT STD_LOGIC;
                    signal d1_data_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal data_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal data_pio_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal data_pio_s1_reset_n : OUT STD_LOGIC
                 );
end component data_pio_s1_arbitrator;

component data_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal clk : IN STD_LOGIC;
                    signal in_port : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal readdata : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
                 );
end component data_pio;

component jtag_uart_avalon_jtag_slave_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_avalon_jtag_slave_dataavailable : IN STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_irq : IN STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_readdata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_avalon_jtag_slave_readyfordata : IN STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_waitrequest : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                    signal cpu_data_master_requests_jtag_uart_avalon_jtag_slave : OUT STD_LOGIC;
                    signal d1_jtag_uart_avalon_jtag_slave_end_xfer : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_address : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_chipselect : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_dataavailable_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_irq_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_read_n : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal jtag_uart_avalon_jtag_slave_readyfordata_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_reset_n : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_waitrequest_from_sa : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_write_n : OUT STD_LOGIC;
                    signal jtag_uart_avalon_jtag_slave_writedata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
                 );
end component jtag_uart_avalon_jtag_slave_arbitrator;

component jtag_uart is 
           port (
                 -- inputs:
                    signal av_address : IN STD_LOGIC;
                    signal av_chipselect : IN STD_LOGIC;
                    signal av_read_n : IN STD_LOGIC;
                    signal av_write_n : IN STD_LOGIC;
                    signal av_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal clk : IN STD_LOGIC;
                    signal rst_n : IN STD_LOGIC;

                 -- outputs:
                    signal av_irq : OUT STD_LOGIC;
                    signal av_readdata : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal av_waitrequest : OUT STD_LOGIC;
                    signal dataavailable : OUT STD_LOGIC;
                    signal readyfordata : OUT STD_LOGIC
                 );
end component jtag_uart;

component note_1_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_note_1_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_1_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_1_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_note_1_pio_s1 : OUT STD_LOGIC;
                    signal d1_note_1_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal note_1_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal note_1_pio_s1_chipselect : OUT STD_LOGIC;
                    signal note_1_pio_s1_reset_n : OUT STD_LOGIC;
                    signal note_1_pio_s1_write_n : OUT STD_LOGIC;
                    signal note_1_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_1_pio_s1_arbitrator;

component note_1_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_1_pio;

component note_2_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_note_2_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_2_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_2_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_note_2_pio_s1 : OUT STD_LOGIC;
                    signal d1_note_2_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal note_2_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal note_2_pio_s1_chipselect : OUT STD_LOGIC;
                    signal note_2_pio_s1_reset_n : OUT STD_LOGIC;
                    signal note_2_pio_s1_write_n : OUT STD_LOGIC;
                    signal note_2_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_2_pio_s1_arbitrator;

component note_2_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_2_pio;

component note_3_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_note_3_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_3_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_3_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_note_3_pio_s1 : OUT STD_LOGIC;
                    signal d1_note_3_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal note_3_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal note_3_pio_s1_chipselect : OUT STD_LOGIC;
                    signal note_3_pio_s1_reset_n : OUT STD_LOGIC;
                    signal note_3_pio_s1_write_n : OUT STD_LOGIC;
                    signal note_3_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_3_pio_s1_arbitrator;

component note_3_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_3_pio;

component note_4_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_note_4_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_4_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_4_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_note_4_pio_s1 : OUT STD_LOGIC;
                    signal d1_note_4_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal note_4_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal note_4_pio_s1_chipselect : OUT STD_LOGIC;
                    signal note_4_pio_s1_reset_n : OUT STD_LOGIC;
                    signal note_4_pio_s1_write_n : OUT STD_LOGIC;
                    signal note_4_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_4_pio_s1_arbitrator;

component note_4_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_4_pio;

component note_5_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal cpu_data_master_granted_note_5_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_note_5_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_note_5_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_note_5_pio_s1 : OUT STD_LOGIC;
                    signal d1_note_5_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal note_5_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal note_5_pio_s1_chipselect : OUT STD_LOGIC;
                    signal note_5_pio_s1_reset_n : OUT STD_LOGIC;
                    signal note_5_pio_s1_write_n : OUT STD_LOGIC;
                    signal note_5_pio_s1_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_5_pio_s1_arbitrator;

component note_5_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component note_5_pio;

component sram_sram_slave_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_data_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_data_master_dbs_write_16 : IN STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_instruction_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_instruction_master_dbs_address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_instruction_master_latency_counter : IN STD_LOGIC;
                    signal cpu_instruction_master_read : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;
                    signal sram_sram_slave_readdata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal cpu_data_master_byteenable_sram_sram_slave : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal cpu_data_master_granted_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_data_master_requests_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_instruction_master_granted_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_instruction_master_qualified_request_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_instruction_master_read_data_valid_sram_sram_slave : OUT STD_LOGIC;
                    signal cpu_instruction_master_requests_sram_sram_slave : OUT STD_LOGIC;
                    signal d1_sram_sram_slave_end_xfer : OUT STD_LOGIC;
                    signal sram_sram_slave_address : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal sram_sram_slave_byteenable : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal sram_sram_slave_chipselect : OUT STD_LOGIC;
                    signal sram_sram_slave_read : OUT STD_LOGIC;
                    signal sram_sram_slave_readdata_from_sa : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal sram_sram_slave_write : OUT STD_LOGIC;
                    signal sram_sram_slave_writedata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component sram_sram_slave_arbitrator;

component sram is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal byteenable : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal read : IN STD_LOGIC;
                    signal write : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- outputs:
                    signal SRAM_ADDR : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal SRAM_CE_N : OUT STD_LOGIC;
                    signal SRAM_DQ : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal SRAM_LB_N : OUT STD_LOGIC;
                    signal SRAM_OE_N : OUT STD_LOGIC;
                    signal SRAM_UB_N : OUT STD_LOGIC;
                    signal SRAM_WE_N : OUT STD_LOGIC;
                    signal readdata : OUT STD_LOGIC_VECTOR (15 DOWNTO 0)
                 );
end component sram;

component status_pio_s1_arbitrator is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal cpu_data_master_address_to_slave : IN STD_LOGIC_VECTOR (20 DOWNTO 0);
                    signal cpu_data_master_byteenable : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
                    signal cpu_data_master_latency_counter : IN STD_LOGIC;
                    signal cpu_data_master_read : IN STD_LOGIC;
                    signal cpu_data_master_write : IN STD_LOGIC;
                    signal cpu_data_master_writedata : IN STD_LOGIC_VECTOR (31 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;
                    signal status_pio_s1_readdata : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

                 -- outputs:
                    signal cpu_data_master_granted_status_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_qualified_request_status_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_read_data_valid_status_pio_s1 : OUT STD_LOGIC;
                    signal cpu_data_master_requests_status_pio_s1 : OUT STD_LOGIC;
                    signal d1_status_pio_s1_end_xfer : OUT STD_LOGIC;
                    signal status_pio_s1_address : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal status_pio_s1_chipselect : OUT STD_LOGIC;
                    signal status_pio_s1_readdata_from_sa : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal status_pio_s1_reset_n : OUT STD_LOGIC;
                    signal status_pio_s1_write_n : OUT STD_LOGIC;
                    signal status_pio_s1_writedata : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
                 );
end component status_pio_s1_arbitrator;

component status_pio is 
           port (
                 -- inputs:
                    signal address : IN STD_LOGIC_VECTOR (1 DOWNTO 0);
                    signal chipselect : IN STD_LOGIC;
                    signal clk : IN STD_LOGIC;
                    signal in_port : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal reset_n : IN STD_LOGIC;
                    signal write_n : IN STD_LOGIC;
                    signal writedata : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

                 -- outputs:
                    signal out_port : OUT STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal readdata : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
                 );
end component status_pio;

component nios_system_reset_clk_domain_synch_module is 
           port (
                 -- inputs:
                    signal clk : IN STD_LOGIC;
                    signal data_in : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- outputs:
                    signal data_out : OUT STD_LOGIC
                 );
end component nios_system_reset_clk_domain_synch_module;

                signal clk_reset_n :  STD_LOGIC;
                signal cpu_data_master_address :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_data_master_address_to_slave :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_data_master_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_data_master_byteenable_sram_sram_slave :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_data_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_data_master_dbs_write_16 :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal cpu_data_master_debugaccess :  STD_LOGIC;
                signal cpu_data_master_granted_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_data_master_granted_data_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal cpu_data_master_granted_note_1_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_note_2_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_note_3_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_note_4_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_note_5_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_granted_sram_sram_slave :  STD_LOGIC;
                signal cpu_data_master_granted_status_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_irq :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_data_master_latency_counter :  STD_LOGIC;
                signal cpu_data_master_qualified_request_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_data_master_qualified_request_data_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal cpu_data_master_qualified_request_note_1_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_note_2_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_note_3_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_note_4_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_note_5_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_qualified_request_sram_sram_slave :  STD_LOGIC;
                signal cpu_data_master_qualified_request_status_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_data_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_note_1_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_note_2_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_note_3_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_note_4_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_note_5_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_sram_sram_slave :  STD_LOGIC;
                signal cpu_data_master_read_data_valid_status_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_data_master_readdatavalid :  STD_LOGIC;
                signal cpu_data_master_requests_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_data_master_requests_data_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_jtag_uart_avalon_jtag_slave :  STD_LOGIC;
                signal cpu_data_master_requests_note_1_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_note_2_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_note_3_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_note_4_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_note_5_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_requests_sram_sram_slave :  STD_LOGIC;
                signal cpu_data_master_requests_status_pio_s1 :  STD_LOGIC;
                signal cpu_data_master_waitrequest :  STD_LOGIC;
                signal cpu_data_master_write :  STD_LOGIC;
                signal cpu_data_master_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_instruction_master_address :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_instruction_master_address_to_slave :  STD_LOGIC_VECTOR (20 DOWNTO 0);
                signal cpu_instruction_master_dbs_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal cpu_instruction_master_granted_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_instruction_master_granted_sram_sram_slave :  STD_LOGIC;
                signal cpu_instruction_master_latency_counter :  STD_LOGIC;
                signal cpu_instruction_master_qualified_request_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_instruction_master_qualified_request_sram_sram_slave :  STD_LOGIC;
                signal cpu_instruction_master_read :  STD_LOGIC;
                signal cpu_instruction_master_read_data_valid_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_instruction_master_read_data_valid_sram_sram_slave :  STD_LOGIC;
                signal cpu_instruction_master_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_instruction_master_readdatavalid :  STD_LOGIC;
                signal cpu_instruction_master_requests_cpu_jtag_debug_module :  STD_LOGIC;
                signal cpu_instruction_master_requests_sram_sram_slave :  STD_LOGIC;
                signal cpu_instruction_master_waitrequest :  STD_LOGIC;
                signal cpu_jtag_debug_module_address :  STD_LOGIC_VECTOR (8 DOWNTO 0);
                signal cpu_jtag_debug_module_begintransfer :  STD_LOGIC;
                signal cpu_jtag_debug_module_byteenable :  STD_LOGIC_VECTOR (3 DOWNTO 0);
                signal cpu_jtag_debug_module_chipselect :  STD_LOGIC;
                signal cpu_jtag_debug_module_debugaccess :  STD_LOGIC;
                signal cpu_jtag_debug_module_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_jtag_debug_module_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal cpu_jtag_debug_module_reset :  STD_LOGIC;
                signal cpu_jtag_debug_module_reset_n :  STD_LOGIC;
                signal cpu_jtag_debug_module_resetrequest :  STD_LOGIC;
                signal cpu_jtag_debug_module_resetrequest_from_sa :  STD_LOGIC;
                signal cpu_jtag_debug_module_write :  STD_LOGIC;
                signal cpu_jtag_debug_module_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal d1_cpu_jtag_debug_module_end_xfer :  STD_LOGIC;
                signal d1_data_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_jtag_uart_avalon_jtag_slave_end_xfer :  STD_LOGIC;
                signal d1_note_1_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_note_2_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_note_3_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_note_4_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_note_5_pio_s1_end_xfer :  STD_LOGIC;
                signal d1_sram_sram_slave_end_xfer :  STD_LOGIC;
                signal d1_status_pio_s1_end_xfer :  STD_LOGIC;
                signal data_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal data_pio_s1_readdata :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal data_pio_s1_readdata_from_sa :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal data_pio_s1_reset_n :  STD_LOGIC;
                signal internal_SRAM_ADDR_from_the_sram :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal internal_SRAM_CE_N_from_the_sram :  STD_LOGIC;
                signal internal_SRAM_LB_N_from_the_sram :  STD_LOGIC;
                signal internal_SRAM_OE_N_from_the_sram :  STD_LOGIC;
                signal internal_SRAM_UB_N_from_the_sram :  STD_LOGIC;
                signal internal_SRAM_WE_N_from_the_sram :  STD_LOGIC;
                signal internal_out_port_from_the_note_1_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_out_port_from_the_note_2_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_out_port_from_the_note_3_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_out_port_from_the_note_4_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_out_port_from_the_note_5_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal internal_out_port_from_the_status_pio :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_address :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_chipselect :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_dataavailable :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_dataavailable_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_irq :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_irq_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_read_n :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_readdata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_readdata_from_sa :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_readyfordata :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_readyfordata_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_reset_n :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_waitrequest :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_waitrequest_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_write_n :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_writedata :  STD_LOGIC_VECTOR (31 DOWNTO 0);
                signal module_input :  STD_LOGIC;
                signal note_1_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_1_pio_s1_chipselect :  STD_LOGIC;
                signal note_1_pio_s1_reset_n :  STD_LOGIC;
                signal note_1_pio_s1_write_n :  STD_LOGIC;
                signal note_1_pio_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal note_2_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_2_pio_s1_chipselect :  STD_LOGIC;
                signal note_2_pio_s1_reset_n :  STD_LOGIC;
                signal note_2_pio_s1_write_n :  STD_LOGIC;
                signal note_2_pio_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal note_3_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_3_pio_s1_chipselect :  STD_LOGIC;
                signal note_3_pio_s1_reset_n :  STD_LOGIC;
                signal note_3_pio_s1_write_n :  STD_LOGIC;
                signal note_3_pio_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal note_4_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_4_pio_s1_chipselect :  STD_LOGIC;
                signal note_4_pio_s1_reset_n :  STD_LOGIC;
                signal note_4_pio_s1_write_n :  STD_LOGIC;
                signal note_4_pio_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal note_5_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal note_5_pio_s1_chipselect :  STD_LOGIC;
                signal note_5_pio_s1_reset_n :  STD_LOGIC;
                signal note_5_pio_s1_write_n :  STD_LOGIC;
                signal note_5_pio_s1_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal reset_n_sources :  STD_LOGIC;
                signal sram_sram_slave_address :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal sram_sram_slave_byteenable :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal sram_sram_slave_chipselect :  STD_LOGIC;
                signal sram_sram_slave_read :  STD_LOGIC;
                signal sram_sram_slave_readdata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal sram_sram_slave_readdata_from_sa :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal sram_sram_slave_write :  STD_LOGIC;
                signal sram_sram_slave_writedata :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal status_pio_s1_address :  STD_LOGIC_VECTOR (1 DOWNTO 0);
                signal status_pio_s1_chipselect :  STD_LOGIC;
                signal status_pio_s1_readdata :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal status_pio_s1_readdata_from_sa :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal status_pio_s1_reset_n :  STD_LOGIC;
                signal status_pio_s1_write_n :  STD_LOGIC;
                signal status_pio_s1_writedata :  STD_LOGIC_VECTOR (7 DOWNTO 0);

begin

  --the_cpu_jtag_debug_module, which is an e_instance
  the_cpu_jtag_debug_module : cpu_jtag_debug_module_arbitrator
    port map(
      cpu_data_master_granted_cpu_jtag_debug_module => cpu_data_master_granted_cpu_jtag_debug_module,
      cpu_data_master_qualified_request_cpu_jtag_debug_module => cpu_data_master_qualified_request_cpu_jtag_debug_module,
      cpu_data_master_read_data_valid_cpu_jtag_debug_module => cpu_data_master_read_data_valid_cpu_jtag_debug_module,
      cpu_data_master_requests_cpu_jtag_debug_module => cpu_data_master_requests_cpu_jtag_debug_module,
      cpu_instruction_master_granted_cpu_jtag_debug_module => cpu_instruction_master_granted_cpu_jtag_debug_module,
      cpu_instruction_master_qualified_request_cpu_jtag_debug_module => cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
      cpu_instruction_master_read_data_valid_cpu_jtag_debug_module => cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
      cpu_instruction_master_requests_cpu_jtag_debug_module => cpu_instruction_master_requests_cpu_jtag_debug_module,
      cpu_jtag_debug_module_address => cpu_jtag_debug_module_address,
      cpu_jtag_debug_module_begintransfer => cpu_jtag_debug_module_begintransfer,
      cpu_jtag_debug_module_byteenable => cpu_jtag_debug_module_byteenable,
      cpu_jtag_debug_module_chipselect => cpu_jtag_debug_module_chipselect,
      cpu_jtag_debug_module_debugaccess => cpu_jtag_debug_module_debugaccess,
      cpu_jtag_debug_module_readdata_from_sa => cpu_jtag_debug_module_readdata_from_sa,
      cpu_jtag_debug_module_reset => cpu_jtag_debug_module_reset,
      cpu_jtag_debug_module_reset_n => cpu_jtag_debug_module_reset_n,
      cpu_jtag_debug_module_resetrequest_from_sa => cpu_jtag_debug_module_resetrequest_from_sa,
      cpu_jtag_debug_module_write => cpu_jtag_debug_module_write,
      cpu_jtag_debug_module_writedata => cpu_jtag_debug_module_writedata,
      d1_cpu_jtag_debug_module_end_xfer => d1_cpu_jtag_debug_module_end_xfer,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_byteenable => cpu_data_master_byteenable,
      cpu_data_master_debugaccess => cpu_data_master_debugaccess,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      cpu_instruction_master_address_to_slave => cpu_instruction_master_address_to_slave,
      cpu_instruction_master_latency_counter => cpu_instruction_master_latency_counter,
      cpu_instruction_master_read => cpu_instruction_master_read,
      cpu_jtag_debug_module_readdata => cpu_jtag_debug_module_readdata,
      cpu_jtag_debug_module_resetrequest => cpu_jtag_debug_module_resetrequest,
      reset_n => clk_reset_n
    );


  --the_cpu_data_master, which is an e_instance
  the_cpu_data_master : cpu_data_master_arbitrator
    port map(
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_dbs_address => cpu_data_master_dbs_address,
      cpu_data_master_dbs_write_16 => cpu_data_master_dbs_write_16,
      cpu_data_master_irq => cpu_data_master_irq,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_readdata => cpu_data_master_readdata,
      cpu_data_master_readdatavalid => cpu_data_master_readdatavalid,
      cpu_data_master_waitrequest => cpu_data_master_waitrequest,
      clk => clk,
      cpu_data_master_address => cpu_data_master_address,
      cpu_data_master_byteenable_sram_sram_slave => cpu_data_master_byteenable_sram_sram_slave,
      cpu_data_master_debugaccess => cpu_data_master_debugaccess,
      cpu_data_master_granted_cpu_jtag_debug_module => cpu_data_master_granted_cpu_jtag_debug_module,
      cpu_data_master_granted_data_pio_s1 => cpu_data_master_granted_data_pio_s1,
      cpu_data_master_granted_jtag_uart_avalon_jtag_slave => cpu_data_master_granted_jtag_uart_avalon_jtag_slave,
      cpu_data_master_granted_note_1_pio_s1 => cpu_data_master_granted_note_1_pio_s1,
      cpu_data_master_granted_note_2_pio_s1 => cpu_data_master_granted_note_2_pio_s1,
      cpu_data_master_granted_note_3_pio_s1 => cpu_data_master_granted_note_3_pio_s1,
      cpu_data_master_granted_note_4_pio_s1 => cpu_data_master_granted_note_4_pio_s1,
      cpu_data_master_granted_note_5_pio_s1 => cpu_data_master_granted_note_5_pio_s1,
      cpu_data_master_granted_sram_sram_slave => cpu_data_master_granted_sram_sram_slave,
      cpu_data_master_granted_status_pio_s1 => cpu_data_master_granted_status_pio_s1,
      cpu_data_master_qualified_request_cpu_jtag_debug_module => cpu_data_master_qualified_request_cpu_jtag_debug_module,
      cpu_data_master_qualified_request_data_pio_s1 => cpu_data_master_qualified_request_data_pio_s1,
      cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave => cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave,
      cpu_data_master_qualified_request_note_1_pio_s1 => cpu_data_master_qualified_request_note_1_pio_s1,
      cpu_data_master_qualified_request_note_2_pio_s1 => cpu_data_master_qualified_request_note_2_pio_s1,
      cpu_data_master_qualified_request_note_3_pio_s1 => cpu_data_master_qualified_request_note_3_pio_s1,
      cpu_data_master_qualified_request_note_4_pio_s1 => cpu_data_master_qualified_request_note_4_pio_s1,
      cpu_data_master_qualified_request_note_5_pio_s1 => cpu_data_master_qualified_request_note_5_pio_s1,
      cpu_data_master_qualified_request_sram_sram_slave => cpu_data_master_qualified_request_sram_sram_slave,
      cpu_data_master_qualified_request_status_pio_s1 => cpu_data_master_qualified_request_status_pio_s1,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_read_data_valid_cpu_jtag_debug_module => cpu_data_master_read_data_valid_cpu_jtag_debug_module,
      cpu_data_master_read_data_valid_data_pio_s1 => cpu_data_master_read_data_valid_data_pio_s1,
      cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave => cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave,
      cpu_data_master_read_data_valid_note_1_pio_s1 => cpu_data_master_read_data_valid_note_1_pio_s1,
      cpu_data_master_read_data_valid_note_2_pio_s1 => cpu_data_master_read_data_valid_note_2_pio_s1,
      cpu_data_master_read_data_valid_note_3_pio_s1 => cpu_data_master_read_data_valid_note_3_pio_s1,
      cpu_data_master_read_data_valid_note_4_pio_s1 => cpu_data_master_read_data_valid_note_4_pio_s1,
      cpu_data_master_read_data_valid_note_5_pio_s1 => cpu_data_master_read_data_valid_note_5_pio_s1,
      cpu_data_master_read_data_valid_sram_sram_slave => cpu_data_master_read_data_valid_sram_sram_slave,
      cpu_data_master_read_data_valid_status_pio_s1 => cpu_data_master_read_data_valid_status_pio_s1,
      cpu_data_master_requests_cpu_jtag_debug_module => cpu_data_master_requests_cpu_jtag_debug_module,
      cpu_data_master_requests_data_pio_s1 => cpu_data_master_requests_data_pio_s1,
      cpu_data_master_requests_jtag_uart_avalon_jtag_slave => cpu_data_master_requests_jtag_uart_avalon_jtag_slave,
      cpu_data_master_requests_note_1_pio_s1 => cpu_data_master_requests_note_1_pio_s1,
      cpu_data_master_requests_note_2_pio_s1 => cpu_data_master_requests_note_2_pio_s1,
      cpu_data_master_requests_note_3_pio_s1 => cpu_data_master_requests_note_3_pio_s1,
      cpu_data_master_requests_note_4_pio_s1 => cpu_data_master_requests_note_4_pio_s1,
      cpu_data_master_requests_note_5_pio_s1 => cpu_data_master_requests_note_5_pio_s1,
      cpu_data_master_requests_sram_sram_slave => cpu_data_master_requests_sram_sram_slave,
      cpu_data_master_requests_status_pio_s1 => cpu_data_master_requests_status_pio_s1,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      cpu_jtag_debug_module_readdata_from_sa => cpu_jtag_debug_module_readdata_from_sa,
      d1_cpu_jtag_debug_module_end_xfer => d1_cpu_jtag_debug_module_end_xfer,
      d1_data_pio_s1_end_xfer => d1_data_pio_s1_end_xfer,
      d1_jtag_uart_avalon_jtag_slave_end_xfer => d1_jtag_uart_avalon_jtag_slave_end_xfer,
      d1_note_1_pio_s1_end_xfer => d1_note_1_pio_s1_end_xfer,
      d1_note_2_pio_s1_end_xfer => d1_note_2_pio_s1_end_xfer,
      d1_note_3_pio_s1_end_xfer => d1_note_3_pio_s1_end_xfer,
      d1_note_4_pio_s1_end_xfer => d1_note_4_pio_s1_end_xfer,
      d1_note_5_pio_s1_end_xfer => d1_note_5_pio_s1_end_xfer,
      d1_sram_sram_slave_end_xfer => d1_sram_sram_slave_end_xfer,
      d1_status_pio_s1_end_xfer => d1_status_pio_s1_end_xfer,
      data_pio_s1_readdata_from_sa => data_pio_s1_readdata_from_sa,
      jtag_uart_avalon_jtag_slave_irq_from_sa => jtag_uart_avalon_jtag_slave_irq_from_sa,
      jtag_uart_avalon_jtag_slave_readdata_from_sa => jtag_uart_avalon_jtag_slave_readdata_from_sa,
      jtag_uart_avalon_jtag_slave_waitrequest_from_sa => jtag_uart_avalon_jtag_slave_waitrequest_from_sa,
      reset_n => clk_reset_n,
      sram_sram_slave_readdata_from_sa => sram_sram_slave_readdata_from_sa,
      status_pio_s1_readdata_from_sa => status_pio_s1_readdata_from_sa
    );


  --the_cpu_instruction_master, which is an e_instance
  the_cpu_instruction_master : cpu_instruction_master_arbitrator
    port map(
      cpu_instruction_master_address_to_slave => cpu_instruction_master_address_to_slave,
      cpu_instruction_master_dbs_address => cpu_instruction_master_dbs_address,
      cpu_instruction_master_latency_counter => cpu_instruction_master_latency_counter,
      cpu_instruction_master_readdata => cpu_instruction_master_readdata,
      cpu_instruction_master_readdatavalid => cpu_instruction_master_readdatavalid,
      cpu_instruction_master_waitrequest => cpu_instruction_master_waitrequest,
      clk => clk,
      cpu_instruction_master_address => cpu_instruction_master_address,
      cpu_instruction_master_granted_cpu_jtag_debug_module => cpu_instruction_master_granted_cpu_jtag_debug_module,
      cpu_instruction_master_granted_sram_sram_slave => cpu_instruction_master_granted_sram_sram_slave,
      cpu_instruction_master_qualified_request_cpu_jtag_debug_module => cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
      cpu_instruction_master_qualified_request_sram_sram_slave => cpu_instruction_master_qualified_request_sram_sram_slave,
      cpu_instruction_master_read => cpu_instruction_master_read,
      cpu_instruction_master_read_data_valid_cpu_jtag_debug_module => cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
      cpu_instruction_master_read_data_valid_sram_sram_slave => cpu_instruction_master_read_data_valid_sram_sram_slave,
      cpu_instruction_master_requests_cpu_jtag_debug_module => cpu_instruction_master_requests_cpu_jtag_debug_module,
      cpu_instruction_master_requests_sram_sram_slave => cpu_instruction_master_requests_sram_sram_slave,
      cpu_jtag_debug_module_readdata_from_sa => cpu_jtag_debug_module_readdata_from_sa,
      d1_cpu_jtag_debug_module_end_xfer => d1_cpu_jtag_debug_module_end_xfer,
      d1_sram_sram_slave_end_xfer => d1_sram_sram_slave_end_xfer,
      reset_n => clk_reset_n,
      sram_sram_slave_readdata_from_sa => sram_sram_slave_readdata_from_sa
    );


  --the_cpu, which is an e_ptf_instance
  the_cpu : cpu
    port map(
      d_address => cpu_data_master_address,
      d_byteenable => cpu_data_master_byteenable,
      d_read => cpu_data_master_read,
      d_write => cpu_data_master_write,
      d_writedata => cpu_data_master_writedata,
      i_address => cpu_instruction_master_address,
      i_read => cpu_instruction_master_read,
      jtag_debug_module_debugaccess_to_roms => cpu_data_master_debugaccess,
      jtag_debug_module_readdata => cpu_jtag_debug_module_readdata,
      jtag_debug_module_resetrequest => cpu_jtag_debug_module_resetrequest,
      clk => clk,
      d_irq => cpu_data_master_irq,
      d_readdata => cpu_data_master_readdata,
      d_readdatavalid => cpu_data_master_readdatavalid,
      d_waitrequest => cpu_data_master_waitrequest,
      i_readdata => cpu_instruction_master_readdata,
      i_readdatavalid => cpu_instruction_master_readdatavalid,
      i_waitrequest => cpu_instruction_master_waitrequest,
      jtag_debug_module_address => cpu_jtag_debug_module_address,
      jtag_debug_module_begintransfer => cpu_jtag_debug_module_begintransfer,
      jtag_debug_module_byteenable => cpu_jtag_debug_module_byteenable,
      jtag_debug_module_clk => clk,
      jtag_debug_module_debugaccess => cpu_jtag_debug_module_debugaccess,
      jtag_debug_module_reset => cpu_jtag_debug_module_reset,
      jtag_debug_module_select => cpu_jtag_debug_module_chipselect,
      jtag_debug_module_write => cpu_jtag_debug_module_write,
      jtag_debug_module_writedata => cpu_jtag_debug_module_writedata,
      reset_n => cpu_jtag_debug_module_reset_n
    );


  --the_data_pio_s1, which is an e_instance
  the_data_pio_s1 : data_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_data_pio_s1 => cpu_data_master_granted_data_pio_s1,
      cpu_data_master_qualified_request_data_pio_s1 => cpu_data_master_qualified_request_data_pio_s1,
      cpu_data_master_read_data_valid_data_pio_s1 => cpu_data_master_read_data_valid_data_pio_s1,
      cpu_data_master_requests_data_pio_s1 => cpu_data_master_requests_data_pio_s1,
      d1_data_pio_s1_end_xfer => d1_data_pio_s1_end_xfer,
      data_pio_s1_address => data_pio_s1_address,
      data_pio_s1_readdata_from_sa => data_pio_s1_readdata_from_sa,
      data_pio_s1_reset_n => data_pio_s1_reset_n,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      data_pio_s1_readdata => data_pio_s1_readdata,
      reset_n => clk_reset_n
    );


  --the_data_pio, which is an e_ptf_instance
  the_data_pio : data_pio
    port map(
      readdata => data_pio_s1_readdata,
      address => data_pio_s1_address,
      clk => clk,
      in_port => in_port_to_the_data_pio,
      reset_n => data_pio_s1_reset_n
    );


  --the_jtag_uart_avalon_jtag_slave, which is an e_instance
  the_jtag_uart_avalon_jtag_slave : jtag_uart_avalon_jtag_slave_arbitrator
    port map(
      cpu_data_master_granted_jtag_uart_avalon_jtag_slave => cpu_data_master_granted_jtag_uart_avalon_jtag_slave,
      cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave => cpu_data_master_qualified_request_jtag_uart_avalon_jtag_slave,
      cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave => cpu_data_master_read_data_valid_jtag_uart_avalon_jtag_slave,
      cpu_data_master_requests_jtag_uart_avalon_jtag_slave => cpu_data_master_requests_jtag_uart_avalon_jtag_slave,
      d1_jtag_uart_avalon_jtag_slave_end_xfer => d1_jtag_uart_avalon_jtag_slave_end_xfer,
      jtag_uart_avalon_jtag_slave_address => jtag_uart_avalon_jtag_slave_address,
      jtag_uart_avalon_jtag_slave_chipselect => jtag_uart_avalon_jtag_slave_chipselect,
      jtag_uart_avalon_jtag_slave_dataavailable_from_sa => jtag_uart_avalon_jtag_slave_dataavailable_from_sa,
      jtag_uart_avalon_jtag_slave_irq_from_sa => jtag_uart_avalon_jtag_slave_irq_from_sa,
      jtag_uart_avalon_jtag_slave_read_n => jtag_uart_avalon_jtag_slave_read_n,
      jtag_uart_avalon_jtag_slave_readdata_from_sa => jtag_uart_avalon_jtag_slave_readdata_from_sa,
      jtag_uart_avalon_jtag_slave_readyfordata_from_sa => jtag_uart_avalon_jtag_slave_readyfordata_from_sa,
      jtag_uart_avalon_jtag_slave_reset_n => jtag_uart_avalon_jtag_slave_reset_n,
      jtag_uart_avalon_jtag_slave_waitrequest_from_sa => jtag_uart_avalon_jtag_slave_waitrequest_from_sa,
      jtag_uart_avalon_jtag_slave_write_n => jtag_uart_avalon_jtag_slave_write_n,
      jtag_uart_avalon_jtag_slave_writedata => jtag_uart_avalon_jtag_slave_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      jtag_uart_avalon_jtag_slave_dataavailable => jtag_uart_avalon_jtag_slave_dataavailable,
      jtag_uart_avalon_jtag_slave_irq => jtag_uart_avalon_jtag_slave_irq,
      jtag_uart_avalon_jtag_slave_readdata => jtag_uart_avalon_jtag_slave_readdata,
      jtag_uart_avalon_jtag_slave_readyfordata => jtag_uart_avalon_jtag_slave_readyfordata,
      jtag_uart_avalon_jtag_slave_waitrequest => jtag_uart_avalon_jtag_slave_waitrequest,
      reset_n => clk_reset_n
    );


  --the_jtag_uart, which is an e_ptf_instance
  the_jtag_uart : jtag_uart
    port map(
      av_irq => jtag_uart_avalon_jtag_slave_irq,
      av_readdata => jtag_uart_avalon_jtag_slave_readdata,
      av_waitrequest => jtag_uart_avalon_jtag_slave_waitrequest,
      dataavailable => jtag_uart_avalon_jtag_slave_dataavailable,
      readyfordata => jtag_uart_avalon_jtag_slave_readyfordata,
      av_address => jtag_uart_avalon_jtag_slave_address,
      av_chipselect => jtag_uart_avalon_jtag_slave_chipselect,
      av_read_n => jtag_uart_avalon_jtag_slave_read_n,
      av_write_n => jtag_uart_avalon_jtag_slave_write_n,
      av_writedata => jtag_uart_avalon_jtag_slave_writedata,
      clk => clk,
      rst_n => jtag_uart_avalon_jtag_slave_reset_n
    );


  --the_note_1_pio_s1, which is an e_instance
  the_note_1_pio_s1 : note_1_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_note_1_pio_s1 => cpu_data_master_granted_note_1_pio_s1,
      cpu_data_master_qualified_request_note_1_pio_s1 => cpu_data_master_qualified_request_note_1_pio_s1,
      cpu_data_master_read_data_valid_note_1_pio_s1 => cpu_data_master_read_data_valid_note_1_pio_s1,
      cpu_data_master_requests_note_1_pio_s1 => cpu_data_master_requests_note_1_pio_s1,
      d1_note_1_pio_s1_end_xfer => d1_note_1_pio_s1_end_xfer,
      note_1_pio_s1_address => note_1_pio_s1_address,
      note_1_pio_s1_chipselect => note_1_pio_s1_chipselect,
      note_1_pio_s1_reset_n => note_1_pio_s1_reset_n,
      note_1_pio_s1_write_n => note_1_pio_s1_write_n,
      note_1_pio_s1_writedata => note_1_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n
    );


  --the_note_1_pio, which is an e_ptf_instance
  the_note_1_pio : note_1_pio
    port map(
      out_port => internal_out_port_from_the_note_1_pio,
      address => note_1_pio_s1_address,
      chipselect => note_1_pio_s1_chipselect,
      clk => clk,
      reset_n => note_1_pio_s1_reset_n,
      write_n => note_1_pio_s1_write_n,
      writedata => note_1_pio_s1_writedata
    );


  --the_note_2_pio_s1, which is an e_instance
  the_note_2_pio_s1 : note_2_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_note_2_pio_s1 => cpu_data_master_granted_note_2_pio_s1,
      cpu_data_master_qualified_request_note_2_pio_s1 => cpu_data_master_qualified_request_note_2_pio_s1,
      cpu_data_master_read_data_valid_note_2_pio_s1 => cpu_data_master_read_data_valid_note_2_pio_s1,
      cpu_data_master_requests_note_2_pio_s1 => cpu_data_master_requests_note_2_pio_s1,
      d1_note_2_pio_s1_end_xfer => d1_note_2_pio_s1_end_xfer,
      note_2_pio_s1_address => note_2_pio_s1_address,
      note_2_pio_s1_chipselect => note_2_pio_s1_chipselect,
      note_2_pio_s1_reset_n => note_2_pio_s1_reset_n,
      note_2_pio_s1_write_n => note_2_pio_s1_write_n,
      note_2_pio_s1_writedata => note_2_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n
    );


  --the_note_2_pio, which is an e_ptf_instance
  the_note_2_pio : note_2_pio
    port map(
      out_port => internal_out_port_from_the_note_2_pio,
      address => note_2_pio_s1_address,
      chipselect => note_2_pio_s1_chipselect,
      clk => clk,
      reset_n => note_2_pio_s1_reset_n,
      write_n => note_2_pio_s1_write_n,
      writedata => note_2_pio_s1_writedata
    );


  --the_note_3_pio_s1, which is an e_instance
  the_note_3_pio_s1 : note_3_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_note_3_pio_s1 => cpu_data_master_granted_note_3_pio_s1,
      cpu_data_master_qualified_request_note_3_pio_s1 => cpu_data_master_qualified_request_note_3_pio_s1,
      cpu_data_master_read_data_valid_note_3_pio_s1 => cpu_data_master_read_data_valid_note_3_pio_s1,
      cpu_data_master_requests_note_3_pio_s1 => cpu_data_master_requests_note_3_pio_s1,
      d1_note_3_pio_s1_end_xfer => d1_note_3_pio_s1_end_xfer,
      note_3_pio_s1_address => note_3_pio_s1_address,
      note_3_pio_s1_chipselect => note_3_pio_s1_chipselect,
      note_3_pio_s1_reset_n => note_3_pio_s1_reset_n,
      note_3_pio_s1_write_n => note_3_pio_s1_write_n,
      note_3_pio_s1_writedata => note_3_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n
    );


  --the_note_3_pio, which is an e_ptf_instance
  the_note_3_pio : note_3_pio
    port map(
      out_port => internal_out_port_from_the_note_3_pio,
      address => note_3_pio_s1_address,
      chipselect => note_3_pio_s1_chipselect,
      clk => clk,
      reset_n => note_3_pio_s1_reset_n,
      write_n => note_3_pio_s1_write_n,
      writedata => note_3_pio_s1_writedata
    );


  --the_note_4_pio_s1, which is an e_instance
  the_note_4_pio_s1 : note_4_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_note_4_pio_s1 => cpu_data_master_granted_note_4_pio_s1,
      cpu_data_master_qualified_request_note_4_pio_s1 => cpu_data_master_qualified_request_note_4_pio_s1,
      cpu_data_master_read_data_valid_note_4_pio_s1 => cpu_data_master_read_data_valid_note_4_pio_s1,
      cpu_data_master_requests_note_4_pio_s1 => cpu_data_master_requests_note_4_pio_s1,
      d1_note_4_pio_s1_end_xfer => d1_note_4_pio_s1_end_xfer,
      note_4_pio_s1_address => note_4_pio_s1_address,
      note_4_pio_s1_chipselect => note_4_pio_s1_chipselect,
      note_4_pio_s1_reset_n => note_4_pio_s1_reset_n,
      note_4_pio_s1_write_n => note_4_pio_s1_write_n,
      note_4_pio_s1_writedata => note_4_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n
    );


  --the_note_4_pio, which is an e_ptf_instance
  the_note_4_pio : note_4_pio
    port map(
      out_port => internal_out_port_from_the_note_4_pio,
      address => note_4_pio_s1_address,
      chipselect => note_4_pio_s1_chipselect,
      clk => clk,
      reset_n => note_4_pio_s1_reset_n,
      write_n => note_4_pio_s1_write_n,
      writedata => note_4_pio_s1_writedata
    );


  --the_note_5_pio_s1, which is an e_instance
  the_note_5_pio_s1 : note_5_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_note_5_pio_s1 => cpu_data_master_granted_note_5_pio_s1,
      cpu_data_master_qualified_request_note_5_pio_s1 => cpu_data_master_qualified_request_note_5_pio_s1,
      cpu_data_master_read_data_valid_note_5_pio_s1 => cpu_data_master_read_data_valid_note_5_pio_s1,
      cpu_data_master_requests_note_5_pio_s1 => cpu_data_master_requests_note_5_pio_s1,
      d1_note_5_pio_s1_end_xfer => d1_note_5_pio_s1_end_xfer,
      note_5_pio_s1_address => note_5_pio_s1_address,
      note_5_pio_s1_chipselect => note_5_pio_s1_chipselect,
      note_5_pio_s1_reset_n => note_5_pio_s1_reset_n,
      note_5_pio_s1_write_n => note_5_pio_s1_write_n,
      note_5_pio_s1_writedata => note_5_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n
    );


  --the_note_5_pio, which is an e_ptf_instance
  the_note_5_pio : note_5_pio
    port map(
      out_port => internal_out_port_from_the_note_5_pio,
      address => note_5_pio_s1_address,
      chipselect => note_5_pio_s1_chipselect,
      clk => clk,
      reset_n => note_5_pio_s1_reset_n,
      write_n => note_5_pio_s1_write_n,
      writedata => note_5_pio_s1_writedata
    );


  --the_sram_sram_slave, which is an e_instance
  the_sram_sram_slave : sram_sram_slave_arbitrator
    port map(
      cpu_data_master_byteenable_sram_sram_slave => cpu_data_master_byteenable_sram_sram_slave,
      cpu_data_master_granted_sram_sram_slave => cpu_data_master_granted_sram_sram_slave,
      cpu_data_master_qualified_request_sram_sram_slave => cpu_data_master_qualified_request_sram_sram_slave,
      cpu_data_master_read_data_valid_sram_sram_slave => cpu_data_master_read_data_valid_sram_sram_slave,
      cpu_data_master_requests_sram_sram_slave => cpu_data_master_requests_sram_sram_slave,
      cpu_instruction_master_granted_sram_sram_slave => cpu_instruction_master_granted_sram_sram_slave,
      cpu_instruction_master_qualified_request_sram_sram_slave => cpu_instruction_master_qualified_request_sram_sram_slave,
      cpu_instruction_master_read_data_valid_sram_sram_slave => cpu_instruction_master_read_data_valid_sram_sram_slave,
      cpu_instruction_master_requests_sram_sram_slave => cpu_instruction_master_requests_sram_sram_slave,
      d1_sram_sram_slave_end_xfer => d1_sram_sram_slave_end_xfer,
      sram_sram_slave_address => sram_sram_slave_address,
      sram_sram_slave_byteenable => sram_sram_slave_byteenable,
      sram_sram_slave_chipselect => sram_sram_slave_chipselect,
      sram_sram_slave_read => sram_sram_slave_read,
      sram_sram_slave_readdata_from_sa => sram_sram_slave_readdata_from_sa,
      sram_sram_slave_write => sram_sram_slave_write,
      sram_sram_slave_writedata => sram_sram_slave_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_byteenable => cpu_data_master_byteenable,
      cpu_data_master_dbs_address => cpu_data_master_dbs_address,
      cpu_data_master_dbs_write_16 => cpu_data_master_dbs_write_16,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_instruction_master_address_to_slave => cpu_instruction_master_address_to_slave,
      cpu_instruction_master_dbs_address => cpu_instruction_master_dbs_address,
      cpu_instruction_master_latency_counter => cpu_instruction_master_latency_counter,
      cpu_instruction_master_read => cpu_instruction_master_read,
      reset_n => clk_reset_n,
      sram_sram_slave_readdata => sram_sram_slave_readdata
    );


  --the_sram, which is an e_ptf_instance
  the_sram : sram
    port map(
      SRAM_ADDR => internal_SRAM_ADDR_from_the_sram,
      SRAM_CE_N => internal_SRAM_CE_N_from_the_sram,
      SRAM_DQ => SRAM_DQ_to_and_from_the_sram,
      SRAM_LB_N => internal_SRAM_LB_N_from_the_sram,
      SRAM_OE_N => internal_SRAM_OE_N_from_the_sram,
      SRAM_UB_N => internal_SRAM_UB_N_from_the_sram,
      SRAM_WE_N => internal_SRAM_WE_N_from_the_sram,
      readdata => sram_sram_slave_readdata,
      address => sram_sram_slave_address,
      byteenable => sram_sram_slave_byteenable,
      chipselect => sram_sram_slave_chipselect,
      read => sram_sram_slave_read,
      write => sram_sram_slave_write,
      writedata => sram_sram_slave_writedata
    );


  --the_status_pio_s1, which is an e_instance
  the_status_pio_s1 : status_pio_s1_arbitrator
    port map(
      cpu_data_master_granted_status_pio_s1 => cpu_data_master_granted_status_pio_s1,
      cpu_data_master_qualified_request_status_pio_s1 => cpu_data_master_qualified_request_status_pio_s1,
      cpu_data_master_read_data_valid_status_pio_s1 => cpu_data_master_read_data_valid_status_pio_s1,
      cpu_data_master_requests_status_pio_s1 => cpu_data_master_requests_status_pio_s1,
      d1_status_pio_s1_end_xfer => d1_status_pio_s1_end_xfer,
      status_pio_s1_address => status_pio_s1_address,
      status_pio_s1_chipselect => status_pio_s1_chipselect,
      status_pio_s1_readdata_from_sa => status_pio_s1_readdata_from_sa,
      status_pio_s1_reset_n => status_pio_s1_reset_n,
      status_pio_s1_write_n => status_pio_s1_write_n,
      status_pio_s1_writedata => status_pio_s1_writedata,
      clk => clk,
      cpu_data_master_address_to_slave => cpu_data_master_address_to_slave,
      cpu_data_master_byteenable => cpu_data_master_byteenable,
      cpu_data_master_latency_counter => cpu_data_master_latency_counter,
      cpu_data_master_read => cpu_data_master_read,
      cpu_data_master_write => cpu_data_master_write,
      cpu_data_master_writedata => cpu_data_master_writedata,
      reset_n => clk_reset_n,
      status_pio_s1_readdata => status_pio_s1_readdata
    );


  --the_status_pio, which is an e_ptf_instance
  the_status_pio : status_pio
    port map(
      out_port => internal_out_port_from_the_status_pio,
      readdata => status_pio_s1_readdata,
      address => status_pio_s1_address,
      chipselect => status_pio_s1_chipselect,
      clk => clk,
      in_port => in_port_to_the_status_pio,
      reset_n => status_pio_s1_reset_n,
      write_n => status_pio_s1_write_n,
      writedata => status_pio_s1_writedata
    );


  --reset is asserted asynchronously and deasserted synchronously
  nios_system_reset_clk_domain_synch : nios_system_reset_clk_domain_synch_module
    port map(
      data_out => clk_reset_n,
      clk => clk,
      data_in => module_input,
      reset_n => reset_n_sources
    );

  module_input <= std_logic'('1');

  --reset sources mux, which is an e_mux
  reset_n_sources <= Vector_To_Std_Logic(NOT (((((std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(NOT reset_n))) OR std_logic_vector'("00000000000000000000000000000000")) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_jtag_debug_module_resetrequest_from_sa)))) OR (std_logic_vector'("0000000000000000000000000000000") & (A_TOSTDLOGICVECTOR(cpu_jtag_debug_module_resetrequest_from_sa))))));
  --vhdl renameroo for output signals
  SRAM_ADDR_from_the_sram <= internal_SRAM_ADDR_from_the_sram;
  --vhdl renameroo for output signals
  SRAM_CE_N_from_the_sram <= internal_SRAM_CE_N_from_the_sram;
  --vhdl renameroo for output signals
  SRAM_LB_N_from_the_sram <= internal_SRAM_LB_N_from_the_sram;
  --vhdl renameroo for output signals
  SRAM_OE_N_from_the_sram <= internal_SRAM_OE_N_from_the_sram;
  --vhdl renameroo for output signals
  SRAM_UB_N_from_the_sram <= internal_SRAM_UB_N_from_the_sram;
  --vhdl renameroo for output signals
  SRAM_WE_N_from_the_sram <= internal_SRAM_WE_N_from_the_sram;
  --vhdl renameroo for output signals
  out_port_from_the_note_1_pio <= internal_out_port_from_the_note_1_pio;
  --vhdl renameroo for output signals
  out_port_from_the_note_2_pio <= internal_out_port_from_the_note_2_pio;
  --vhdl renameroo for output signals
  out_port_from_the_note_3_pio <= internal_out_port_from_the_note_3_pio;
  --vhdl renameroo for output signals
  out_port_from_the_note_4_pio <= internal_out_port_from_the_note_4_pio;
  --vhdl renameroo for output signals
  out_port_from_the_note_5_pio <= internal_out_port_from_the_note_5_pio;
  --vhdl renameroo for output signals
  out_port_from_the_status_pio <= internal_out_port_from_the_status_pio;

end europa;


--synthesis translate_off

library altera;
use altera.altera_europa_support_lib.all;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;



-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add your libraries here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>

entity test_bench is 
end entity test_bench;


architecture europa of test_bench is
component nios_system is 
           port (
                 -- 1) global signals:
                    signal clk : IN STD_LOGIC;
                    signal reset_n : IN STD_LOGIC;

                 -- the_data_pio
                    signal in_port_to_the_data_pio : IN STD_LOGIC_VECTOR (7 DOWNTO 0);

                 -- the_note_1_pio
                    signal out_port_from_the_note_1_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- the_note_2_pio
                    signal out_port_from_the_note_2_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- the_note_3_pio
                    signal out_port_from_the_note_3_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- the_note_4_pio
                    signal out_port_from_the_note_4_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- the_note_5_pio
                    signal out_port_from_the_note_5_pio : OUT STD_LOGIC_VECTOR (15 DOWNTO 0);

                 -- the_sram
                    signal SRAM_ADDR_from_the_sram : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
                    signal SRAM_CE_N_from_the_sram : OUT STD_LOGIC;
                    signal SRAM_DQ_to_and_from_the_sram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
                    signal SRAM_LB_N_from_the_sram : OUT STD_LOGIC;
                    signal SRAM_OE_N_from_the_sram : OUT STD_LOGIC;
                    signal SRAM_UB_N_from_the_sram : OUT STD_LOGIC;
                    signal SRAM_WE_N_from_the_sram : OUT STD_LOGIC;

                 -- the_status_pio
                    signal in_port_to_the_status_pio : IN STD_LOGIC_VECTOR (7 DOWNTO 0);
                    signal out_port_from_the_status_pio : OUT STD_LOGIC_VECTOR (7 DOWNTO 0)
                 );
end component nios_system;

                signal SRAM_ADDR_from_the_sram :  STD_LOGIC_VECTOR (17 DOWNTO 0);
                signal SRAM_CE_N_from_the_sram :  STD_LOGIC;
                signal SRAM_DQ_to_and_from_the_sram :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal SRAM_LB_N_from_the_sram :  STD_LOGIC;
                signal SRAM_OE_N_from_the_sram :  STD_LOGIC;
                signal SRAM_UB_N_from_the_sram :  STD_LOGIC;
                signal SRAM_WE_N_from_the_sram :  STD_LOGIC;
                signal clk :  STD_LOGIC;
                signal in_port_to_the_data_pio :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal in_port_to_the_status_pio :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal jtag_uart_avalon_jtag_slave_dataavailable_from_sa :  STD_LOGIC;
                signal jtag_uart_avalon_jtag_slave_readyfordata_from_sa :  STD_LOGIC;
                signal out_port_from_the_note_1_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal out_port_from_the_note_2_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal out_port_from_the_note_3_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal out_port_from_the_note_4_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal out_port_from_the_note_5_pio :  STD_LOGIC_VECTOR (15 DOWNTO 0);
                signal out_port_from_the_status_pio :  STD_LOGIC_VECTOR (7 DOWNTO 0);
                signal reset_n :  STD_LOGIC;


-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add your component and signal declaration here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>


begin

  --Set us up the Dut
  DUT : nios_system
    port map(
      SRAM_ADDR_from_the_sram => SRAM_ADDR_from_the_sram,
      SRAM_CE_N_from_the_sram => SRAM_CE_N_from_the_sram,
      SRAM_DQ_to_and_from_the_sram => SRAM_DQ_to_and_from_the_sram,
      SRAM_LB_N_from_the_sram => SRAM_LB_N_from_the_sram,
      SRAM_OE_N_from_the_sram => SRAM_OE_N_from_the_sram,
      SRAM_UB_N_from_the_sram => SRAM_UB_N_from_the_sram,
      SRAM_WE_N_from_the_sram => SRAM_WE_N_from_the_sram,
      out_port_from_the_note_1_pio => out_port_from_the_note_1_pio,
      out_port_from_the_note_2_pio => out_port_from_the_note_2_pio,
      out_port_from_the_note_3_pio => out_port_from_the_note_3_pio,
      out_port_from_the_note_4_pio => out_port_from_the_note_4_pio,
      out_port_from_the_note_5_pio => out_port_from_the_note_5_pio,
      out_port_from_the_status_pio => out_port_from_the_status_pio,
      clk => clk,
      in_port_to_the_data_pio => in_port_to_the_data_pio,
      in_port_to_the_status_pio => in_port_to_the_status_pio,
      reset_n => reset_n
    );


  process
  begin
    clk <= '0';
    loop
       wait for 10 ns;
       clk <= not clk;
    end loop;
  end process;
  PROCESS
    BEGIN
       reset_n <= '0';
       wait for 200 ns;
       reset_n <= '1'; 
    WAIT;
  END PROCESS;


-- <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
--add additional architecture here
-- AND HERE WILL BE PRESERVED </ALTERA_NOTE>


end europa;



--synthesis translate_on
