library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

package soundtrack is

type SOUND1 is array(integer range 0 to 143) of unsigned(15 downto 0);
type SOUND2 is array(integer range 0 to 1599) of unsigned(15 downto 0);

constant default: SOUND1 := (
    X"0000",
    X"30F8",
    X"5A72",
    X"7624",
    X"7FFE",
    X"76C1",
    X"5C1C",
    X"3450",
    X"0568",
    X"D635",
    X"AD3C",
    X"8FCB",
    X"8148",
    X"82E6",
    X"93AB",
    X"B0CE",
    X"D646",
    X"FF71",
    X"27BC",
    X"4B28",
    X"66AF",
    X"7874",
    X"7FC5",
    X"7CFE",
    X"714F",
    X"5E78",
    X"4685",
    X"2B8D",
    X"0F81",
    X"F409",
    X"DA72",
    X"C3A9",
    X"B03A",
    X"A062",
    X"9416",
    X"8B1E",
    X"851A",
    X"8199",
    X"8021",
    X"8038",
    X"816D",
    X"8359",
    X"85A2",
    X"8800",
    X"8A37",
    X"8C18",
    X"8D84",
    X"8E65",
    X"8EB0",
    X"8E66",
    X"8D8E",
    X"8C38",
    X"8A7B",
    X"8878",
    X"8653",
    X"8438",
    X"8258",
    X"80E5",
    X"8018",
    X"8027",
    X"8148",
    X"83AD",
    X"8781",
    X"8CE6",
    X"93F4",
    X"9CB4",
    X"A720",
    X"B323",
    X"C097",
    X"CF48",
    X"DEF4",
    X"EF4D",
    X"0000",
    X"10B2",
    X"210B",
    X"30B7",
    X"3F68",
    X"4CDC",
    X"58DF",
    X"634B",
    X"6C0B",
    X"7319",
    X"787E",
    X"7C52",
    X"7EB7",
    X"7FD8",
    X"7FE7",
    X"7F1A",
    X"7DA7",
    X"7BC7",
    X"79AC",
    X"7787",
    X"7584",
    X"73C7",
    X"7271",
    X"7199",
    X"714F",
    X"719A",
    X"727B",
    X"73E7",
    X"75C8",
    X"77FF",
    X"7A5D",
    X"7CA6",
    X"7E92",
    X"7FC7",
    X"7FDE",
    X"7E66",
    X"7AE5",
    X"7AE1",
    X"6BE9",
    X"5F9D",
    X"4FC5",
    X"3C56",
    X"258D",
    X"0BF6",
    X"F07E",
    X"D472",
    X"B97A",
    X"A187",
    X"8EB0",
    X"8301",
    X"803A",
    X"878B",
    X"9950",
    X"B4D7",
    X"D843",
    X"008E",
    X"29B9",
    X"4F31",
    X"6C54",
    X"7D19",
    X"7EB7",
    X"7034",
    X"52C3",
    X"29CA",
    X"FA97",
    X"CBAF",
    X"A3E3",
    X"893E",
    X"8001",
    X"89DB",
    X"A58D",
    X"CF07");

constant jump: SOUND2 := (
X"fb33",
X"fa97",
X"cd9c",
X"9956",
X"f432",
X"fe22",
X"075e",
X"10fa",
X"3651",
X"1274",
X"ea4c",
X"e8b3",
X"d8db",
X"c0bc",
X"a3e0",
X"1a4c",
X"05aa",
X"2a94",
X"4345",
X"7fff",
X"1389",
X"15a3",
X"eb63",
X"e0f2",
X"a769",
X"ba72",
X"1629",
X"134d",
X"3844",
X"3876",
X"63f1",
X"ec97",
X"ee50",
X"c400",
X"ab4a",
X"87cd",
X"d393",
X"0485",
X"175a",
X"475c",
X"54c0",
X"597c",
X"f1ce",
X"e59d",
X"bc44",
X"abc5",
X"8b24",
X"f103",
X"103a",
X"31e5",
X"5b8d",
X"6b68",
X"406e",
X"02f2",
X"e9a4",
X"c41e",
X"a4c7",
X"ae6b",
X"03eb",
X"163a",
X"3b0d",
X"59d9",
X"69a6",
X"2656",
X"082f",
X"d2ad",
X"be8a",
X"a493",
X"b2c1",
X"f4dc",
X"018a",
X"31f8",
X"3156",
X"43c6",
X"f5e8",
X"e7b7",
X"c86d",
X"bcd0",
X"b0d1",
X"d2dc",
X"ffd1",
X"13d3",
X"38ad",
X"3f6a",
X"508d",
X"06ee",
X"03d8",
X"dd4d",
X"d975",
X"c24f",
X"f413",
X"1496",
X"26d4",
X"3dbb",
X"44a1",
X"3bd6",
X"007e",
X"eed4",
X"d227",
X"c34e",
X"b376",
X"f5ca",
X"0819",
X"1ab4",
X"2f3a",
X"3d06",
X"0d03",
X"f5b4",
X"d678",
X"c779",
X"b905",
X"b79b",
X"fd89",
X"05a5",
X"2998",
X"2eb4",
X"487c",
X"0be9",
X"fcd7",
X"dd92",
X"d4cc",
X"c95e",
X"d8db",
X"116d",
X"1b7c",
X"349d",
X"4327",
X"58ae",
X"0863",
X"0879",
X"dc30",
X"d4c7",
X"b9ad",
X"e042",
X"0ab3",
X"160b",
X"34ea",
X"2bdd",
X"338b",
X"ebe7",
X"e33d",
X"c39b",
X"c0a6",
X"a417",
X"eb98",
X"0618",
X"1381",
X"36d5",
X"4321",
X"1f91",
X"f9fd",
X"eab4",
X"d435",
X"c83e",
X"c273",
X"0c30",
X"1853",
X"3122",
X"3be6",
X"4bfd",
X"1db9",
X"ff63",
X"e1eb",
X"d7d7",
X"c2f9",
X"d4ab",
X"0852",
X"12be",
X"29cc",
X"340f",
X"42a6",
X"fa39",
X"f317",
X"cc50",
X"cb5f",
X"b6e9",
X"d5ef",
X"fe85",
X"0c20",
X"2c92",
X"2bfe",
X"3315",
X"ece3",
X"f028",
X"cc1f",
X"cea6",
X"bb50",
X"fa13",
X"17b4",
X"3002",
X"4663",
X"437e",
X"2b3e",
X"005d",
X"ec97",
X"d4cc",
X"cb33",
X"c841",
X"0939",
X"1676",
X"2c01",
X"3975",
X"3fe5",
X"1014",
X"f280",
X"d766",
X"c7ec",
X"ba07",
X"cf6e",
X"f839",
X"12c4",
X"2095",
X"30f4",
X"3d7f",
X"faec",
X"f2c8",
X"d029",
X"cf97",
X"b8f8",
X"e04a",
X"04d4",
X"1f96",
X"2924",
X"3928",
X"435d",
X"fcc1",
X"fe9b",
X"daa5",
X"d746",
X"df07",
X"056b",
X"183a",
X"2ebc",
X"6886",
X"0c15",
X"0894",
X"ddc6",
X"c098",
X"96e5",
X"ee71",
X"f3a6",
X"0f64",
X"4c73",
X"225a",
X"1af6",
X"fa6e",
X"e739",
X"ae0d",
X"e58d",
X"df15",
X"fdc2",
X"3ec2",
X"1e63",
X"1f68",
X"1634",
X"f28b",
X"acb9",
X"f2f9",
X"e60e",
X"f55c",
X"3e4f",
X"1a3b",
X"1c5d",
X"1483",
X"f65e",
X"b9b5",
X"f3fd",
X"eada",
X"fdb2",
X"2bd7",
X"1621",
X"1806",
X"1016",
X"fb80",
X"c1f2",
X"f92a",
X"e452",
X"f2e6",
X"2880",
X"10bb",
X"0409",
X"0453",
X"f674",
X"bfc2",
X"f96f",
X"edac",
X"fca2",
X"1843",
X"183a",
X"1a4c",
X"1470",
X"0b73",
X"dca6",
X"0164",
X"ebf2",
X"f56d",
X"19ba",
X"19e6",
X"0a7c",
X"0bee",
X"03f6",
X"d563",
X"f844",
X"e6f7",
X"ee9d",
X"0ba2",
X"0b42",
X"0ca1",
X"0b5a",
X"ff16",
X"da7f",
X"fdec",
X"f007",
X"f57d",
X"0f72",
X"0def",
X"0ab8",
X"0b83",
X"06b7",
X"d73d",
X"0315",
X"f19d",
X"fbcd",
X"1037",
X"1324",
X"0545",
X"0b0d",
X"004a",
X"dcda",
X"06bc",
X"f4b0",
X"fd76",
X"0d40",
X"1152",
X"0597",
X"0c6c",
X"09ae",
X"da8f",
X"01cf",
X"f25a",
X"f959",
X"0b7b",
X"0bcb",
X"0318",
X"0a32",
X"01ea",
X"d79d",
X"046f",
X"f06f",
X"f695",
X"0cdd",
X"18c1",
X"fee2",
X"0b26",
X"0172",
X"e295",
X"044e",
X"f8c2",
X"fbf8",
X"08a2",
X"22a1",
X"06a4",
X"120f",
X"0639",
X"def1",
X"fb04",
X"f338",
X"efcd",
X"0b00",
X"2924",
X"0336",
X"0d56",
X"0662",
X"e900",
X"f8ee",
X"f8cf",
X"f31a",
X"0699",
X"211c",
X"014b",
X"0ca9",
X"04cc",
X"ea4c",
X"f4f4",
X"f458",
X"ea6d",
X"fff2",
X"249f",
X"0555",
X"0ee3",
X"0e34",
X"e908",
X"e66e",
X"ed49",
X"e963",
X"ff1f",
X"26e2",
X"0368",
X"0f2b",
X"1324",
X"fa05",
X"f3c1",
X"f987",
X"ef26",
X"fc79",
X"1ecb",
X"057c",
X"0c0d",
X"0c30",
X"f9b3",
X"e228",
X"fd02",
X"f25a",
X"fbb1",
X"14d2",
X"04f8",
X"0704",
X"0842",
X"fa3c",
X"db39",
X"f9fa",
X"ee27",
X"02f2",
X"1c6b",
X"087e",
X"0d1f",
X"0c3e",
X"fbc7",
X"de57",
X"fb64",
X"efb2",
X"0114",
X"1908",
X"0bff",
X"08b2",
X"0e65",
X"f940",
X"de0b",
X"fdf4",
X"efeb",
X"fd9f",
X"1373",
X"0a69",
X"04a3",
X"128d",
X"faa4",
X"dc6a",
X"f7b0",
X"ec60",
X"f938",
X"1290",
X"10d4",
X"0a2a",
X"0e36",
X"faf1",
X"da6c",
X"0109",
X"f5bc",
X"2d62",
X"efa7",
X"f479",
X"ccd1",
X"e540",
X"21aa",
X"2a26",
X"50e5",
X"d3a4",
X"eb19",
X"b9c8",
X"016c",
X"2599",
X"3b37",
X"565e",
X"ecf1",
X"fcfd",
X"a414",
X"0fc4",
X"fc06",
X"2bb4",
X"18a0",
X"e93c",
X"ddb6",
X"a623",
X"2627",
X"07ab",
X"50d7",
X"fb02",
X"de1e",
X"c8f3",
X"c1e9",
X"1a49",
X"179b",
X"5dd0",
X"e0ce",
X"f536",
X"c468",
X"c708",
X"1c1b",
X"1ffc",
X"56ab",
X"df75",
X"f770",
X"a95f",
X"106b",
X"15f0",
X"3c20",
X"2e8b",
X"e895",
X"e882",
X"a9a6",
X"316f",
X"0701",
X"405e",
X"fe17",
X"edda",
X"df88",
X"e3dc",
X"26a3",
X"14f6",
X"3b73",
X"d939",
X"e38f",
X"c2c2",
X"d323",
X"0b03",
X"1aa9",
X"2ff4",
X"e7af",
X"ef34",
X"b989",
X"fe6a",
X"0699",
X"25e0",
X"2d4c",
X"efca",
X"f6f8",
X"cca5",
X"25a4",
X"0f4e",
X"33bd",
X"0cdd",
X"eee7",
X"e2b6",
X"d8b2",
X"1d25",
X"14bc",
X"4303",
X"ed51",
X"f586",
X"d5d3",
X"df59",
X"11c8",
X"120f",
X"32e7",
X"ddc1",
X"f16e",
X"c361",
X"f79a",
X"10a8",
X"22ee",
X"32f7",
X"e57a",
X"f197",
X"b827",
X"09b1",
X"01bc",
X"25c5",
X"1733",
X"ec21",
X"ed17",
X"c656",
X"2064",
X"0ac1",
X"3f7d",
X"0237",
X"f270",
X"e645",
X"d45c",
X"1f91",
X"1183",
X"43b2",
X"ecdb",
X"f62a",
X"cf27",
X"f194",
X"141d",
X"18e7",
X"3a4b",
X"e2be",
X"f580",
X"bea8",
X"013e",
X"09bf",
X"2015",
X"2215",
X"e496",
X"eb58",
X"bf26",
X"13bb",
X"06d8",
X"35f1",
X"169c",
X"eff9",
X"ec8e",
X"c86d",
X"1d8d",
X"0c93",
X"3c7d",
X"f42f",
X"ef5d",
X"d45e",
X"d53f",
X"1986",
X"1126",
X"42a3",
X"ee2c",
X"fa9c",
X"d1f3",
X"edf8",
X"12fd",
X"1332",
X"2d96",
X"e0c3",
X"f1a8",
X"c103",
X"10f2",
X"0993",
X"293a",
X"1f73",
X"e73e",
X"f31a",
X"c781",
X"14e8",
X"0568",
X"2b93",
X"0002",
X"ec52",
X"e8f8",
X"cdcb",
X"1d82",
X"0c62",
X"3b81",
X"f3b1",
X"f6da",
X"da84",
X"e5e7",
X"1ef2",
X"1488",
X"3dc1",
X"e817",
X"f98d",
X"ca10",
X"f71e",
X"0c8d",
X"13c8",
X"2aaa",
X"e290",
X"f72f",
X"ce6a",
X"14e6",
X"0759",
X"2252",
X"09fb",
X"e0f7",
X"e7f3",
X"c6d1",
X"1b14",
X"07e5",
X"35d1",
X"fe4b",
X"f343",
X"e491",
X"d876",
X"17ac",
X"0881",
X"329d",
X"eb71",
X"f716",
X"d89f",
X"f150",
X"1715",
X"16de",
X"2f7f",
X"e613",
X"fa16",
X"e1cd",
X"ddea",
X"177d",
X"0bd0",
X"196b",
X"3a24",
X"ee48",
X"ef3f",
X"dcca",
X"ad7c",
X"0829",
X"fa4f",
X"1e1c",
X"3ce2",
X"faba",
X"0e9f",
X"f00c",
X"d266",
X"1350",
X"f7fa",
X"169c",
X"3b81",
X"f5a1",
X"0831",
X"f077",
X"ce6f",
X"17e0",
X"feca",
X"09f3",
X"28b7",
X"e50c",
X"f7d0",
X"e4d5",
X"c977",
X"0ca1",
X"06f3",
X"1186",
X"2f9a",
X"f171",
X"f369",
X"ee7f",
X"d3db",
X"0adc",
X"0764",
X"1228",
X"2cfa",
X"fbbf",
X"f904",
X"f458",
X"dbe3",
X"0adc",
X"0cfe",
X"0f54",
X"2998",
X"f710",
X"f158",
X"fa4d",
X"ed82",
X"1566",
X"0a95",
X"103a",
X"1751",
X"ede2",
X"fe33",
X"fb80",
X"de39",
X"0a2a",
X"febc",
X"03a4",
X"150c",
X"e9e1",
X"f236",
X"ee45",
X"e201",
X"0978",
X"01ed",
X"0318",
X"1439",
X"f5a6",
X"0495",
X"fb90",
X"e1c8",
X"13e1",
X"0a27",
X"107c",
X"1f29",
X"f664",
X"029f",
X"fbcf",
X"ea41",
X"06d5",
X"088c",
X"06fb",
X"1e42",
X"fb9e",
X"fdd3",
X"f6a3",
X"e327",
X"fe82",
X"fa34",
X"00cd",
X"1590",
X"0498",
X"fd39",
X"fdd0",
X"e2a3",
X"f987",
X"ff6b",
X"011f",
X"182d",
X"0020",
X"f791",
X"f656",
X"e6b2",
X"01ed",
X"0dc3",
X"0df7",
X"1ec0",
X"0644",
X"f10b",
X"f17f",
X"e551",
X"0d0e",
X"115a",
X"111b",
X"21e7",
X"fcec",
X"fb46",
X"f307",
X"e48b",
X"fe6a",
X"02be",
X"0693",
X"1014",
X"06fe",
X"f599",
X"ffbe",
X"ed38",
X"f50a",
X"0a32",
X"fa3f",
X"12ae",
X"03c5",
X"f567",
X"f8cf",
X"ec00",
X"fa52",
X"0f15",
X"0da2",
X"1b71",
X"0c04",
X"f114",
X"f6c6",
X"e765",
X"f0d2",
X"0ec0",
X"0c64",
X"1c2c",
X"115a",
X"f896",
X"fa34",
X"e600",
X"ed3b",
X"0795",
X"00e6",
X"1290",
X"1105",
X"f23c",
X"fe46",
X"edf3",
X"f4e4",
X"0b5a",
X"fd0d",
X"0acc",
X"0d87",
X"f3cc",
X"0182",
X"f878",
X"ea67",
X"0bd6",
X"fcb0",
X"092e",
X"191b",
X"f343",
X"0357",
X"f01a",
X"e6a2",
X"0a63",
X"fb20",
X"0ee9",
X"2067",
X"f784",
X"09c4",
X"fa79",
X"e475",
X"1300",
X"fd55",
X"0df7",
X"1a3e",
X"eab4",
X"fc1c",
X"f4b0",
X"e87c",
X"14c2",
X"083f",
X"0def",
X"14dd",
X"e441",
X"f84f",
X"edbc",
X"df95",
X"192f",
X"017a",
X"0e91",
X"1ecb",
X"e887",
X"01a9",
X"f50a",
X"e1ac",
X"0b91",
X"fc74",
X"0219",
X"1a6d",
X"f19a",
X"014e",
X"fe2d",
X"e397",
X"0fa3",
X"fb18",
X"0785",
X"1ae5",
X"f4e9",
X"067b",
X"fbe8",
X"e8b6",
X"0a53",
X"0579",
X"03cd",
X"1cf4",
X"ed25",
X"fa7e",
X"f2a1",
X"df98",
X"0ba7",
X"069e",
X"0bf7",
X"1984",
X"f593",
X"f3ea",
X"f4aa",
X"e53d",
X"071a",
X"08ad",
X"07c4",
X"1a98",
X"ffea",
X"fabd",
X"ff11",
X"f215",
X"045e",
X"05c0",
X"01c9",
X"0b26",
X"fc37",
X"f17c",
X"0057",
X"f3b1",
X"ff40",
X"0f95",
X"00ee",
X"0dc9",
X"0383",
X"f1ad",
X"faf4",
X"ef2e",
X"f429",
X"0d6e",
X"0373",
X"0c3b",
X"1214",
X"f43f",
X"faec",
X"e595",
X"e81c",
X"02aa",
X"ff76",
X"0fa3",
X"0bcb",
X"ff6b",
X"0308",
X"fcad",
X"f627",
X"0a32",
X"fb1a",
X"052f",
X"092e",
X"ef8e",
X"ff35",
X"f9ab",
X"f8dd",
X"0939",
X"0297",
X"fee8",
X"015c",
X"efa1",
X"f862",
X"f904",
X"f5dd",
X"0f59",
X"0477",
X"0d8a",
X"11f6",
X"f96f",
X"02de",
X"f768",
X"f017",
X"08fc",
X"feda",
X"061b",
X"11eb",
X"fd47",
X"01da",
X"fc03",
X"f21e",
X"0258",
X"fe6f",
X"040f",
X"053c",
X"f5b7",
X"fa52",
X"f5c7",
X"f2a4",
X"06ac",
X"fe43",
X"059c",
X"0990",
X"efdb",
X"fd34",
X"f7ad",
X"f19d",
X"0c9b",
X"01cf",
X"048d",
X"0ca3",
X"f37f",
X"fd26",
X"fbb4",
X"f215",
X"0be3",
X"00ca",
X"066d",
X"0c43",
X"f828",
X"0154",
X"fb8d",
X"f2db",
X"0792",
X"0091",
X"05f1",
X"110d",
X"f8dd",
X"00fc",
X"f88e",
X"ef7e",
X"09f6",
X"0289",
X"0b29",
X"1355",
X"f87d",
X"fb46",
X"f549",
X"eb6e",
X"058f",
X"0594",
X"0933",
X"1929",
X"f7f1",
X"fdcd",
X"f632",
X"eafe",
X"0996",
X"fe33",
X"0886",
X"1243",
X"f8e0",
X"fcbe",
X"fac8",
X"edca",
X"0985",
X"00f6",
X"0234",
X"0f3b",
X"f2c5",
X"fdf1",
X"f7a2",
X"f0a6",
X"04b9",
X"ff76",
X"02f7",
X"0790",
X"f6c6",
X"fca2",
X"ff1c",
X"f41e",
X"0b62",
X"00d3",
X"060d",
X"0d1f",
X"f7de",
X"fde3",
X"f86a",
X"f1ec",
X"035d",
X"0438",
X"0432",
X"1170",
X"fc2a",
X"ff11",
X"fd29",
X"f215",
X"070f",
X"01cf",
X"0889",
X"0eaa",
X"fe3e",
X"ffa5",
X"fc1c",
X"f0fb",
X"0333",
X"00f9",
X"0156",
X"12bc",
X"fab5",
X"071a",
X"fcc1",
X"f2af",
X"012d",
X"fc7f",
X"0065",
X"053f",
X"f9df",
X"fa3c",
X"ff50",
X"f3d7",
X"0a8f",
X"0349",
X"061b",
X"0b31",
X"f4f2",
X"f9fd",
X"f4b5",
X"f471",
X"0571",
X"07df",
X"071a",
X"0fda",
X"fb62",
X"fcf7",
X"fad3",
X"f233",
X"0740",
X"0034",
X"0615",
X"09b1",
X"fc4d",
X"feed",
X"fe0c",
X"f805",
X"033c",
X"05d9",
X"011d",
X"0cca",
X"fb4c",
X"fc97",
X"fb5f",
X"f2d0",
X"03e8",
X"ffc3",
X"0ac1",
X"0ba7",
X"0435",
X"fbb7",
X"fb57",
X"f1a5",
X"fbe0",
X"0383",
X"00c2",
X"1131",
X"ffc3",
X"033e",
X"fd8e",
X"fb93",
X"ffa2",
X"02f2",
X"01f8",
X"035f",
X"03b7",
X"f784",
X"017a",
X"f784",
X"00a7",
X"0310",
X"0125",
X"0547",
X"fe75",
X"fcc6",
X"fa23",
X"f948",
X"f747",
X"0531",
X"00ff",
X"0508",
X"06b7",
X"fdee",
X"0537",
X"fbda",
X"ffef",
X"023d",
X"ffc9",
X"011f",
X"00ee",
X"fb0a",
X"fa60",
X"fe9b",
X"f8fb",
X"0753",
X"feed",
X"0352",
X"012d",
X"f8ca",
X"fee8",
X"f8dd",
X"00c8",
X"01ae",
X"08d6",
X"045e",
X"0af8",
X"fc48",
X"028c",
X"004a",
X"fa99",
X"0a66",
X"fca8",
X"0657",
X"0149",
X"ff3a",
X"fb88",
X"fd3c",
X"f7ff",
X"0080",
X"046c",
X"ff09",
X"0b4d",
X"f940",
X"032e",
X"fb7a",
X"f6f5",
X"023f",
X"fd91",
X"061b",
X"059f",
X"fe5c",
X"fb7a",
X"fecc",
X"f599",
X"0581",
X"012d",
X"01fb",
X"09b1",
X"f611",
X"ffb0",
X"f9a3",
X"fb6a",
X"0620",
X"04fb",
X"0503",
X"07ae",
X"ff24",
X"f93d",
X"005a",
X"f3fd",
X"070c",
X"ff50",
X"0459",
X"0aa8",
X"fb67",
X"032e",
X"f893",
X"fb12",
X"fcbb",
X"00eb",
X"fcdf",
X"0842",
X"fce4",
X"ff3a",
X"03d5",
X"f669",
X"0962",
X"ff92",
X"0547",
X"0375",
X"fc37",
X"fe0a",
X"ff14",
X"fa5a",
X"02e4",
X"04ab",
X"0164",
X"0a92",
X"f9cc",
X"fefb",
X"f9ce",
X"f3f5",
X"01bc",
X"fea3",
X"0639",
X"0a77",
X"0508",
X"ffea",
X"ffa8",
X"f10e",
X"f977",
X"fcbe",
X"fc11",
X"0819",
X"fbcf",
X"04f5",
X"fe2d",
X"005f",
X"0388",
X"0091",
X"01a9",
X"fe59",
X"fbb4",
X"f7db",
X"fe28",
X"f9f5",
X"07a3",
X"0527",
X"0347",
X"071f",
X"fb0f",
X"0008",
X"fd73",
X"ffa5",
X"00ca",
X"0253",
X"fe3b",
X"0391",
X"fdde",
X"fdaa",
X"fea9",
X"f7f1",
X"02e1",
X"fcea",
X"0586",
X"0597",
X"03c5",
X"0198",
X"fa91",
X"f98f",
X"f969",
X"00db",
X"feda",
X"0928",
X"fdec",
X"fee0",
X"fe9e",
X"f656",
X"00f6",
X"fcad",
X"059c",
X"0211",
X"0258",
X"fbe2",
X"fc7c",
X"fcf5",
X"fc7c",
X"0266",
X"febf",
X"0962",
X"fd94",
X"0644",
X"ff87",
X"fee8",
X"0224",
X"fe07",
X"0068",
X"fe4e",
X"009f",
X"fa7e",
X"0354",
X"f95e",
X"ff00",
X"00c8",
X"fb38",
X"0339",
X"fc4b",
X"0164",
X"fba6",
X"001e",
X"ff19",
X"0378",
X"04be",
X"0130",
X"05b0",
X"f932",
X"ff00",
X"f6cc",
X"fc74",
X"0281",
X"0284",
X"094f",
X"0294",
X"00a4",
X"fa60",
X"f998",
X"f351",
X"ff48",
X"fd55",
X"0294",
X"0646",
X"fe7a",
X"04b1",
X"fa6b",
X"ff4d",
X"fd16",
X"ff69",
X"fdee",
X"02fd",
X"fefb",
X"fd81",
X"0013",
X"f75b",
X"0310",
X"fa08",
X"022c",
X"0432",
X"fbf3",
X"0224",
X"fde9",
X"feae",
X"fe5c",
X"01ab",
X"fed7",
X"05d1",
X"ff71",
X"00fc",
X"024d",
X"fa8c",
X"02e7",
X"fd4f",
X"028f",
X"00d0",
X"fdd0",
X"fd76",
X"fc0e",
X"f9c9",
X"feb6",
X"ff3a",
X"fe1d",
X"059a",
X"fdb5",
X"0263",
X"ff8f",
X"fcea",
X"03ba",
X"0034",
X"00af",
X"00b7",
X"ff79",
X"fc09",
X"fdf9",
X"fba1",
X"ff3a",
X"018d",
X"02f7",
X"08a2",
X"ffe7",
X"021c",
X"fbe0",
X"f917",
X"fde3",
X"fd37",
X"0203",
X"02ce",
X"02b0",
X"ffd6",
X"0219",
X"fba3",
X"fd70",
X"fffd",
X"fd16",
X"0140",
X"fe5f",
X"00e9",
X"fc61",
X"ff45",
X"fc9d",
X"fe46",
X"fc66",
X"0169",
X"02a8",
X"00fc",
X"0555",
X"fcd4",
X"04da",
X"ffe1",
X"035f",
X"03e6",
X"0130",
X"fe20",
X"fc2a",
X"fbed",
X"f86d",
X"035a",
X"0140",
X"05ce",
X"0365",
X"ff60",
X"000d",
X"fb9b",
X"fe75",
X"fd18",
X"0101",
X"fdd0",
X"ff0e",
X"fd26",
X"ff2a",
X"ffe4",
X"0023",
X"04b6",
X"fc06",
X"0075",
X"fee0",
X"fb46",
X"ff3d",
X"fffa",
X"ff19",
X"01c1",
X"02f4",
X"016c",
X"071a",
X"fea9",
X"00e9",
X"fd47",
X"fa9c",
X"011d",
X"ff8c",
X"072a",
X"066d",
X"0331",
X"0091",
X"fa86",
X"f6f2",
X"ff2a",
X"fe12",
X"fedd",
X"04c7",
X"fca8",
X"ffec",
X"ff1c",
X"fd05",
X"0344",
X"ffc0",
X"ff32",
X"ff3d",
X"fb93",
X"fc95",
X"ffec",
X"ffb8",
X"034f",
X"0104",
X"007e",
X"01bc",
X"fd26",
X"044b",
X"0140",
X"fe36",
X"ffea",
X"fcd1",
X"ff09",
X"0448",
X"0122",
X"059f",
X"050b",
X"fcb3",
X"017a",
X"febc",
X"0005",
X"02a5",
X"0010",
X"ff24",
X"fa97",
X"faaf",
X"fd60",
X"ffb8",
X"0107",
X"0693",
X"feb4",
X"00ba",
X"fd37",
X"fa7e",
X"02e1",
X"00e3",
X"018d",
X"0260",
X"fb57",
X"fc40",
X"fd08",
X"fd70",
X"04f2",
X"036d",
X"0409",
X"0407");

  signal collision: sOUND2 := (
X"05d9",
X"009f",
X"fd23",
X"f8b1",
X"d8b4",
X"2be8",
X"22ee",
X"ed52",
X"1754",
X"c90a",
X"22b0",
X"0615",
X"dfff",
X"0c92",
X"cd80",
X"061a",
X"154f",
X"f71d",
X"24d0",
X"ecf0",
X"dba5",
X"1056",
X"fcc3",
X"0b19",
X"0d2d",
X"eab7",
X"eed6",
X"061e",
X"f407",
X"208c",
X"ff2c",
X"1346",
X"116e",
X"db33",
X"f525",
X"f5f1",
X"ebb4",
X"fa43",
X"1268",
X"2939",
X"ebc2",
X"e842",
X"a6dd",
X"222e",
X"0476",
X"f0a1",
X"52c5",
X"ea89",
X"3bb5",
X"e59c",
X"cd1e",
X"12aa",
X"2747",
X"f8ba",
X"65cf",
X"ec61",
X"fdde",
X"7dd5",
X"8a02",
X"3777",
X"bb6d",
X"cac9",
X"d97a",
X"c6b2",
X"bb5a",
X"bbdc",
X"39d8",
X"21b3",
X"680f",
X"59e6",
X"ff9f",
X"da68",
X"2b28",
X"78f1",
X"dc80",
X"370d",
X"9540",
X"a7bf",
X"26a8",
X"26af",
X"5b1d",
X"6940",
X"05ff",
X"b511",
X"f9d5",
X"c40b",
X"c559",
X"0137",
X"ecf0",
X"6778",
X"2252",
X"3852",
X"e314",
X"cc9b",
X"a693",
X"4fdc",
X"284f",
X"00a6",
X"f4b7",
X"fa64",
X"ed71",
X"efca",
X"163f",
X"6f7c",
X"1a61",
X"bbc9",
X"c404",
X"c5d4",
X"13e3",
X"e49b",
X"1975",
X"6157",
X"727c",
X"d4d0",
X"9d7f",
X"2a24",
X"0b74",
X"5746",
X"0635",
X"a366",
X"b9da",
X"efad",
X"0d16",
X"ca5d",
X"23fa",
X"1189",
X"2f18",
X"0fed",
X"f975",
X"e0db",
X"ea00",
X"1b52",
X"ee1a",
X"29f0",
X"49fe",
X"cd3f",
X"b647",
X"e23c",
X"eac6",
X"0a60",
X"3a85",
X"055a",
X"2109",
X"d0b3",
X"f9c6",
X"466b",
X"dfe1",
X"ffdd",
X"0968",
X"deb2",
X"0afe",
X"ebae",
X"bf81",
X"1ca1",
X"0c8d",
X"2a85",
X"0bb5",
X"e787",
X"e112",
X"f276",
X"22aa",
X"c9c9",
X"3971",
X"ffd1",
X"de4e",
X"0834",
X"d412",
X"0783",
X"faa0",
X"08cd",
X"0902",
X"434e",
X"276c",
X"e7c6",
X"d30f",
X"1181",
X"d98c",
X"1fd4",
X"1902",
X"e226",
X"26be",
X"22c2",
X"0220",
X"0e6f",
X"f4ba",
X"dff7",
X"cbe4",
X"330c",
X"ed5e",
X"d88c",
X"f925",
X"072b",
X"2631",
X"34ab",
X"b503",
X"07ee",
X"10e4",
X"d327",
X"01f1",
X"11a6",
X"14ec",
X"f068",
X"012a",
X"0fc9",
X"de0f",
X"4aa8",
X"87ef",
X"4112",
X"10be",
X"c1fd",
X"1216",
X"eea2",
X"f808",
X"d8ed",
X"4837",
X"f880",
X"2c8f",
X"cb8f",
X"009e",
X"d38a",
X"2c07",
X"2832",
X"dc2f",
X"2b54",
X"c63c",
X"1d42",
X"fc87",
X"0b16",
X"cb5d",
X"02fa",
X"efbf",
X"0a22",
X"fa61",
X"f8a1",
X"fa64",
X"f800",
X"0e31",
X"08b9",
X"0b77",
X"e32e",
X"0856",
X"f496",
X"f880",
X"e96b",
X"02f1",
X"2816",
X"f45f",
X"18d1",
X"ebb8",
X"f7f4",
X"0759",
X"f46c",
X"f299",
X"19e5",
X"0bf2",
X"e8c6",
X"ef14",
X"fc7f",
X"e4a7",
X"ecca",
X"ff76",
X"1815",
X"255f",
X"d8c2",
X"e69a",
X"205a",
X"f203",
X"cd3e",
X"1467",
X"1748",
X"e1fa",
X"0047",
X"1ade",
X"0c4f",
X"1192",
X"0f43",
X"f4d7",
X"04e3",
X"f8d3",
X"e188",
X"dc3a",
X"fd29",
X"0b09",
X"e60f",
X"e36c",
X"ecfb",
X"1b1d",
X"fd62",
X"0103",
X"fe25",
X"106b",
X"0723",
X"f92e",
X"0e70",
X"284f",
X"06a8",
X"0215",
X"0ad9",
X"f974",
X"d827",
X"d439",
X"f0b6",
X"fc2e",
X"06db",
X"3264",
X"195a",
X"f01f",
X"d86b",
X"de47",
X"da4f",
X"f5c4",
X"11b8",
X"0d78",
X"0fc5",
X"185e",
X"00ad",
X"092f",
X"0808",
X"e0a6",
X"f544",
X"1b3c",
X"da53",
X"ef3d",
X"0314",
X"ecea",
X"f65b",
X"dec2",
X"f961",
X"1679",
X"f356",
X"f74c",
X"09b7",
X"1079",
X"179b",
X"0af6",
X"ea90",
X"dd11",
X"f98e",
X"ff35",
X"e6c9",
X"07e6",
X"1324",
X"1ba0",
X"f7d9",
X"bd3c",
X"31fe",
X"0446",
X"0bdc",
X"ed04",
X"fa7b",
X"1bfa",
X"e6f6",
X"fb73",
X"0c64",
X"e771",
X"e8d1",
X"35e9",
X"086d",
X"00b6",
X"f203",
X"f5ed",
X"13fa",
X"ee74",
X"0a0a",
X"01e4",
X"e79d",
X"f54a",
X"09b0",
X"0e48",
X"f138",
X"eb27",
X"0786",
X"18e2",
X"e9ad",
X"f4e1",
X"f852",
X"07f5",
X"dc6f",
X"05bb",
X"2da5",
X"d900",
X"fabe",
X"1e50",
X"fe0c",
X"1158",
X"01be",
X"e9b4",
X"0026",
X"08d2",
X"f945",
X"fd12",
X"fae9",
X"fff0",
X"09f2",
X"fad9",
X"01c0",
X"fb55",
X"fd72",
X"fc4d",
X"fcbd",
X"0f42",
X"0163",
X"f3cf",
X"ffb3",
X"e2c3",
X"fe30",
X"02b7",
X"1998",
X"d14f",
X"efd7",
X"08aa",
X"1421",
X"0dfd",
X"d95c",
X"f9be",
X"4910",
X"f05c",
X"cfb0",
X"ff88",
X"f3e6",
X"052c",
X"d69c",
X"0bb8",
X"0eb4",
X"00bf",
X"0bdb",
X"f060",
X"124b",
X"fc63",
X"df9c",
X"e6f8",
X"0210",
X"11d1",
X"f196",
X"f034",
X"1c70",
X"0010",
X"fad5",
X"0df2",
X"04fe",
X"e6df",
X"ed48",
X"01c5",
X"19ab",
X"dedb",
X"f5bc",
X"16df",
X"27a1",
X"e6d5",
X"f7c6",
X"fcc9",
X"00ca",
X"d163",
X"0014",
X"02e5",
X"e873",
X"e6cc",
X"fe74",
X"19f1",
X"e621",
X"32e1",
X"a5be",
X"fa05",
X"7fff",
X"e810",
X"cdb1",
X"0911",
X"0444",
X"28fc",
X"d3c1",
X"c48a",
X"251a",
X"3330",
X"d3ec",
X"c41a",
X"17dd",
X"38c3",
X"0e66",
X"da3f",
X"008f",
X"1fc5",
X"f7b0",
X"dd40",
X"0e13",
X"2cc2",
X"df5e",
X"f699",
X"1740",
X"fb5c",
X"e7bb",
X"04e1",
X"fb5a",
X"ec94",
X"0080",
X"05d9",
X"0062",
X"f9ff",
X"1dc1",
X"f31a",
X"ffe7",
X"0036",
X"0c53",
X"f567",
X"fb8e",
X"0757",
X"f3bf",
X"013b",
X"0a5a",
X"05d1",
X"f962",
X"f7cc",
X"021d",
X"fbf4",
X"ffbc",
X"0d7b",
X"0c04",
X"fb19",
X"feb9",
X"fe3d",
X"e8ec",
X"01ee",
X"ef21",
X"f601",
X"f3f6",
X"062b",
X"07d3",
X"0b4d",
X"fb01",
X"feb0",
X"0f14",
X"0099",
X"f546",
X"0b8a",
X"0c69",
X"f02b",
X"fb96",
X"0b27",
X"fd9a",
X"f778",
X"fa09",
X"ff99",
X"f773",
X"fd09",
X"0086",
X"fec2",
X"fa58",
X"0a5b",
X"042c",
X"07a3",
X"f891",
X"f30a",
X"0334",
X"0974",
X"039c",
X"fa8c",
X"fdd7",
X"0aca",
X"0932",
X"00ab",
X"fdc1",
X"02ac",
X"06e1",
X"f70c",
X"f646",
X"f7cb",
X"f7af",
X"0649",
X"01e7",
X"fad4",
X"fa87",
X"fd9f",
X"167b",
X"eed7",
X"fb23",
X"014b",
X"14a6",
X"f739",
X"028e",
X"017d",
X"067c",
X"0a20",
X"f8e4",
X"edc5",
X"f7a6",
X"032a",
X"f860",
X"ff2f",
X"f321",
X"f767",
X"0165",
X"ffa4",
X"0956",
X"026b",
X"f5fd",
X"0153",
X"01d2",
X"01eb",
X"ffb8",
X"f482",
X"faee",
X"10fb",
X"0495",
X"f08d",
X"fcd0",
X"07fd",
X"0111",
X"f4da",
X"04ac",
X"0256",
X"011f",
X"fb59",
X"fc52",
X"02a6",
X"fff4",
X"f90d",
X"fd17",
X"06cc",
X"fbe9",
X"0191",
X"fc47",
X"fd5a",
X"0245",
X"fec8",
X"fdcb",
X"fcfc",
X"fcac",
X"ffc3",
X"04b4",
X"fe0c",
X"f968",
X"ff3e",
X"0506",
X"04ed",
X"fa23",
X"f726",
X"00ac",
X"fdb7",
X"02d5",
X"fbf8",
X"f9f5",
X"ffef",
X"04c8",
X"feae",
X"fc68",
X"fe38",
X"00aa",
X"fed8",
X"fbe3",
X"fb10",
X"01f6",
X"feea",
X"ff60",
X"040d",
X"fd27",
X"fc9b",
X"0792",
X"054a",
X"fcd9",
X"f2da",
X"01ad",
X"f6f8",
X"f407",
X"02c8",
X"fbeb",
X"0dcd",
X"f73e",
X"063d",
X"ee84",
X"fcc7",
X"067a",
X"043a",
X"f993",
X"014e",
X"0544",
X"0669",
X"fbc2",
X"fdcf",
X"0595",
X"fd8f",
X"000c",
X"feb3",
X"03b8",
X"0640",
X"fb31",
X"f33b",
X"02af",
X"06a6",
X"ff57",
X"f63b",
X"fc5b",
X"fbf0",
X"042a",
X"0196",
X"fdbf",
X"fb76",
X"ffe9",
X"016a",
X"02d5",
X"fb96",
X"fc5b",
X"ffdd",
X"052e",
X"02c0",
X"fa5f",
X"ecd5",
X"fb53",
X"00cd",
X"01fe",
X"f769",
X"f7fd",
X"fe38",
X"ff68",
X"0912",
X"007a",
X"fd66",
X"f61c",
X"021b",
X"0b73",
X"ffbb",
X"f193",
X"fea7",
X"06e9",
X"02ab",
X"fd9a",
X"fc46",
X"01b4",
X"0252",
X"02c9",
X"fa74",
X"fd09",
X"fc83",
X"02cc",
X"008a",
X"fbd4",
X"ff25",
X"fe1d",
X"0761",
X"f8cf",
X"f628",
X"f78a",
X"05af",
X"f78e",
X"0349",
X"015d",
X"fc08",
X"f692",
X"0824",
X"0ef1",
X"f3ac",
X"eb37",
X"ef07",
X"fe06",
X"f97a",
X"002d",
X"0bf6",
X"fce8",
X"fcca",
X"022c",
X"fc23",
X"ff02",
X"002c",
X"f4bf",
X"009b",
X"11c2",
X"0322",
X"005c",
X"fed3",
X"0c34",
X"f47d",
X"ee18",
X"0070",
X"10b8",
X"0002",
X"f978",
X"fad5",
X"0c4a",
X"f3ba",
X"fb5a",
X"0656",
X"0463",
X"fd59",
X"0147",
X"f740",
X"fe08",
X"04cf",
X"f8d5",
X"f4db",
X"0066",
X"13a8",
X"0c5f",
X"efd9",
X"e3e7",
X"036d",
X"1415",
X"05ab",
X"f8b2",
X"012a",
X"f7ea",
X"f6f0",
X"f8f6",
X"03fa",
X"0a38",
X"fc5b",
X"0241",
X"f512",
X"ed38",
X"053d",
X"19a0",
X"064b",
X"f4d4",
X"f58b",
X"f9e4",
X"f2f6",
X"0962",
X"12bf",
X"00d2",
X"e91a",
X"ee00",
X"0dd2",
X"0874",
X"ffba",
X"fdde",
X"fa03",
X"f681",
X"00e7",
X"0b93",
X"032f",
X"fca7",
X"0251",
X"f84a",
X"f67e",
X"045d",
X"071c",
X"f70f",
X"fbf6",
X"0132",
X"049c",
X"fc48",
X"00fb",
X"fd8e",
X"fd4f",
X"06f5",
X"f043",
X"f3c3",
X"fcaa",
X"0fdd",
X"10be",
X"e94b",
X"e060",
X"0c04",
X"1b2c",
X"f6fe",
X"f4f7",
X"0524",
X"0c9f",
X"01cd",
X"e0fa",
X"f74b",
X"00fb",
X"088b",
X"fec9",
X"ffee",
X"0445",
X"f380",
X"0723",
X"0af3",
X"fcb3",
X"f62e",
X"fe67",
X"02cc",
X"02c6",
X"ed77",
X"01d9",
X"04ae",
X"03e0",
X"fd51",
X"faa5",
X"ffd9",
X"ffa5",
X"f4cc",
X"0057",
X"feca",
X"03ed",
X"ffde",
X"fc26",
X"f7a7",
X"fcdc",
X"fe9b",
X"0693",
X"fdcd",
X"fc72",
X"07a2",
X"0366",
X"faab",
X"fdb8",
X"fcfa",
X"fc18",
X"00c8",
X"fde2",
X"f95f",
X"fbe4",
X"0b6c",
X"0446",
X"f449",
X"f582",
X"0abd",
X"02ce",
X"f256",
X"fd04",
X"0709",
X"0548",
X"faa2",
X"038c",
X"f7ec",
X"0512",
X"032e",
X"ef07",
X"f8c8",
X"0987",
X"f6ef",
X"0076",
X"0af2",
X"ff9d",
X"ed0b",
X"0738",
X"01da",
X"07c6",
X"f69e",
X"ed86",
X"0c63",
X"0347",
X"f3d5",
X"f38a",
X"0b42",
X"0721",
X"f1a1",
X"097e",
X"fac7",
X"f455",
X"03dd",
X"0813",
X"f492",
X"fcaf",
X"0147",
X"0190",
X"fe15",
X"0005",
X"fb83",
X"ffe3",
X"fc31",
X"ff1e",
X"03ca",
X"faad",
X"f8c5",
X"01d7",
X"0255",
X"fa9c",
X"ff96",
X"0286",
X"fe89",
X"f985",
X"01bc",
X"02d8",
X"fca2",
X"fabc",
X"0095",
X"00d3",
X"fde3",
X"0189",
X"fb1f",
X"ff18",
X"fa67",
X"fea7",
X"ff75",
X"00fc",
X"fab3",
X"ffbc",
X"008d",
X"fcf7",
X"fb7a",
X"fa87",
X"ff77",
X"fe8a",
X"00b0",
X"0509",
X"fbaf",
X"fbcf",
X"01a3",
X"fd98",
X"faaf",
X"f7fb",
X"01f7",
X"078f",
X"f971",
X"025e",
X"02f7",
X"fc39",
X"fb9d",
X"00d6",
X"fb48",
X"fda6",
X"0394",
X"fa9d",
X"fc92",
X"020a",
X"fdcf",
X"f30f",
X"0350",
X"0469",
X"f899",
X"0154",
X"ffa0",
X"fb7e",
X"047c",
X"faa3",
X"fe7a",
X"0165",
X"007f",
X"fe1a",
X"fb33",
X"001c",
X"fe82",
X"f8cb",
X"fbb5",
X"02ee",
X"0035",
X"0084",
X"fa1c",
X"ffaa",
X"00ae",
X"ff9d",
X"f68a",
X"fe38",
X"ff25",
X"ff97",
X"ff5a",
X"fd45",
X"fdc5",
X"fde1",
X"fe67",
X"fbd0",
X"fd61",
X"0252",
X"fee0",
X"fe79",
X"029d",
X"fc6a",
X"f998",
X"02e8",
X"fe73",
X"fc19",
X"f920",
X"0073",
X"ffe9",
X"fc53",
X"fc10",
X"0560",
X"feee",
X"f6a9",
X"ffea",
X"00ae",
X"f783",
X"fc80",
X"05c3",
X"003b",
X"fbe6",
X"fe38",
X"fdb0",
X"fe48",
X"fc0d",
X"fc6e",
X"fe63",
X"ff49",
X"fcc7",
X"01a3",
X"01a2",
X"f944",
X"fc95",
X"ffc1",
X"016f",
X"faaf",
X"f849",
X"00b6",
X"fd65",
X"fd7a",
X"00db",
X"fb6f",
X"fe09",
X"007c",
X"0140",
X"fa2e",
X"03a1",
X"0050",
X"007c",
X"fbdb",
X"051b",
X"f99f",
X"f8e9",
X"00ce",
X"01a9",
X"fa11",
X"fb06",
X"00ad",
X"fd2c",
X"ff8f",
X"fdce",
X"ff8f",
X"fed3",
X"febf",
X"01d9",
X"fea7",
X"fba1",
X"fc8d",
X"ffc5",
X"fde6",
X"f93d",
X"fd20",
X"03ac",
X"fd66",
X"fc0a",
X"ffac",
X"fd39",
X"01cc",
X"fe20",
X"fd72",
X"0073",
X"fec6",
X"fc35",
X"fc85",
X"ffa4",
X"fc99",
X"00bd",
X"ffa9",
X"fb6f",
X"fd4d",
X"fec7",
X"fded",
X"004c",
X"feea",
X"fc43",
X"feae",
X"fdf1",
X"fcf5",
X"fe62",
X"fdc3",
X"fc31",
X"0067",
X"ff03",
X"ff3b",
X"f9f9",
X"061f",
X"fcd1",
X"fd92",
X"f8a2",
X"0643",
X"fbed",
X"ff13",
X"fccb",
X"fcc7",
X"005c",
X"fc22",
X"ffca",
X"f7c7",
X"03ab",
X"0227",
X"fc8e",
X"fe2d",
X"fe2c",
X"fe40",
X"fe60",
X"021a",
X"fc31",
X"000d",
X"fd13",
X"fee3",
X"fd9f",
X"ffba",
X"fe64",
X"fd2f",
X"fe13",
X"fdd7",
X"fcc6",
X"006c",
X"ff80",
X"fc6c",
X"fc6e",
X"ff7d",
X"016b",
X"fcc1",
X"fdda",
X"ff4a",
X"0007",
X"fe35",
X"fba0",
X"fdf5",
X"01e7",
X"ffc2",
X"fa57",
X"fe63",
X"ffea",
X"0050",
X"ff29",
X"ff87",
X"fa73",
X"ff17",
X"0179",
X"fdbe",
X"fd89",
X"fee0",
X"00cf",
X"fe2b",
X"004d",
X"feed",
X"ffa9",
X"fcd2",
X"fe35",
X"fddc",
X"ff8b",
X"00d8",
X"fc2d",
X"fda7",
X"fdef",
X"009f",
X"fe97",
X"fef9",
X"fce0",
X"ffbe",
X"fe65",
X"fea5",
X"fd26",
X"fe30",
X"fd4e",
X"feff",
X"fdda",
X"ffbe",
X"ff68",
X"ff44",
X"fc13",
X"fec1",
X"ffe8",
X"fd21",
X"0019",
X"fe4f",
X"fe22",
X"000a",
X"0043",
X"fddb",
X"fcc3",
X"ff6d",
X"fd99",
X"ff3f",
X"fba1",
X"0074",
X"0172",
X"f867",
X"ffce",
X"fe4b",
X"fd52",
X"0105",
X"fb52",
X"fe4c",
X"00bf",
X"ff75",
X"fba0",
X"ff59",
X"fb04",
X"0200",
X"fe00",
X"0026",
X"fdac",
X"fe23",
X"0092",
X"fe7c",
X"fc1c",
X"0120",
X"fdb8",
X"fcb1",
X"fd55",
X"fd77",
X"019a",
X"fda5",
X"000e",
X"fedb",
X"fc5e",
X"0033",
X"fc03",
X"fff4",
X"ff73",
X"fd42",
X"008c",
X"fdb4",
X"fed9",
X"ffb4",
X"fd4d",
X"0053",
X"fc5d",
X"fcef",
X"ff8c",
X"ff51",
X"0067",
X"fec7",
X"ff1f",
X"ff54",
X"0013",
X"fe98",
X"fe7e",
X"fd19",
X"fe2e",
X"ff9e",
X"ff59",
X"fed2",
X"febb",
X"fe31",
X"fef2",
X"fe0c",
X"fe19",
X"fde0",
X"ff97",
X"fffc",
X"ff36",
X"ff50",
X"fe92",
X"fea4",
X"fdf4",
X"fde4",
X"febe",
X"fe25",
X"fd16",
X"fecd",
X"ff13",
X"fe9b",
X"feca",
X"ff7f",
X"ff45",
X"fe70",
X"fe02",
X"fdf5",
X"ff81",
X"fecf",
X"fb38",
X"ffcd",
X"fe8d",
X"0205",
X"feec",
X"ff2b",
X"0030",
X"fbc1",
X"ff8e",
X"fdd1",
X"fefa",
X"feab",
X"fe31",
X"fd0c",
X"fed9",
X"ff01",
X"feb7",
X"fda1",
X"fde2",
X"ff18",
X"fd0a",
X"00ec",
X"fe74",
X"fe47",
X"006d",
X"007c",
X"fd8e",
X"ff5d",
X"fa90",
X"fedb",
X"fdac",
X"00e4",
X"ffa6",
X"fdff",
X"fd5f",
X"ffd6",
X"fdc6",
X"00f0",
X"fd55",
X"ff41",
X"ff6f",
X"feb1",
X"fd03",
X"fd7a",
X"fdc2",
X"ff86",
X"fe55",
X"fff4",
X"fd6e",
X"0000",
X"fe76",
X"0198",
X"000e",
X"f769",
X"fcda",
X"fe62",
X"fff9",
X"ff99",
X"01ab",
X"fe4f",
X"0085",
X"ff33",
X"fe80",
X"fdf1",
X"ff0c",
X"fe0d",
X"ffec",
X"fd81",
X"feee",
X"fe56",
X"ff90",
X"fe9a",
X"fe49",
X"ff51",
X"fe88",
X"feb6",
X"fecb",
X"ff67",
X"ff82",
X"fea2",
X"fe44",
X"004d",
X"fe8b",
X"fdb5",
X"fed5",
X"ff58",
X"fe9f",
X"fe7e",
X"ff7e",
X"ff95",
X"fe62",
X"fecf",
X"fdc4",
X"fe23",
X"fe54",
X"005f",
X"fe53",
X"fe69",
X"0043",
X"fe7c",
X"fde5",
X"fe2f",
X"fecb",
X"feb0",
X"fea0",
X"fde3",
X"fe14",
X"ff0f",
X"fedf",
X"ff9a",
X"feb1",
X"fecb",
X"fe2f",
X"fde6",
X"fe79",
X"ff4d",
X"fe67",
X"fe0f",
X"fddf",
X"feaa",
X"fe9a",
X"fe3b",
X"ff70",
X"fe4d",
X"fe6b",
X"0049",
X"ff67",
X"fe05",
X"fdf8",
X"fe30",
X"fdc9",
X"fe72",
X"fe55",
X"ff8f",
X"fdad",
X"fc2d",
X"0001",
X"fdb5",
X"fa9f",
X"00a9",
X"0148",
X"fa21",
X"026d",
X"fff5",
X"fc91",
X"029f",
X"033e",
X"fa42",
X"03b8",
X"fc10",
X"fe93",
X"02b0",
X"0090",
X"fafd",
X"ff34",
X"ff5f",
X"fc79",
X"ff65",
X"0094",
X"fdb9",
X"fd76",
X"01db",
X"ff5b",
X"fd20",
X"0126",
X"febd",
X"fe4c",
X"02c5",
X"fed3",
X"fee3",
X"fea4",
X"003d",
X"fae6",
X"026f",
X"fd54",
X"004f",
X"ffba",
X"fe63",
X"fd3c",
X"01a2",
X"fc3a",
X"fe04",
X"ff97",
X"fd71",
X"ff23",
X"fea2",
X"fe5f",
X"fecc",
X"ff0a",
X"ff9f",
X"0000",
X"fe1f",
X"00d2",
X"fd63",
X"fdde",
X"fca3",
X"00ff",
X"fdec",
X"fde3",
X"ff74",
X"ffd4",
X"fe01",
X"ff44",
X"fc7e",
X"009c",
X"fea5",
X"000a",
X"fda7",
X"fc6e",
X"fe83",
X"feb1",
X"009e",
X"fcdb",
X"0020",
X"fee6",
X"fd70",
X"fdbc",
X"0061",
X"fc02",
X"ff7f",
X"fceb",
X"000b",
X"02f6",
X"fc0e",
X"0048",
X"fe6f",
X"ffa5",
X"fd93",
X"fd4a",
X"fea8",
X"0032",
X"fe6e",
X"ff18",
X"fd73",
X"ff69",
X"ff1d",
X"ff1c",
X"feb4",
X"012a",
X"009d",
X"fe0b",
X"0061",
X"ff86",
X"ff92",
X"fe63",
X"ffc5",
X"fe12",
X"0094",
X"fe19",
X"ffb5",
X"fe7c",
X"ff68",
X"ffc7",
X"fe02",
X"00c1",
X"fd3d",
X"fe3e",
X"007f",
X"ff05",
X"ff04",
X"ff17");


end soundtrack;