library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity number_controller is
  port(
clk50   : in std_logic;
clk25   : in std_logic;    
address: in unsigned (5 downto 0);
vertical: in integer;
horizontal: in integer;
numflag : out std_logic;
charc : out unsigned (9 downto 0)
  );
end number_controller;

architecture rtl of number_controller is

component number_all_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (7 downto 0)
  );
end component;

signal index : unsigned (9 downto 0);
signal pilenum : integer;
signal data : unsigned (7 downto 0);
signal data_tmp: unsigned (7 downto 0);

begin
  data_out: number_all_ROM port map (clk50,index,data);

process(clk25)
begin

if rising_edge(clk25) then 
   pilenum <= to_integer(address);
   index <= to_unsigned (vertical + pilenum * 16,10);
   data_tmp <= (data sll (horizontal - 1)) and x"80";
  if pilenum > 36 then
    numflag <= '0';
  else	
    if data_tmp = "00000000" then
		numflag <= '0';
    else
		numflag <= '1';
		charc <= "1111111111";
	end if;
  end if;
end if;
end process;


end rtl;




 
