library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity number_all_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(7 downto 0)
  );
end number_all_ROM;

architecture rtl of number_all_ROM is
type rom_type is array(0 to 591) of unsigned(7 downto 0);
  constant ROM: rom_type := (
x"00", x"00", x"7c", x"c6", x"ce", x"ce", x"d6", x"d6", x"e6", x"e6", x"c6", x"7c", x"00", x"00", x"00", x"00",--0
x"00", x"00", x"18", x"38", x"78", x"18", x"18", x"18", x"18", x"18",x"18", x"7e", x"00", x"00", x"00", x"00",--1
x"00", x"00", x"7c", x"c6", x"06", x"0c", x"18", x"30", x"60", x"c0", x"c6", x"fe", x"00", x"00", x"00", x"00",--2
x"00", x"00", x"7c", x"c6", x"06", x"06", x"3c", x"06", x"06", x"06", x"c6", x"7c", x"00", x"00", x"00", x"00", --3
x"00", x"00", x"0c", x"1c", x"3c", x"6c", x"cc", x"fe", x"0c", x"0c", x"0c", x"1e", x"00", x"00", x"00", x"00", --4
x"00", x"00", x"fe", x"c0", x"c0", x"c0", x"fc", x"06", x"06", x"06", x"c6", x"7c", x"00", x"00", x"00", x"00",--5
x"00", x"00", x"38", x"60", x"c0", x"c0", x"fc", x"c6", x"c6", x"c6", x"c6", x"7c", x"00", x"00", x"00", x"00",--6
x"00", x"00", x"fe", x"c6", x"06", x"06", x"0c", x"18", x"30", x"30", x"30", x"30", x"00", x"00", x"00", x"00",--7
x"00", x"00", x"7c", x"c6", x"c6", x"c6", x"7c", x"c6", x"c6", x"c6", x"c6", x"7c", x"00", x"00", x"00", x"00",--8
x"00", x"00", x"7c", x"c6", x"c6", x"c6", x"7e", x"06", x"06", x"06", x"0c", x"78", x"00", x"00", x"00", x"00",--9

x"00", x"00", x"10", x"38", x"6c", x"c6", x"c6", x"fe", x"c6", x"c6", x"c6", x"c6", x"00", x"00", x"00", x"00", --A 10
x"00", x"00", x"fc", x"66", x"66", x"66", x"7c", x"66", x"66", x"66", x"66", x"fc", x"00", x"00", x"00", x"00",--B 11
x"00", x"00", x"3c", x"66", x"c2", x"c0", x"c0", x"c0", x"c0", x"c2", x"66", x"3c", x"00", x"00", x"00", x"00",--C 12
x"00", x"00", x"f8", x"6c", x"66", x"66", x"66", x"66", x"66", x"66", x"6c", x"f8", x"00", x"00", x"00", x"00",--D 13
x"00", x"00", x"fe", x"66", x"62", x"68", x"78", x"68", x"60", x"62", x"66", x"fe", x"00", x"00", x"00", x"00",--E 14
x"00", x"00", x"fe", x"66", x"62", x"68", x"78", x"68", x"60", x"60", x"60", x"f0", x"00", x"00", x"00", x"00",--F 15
x"00", x"00", x"3c", x"66", x"c2", x"c0", x"c0", x"de", x"c6", x"c6", x"66", x"3a", x"00", x"00", x"00", x"00",--G 16
x"00", x"00", x"c6", x"c6", x"c6", x"c6", x"fe", x"c6", x"c6", x"c6", x"c6", x"c6", x"00", x"00", x"00", x"00",--H 17
x"00", x"00", x"3c", x"18", x"18", x"18", x"18", x"18", x"18", x"18", x"18", x"3c", x"00", x"00", x"00", x"00",--I 18
x"00", x"00", x"1e", x"0c", x"0c", x"0c", x"0c", x"0c", x"cc", x"cc", x"cc", x"78", x"00", x"00", x"00", x"00",--J 19
x"00", x"00", x"e6", x"66", x"66", x"6c", x"78", x"78", x"6c", x"66", x"66", x"e6", x"00", x"00", x"00", x"00",--K 20
x"00", x"00", x"f0", x"60", x"60", x"60", x"60", x"60", x"60", x"62", x"66", x"fe", x"00", x"00", x"00", x"00",--L 21
x"00", x"00", x"c6", x"ee", x"fe", x"fe", x"d6", x"c6", x"c6", x"c6", x"c6", x"c6", x"00", x"00", x"00", x"00",--M 22
x"00", x"00", x"c6", x"e6", x"f6", x"fe", x"de", x"ce", x"c6", x"c6", x"c6", x"c6", x"00", x"00", x"00", x"00",--N 23
x"00", x"00", x"7c", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"7c", x"00", x"00", x"00", x"00",--O 24
x"00", x"00", x"fc", x"66", x"66", x"66", x"7c", x"60", x"60", x"60", x"60", x"f0", x"00", x"00", x"00", x"00",--P 25
x"00", x"00", x"7c", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"d6", x"de", x"7c", x"00", x"00", x"00", x"00",--Q 26
x"00", x"00", x"fc", x"66", x"66", x"66", x"7c", x"6c", x"66", x"66", x"66", x"e6", x"00", x"00", x"00", x"00",--R 27
x"00", x"00", x"7c", x"c6", x"c6", x"60", x"38", x"0c", x"06", x"c6", x"c6", x"7c", x"00", x"00", x"00", x"00",--S 28
x"00", x"00", x"7e", x"7e", x"5a", x"18", x"18", x"18", x"18", x"18", x"18", x"3c", x"00", x"00", x"00", x"00",--T 29
x"00", x"00", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"7c", x"00", x"00", x"00", x"00",--U 30
x"00", x"00", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"c6", x"6c", x"38", x"10", x"00", x"00", x"00", x"00",--V 31
x"00", x"00", x"c6", x"c6", x"c6", x"c6", x"d6", x"d6", x"d6", x"fe", x"ee", x"6c", x"00", x"00", x"00", x"00",--W 32
x"00", x"00", x"c6", x"c6", x"6c", x"7c", x"38", x"38", x"7c", x"6c", x"c6", x"c6", x"00", x"00", x"00", x"00",--X 33
x"00", x"00", x"66", x"66", x"66", x"66", x"3c", x"18", x"18", x"18", x"18", x"3c", x"00", x"00", x"00", x"00",--Y 34
x"00", x"00", x"fe", x"c6", x"86", x"0c", x"18", x"30", x"60", x"c2", x"c6", x"fe", x"00", x"00", x"00", x"00",--Z 35
x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00" --nothing displayed 36
);

begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;