library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity number_6_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (7 downto 0);
data  : out std_logic
  );
end number_6_ROM;

architecture rtl of number_6_ROM is
type rom_type is array(0 to 215) of std_logic;
  constant ROM: rom_type := (
'0','0','0','0','0','0','0','0','1','1','1','0',
'0','0','0','0','0','0','1','1','1','0','0','0',
'0','0','0','0','1','1','1','1','0','0','0','0',
'0','0','0','1','1','0','0','0','0','0','0','0',
'0','0','1','1','0','0','0','0','0','0','0','0',
'0','0','1','1','0','0','0','0','0','0','0','0',
'0','1','1','0','0','0','0','0','0','0','0','0',
'0','1','1','1','1','1','1','1','0','0','0','0',
'0','1','1','1','0','0','0','1','1','0','0','0',
'1','1','1','0','0','0','0','0','1','1','0','0',
'1','1','1','0','0','0','0','0','0','1','1','0',
'1','1','1','0','0','0','0','0','0','1','1','0',
'1','1','1','0','0','0','0','0','0','1','1','0',
'0','1','1','0','0','0','0','0','0','1','1','0',
'0','1','1','0','0','0','0','0','0','1','0','0',
'0','0','1','1','0','0','0','0','0','1','0','0',
'0','0','0','1','1','0','0','1','1','1','0','0',
'0','0','0','0','1','1','1','1','1','0','0','0'); 
begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;