library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity item_controller is
  port(
clk50   : in std_logic;
clk25   : in std_logic;    
address: in unsigned (3 downto 0);
phase : in integer;
vertical: in integer;
horizontal: in integer;
itemflag : out std_logic;
pixel_R: out unsigned (3 downto 0);
pixel_G: out unsigned (3 downto 0);
pixel_B: out unsigned (3 downto 0)
  );
end item_controller;

architecture rtl of item_controller is

component car1_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car1_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car1_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car2_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car2_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car2_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car3_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car3_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car3_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car4_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car4_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car4_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_1_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_1_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_1_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_2_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_2_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component car5_2_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_mid_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_mid_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_mid_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_head_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_head_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_head_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_tail_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_tail_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component log_tail_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle1_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle1_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle1_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle2_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle2_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle2_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle3_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle3_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component turtle3_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

--signal data_R:integer;
--signal data_G:integer;
--signal data_B:integer;
signal index : unsigned ( 9 downto 0 );
signal car1_R,car1_G,car1_B : unsigned (3 downto 0);
signal car2_R,car2_G,car2_B : unsigned (3 downto 0);
signal car3_R,car3_G,car3_B : unsigned (3 downto 0);
signal car4_R,car4_G,car4_B : unsigned (3 downto 0);
signal car5_1_R,car5_1_G,car5_1_B : unsigned (3 downto 0);
signal car5_2_R,car5_2_G,car5_2_B : unsigned (3 downto 0);
signal log_mid_R,log_mid_G,log_mid_B : unsigned (3 downto 0);
signal log_head_R,log_head_G,log_head_B : unsigned (3 downto 0);
signal log_tail_R,log_tail_G,log_tail_B : unsigned (3 downto 0);
signal turtle1_R,turtle1_G,turtle1_B : unsigned (3 downto 0);
signal turtle2_R,turtle2_G,turtle2_B : unsigned (3 downto 0);
signal turtle3_R,turtle3_G,turtle3_B : unsigned (3 downto 0);


begin

car1R: car1_R_ROM port map (clk50,index,car1_R);
car1G: car1_G_ROM port map (clk50,index,car1_G);
car1B: car1_B_ROM port map (clk50,index,car1_B);
car2R: car2_R_ROM port map (clk50,index,car2_R);
car2G: car2_G_ROM port map (clk50,index,car2_G);
car2B: car2_B_ROM port map (clk50,index,car2_B);
car3R: car3_R_ROM port map (clk50,index,car3_R);
car3G: car3_G_ROM port map (clk50,index,car3_G);
car3B: car3_B_ROM port map (clk50,index,car3_B);
car4R: car4_R_ROM port map (clk50,index,car4_R);
car4G: car4_G_ROM port map (clk50,index,car4_G);
car4B: car4_B_ROM port map (clk50,index,car4_B);
car5_1R: car5_1_R_ROM port map (clk50,index,car5_1_R);
car5_1G: car5_1_G_ROM port map (clk50,index,car5_1_G);
car5_1B: car5_1_B_ROM port map (clk50,index,car5_1_B);
car5_2R: car5_2_R_ROM port map (clk50,index,car5_2_R);
car5_2G: car5_2_G_ROM port map (clk50,index,car5_2_G);
car5_2B: car5_2_B_ROM port map (clk50,index,car5_2_B);
log_midR: log_mid_R_ROM port map (clk50,index,log_mid_R);
log_midG: log_mid_G_ROM port map (clk50,index,log_mid_G);
log_midB: log_mid_B_ROM port map (clk50,index,log_mid_B);
log_headR: log_head_R_ROM port map (clk50,index,log_head_R);
log_headG: log_head_G_ROM port map (clk50,index,log_head_G);
log_headB: log_head_B_ROM port map (clk50,index,log_head_B);
log_tailR: log_tail_R_ROM port map (clk50,index,log_tail_R);
log_tailG: log_tail_G_ROM port map (clk50,index,log_tail_G);
log_tailB: log_tail_B_ROM port map (clk50,index,log_tail_B);
turtle1R: turtle1_R_ROM port map (clk50,index,turtle1_R);
turtle1G: turtle1_G_ROM port map (clk50,index,turtle1_G);
turtle1B: turtle1_B_ROM port map (clk50,index,turtle1_B);
turtle2R: turtle2_R_ROM port map (clk50,index,turtle2_R);
turtle2G: turtle2_G_ROM port map (clk50,index,turtle2_G);
turtle2B: turtle2_B_ROM port map (clk50,index,turtle2_B);
turtle3R: turtle3_R_ROM port map (clk50,index,turtle3_R);
turtle3G: turtle3_G_ROM port map (clk50,index,turtle3_G);
turtle3B: turtle3_B_ROM port map (clk50,index,turtle3_B);

process(clk25)
begin
if rising_edge(clk25) then 
index <= to_unsigned ((vertical*32 + horizontal), 10);
case address is
when "0000" =>
  itemflag <= '0';
when "0001" =>  
if car1_R ="0000" and car1_G  ="0000" and car1_B  ="0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car1_R ;
  pixel_G <= car1_G ;
  pixel_B <= car1_B ;
end if;
when "0010" =>
if log_head_R ="0000" and log_head_G  = "0000" and log_head_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= log_head_R ;
  pixel_G <= log_head_G ;
  pixel_B <= log_head_B ;
end if;
when "0011" =>
if log_mid_R ="0000" and log_mid_G  = "0000" and log_mid_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
pixel_R <= log_mid_R ;
pixel_G <= log_mid_G ;
pixel_B <= log_mid_B ;
end if;
when "0100" =>
if log_tail_R ="0000" and log_tail_G  = "0000" and log_tail_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
pixel_R <= log_tail_R ;
pixel_G <= log_tail_G ;
pixel_B <= log_tail_B ;
end if;
when "0101" =>
case phase is 
when 1 =>
if turtle1_R = "0000" and turtle1_G  = "0000" and turtle1_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
pixel_R <= turtle1_R ;
pixel_G <= turtle1_G ;
pixel_B <= turtle1_B ;
end if;
when 2 =>
if turtle2_R ="0000" and turtle2_G  = "0000" and turtle2_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
pixel_R <= turtle2_R ;
pixel_G <= turtle2_G ;
pixel_B <= turtle2_B ;
end if;
when 3 =>
if turtle3_R ="0000" and turtle3_G  ="0000" and turtle3_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
pixel_R <= turtle3_R ;
pixel_G <= turtle3_G ;
pixel_B <= turtle3_B ;
end if;
when others =>
  itemflag <= '0';
end case;
when "0110" =>  
if car2_R ="0000" and car2_G  = "0000" and car2_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car2_R ;
  pixel_G <= car2_G ;
  pixel_B <= car2_B ;
end if;
when "0111" =>  
if car3_R ="0000" and car3_G  = "0000" and car3_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car3_R ;
  pixel_G <= car3_G ;
  pixel_B <= car3_B ;
end if;
when "1000" =>  
if car4_R ="0000" and car4_G  = "0000" and car4_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car4_R ;
  pixel_G <= car4_G ;
  pixel_B <= car4_B ;
end if;
when "1001" =>  
if car5_1_R ="0000" and car5_1_G  = "0000" and car5_1_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car5_1_R ;  
  pixel_G <= car5_1_G ;
  pixel_B <= car5_1_B ;
end if;
when "1010" =>  
if car5_2_R ="0000" and car5_2_G  = "0000" and car5_2_B  = "0000" then
  itemflag <= '0';
else
  itemflag <='1';
  pixel_R <= car5_2_R ;
  pixel_G <= car5_2_G ;
  pixel_B <= car5_2_B ;
end if;
when others =>
  itemflag <= '0';
end case;
end if;
end process;


end rtl;




 
