library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity homefrog_G_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end homefrog_G_ROM;

architecture rtl of homefrog_G_ROM is
type rom_type is array(0 to 1023) of unsigned(3 downto 0);
constant ROM: rom_type := (
"0111","0111","0111","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0110","0111","0110","0110","0110","0110","0110","0110","0111","0111","0111","0111","0111",
"0111","0111","0110","0110","0111","0111","0110","0111","0110","0110","0110","0111","0110","0101","0111","0110","0110","0110","0110","0110","0111","0111","1000","0111","0111","0110","0110","0110","0110","0111","0111","0111",
"0101","0111","0111","0111","0111","0110","0101","0110","0110","0110","0110","1000","1001","1001","1001","0111","0111","1000","0110","0110","0110","0110","1000","1001","1000","0110","0111","0111","0110","0111","0111","0111",
"0101","0110","0110","0110","0110","0101","0101","0101","0101","0110","1000","1011","1101","1101","1101","1011","1001","1000","0111","0111","0111","1000","1001","1001","1000","0110","0111","0111","0110","0110","0111","0111",
"0101","0101","0101","0110","0110","0110","0110","0110","0111","1001","1100","1110","1111","1111","1111","1110","1011","1001","1001","1010","1100","1110","1111","1101","1001","0110","0111","1000","0110","0110","0110","0111",
"0110","0111","0111","0111","0110","0111","0111","0111","1001","1100","1101","1111","1111","1111","1111","1111","1011","1010","1100","1110","1111","1111","1111","1111","1101","1001","0111","1000","0111","0110","0110","0111",
"0111","0111","0111","1000","1000","1000","1000","1000","1010","1100","1101","1110","1101","1100","1110","1110","1011","1011","1110","1111","1111","1111","1111","1111","1111","1100","0111","0111","1000","0111","0101","0110",
"1000","1000","1000","1001","1010","1001","1001","1010","1011","1101","1110","1100","0110","0101","1100","1110","1100","1101","1101","1110","1111","1111","1111","1111","1111","1100","1001","0111","0110","0111","0110","0110",
"1000","1000","1001","1010","1011","1011","1011","1011","1100","1101","1111","1000","0010","0011","1100","1110","1101","1101","1101","1110","1101","1010","1100","1111","1111","1100","1010","0111","0111","1000","0110","0101",
"1000","1000","1001","1010","1011","1100","1100","1011","1100","1101","1110","1000","0101","0101","1100","1110","1101","1101","1110","1101","0111","0011","0101","1100","1111","1100","1010","1000","0111","0111","0110","0101",
"0111","1000","1001","1010","1011","1011","1011","1010","1011","1101","1101","0110","0100","0100","1010","1101","1101","1101","1110","1100","0011","0011","0101","1010","1111","1100","1010","1000","0110","0110","0101","0101",
"0111","1001","1001","1010","1010","1010","1011","1100","1100","1101","1101","1000","0101","0111","1010","1101","1101","1101","1110","1011","0011","1000","1100","1100","1110","1011","1001","1001","0111","0111","0101","0101",
"1000","1001","1010","1011","1100","1100","1100","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1000","0001","0100","1000","1001","1100","1011","1000","1010","1010","0111","0101","0110",
"1001","1100","1100","1100","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1010","0111","1000","1000","1010","1100","1010","1000","1010","1011","1001","0110","0101",
"1100","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1110","1101","1100","1100","1011","1001","1000","1000","1011","1010","0111","0101",
"1101","1101","1101","1110","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1110","1110","1100","1010","1000","0111","1001","1010","1001","0111",
"1011","1101","1101","1110","1110","1101","1101","1101","1101","1101","1101","1101","1101","1101","1101","1110","1110","1110","1110","1110","1101","1110","1111","1111","1110","1100","1001","1000","1000","1000","1001","0111",
"1001","1011","1100","1101","1101","1101","1101","1101","1101","1101","1110","1110","1110","1110","1111","1111","1111","1111","1111","1111","1110","1101","1101","1101","1101","1100","1011","1010","1001","0111","1000","1000",
"1000","1000","1010","1011","1100","1100","1101","1101","1101","1110","1111","1110","1110","1110","1111","1111","1110","1101","1100","1100","1100","1100","1100","1011","1010","1001","1001","1010","1010","1001","1000","1000",
"1000","0111","0110","0110","1001","1011","1100","1100","1100","1101","1101","1101","1101","1100","1100","1100","1100","1011","1011","1011","1010","1010","0111","0100","0100","0011","0110","1010","1010","1010","1000","0111",
"1010","1001","0110","0011","0010","0101","1001","1010","1011","1011","1011","1011","1011","1011","1010","1010","1010","1010","1001","0111","0100","0011","0100","0110","0110","0010","0101","1010","1010","1010","1001","0111",
"1011","1100","1011","0111","0011","0000","0001","0010","0101","1000","1001","1001","1001","0111","0011","0011","0011","0100","0011","0100","1000","1010","1101","1110","1101","0100","0101","1010","1010","1010","1010","1000",
"1101","1101","1101","1100","1000","0100","0000","0000","0000","0010","0011","0011","0011","0010","0010","0110","1001","1010","1011","1100","1111","1111","1111","1111","1100","0100","0100","1010","1010","1010","1000","0111",
"1101","1101","1101","1101","1011","0111","0111","0101","0000","0010","0110","0110","1000","1010","1010","1011","1011","1011","1100","1101","1111","1111","1111","1101","1001","0100","0110","1010","1010","1001","0111","1000",
"1110","1101","1101","1110","1101","1001","1000","1010","0110","0011","0001","0000","0100","1000","1011","1100","1100","1100","1101","1100","1001","1001","1000","0100","0011","0111","1010","1010","1001","0111","1001","1100",
"1110","1110","1110","1110","1110","1101","1010","1001","1010","1010","0110","0100","0100","0100","0100","0101","0101","0101","0101","0100","0100","0101","0101","0111","1010","1010","1001","1000","0111","1010","1110","1110",
"1110","1110","1110","1110","1110","1110","1101","1010","1000","1001","1011","1011","1011","1001","0110","0110","0110","0110","0110","0111","1010","1011","1011","1010","1001","1000","0111","0111","1010","1110","1110","1101",
"1110","1110","1110","1110","1110","1110","1110","1110","1010","1000","1000","1000","1001","1010","1010","1011","1011","1011","1011","1011","1001","1000","1000","1000","0111","0111","1010","1100","1110","1101","1011","1001",
"1001","1001","1010","1011","1011","1100","1101","1101","1101","1100","1001","0110","0111","1000","1000","1000","1000","1000","1000","1000","1000","0111","0111","1001","1100","1100","1101","1100","1010","1001","1000","0111",
"0111","0111","1000","1000","1000","1000","1000","1000","1001","1001","1000","0111","0111","0110","0110","0110","0110","0110","0110","0110","1000","1011","1011","1010","1001","1001","1001","1000","1000","0111","1000","0111",
"0111","0111","0111","0111","1000","1000","0111","0111","0111","0111","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","0111","0111","0111","1000","0111","0111","0111",
"0111","0111","0111","0111","0111","0111","0111","0111","0111","0111","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","1000","0111","0111","0111","0111","0111","0110"); 

begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;