--
-- Copyright (c)2002 Flarion Technologies. All Rights Reserved.
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
--use ieee.std_logic_arith.all;
use ieee.std_logic_misc.all;

package functions is
-- signed / unsigned shifts
function s_shr (v : std_logic_vector; s : integer) return std_logic_vector;

end functions;

package body functions is
-- sign shift right (arithmetic)
function s_shr (v : std_logic_vector; s : integer) return std_logic_vector is
variable r : std_logic_vector (v'range);
begin
case s is
when 0 => r := v;
when 1 => r (v'left - 1 downto 0) 			:= v (v'left downto 1);
  for i in v'left downto v'left - 1 + 1 loop
r (i) := v (v'left);
  end loop;
when 2 => r (v'left - 2 downto 0) 			:= v (v'left downto 2);
  for i in v'left downto v'left - 2 + 1 loop
r (i) := v (v'left);
  end loop;
when 3 => r (v'left - 3 downto 0) 			:= v (v'left downto 3);
  for i in v'left downto v'left - 3 + 1 loop
r (i) := v (v'left);
  end loop;
when others => null;
end case; 
return r;
end;
end functions;
