library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frogming_controller is
  port(
clk50   : in std_logic;
clk25   : in std_logic;    
address: in unsigned (1 downto 0);
vertical: in integer;
horizontal: in integer;
smallflag : out std_logic;
pixel_R: out unsigned (3 downto 0);
pixel_G: out unsigned (3 downto 0);
pixel_B: out unsigned (3 downto 0)
  );
end  frogming_controller;

architecture rtl of frogming_controller is

component frogleft_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component frogleft_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component frogleft_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component frogright_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component frogright_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component frogright_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;


signal index : unsigned ( 9 downto 0 );

signal frogleft_R,frogleft_G,frogleft_B: unsigned (3 downto 0);
signal frogright_R,frogright_G,frogright_B : unsigned (3 downto 0);

begin

frogleftmap_R : frogleft_R_ROM port map (clk50, index, frogleft_R);
frogleftmap_G : frogleft_G_ROM port map (clk50, index, frogleft_G);
frogleftmap_B : frogleft_B_ROM port map (clk50, index, frogleft_B);

frogrightmap_R : frogright_R_ROM port map (clk50, index, frogright_R);
frogrightmap_G : frogright_G_ROM port map (clk50, index, frogright_G);
frogrightmap_B : frogright_B_ROM port map (clk50, index, frogright_B);


process(clk25)
begin
if rising_edge(clk25) then 
index <= to_unsigned ((vertical * 8 + horizontal), 10);

case address is
when "00" =>
 smallflag <= '1';
  pixel_R <= "0000";
  pixel_G <= "0000";
  pixel_B <= "0000";
when "01" =>
  smallflag <= '1';
  pixel_R <= frogleft_R ;
  pixel_G <= frogleft_G ;
  pixel_B <= frogleft_B ;

when "10" =>
  smallflag <= '1';
  pixel_R <= frogright_R ;
  pixel_G <= frogright_G ;
  pixel_B <= frogright_B ;

when others =>
  smallflag <= '0';
 end case;
end if;
end process;

end rtl;




 
