library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frogleft_G_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end frogleft_G_ROM;

architecture rtl of frogleft_G_ROM is
type rom_type is array(0 to 127) of unsigned(3 downto 0);
constant ROM: rom_type := (
"0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0010","0000","0000","0000","0011",
"0000","0000","0101","0111","0011","0000","0101","1001",
"0000","0000","1000","1010","0110","0000","1010","1111",
"0000","0000","1001","1011","0111","1000","1100","1111",
"0000","0000","1001","1100","1010","0101","1000","1111",
"0000","0000","0110","1010","1100","1000","1001","1111",
"0000","0000","0000","0111","1011","1101","1111","1111",
"0000","0000","0000","0000","0000","1010","1110","1111",
"0000","0000","0110","1000","0000","1001","1101","1111",
"0000","0000","1000","1010","1000","1011","1101","1110",
"0000","0000","1000","1011","1011","1100","1100","1010",
"0000","0000","0111","1010","1100","1001","0111","0110",
"0000","0000","0111","1001","1000","0101","0011","0000",
"0000","0000","0101","0110","0101","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000"); 

begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;