library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frog_jump_R_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end frog_jump_R_ROM;

architecture rtl of frog_jump_R_ROM is
--type rom_type is array (0 to 1023) of integer;
--constant ROM : rom_type :=
--( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 1, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 83, 12, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 19, 0, 5, 94, 0, 13, 0, 0, 0, 0, 0, 14, 0, 1, 0, 0, 0, 0, 0, 5, 0, 89, 0, 0, 11, 0, 0, 0 , 
-- 0, 0, 0, 0, 70, 12, 82, 93, 3, 86, 4, 0, 0, 6, 18, 73, 64, 83, 10, 2, 6, 0, 0, 83, 0, 66, 17, 1, 83, 0, 0, 0 , 
-- 0, 0, 0, 15, 89, 67, 85, 0, 85, 90, 9, 3, 10, 76, 69, 86, 5, 83, 97, 81, 1, 0, 9, 89, 0, 93, 67, 8, 95, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 80, 2, 0, 77, 0, 87, 134, 138, 91, 88, 83, 0, 88, 68, 72, 151, 138, 6, 11, 67, 93, 85, 80, 2, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 91, 5, 12, 0, 137, 244, 146, 157, 68, 1, 0, 11, 80, 145, 139, 247, 136, 0, 19, 85, 82, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 160, 251, 145, 84, 78, 12, 0, 0, 91, 79, 133, 246, 143, 0, 0, 11, 69, 1, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 3, 254, 1, 0, 0, 148, 134, 80, 85, 88, 3, 0, 5, 99, 81, 84, 139, 147, 0, 0, 4, 80, 6, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 250, 9, 0, 1, 0, 79, 88, 84, 0, 83, 81, 89, 0, 83, 78, 87, 0, 0, 0, 1, 78, 3, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 1, 255, 87, 91, 4, 79, 77, 83, 77, 92, 87, 81, 82, 85, 81, 82, 81, 75, 10, 78, 79, 90, 7, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 83, 254, 236, 0, 93, 98, 73, 86, 79, 75, 98, 74, 70, 97, 84, 1, 5, 81, 102, 82, 3, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 2, 77, 86, 83, 86, 76, 0, 92, 101, 81, 109, 76, 81, 89, 0, 91, 71, 5, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 80, 89, 0, 5, 65, 86, 80, 68, 79, 81, 80, 8, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 78, 1, 17, 81, 72, 92, 79, 90, 83, 74, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 2, 0, 1, 82, 77, 90, 88, 74, 91, 81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 74, 10, 1, 255, 86, 93, 76, 91, 82, 72, 81, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 5, 0, 0, 253, 2, 85, 88, 81, 88, 97, 86, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 90, 0, 0, 252, 0, 77, 86, 77, 86, 82, 81, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 8, 77, 85, 0, 5, 0, 19, 84, 67, 72, 88, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 75, 13, 89, 89, 85, 79, 2, 0, 0, 82, 98, 81, 83, 74, 82, 23, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 84, 241, 87, 95, 83, 79, 73, 84, 84, 83, 87, 73, 70, 93, 80, 88, 92, 14, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 251, 88, 84, 73, 1, 21, 4, 1, 87, 80, 89, 0, 4, 2, 2, 83, 77, 57, 23, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 91, 97, 81, 0, 9, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 9, 91, 78, 86, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 11, 1, 66, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 90, 16, 1, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 5, 79, 83, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 84, 67, 0, 0, 0, 0 , 
-- 0, 0, 0, 1, 91, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 65, 0, 0 , 
-- 0, 0, 1, 79, 4, 83, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 16, 0, 100 , 
-- 2, 78, 78, 0, 78, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 5, 0, 0, 0 , 
-- 0, 1, 1, 88, 16, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 8, 6, 0 , 
-- 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 165, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); 

type rom_type is array(0 to 1023) of unsigned(3 downto 0);
constant ROM: rom_type := (
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0001","0000","0000","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0100","0000","0101","0101","0000","0101","0000","0000","0000","0000","0001","0100","0100","0101","0000","0000","0000","0000","0000","0101","0000","0100","0001","0000","0101","0000","0000","0000",
"0000","0000","0000","0000","0101","0100","0101","0000","0101","0101","0000","0000","0000","0100","0100","0101","0000","0101","0110","0101","0000","0000","0000","0101","0000","0101","0100","0000","0101","0000","0000","0000",
"0000","0000","0000","0000","0000","0101","0000","0000","0100","0000","0101","1000","1000","0101","0101","0101","0000","0101","0100","0100","1001","1000","0000","0000","0100","0101","0101","0101","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","1000","1111","1001","1001","0100","0000","0000","0000","0101","1001","1000","1111","1000","0000","0001","0101","0101","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","1010","1111","1001","0101","0100","0000","0000","0000","0101","0100","1000","1111","1000","0000","0000","0000","0100","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","1111","0000","0000","0000","1001","1000","0101","0101","0101","0000","0000","0000","0110","0101","0101","1000","1001","0000","0000","0000","0101","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","1111","0000","0000","0000","0000","0100","0101","0101","0000","0101","0101","0101","0000","0101","0100","0101","0000","0000","0000","0000","0100","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","1111","0101","0101","0000","0100","0100","0101","0100","0101","0101","0101","0101","0101","0101","0101","0101","0100","0000","0100","0100","0101","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0101","1111","1110","0000","0101","0110","0100","0101","0100","0100","0110","0100","0100","0110","0101","0000","0000","0101","0110","0101","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0100","0101","0101","0101","0100","0000","0101","0110","0101","0110","0100","0101","0101","0000","0101","0100","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0101","0000","0000","0100","0101","0101","0100","0100","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0100","0000","0001","0101","0100","0101","0100","0101","0101","0100","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","0101","0100","0101","0101","0100","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0100","0000","0000","1111","0101","0101","0100","0101","0101","0100","0101","0100","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0000","0000","0000","1111","0000","0101","0101","0101","0101","0110","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0000","0101","0000","0000","1111","0000","0100","0101","0100","0101","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0000","0100","0101","0000","0000","0000","0001","0101","0100","0100","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0100","0000","0101","0101","0101","0100","0000","0000","0000","0101","0110","0101","0101","0100","0101","0001","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0101","1111","0101","0101","0101","0100","0100","0101","0101","0101","0101","0100","0100","0101","0101","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","1111","0101","0101","0100","0000","0001","0000","0000","0101","0101","0101","0000","0000","0000","0000","0101","0100","0011","0001","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0101","0110","0101","0000","0000","0000","0000","0000","0000","0000","0000","0001","0000","0000","0000","0000","0000","0101","0100","0101","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0100","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0001","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0100","0101","0001","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0100","0000","0000","0000","0000",
"0000","0000","0000","0000","0101","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0100","0000","0000",
"0000","0000","0000","0100","0000","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0001","0000","0110",
"0000","0100","0100","0000","0100","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0101","0001","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","1010","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"); 


begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;