library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frog_jump_G_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end frog_jump_G_ROM;

architecture rtl of frog_jump_G_ROM is
--type rom_type is array (0 to 1023) of integer;
--constant ROM : rom_type :=
--( 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 93, 153, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 149, 61, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 91, 0, 91, 225, 88, 96, 0, 0, 0, 0, 0, 100, 95, 98, 0, 0, 0, 0, 0, 65, 73, 198, 69, 0, 54, 0, 0, 0 , 
-- 0, 0, 0, 101, 221, 88, 161, 217, 97, 217, 99, 0, 72, 79, 93, 184, 222, 170, 100, 99, 70, 0, 62, 151, 71, 185, 92, 59, 162, 63, 0, 0 , 
-- 0, 0, 0, 87, 222, 168, 219, 249, 124, 227, 90, 61, 97, 184, 219, 147, 255, 161, 218, 144, 107, 53, 64, 159, 93, 189, 164, 95, 167, 65, 0, 0 , 
-- 0, 0, 0, 0, 101, 228, 254, 255, 224, 91, 134, 32, 29, 222, 221, 227, 255, 219, 223, 184, 36, 26, 63, 82, 159, 201, 184, 144, 67, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 89, 218, 245, 96, 0, 26, 255, 27, 27, 225, 250, 255, 246, 180, 34, 29, 145, 36, 0, 96, 181, 166, 72, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 102, 252, 91, 0, 0, 32, 144, 35, 152, 226, 251, 255, 253, 177, 127, 39, 57, 32, 0, 0, 98, 191, 61, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 89, 250, 99, 0, 0, 32, 25, 156, 215, 222, 248, 255, 251, 171, 173, 134, 33, 24, 0, 0, 99, 191, 78, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 102, 254, 89, 0, 96, 107, 153, 223, 230, 254, 218, 227, 220, 251, 182, 178, 161, 96, 0, 0, 86, 194, 58, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 91, 247, 222, 133, 88, 125, 157, 220, 224, 211, 220, 221, 223, 225, 220, 169, 160, 127, 95, 124, 185, 163, 64, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 102, 224, 255, 254, 252, 226, 126, 158, 223, 230, 220, 234, 216, 236, 206, 162, 97, 93, 193, 181, 162, 63, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 91, 91, 229, 219, 127, 120, 231, 253, 217, 208, 215, 220, 219, 180, 150, 99, 195, 168, 61, 68, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 84, 96, 155, 222, 255, 243, 226, 235, 212, 231, 220, 187, 162, 91, 63, 51, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 221, 251, 254, 227, 220, 220, 223, 220, 176, 157, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 254, 247, 255, 220, 220, 219, 217, 230, 173, 163, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 229, 249, 255, 251, 223, 229, 224, 210, 238, 165, 163, 136, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 247, 255, 255, 253, 247, 220, 211, 224, 218, 176, 151, 126, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 255, 217, 255, 253, 255, 251, 234, 218, 188, 153, 125, 123, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 254, 185, 222, 255, 249, 255, 246, 176, 153, 127, 139, 119, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 217, 252, 224, 189, 174, 220, 255, 252, 255, 181, 150, 131, 154, 191, 228, 86, 0, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 219, 255, 213, 181, 184, 153, 181, 224, 221, 222, 154, 157, 157, 148, 198, 214, 212, 89, 0, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 255, 220, 180, 166, 99, 97, 88, 96, 127, 155, 124, 98, 99, 96, 94, 161, 223, 168, 85, 0, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 0, 180, 214, 185, 95, 82, 0, 0, 0, 0, 102, 90, 91, 0, 0, 0, 0, 94, 149, 227, 157, 96, 0, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 0, 100, 92, 163, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 159, 92, 104, 0, 0, 0, 0 , 
-- 0, 0, 0, 0, 82, 154, 164, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 155, 165, 102, 0, 0, 0 , 
-- 0, 0, 0, 96, 160, 150, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 93, 108, 158, 0, 0 , 
-- 0, 87, 102, 153, 95, 156, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 102, 55, 91, 102, 154 , 
-- 93, 169, 162, 101, 154, 98, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 87, 100, 66, 96, 100 , 
-- 100, 98, 90, 156, 97, 147, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 64, 100, 90, 54, 72 , 
-- 0, 0, 0, 86, 104, 97, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 109, 49, 67, 190, 0 , 
-- 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); 

type rom_type is array(0 to 1023) of unsigned(3 downto 0);
constant ROM: rom_type := (
"0000","0000","0000","0000","0000","0000","0000","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0011","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0101","1001","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0100","1001","0011","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0101","0000","0101","1110","0101","0110","0000","0000","0000","0000","0000","0110","0101","0110","0000","0000","0000","0000","0000","0100","0100","1100","0100","0000","0011","0000","0000","0000",
"0000","0000","0000","0110","1101","0101","1010","1101","0110","1101","0110","0000","0100","0100","0101","1011","1101","1010","0110","0110","0100","0000","0011","1001","0100","1011","0101","0011","1010","0011","0000","0000",
"0000","0000","0000","0101","1101","1010","1101","1111","0111","1110","0101","0011","0110","1011","1101","1001","1111","1010","1101","1001","0110","0011","0100","1001","0101","1011","1010","0101","1010","0100","0000","0000",
"0000","0000","0000","0000","0110","1110","1111","1111","1110","0101","1000","0010","0001","1101","1101","1110","1111","1101","1101","1011","0010","0001","0011","0101","1001","1100","1011","1001","0100","0000","0000","0000",
"0000","0000","0000","0000","0000","0101","1101","1111","0110","0000","0001","1111","0001","0001","1110","1111","1111","1111","1011","0010","0001","1001","0010","0000","0110","1011","1010","0100","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0110","1111","0101","0000","0000","0010","1001","0010","1001","1110","1111","1111","1111","1011","0111","0010","0011","0010","0000","0000","0110","1011","0011","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0101","1111","0110","0000","0000","0010","0001","1001","1101","1101","1111","1111","1111","1010","1010","1000","0010","0001","0000","0000","0110","1011","0100","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0110","1111","0101","0000","0110","0110","1001","1101","1110","1111","1101","1110","1101","1111","1011","1011","1010","0110","0000","0000","0101","1100","0011","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0101","1111","1101","1000","0101","0111","1001","1101","1110","1101","1101","1101","1101","1110","1101","1010","1010","0111","0101","0111","1011","1010","0100","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0110","1110","1111","1111","1111","1110","0111","1001","1101","1110","1101","1110","1101","1110","1100","1010","0110","0101","1100","1011","1010","0011","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0101","0101","1110","1101","0111","0111","1110","1111","1101","1101","1101","1101","1101","1011","1001","0110","1100","1010","0011","0100","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0101","0110","1001","1101","1111","1111","1110","1110","1101","1110","1101","1011","1010","0101","0011","0011","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","1010","1101","1111","1111","1110","1101","1101","1101","1101","1011","1001","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","1001","1111","1111","1111","1101","1101","1101","1101","1110","1010","1010","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","1001","1110","1111","1111","1111","1101","1110","1110","1101","1110","1010","1010","1000","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","1010","1111","1111","1111","1111","1111","1101","1101","1110","1101","1011","1001","0111","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","1001","1111","1101","1111","1111","1111","1111","1110","1101","1011","1001","0111","0111","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","1001","1111","1011","1101","1111","1111","1111","1111","1011","1001","0111","1000","0111","0100","0000","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","1101","1111","1110","1011","1010","1101","1111","1111","1111","1011","1001","1000","1001","1011","1110","0101","0000","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","1101","1111","1101","1011","1011","1001","1011","1110","1101","1101","1001","1001","1001","1001","1100","1101","1101","0101","0000","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","0000","1111","1101","1011","1010","0110","0110","0101","0110","0111","1001","0111","0110","0110","0110","0101","1010","1101","1010","0101","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0000","1011","1101","1011","0101","0101","0000","0000","0000","0000","0110","0101","0101","0000","0000","0000","0000","0101","1001","1110","1001","0110","0000","0000","0000","0000","0000",
"0000","0000","0000","0000","0000","0110","0101","1010","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","1001","0101","0110","0000","0000","0000","0000",
"0000","0000","0000","0000","0101","1001","1010","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","1001","1010","0110","0000","0000","0000",
"0000","0000","0000","0110","1010","1001","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0110","0101","0110","1001","0000","0000",
"0000","0101","0110","1001","0101","1001","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0101","0110","0011","0101","0110","1001",
"0101","1010","1010","0110","1001","0110","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0100","0101","0110","0100","0110","0110",
"0110","0110","0101","1001","0110","1001","0101","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0110","0100","0110","0101","0011","0100",
"0000","0000","0000","0101","0110","0110","0110","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0110","0110","0011","0100","1011","0000",
"0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"); 


begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;