library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frog_jump_B_ROM is
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end frog_jump_B_ROM;

architecture rtl of frog_jump_B_ROM is
--type rom_type is array (0 to 1023) of integer;
--constant ROM : rom_type :=
--( 255, 255, 255, 255, 255, 255, 255, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 4, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 6, 64, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 5, 59, 6, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 18, 255, 0, 61, 12, 14, 255, 255, 255, 255, 255, 1, 13, 5, 255, 255, 255, 255, 255, 1, 0, 57, 0, 255, 1, 255, 255, 255 , 
-- 255, 255, 255, 0, 54, 23, 72, 59, 0, 59, 0, 255, 0, 10, 0, 46, 65, 76, 0, 6, 10, 255, 0, 66, 5, 55, 10, 1, 45, 3, 255, 255 , 
-- 255, 255, 255, 5, 55, 40, 62, 0, 57, 62, 0, 2, 0, 82, 72, 77, 0, 52, 65, 63, 0, 7, 6, 71, 0, 82, 61, 0, 67, 1, 255, 255 , 
-- 255, 255, 255, 255, 7, 70, 13, 27, 47, 4, 64, 95, 86, 68, 68, 67, 13, 65, 59, 76, 75, 84, 12, 2, 60, 63, 75, 66, 3, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 0, 67, 0, 0, 255, 94, 249, 93, 89, 60, 0, 0, 3, 66, 85, 92, 255, 90, 255, 2, 56, 52, 0, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 0, 27, 0, 255, 255, 81, 255, 84, 65, 52, 0, 0, 0, 70, 77, 89, 248, 98, 255, 255, 4, 44, 1, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 2, 241, 0, 255, 255, 81, 92, 81, 63, 75, 5, 0, 2, 63, 62, 75, 81, 91, 255, 255, 17, 61, 12, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 0, 253, 0, 255, 4, 11, 54, 59, 69, 6, 66, 54, 54, 14, 55, 64, 62, 11, 255, 255, 1, 69, 0, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 4, 234, 57, 70, 0, 63, 58, 70, 47, 69, 66, 54, 57, 56, 75, 62, 33, 78, 2, 51, 74, 58, 11, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 0, 57, 250, 254, 11, 59, 67, 65, 73, 41, 57, 74, 52, 68, 79, 76, 0, 6, 55, 76, 67, 1, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 22, 0, 59, 68, 74, 59, 52, 0, 63, 70, 66, 79, 39, 61, 70, 3, 46, 71, 0, 13, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 1, 1, 54, 55, 0, 25, 70, 58, 48, 54, 80, 53, 62, 1, 10, 17, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 58, 79, 3, 2, 54, 62, 63, 73, 60, 61, 65, 6, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 60, 9, 0, 1, 72, 53, 56, 75, 61, 62, 53, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 67, 50, 10, 0, 255, 45, 71, 68, 56, 66, 61, 63, 52, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 69, 15, 0, 0, 255, 4, 55, 68, 57, 60, 87, 67, 63, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 67, 0, 66, 1, 2, 246, 8, 55, 70, 57, 73, 53, 75, 10, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 56, 5, 74, 72, 5, 3, 0, 6, 51, 54, 59, 60, 56, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 47, 9, 59, 57, 56, 46, 6, 3, 0, 62, 75, 70, 62, 58, 81, 16, 255, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 57, 255, 67, 58, 66, 54, 70, 57, 69, 57, 61, 69, 78, 55, 75, 52, 79, 7, 255, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 59, 70, 60, 0, 25, 0, 4, 56, 72, 58, 0, 0, 0, 19, 42, 60, 47, 20, 255, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 255, 72, 73, 62, 1, 29, 255, 255, 255, 255, 0, 0, 29, 255, 255, 255, 255, 13, 72, 73, 63, 0, 255, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 255, 10, 0, 50, 4, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 70, 1, 0, 255, 255, 255, 255 , 
-- 255, 255, 255, 255, 28, 63, 61, 23, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 15, 61, 52, 0, 255, 255, 255 , 
-- 255, 255, 255, 4, 71, 77, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 1, 4, 0, 54, 255, 255 , 
-- 255, 16, 0, 64, 0, 66, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 3, 2, 6, 0, 0, 92 , 
-- 0, 52, 48, 0, 66, 0, 11, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 2, 6, 5, 0, 1 , 
-- 2, 5, 10, 69, 2, 60, 2, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 0, 8, 16, 0 , 
-- 255, 255, 255, 15, 0, 0, 3, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 4, 7, 9, 161, 255 , 
-- 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 );  

type rom_type is array(0 to 1023) of unsigned(3 downto 0);
constant ROM: rom_type := (
"1111","1111","1111","1111","1111","1111","1111","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","0000","0100","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0011","0000","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","0001","1111","0000","0011","0000","0000","1111","1111","1111","1111","1111","0000","0000","0000","1111","1111","1111","1111","1111","0000","0000","0011","0000","1111","0000","1111","1111","1111",
"1111","1111","1111","0000","0011","0001","0100","0011","0000","0011","0000","1111","0000","0000","0000","0010","0100","0100","0000","0000","0000","1111","0000","0100","0000","0011","0000","0000","0010","0000","1111","1111",
"1111","1111","1111","0000","0011","0010","0011","0000","0011","0011","0000","0000","0000","0101","0100","0100","0000","0011","0100","0011","0000","0000","0000","0100","0000","0101","0011","0000","0100","0000","1111","1111",
"1111","1111","1111","1111","0000","0100","0000","0001","0010","0000","0100","0101","0101","0100","0100","0100","0000","0100","0011","0100","0100","0101","0000","0000","0011","0011","0100","0100","0000","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","0100","0000","0000","1111","0101","1111","0101","0101","0011","0000","0000","0000","0100","0101","0101","1111","0101","1111","0000","0011","0011","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","0001","0000","1111","1111","0101","1111","0101","0100","0011","0000","0000","0000","0100","0100","0101","1111","0110","1111","1111","0000","0010","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","1111","0000","1111","1111","0101","0101","0101","0011","0100","0000","0000","0000","0011","0011","0100","0101","0101","1111","1111","0001","0011","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","1111","0000","1111","0000","0000","0011","0011","0100","0000","0100","0011","0011","0000","0011","0100","0011","0000","1111","1111","0000","0100","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","1110","0011","0100","0000","0011","0011","0100","0010","0100","0100","0011","0011","0011","0100","0011","0010","0100","0000","0011","0100","0011","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","0011","1111","1111","0000","0011","0100","0100","0100","0010","0011","0100","0011","0100","0100","0100","0000","0000","0011","0100","0100","0000","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","0001","0000","0011","0100","0100","0011","0011","0000","0011","0100","0100","0100","0010","0011","0100","0000","0010","0100","0000","0000","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0011","0011","0000","0001","0100","0011","0011","0011","0101","0011","0011","0000","0000","0001","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0011","0100","0000","0000","0011","0011","0011","0100","0011","0011","0100","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0011","0000","0000","0000","0100","0011","0011","0100","0011","0011","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","0100","0011","0000","0000","1111","0010","0100","0100","0011","0100","0011","0011","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","0100","0000","0000","0000","1111","0000","0011","0100","0011","0011","0101","0100","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","0100","0000","0100","0000","0000","1111","0000","0011","0100","0011","0100","0011","0100","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","0011","0000","0100","0100","0000","0000","0000","0000","0011","0011","0011","0011","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","0010","0000","0011","0011","0011","0010","0000","0000","0000","0011","0100","0100","0011","0011","0101","0001","1111","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","0011","1111","0100","0011","0100","0011","0100","0011","0100","0011","0011","0100","0100","0011","0100","0011","0100","0000","1111","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","0011","0100","0011","0000","0001","0000","0000","0011","0100","0011","0000","0000","0000","0001","0010","0011","0010","0001","1111","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","1111","0100","0100","0011","0000","0001","1111","1111","1111","1111","0000","0000","0001","1111","1111","1111","1111","0000","0100","0100","0011","0000","1111","1111","1111","1111","1111",
"1111","1111","1111","1111","1111","0000","0000","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0100","0000","0000","1111","1111","1111","1111",
"1111","1111","1111","1111","0001","0011","0011","0001","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0011","0011","0000","1111","1111","1111",
"1111","1111","1111","0000","0100","0100","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0000","0011","1111","1111",
"1111","0001","0000","0100","0000","0100","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0000","0000","0000","0101",
"0000","0011","0011","0000","0100","0000","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0000","0000","0000","0000",
"0000","0000","0000","0100","0000","0011","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0000","0000","0001","0000",
"1111","1111","1111","0000","0000","0000","0000","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","0000","0000","0000","0000","1010","1111",
"1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111","1111"); 


begin

  process(clk)
	begin
	  if rising_edge(clk) then
		data <= ROM(to_integer(addr));
	  end if;
  end process;

end rtl;