library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity frog_controller is
  port(
clk50   : in std_logic;
clk25   : in std_logic;    
address: in unsigned (1 downto 0);
frog_alive : in unsigned (1 downto 0);
direction: in integer;
vertical: in integer;
horizontal: in integer;
frogflag : out std_logic;
pixel_R: out unsigned(3 downto 0);
pixel_G: out unsigned(3 downto 0);
pixel_B: out unsigned(3 downto 0)
  );
end frog_controller;

architecture rtl of frog_controller is

component frog_static_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_static_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_static_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_jump_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_jump_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_jump_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead1_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead1_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead1_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead2_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead2_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

component frog_dead2_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned(3 downto 0)
  );
end component;

signal index : unsigned ( 9 downto 0 );
signal index2 : unsigned ( 9 downto 0 );
signal frog_static_R,frog_static_G,frog_static_B : unsigned(3 downto 0);
signal frog_jump_R,frog_jump_G,frog_jump_B : unsigned(3 downto 0);
signal frog_dead1_R,frog_dead1_G,frog_dead1_B : unsigned(3 downto 0);
signal frog_dead2_R,frog_dead2_G,frog_dead2_B : unsigned(3 downto 0);

begin

frog_staticR: frog_static_R_ROM port map (clk50,index,frog_static_R);
frog_staticG: frog_static_G_ROM port map (clk50,index,frog_static_G);
frog_staticB: frog_static_B_ROM port map (clk50,index,frog_static_B);
frog_jumpR: frog_jump_R_ROM port map (clk50,index,frog_jump_R);
frog_jumpG: frog_jump_G_ROM port map (clk50,index,frog_jump_G);
frog_jumpB: frog_jump_B_ROM port map (clk50,index,frog_jump_B);
frog_dead1R: frog_dead1_R_ROM port map (clk50,index2,frog_dead1_R);
frog_dead1G: frog_dead1_G_ROM port map (clk50,index2,frog_dead1_G);
frog_dead1B: frog_dead1_B_ROM port map (clk50,index2,frog_dead1_B);
frog_dead2R: frog_dead2_R_ROM port map (clk50,index2,frog_dead2_R);
frog_dead2G: frog_dead2_G_ROM port map (clk50,index2,frog_dead2_G);
frog_dead2B: frog_dead2_B_ROM port map (clk50,index2,frog_dead2_B);

process(clk50)
begin
if rising_edge(clk50) then 
case direction is
  when 2 =>   --left
	index <= to_unsigned ((horizontal * 32 + 31 - vertical), 10);
  when 3 =>   --down
	index <= to_unsigned (((31-vertical) * 32 + 31 - horizontal), 10);
  when 4 =>   --right
	index <= to_unsigned ((vertical + (31 - horizontal) * 32), 10);
  when others =>  --up
	index <= to_unsigned ((vertical * 32 + horizontal), 10);
end case;
    index2 <= to_unsigned ((vertical * 32 + horizontal), 10);
end if;
end process;

process(clk25)
begin
if rising_edge(clk25) then
if address = "00" then 
frogflag <= '0';
else 
case frog_alive is 
  when "01" =>
	if frog_dead1_R = "0000" and frog_dead1_G = "0000" and frog_dead1_B = "0000" then  --transparent the background
	  frogflag <= '0';
	else   --display character
	  frogflag <= '1'; 
	  pixel_R <= frog_dead1_R;
	  pixel_G <= frog_dead1_G;
	  pixel_B <= frog_dead1_B;
    end if;
  when "10" =>
	if frog_dead2_R = "0000" and frog_dead2_G = "0000" and frog_dead2_B = "0000" then  --transparent the background
	  frogflag <= '0';
	else   --display character
	  frogflag <= '1'; 
	  pixel_R <= frog_dead2_R;
	  pixel_G <= frog_dead2_G;
	  pixel_B <= frog_dead2_B;
    end if;
  when others =>
case address is 
  when "00" =>
	frogflag <= '0';
  when "01" =>   --when frog does not move
    if frog_static_R = "0000" and frog_static_G = "0000" and frog_static_B = "1111" then  --transparent the background
	  frogflag <= '0';
	else   --display character
	  frogflag <= '1'; 
	  pixel_R <= frog_static_R;
	  pixel_G <= frog_static_G;
	  pixel_B <= frog_static_B;
    end if;
  when "11" =>   --when frog jumps
    if frog_jump_R = "0000" and frog_jump_G = "0000" and frog_jump_B = "1111" then  --transparent the background
	  frogflag <= '0';
	else   --display character
	  frogflag <= '1';
	  pixel_R <= frog_jump_R;
	  pixel_G <= frog_jump_G;
	  pixel_B <= frog_jump_B;
    end if;
  when others =>
	frogflag <= '0';
end case;

end case;
end if;
end if;
end process;

end rtl;


