library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
--use ieee.std_logic_arith.all;


entity de2_audio is
  
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(1 downto 0);
	writedata  : in  unsigned(15 downto 0);
	readdata   : out unsigned(15 downto 0);

    AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic      --    Audio CODEC Bit-Stream Clock
    );
  
end de2_audio;

architecture rtl of de2_audio is
--component de2_wm8731_audio is
--port (
--    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
--    reset_n : in std_logic;
--    test_mode : in std_logic;       --    Audio CODEC controller test mode
--    audio_request : out std_logic;  --    Audio controller request new data
--    data : in unsigned(15 downto 0);
--  
--    -- Audio interface signals
--    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
--    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
--    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
--    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
--    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
--  );
--end  component;

  component de2_audio_select is
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
	audio_ini  : in  std_logic;
	audio_sel  : in  unsigned (1 downto 0);
	audio_vol  : in  unsigned (1 downto 0);
	
    -- Audio interface signals
    AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic      --    Audio CODEC Bit-Stream Clock
  );
  end component;

  type ram_type is array(3 downto 0) of unsigned(15 downto 0);
  signal RAM : ram_type := (X"0000", X"0000", X"0000", X"0000");
  signal ram_address   : unsigned(1 downto 0);
  signal audio_request : std_logic;
  signal audio_sel     : unsigned(15 downto 0) := X"0000";
  signal audio_ini     : unsigned(15 downto 0) := X"0000";
  signal audio_tmp	   : unsigned(15 downto 0) := X"0000";
  signal audio_vol     : unsigned(15 downto 0) := X"0000";

begin
  ram_address <= address(1 downto 0);

  process (clk)
  begin
	if rising_edge(clk) then
	  if reset_n = '0' then
		audio_sel <= (others => '0');
		audio_ini <= (others => '0');
      else
        if chipselect = '1' then
			if read = '1' then
				readdata <= RAM(to_integer(ram_address));
				audio_sel  <= RAM(to_integer("01"));
				audio_ini  <= RAM(to_integer("11"));
				audio_vol  <= RAM(to_integer("10"));
			elsif write = '1' then
				RAM(to_integer(ram_address)) <= writedata;
			end if;
		end if;
	  end if;
	end if;
  end process;

--V1: de2_wm8731_audio
--port map(
--    clk => clk,       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
--    reset_n => reset_n,
--    test_mode => '1',       --    Audio CODEC controller test mode
--    audio_request => audio_request,  --    Audio controller request new data
--    data => "0000000000000000",
--  
--    -- Audio interface signals
--    AUD_ADCLRCK  => AUD_ADCLRCK,   --    Audio CODEC ADC LR Clock
--    AUD_ADCDAT   => AUD_ADCDAT,   --    Audio CODEC ADC Data
--    AUD_DACLRCK  => AUD_DACLRCK,   --    Audio CODEC DAC LR Clock
--    AUD_DACDAT   => AUD_DACDAT,   --    Audio CODEC DAC Data
--    AUD_BCLK     => AUD_BCLK  --    Audio CODEC Bit-Stream Clock
--  );
  
  V1: de2_audio_select port map (
	clk        => clk,
	reset_n    => reset_n,
	audio_ini  => audio_ini (0),
	audio_sel  => audio_sel (1 downto 0),
	audio_vol  => audio_vol (1 downto 0),

	AUD_ADCLRCK  => AUD_ADCLRCK,
	AUD_ADCDAT   => AUD_ADCDAT,
	AUD_DACLRCK  => AUD_DACLRCK,
	AUD_DACDAT   => AUD_DACDAT,
	AUD_BCLK     => AUD_BCLK
  );


end rtl;
