library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity background_controller is
  port(
clk50   : in std_logic;
clk25   : in std_logic;    
address: in unsigned (4 downto 0);
vertical: in integer;
horizontal: in integer;
backflag : out std_logic;
pixel_R: out unsigned (3 downto 0);
pixel_G: out unsigned (3 downto 0);
pixel_B: out unsigned (3 downto 0)
  );
end  background_controller;

architecture rtl of background_controller is


component startzone_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component startzone_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component startzone_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roaddown_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roaddown_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roaddown_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadmain_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadmain_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadmain_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadup_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadup_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component roadup_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component middlezone_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component middlezone_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component middlezone_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component water_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component water_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component water_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeleft_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeleft_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeleft_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homemiddle_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homemiddle_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homemiddle_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeright_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeright_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homeright_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homefrog_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homefrog_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component homefrog_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component lawn_R_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component lawn_G_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

component lawn_B_ROM
  port(
clk   : in std_logic;    
addr  : in unsigned (9 downto 0);
data  : out unsigned (3 downto 0)
  );
end component;

signal index : unsigned ( 9 downto 0 );

signal startzone_R,startzone_G,startzone_B : unsigned (3 downto 0);
signal startzone_R_R,startzone_R_G,startzone_R_B : unsigned (3 downto 0);
signal roaddown_R,roaddown_G,roaddown_B : unsigned (3 downto 0);
signal roaddown_R_R,roaddown_R_G,roaddown_R_B : unsigned (3 downto 0);
signal roadmain_R,roadmain_G,roadmain_B : unsigned (3 downto 0);
signal roadmain_R_R,roadmain_R_G,roadmain_R_B : unsigned (3 downto 0);
signal roadup_R,roadup_G,roadup_B : unsigned (3 downto 0);
signal roadup_R_R,roadup_R_G,roadup_R_B : unsigned (3 downto 0);
signal middle_R,middle_G,middle_B : unsigned (3 downto 0);
signal middle_R_R,middle_R_G,middle_R_B : unsigned (3 downto 0);
signal water_R,water_G,water_B : unsigned (3 downto 0);
signal homeleft_R,homeleft_G,homeleft_B : unsigned (3 downto 0);
signal homemiddle_R,homemiddle_G,homemiddle_B : unsigned (3 downto 0);
signal homeright_R,homeright_G,homeright_B : unsigned (3 downto 0);
signal homefrog_R,homefrog_G,homefrog_B : unsigned (3 downto 0);
signal lawn_R,lawn_G,lawn_B : unsigned (3 downto 0);

begin

start_R: startzone_R_ROM port map (clk50,index,startzone_R);
start_G: startzone_G_ROM port map (clk50,index,startzone_G);
start_B: startzone_B_ROM port map (clk50,index,startzone_B);


roadd_R: roaddown_R_ROM port map (clk50,index,roaddown_R);
roadd_G: roaddown_G_ROM port map (clk50,index,roaddown_G);
roadd_B: roaddown_B_ROM port map (clk50,index,roaddown_B);


roadm_R: roadmain_R_ROM port map (clk50,index,roadmain_R);
roadm_G: roadmain_G_ROM port map (clk50,index,roadmain_G);
roadm_B: roadmain_B_ROM port map (clk50,index,roadmain_B);


roadu_R: roadup_R_ROM port map (clk50,index,roadup_R);
roadu_G: roadup_G_ROM port map (clk50,index,roadup_G);
roadu_B: roadup_B_ROM port map (clk50,index,roadup_B);
 

mid_R: middlezone_R_ROM port map (clk50,index,middle_R);
mid_G: middlezone_G_ROM port map (clk50,index,middle_G);
mid_B: middlezone_B_ROM port map (clk50,index,middle_B);

wat_R: water_R_ROM port map (clk50,index,water_R);
wat_G: water_G_ROM port map (clk50,index,water_G);
wat_B: water_B_ROM port map (clk50,index,water_B);

hleft_R: homeleft_R_ROM port map (clk50,index,homeleft_R);
hleft_G: homeleft_G_ROM port map (clk50,index,homeleft_G);
hleft_B: homeleft_B_ROM port map (clk50,index,homeleft_B);

hmiddle_R: homemiddle_R_ROM port map (clk50,index,homemiddle_R);
hmiddle_G: homemiddle_G_ROM port map (clk50,index,homemiddle_G);
hmiddle_B: homemiddle_B_ROM port map (clk50,index,homemiddle_B);

hright_R: homeright_R_ROM port map (clk50,index,homeright_R);
hright_G: homeright_G_ROM port map (clk50,index,homeright_G);
hright_B: homeright_B_ROM port map (clk50,index,homeright_B);

hfrog_R: homefrog_R_ROM port map (clk50,index,homefrog_R);
hfrog_G: homefrog_G_ROM port map (clk50,index,homefrog_G);
hfrog_B: homefrog_B_ROM port map (clk50,index,homefrog_B);

hlawn_R: lawn_R_ROM port map (clk50,index,lawn_R);
hlawn_G: lawn_G_ROM port map (clk50,index,lawn_G);
hlawn_B: lawn_B_ROM port map (clk50,index,lawn_B);


process(clk50)
begin
if rising_edge(clk50) then
if (address and "00001") = "00000" then
index <= to_unsigned ((vertical*32 + horizontal), 10);
else
index <= to_unsigned ((vertical*32 + (31 - horizontal)), 10);
end if;
end if;
end process;

process(clk25)
begin
if rising_edge(clk25) then 


case address is
when "00000" =>
  backflag <= '1';
  pixel_R <= startzone_R ;
  pixel_G <= startzone_G ;
  pixel_B <= startzone_B ;

when "00001" =>  
  backflag <='1';
  pixel_R <= startzone_R ;
  pixel_G <= startzone_G ;
  pixel_B <= startzone_B ;

when "00010" =>  
  backflag <='1';
  pixel_R <= roaddown_R ;
  pixel_G <= roaddown_G ;
  pixel_B <= roaddown_B ;


when "00011" =>  
  backflag <='1';
  pixel_R <= roaddown_R ;
  pixel_G <= roaddown_G ;
  pixel_B <= roaddown_B ;


when "00100" =>  
  backflag <='1';
  pixel_R <= roadmain_R ;
  pixel_G <= roadmain_G ;
  pixel_B <= roadmain_B ;


when "00101" =>  --5
  backflag <='1';
  pixel_R <= roadmain_R ;
  pixel_G <= roadmain_G ;
  pixel_B <= roadmain_B ;


when "00110" =>  --6
  backflag <='1';
  pixel_R <= roadup_R ;
  pixel_G <= roadup_G ;
  pixel_B <= roadup_B ;


when "00111" =>  --7
  backflag <='1';
  pixel_R <= roadup_R ;
  pixel_G <= roadup_G ;
  pixel_B <= roadup_B ;


when "01000" =>  --8
  backflag <='1';
  pixel_R <= middle_R ;
  pixel_G <= middle_G ;
  pixel_B <= middle_B ;

when "01001" =>  --9
  backflag <='1';
  pixel_R <= middle_R ;
  pixel_G <= middle_G ;
  pixel_B <= middle_B ;

when "01010" =>  --10
  backflag <='1';
  pixel_R <= water_R ;
  pixel_G <= water_G ;
  pixel_B <= water_B ;

when "01011" =>  --11
  backflag <='1';
  pixel_R <= water_R ;
  pixel_G <= water_G ;
  pixel_B <= water_B ;

when "01100" =>  --12
  backflag <='1';
  pixel_R <= homeleft_R ;
  pixel_G <= homeleft_G ;
  pixel_B <= homeleft_B ;

when "01110" =>  --14
  backflag <='1';
  pixel_R <= homemiddle_R ;
  pixel_G <= homemiddle_G ;
  pixel_B <= homemiddle_B ;

when "10000" =>  --16
  backflag <='1';
  pixel_R <= homeright_R ;
  pixel_G <= homeright_G ;
  pixel_B <= homeright_B ;

when "10010" =>  --18
  backflag <='1';
  pixel_R <= homefrog_R ;
  pixel_G <= homefrog_G ;
  pixel_B <= homefrog_B ;

when "10100" =>  --20
  backflag <='1';
  pixel_R <= lawn_R ;
  pixel_G <= lawn_G ;
  pixel_B <= lawn_B ;

when "10101" =>  --21
  backflag <='1';
  pixel_R <= lawn_R ;
  pixel_G <= lawn_G ;
  pixel_B <= lawn_B ;

when others =>
  backflag <= '0';
 end case;
end if;
end process;


end rtl;




 
