library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_signed.all;
 
entity ps_controller is
  port(
clk   : in std_logic;    
address: in unsigned (5 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector (4 downto 0);
pixel_G: out std_logic_vector (4 downto 0);
pixel_B: out std_logic_vector (4 downto 0)
  );

end ps_controller;

architecture rtl of ps_controller is

----------------NUMBER COMPONENT-------------0-9
component ps_0_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_1_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_2_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_3_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_4_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_5_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_6_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_7_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_8_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_9_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

--------------------LETTER COMPONENT-------------------A-X
component ps_A_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_B_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_C_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_D_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_E_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_F_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_G_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_H_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_I_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_J_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_K_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_L_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_M_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_N_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_O_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_P_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_Q_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_R_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_S_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_T_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_U_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_V_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_W_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;

component ps_X_rom
  port(
       clk   : in std_logic; 
       addr  : in integer;
       data  : out std_logic_vector (4 downto 0)
      );
end component;
----------------------------------------------------------------


signal ver : integer;
signal hor : integer;

signal ps_0_R,ps_0_G,ps_0_B : std_logic_vector(4 downto 0); 
signal ps_1_R,ps_1_G,ps_1_B : std_logic_vector(4 downto 0); 
signal ps_2_R,ps_2_G,ps_2_B : std_logic_vector(4 downto 0); 
signal ps_3_R,ps_3_G,ps_3_B : std_logic_vector(4 downto 0); 
signal ps_4_R,ps_4_G,ps_4_B : std_logic_vector(4 downto 0); 
signal ps_5_R,ps_5_G,ps_5_B : std_logic_vector(4 downto 0); 
signal ps_6_R,ps_6_G,ps_6_B : std_logic_vector(4 downto 0); 
signal ps_7_R,ps_7_G,ps_7_B : std_logic_vector(4 downto 0); 
signal ps_8_R,ps_8_G,ps_8_B : std_logic_vector(4 downto 0); 
signal ps_9_R,ps_9_G,ps_9_B : std_logic_vector(4 downto 0); 


signal ps_A_R,ps_A_G,ps_A_B : std_logic_vector(4 downto 0); 
signal ps_B_R,ps_B_G,ps_B_B : std_logic_vector(4 downto 0); 
signal ps_C_R,ps_C_G,ps_C_B : std_logic_vector(4 downto 0); 
signal ps_D_R,ps_D_G,ps_D_B : std_logic_vector(4 downto 0); 
signal ps_E_R,ps_E_G,ps_E_B : std_logic_vector(4 downto 0); 
signal ps_F_R,ps_F_G,ps_F_B : std_logic_vector(4 downto 0); 
signal ps_G_R,ps_G_G,ps_G_B : std_logic_vector(4 downto 0); 
signal ps_H_R,ps_H_G,ps_H_B : std_logic_vector(4 downto 0); 
signal ps_I_R,ps_I_G,ps_I_B : std_logic_vector(4 downto 0); 
signal ps_J_R,ps_J_G,ps_J_B : std_logic_vector(4 downto 0); 
signal ps_K_R,ps_K_G,ps_K_B : std_logic_vector(4 downto 0); 
signal ps_L_R,ps_L_G,ps_L_B : std_logic_vector(4 downto 0); 
signal ps_M_R,ps_M_G,ps_M_B : std_logic_vector(4 downto 0); 
signal ps_N_R,ps_N_G,ps_N_B : std_logic_vector(4 downto 0); 
signal ps_O_R,ps_O_G,ps_O_B : std_logic_vector(4 downto 0); 
signal ps_P_R,ps_P_G,ps_P_B : std_logic_vector(4 downto 0); 
signal ps_Q_R,ps_Q_G,ps_Q_B : std_logic_vector(4 downto 0); 
signal ps_R_R,ps_R_G,ps_R_B : std_logic_vector(4 downto 0); 
signal ps_S_R,ps_S_G,ps_S_B : std_logic_vector(4 downto 0); 
signal ps_T_R,ps_T_G,ps_T_B : std_logic_vector(4 downto 0); 
signal ps_U_R,ps_U_G,ps_U_B : std_logic_vector(4 downto 0); 
signal ps_V_R,ps_V_G,ps_V_B : std_logic_vector(4 downto 0); 
signal ps_W_R,ps_W_G,ps_W_B : std_logic_vector(4 downto 0); 
signal ps_X_R,ps_X_G,ps_X_B : std_logic_vector(4 downto 0); 



begin

ps_0_red: ps_0_rom port map (clk,ver*8+hor,ps_0_R);
ps_0_green: ps_0_rom port map (clk,ver*8+hor,ps_0_G);
ps_0_blue: ps_0_rom port map (clk,ver*8+hor,ps_0_B);

ps_1_red: ps_1_rom port map (clk,ver*8+hor,ps_1_R);
ps_1_green: ps_1_rom port map (clk,ver*8+hor,ps_1_G);
ps_1_blue: ps_1_rom port map (clk,ver*8+hor,ps_1_B);

ps_2_red: ps_2_rom port map (clk,ver*8+hor,ps_2_R);
ps_2_green: ps_2_rom port map (clk,ver*8+hor,ps_2_G);
ps_2_blue: ps_2_rom port map (clk,ver*8+hor,ps_2_B);

ps_3_red: ps_3_rom port map (clk,ver*8+hor,ps_3_R);
ps_3_green: ps_3_rom port map (clk,ver*8+hor,ps_3_G);
ps_3_blue: ps_3_rom port map (clk,ver*8+hor,ps_3_B);

ps_4_red: ps_4_rom port map (clk,ver*8+hor,ps_4_R);
ps_4_green: ps_4_rom port map (clk,ver*8+hor,ps_4_G);
ps_4_blue: ps_4_rom port map (clk,ver*8+hor,ps_4_B);

ps_5_red: ps_5_rom port map (clk,ver*8+hor,ps_5_R);
ps_5_green: ps_5_rom port map (clk,ver*8+hor,ps_5_G);
ps_5_blue: ps_5_rom port map (clk,ver*8+hor,ps_5_B);

ps_6_red: ps_6_rom port map (clk,ver*8+hor,ps_6_R);
ps_6_green: ps_6_rom port map (clk,ver*8+hor,ps_6_G);
ps_6_blue: ps_6_rom port map (clk,ver*8+hor,ps_6_B);

ps_7_red: ps_7_rom port map (clk,ver*8+hor,ps_7_R);
ps_7_green: ps_7_rom port map (clk,ver*8+hor,ps_7_G);
ps_7_blue: ps_7_rom port map (clk,ver*8+hor,ps_7_B);

ps_8_red: ps_8_rom port map (clk,ver*8+hor,ps_8_R);
ps_8_green: ps_8_rom port map (clk,ver*8+hor,ps_8_G);
ps_8_blue: ps_8_rom port map (clk,ver*8+hor,ps_8_B);

ps_9_red: ps_9_rom port map (clk,ver*8+hor,ps_9_R);
ps_9_green: ps_9_rom port map (clk,ver*8+hor,ps_9_G);
ps_9_blue: ps_9_rom port map (clk,ver*8+hor,ps_9_B);

ps_A_red: ps_A_rom port map (clk,ver*8+hor,ps_A_R);
ps_A_green: ps_A_rom port map (clk,ver*8+hor,ps_A_G);
ps_A_blue: ps_A_rom port map (clk,ver*8+hor,ps_A_B);

ps_B_red: ps_B_rom port map (clk,ver*8+hor,ps_B_R);
ps_B_green: ps_B_rom port map (clk,ver*8+hor,ps_B_G);
ps_B_blue: ps_B_rom port map (clk,ver*8+hor,ps_B_B);

ps_C_red: ps_C_rom port map (clk,ver*8+hor,ps_C_R);
ps_C_green: ps_C_rom port map (clk,ver*8+hor,ps_C_G);
ps_C_blue: ps_C_rom port map (clk,ver*8+hor,ps_C_B);

ps_D_red: ps_D_rom port map (clk,ver*8+hor,ps_D_R);
ps_D_green: ps_D_rom port map (clk,ver*8+hor,ps_D_G);
ps_D_blue: ps_D_rom port map (clk,ver*8+hor,ps_D_B);

ps_E_red: ps_E_rom port map (clk,ver*8+hor,ps_E_R);
ps_E_green: ps_E_rom port map (clk,ver*8+hor,ps_E_G);
ps_E_blue: ps_E_rom port map (clk,ver*8+hor,ps_E_B);

ps_F_red: ps_F_rom port map (clk,ver*8+hor,ps_F_R);
ps_F_green: ps_F_rom port map (clk,ver*8+hor,ps_F_G);
ps_F_blue: ps_F_rom port map (clk,ver*8+hor,ps_F_B);

ps_G_red: ps_G_rom port map (clk,ver*8+hor,ps_G_R);
ps_G_green: ps_G_rom port map (clk,ver*8+hor,ps_G_G);
ps_G_blue: ps_G_rom port map (clk,ver*8+hor,ps_G_B);

ps_H_red: ps_H_rom port map (clk,ver*8+hor,ps_H_R);
ps_H_green: ps_H_rom port map (clk,ver*8+hor,ps_H_G);
ps_H_blue: ps_H_rom port map (clk,ver*8+hor,ps_H_B);

ps_I_red: ps_I_rom port map (clk,ver*8+hor,ps_I_R);
ps_I_green: ps_I_rom port map (clk,ver*8+hor,ps_I_G);
ps_I_blue: ps_I_rom port map (clk,ver*8+hor,ps_I_B);

ps_J_red: ps_J_rom port map (clk,ver*8+hor,ps_J_R);
ps_J_green: ps_J_rom port map (clk,ver*8+hor,ps_J_G);
ps_J_blue: ps_J_rom port map (clk,ver*8+hor,ps_J_B);

ps_K_red: ps_K_rom port map (clk,ver*8+hor,ps_K_R);
ps_K_green: ps_K_rom port map (clk,ver*8+hor,ps_K_G);
ps_K_blue: ps_K_rom port map (clk,ver*8+hor,ps_K_B);

ps_L_red: ps_L_rom port map (clk,ver*8+hor,ps_L_R);
ps_L_green: ps_L_rom port map (clk,ver*8+hor,ps_L_G);
ps_L_blue: ps_L_rom port map (clk,ver*8+hor,ps_L_B);

ps_M_red: ps_M_rom port map (clk,ver*8+hor,ps_M_R);
ps_M_green: ps_M_rom port map (clk,ver*8+hor,ps_M_G);
ps_M_blue: ps_M_rom port map (clk,ver*8+hor,ps_M_B);

ps_N_red: ps_N_rom port map (clk,ver*8+hor,ps_N_R);
ps_N_green: ps_N_rom port map (clk,ver*8+hor,ps_N_G);
ps_N_blue: ps_N_rom port map (clk,ver*8+hor,ps_N_B);

ps_O_red: ps_O_rom port map (clk,ver*8+hor,ps_O_R);
ps_O_green: ps_O_rom port map (clk,ver*8+hor,ps_O_G);
ps_O_blue: ps_O_rom port map (clk,ver*8+hor,ps_O_B);

ps_P_red: ps_P_rom port map (clk,ver*8+hor,ps_P_R);
ps_P_green: ps_P_rom port map (clk,ver*8+hor,ps_P_G);
ps_P_blue: ps_P_rom port map (clk,ver*8+hor,ps_P_B);

ps_Q_red: ps_Q_rom port map (clk,ver*8+hor,ps_Q_R);
ps_Q_green: ps_Q_rom port map (clk,ver*8+hor,ps_Q_G);
ps_Q_blue: ps_Q_rom port map (clk,ver*8+hor,ps_Q_B);

ps_R_red: ps_R_rom port map (clk,ver*8+hor,ps_R_R);
ps_R_green: ps_R_rom port map (clk,ver*8+hor,ps_R_G);
ps_R_blue: ps_R_rom port map (clk,ver*8+hor,ps_R_B);

ps_S_red: ps_S_rom port map (clk,ver*8+hor,ps_S_R);
ps_S_green: ps_S_rom port map (clk,ver*8+hor,ps_S_G);
ps_S_blue: ps_S_rom port map (clk,ver*8+hor,ps_S_B);

ps_T_red: ps_T_rom port map (clk,ver*8+hor,ps_T_R);
ps_T_green: ps_T_rom port map (clk,ver*8+hor,ps_T_G);
ps_T_blue: ps_T_rom port map (clk,ver*8+hor,ps_T_B);

ps_U_red: ps_U_rom port map (clk,ver*8+hor,ps_U_R);
ps_U_green: ps_U_rom port map (clk,ver*8+hor,ps_U_G);
ps_U_blue: ps_U_rom port map (clk,ver*8+hor,ps_U_B);

ps_V_red: ps_V_rom port map (clk,ver*8+hor,ps_V_R);
ps_V_green: ps_V_rom port map (clk,ver*8+hor,ps_V_G);
ps_V_blue: ps_V_rom port map (clk,ver*8+hor,ps_V_B);

ps_W_red: ps_W_rom port map (clk,ver*8+hor,ps_W_R);
ps_W_green: ps_W_rom port map (clk,ver*8+hor,ps_W_G);
ps_W_blue: ps_W_rom port map (clk,ver*8+hor,ps_W_B);

ps_X_red: ps_X_rom port map (clk,ver*8+hor,ps_X_R);
ps_X_green: ps_X_rom port map (clk,ver*8+hor,ps_X_G);
ps_X_blue: ps_X_rom port map (clk,ver*8+hor,ps_X_B);





process(clk)
begin
if rising_edge(clk) then 
   hor  <= horizontal;
   ver  <= vertical;
end if;
end process;


process(clk)

begin
if rising_edge(clk) then 
case address is 

  when "000000" =>
							
    if ps_0_R /= "00000" then
    pixel_R <= ps_0_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_0_G /= "00000" then     
    pixel_G <= ps_0_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_0_B /= "00000" then
    pixel_B <= ps_0_B;
    else
    pixel_B <= "00000";
    end if;

  when "000001" =>
						
    if ps_1_R /= "00000" then
    pixel_R <= ps_1_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_1_G /= "00000" then     
    pixel_G <= ps_1_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_1_B /= "00000" then
    pixel_B <= ps_1_B;
    else
    pixel_B <= "00000";
    end if;

  when "000010" =>
						
    if ps_2_R /= "00000" then
    pixel_R <= ps_2_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_2_G /= "00000" then     
    pixel_G <= ps_2_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_2_B /= "00000" then
    pixel_B <= ps_2_B;
    else
    pixel_B <= "00000";
    end if;

  when "000011" =>
						
    if ps_3_R /= "00000" then
    pixel_R <= ps_3_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_3_G /= "00000" then     
    pixel_G <= ps_3_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_3_B /= "00000" then
    pixel_B <= ps_3_B;
    else
    pixel_B <= "00000";
    end if;

  when "000100" =>
						
    if ps_4_R /= "00000" then
    pixel_R <= ps_4_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_4_G /= "00000" then     
    pixel_G <= ps_4_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_4_B /= "00000" then
    pixel_B <= ps_4_R;
    else
    pixel_B <= "00000";
    end if;

  when "000101" =>
						
    if ps_5_R /= "00000" then
    pixel_R <= ps_5_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_5_G /= "00000" then     
    pixel_G <= ps_5_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_5_B /= "00000" then
    pixel_B <= ps_5_B;
    else
    pixel_B <= "00000";
    end if;

  when "000110" =>
						
    if ps_6_R /= "00000" then
    pixel_R <= ps_6_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_6_G /= "00000" then     
    pixel_G <= ps_6_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_6_B /= "00000" then
    pixel_B <= ps_6_B;
    else
    pixel_B <= "00000";
    end if;

  when "000111" =>
						
    if ps_7_R /= "00000" then
    pixel_R <= ps_7_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_7_G /= "00000" then     
    pixel_G <= ps_7_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_7_B /= "00000" then
    pixel_B <= ps_7_B;
    else
    pixel_B <= "00000";
    end if;

  when "001000" =>
							
    if ps_8_R /= "00000" then
    pixel_R <= ps_8_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_8_G /= "00000" then     
    pixel_G <= ps_8_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_8_B /= "00000" then
    pixel_B <= ps_8_B;
    else
    pixel_B <= "00000";
    end if;

  when "001001" =>
						
    if ps_9_R /= "00000" then
    pixel_R <= ps_9_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_9_G /= "00000" then     
    pixel_G <= ps_9_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_9_B /= "00000" then
    pixel_B <= ps_9_B;
    else
    pixel_B <= "00000";
    end if;

  when "001010" =>
						
    if ps_A_R /= "00000" then
    pixel_R <= ps_A_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_A_G /= "00000" then     
    pixel_G <= ps_A_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_A_B /= "00000" then
    pixel_B <= ps_A_B;
    else
    pixel_B <= "00000";
    end if;

  when "001011" =>
						
    if ps_B_R /= "00000" then
    pixel_R <= ps_B_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_B_G /= "00000" then     
    pixel_G <= ps_B_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_B_B /= "00000" then
    pixel_B <= ps_B_B;
    else
    pixel_B <= "00000";
    end if;

  when "001100" =>
						
    if ps_C_R /= "00000" then
    pixel_R <= ps_C_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_C_G /= "00000" then     
    pixel_G <= ps_C_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_C_B /= "00000" then
    pixel_B <= ps_C_B;
    else
    pixel_B <= "00000";
    end if;

  when "001101" =>
						
    if ps_D_R /= "00000" then
    pixel_R <= ps_D_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_D_G /= "00000" then     
    pixel_G <= ps_D_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_D_B /= "00000" then
    pixel_B <= ps_D_B;
    else
    pixel_B <= "00000";
    end if;

  when "001110" =>
						
    if ps_E_R /= "00000" then
    pixel_R <= ps_E_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_E_G /= "00000" then     
    pixel_G <= ps_E_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_E_B /= "00000" then
    pixel_B <= ps_E_B;
    else
    pixel_B <= "00000";
    end if;

  when "001111" =>
						
    if ps_F_R /= "00000" then
    pixel_R <= ps_F_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_F_G /= "00000" then     
    pixel_G <= ps_F_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_F_B /= "00000" then
    pixel_B <= ps_F_B;
    else
    pixel_B <= "00000";
    end if;

  when "010000" =>
						
    if ps_G_R /= "00000" then
    pixel_R <= ps_G_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_G_G /= "00000" then     
    pixel_G <= ps_G_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_G_B /= "00000" then
    pixel_B <= ps_G_B;
    else
    pixel_B <= "00000";
    end if;

  when "010001" =>
						
    if ps_H_R /= "00000" then
    pixel_R <= ps_H_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_H_G /= "00000" then     
    pixel_G <= ps_H_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_H_B /= "00000" then
    pixel_B <= ps_H_B;
    else
    pixel_B <= "00000";
    end if;

  when "010010" =>
						
    if ps_I_R /= "00000" then
    pixel_R <= ps_I_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_I_G /= "00000" then     
    pixel_G <= ps_I_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_I_B /= "00000" then
    pixel_B <= ps_I_B;
    else
    pixel_B <= "00000";
    end if;

  when "010011" =>
						
    if ps_J_R /= "00000" then
    pixel_R <= ps_J_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_J_G /= "00000" then     
    pixel_G <= ps_J_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_J_B /= "00000" then
    pixel_B <= ps_J_B;
    else
    pixel_B <= "00000";
    end if;

  when "010100" =>
						
    if ps_K_R /= "00000" then
    pixel_R <= ps_K_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_K_G /= "00000" then     
    pixel_G <= ps_K_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_K_B /= "00000" then
    pixel_B <= ps_K_B;
    else
    pixel_B <= "00000";
    end if;

  when "010101" =>
						
    if ps_L_R /= "00000" then
    pixel_R <= ps_L_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_L_G /= "00000" then     
    pixel_G <= ps_L_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_L_B /= "00000" then
    pixel_B <= ps_L_B;
    else
    pixel_B <= "00000";
    end if;

  when "010110" =>
						
    if ps_M_R /= "00000" then
    pixel_R <= ps_M_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_M_G /= "00000" then     
    pixel_G <= ps_M_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_M_B /= "00000" then
    pixel_B <= ps_M_B;
    else
    pixel_B <= "00000";
    end if;

  when "010111" =>
						
    if ps_N_R /= "00000" then
    pixel_R <= ps_N_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_N_G /= "00000" then     
    pixel_G <= ps_N_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_N_B /= "00000" then
    pixel_B <= ps_N_B;
    else
    pixel_B <= "00000";
    end if;

  when "011000" =>
						
    if ps_O_R /= "00000" then
    pixel_R <= ps_O_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_O_G /= "00000" then     
    pixel_G <= ps_O_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_O_B /= "00000" then
    pixel_B <= ps_O_B;
    else
    pixel_B <= "00000";
    end if;

  when "011001" =>
						
    if ps_P_R /= "00000" then
    pixel_R <= ps_P_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_P_G /= "00000" then     
    pixel_G <= ps_P_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_P_B /= "00000" then
    pixel_B <= ps_P_B;
    else
    pixel_B <= "00000";
    end if;

  when "011010" =>
						
    if ps_Q_R /= "00000" then
    pixel_R <= ps_Q_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_Q_G /= "00000" then     
    pixel_G <= ps_Q_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_Q_B /= "00000" then
    pixel_B <= ps_Q_B;
    else
    pixel_B <= "00000";
    end if;

  when "011011" =>
						
    if ps_R_R /= "00000" then
    pixel_R <= ps_R_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_R_G /= "00000" then     
    pixel_G <= ps_R_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_R_B /= "00000" then
    pixel_B <= ps_R_B;
    else
    pixel_B <= "00000";
    end if;

  when "011100" =>
						
    if ps_S_R /= "00000" then
    pixel_R <= ps_S_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_S_G /= "00000" then     
    pixel_G <= ps_S_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_S_B /= "00000" then
    pixel_B <= ps_S_B;
    else
    pixel_B <= "00000";
    end if;

  when "011101" =>
						
    if ps_T_R /= "00000" then
    pixel_R <= ps_T_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_T_G /= "00000" then     
    pixel_G <= ps_T_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_T_B /= "00000" then
    pixel_B <= ps_T_B;
    else
    pixel_B <= "00000";
    end if;

  when "011110" =>
    						
    if ps_U_R /= "00000" then
    pixel_R <= ps_U_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_U_G /= "00000" then     
    pixel_G <= ps_U_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_U_B /= "00000" then
    pixel_B <= ps_U_B;
    else
    pixel_B <= "00000";
    end if;

  when "011111" =>
						
    if ps_V_R /= "00000" then
    pixel_R <= ps_V_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_V_G /= "00000" then     
    pixel_G <= ps_V_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_V_B /= "00000" then
    pixel_B <= ps_V_B;
    else
    pixel_B <= "00000";
    end if;

  when "100000" =>
							
    if ps_W_R /= "00000" then
    pixel_R <= ps_W_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_W_G /= "00000" then     
    pixel_G <= ps_W_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_W_B /= "00000" then
    pixel_B <= ps_W_B;
    else
    pixel_B <= "00000";
    end if;

  when "100001" =>
 						
    if ps_X_R /= "00000" then
    pixel_R <= ps_X_R;
    else
    pixel_R <= "00000";
    end if;

    if ps_X_G /= "00000" then     
    pixel_G <= ps_X_G;
    else
    pixel_G <= "00000";
    end if;

    if ps_X_B /= "00000" then
    pixel_B <= ps_X_B;
    else
    pixel_B <= "00000";
    end if;

  
  when others =>
  pixel_R <= "00000";
  pixel_G <= "00000";
  pixel_B <= "00000";

end case;
  
end if;
end process;

end rtl;
