library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_signed.all;
 
entity frog_controller is
  port(
clk   : in std_logic;    
address: in unsigned (5 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector (4 downto 0);
pixel_G: out std_logic_vector (4 downto 0);
pixel_B: out std_logic_vector (4 downto 0)
  );

end frog_controller;

architecture rtl of frog_controller is

-------------------------------------------------------frog_red_big--------------------------------
component frog_red_big_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_red_big_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_red_big_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------frog_red_big_mirror-------------------------
component frog_red_big_mirror_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_red_big_mirror_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_red_big_mirror_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;


-----------------------------------------------------------------frog_blue_big------------------------
component frog_blue_big_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_blue_big_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_blue_big_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
--
-------------------------------------------------------------frog_blue_big_mirror-----------------------------
component frog_blue_big_mirror_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_blue_big_mirror_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component frog_blue_big_mirror_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-----------------------------------------------------------start-------------------------
component map_start_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_start_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_start_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------back-------------------------
component map_back_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_back_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_back_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------next-------------------------
component map_next_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_next_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_next_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------pause-------------------------
component map_pause_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_pause_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_pause_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------bulletup-------------------------
component map_bulletup_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------bulletdown-------------------------
component map_bulletdown_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------bulletleft-------------------------
component map_bulletleft_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------bulletright-------------------------
component map_bulletright_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------explode1-------------------------
component map_explode1_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------explode2-------------------------
component map_explode2_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_lv-------------------------
component map_lv
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_hit-------------------------
component map_hit
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_0-------------------------
component map_0
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_1-------------------------
component map_1
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_2-------------------------
component map_2
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_3-------------------------
component map_3
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_4-------------------------
component map_4
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_5-------------------------
component map_5
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_6-------------------------
component map_6
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_7-------------------------
component map_7
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_8-------------------------
component map_8
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_9-------------------------
component map_9
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_Good_Job-------------------------
component map_Good_Job
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_Snappers-------------------------
component map_Snappers
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
---------------------------------------------------------------map_Try_Again-------------------------
component map_Try_Again
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
--------------------------------------------------------arrow------------------------------
component map_arrow_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_background_r
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_background_g
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component map_background_b
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

signal ver : integer;
signal hor : integer;


signal frog_g_b_R,frog_g_b_G,frog_g_b_B : std_logic_vector(4 downto 0); 
signal frog_g_b_m_R,frog_g_b_m_G,frog_g_b_m_B : std_logic_vector(4 downto 0); 
signal frog_g_s_R,frog_g_s_G,frog_g_s_B : std_logic_vector(4 downto 0); 
signal frog_g_s_m_R,frog_g_s_m_G,frog_g_s_m_B : std_logic_vector(4 downto 0); 

signal frog_r_b_R,frog_r_b_G,frog_r_b_B : std_logic_vector(4 downto 0); 
signal frog_r_b_m_R,frog_r_b_m_G,frog_r_b_m_B : std_logic_vector(4 downto 0); 
signal frog_r_s_R,frog_r_s_G,frog_r_s_B : std_logic_vector(4 downto 0); 
signal frog_r_s_m_R,frog_r_s_m_G,frog_r_s_m_B : std_logic_vector(4 downto 0); 


signal frog_b_b_R,frog_b_b_G,frog_b_b_B : std_logic_vector(4 downto 0); 
signal frog_b_b_m_R,frog_b_b_m_G,frog_b_b_m_B : std_logic_vector(4 downto 0); 
signal frog_b_s_R,frog_b_s_G,frog_b_s_B : std_logic_vector(4 downto 0); 
signal frog_b_s_m_R,frog_b_s_m_G,frog_b_s_m_B : std_logic_vector(4 downto 0); 

signal frog_o_b_R,frog_o_b_G,frog_o_b_B : std_logic_vector(4 downto 0); 
signal frog_o_b_m_R,frog_o_b_m_G,frog_o_b_m_B : std_logic_vector(4 downto 0); 
signal frog_o_s_R,frog_o_s_G,frog_o_s_B : std_logic_vector(4 downto 0); 
signal frog_o_s_m_R,frog_o_s_m_G,frog_o_s_m_B : std_logic_vector(4 downto 0); 

signal start_R,start_G,start_B : std_logic_vector(4 downto 0); 
signal next_R,next_G,next_B : std_logic_vector(4 downto 0); 
signal back_R,back_G,back_B : std_logic_vector(4 downto 0); 
signal pause_R,pause_G,pause_B : std_logic_vector(4 downto 0); 

signal bulletdown_R,bulletdown_G,bulletdown_B : std_logic_vector(4 downto 0); 
signal bulletup_R,bulletup_G,bulletup_B : std_logic_vector(4 downto 0); 
signal bulletleft_R,bulletleft_G,bulletleft_B : std_logic_vector(4 downto 0); 
signal bulletright_R,bulletright_G,bulletright_B : std_logic_vector(4 downto 0); 
signal black_R,black_G,black_B : std_logic_vector(4 downto 0); 
signal explode1_R,explode1_G,explode1_B : std_logic_vector(4 downto 0); 
signal explode2_R,explode2_G,explode2_B : std_logic_vector(4 downto 0); 
------------------------------------------
signal map_lv_R,map_lv_G,map_lv_B : std_logic_vector(4 downto 0); 
signal map_hit_R,map_hit_G,map_hit_B : std_logic_vector(4 downto 0); 
signal map_0_R,map_0_G,map_0_B : std_logic_vector(4 downto 0); 
signal map_1_R,map_1_G,map_1_B : std_logic_vector(4 downto 0); 
signal map_2_R,map_2_G,map_2_B : std_logic_vector(4 downto 0); 
signal map_3_R,map_3_G,map_3_B : std_logic_vector(4 downto 0); 
signal map_4_R,map_4_G,map_4_B : std_logic_vector(4 downto 0); 
signal map_5_R,map_5_G,map_5_B : std_logic_vector(4 downto 0); 
signal map_6_R,map_6_G,map_6_B : std_logic_vector(4 downto 0); 
signal map_7_R,map_7_G,map_7_B : std_logic_vector(4 downto 0); 
signal map_8_R,map_8_G,map_8_B : std_logic_vector(4 downto 0); 
signal map_9_R,map_9_G,map_9_B : std_logic_vector(4 downto 0); 
signal map_Snappers_R,map_Snappers_G,map_Snappers_B : std_logic_vector(4 downto 0); 
signal map_Try_Again_R,map_Try_Again_G,map_Try_Again_B : std_logic_vector(4 downto 0); 
signal map_Good_Job_R,map_Good_Job_G,map_Good_Job_B : std_logic_vector(4 downto 0); 
----------------------------------------
signal arrow_R,arrow_G,arrow_B:std_logic_vector(4 downto 0);   ------------arrow
signal background_R,background_G,background_B : std_logic_vector(4 downto 0); 


begin
----------------------------------------green -----------------------------------
frog_green_big_red: frog_red_big_g port map (clk,ver*36+hor,frog_g_b_R);
frog_green_big_green: frog_red_big_r port map (clk,ver*36+hor,frog_g_b_G);
frog_green_big_blue: frog_red_big_g port map (clk,ver*36+hor,frog_g_b_B);

frog_green_big_mirror_red: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_g_b_m_R);
frog_green_big_mirror_green: frog_red_big_mirror_r port map (clk,ver*36+hor,frog_g_b_m_G);
frog_green_big_mirror_blue: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_g_b_m_B);

frog_green_small_red: frog_blue_big_r port map (clk,ver*36+hor,frog_g_s_R);
frog_green_small_green: frog_blue_big_b port map (clk,ver*36+hor,frog_g_s_G);
frog_green_small_blue: frog_blue_big_r port map (clk,ver*36+hor,frog_g_s_B);

frog_green_small_mirror_red: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_g_s_m_R);
frog_green_small_mirror_green: frog_blue_big_mirror_b port map (clk,ver*36+hor,frog_g_s_m_G);
frog_green_small_mirror_blue: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_g_s_m_B);

----------------------------------------red -----------------------------------
frog_red_big_red: frog_red_big_r port map (clk,ver*36+hor,frog_r_b_R);
frog_red_big_green: frog_red_big_g port map (clk,ver*36+hor,frog_r_b_G);
frog_red_big_blue: frog_red_big_g port map (clk,ver*36+hor,frog_r_b_B);

frog_red_big_mirror_red: frog_red_big_mirror_r port map (clk,ver*36+hor,frog_r_b_m_R);
frog_red_big_mirror_green: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_r_b_m_G);
frog_red_big_mirror_blue: frog_red_big_mirror_b port map (clk,ver*36+hor,frog_r_b_m_B);

frog_red_small_red: frog_blue_big_b port map (clk,ver*36+hor,frog_r_s_R);
frog_red_small_green: frog_blue_big_r port map (clk,ver*36+hor,frog_r_s_G);
frog_red_small_blue: frog_blue_big_r port map (clk,ver*36+hor,frog_r_s_B);

frog_red_small_mirror_red: frog_blue_big_mirror_b port map (clk,ver*36+hor,frog_r_s_m_R);
frog_red_small_mirror_green: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_r_s_m_G);
frog_red_small_mirror_blue: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_r_s_m_B);

----------------------------------------blue -----------------------------------
frog_blue_big_red: frog_red_big_g port map (clk,ver*36+hor,frog_b_b_R);
frog_blue_big_green: frog_red_big_g port map (clk,ver*36+hor,frog_b_b_G);
frog_blue_big_blue: frog_red_big_r port map (clk,ver*36+hor,frog_b_b_B);

frog_blue_big_mirror_red: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_b_b_m_R);
frog_blue_big_mirror_green: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_b_b_m_G);
frog_blue_big_mirror_blue: frog_red_big_mirror_r port map (clk,ver*36+hor,frog_b_b_m_B);

frog_blue_small_red: frog_blue_big_r port map (clk,ver*36+hor,frog_b_s_R);
frog_blue_small_green: frog_blue_big_r port map (clk,ver*36+hor,frog_b_s_G);
frog_blue_small_blue: frog_blue_big_b port map (clk,ver*36+hor,frog_b_s_B);

frog_blue_small_mirror_red: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_b_s_m_R);
frog_blue_small_mirror_green: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_b_s_m_G);
frog_blue_small_mirror_blue: frog_blue_big_mirror_b port map (clk,ver*36+hor,frog_b_s_m_B);

----------------------------------------orange -----------------------------------
frog_orange_big_red: frog_red_big_r port map (clk,ver*36+hor,frog_o_b_R);
frog_orange_big_green: frog_red_big_r port map (clk,ver*36+hor,frog_o_b_G);
frog_orange_big_blue: frog_red_big_g port map (clk,ver*36+hor,frog_o_b_B);

frog_orange_big_mirror_red: frog_red_big_mirror_r port map (clk,ver*36+hor,frog_o_b_m_R);
frog_orange_big_mirror_green: frog_red_big_mirror_r port map (clk,ver*36+hor,frog_o_b_m_G);
frog_orange_big_mirror_blue: frog_red_big_mirror_g port map (clk,ver*36+hor,frog_o_b_m_B);

frog_orange_small_red: frog_blue_big_b port map (clk,ver*36+hor,frog_o_s_R);
frog_orange_small_green: frog_blue_big_b port map (clk,ver*36+hor,frog_o_s_G);
frog_orange_small_blue: frog_blue_big_r port map (clk,ver*36+hor,frog_o_s_B);

frog_orange_small_mirror_red: frog_blue_big_mirror_b port map (clk,ver*36+hor,frog_o_s_m_R);
frog_orange_small_mirror_green: frog_blue_big_mirror_b port map (clk,ver*36+hor,frog_o_s_m_G);
frog_orange_small_mirror_blue: frog_blue_big_mirror_r port map (clk,ver*36+hor,frog_o_s_m_B);

------------------------------------bullet -----------------------------------
bulletup_red: map_bulletup_r port map (clk,ver*12+hor,bulletup_R);
bulletup_green: map_bulletup_r port map (clk,ver*12+hor,bulletup_G);
bulletup_blue: map_bulletup_r port map (clk,ver*12+hor,bulletup_B);

bulletdown_red: map_bulletdown_r port map (clk,ver*12+hor,bulletdown_R);
bulletdown_green: map_bulletdown_r port map (clk,ver*12+hor,bulletdown_G);
bulletdown_blue: map_bulletdown_r port map (clk,ver*12+hor,bulletdown_B);

bulletleft_red: map_bulletleft_r port map (clk,ver*12+hor,bulletleft_R);
bulletleft_green: map_bulletleft_r port map (clk,ver*12+hor,bulletleft_G);
bulletleft_blue: map_bulletleft_r port map (clk,ver*12+hor,bulletleft_B);

bulletright_red: map_bulletright_r port map (clk,ver*12+hor,bulletright_R);
bulletright_green: map_bulletright_r port map (clk,ver*12+hor,bulletright_G);
bulletright_blue: map_bulletright_r port map (clk,ver*12+hor,bulletright_B);


---------------------------------------------arrow--------------------------------------
arrow_red: map_arrow_r port map (clk,ver*36+hor,arrow_R);
arrow_green: map_arrow_r port map (clk,ver*36+hor,arrow_G);
arrow_blue: map_arrow_r port map (clk,ver*36+hor,arrow_B);
---------------------------------------------lv--------------------------------------
lv_red: map_lv port map (clk,ver*36+hor,map_lv_R);
lv_green: map_lv port map (clk,ver*36+hor,map_lv_G);
lv_blue: map_lv port map (clk,ver*36+hor,map_lv_B);
---------------------------------------------hit--------------------------------------
hit_red: map_hit port map (clk,ver*36+hor,map_hit_R);
hit_green: map_hit port map (clk,ver*36+hor,map_hit_G);
hit_blue: map_hit port map (clk,ver*36+hor,map_hit_B);
---------------------------------------------0--------------------------------------
map_0_red: map_0 port map (clk,ver*36+hor,map_0_R);
map_0_green: map_0 port map (clk,ver*36+hor,map_0_G);
map_0_blue: map_0 port map (clk,ver*36+hor,map_0_B);
---------------------------------------------1--------------------------------------
map_1_red: map_1 port map (clk,ver*36+hor,map_1_R);
map_1_green: map_1 port map (clk,ver*36+hor,map_1_G);
map_1_blue: map_1 port map (clk,ver*36+hor,map_1_B);
---------------------------------------------2--------------------------------------
map_2_red: map_2 port map (clk,ver*36+hor,map_2_R);
map_2_green: map_2 port map (clk,ver*36+hor,map_2_G);
map_2_blue: map_2 port map (clk,ver*36+hor,map_2_B);
---------------------------------------------3--------------------------------------
map_3_red: map_3 port map (clk,ver*36+hor,map_3_R);
map_3_green: map_3 port map (clk,ver*36+hor,map_3_G);
map_3_blue: map_3 port map (clk,ver*36+hor,map_3_B);
---------------------------------------------4--------------------------------------
map_4_red: map_4 port map (clk,ver*36+hor,map_4_R);
map_4_green: map_4 port map (clk,ver*36+hor,map_4_G);
map_4_blue: map_4 port map (clk,ver*36+hor,map_4_B);
---------------------------------------------5--------------------------------------
map_5_red: map_5 port map (clk,ver*36+hor,map_5_R);
map_5_green: map_5 port map (clk,ver*36+hor,map_5_G);
map_5_blue: map_5 port map (clk,ver*36+hor,map_5_B);
---------------------------------------------6--------------------------------------
map_6_red: map_6 port map (clk,ver*36+hor,map_6_R);
map_6_green: map_6 port map (clk,ver*36+hor,map_6_G);
map_6_blue: map_6 port map (clk,ver*36+hor,map_6_B);
---------------------------------------------7--------------------------------------
map_7_red: map_7 port map (clk,ver*36+hor,map_7_R);
map_7_green: map_7 port map (clk,ver*36+hor,map_7_G);
map_7_blue: map_7 port map (clk,ver*36+hor,map_7_B);
---------------------------------------------8--------------------------------------
map_8_red: map_8 port map (clk,ver*36+hor,map_8_R);
map_8_green: map_8 port map (clk,ver*36+hor,map_8_G);
map_8_blue: map_8 port map (clk,ver*36+hor,map_8_B);
---------------------------------------------9--------------------------------------
map_9_red: map_9 port map (clk,ver*36+hor,map_9_R);
map_9_green: map_9 port map (clk,ver*36+hor,map_9_G);
map_9_blue: map_9 port map (clk,ver*36+hor,map_9_B);
---------------------------------------------Snappers--------------------------------------
map_Snappers_red: map_Snappers port map (clk,ver*330+hor,map_Snappers_R);
map_Snappers_green: map_Snappers port map (clk,ver*330+hor,map_Snappers_G);
map_Snappers_blue: map_Snappers port map (clk,ver*330+hor,map_Snappers_B);
---------------------------------------------Good_Job--------------------------------------
map_Good_Job_red: map_Good_Job port map (clk,ver*330+hor,map_Good_Job_R);
map_Good_Job_green: map_Good_Job port map (clk,ver*330+hor,map_Good_Job_G);
map_Good_Job_blue: map_Good_Job port map (clk,ver*330+hor,map_Good_Job_B);
--------------------------------------------Try_Again--------------------------------------
map_Try_Again_red: map_Try_Again port map (clk,ver*330+hor,map_Try_Again_R);
map_Try_Again_green: map_Try_Again port map (clk,ver*330+hor,map_Try_Again_G);
map_Try_Again_blue: map_Try_Again port map (clk,ver*330+hor,map_Try_Again_B);
----------------------------------------explode-----------------------------------
explode1_red: map_explode1_r port map (clk,ver*36+hor,explode1_R);
explode1_green: map_explode1_r port map (clk,ver*36+hor,explode1_G);
explode1_blue: map_explode1_r port map (clk,ver*36+hor,explode1_B);

explode2_red: map_explode2_r port map (clk,ver*36+hor,explode2_R);
explode2_green: map_explode2_r port map (clk,ver*36+hor,explode2_G);
explode2_blue: map_explode2_r port map (clk,ver*36+hor,explode2_B);

--black_red: map_black_r port map (clk,ver*36+hor,black_R);
--black_green: map_black_r port map (clk,ver*36+hor,black_G);
--black_blue: map_black_r port map (clk,ver*36+hor,black_B);
------------------------------------buttom -----------------------------------
start_red: map_start_r port map (clk,ver*36+hor,start_R);
start_green: map_start_g port map (clk,ver*36+hor,start_G);
start_blue: map_start_b port map (clk,ver*36+hor,start_B);

pause_red: map_pause_r port map (clk,ver*36+hor,pause_R);
pause_green: map_pause_g port map (clk,ver*36+hor,pause_G);
pause_blue: map_pause_b port map (clk,ver*36+hor,pause_B);

next_red: map_next_r port map (clk,ver*36+hor,next_R);
next_green: map_next_g port map (clk,ver*36+hor,next_G);
next_blue: map_next_b port map (clk,ver*36+hor,next_B);

back_red: map_back_r port map (clk,ver*36+hor,back_R);
back_green: map_back_g port map (clk,ver*36+hor,back_G);
back_blue: map_back_b port map (clk,ver*36+hor,back_B);
-------------------------------------------------------------
background_red: map_background_r port map (clk,ver*36+hor,background_R);
background_green: map_background_g port map (clk,ver*36+hor,background_G);
background_blue: map_background_b port map (clk,ver*36+hor,background_B);



process(clk)
begin
if rising_edge(clk) then 
   hor <= horizontal;
   ver <= vertical;
end if;
end process;

process(clk)

begin
if rising_edge(clk) then 
case address is 
----------------------------------------green---------------------------------------
  when "001011" =>								--gb
    if frog_g_b_R /= "00000" then
    pixel_R <= frog_g_b_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_g_b_G /= "00000" then     
    pixel_G <= frog_g_b_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_g_b_B /= "00000" then
    pixel_B <= frog_g_b_B;
    else
    pixel_B <= "00000";
    end if;

  when "001100" =>   						    -- gbm
    if frog_g_b_m_R /= "00000" then
    pixel_R <= frog_g_b_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_g_b_m_G /= "00000" then
    pixel_G <= frog_g_b_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_g_b_m_B /= "00000" then
    pixel_B <= frog_g_b_m_B;
    else
    pixel_B <= "00000";
    end if;
 
 when "001001" =>                               -- gs
     if frog_g_s_R /= "00000" then
    pixel_R <= frog_g_s_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_g_s_G /= "00000" then
    pixel_G <= frog_g_s_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_g_s_B /= "00000" then

    pixel_B <= frog_g_s_B;
    else
    pixel_B <= "00000";
    end if;  

 when "001010" =>                               -- gsm
     if frog_g_s_m_R /= "00000" then
    pixel_R <= frog_g_s_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_g_s_m_G /= "00000" then
    pixel_G <= frog_g_s_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_g_s_m_B /= "00000" then
    pixel_B <= frog_g_s_m_B;
    else
    pixel_B <= "00000";
    end if;  
-------------------------------------------------------------red----------------------------
 when "001111" =>								--rb
    if frog_r_b_R /= "00000" then
    pixel_R <= frog_r_b_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_r_b_R /= "00000" then     
    pixel_G <= frog_r_b_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_r_b_B /= "00000" then
    pixel_B <= frog_r_b_B;
    else
    pixel_B <= "00000";
    end if;

  when "010000" =>   						    -- rbm
    if frog_r_b_m_R /= "00000" then
    pixel_R <= frog_r_b_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_r_b_m_G /= "00000" then
    pixel_G <= frog_r_b_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_r_b_m_B /= "00000" then
    pixel_B <= frog_r_b_m_B;
    else
    pixel_B <= "00000";
    end if;
 
 when "001101" =>                               -- rs
     if frog_r_s_R /= "00000" then
    pixel_R <= frog_r_s_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_r_s_G /= "00000" then
    pixel_G <= frog_r_s_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_r_s_B /= "00000" then
    pixel_B <= frog_r_s_B;
    else
    pixel_B <= "00000";
    end if;  

 when "001110" =>                               -- rsm
     if frog_r_s_m_R /= "00000" then
    pixel_R <= frog_r_s_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_r_s_m_G /= "00000" then
    pixel_G <= frog_r_s_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_r_s_m_B /= "00000" then
    pixel_B <= frog_r_s_m_B;
    else
    pixel_B <= "00000";
    end if; 

-------------------------------------------------------------blue----------------------------
 when "000011" =>								--bb
    if frog_b_b_R /= "00000" then
    pixel_R <= frog_b_b_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_b_b_R /= "00000" then     
    pixel_G <= frog_b_b_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_b_b_B /= "00000" then
    pixel_B <= frog_b_b_B;
    else
    pixel_B <= "00000";
    end if;

  when "000100" =>   						    -- bbm
    if frog_b_b_m_R /= "00000" then
    pixel_R <= frog_b_b_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_b_b_m_G /= "00000" then
    pixel_G <= frog_b_b_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_b_b_m_B /= "00000" then
    pixel_B <= frog_b_b_m_B;
    else
    pixel_B <= "00000";
    end if;
 
 when "000001" =>                               -- bs
     if frog_b_s_R /= "00000" then
    pixel_R <= frog_b_s_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_b_s_G /= "00000" then
    pixel_G <= frog_b_s_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_b_s_B /= "00000" then
    pixel_B <= frog_b_s_B;
    else
    pixel_B <= "00000";
    end if;  

 when "000010" =>                               -- bsm
     if frog_b_s_m_R /= "00000" then
    pixel_R <= frog_b_s_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_b_s_m_G /= "00000" then
    pixel_G <= frog_b_s_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_b_s_m_B /= "00000" then
    pixel_B <= frog_b_s_m_B;
    else
    pixel_B <= "00000";
    end if; 

-------------------------------------------------------------orange----------------------------
 when "000111" =>								--ob
    if frog_o_b_R /= "00000" then
    pixel_R <= frog_o_b_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_o_b_R /= "00000" then     
    pixel_G <= frog_o_b_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_o_b_B /= "00000" then
    pixel_B <= frog_o_b_B;
    else
    pixel_B <= "00000";
    end if;

  when "001000" =>   						    -- obm
    if frog_o_b_m_R /= "00000" then
    pixel_R <= frog_o_b_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_o_b_m_G /= "00000" then
    pixel_G <= frog_o_b_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_o_b_m_B /= "00000" then
    pixel_B <= frog_o_b_m_B;
    else
    pixel_B <= "00000";
    end if;
 
 when "000101" =>                               -- os
     if frog_o_s_R /= "00000" then
    pixel_R <= frog_o_s_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_o_s_G /= "00000" then
    pixel_G <= frog_o_s_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_o_s_B /= "00000" then
    pixel_B <= frog_o_s_B;
    else
    pixel_B <= "00000";
    end if;  

 when "000110" =>                               -- osm
     if frog_o_s_m_R /= "00000" then
    pixel_R <= frog_o_s_m_R;
    else
    pixel_R <= "00000";
    end if;

    if frog_o_s_m_G /= "00000" then
    pixel_G <= frog_o_s_m_G;
    else
    pixel_G <= "00000";
    end if;

    if frog_o_s_m_B /= "00000" then
    pixel_B <= frog_o_s_m_B;
    else
    pixel_B <= "00000";
    end if; 
-----------------------------------------------------------bullet----------------------------
 when "010001" =>								--up
    if bulletup_R /= "00000" then
    pixel_R <= bulletup_R;
    else
    pixel_R <= "00000";
    end if;

    if bulletup_G /= "00000" then     
    pixel_G <= bulletup_G;
    else
    pixel_G <= "00000";
    end if;

    if bulletup_B /= "00000" then
    pixel_B <= bulletup_B;
    else
    pixel_B <= "00000";
    end if;

  when "010010" =>   						    -- down
    if bulletdown_R /= "00000" then
    pixel_R <= bulletdown_R;
    else
    pixel_R <= "00000";
    end if;

    if bulletdown_G /= "00000" then
    pixel_G <= bulletdown_G;
    else
    pixel_G <= "00000";
    end if;

    if bulletdown_B /= "00000" then
    pixel_B <= bulletdown_B;
    else
    pixel_B <= "00000";
    end if;
 
 when "010011" =>                               -- left
     if bulletleft_R /= "00000" then
    pixel_R <= bulletleft_R;
    else
    pixel_R <= "00000";
    end if;

    if bulletleft_G /= "00000" then
    pixel_G <= bulletleft_G;
    else
    pixel_G <= "00000";
    end if;

    if bulletleft_B /= "00000" then
    pixel_B <= bulletleft_B;
    else
    pixel_B <= "00000";
    end if;  

 when "010100" =>                               -- right
     if bulletright_R /= "00000" then
    pixel_R <= bulletright_R;
    else
    pixel_R <= "00000";
    end if;

    if bulletright_G /= "00000" then
    pixel_G <= bulletright_G;
    else
    pixel_G <= "00000";
    end if;

    if bulletright_B /= "00000" then
    pixel_B <= bulletright_B;
    else
    pixel_B <= "00000";
    end if; 
-------------------------------------------------------------explode----------------------------
 when "010101" =>								
    if explode1_R /= "00000" then
    pixel_R <= explode1_R;
    else
    pixel_R <= "00000";
    end if;

    if explode1_G /= "00000" then     
    pixel_G <= explode1_G;
    else
    pixel_G <= "00000";
    end if;

    if explode1_B /= "00000" then
    pixel_B <= explode1_B;
    else
    pixel_B <= "00000";
    end if;

  when "010110" =>   						    
    if explode2_R /= "00000" then
    pixel_R <= explode2_R;
    else
    pixel_R <= "00000";
    end if;

    if explode2_G /= "00000" then
    pixel_G <= explode2_G;
    else
    pixel_G <= "00000";
    end if;

    if explode2_B /= "00000" then
    pixel_B <= explode2_B;
    else
    pixel_B <= "00000";
    end if;
 
-- when "010110" =>                           
--     if black_R /= "00000" then
--    pixel_R <= black_R;
--    else
--    pixel_R <= "00000";
--    end if;
--
--    if black_G /= "00000" then
--    pixel_G <= black_G;
--    else
--    pixel_G <= "00000";
--    end if;
--
--    if black_B /= "00000" then
--    pixel_B <= black_B;
--    else
--    pixel_B <= "00000";
--    end if;  
-------------------------------------------------button-----------------------
when "011000" =>								
    if start_R /= "00000" then
    pixel_R <= start_R;
    else
    pixel_R <= "00000";
    end if;

    if start_G /= "00000" then     
    pixel_G <= start_G;
    else
    pixel_G <= "00000";
    end if;

    if start_B /= "00000" then
    pixel_B <= start_B;
    else
    pixel_B <= "00000";
    end if;
when "011001" =>								
    if pause_R /= "00000" then
    pixel_R <= pause_R;
    else
    pixel_R <= "00000";
    end if;

    if pause_G /= "00000" then     
    pixel_G <= pause_G;
    else
    pixel_G <= "00000";
    end if;

    if pause_B /= "00000" then
    pixel_B <= pause_B;
    else
    pixel_B <= "00000";
    end if;
when "011010" =>								
    if next_R /= "00000" then
    pixel_R <= next_R;
    else
    pixel_R <= "00000";
    end if;

    if next_G /= "00000" then     
    pixel_G <= next_G;
    else
    pixel_G <= "00000";
    end if;

    if next_B /= "00000" then
    pixel_B <= next_B;
    else
    pixel_B <= "00000";
    end if;
when "011011" =>								
    if back_R /= "00000" then
    pixel_R <= back_R;
    else
    pixel_R <= "00000";
    end if;

    if back_G /= "00000" then     
    pixel_G <= back_G;
    else
    pixel_G <= "00000";
    end if;

    if back_B /= "00000" then
    pixel_B <= back_B;
    else
    pixel_B <= "00000";
    end if;

-------------------------------------------------------------------------------
 when "011100" =>								--arrow
    if arrow_R /= "00000" then
    pixel_R <= arrow_R;
    else
    pixel_R <= "00000";
    end if;

    if arrow_G /= "00000" then     
    pixel_G <= arrow_G;
    else
    pixel_G <= "00000";
    end if;

    if arrow_B /= "00000" then
    pixel_B <= arrow_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "011101" =>								--lv
    if map_lv_R /= "00000" then
    pixel_R <= map_lv_R;
    else
    pixel_R <= "00000";
    end if;

    if map_lv_G /= "00000" then     
    pixel_G <= map_lv_G;
    else
    pixel_G <= "00000";
    end if;

    if map_lv_B /= "00000" then
    pixel_B <= map_lv_B;
    else
    pixel_B <= "00000";
    end if;

-------------------------------------------------------------------------------
 when "011110" =>								--hit
    if map_hit_R /= "00000" then
    pixel_R <= map_hit_R;
    else
    pixel_R <= "00000";
    end if;

    if map_hit_G /= "00000" then     
    pixel_G <= map_hit_G;
    else
    pixel_G <= "00000";
    end if;

    if map_hit_B /= "00000" then
    pixel_B <= map_hit_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "011111" =>								--0
    if map_0_R /= "00000" then
    pixel_R <= map_0_R;
    else
    pixel_R <= "00000";
    end if;

    if map_0_G /= "00000" then     
    pixel_G <= map_0_G;
    else
    pixel_G <= "00000";
    end if;

    if map_0_B /= "00000" then
    pixel_B <= map_0_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100000" =>								--1
    if map_1_R /= "00000" then
    pixel_R <= map_1_R;
    else
    pixel_R <= "00000";
    end if;

    if map_1_G /= "00000" then     
    pixel_G <= map_1_G;
    else
    pixel_G <= "00000";
    end if;

    if map_1_B /= "00000" then
    pixel_B <= map_1_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100001" =>								--2
    if map_2_R /= "00000" then
    pixel_R <= map_2_R;
    else
    pixel_R <= "00000";
    end if;

    if map_2_G /= "00000" then     
    pixel_G <= map_2_G;
    else
    pixel_G <= "00000";
    end if;

    if map_2_B /= "00000" then
    pixel_B <= map_2_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100010" =>								--3
    if map_3_R /= "00000" then
    pixel_R <= map_3_R;
    else
    pixel_R <= "00000";
    end if;

    if map_3_G /= "00000" then     
    pixel_G <= map_3_G;
    else
    pixel_G <= "00000";
    end if;

    if map_3_B /= "00000" then
    pixel_B <= map_3_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100011" =>								--4
    if map_4_R /= "00000" then
    pixel_R <= map_4_R;
    else
    pixel_R <= "00000";
    end if;

    if map_4_G /= "00000" then     
    pixel_G <= map_4_G;
    else
    pixel_G <= "00000";
    end if;

    if map_4_B /= "00000" then
    pixel_B <= map_4_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100100" =>								--5
    if map_5_R /= "00000" then
    pixel_R <= map_5_R;
    else
    pixel_R <= "00000";
    end if;

    if map_5_G /= "00000" then     
    pixel_G <= map_5_G;
    else
    pixel_G <= "00000";
    end if;

    if map_5_B /= "00000" then
    pixel_B <= map_5_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100101" =>								--6
    if map_6_R /= "00000" then
    pixel_R <= map_6_R;
    else
    pixel_R <= "00000";
    end if;

    if map_6_G /= "00000" then     
    pixel_G <= map_6_G;
    else
    pixel_G <= "00000";
    end if;

    if map_6_B /= "00000" then
    pixel_B <= map_6_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100110" =>								--7
    if map_7_R /= "00000" then
    pixel_R <= map_7_R;
    else
    pixel_R <= "00000";
    end if;

    if map_7_G /= "00000" then     
    pixel_G <= map_7_G;
    else
    pixel_G <= "00000";
    end if;

    if map_7_B /= "00000" then
    pixel_B <= map_7_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "100111" =>								--8
    if map_8_R /= "00000" then
    pixel_R <= map_8_R;
    else
    pixel_R <= "00000";
    end if;

    if map_8_G /= "00000" then     
    pixel_G <= map_8_G;
    else
    pixel_G <= "00000";
    end if;

    if map_8_B /= "00000" then
    pixel_B <= map_8_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "101000" =>								--9
    if map_9_R /= "00000" then
    pixel_R <= map_9_R;
    else
    pixel_R <= "00000";
    end if;

    if map_9_G /= "00000" then     
    pixel_G <= map_9_G;
    else
    pixel_G <= "00000";
    end if;

    if map_9_B /= "00000" then
    pixel_B <= map_9_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "101001" =>								--Snappers
    if map_Snappers_R /= "00000" then
    pixel_R <= map_Snappers_R;
    else
    pixel_R <= "00000";
    end if;

    if map_Snappers_G /= "00000" then     
    pixel_G <= map_Snappers_G;
    else
    pixel_G <= "00000";
    end if;

    if map_Snappers_B /= "00000" then
    pixel_B <= map_Snappers_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "101010" =>								--Try_Again
    if map_Try_Again_R /= "00000" then
    pixel_R <= map_Try_Again_R;
    else
    pixel_R <= "00000";
    end if;

    if map_Try_Again_G /= "00000" then     
    pixel_G <= map_Try_Again_G;
    else
    pixel_G <= "00000";
    end if;

    if map_Try_Again_B /= "00000" then
    pixel_B <= map_Try_Again_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "101011" =>								--Good_Job
    if map_Good_Job_R /= "00000" then
    pixel_R <= map_Good_Job_R;
    else
    pixel_R <= "00000";
    end if;

    if map_Good_Job_G /= "00000" then     
    pixel_G <= map_Good_Job_G;
    else
    pixel_G <= "00000";
    end if;

    if map_Good_Job_B /= "00000" then
    pixel_B <= map_Good_Job_B;
    else
    pixel_B <= "00000";
    end if;
-------------------------------------------------------------------------------
 when "101100" =>								--background
    if background_R /= "00000" then
    pixel_R <= background_R;
    else
    pixel_R <= "00000";
    end if;

    if background_G /= "00000" then     
    pixel_G <= background_G;
    else
    pixel_G <= "00000";
    end if;

    if background_B /= "00000" then
    pixel_B <= background_B;
    else
    pixel_B <= "00000";
    end if;




  when others =>
  pixel_R <= "00000";
  pixel_G <= "00000";
  pixel_B <= "00000";
end case;
  
end if;
end process;

end rtl;
