library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    clk : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
    reset_n : in std_logic;
    test_mode : in std_logic;       --    Audio CODEC controller test mode
    audio_request : out std_logic;  --    Audio controller request new data
    data : in unsigned(15 downto 0);
    sw: in std_logic_vector(17 downto 0);    
    pitch    : in unsigned(7 downto 0);   
    tone     : in unsigned(1 downto 0);

    -- Audio interface signals
    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic  --    Audio CODEC Bit-Stream Clock
  );
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;
    signal flag : std_logic;
    
    signal lrck_divider : unsigned(7 downto 0); 
    signal bclk_divider : unsigned(3 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
    
    signal shift_out : unsigned(15 downto 0);

    signal sin_out1     : unsigned(15 downto 0);
    signal sin_out2     : unsigned(15 downto 0);
    signal sin_out3     : unsigned(15 downto 0);
    signal sin_counter  : unsigned(7 downto 0);  
    signal ff       : std_logic :='0';

	signal divider1 : unsigned(7 downto 0); 
	signal one_step : unsigned(11 downto 0):=X"000"; 
	signal flg      : unsigned(3 downto 0);
	signal clk1     : std_logic :='0';
    signal clk1_div : unsigned(23 downto 0);
begin

  
    -- LRCK divider 
    -- Audio chip main clock is 18.432MHz / Sample rate 48KHz
    -- Divider is 18.432 MHz / 48KHz /2= 192 (X"C0")
    -- Left justify mode set by I2C controller
    

  process (clk)
  begin
    if rising_edge(clk) then
	  if pitch = "00001111" then               --pitch=15
        divider1 <= X"30";--30
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
        lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001110" or flg = X"5" then               --pitch=14 
		divider1 <= X"36"; --36
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
        lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001101" or flg = X"4" then               --pitch=13
		divider1 <= X"3C";--3D-------------------------------
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001100" or flg = X"3" then               --pitch=12
		divider1 <= X"40"; --41
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001011" or flg = X"2" then               --pitch=11
		divider1 <= X"48";--49
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001010" or flg = X"1" then               --pitch=10
		divider1 <= X"52"; --52
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00001001" then               --pitch=9
		divider1 <= X"5C";	--56				--57
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00001000" then               --pitch=8
		divider1 <= X"62";--62
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00000111" or flg = X"0" then               --pitch=7
		divider1 <= X"6E"; --6E
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00000110" then               --pitch=6
		divider1 <= X"7C";  --7B
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
      elsif pitch = "00000101" then
		divider1 <= X"80";  --83
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00000100" then
		divider1 <= X"92"; --93
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00000011" then
		divider1 <= X"A4";   --A5
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00000010" then
		divider1 <= X"B8";  --B0
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
	  elsif pitch = "00000001" then
		divider1 <= X"C4";           --C4              
        if reset_n = '0' then 
          lrck_divider <= (others => '0');
        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
          lrck_divider <= X"00";
        else 
          lrck_divider <= lrck_divider + 1;
        end if;
--      if pitch = "00000001" then  
--		divider1 <= X"30";
--        if reset_n = '0' then 
--          lrck_divider <= (others => '0');
--        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
--          lrck_divider <= X"00";
--        else 
--        lrck_divider <= lrck_divider + 1;
--        end if;
--       elsif pitch = "00000010" then  
--		divider1 <= X"C4";
--        if reset_n = '0' then 
--          lrck_divider <= (others => '0');
--        elsif lrck_divider = divider1  then        -- 25MHz/48/0x4A0=440Hz 
--          lrck_divider <= X"00";
--        else 
--        lrck_divider <= lrck_divider + 1;
--        end if;
	  end if;
    end if; 
  end process;

  process (clk)
  begin
    if rising_edge(clk) then      
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = ((divider1+1) srl 4) or set_lrck = '1'  then  
        bclk_divider <= X"0";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;


  process (clk1)
  begin
    if rising_edge(clk1) then    
      if tone="11" then
--chapter1  
		  if one_step = X"001"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"005"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"006"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"00A"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"00B"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"00F"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"010"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"014"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"016"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"01A"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"01B"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"01D"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"01E"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"023"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"024"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"028"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"029"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"02C"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"02D"  then  
			flg <= X"1";
			one_step <= one_step + 1;     
		  elsif one_step = X"032"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"033"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"037"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"038"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"03C"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"03E"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"042"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"043"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"045"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"046"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"04D"  then  
			flg <= X"F";
			one_step <= one_step + 1;
	--chapter2
		  elsif one_step = X"04E"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"052"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"053"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"057"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"058"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"05C"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"05E"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"062"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"063"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"067"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"068"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"06C"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"06D"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"071"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"072"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"076"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"077"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"07B"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"07C"  then  
			flg <= X"1";
			one_step <= one_step + 1;     
		  elsif one_step = X"080"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"081"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"085"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"086"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"08A"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"08C"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"090"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"091"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"093"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"094"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"09B"  then  
			flg <= X"F";
			one_step <= one_step + 1;
	--chapter3
		  elsif one_step = X"09C"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"0A0"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0A1"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"0A5"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0A6"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0AA"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0AB"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"0AF"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0B0"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"0B4"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0B5"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0B7"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0B8"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"0BA"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0BB"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0BF"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0C0"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"0C4"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0C5"  then  
			flg <= X"2";
			one_step <= one_step + 1;     
		  elsif one_step = X"0C9"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0CA"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0CC"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0CD"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"0CF"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0D0"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0D4"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0D5"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"0D9"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0DA"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"0DE"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0DF"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"0E3"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0E4"  then  
			flg <= X"0";
			one_step <= one_step + 1;
		  elsif one_step = X"0EC"  then  
			flg <= X"F";
			one_step <= one_step + 1;
	--chapter4
		  elsif one_step = X"0ED"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0F1"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0F2"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"0F6"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0F7"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"0FB"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"0FC"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"100"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"102"  then  
			flg <= X"5";
			one_step <= one_step + 1;
		  elsif one_step = X"106"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"107"  then  
			flg <= X"4";
			one_step <= one_step + 1;
		  elsif one_step = X"109"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"10A"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"10E"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"10F"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"113"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"114"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"118"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"119"  then  
			flg <= X"1";
			one_step <= one_step + 1;     
		  elsif one_step = X"11D"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"11E"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"122"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"123"  then  
			flg <= X"3";
			one_step <= one_step + 1;
		  elsif one_step = X"127"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"129"  then  
			flg <= X"2";
			one_step <= one_step + 1;
		  elsif one_step = X"12D"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"12E"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"130"  then  
			flg <= X"F";
			one_step <= one_step + 1;
		  elsif one_step = X"131"  then  
			flg <= X"1";
			one_step <= one_step + 1;
		  elsif one_step = X"139"  then  
			flg <= X"F";
			one_step <= one_step + 1;






	   
		  elsif one_step = X"13F" then
			flg <= X"F";
			one_step <= X"000";
		  else 
			one_step <= one_step + 1;
		  end if;
		else
		  flg <=X"E";
        end if;
    end if;
  end process;

process (clk)
  begin
    if rising_edge(clk) then      
      if clk1_div = X"2FFFFF"  then  
        clk1_div <= X"000000";
        clk1 <= not clk1; 
      else
		clk1_div <= clk1_div + 1;
      end if;
    end if;
  end process;


  
  set_lrck <= '1' when lrck_divider = divider1 else '0';




  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(3 downto 0) = (divider1+1) srl 5 else '0';   --5  (6)
  clr_bclk <= '1' when bclk_divider(3 downto 0) = (divider1+1) srl 4 else '0';   --11  (12)
   
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        bclk <= '0';
      --elsif set_lrck = '1' or clr_bclk = '1' then
	  elsif clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;

  -- Audio data shift output
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif set_lrck = '1' then
--        if sw(0) = '0' then   
--          shift_out <= sin_out1;
--	    elsif sw(1) = '0' then
--		  shift_out <= sin_out2;
--		elsif sw(2) = '0' then
--		  shift_out <= sin_out3;
		if tone = "11"  then                      --background
          shift_out <= sin_out1;
		  --ff <= '1';
		elsif tone = "01"  then                    --scream
          shift_out <= sin_out1;
          --ff <= '0';
	    elsif tone = "00" or flg = X"F" then       --non
          shift_out <= data;            
        else
          shift_out <= data;   --shift_out <= data; 
          
        end if;
      elsif clr_bclk = '1' then 
        shift_out <= shift_out (14 downto 0) & '0';
      end if;
    end if;   
  end process;

    -- Audio outputs
    
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;          
    AUD_DACDAT   <= shift_out(15); 
    AUD_BCLK     <= bclk;          

    -- Self test with Sin wave
    
    process(clk)      
    begin
      if rising_edge(clk) then
        if reset_n = '0' then 
            sin_counter <= (others => '0');
        elsif lrck_lat = '1' and lrck = '0'  then  
          if sin_counter = "10001111" then     --48
            sin_counter <= "00000000";
          else  
            sin_counter <= sin_counter + 1;   
          end if;
        end if;
      end if;
    end process; 



    process(clk)
    begin
      if rising_edge(clk) then
        lrck_lat <= lrck;
      end if;
    end process;

    process (clk) 
    begin
      if rising_edge(clk) then 
        if lrck_lat = '1' and lrck = '0' then
          audio_request <= '1';
        else 
          audio_request <= '0';
        end if;
      end if;
    end process;

  with sin_counter select sin_out1 <=
    X"0000" when "00000000",
    X"10b4" when "00000001",
    X"2120" when "00000010",
    X"30fb" when "00000011",
    X"3fff" when "00000100",
    X"4deb" when "00000101",
    X"5a81" when "00000110",
    X"658b" when "00000111",
    X"6ed9" when "00001000",
    X"7640" when "00001001",
    X"7ba2" when "00001010",
    X"7ee6" when "00001011",
    X"7fff" when "00001100",
    X"7ee6" when "00001101",
    X"7ba2" when "00001110",
    X"7640" when "00001111",
    X"6ed9" when "00010000",
    X"658b" when "00010001",
    X"5a81" when "00010010",
    X"4deb" when "00010011",
    X"3fff" when "00010100",
    X"30fb" when "00010101",
    X"2120" when "00010110",
    X"10b4" when "00010111",
    X"0000" when "00011000",
    X"ef4b" when "00011001",
    X"dee0" when "00011010",
    X"cf05" when "00011011",
    X"c001" when "00011100",
    X"b215" when "00011101",
    X"a57e" when "00011110",
    X"9a74" when "00011111",
    X"9127" when "00100000",
    X"89bf" when "00100001",
    X"845d" when "00100010",
    X"8119" when "00100011",
    X"8000" when "00100100",
    X"8119" when "00100101",
    X"845d" when "00100110",
    X"89bf" when "00100111",
    X"9127" when "00101000",
    X"9a74" when "00101001",
    X"a57e" when "00101010",
    X"b215" when "00101011",
    X"c000" when "00101100",
    X"cf05" when "00101101",
    X"dee0" when "00101110",
    X"ef4b" when "00101111",


    X"0000" when "00110000",
    X"10b4" when "00110001",
    X"2120" when "00110010",
    X"30fb" when "00110011",
    X"3fff" when "00110100",
    X"4deb" when "00110101",
    X"5a81" when "00110110",
    X"658b" when "00110111",
    X"6ed9" when "00111000",
    X"7640" when "00111001",
    X"7ba2" when "00111010",
    X"7ee6" when "00111011",
    X"7fff" when "00111100",
    X"7ee6" when "00111101",
    X"7ba2" when "00111110",
    X"7640" when "00111111",
    X"6ed9" when "01000000",
    X"658b" when "01000001",
    X"5a81" when "01000010",
    X"4deb" when "01000011",
    X"3fff" when "01000100",
    X"30fb" when "01000101",
    X"2120" when "01000110",
    X"10b4" when "01000111",
    X"0000" when "01001000",
    X"ef4b" when "01001001",
    X"dee0" when "01001010",
    X"cf05" when "01001011",
    X"c001" when "01001100",
    X"b215" when "01001101",
    X"a57e" when "01001110",
    X"9a74" when "01001111",
    X"9127" when "01010000",
    X"89bf" when "01010001",
    X"845d" when "01010010",
    X"8119" when "01010011",
    X"8000" when "01010100",
    X"8119" when "01010101",
    X"845d" when "01010110",
    X"89bf" when "01010111",
    X"9127" when "01011000",
    X"9a74" when "01011001",
    X"a57e" when "01011010",
    X"b215" when "01011011",
    X"c000" when "01011100",
    X"cf05" when "01011101",
    X"dee0" when "01011110",
    X"ef4b" when "01011111",


    X"0000" when "01100000",
    X"10b4" when "01100001",
    X"2120" when "01100010",
    X"30fb" when "01100011",
    X"3fff" when "01100100",
    X"4deb" when "01100101",
    X"5a81" when "01100110",
    X"658b" when "01100111",
    X"6ed9" when "01101000",
    X"7640" when "01101001",
    X"7ba2" when "01101010",
    X"7ee6" when "01101011",
    X"7fff" when "01101100",
    X"7ee6" when "01101101",
    X"7ba2" when "01101110",
    X"7640" when "01101111",
    X"6ed9" when "01110000",
    X"658b" when "01110001",
    X"5a81" when "01110010",
    X"4deb" when "01110011",
    X"3fff" when "01110100",
    X"30fb" when "01110101",
    X"2120" when "01110110",
    X"10b4" when "01110111",
    X"0000" when "01111000",
    X"ef4b" when "01111001",
    X"dee0" when "01111010",
    X"cf05" when "01111011",
    X"c001" when "01111100",
    X"b215" when "01111101",
    X"a57e" when "01111110",
    X"9a74" when "01111111",
    X"9127" when "10000000",
    X"89bf" when "10000001",
    X"845d" when "10000010",
    X"8119" when "10000011",
    X"8000" when "10000100",
    X"8119" when "10000101",
    X"845d" when "10000110",
    X"89bf" when "10000111",
    X"9127" when "10001000",
    X"9a74" when "10001001",
    X"a57e" when "10001010",
    X"b215" when "10001011",
    X"c000" when "10001100",
    X"cf05" when "10001101",
    X"dee0" when "10001110",
    X"ef4b" when "10001111",

   
    X"0000" when others;      



end architecture;


