-------------------------------------------------------------------------------
--sdfsdg
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_signed.all;

entity de2_vga_raster is
  
  port (
    reset : in std_logic;
    clk   : in std_logic;                    -- Should be 25.125 MHz
    
    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out unsigned(9 downto 0); -- Blue[9:0]

    chipselect: in std_logic;
    write: in std_logic;
    address: in unsigned(15 downto 0);
    writedata: in unsigned(31 downto 0)

    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is


  component frog_controller
 port(
clk   : in std_logic;    
address: in unsigned (5 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector(4 downto 0);
pixel_G: out std_logic_vector(4 downto 0);
pixel_B: out std_logic_vector(4 downto 0)
  );
end component;

component ps_controller 
  port(
clk   : in std_logic;    
address: in unsigned (5 downto 0);
vertical: in integer;
horizontal: in integer;


pixel_R: out std_logic_vector (4 downto 0);
pixel_G: out std_logic_vector (4 downto 0);
pixel_B: out std_logic_vector (4 downto 0)
      );

  end component;


  -- Video parameters
  signal Center_h:integer:=145;
  signal Center_v:integer:=75;
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;

  signal lable_hstart1 : unsigned(9 downto 0);
  signal lable_vstart1 : unsigned(9 downto 0);
--------------------------------------------------
  signal buf_h_open, buf_v_open, buf_open : std_logic;  -- cursor area 

  signal cursor_h, cursor_v, cursor_open : std_logic;  -- cursor area 
  signal background_h, background_v, background_open, ps_flag1,ps_flag2,ps_flag3,ps_flag4 : std_logic;  -- background area  
  signal lable_v,lable_h, lable_open1, lable_flag1 : std_logic;  -- lable area  
  signal Hscreen : integer;
  signal Vscreen : integer;
  signal clk25:std_logic:='0';--Clock with frequency 25MHz
  signal rectangle_h, rectangle_v, rectangle : std_logic;  -- rectangle area
  type snapper_row is array(0 to 35) of std_logic_vector(7 downto 0);   -- denote tile content
  type snapper_column is array(0 to 35) of snapper_row;

  type bullet_row is array(0 to 11) of std_logic_vector(4 downto 0);   -- denote tile content
  type bullet_column is array(0 to 11) of bullet_row;


  ------------------------------------------------------------------
  type background_row is array(16 downto 0) of std_logic_vector(0 downto 0);   -- denote ice position in map
  type background_column is array(12 downto 0) of background_row;
  
   signal map_level1 : background_column ;

-------------------------------------------------------------------
  -- Signals for the video controller
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;
 
signal v_buf1, h_buf1 : unsigned(9 downto 0);
 
signal v_buf, h_buf : unsigned(9 downto 0);
type sprite_hv_type is array(integer range 0 to 127) of unsigned(9 downto 0);  
signal lable_hstart, lable_vstart,
frog_v,frog_h,
bullet_v, bullet_h : sprite_hv_type;
type hv_type is array(integer range 0 to 127) of unsigned(5 downto 0);  
signal figure_type : hv_type;
  

  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals


  signal map_h, map_v : std_logic;
  signal h_count : integer := 0;
  signal v_count : integer := 0; 




  signal frog_mode: std_logic_vector(63 downto 0) := (others => '0');
--  signal frog_mode: integer;
  signal h_frog_open, v_frog_open, frog_open :std_logic_vector(127 downto 0) := (others => '0');  -- rectangle area
  signal h_lable_open, v_lable_open, lable_open, lable_flag :std_logic_vector(127 downto 0) := (others => '0');  -- rectangle area

  signal h_bullet_open, v_bullet_open, bullet_open : std_logic_vector(127 downto 0) := (others => '0');  -- rectangle area
  
  signal explode_mode: integer :=0;
  
  signal frog_flag : integer := 30000000;
  signal frog_stage : integer := 0;
  signal frog_stage1 : integer := 0;
  signal frog_stage2 : integer := 0;
  signal frog_stage3 : integer := 0;

  signal explode_flag : integer := 0;
  signal explode_stage : integer := 0;
--timer
signal count : integer := 0;
signal timeflag : std_logic := '0';
signal timerange : integer := 500;

signal offset : integer := 0;
signal frog_R : std_logic_vector (4 downto 0);
signal frog_G : std_logic_vector (4 downto 0);
signal frog_B : std_logic_vector (4 downto 0);
signal ps_R : std_logic_vector (4 downto 0);
signal ps_G : std_logic_vector (4 downto 0);
signal ps_B : std_logic_vector (4 downto 0);


-----------------------------------------ps-----------------------------------------
 type timepattern1 is array(0 to 10) of unsigned(5 downto 0);
 type timepattern2 is array(integer range 0 to 3, integer range 0 to 16) of unsigned(5 downto 0);
 type timepattern3 is array(0 to 7) of unsigned(5 downto 0);


signal word_map1 : timepattern1 := (
"011001","011011","001110","011100","011100","111111","001110","010111","011101","001110","011011" );

signal word_map2 : timepattern2 := (                                                   ------------press N for Next B for Back P for Pause S for Start
("011001","011011","001110","011100","011100","111111","010111","111111","001111","011000","011011","111111","010111","001110","100001", "011101","111111"),
("111111","111111","111111","111111","111111","111111","001011","111111","001111","011000","011011","111111","001011","001010","001011","010100","111111"),
("111111","111111","111111","111111","111111","111111","011001","111111","001111","011000","011011","111111","011001","001010","011110","011100","001110"),
("111111","111111","111111","111111","111111","111111","011100","111111","001111","011000","011011","111111","011100","011101","001010","011011","011101")
);

signal word_map3 : timepattern3 := (
 ("011100","010010","010110","001110", "111111", "111111","111111","111111")
);


 type background is array(integer range 0 to 12, integer range 0 to 16) of unsigned(5 downto 0);
 signal groundmap : background := (  
 ("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100"),
("101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100","101100")
);


  signal map1_hcount, map1_vcount: integer :=0;
  signal ps_address: unsigned (5 downto 0);     
  signal ps_vertical,ps_horizontal: integer;
  signal Hnumber : integer;  
  signal Vnumber : integer;
  signal TempHnumber : integer;

-------------------------------------------------------------------------------------

signal test1: integer;
signal test2: integer;


signal image_address : unsigned(5 downto 0);
signal figure_num : integer;
signal figure_num1 : integer;
signal figure_num2 : integer;
signal figure_num3 : integer;
signal figure_num4 : integer;

signal h_cursor, v_cursor: unsigned(9 downto 0);

begin
h_buf <= writedata(9 downto 0);
v_buf <= writedata(19 downto 10);
figure_num <= to_integer(writedata(26 downto 20));

--


tile_rgb: frog_controller port map (clk,image_address,test1,test2,frog_R,frog_G,frog_B);
ps_rgb: ps_controller port map (clk,ps_address,ps_vertical,ps_horizontal,ps_R,ps_G,ps_B);
--
--h_buf <= "0100010100";
--v_buf <= "0001010000";
--figure_num <= 1;



 

-------------------------------------------------------------------------------------------
process (clk)
  begin
    if rising_edge(clk) then
      clk25 <= not clk25;
    end if;
  end process;
--------------------------------------------------------
--Timecount: process (clk) 
--	begin
--		if rising_edge (clk) then
--				count <= 1;
--				timeflag <= '0';
--			elsif count = 2500000 then
--				count <= 1;
--				timeflag <= '1';
--				if timerange > 0 then
--					timerange <= timerange - 1;
--			else
--				timeflag <= '0';
--				count <= count + 1;
--			end if;
--			end if;
--		end if;
--end process Timecount;
--------------------------------------------------------
DataProcess: process (clk)
  begin
    if rising_edge(clk) then

        if chipselect = '1' then 
          if address(4 downto 0)  = "00000" then  --open frog
          if write = '1' then
          frog_h(  figure_num  ) <= h_buf;
          frog_v(  figure_num  ) <= v_buf;
--          figure_type(  figure_num  ) <=  "011000";
          figure_type(  figure_num  ) <= address(10 downto 5);
          end if;
          elsif address(4 downto 0)  = "00001" then --open bullet
          if write = '1' then
          bullet_h(  figure_num  ) <= h_buf;
          bullet_v(  figure_num  ) <= v_buf;
--          figure_type(  figure_num  ) <=  "010000";
          figure_type(  figure_num  ) <= address(10 downto 5);
          end if;
          elsif address(4 downto 0)  = "00010" then  -- open cursor
          if write = '1' then
          h_cursor <= h_buf;
          v_cursor <= v_buf;
          end if;
--          elsif address(4 downto 0)  = "00011" then --open background
--          if write = '1' then
--          background_open <='1';
--          end if;
--          elsif address(4 downto 0)  = "00100" then -- open lable
--          if write = '1' then
------            if address(10 downto 5) = "001010" or address(10 downto 5) = "001010" or address(10 downto 5) = "000010" or address(10 downto 5) = "000110" or address(10 downto 5) = "011011" then
------          frog_h(  figure_num  ) <= h_buf;
------          frog_v(  figure_num  ) <= v_buf;
------          figure_type(  figure_num  ) <= address(10 downto 5);
--          lable_flag1  <='1';
--          lable_hstart1 <= h_buf;
--          lable_vstart1 <= v_buf;
----          image_address <= address(10 downto 5);
------          lable_flag (figure_num) <='1';
------          image_address <= "101001";
--          end if;

--          elsif address(4 downto 0)  = "00101" then --open press enter
--          if write = '1' then
--          ps_flag1 <= '1';
--          end if;
--
          elsif address(4 downto 0)  = "00110" then --buttun explain
          if write = '1' then
          ps_flag2 <= '1';
          end if;

--          elsif address(4 downto 0)  = "00111" then --score
--          if write = '1' then
--          ps_flag3 <= '1';
--          end if;
--          elsif address(4 downto 0)  = "01000" then --time
--          if write = '1' then
--          ps_flag4 <= '1';
--          end if;

----        end if;
        end if;
      end if;
      end if;
  end process DataProcess;

          
----------------------------------------------------------------------------
  -- Horizontal and vertical counters

  HCounter : process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;
frogstaget: process (clk25)
begin
if rising_edge(clk25) then

        if frog_flag <= 30000000 then 
        frog_stage <= 0;
        frog_flag <= frog_flag+1;
        elsif frog_flag <= 35000000 then 
        frog_stage <= 1;
        frog_flag <= frog_flag+1;
        else frog_flag <= 0;
end if; 
        if frog_flag <= 50000000 then 
        frog_stage1 <= 0;
        frog_flag <= frog_flag+1;
        elsif frog_flag <= 58000000 then 
        frog_stage1 <= 1;
        frog_flag <= frog_flag+1;
        else frog_flag <= 0;
end if; 
        if frog_flag <= 70000000 then 
        frog_stage2 <= 0;
        frog_flag <= frog_flag+1;
        elsif frog_flag <= 80000000 then 
        frog_stage2 <= 1;
        frog_flag <= frog_flag+1;
        else frog_flag <= 0;
end if; 
        if frog_flag <= 90000000 then 
        frog_stage3 <= 0;
        frog_flag <= frog_flag+1;
        elsif frog_flag <= 120000000 then 
        frog_stage3 <= 1;
        frog_flag <= frog_flag+1;
        else frog_flag <= 0;
end if; 

        if explode_flag <= 40000000 then 
        explode_stage <= 0;
        explode_flag <= explode_flag+1;
        elsif explode_flag <= 600000000 then 
        explode_stage <= 1;
        explode_flag <= explode_flag+1;
        elsif explode_flag <= 80000000 then 
        explode_stage <= 2;
        explode_flag <= explode_flag+1;


  end if; 

end if;
end process;
---------------------------------------psmap1 gen------------------
--psmap1_gen : process (clk)
--  begin
--    if rising_edge(clk) then     
--      if reset = '1' or Hcount =  HSYNC + HBACK_PORCH +36+ 8*map1_hcount  then  ---------------?weizhi
--         map1_hcount <= map1_hcount + 1;
--         if map1_hcount = 10 then
--            map1_hcount <= 0;
--         end if;
--      end if;
--      if reset = '1' or Vcount = VSYNC + VBACK_PORCH +200+ 16*map1_vcount  then 	  
--         map1_vcount <= map1_vcount + 1;
--         if map1_vcount = 0 then
--         map1_vcount <= 0;
--         end if;
--      end if;   
--    end if;
--  end process psmap1_gen;
--------------------------------------------------------------------

--background generate
--Gen_background : process (clk)
--  begin
--    if rising_edge(clk) then     
--      if reset = '1' or Hcount =  HSYNC + HBACK_PORCH + 36*h_count  then 
--    h_count <= h_count + 1;
--if h_count = 17 then
--   h_count <= 0;
-- end if;
--end if;
--  if  reset = '1' or Vcount = VSYNC + VBACK_PORCH + 36*v_count +6 then 	  
--            v_count <= v_count + 1;
--         if v_count = 13 then
--   v_count <= 0;
-- end if;
--      end if;   
--    end if;
--  end process Gen_background;
----lable gen
LableHGen: process (clk)
begin
if rising_edge(clk) then
--for i in 0 to 60 loop			
if reset = '1' or Hcount = HSYNC + HBACK_PORCH + lable_hstart1 +1 then
lable_h  <= '1';
end if;
if reset = '1' or  Hcount = HSYNC + HBACK_PORCH + lable_hstart1 + 330+1  then
lable_h  <= '0';
end if;
--end loop;
end if;
end process LableHGen;

LableVGen: process (clk)
begin
if rising_edge(clk) then
--for i in 0 to 60 loop
if reset = '1' then
lable_v <= '0';
elsif EndOfLine = '1' then
if Vcount = VSYNC + VBACK_PORCH + lable_vstart1  +6  then
lable_v <= '1';
end if;
if Vcount = VSYNC + VBACK_PORCH + lable_vstart1  + 72 +6 then
lable_v <= '0';
end if;
end if;
--end loop;
end if;
end process LableVGen;  

lable_open1<= lable_v and lable_h ; 
--lable_open(1)<= v_lable_open(1) and h_lable_open(1) ;   
--lable_open(2)<= v_lable_open(2) and h_lable_open(2) ;   
--lable_open(3)<= v_lable_open(3) and h_lable_open(3) ; 


---------------frog generate
RectangleHGen: process (clk)
begin
if rising_edge(clk) then
for i in 0 to 60 loop			
if reset = '1' or Hcount = HSYNC + HBACK_PORCH + frog_h(i)  then
h_frog_open(i)  <= '1';
end if;
if reset = '1' or  Hcount = HSYNC + HBACK_PORCH + frog_h(i) + 36  then
h_frog_open(i)  <= '0';
end if;
end loop;
end if;
end process RectangleHGen;

RectangleVGen: process (clk)
begin
if rising_edge(clk) then
for i in 0 to 60 loop
if reset = '1' then
v_frog_open(i) <= '0';
elsif EndOfLine = '1' then
if Vcount = VSYNC + VBACK_PORCH + frog_v(i)  +6  then
v_frog_open(i) <= '1';
end if;
if Vcount = VSYNC + VBACK_PORCH + frog_v(i)  + 36 +6 then
v_frog_open(i) <= '0';
end if;
end if;
end loop;
end if;
end process RectangleVGen;      
--------------------------------------------------------------
BulletHGen: process (clk)
begin
if rising_edge(clk) then
for i in 0 to 60 loop			
if reset = '1' or Hcount = HSYNC + HBACK_PORCH + bullet_h(i) +1 then
h_bullet_open(i) <= '1';
end if;
if reset = '1' or  Hcount = HSYNC + HBACK_PORCH + bullet_h(i) + 12+1 then
h_bullet_open(i) <= '0';
end if;
end loop;
end if;
end process BulletHGen;

BulletVGen: process (clk)
begin
if rising_edge(clk) then
for i in 0 to 60 loop
if reset = '1' then
v_bullet_open(i) <= '0';
elsif EndOfLine = '1' then
if Vcount = VSYNC + VBACK_PORCH + bullet_v(i)  +6 - 1 then
v_bullet_open(i) <= '1';
end if;
if Vcount = VSYNC + VBACK_PORCH + bullet_v(i) + 12 +6 -1 then
v_bullet_open(i) <= '0';
end if;
end if;
end loop;
end if;
end process BulletVGen; 
---------------------------------------------------------------

frog_open(1)<= v_frog_open(1) and h_frog_open(1) ;   
frog_open(2)<= v_frog_open(2) and h_frog_open(2) ;   
frog_open(3)<= v_frog_open(3) and h_frog_open(3) ;   
frog_open(4)<= v_frog_open(4) and h_frog_open(4) ;   
frog_open(5)<= v_frog_open(5) and h_frog_open(5) ;  
frog_open(6)<= v_frog_open(6) and h_frog_open(6) ;   
frog_open(7)<= v_frog_open(7) and h_frog_open(7) ;   
frog_open(8)<= v_frog_open(8) and h_frog_open(8) ;   
frog_open(9)<= v_frog_open(9) and h_frog_open(9) ;   
frog_open(10)<= v_frog_open(10) and h_frog_open(10) ;  

frog_open(11)<= v_frog_open(11) and h_frog_open(11) ;   
frog_open(12)<= v_frog_open(12) and h_frog_open(12) ;   
frog_open(13)<= v_frog_open(13) and h_frog_open(13) ;   
frog_open(14)<= v_frog_open(14) and h_frog_open(14) ;   
frog_open(15)<= v_frog_open(15) and h_frog_open(15) ;  
frog_open(16)<= v_frog_open(16) and h_frog_open(16) ;   
frog_open(17)<= v_frog_open(17) and h_frog_open(17) ;   
frog_open(18)<= v_frog_open(18) and h_frog_open(18) ;   
frog_open(19)<= v_frog_open(19) and h_frog_open(19) ;   
frog_open(20)<= v_frog_open(20) and h_frog_open(20) ;  

frog_open(21)<= v_frog_open(21) and h_frog_open(21) ;   
frog_open(22)<= v_frog_open(22) and h_frog_open(22) ;   
frog_open(23)<= v_frog_open(23) and h_frog_open(23) ;   
frog_open(24)<= v_frog_open(24) and h_frog_open(24) ;   
frog_open(25)<= v_frog_open(25) and h_frog_open(25) ;  
frog_open(26)<= v_frog_open(26) and h_frog_open(26) ;   
frog_open(27)<= v_frog_open(27) and h_frog_open(27) ;   
frog_open(28)<= v_frog_open(28) and h_frog_open(28) ;   
frog_open(29)<= v_frog_open(29) and h_frog_open(29) ;   
frog_open(30)<= v_frog_open(30) and h_frog_open(30) ;  

frog_open(31)<= v_frog_open(31) and h_frog_open(31) ;   
frog_open(32)<= v_frog_open(32) and h_frog_open(32) ;   
frog_open(33)<= v_frog_open(33) and h_frog_open(33) ;   
frog_open(34)<= v_frog_open(34) and h_frog_open(34) ;   
frog_open(35)<= v_frog_open(35) and h_frog_open(35) ;  
frog_open(36)<= v_frog_open(36) and h_frog_open(36) ;   
frog_open(37)<= v_frog_open(37) and h_frog_open(37) ;   
frog_open(38)<= v_frog_open(38) and h_frog_open(38) ;   
frog_open(39)<= v_frog_open(39) and h_frog_open(39) ;   
frog_open(40)<= v_frog_open(40) and h_frog_open(40) ;  

frog_open(41)<= v_frog_open(41) and h_frog_open(41) ;   
frog_open(42)<= v_frog_open(42) and h_frog_open(42) ;   
frog_open(43)<= v_frog_open(43) and h_frog_open(43) ;   
frog_open(44)<= v_frog_open(44) and h_frog_open(44) ;   
frog_open(45)<= v_frog_open(45) and h_frog_open(45) ;  
frog_open(46)<= v_frog_open(46) and h_frog_open(46) ;   
frog_open(47)<= v_frog_open(47) and h_frog_open(47) ;   
frog_open(48)<= v_frog_open(48) and h_frog_open(48) ;   
frog_open(49)<= v_frog_open(49) and h_frog_open(49) ;   
frog_open(50)<= v_frog_open(50) and h_frog_open(50) ;  

frog_open(51)<= v_frog_open(51) and h_frog_open(51) ;   
frog_open(52)<= v_frog_open(52) and h_frog_open(52) ;   
frog_open(53)<= v_frog_open(53) and h_frog_open(53) ;   
frog_open(54)<= v_frog_open(54) and h_frog_open(54) ;   
frog_open(55)<= v_frog_open(55) and h_frog_open(55) ;  
--frog_open(56)<= v_frog_open(56) and h_frog_open(56) ;   
--frog_open(57)<= v_frog_open(57) and h_frog_open(57) ;   
--frog_open(58)<= v_frog_open(58) and h_frog_open(58) ;   
--frog_open(59)<= v_frog_open(59) and h_frog_open(59) ;   
--frog_open(60)<= v_frog_open(60) and h_frog_open(60) ;
----frog_open(61)<= v_frog_open(61) and h_frog_open(61) ;   
----frog_open(62)<= v_frog_open(62) and h_frog_open(62) ;   
----frog_open(63)<= v_frog_open(63) and h_frog_open(63) ;   
----frog_open(64)<= v_frog_open(64) and h_frog_open(64) ;   
----frog_open(65)<= v_frog_open(65) and h_frog_open(65) ;  
----frog_open(66)<= v_frog_open(66) and h_frog_open(66) ;   
----frog_open(67)<= v_frog_open(67) and h_frog_open(67) ;   
----frog_open(68)<= v_frog_open(68) and h_frog_open(68) ;   
----frog_open(69)<= v_frog_open(69) and h_frog_open(69) ;   
----frog_open(70)<= v_frog_open(70) and h_frog_open(70) ;     
--
--
bullet_open(1)<= v_bullet_open(1) and h_bullet_open(1) ;   
bullet_open(2)<= v_bullet_open(2) and h_bullet_open(2) ;   
bullet_open(3)<= v_bullet_open(3) and h_bullet_open(3) ;   
bullet_open(4)<= v_bullet_open(4) and h_bullet_open(4) ;   
bullet_open(5)<= v_bullet_open(5) and h_bullet_open(5) ;  
bullet_open(6)<= v_bullet_open(6) and h_bullet_open(6) ;   
bullet_open(7)<= v_bullet_open(7) and h_bullet_open(7) ;   
bullet_open(8)<= v_bullet_open(8) and h_bullet_open(8) ;   
bullet_open(9)<= v_bullet_open(9) and h_bullet_open(9) ;   
bullet_open(10)<= v_bullet_open(10) and h_bullet_open(10) ;  

bullet_open(11)<= v_bullet_open(11) and h_bullet_open(11) ;   
bullet_open(12)<= v_bullet_open(12) and h_bullet_open(12) ;   
bullet_open(13)<= v_bullet_open(13) and h_bullet_open(13) ;   
bullet_open(14)<= v_bullet_open(14) and h_bullet_open(14) ;   
bullet_open(15)<= v_bullet_open(15) and h_bullet_open(15) ;  
bullet_open(16)<= v_bullet_open(16) and h_bullet_open(16) ;   
bullet_open(17)<= v_bullet_open(17) and h_bullet_open(17) ;   
bullet_open(18)<= v_bullet_open(18) and h_bullet_open(18) ;   
bullet_open(19)<= v_bullet_open(19) and h_bullet_open(19) ;   
bullet_open(20)<= v_bullet_open(20) and h_bullet_open(20) ; 
 
bullet_open(21)<= v_bullet_open(21) and h_bullet_open(21) ;   
bullet_open(22)<= v_bullet_open(22) and h_bullet_open(22) ;   
bullet_open(23)<= v_bullet_open(23) and h_bullet_open(23) ;   
bullet_open(24)<= v_bullet_open(24) and h_bullet_open(24) ;   
bullet_open(25)<= v_bullet_open(25) and h_bullet_open(25) ;  
bullet_open(26)<= v_bullet_open(26) and h_bullet_open(26) ;   
bullet_open(27)<= v_bullet_open(27) and h_bullet_open(27) ;   
bullet_open(28)<= v_bullet_open(28) and h_bullet_open(28) ;   
bullet_open(29)<= v_bullet_open(29) and h_bullet_open(29) ;   
bullet_open(30)<= v_bullet_open(30) and h_bullet_open(30) ;  

bullet_open(31)<= v_bullet_open(31) and h_bullet_open(31) ;   
bullet_open(32)<= v_bullet_open(32) and h_bullet_open(32) ;   
bullet_open(33)<= v_bullet_open(33) and h_bullet_open(33) ;   
bullet_open(34)<= v_bullet_open(34) and h_bullet_open(34) ;   
bullet_open(35)<= v_bullet_open(35) and h_bullet_open(35) ;  
bullet_open(36)<= v_bullet_open(36) and h_bullet_open(36) ;   
bullet_open(37)<= v_bullet_open(37) and h_bullet_open(37) ;   
bullet_open(38)<= v_bullet_open(38) and h_bullet_open(38) ;   
bullet_open(39)<= v_bullet_open(39) and h_bullet_open(39) ;   
bullet_open(40)<= v_bullet_open(40) and h_bullet_open(40) ;

bullet_open(41)<= v_bullet_open(41) and h_bullet_open(41) ;   
bullet_open(42)<= v_bullet_open(42) and h_bullet_open(42) ;   
bullet_open(43)<= v_bullet_open(43) and h_bullet_open(43) ;   
bullet_open(44)<= v_bullet_open(44) and h_bullet_open(44) ;   
bullet_open(45)<= v_bullet_open(45) and h_bullet_open(45) ;  
bullet_open(46)<= v_bullet_open(46) and h_bullet_open(46) ;   
bullet_open(47)<= v_bullet_open(47) and h_bullet_open(47) ;   
bullet_open(48)<= v_bullet_open(48) and h_bullet_open(48) ;   
bullet_open(49)<= v_bullet_open(49) and h_bullet_open(49) ;   
bullet_open(50)<= v_bullet_open(50) and h_bullet_open(50) ;  

bullet_open(51)<= v_bullet_open(51) and h_bullet_open(51) ;   
bullet_open(52)<= v_bullet_open(52) and h_bullet_open(52) ;   
bullet_open(53)<= v_bullet_open(53) and h_bullet_open(53) ;   
bullet_open(54)<= v_bullet_open(54) and h_bullet_open(54) ;   
bullet_open(55)<= v_bullet_open(55) and h_bullet_open(55) ;  
--bullet_open(56)<= v_bullet_open(56) and h_bullet_open(56) ;   
--bullet_open(57)<= v_bullet_open(57) and h_bullet_open(57) ;   
--bullet_open(58)<= v_bullet_open(58) and h_bullet_open(58) ;   
--bullet_open(59)<= v_bullet_open(59) and h_bullet_open(59) ;   
--bullet_open(60)<= v_bullet_open(60) and h_bullet_open(60) ;
----bullet_open(61)<= v_bullet_open(61) and h_bullet_open(61) ;   
----bullet_open(62)<= v_bullet_open(62) and h_bullet_open(62) ;   
----bullet_open(63)<= v_bullet_open(63) and h_bullet_open(63) ;   
----bullet_open(64)<= v_bullet_open(64) and h_bullet_open(64) ;   
----bullet_open(65)<= v_bullet_open(65) and h_bullet_open(65) ;  
----bullet_open(66)<= v_bullet_open(66) and h_bullet_open(66) ;   
----bullet_open(67)<= v_bullet_open(67) and h_bullet_open(67) ;   
----bullet_open(68)<= v_bullet_open(68) and h_bullet_open(68) ;   
----bullet_open(69)<= v_bullet_open(69) and h_bullet_open(69) ;   
----bullet_open(70)<= v_bullet_open(70) and h_bullet_open(70) ;      



--Sprite: process(clk25)
--begin
--if rising_edge(clk25) then
--
--for i in 127 downto 0 loop
--frog_open(i)<= v_frog_open(i) and h_frog_open(i) ;  
--bullet_open(i)<= v_bullet_open(i) and h_bullet_open(i) ;  
--end loop;
--end if;
--end process Sprite;
-----------------------------------------------------------------


--  FrameHGen : process (clk25)
--  begin
--    if rising_edge(clk25) then
--      if reset = '1'then
--        rectangle_h <= '1';
--      elsif Vcount >= VSYNC + VBACK_PORCH - 1 and 
--            Vcount < VSYNC + VBACK_PORCH - 1 + 6 then
--            if Hcount = HSYNC + HBACK_PORCH + 14 or 
--               Hcount = HSYNC + HBACK_PORCH + 364 then
--               rectangle_h <= '1';
--            elsif Hcount = HSYNC + HBACK_PORCH + 350 or
--                  Hcount = HSYNC + HBACK_PORCH + 626 then
--               rectangle_h <= '0';
--            end if;
--      
--      elsif Vcount >= VSYNC + VBACK_PORCH - 1 + 474 and 
--            Vcount < VSYNC + VBACK_PORCH - 1 + 480 then
--            if Hcount = HSYNC + HBACK_PORCH + 14 or
--               Hcount = HSYNC + HBACK_PORCH + 364 then
--               rectangle_h <= '1';
--            elsif Hcount = HSYNC + HBACK_PORCH + 350 or 
--                  Hcount = HSYNC + HBACK_PORCH + 626 then
--               rectangle_h <= '0';        
--            end if;
--
--      elsif Vcount >= VSYNC + VBACK_PORCH - 1 + 6 and 
--            Vcount < VSYNC + VBACK_PORCH - 1 + 474 then
--            if Hcount = HSYNC + HBACK_PORCH + 14 or 
--               Hcount = HSYNC + HBACK_PORCH + 344 or 
--               Hcount = HSYNC + HBACK_PORCH + 364 or
--               Hcount = HSYNC + HBACK_PORCH + 620 then
--               rectangle_h <= '1';
--            elsif Hcount = HSYNC + HBACK_PORCH + 20 or 
--                  Hcount = HSYNC + HBACK_PORCH + 350 or
--                  Hcount = HSYNC + HBACK_PORCH + 370 or
--                  Hcount = HSYNC + HBACK_PORCH + 626 then
--               rectangle_h <= '0';
--            end if;
--
--      end if;
--    end if;
--  end process FrameHGen;
--
--
--
--  FrameVGen : process (clk25)
--  begin
--    if rising_edge(clk25) then
--      if reset = '1' then       
--        rectangle_v <= '0';
--      elsif EndOfLine = '1' then
--        if Vcount = VSYNC + VBACK_PORCH - 1  then
--          rectangle_v <= '1';
--        elsif Vcount = VSYNC + VBACK_PORCH - 1 + 480 then
--          rectangle_v <= '0';
--        end if;
--      end if;      
--    end if;
--  end process FrameVGen;
--
--  rectangle <= rectangle_h and rectangle_v;





  CursorHGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
         cursor_h <= '0';
      elsif Vcount >= VSYNC + VBACK_PORCH - 1 + v_cursor -18 and 
            Vcount < VSYNC + VBACK_PORCH - 1 + v_cursor-18+2 then
         if Hcount = HSYNC + HBACK_PORCH + h_cursor -18 then 
            cursor_h <= '1';
         elsif Hcount = HSYNC + HBACK_PORCH + h_cursor+18 then 
            cursor_h <= '0';
         end if;
      elsif Vcount >= VSYNC + VBACK_PORCH - 1 + v_cursor+18-2 and 
            Vcount < VSYNC + VBACK_PORCH - 1 + v_cursor+18 then
         if Hcount = HSYNC + HBACK_PORCH + h_cursor-18 then 
            cursor_h <= '1';
         elsif Hcount = HSYNC + HBACK_PORCH + h_cursor +18 then 
            cursor_h <= '0';
         end if;
      elsif Vcount >= VSYNC + VBACK_PORCH - 1 + v_cursor-18+2 and 
            Vcount < VSYNC + VBACK_PORCH - 1 + v_cursor+18-2 then
            if Hcount = HSYNC + HBACK_PORCH + h_cursor -18 or 
               Hcount = HSYNC + HBACK_PORCH + h_cursor +18-2 then
               cursor_h <= '1';
            elsif Hcount = HSYNC + HBACK_PORCH + h_cursor -18+2 or 
                  Hcount = HSYNC + HBACK_PORCH + h_cursor +18 then
               cursor_h <= '0';
            end if;      
      end if;
    end if;
 end process CursorHGen;

  CursorVGen : process (clk)
  begin
    if rising_edge(clk) then
       if reset = '1' then       
          cursor_v <= '0';
       elsif Vcount = VSYNC + VBACK_PORCH - 1  then
          cursor_v <= '1';
       elsif Vcount = VSYNC + VBACK_PORCH - 1 + 480 then
          cursor_v <= '0';
       end if;      
    end if;
  end process CursorVGen;------------------

  cursor_open <= cursor_h and cursor_v;
  -- Registered video signals going to the video DAC
---------------------------------------display the map------------------------




 





 VideoOut: process (clk25, reset)
  begin
    if reset = '1' then
      VGA_R <= "0000000000";
      VGA_G <= "0000000000";
      VGA_B <= "0000000000";
elsif clk25'event and clk25 = '1' then 




if vga_hblank = '0' and vga_vblank ='0' then

        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";
      else
       VGA_R <= "0000000000";
       VGA_G <= "0000000000";
        VGA_B <= "0000000000"; 

  
end if; 
--  if lable_flag1 = '1' then 
--  if lable_open1 = '1' then   ---lable
--    image_address <= address(10 downto 5);
--    VGA_R(4 downto 0) <= "11111";
--    VGA_G(4 downto 0) <= "11111";
--    VGA_B(4 downto 0) <= "11111";
--test1 <=  to_integer(Vcount - lable_vstart1-6) -VSYNC - VBACK_PORCH;
--test2 <=  to_integer(Hcount - lable_hstart1+1) -HSYNC - HBACK_PORCH;
--    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
--end if;
--if ps_flag1 = '1' then  ----press enter
--Vnumber  <= to_integer(Vcount) - VBACK_PORCH - VSYNC;
--Hnumber <=  to_integer(Hcount) - HBACK_PORCH  - HSYNC;
--if Vnumber >= 210 and Vnumber < 226 and Hnumber >= 210 and Hnumber < 298 then
--ps_horizontal <= Hnumber mod 8;
--ps_vertical <= (Vnumber - 210) mod 16;
--ps_address <= word_map1((Hnumber-210)/8);
--    VGA_R(9 downto 5) <= unsigned(ps_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(ps_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(ps_B(4 downto 0));
--end if;
--elsif ps_flag2 = '1' then  ---button explain
--Vnumber  <= to_integer(Vcount) - VBACK_PORCH - VSYNC;
--Hnumber <=  to_integer(Hcount) - HBACK_PORCH  - HSYNC;
--if Vnumber >= 400 and Vnumber < 464 and Hnumber >= 400 and Hnumber < 536 then
--ps_horizontal <= Hnumber mod 8;
--ps_vertical <= (Vnumber - 400) mod 16;
--ps_address <= word_map2((Vnumber - 400)/16, (Hnumber - 400)/8);
--    VGA_R(9 downto 5) <= unsigned(ps_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(ps_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(ps_B(4 downto 0));
--end if;
--
--end if;
--else



for i in 0 to 60 loop
---------------------------------------display the map------------------------


    
 
if cursor_open = '1' then 
        VGA_R <= "1111111111";
        VGA_G <= "1111111111";
        VGA_B <= "1111111111";
elsif frog_open(i) = '1' then 
    VGA_R(4 downto 0) <= "11111";
    VGA_G(4 downto 0) <= "11111";
    VGA_B(4 downto 0) <= "11111";
test1 <=  to_integer(Vcount - frog_v(i)-7) -VSYNC - VBACK_PORCH;
test2 <=  to_integer(Hcount - frog_h(i)) -HSYNC - HBACK_PORCH;
image_address <= figure_type(i);
if figure_type(i) = "001011" then                                     --green_big
if frog_stage3 = 0 then
    
    
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "001100";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
elsif figure_type(i) = "001001" then                                --green_small
--    
 if frog_stage3 = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else
    image_address <= "001010";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
 elsif figure_type(i) = "001111" then                               --red_big

 if frog_stage2 = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "010000";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
    end if;
elsif figure_type(i) = "001101" then                            --red small

 if frog_stage2 = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
    image_address <= "001110";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
  elsif figure_type(i) = "000011" then                        --blue big
 if frog_stage1 = 0 then

    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "000100";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
elsif figure_type(i) = "000001" then                       --blue small
if frog_stage1 = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "000010";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
   elsif figure_type(i) = "000111" then                  --orange big
if frog_stage = 0 then
    
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "001000";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
   elsif figure_type(i) = "000101" then                   --orange small
if frog_stage = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
else 
      image_address <= "000110";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;
-------------------------------------button--------------------------------------
elsif figure_type(i) = "011000" then                             --start
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011001" then                             --pause
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011010" then                             --next
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011011" then                             --back
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
----------------------------------------explode-------------------------------------
elsif figure_type(i) = "010101" then 
if explode_stage = 0 then
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
 elsif  explode_stage = 1 then
      image_address <= "010110";
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
   elsif  explode_stage = 2 then
    VGA_R(9 downto 0) <= "0000000000";
    VGA_G(9 downto 0) <= "0000000000";
    VGA_B(9 downto 0) <= "0000000000";
--    VGA_R(9 downto 2) <= unsigned(map_black(to_integer(Vcount -frog_v(i) -6) - (VSYNC + VBACK_PORCH +2))(to_integer(Hcount-frog_h(i) )- (HSYNC + HBACK_PORCH )));
--    VGA_G(9 downto 2) <= unsigned(map_black(to_integer(Vcount -frog_v(i) -6) - (VSYNC + VBACK_PORCH +2))(to_integer(Hcount-frog_h(i) )- (HSYNC + HBACK_PORCH )));
--    VGA_B(9 downto 2) <= unsigned(map_black(to_integer(Vcount -frog_v(i) -6) - (VSYNC + VBACK_PORCH +2))(to_integer(Hcount-frog_h(i) )- (HSYNC + HBACK_PORCH )));
end if;
----------------------------------------------------arrow back 0-9-------------
elsif figure_type(i) = "011101" then ---lv
 
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011110" then ---hit
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011100" then ---arrow
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "011111" then --0
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100000" then --1
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100001" then --2
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100010" then --3
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100011" then --4
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100100" then --5
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100101" then --6
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100110" then --7
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "100111" then --8
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
elsif figure_type(i) = "101000" then --9
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));

--elsif figure_type(i) = "101001" then --Snappers
--    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
--elsif figure_type(i) = "101010" then --Try_Again
--    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
--elsif figure_type(i) = "101011" then --Good_Job
--    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
end if;




------------------------------------------------------------------------------------ 

elsif bullet_open(i) = '1' then
test1 <=  to_integer(Vcount - bullet_v(i)-6 - 1 ) -VSYNC - VBACK_PORCH;
test2 <=  to_integer(Hcount - bullet_h(i) +2 ) -HSYNC - HBACK_PORCH;
image_address <= figure_type(i);

if figure_type(i) = "010001" then                 --bullet up
    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));

elsif figure_type(i) = "010010" then             --bullet down

    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));


elsif figure_type(i) = "010011" then            --bullet left

    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));

elsif figure_type(i) = "010100" then             --bullet right

    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));




end if;
--end if;
--elsif background_open = '1' then 
--
--
--Vnumber  <= to_integer(Vcount) - VBACK_PORCH - VSYNC;
--Hnumber <=  to_integer(Hcount) - HBACK_PORCH  - HSYNC;
--test2 <= Hnumber mod 36;
--test1 <= (Vnumber - 480) mod 36;
--image_address <= groundmap((Vnumber)/36, (Hnumber)/36);
--    VGA_R(4 downto 0) <= "11111";
--    VGA_G(4 downto 0) <= "11111";
--    VGA_B(4 downto 0) <= "11111";
--        VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--        VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--        VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));




  
--end if; 

end if; 
      end loop;
--  if lable_flag1 = '1' then 
--  if lable_open1 = '1' then   ---lable
--    image_address <= address(10 downto 5);
--    VGA_R(4 downto 0) <= "11111";
--    VGA_G(4 downto 0) <= "11111";
--    VGA_B(4 downto 0) <= "11111";
--test1 <=  to_integer(Vcount - lable_vstart1-6) -VSYNC - VBACK_PORCH;
--test2 <=  to_integer(Hcount - lable_hstart1+1) -HSYNC - HBACK_PORCH;
--    VGA_R(9 downto 5) <= unsigned(frog_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(frog_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(frog_B(4 downto 0));
--end if;
--elsif ps_flag1 = '1' then  ----press enter
--Vnumber  <= to_integer(Vcount) - VBACK_PORCH - VSYNC;
--Hnumber <=  to_integer(Hcount) - HBACK_PORCH  - HSYNC;
--if Vnumber >= 210 and Vnumber < 226 and Hnumber >= 210 and Hnumber < 298 then
--ps_horizontal <= Hnumber mod 8;
--ps_vertical <= (Vnumber - 210) mod 16;
--ps_address <= word_map1((Hnumber-210)/8);
--    VGA_R(9 downto 5) <= unsigned(ps_R(4 downto 0));
--    VGA_G(9 downto 5) <= unsigned(ps_G(4 downto 0));
--    VGA_B(9 downto 5) <= unsigned(ps_B(4 downto 0));
--end if;
if ps_flag2 = '1' then  ---button explain
Vnumber  <= to_integer(Vcount) - VBACK_PORCH - VSYNC;
Hnumber <=  to_integer(Hcount) - HBACK_PORCH  - HSYNC;
if Vnumber >= 400 and Vnumber < 464 and Hnumber >= 400 and Hnumber < 536 then
ps_horizontal <= Hnumber mod 8;
ps_vertical <= (Vnumber - 400) mod 16;
ps_address <= word_map2((Vnumber - 400)/16, (Hnumber - 400)/8);
    VGA_R(9 downto 5) <= unsigned(ps_R(4 downto 0));
    VGA_G(9 downto 5) <= unsigned(ps_G(4 downto 0));
    VGA_B(9 downto 5) <= unsigned(ps_B(4 downto 0));
end if;

end if;
--      end if;
--
      end if;

  end process VideoOut;

  VGA_CLK <= clk25;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
