library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_audio is
  
  port (
    clk        : in  std_logic;
    reset_n    : in  std_logic;
    read       : in  std_logic;
    write      : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(4 downto 0);
    readdata   : out unsigned(15 downto 0);
    writedata  : in  unsigned(15 downto 0);

    AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
	AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
	AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
	AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
	AUD_BCLK     : inout std_logic );
  
end de2_audio;

architecture rtl of de2_audio is
  component de2_wm8731_audio
    port(
			clk       : in std_logic;       --  Audio CODEC Chip Clock AUD_XCK (18.43 MHz)
			reset_n   : in std_logic;
			test_mode : in std_logic;       --    Audio CODEC controller test mode
			audio_request : out std_logic;  --    Audio controller request new data
			data      : in unsigned(15 downto 0);
			pitch     : in unsigned(7 downto 0);  
            tone      : in unsigned(1 downto 0);
			AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
			AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
			AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
			AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
			AUD_BCLK     : inout std_logic      );
  end component;

  signal audio_pitch : unsigned(7 downto 0);
  signal audio_tone  : unsigned(1 downto 0);
--  signal pitch : unsigned(7 downto 0);
--  signal tone  : unsigned(1 downto 0);
  signal audio_request: std_logic;


begin



  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        readdata <= (others => '0');  
      else
        if chipselect = '1' then
          if read = '1' then
            readdata(7 downto 0) <= audio_pitch;
            readdata(9 downto 8) <= audio_tone;
--            pitch <= audio_pitch;
--            tone  <= audio_tone;
		  elsif write = '1' then
            audio_pitch <= writedata(7 downto 0);
            audio_tone  <= writedata(9 downto 8);
          end if;
        end if;
      end if;
    end if;
  end process;

V3: de2_wm8731_audio port map(
    clk => clk,
    reset_n => reset_n,
    test_mode => '1',
    audio_request => audio_request,
    data => "0000000000000000",
    pitch => audio_pitch,
    tone => audio_tone,
    AUD_ADCLRCK => AUD_ADCLRCK,
    AUD_ADCDAT => AUD_ADCDAT,
    AUD_DACLRCK => AUD_DACLRCK,
    AUD_DACDAT => AUD_DACDAT,
    AUD_BCLK => AUD_BCLK);

end rtl;
