library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity zero_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end zero_rom;
architecture rom of zero_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"D",X"D",X"D",X"D",X"D",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"D",X"A",X"6",X"6",X"6",X"A",X"6",X"6",X"6",X"A",X"D",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"D",X"A",X"6",X"6",X"6",X"6",X"6",X"A",X"6",X"6",X"2",X"6",X"6",X"A",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"A",X"6",X"A",X"A",X"A",X"D",X"D",X"F",X"F",X"F",X"D",X"A",X"6",X"6",X"6",X"D",X"F",X"F",X"F"),
(X"F",X"F",X"D",X"6",X"6",X"A",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"C",X"C",X"C",X"C",X"F",X"F",X"F"),
(X"F",X"F",X"B",X"B",X"B",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"D",X"4",X"4",X"4",X"D",X"F",X"F"),
(X"F",X"F",X"B",X"8",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"7",X"0",X"0",X"0",X"D",X"F",X"F"),
(X"F",X"F",X"B",X"8",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"5",X"2",X"3",X"3",X"F",X"F",X"F"),
(X"F",X"F",X"7",X"4",X"7",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"9",X"9",X"B",X"6",X"A",X"F",X"F",X"F"),
(X"F",X"F",X"4",X"1",X"1",X"7",X"F",X"F",X"F",X"D",X"F",X"D",X"B",X"9",X"9",X"5",X"B",X"6",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"D",X"1",X"1",X"7",X"C",X"4",X"4",X"4",X"7",X"C",X"9",X"1",X"9",X"9",X"B",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"D",X"0",X"7",X"C",X"4",X"4",X"0",X"7",X"C",X"9",X"9",X"9",X"E",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"D",X"D",X"D",X"7",X"7",X"7",X"C",X"D",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F")


);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
