library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity two_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end two_rom;
architecture rom of two_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"D",X"5",X"4",X"5",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"9",X"4",X"1",X"1",X"4",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"B",X"B",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"9",X"6",X"9",X"6",X"6",X"6",X"D",X"F",X"F",X"F",X"F",X"D",X"4",X"1",X"0",X"4",X"F",X"F",X"F"),
(X"F",X"F",X"E",X"A",X"A",X"9",X"9",X"D",X"D",X"F",X"F",X"F",X"D",X"9",X"6",X"1",X"0",X"0",X"4",X"F",X"F",X"F"),
(X"F",X"F",X"E",X"3",X"3",X"A",X"D",X"F",X"F",X"F",X"F",X"B",X"6",X"6",X"4",X"6",X"4",X"1",X"1",X"F",X"F",X"F"),
(X"F",X"F",X"B",X"0",X"2",X"7",X"C",X"F",X"F",X"F",X"9",X"6",X"9",X"1",X"0",X"5",X"9",X"6",X"6",X"F",X"F",X"F"),
(X"F",X"F",X"D",X"0",X"2",X"7",X"7",X"A",X"A",X"9",X"6",X"6",X"9",X"4",X"0",X"4",X"8",X"6",X"9",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"1",X"3",X"7",X"A",X"7",X"3",X"6",X"4",X"1",X"4",X"6",X"9",X"9",X"9",X"6",X"9",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"D",X"7",X"A",X"C",X"7",X"8",X"1",X"0",X"1",X"5",X"F",X"F",X"B",X"5",X"4",X"6",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"E",X"A",X"7",X"8",X"9",X"9",X"B",X"D",X"F",X"F",X"F",X"5",X"0",X"2",X"1",X"D",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"8",X"7",X"7",X"A",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"C",X"7",X"7",X"7",X"E",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"C",X"C",X"E",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F")

);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
