library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity three_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end three_rom;
architecture rom of three_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E"),
(X"E",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E"),
(X"F",X"F",X"F",X"F",X"D",X"B",X"B",X"E",X"F",X"E",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"E",X"F",X"F"),
(X"E",X"F",X"F",X"C",X"3",X"2",X"8",X"C",X"F",X"E",X"F",X"F",X"E",X"F",X"F",X"E",X"F",X"F",X"E",X"F",X"F",X"E"),
(X"E",X"F",X"C",X"3",X"3",X"9",X"C",X"D",X"F",X"B",X"9",X"B",X"F",X"E",X"F",X"F",X"7",X"7",X"7",X"C",X"F",X"E"),
(X"E",X"F",X"B",X"3",X"3",X"C",X"F",X"E",X"F",X"9",X"2",X"9",X"F",X"F",X"F",X"E",X"2",X"1",X"1",X"9",X"F",X"E"),
(X"E",X"F",X"9",X"2",X"3",X"B",X"F",X"F",X"C",X"3",X"3",X"8",X"D",X"F",X"F",X"F",X"6",X"6",X"6",X"D",X"F",X"F"),
(X"F",X"F",X"B",X"9",X"9",X"9",X"C",X"C",X"9",X"3",X"2",X"8",X"9",X"D",X"D",X"B",X"5",X"5",X"5",X"D",X"F",X"E"),
(X"E",X"F",X"D",X"7",X"7",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"A",X"B",X"E",X"F",X"F"),
(X"F",X"E",X"F",X"2",X"0",X"0",X"1",X"1",X"1",X"3",X"9",X"1",X"2",X"2",X"2",X"4",X"4",X"4",X"D",X"F",X"E",X"F"),
(X"E",X"F",X"F",X"D",X"9",X"3",X"3",X"3",X"3",X"C",X"F",X"3",X"1",X"1",X"0",X"0",X"0",X"8",X"F",X"E",X"F",X"E"),
(X"F",X"E",X"E",X"E",X"F",X"E",X"D",X"E",X"F",X"F",X"E",X"F",X"D",X"B",X"9",X"B",X"E",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"E",X"E",X"E",X"F",X"F",X"F",X"E",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"E",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"E",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"E",X"F",X"E")


);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
