library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity six_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end six_rom;
architecture rom of six_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"F",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"E",X"E",X"D",X"A",X"8",X"2",X"7",X"7",X"B",X"B",X"D",X"D",X"D",X"E",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"E",X"C",X"6",X"1",X"8",X"0",X"2",X"7",X"7",X"B",X"4",X"4",X"B",X"D",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"B",X"C",X"7",X"1",X"A",X"8",X"0",X"4",X"B",X"B",X"3",X"4",X"B",X"5",X"D",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"B",X"A",X"A",X"B",X"B",X"B",X"B",X"A",X"A",X"B",X"B",X"B",X"D",X"5",X"5",X"B",X"E",X"E",X"E"),
(X"E",X"E",X"D",X"D",X"3",X"4",X"B",X"B",X"B",X"B",X"B",X"B",X"D",X"E",X"E",X"E",X"D",X"A",X"A",X"E",X"E",X"E"),
(X"F",X"E",X"5",X"5",X"B",X"B",X"D",X"E",X"E",X"B",X"B",X"B",X"E",X"E",X"E",X"E",X"E",X"D",X"B",X"D",X"E",X"E"),
(X"F",X"E",X"7",X"3",X"B",X"E",X"E",X"E",X"E",X"B",X"B",X"D",X"E",X"E",X"E",X"E",X"E",X"D",X"B",X"D",X"E",X"E"),
(X"E",X"E",X"9",X"9",X"B",X"D",X"E",X"E",X"E",X"B",X"B",X"A",X"D",X"E",X"E",X"E",X"E",X"B",X"B",X"E",X"E",X"E"),
(X"E",X"E",X"A",X"3",X"B",X"B",X"D",X"E",X"E",X"A",X"2",X"0",X"0",X"8",X"A",X"8",X"3",X"B",X"B",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"D",X"B",X"B",X"D",X"E",X"E",X"4",X"0",X"2",X"8",X"3",X"8",X"2",X"0",X"2",X"D",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"D",X"D",X"E",X"E",X"E",X"E",X"8",X"3",X"0",X"0",X"0",X"8",X"2",X"4",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"A",X"9",X"C",X"6",X"8",X"E",X"E",X"E",X"E",X"E",X"E"),
(X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"F",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E",X"E")


);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
